/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.extractrptdata.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorResultProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.CSLPropertyAdapter;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.excel.json.JSONUtils;
import com.kingdee.eas.fi.newrpt.extractrptdata.WSCalcFormulaErrorEnum;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.fi.newrpt.report.VariablesHelper;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FormulasCalcForWebServiceHandle {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.extractrptdata.FormulaInterface");
    private Book book = null;
    private Context ctx = null;
    private ReportVariables reportVariables = new ReportVariables();

    public FormulasCalcForWebServiceHandle(Context ctx) {
        this.ctx = ctx;
    }

    public List calcFormulaValues(List<Map> calcParams) {
        String json;
        boolean isOnlyFillHavingDataItem = false;
        try {
            isOnlyFillHavingDataItem = CslRptUtil.getCslParam((Context)this.ctx, (String)"easToCqJson");
            if (isOnlyFillHavingDataItem) {
                json = JSONUtils.convertObjectToJson(calcParams);
                logger.error((Object)("formula calcParams json \n" + json));
            }
        }
        catch (Exception e) {
            logger.error((Object)"get param error \n");
        }
        for (Map calcParam : calcParams) {
            try {
                if (calcParam == null) {
                    calcParam.put("error", WSCalcFormulaErrorEnum.paramNull.getAlias());
                    continue;
                }
                Map bookFormulas = (Map)calcParam.get("bookformulas");
                if (bookFormulas == null || bookFormulas.size() == 0) {
                    calcParam.put("error", WSCalcFormulaErrorEnum.formulasNull.getAlias());
                    continue;
                }
                OrgTreeInfo orgTreeInfo = null;
                String currencyNum = (String)calcParam.get("currencynum");
                CurrencyInfo currency = null;
                if (currencyNum == null || currencyNum.length() == 0) {
                    calcParam.put("error", WSCalcFormulaErrorEnum.currencyNull.getAlias());
                } else {
                    try {
                        currency = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyCollection("select * where number='" + currencyNum + "'").get(0);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (currency == null) {
                    calcParam.put("error", WSCalcFormulaErrorEnum.currencyNull.getAlias());
                    logger.error((Object)("calc web service Famula calc param error currency:" + currencyNum));
                    continue;
                }
                if (calcParam.get("year") == null) {
                    calcParam.put("error", WSCalcFormulaErrorEnum.yearNull.getAlias());
                    continue;
                }
                int year = Integer.valueOf(calcParam.get("year").toString());
                if (calcParam.get("period") == null) {
                    calcParam.put("error", WSCalcFormulaErrorEnum.periodNull.getAlias());
                    continue;
                }
                short period = Short.valueOf(calcParam.get("period").toString());
                RptPeriodTypeEnum periodType = RptPeriodTypeEnum.MONTHLY;
                if (calcParam.get("periodtype") != null) {
                    periodType = RptPeriodTypeEnum.getEnum((String)((String)calcParam.get("periodtype")));
                }
                String companyNum = (String)calcParam.get("companynum");
                FullOrgUnitInfo orgUnitInfo = null;
                if (companyNum == null || companyNum.length() == 0) {
                    calcParam.put("error", WSCalcFormulaErrorEnum.companyNull.getAlias());
                } else {
                    try {
                        orgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)this.ctx).getFullOrgUnitInfo("select * where number='" + companyNum + "'");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (orgUnitInfo == null) {
                    logger.error((Object)("calc web service Famula calc param error companyNum:" + companyNum));
                    continue;
                }
                OrgType orgType = null;
                String orgTypeStr = (String)calcParam.get("orgtype");
                orgType = orgTypeStr == null || orgTypeStr.length() == 0 ? OrgType.Company : OrgType.getEnum((String)orgTypeStr);
                Set sheetFormulaKeys = bookFormulas.keySet();
                for (String sheetKey : sheetFormulaKeys) {
                    Map sheetFormulas = (Map)bookFormulas.get(sheetKey);
                    this.initBook(this.ctx, orgType, (OrgUnitInfo)orgUnitInfo, orgTreeInfo, year, period, periodType, currency, sheetFormulas);
                    Map formulas = (Map)sheetFormulas.get("formulas");
                    if (formulas == null) continue;
                    Set formulaKeys = formulas.keySet();
                    int index = 0;
                    Sheet sheet = new Sheet(this.book, sheetKey);
                    this.book.addSheet(sheet);
                    for (String formulaKey : formulaKeys) {
                        String formula = (String)formulas.get(formulaKey);
                        Cell cell = sheet.getCell(index, 0, true);
                        cell.setUserObject("key", (Object)formulaKey);
                        if (!formula.startsWith("=")) {
                            formula = "=" + formula;
                        }
                        cell.setFormula(formula);
                        ++index;
                    }
                }
                this.setCalcValues(bookFormulas);
            }
            catch (Exception e) {
                calcParam.put("error", e.getMessage());
                logger.error((Object)"ws calc error", (Throwable)e);
            }
        }
        try {
            if (isOnlyFillHavingDataItem) {
                json = JSONUtils.convertObjectToJson(calcParams);
                logger.error((Object)("formula return \n" + json));
            }
        }
        catch (Exception e) {
            logger.error((Object)"formula return logger error \n");
        }
        return calcParams;
    }

    private void initReportVariables(Map sheetParam) {
        Set keySet = sheetParam.keySet();
        for (String key : keySet) {
            if ("formulas".equals(key)) continue;
            String value = (String)sheetParam.get(key);
            int valueType = 3;
            if ("true".equals(value) || "year".equals(value)) {
                valueType = 1;
            }
            VariableEntry ve = VariablesHelper.createReservedEntry(key, null, "Sheet1", value, valueType);
            this.reportVariables.add(ve);
        }
    }

    private void initBook(final Context ctx, final OrgType orgType, final OrgUnitInfo orgUnitInfo, final OrgTreeInfo orgTreeInfo, final int year, final short period, final RptPeriodTypeEnum periodType, final CurrencyInfo currency, Map<String, Object> sheetCalcParam) throws Exception {
        if (this.book == null) {
            this.book = Book.Manager.getNewBook(null, (int)0);
            this.book.setCalculate(false);
            FormulaDefinition.registerFormulaToBook(this.book, new ICalculateContextProvider(){
                private static final long serialVersionUID = 2342600610859269292L;

                public IErrorProvider getErrorProvider() {
                    return null;
                }

                public IErrorResultProvider getErrorResultProvider() {
                    return null;
                }

                public IReportPropertyAdapter getReportAdapter() {
                    CslReportInfo cslReport = new CslReportInfo();
                    cslReport.setOrgTree(orgTreeInfo);
                    cslReport.setOrgUnit(orgUnitInfo);
                    cslReport.setCompany(orgUnitInfo);
                    cslReport.setYear(year);
                    cslReport.setPeriod(period);
                    cslReport.setPeriodType(periodType);
                    cslReport.setCurrency(currency);
                    cslReport.setSourceType(RptSrcTypeEnum.COMMITREPORT);
                    cslReport.setOrgType(orgType);
                    CSLPropertyAdapter adapter = new CSLPropertyAdapter(cslReport, ctx);
                    return adapter;
                }

                public ReportVariables getReportVariables() {
                    return FormulasCalcForWebServiceHandle.this.reportVariables;
                }

                public Context getServerContext() {
                    return ctx;
                }
            });
        }
        this.initReportVariables(sheetCalcParam);
    }

    private void setCalcValues(Map<String, Object> bookFormulas) {
        this.book.calc();
        for (int i = 0; i < this.book.getSheetCount(); ++i) {
            Sheet sheet = this.book.getSheet(i);
            String sheetKey = sheet.getSheetName();
            Map sheetFormulas = (Map)bookFormulas.get(sheetKey);
            Map formulas = (Map)sheetFormulas.get("formulas");
            HashMap values = new HashMap();
            int size = formulas.size();
            Cell cell = null;
            for (int j = 0; j < size; ++j) {
                cell = sheet.getCell(j, 0, true);
                String key = (String)cell.getUserObjectValue("key");
                Object cellValue = cell.getValue() == null ? null : cell.getValue().getValue();
                HashMap<String, Object> value = new HashMap<String, Object>();
                if (cellValue instanceof BigDecimal || cellValue instanceof Integer) {
                    value.put("1", cellValue);
                } else if (cellValue instanceof String) {
                    value.put("2", cellValue);
                } else if (cellValue instanceof Exception) {
                    String vStr = cellValue.toString().replace(":", " ");
                    value.put("-1", vStr);
                }
                values.put(key, value);
            }
            sheetFormulas.put("formulas", values);
        }
    }
}

