/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.formulasolu;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.UserObject;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynaRptBasePointIndexHandle;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.newrpt.formulasolu.AbstractFormulaSoluInfo;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluFactory;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluInfo;
import com.kingdee.eas.fi.newrpt.formulasolu.IFormulaSolu;
import com.kingdee.eas.fi.newrpt.formulasolu.IReportUseFormulaSolu;
import com.kingdee.eas.fi.newrpt.formulasolu.ReportUseFormulaSoluFactory;
import com.kingdee.eas.fi.newrpt.formulasolu.ReportUseFormulaSoluInfo;
import com.kingdee.eas.fi.rpt.ITemplate;
import com.kingdee.eas.fi.rpt.RptCheckExpTank;
import com.kingdee.eas.fi.rpt.RptCheckExpression;
import com.kingdee.eas.fi.rpt.RptOperationSchemaComp;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.TemplateSourceEnum;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.fi.rpt.util.RptUtilForServer;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class FormulaSoluCalcHelp {
    private static final Logger logger = CoreUIObject.getLogger(FormulaSoluCalcHelp.class);
    private Context ctx = null;
    public static final String LEFT_UP_VALUE = "1";
    public static final String RIGHT_DOWN_VALUE = "2";

    public static FormulaSoluCalcHelp getInstance() {
        return new FormulaSoluCalcHelp();
    }

    public FormulaSoluInfo preRptDataFormulaSolu(byte[] zippedData, OrgUnitInfo orgUnit, TemplateInfo tameplate) {
        byte[] data = null;
        AbstractFormulaSoluInfo formulaSoluInfo = null;
        try {
            Book book = IOHelper.unpackBook((byte[])zippedData);
            formulaSoluInfo = this.preBookFormulaSolu(book, orgUnit, tameplate);
            if (((FormulaSoluInfo)formulaSoluInfo).getReportBook() == null) {
                formulaSoluInfo.setData(zippedData);
                ((FormulaSoluInfo)formulaSoluInfo).setReportData(zippedData);
                return formulaSoluInfo;
            }
            data = IOHelper.packBook((Book)((FormulaSoluInfo)formulaSoluInfo).getReportBook());
        }
        catch (Exception e) {
            formulaSoluInfo.setData(zippedData);
            ((FormulaSoluInfo)formulaSoluInfo).setReportData(zippedData);
            return formulaSoluInfo;
        }
        formulaSoluInfo.setData(data);
        ((FormulaSoluInfo)formulaSoluInfo).setReportData(data);
        return formulaSoluInfo;
    }

    public FormulaSoluInfo preRptDataFormulaSoluForServer(Context ctx, byte[] zippedData, OrgUnitInfo orgUnit, TemplateInfo tameplate) {
        this.ctx = ctx;
        return this.preRptDataFormulaSolu(zippedData, orgUnit, tameplate);
    }

    public FormulaSoluInfo preTemplateBookFormulaSolu(Book tempBook, OrgUnitInfo orgUnit, TemplateInfo tameplate) {
        FormulaSoluInfo formulaSoluInfo = this.preBookFormulaSolu(RptUtilForClient.LockBookExpTank((Book)tempBook), orgUnit, tameplate);
        if (formulaSoluInfo.getReportBook() == null) {
            formulaSoluInfo.setReportBook(RptUtilForClient.LockBookExpTank((Book)tempBook));
        }
        return formulaSoluInfo;
    }

    public FormulaSoluInfo preTemplateBookFormulaSoluForServer(Context ctx, Book tempBook, OrgUnitInfo orgUnit, TemplateInfo tameplate) {
        this.ctx = ctx;
        FormulaSoluInfo formulaSoluInfo = this.preBookFormulaSolu(RptUtilForServer.LockBookExpTank((Book)tempBook), orgUnit, tameplate);
        if (formulaSoluInfo.getReportBook() == null) {
            formulaSoluInfo.setReportBook(RptUtilForServer.LockBookExpTank((Book)tempBook));
        }
        return formulaSoluInfo;
    }

    private IFormulaSolu getFormulaSoluBizInterface() throws Exception {
        return this.ctx == null ? FormulaSoluFactory.getRemoteInstance() : FormulaSoluFactory.getLocalInstance(this.ctx);
    }

    private ITemplate getTemplateBizInterface() throws Exception {
        return this.ctx == null ? TemplateFactory.getRemoteInstance() : TemplateFactory.getLocalInstance((Context)this.ctx);
    }

    private boolean isDynaReport(Book book, TemplateInfo temaplate, Sheet sheet) {
        boolean flag = false;
        if (RptTmpTypeEnum.DYNAMICNORMALREPORT.equals((Object)temaplate.getTemplateType()) || RptTmpTypeEnum.MULTIDYNAMICCSLREPORT.equals((Object)temaplate.getTemplateType()) || RptTmpTypeEnum.RPTDYNAMICREPORT.equals((Object)temaplate.getTemplateType()) || RptTmpTypeEnum.MULTIRPTDYNAMICREPORT.equals((Object)temaplate.getTemplateType())) {
            flag = true;
        }
        return flag;
    }

    protected ReportVariables getVariables(Book book) {
        ReportVariables v = ReportVariables.loadFromBook((Book)book);
        if (v == null) {
            v = new ReportVariables();
            v.storeToBook(book);
        }
        return v;
    }

    protected int getSheetType(Book book, Sheet sheet) {
        int reportClass = this.getVariables(book).getIntValue("SheetClass", sheet.getSheetName(), 1);
        return reportClass;
    }

    public void saveReportUseFormula(String reportId, String formulaSoluId, byte[] formulaSoulData) {
        try {
            ReportUseFormulaSoluInfo info = new ReportUseFormulaSoluInfo();
            info.setReport(reportId);
            info.setFormulaSolu(formulaSoluId);
            info.setData(formulaSoulData);
            IReportUseFormulaSolu reportUserFormulaSolu = ReportUseFormulaSoluFactory.getRemoteInstance();
            reportUserFormulaSolu.addnew(info);
        }
        catch (Exception e) {
            logger.error((Object)"save Report Use Formula error", (Throwable)e);
        }
    }

    public boolean isUseFormulaSolu(String reportId) {
        try {
            return ReportUseFormulaSoluFactory.getRemoteInstance().getValue("where report='" + reportId + "'") != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FormulaSoluInfo preBookFormulaSolu(Book book, OrgUnitInfo orgUnit, TemplateInfo template) {
        boolean autoCalculate = book.isAutoCalculate();
        book.setAutoCalculate(false);
        FormulaSoluInfo formulaSolu = new FormulaSoluInfo();
        if (orgUnit == null || orgUnit.getId() == null || book == null || template == null || template.getTemplateSource().getValue() == 1) {
            if (template != null && !template.isFromTemplate()) {
                String tplId = template.getId().toString();
                try {
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo("groupTemplate"));
                    TemplateInfo templateInfo = this.getTemplateBizInterface().getTemplateInfo((IObjectPK)new ObjectUuidPK(tplId), selector);
                    String groupTplId = templateInfo.getGroupTemplate().getId().toString();
                    selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo("data"));
                    templateInfo = this.getTemplateBizInterface().getTemplateInfo((IObjectPK)new ObjectUuidPK(groupTplId), selector);
                    Book groupTplBook = templateInfo.getBook();
                    this.changeCellFormat(book, groupTplBook);
                }
                catch (Exception e) {
                    logger.error((Object)"FormulaSoluCalcHelp.preFormulaSolu error:", (Throwable)e);
                    formulaSolu.setReportBook(book);
                    FormulaSoluInfo templateInfo = formulaSolu;
                    return templateInfo;
                }
                finally {
                    book.setAutoCalculate(autoCalculate);
                }
            }
            formulaSolu.setReportBook(book);
            return formulaSolu;
        }
        Map formulaMap = null;
        try {
            String groupId = template.getGroup();
            String orgUnitId = orgUnit.getId().toString();
            formulaMap = this.getFormulaSoluBizInterface().getFormulaMapByOrg(orgUnitId, groupId);
            if (formulaMap == null || formulaMap.size() == 0) {
                Object soluId;
                formulaMap = this.getFormulaSoluBizInterface().getSoluByTplGroupIdAndComId(groupId, orgUnitId);
                if (formulaMap != null && !formulaMap.isEmpty()) {
                    soluId = (String)formulaMap.get("soluId");
                    FormulaSoluInfo solu = this.getFormulaSoluBizInterface().getFormulaSoluInfo((IObjectPK)new ObjectUuidPK((String)soluId));
                    Book soluBook = IOHelper.unpackBook((byte[])solu.getData(), (String)"rpt_trans");
                    if (!template.isFromTemplate()) {
                        this.changeCellFormat(soluBook, book);
                    }
                    formulaSolu.setReportBook(soluBook);
                    template.setTemplateSource(TemplateSourceEnum.GRADETEMPLATE);
                    template.setVersionNumber(solu.getVersionNumber());
                } else {
                    formulaSolu.setReportBook(book);
                }
                soluId = formulaSolu;
                return soluId;
            }
        }
        catch (Exception e) {
            logger.error((Object)"FormulaSoluCalcHelp.preFormulaSolu error:", (Throwable)e);
            formulaSolu.setReportBook(book);
            FormulaSoluInfo orgUnitId = formulaSolu;
            return orgUnitId;
        }
        finally {
            book.setAutoCalculate(autoCalculate);
        }
        int sheetCount = book.getSheetCount();
        try {
            Sheet sheet = null;
            for (int i = 0; i < sheetCount; ++i) {
                sheet = book.getSheet(i);
                String sheetId = sheet.getID();
                Map sheetMap = (Map)formulaMap.get(sheetId);
                if (sheetMap == null || sheetMap.size() == 0) continue;
                boolean isDynaReport = this.isDynaReport(book, template, sheet);
                this.setSheetFormula(sheet, sheetMap, isDynaReport, book);
            }
        }
        catch (Exception e) {
            logger.error((Object)"FormulaSoluCalcHelp.preFormulaSolu error:", (Throwable)e);
            FormulaSoluInfo formulaSoluInfo = null;
            return formulaSoluInfo;
        }
        finally {
            book.setAutoCalculate(autoCalculate);
        }
        formulaSolu.setReportBook(book);
        formulaSolu.setId(BOSUuid.read((String)((String)formulaMap.get("soluId"))));
        FormulaSoluInfo tempFormulaSoluInfo = null;
        try {
            tempFormulaSoluInfo = this.getFormulaSoluBizInterface().getFormulaSoluInfo("select * where id='" + formulaMap.get("soluId") + "'");
            formulaSolu.setBook(tempFormulaSoluInfo.getBook());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return formulaSolu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeCellFormat(Book soluBook, Book tplBook) {
        boolean autoCalculate = soluBook.isAutoCalculate();
        try {
            soluBook.setCalculate(false);
            int sheetCount = soluBook.getSheetCount();
            Sheet sheet = null;
            for (int i = 0; i < sheetCount; ++i) {
                sheet = soluBook.getSheet(i);
                String sheetId = sheet.getID();
                Sheet tplSheet = tplBook.getSheetByID(sheetId);
                int maxRowCount = sheet.getMaxRowIndex();
                int maxColCount = sheet.getMaxColIndex();
                for (int j = 0; j <= maxRowCount; ++j) {
                    for (int k = 0; k <= maxColCount; ++k) {
                        Cell tplCell;
                        Cell cell = sheet.getCell(j, k, false);
                        if (cell == null || cell.getUserObject("formulaSolutionNeedSave") == null) continue;
                        StyleAttributes sa = Styles.getEmptySA();
                        ShareStyleAttributes ssa = Styles.getSSA((StyleAttributes)sa);
                        if (tplSheet != null && (tplCell = tplSheet.getCell(j, k, false)) != null) {
                            ssa = tplCell.getSSA();
                        }
                        cell.setSSA(ssa);
                        cell.removeUserObject("formulaSolutionNeedSave");
                    }
                }
            }
        }
        finally {
            soluBook.setCalculate(autoCalculate);
        }
    }

    private void setSheetFormula(Sheet sheet, Map<String, String> formulaMap, boolean isDynaReport, Book book) {
        if (isDynaReport) {
            this.setDynaReportFormola(sheet, formulaMap);
        } else if (this.isInterOrExchSheet(sheet, book)) {
            this.setGroupReportFormulaForInterOrExch(sheet, formulaMap);
        } else {
            this.setGroupReportFormula(sheet, formulaMap);
        }
    }

    private void setGroupReportFormulaForInterOrExch(Sheet sheet, Map<String, String> formulaMap) {
        int iPosLeft = CslRptUtil.getBasePosition_Left((Sheet)sheet);
        int iPosTop = CslRptUtil.getBasePosition_Top((Sheet)sheet);
        if (iPosLeft < 0) {
            iPosLeft = 0;
        }
        if (iPosTop < 0) {
            iPosTop = 0;
        }
        int extX = sheet.getMaxColIndex() + 1;
        for (int j = iPosLeft + 1; j < extX; ++j) {
            Range range;
            ItemFormula itemFormula;
            String itemFormulaStr;
            String formula;
            Range rangeItemFormula = sheet.getRange(iPosTop, j);
            if (rangeItemFormula == null || rangeItemFormula.getUserObject("ITEM") == null || StringUtils.isEmpty((String)(formula = formulaMap.get(itemFormulaStr = (itemFormula = (ItemFormula)rangeItemFormula.getUserObject("ITEM")).toString()))) || (range = sheet.getRange(iPosTop + 1, j)) == null) continue;
            range.setFormula(formula);
        }
    }

    private boolean isInterOrExchSheet(Sheet sheet, Book book) {
        int reportClass = this.getSheetType(book, sheet);
        boolean isInter = reportClass == 10;
        boolean isExch = reportClass == 20;
        return isInter || isExch;
    }

    private void setDynaReportFormola(Sheet sheet, Map<String, String> formulaMap) {
        ArrayList pointList = DynamicTemplateUtility.getBasePointList((Sheet)sheet);
        for (int j = 0; j < pointList.size(); ++j) {
            boolean isVertiCal;
            int rowIndex = -1;
            int rowCount = 1;
            int colIndex = -1;
            int colCount = 1;
            int valueRowDynaIndex = 0;
            int valueColDynaIndex = 0;
            Point basePoint = (Point)pointList.get(j);
            Point endPoint = this.getDynaRange(sheet, basePoint);
            DynaParameters param = DynamicTemplateUtility.getDynaParameters((Sheet)sheet, (Point)basePoint);
            DynaRptBasePointIndexHandle indexHandle = new DynaRptBasePointIndexHandle(param, basePoint, sheet, true, true);
            int boforeSumFormulaCount = indexHandle.getBeforeDynaItemSumRangeCount();
            boolean bl = isVertiCal = 0 == param.getSpreadStyle();
            if (isVertiCal) {
                rowIndex = basePoint.y;
                colIndex = basePoint.x + 1;
                colCount = endPoint.x - basePoint.x;
                valueRowDynaIndex = 1 + boforeSumFormulaCount;
            } else {
                colIndex = basePoint.x;
                rowIndex = basePoint.y + 1;
                rowCount = endPoint.y - basePoint.y;
                valueColDynaIndex = 1 + boforeSumFormulaCount;
            }
            this.setDynaBasePoitSql(sheet, formulaMap, basePoint.y, basePoint.x, isVertiCal ? basePoint.y : basePoint.y + 1, isVertiCal ? basePoint.x + 1 : basePoint.x);
            this.setDynaReportFormolaByItem(sheet, formulaMap, rowIndex, rowCount, colIndex, colCount, valueRowDynaIndex, valueColDynaIndex);
        }
    }

    private void setDynaBasePoitSql(Sheet sheet, Map<String, String> formulaMap, int rowIndex, int colIndex, int itemFCellRowIndex, int itemFCellColIndex) {
        String itemF;
        String sqlText;
        Cell cell = sheet.getCell(rowIndex, colIndex, false);
        if (cell == null) {
            return;
        }
        Cell formulaCell = sheet.getCell(itemFCellRowIndex, itemFCellColIndex, false);
        if (formulaCell != null && formulaCell.getUserObject("ITEM") != null && !StringUtils.isEmpty((String)(sqlText = formulaMap.get(itemF = formulaCell.getUserObjectValue("ITEM").toString() + "sqlText")))) {
            cell.setUserObject("sqlText", (Object)sqlText);
        }
    }

    private void setDynaReportFormolaByItem(Sheet sheet, Map<String, String> formulaMap, int rowIndex, int rowCount, int colIndex, int colCount, int valueRowDynaIndex, int valueColDynaIndex) {
        Cell cell = null;
        String itemF = null;
        String formula = null;
        Cell formulaCell = null;
        for (int i = rowIndex; i < rowIndex + rowCount; ++i) {
            for (int j = colIndex; j < colIndex + colCount; ++j) {
                cell = sheet.getCell(i, j, false);
                if (cell == null || cell.getUserObject("ITEM") == null || StringUtils.isEmpty((String)(formula = formulaMap.get(itemF = cell.getUserObjectValue("ITEM").toString()))) || (formulaCell = sheet.getCell(i + valueRowDynaIndex, j + valueColDynaIndex, false)) == null) continue;
                formulaCell.setFormula(formula);
            }
        }
    }

    private void setGroupReportFormula(Sheet sheet, Map<String, String> formulaMap) {
        int maxRowCount = sheet.getMaxRowIndex();
        int maxColCount = sheet.getMaxColIndex();
        for (int i = 0; i <= maxRowCount; ++i) {
            for (int j = 0; j <= maxColCount; ++j) {
                String itemF;
                String formula;
                Cell cell = sheet.getCell(i, j, false);
                if (cell == null || cell.getUserObject("ITEM") == null || StringUtils.isEmpty((String)(formula = formulaMap.get(itemF = cell.getUserObjectValue("ITEM").toString())))) continue;
                cell.setFormula(formula);
            }
        }
    }

    public Point getDynaRange(Sheet sheet, Point basePoint) {
        Point point = null;
        DynaParameters param = DynamicTemplateUtility.getDynaParameters((Sheet)sheet, (Point)basePoint);
        int colSize = param.getDefaultCounter();
        int x = basePoint.y;
        int y = basePoint.x;
        DynaRptBasePointIndexHandle indexHandle = new DynaRptBasePointIndexHandle(param, basePoint, sheet, true, true);
        int boforeSumFormulaCount = indexHandle.getBeforeDynaItemSumRangeCount();
        if (param.getSpreadStyle() == 0) {
            int x1 = x + colSize + boforeSumFormulaCount;
            point = new Point(this.getColCount(sheet, x, y), x1);
        } else if (param.getSpreadStyle() == 1) {
            int y1 = y + colSize + boforeSumFormulaCount;
            point = new Point(y1, this.getRowCount(sheet, x, y));
        }
        return point;
    }

    public int getColCount(Sheet curSheet, int top, int left) {
        int width;
        for (int i = width = curSheet.getMaxColIndex(); i > left; --i) {
            Cell cell = curSheet.getCell(top, i, false);
            if (cell == null || !this.hasFormula(cell)) continue;
            return i;
        }
        return 1;
    }

    public int getRowCount(Sheet curSheet, int top, int left) {
        int height;
        for (int i = height = curSheet.getMaxRowIndex(); i > top; --i) {
            Cell cell = curSheet.getCell(i, left, false);
            if (cell == null || !this.hasFormula(cell)) continue;
            return i;
        }
        return 1;
    }

    private boolean hasFormula(Cell cell) {
        if (cell == null) {
            return false;
        }
        ItemFormula itemCellObj = (ItemFormula)cell.getUserObjectValue("ITEM");
        return itemCellObj != null;
    }

    public void replaceCellContentBySolu(Book tplBook, Book currVerBook) {
        currVerBook.setCalculate(false);
        tplBook.setCalculate(false);
        int sheetCount = currVerBook.getSheetCount();
        for (int i = 0; i < sheetCount; ++i) {
            Sheet currVerSheet = currVerBook.getSheet(i);
            Sheet tplSheet = tplBook.getSheet(currVerSheet.getSheetName());
            if (tplSheet == null) {
                return;
            }
            int maxc = currVerSheet.getMaxColIndex() > tplSheet.getMaxColIndex() ? currVerSheet.getMaxColIndex() : tplSheet.getMaxColIndex();
            int maxr = currVerSheet.getMaxRowIndex() > tplSheet.getMaxRowIndex() ? currVerSheet.getMaxRowIndex() : tplSheet.getMaxRowIndex();
            for (int row = 0; row <= maxr; ++row) {
                for (int col = 0; col <= maxc; ++col) {
                    Cell cell = currVerSheet.getCell(row, col, false);
                    Cell tblCell = tplSheet.getCell(row, col, true);
                    if (cell == null || cell.getUserObject("formulaSolutionNeedSave") == null) continue;
                    String formula = cell.getFormula();
                    Variant value = cell.getValue();
                    UserObject userObject = cell.getUserObject("ITEM");
                    if (userObject != null && !((ItemFormula)userObject.getValue()).isBasePoint()) {
                        ItemFormula itemFormula = (ItemFormula)userObject.getValue();
                        String itemFormulaStr = itemFormula.getFormula();
                        if (tblCell == null || tblCell.getUserObject("ITEM") == null) continue;
                        ItemFormula tblItemFormula = (ItemFormula)tblCell.getUserObject("ITEM").getValue();
                        String tblItemFormulaStr = tblItemFormula.getFormula();
                        if (itemFormulaStr.equals(tblItemFormulaStr)) {
                            if (formula != null && formula.startsWith("=")) {
                                tblCell.setFormula(formula);
                            } else {
                                if (value == null) continue;
                                tblCell.setValue(value);
                            }
                            this.setCellGreenSSA(tblCell);
                            tblCell.setUserObject("formulaSolutionNeedSave", (Object)"true");
                            continue;
                        }
                        for (int r = 0; r <= maxr; ++r) {
                            for (int c = 0; c <= maxc; ++c) {
                                ItemFormula itemFormulaTbl;
                                String itemFormulaTblStr;
                                Cell tblC = tplSheet.getCell(r, c, false);
                                if (tblC == null || tblC.getUserObject("ITEM") == null || !itemFormulaStr.equals(itemFormulaTblStr = (itemFormulaTbl = (ItemFormula)tblC.getUserObject("ITEM").getValue()).getFormula())) continue;
                                if (formula != null && formula.startsWith("=")) {
                                    tblCell.setFormula(formula);
                                } else {
                                    if (value == null) continue;
                                    tblCell.setValue(value);
                                }
                                this.setCellGreenSSA(tblCell);
                                tblCell.setUserObject("formulaSolutionNeedSave", (Object)"true");
                            }
                        }
                        continue;
                    }
                    if (tblCell == null) continue;
                    if (formula != null && formula.startsWith("=")) {
                        tblCell.setFormula(formula);
                    } else {
                        if (value == null) continue;
                        tblCell.setValue(value);
                    }
                    this.setCellGreenSSA(tblCell);
                    tblCell.setUserObject("formulaSolutionNeedSave", (Object)"true");
                }
            }
        }
    }

    private void setCellGreenSSA(Cell cell) {
        ShareStyleAttributes oldSSA = cell.getSSA();
        cell.setUserObject("formulaSolutionProcessUISSA", (Object)oldSSA);
        StyleAttributes sa = Styles.getEmptySA();
        sa.setBackground(Color.GREEN);
        ShareStyleAttributes ssa = Styles.getSSA((StyleAttributes)sa);
        cell.setSSA(ssa);
    }

    public void synCheckSolution(Book tplBook, Book currVerBook) {
        BookProperties propertiesTpl = BookProperties.loadFromBook((Book)tplBook);
        RptOperationSchemaComp operationSchemaTpl = propertiesTpl.getOperationSchema();
        BookProperties propertiesCv = BookProperties.loadFromBook((Book)currVerBook);
        RptOperationSchemaComp operationSchemaCv = propertiesCv.getOperationSchema();
        if (operationSchemaTpl.getExpTank() == null) {
            if (operationSchemaCv.getExpTank() == null) {
                return;
            }
            tplBook.setUserObject("operationSchemas", (Object)operationSchemaCv);
            return;
        }
        if (operationSchemaCv.getExpTank() == null) {
            tplBook.setUserObject("operationSchemas", (Object)operationSchemaTpl);
            return;
        }
        ArrayList tblExpressions = (ArrayList)operationSchemaTpl.getExpTank().getExpressions();
        if (tblExpressions == null) {
            return;
        }
        ArrayList cvExpressions = (ArrayList)operationSchemaCv.getExpTank().getExpressions();
        ArrayList<RptCheckExpression> newExpressions = new ArrayList<RptCheckExpression>();
        newExpressions.addAll(tblExpressions);
        for (int i = 0; i < cvExpressions.size(); ++i) {
            try {
                RptCheckExpression cvExp = (RptCheckExpression)cvExpressions.get(i);
                String cvExpString = cvExp.toSerialString();
                boolean isSame = false;
                for (int j = 0; j < tblExpressions.size(); ++j) {
                    RptCheckExpression exp = (RptCheckExpression)tblExpressions.get(j);
                    String expString = exp.toSerialString();
                    if (!expString.equals(cvExpString)) continue;
                    isSame = true;
                }
                if (isSame) continue;
                newExpressions.add(cvExp);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)"synCheckSolution: ", (Throwable)e);
            }
        }
        RptOperationSchemaComp newRptOperationSchemaComp = new RptOperationSchemaComp();
        RptCheckExpTank newRptCheckExpTank = new RptCheckExpTank();
        newRptCheckExpTank.setExpressions(newExpressions);
        newRptOperationSchemaComp.setExpTank(newRptCheckExpTank);
        tplBook.setUserObject("operationSchemas", (Object)newRptOperationSchemaComp);
    }
}

