/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.formulasolu.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetOption;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.app.CSLServerHelper;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.TableInfo;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluCalcHelp;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluCollection;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluDispenseCollection;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluDispenseFactory;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluDispenseInfo;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluFactory;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluInfo;
import com.kingdee.eas.fi.newrpt.formulasolu.app.AbstractFormulaSoluDispenseControllerBean;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.PublishedStatusEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.TemplateSourceEnum;
import com.kingdee.eas.fi.rpt.VersionStatusEnum;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.IBreakableExpressionHandler;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FormulaSoluDispenseControllerBean
extends AbstractFormulaSoluDispenseControllerBean {
    private static final long serialVersionUID = 7425310009982353584L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.formulaSolu.app.FormulaSoluDispenseControllerBean");
    private Set methodSet;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Map _dispenseFormulaSolu(Context ctx, List companyIds, List formulaSoluIds, Map params) throws BOSException, EASBizException {
        boolean ispass;
        String tmpTable;
        HashMap result;
        block6: {
            result = null;
            if (companyIds == null || companyIds.isEmpty() || formulaSoluIds == null || formulaSoluIds.isEmpty()) return result;
            this.writeDispenseLog(ctx, 0, formulaSoluIds);
            tmpTable = null;
            result = new HashMap();
            tmpTable = this.getSoluIdCompanyTable(ctx, companyIds, formulaSoluIds);
            ispass = this.checkSelectedTemplateGroup(ctx, tmpTable, formulaSoluIds, result);
            if (ispass) break block6;
            HashMap hashMap = result;
            if (tmpTable == null) return hashMap;
            TempTablePool.getInstance((Context)ctx).releaseTable(tmpTable);
            return hashMap;
        }
        try {
            ispass = this.checkTemplateGroupIsDisp(ctx, tmpTable, result);
            if (ispass) {
                this.isUpdateSubCompanyTemplate(ctx, tmpTable, companyIds, formulaSoluIds, params);
                this.delTheSameDisp(ctx, tmpTable);
                this.dispense(ctx, tmpTable, params);
                this.updateSubCompanyTemplate(ctx, formulaSoluIds, companyIds);
            }
            if (tmpTable == null) return result;
        }
        catch (Exception e) {
            try {
                logger.error((Object)"_dispenseFormulaSolu error.", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                if (tmpTable == null) throw throwable;
                TempTablePool.getInstance((Context)ctx).releaseTable(tmpTable);
                throw throwable;
            }
        }
        TempTablePool.getInstance((Context)ctx).releaseTable(tmpTable);
        return result;
    }

    private void writeDispenseLog(Context ctx, int type, List formulaSoluIds) throws BOSException {
        HashSet ids = new HashSet(formulaSoluIds);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        view.setFilter(filter);
        FormulaSoluCollection solus = FormulaSoluFactory.getLocalInstance(ctx).getFormulaSoluCollection(view);
        if (solus != null && !solus.isEmpty()) {
            Iterator it = solus.iterator();
            while (it.hasNext()) {
                FormulaSoluInfo formulaSolu = (FormulaSoluInfo)it.next();
                if (type == 0) {
                    this.dispense_log(ctx, (IObjectValue)formulaSolu);
                    continue;
                }
                this.undispense_log(ctx, (IObjectValue)formulaSolu);
            }
        }
    }

    private void isUpdateSubCompanyTemplate(Context ctx, String tmpTable, List companyIds, List formulaSoluIds, Map params) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" Select disp.Fformulasoluid soluId,disp.FCompanyId comId,disp.FIsCoverTmpFormula isCoverTmpFormula,disp.FIsCoverUnLockCell isCoverUnLockCell from T_Csl_FormulaSoluDispense disp Inner join ").append(tmpTable).append(" tmp ON disp.Fformulasoluid = tmp.fformulaSoluId and disp.FCompanyId = tmp.fcompanyid ");
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString());
        try {
            boolean isCoverTmpFormulaSel = Integer.valueOf(String.valueOf(params.get("isCoverTmpFormula"))) != 0;
            boolean isCoverUnLockCellSel = Integer.valueOf(String.valueOf(params.get("isCoverUnLockCell"))) != 0;
            companyIds.clear();
            formulaSoluIds.clear();
            while (rowSet.next()) {
                String soluId = rowSet.getString("soluId");
                String comId = rowSet.getString("comId");
                boolean isCoverTmpFormula = rowSet.getBoolean("isCoverTmpFormula");
                boolean isCoverUnLockCell = rowSet.getBoolean("isCoverUnLockCell");
                if (isCoverTmpFormulaSel == isCoverTmpFormula && isCoverUnLockCellSel == isCoverUnLockCell) continue;
                companyIds.add(comId);
                formulaSoluIds.add(soluId);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"isUpdateSubCompanyTemplate error. ", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void delTheSameDisp(Context ctx, String tmpTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from T_Csl_FormulaSoluDispense where fid in ( \n");
        sql.append(" Select fid from T_Csl_FormulaSoluDispense disp Inner join ").append(tmpTable).append(" tmp ON disp.Fformulasoluid = tmp.fformulaSoluId and disp.FCompanyId = tmp.fcompanyid) ");
        DbUtil.execute(ctx, sql.toString());
    }

    private boolean checkTemplateGroupIsDisp(Context ctx, String tmpTable, Map result) throws BOSException, EASBizException {
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" select distinct targSolu.FTemplateNumber as tmplNumber, targSolu.FTemplateName as tmplName, unit.fname_").append(ctx.getLocale());
            sql.append(" as unitName,targSolu.fname_").append(ctx.getLocale()).append(" soluName ");
            sql.append(" from ").append(tmpTable).append(" tmp ");
            sql.append(" inner join T_CSL_FormulaSolu srcSolu on srcSolu.FId=tmp.fformulaSoluId ");
            sql.append(" inner join T_CSL_FormulaSolu targSolu on srcSolu.FTemplateGroupId=targSolu.FTemplateGroupId ");
            sql.append(" and srcSolu.Fnumber<>targSolu.Fnumber ");
            sql.append(" inner join T_Csl_FormulaSoluDispense srcDisp on srcDisp.Fformulasoluid=targSolu.Fid and srcDisp.Fcompanyid=tmp.fcompanyid");
            sql.append(" inner join t_org_baseunit unit on unit.fid = srcDisp.fcompanyid ");
            sql.append(" left join T_Csl_FormulaSoluDispense disp on disp.FFormulaSoluId=tmp.fformulaSoluId and disp.FCompanyId=tmp.fcompanyid ");
            sql.append(" where disp.fid is null ");
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString());
            if (rowSet != null && rowSet.size() > 0) {
                StringBuffer showMsg = new StringBuffer();
                String resPath = "com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluResource";
                String soluStr = EASResource.getString((String)resPath, (String)"7_solu");
                String itemFormulaStr = EASResource.getString((String)resPath, (String)"33_soluTemplateGroup");
                String isDispenseStr = EASResource.getString((String)resPath, (String)"9_isDispense");
                while (rowSet.next()) {
                    showMsg.append(soluStr).append("[").append(rowSet.getString("soluName")).append("]").append(itemFormulaStr).append("[");
                    showMsg.append(rowSet.getString("tmplName")).append("(").append(rowSet.getString("tmplNumber")).append(")").append("]").append(isDispenseStr).append("[");
                    showMsg.append(rowSet.getString("unitName")).append("]\n");
                    if (showMsg.length() <= 1000) continue;
                }
                if (showMsg.length() > 0) {
                    result.put("showMsgKey", showMsg.toString());
                    return false;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"checkItemFormulaIsDisp error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    private boolean checkSelectedTemplateGroup(Context ctx, String tmpTable, List formulaSoluIds, Map result) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        sql.append(" select distinct solu.FTemplateNumber tmplNumber, solu.FTemplateName tmplName, solu.fnumber fnumber,solu.fname_").append(ctx.getLocale());
        sql.append(" soluName from T_CSL_FormulaSolu solu ");
        sql.append(" inner join (");
        sql.append(" select FTemplateGroupId from T_CSL_FormulaSolu ");
        sql.append(" where Fid in ", formulaSoluIds);
        sql.append(" group by FTemplateGroupId having count(*)>1 ");
        sql.append(") solu2 on solu2.FTemplateGroupId=solu.FTemplateGroupId");
        sql.append(" where solu.fid in", formulaSoluIds);
        sql.append(" order by solu.FNumber asc ");
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
        if (rowSet != null && rowSet.size() > 0) {
            String tmplName = null;
            String tmplNumber = null;
            String preTmplNumber = null;
            StringBuffer msg = new StringBuffer();
            String resPath = "com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluResource";
            String itemFormulaStr = EASResource.getString((String)resPath, (String)"33_soluTemplateGroup");
            String dispenseSolu = EASResource.getString((String)resPath, (String)"11_dispenseSolu");
            while (rowSet.next()) {
                tmplNumber = rowSet.getString("tmplNumber");
                tmplName = rowSet.getString("tmplName");
                if (preTmplNumber == null || !preTmplNumber.equals(tmplNumber)) {
                    if (preTmplNumber != null) {
                        msg.append(itemFormulaStr).append("\uff1a").append(tmplName).append("(").append(tmplNumber).append(")").append(" \n");
                    }
                    msg.append(dispenseSolu).append("[").append(rowSet.getString("soluName")).append("]");
                    preTmplNumber = tmplNumber;
                } else {
                    msg.append("\u3001[").append(rowSet.getString("soluName")).append("]");
                }
                if (msg.length() <= 1000) continue;
            }
            if (msg.length() > 0) {
                msg.append(itemFormulaStr).append("\uff1a").append(tmplName).append("(").append(tmplNumber).append(")").append(" \n");
                result.put("showMsgKey", msg.toString());
                return false;
            }
        }
        return true;
    }

    private void dispense(Context ctx, String tmpTable, Map params) throws BOSException, EASBizException {
        try {
            Calendar ca = Calendar.getInstance();
            int year = ca.get(1);
            int month = ca.get(2) + 1;
            int day = ca.get(5);
            int hour = ca.get(11);
            int min = ca.get(12);
            int sec = ca.get(13);
            int isAllowChgTemplate = Integer.valueOf(String.valueOf(params.get("isAllowChgTemplate")));
            int isCoverTmpFormula = Integer.valueOf(String.valueOf(params.get("isCoverTmpFormula")));
            int isCoverUnLockCell = Integer.valueOf(String.valueOf(params.get("isCoverUnLockCell")));
            int isAllowChgCheckSol = Integer.valueOf(String.valueOf(params.get("isAllowChgCheckSol")));
            StringBuffer sql = new StringBuffer();
            sql.append(" insert into T_Csl_FormulaSoluDispense(fid,FFormulaSoluId,FCompanyId,FIsAllowChgTemplate,FIsCoverTmpFormula,FIsCoverUnLockCell,FIsAllowChgCheckSol,FCreatorID,FCreateTime)");
            sql.append(" select newbosid('").append(new FormulaSoluDispenseInfo().getBOSType()).append("'),");
            sql.append(" tmp.fformulaSoluId,tmp.fcompanyid,").append(isAllowChgTemplate).append(",").append(isCoverTmpFormula).append(",").append(isCoverUnLockCell).append(",").append(isAllowChgCheckSol).append(",'").append(ctx.getCaller().toString()).append("',");
            sql.append("{ts'").append(year).append("-").append(month < 10 ? "0" + month : Integer.valueOf(month)).append("-").append(day < 10 ? "0" + day : Integer.valueOf(day)).append(" ").append(hour < 10 ? "0" + hour : Integer.valueOf(hour)).append(":").append(min < 10 ? "0" + min : Integer.valueOf(min)).append(":").append(sec < 10 ? "0" + sec : Integer.valueOf(sec)).append("'}");
            sql.append(" from ").append(tmpTable).append(" tmp ");
            DbUtil.execute(ctx, sql.toString());
        }
        catch (Exception e) {
            logger.error((Object)"dispense error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private String getSoluIdCompanyTable(Context ctx, List companyIds, List formulaSoluIds) throws BOSException, EASBizException {
        try {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            String tmpTable = pool.createTempTable("create table t_csl_formulaSolu(fcompanyid varchar(44),fformulaSoluId varchar(44))");
            StringBuffer sql = new StringBuffer();
            sql.append(" insert into ").append(tmpTable).append("(fcompanyid,fformulaSoluId) values(?,?)");
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            for (Object formulaSoluId : formulaSoluIds) {
                for (Object companyId : companyIds) {
                    paramsList.add(new Object[]{companyId, formulaSoluId});
                }
            }
            DbUtil.executeBatch(ctx, sql.toString(), paramsList);
            return tmpTable;
        }
        catch (Exception e) {
            logger.error((Object)"getSoluIdCompanyTable error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Map _unDispenseFormulaSolu(Context ctx, List formulaSoluIds, List companyIds) throws BOSException, EASBizException {
        this.writeDispenseLog(ctx, 1, formulaSoluIds);
        Map checkMap = this.checkUnDispensed(ctx, formulaSoluIds, companyIds);
        if (checkMap != null && !checkMap.isEmpty()) {
            this.delPassedDisRec(ctx, formulaSoluIds, companyIds, checkMap);
        } else {
            SQLBuilder sql = new SQLBuilder();
            sql.append(" delete from T_Csl_FormulaSoluDispense where FFormulaSoluId in ", formulaSoluIds);
            sql.append(" and FCompanyId in", companyIds);
            DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
        }
        return checkMap;
    }

    private void delPassedDisRec(Context ctx, List<String> formulaSoluIds, List<String> companyIds, Map checkMap) throws BOSException {
        if (checkMap != null && !checkMap.isEmpty() && checkMap.containsKey("notDelDisIDs")) {
            Map notDelDisIDs = (Map)checkMap.get("notDelDisIDs");
            FormulaSoluDispenseCollection disps = this.getFormulaSoluDispenseCollection(ctx, formulaSoluIds, companyIds);
            if (disps != null && !disps.isEmpty()) {
                ArrayList<String> unDispIds = new ArrayList<String>();
                Iterator it = disps.iterator();
                while (it.hasNext()) {
                    FormulaSoluDispenseInfo soluDisp = (FormulaSoluDispenseInfo)it.next();
                    String dispId = soluDisp.getId().toString();
                    if (notDelDisIDs.containsKey(dispId)) continue;
                    unDispIds.add(dispId);
                }
                if (!unDispIds.isEmpty()) {
                    SQLBuilder sql = new SQLBuilder();
                    sql.append(" delete from T_Csl_FormulaSoluDispense where FId in ", unDispIds);
                    DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
                }
            }
        }
    }

    private FormulaSoluDispenseCollection getFormulaSoluDispenseCollection(Context ctx, List<String> formulaSoluIds, List<String> companyIds) throws BOSException {
        HashSet<String> soluSet = new HashSet<String>(formulaSoluIds);
        HashSet<String> comIdSet = new HashSet<String>(companyIds);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("formulaSoluId", soluSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("company", comIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        return FormulaSoluDispenseFactory.getLocalInstance(ctx).getFormulaSoluDispenseCollection(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map checkUnDispensed(Context ctx, List formulaSoluIds, List companyIds) throws BOSException {
        if (formulaSoluIds == null || formulaSoluIds.size() == 0) {
            return null;
        }
        ParamTempTblService paramsrv = null;
        HashMap notDelDisIDs = new HashMap();
        HashMap<String, Cloneable> map = new HashMap<String, Cloneable>();
        try {
            CSLServerHelper helper = new CSLServerHelper(ctx);
            String ext = helper.getFieldNameExtend().toString();
            StringBuffer wherein = new StringBuffer();
            for (int i = 0; i < formulaSoluIds.size(); ++i) {
                if (i != 0) {
                    wherein.append(", ");
                }
                wherein.append("'" + formulaSoluIds.get(i) + "'");
            }
            TableInfo table = new TableInfo("T_DISP_COMPANY001");
            table.addColumn("companyID");
            paramsrv = new ParamTempTblService(ctx, table, (Collection)companyIds, null);
            StringBuffer sql = null;
            IRowSet rs = null;
            ArrayList result = null;
            sql = new StringBuffer();
            sql.append(" SELECT DISTINCT fsd.fid, o.FNumber, o.FName" + ext + " \n");
            sql.append(" FROM T_RPT_Template t \n");
            sql.append(" INNER JOIN T_CSL_FormulaSolu fs On t.FGroup = fs.FTemplateGroupId ");
            sql.append(" INNER JOIN T_Csl_FormulaSoluDispense fsd On fs.Fid = fsd.FFormulaSoluId and t.FCOMPANYID = fsd.FCompanyId \n");
            sql.append(" INNER JOIN T_ORG_BaseUNIT o ON t.FCompanyID = o.FID \n");
            sql.append(" Where t.FTemplateSource = 1 \n");
            sql.append(" And t.FCompanyID in (").append(paramsrv.getParamsSql()).append(") \n");
            sql.append(" And t.FVersionNumber like concat(fs.FVersionNumber,'.%') \n");
            sql.append(" And fs.Fid IN (" + wherein + ") \n");
            rs = DbUtil.executeQuery(ctx, sql.toString());
            result = new ArrayList();
            try {
                result = this.filterDbAndGetDisID(rs, notDelDisIDs, 2);
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            if (result.size() > 0) {
                map.put("reason1", result);
            }
            sql = new StringBuffer();
            sql.append(" Select DISTINCT fsd.fid, o.FNumber, o.FName" + ext + " \n");
            sql.append(" From T_Csl_CslReport r \n");
            sql.append(" INNER JOIN T_CSL_RptReceived rec ON rec.FReportID = r.FID \n");
            sql.append(" INNER JOIN T_ORG_BaseUNIT o ON r.FOrgUnitID = o.FID \n");
            sql.append(" Inner join T_Rpt_Template t On t.Fid = r.FTemplateId \n");
            sql.append(" INNER JOIN T_CSL_FormulaSolu fs On t.FGroup = fs.FTemplateGroupId \n");
            sql.append(" INNER JOIN T_Csl_FormulaSoluDispense fsd On fs.Fid = fsd.FFormulaSoluId and r.FOrgUnitID = fsd.FCompanyId \n");
            sql.append(" Where r.FOrgUnitID in (").append(paramsrv.getParamsSql()).append(") \n");
            sql.append(" And fs.Fid IN (" + wherein + ") \n");
            sql.append(" AND r.FSourceType IN (1, 7, 10,13) \n");
            sql.append(" AND r.FCreateTime > fsd.FCreateTime \n");
            rs = DbUtil.executeQuery(ctx, sql.toString());
            result = new ArrayList();
            try {
                result = this.filterDbAndGetDisID(rs, notDelDisIDs, 2);
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            if (result.size() > 0) {
                map.put("reason2", result);
            }
            sql = new StringBuffer();
            sql.append(" Select DISTINCT fsd.fid, o.FNumber, o.FName" + ext + " \n");
            sql.append(" From T_Rpt_Report r \n");
            sql.append(" INNER JOIN T_CSL_RptReceived rec ON rec.FReportID = r.FCslReportID \n");
            sql.append(" INNER JOIN T_ORG_BaseUNIT o ON r.FCompanyID = o.FID \n");
            sql.append(" Inner join T_Rpt_Template t On t.Fid = r.FTemplateId \n");
            sql.append(" INNER JOIN T_RPT_Template t2 ON t.FGroupTemplateID = t2.FID\t\n");
            sql.append(" INNER JOIN T_CSL_FormulaSolu fs On t2.FGroup = fs.FTemplateGroupId \n");
            sql.append(" INNER JOIN T_Csl_FormulaSoluDispense fsd On fs.Fid = fsd.FFormulaSoluId and r.FCompanyID = fsd.FCompanyId \n");
            sql.append(" Where r.FCompanyID in (").append(paramsrv.getParamsSql()).append(") \n");
            sql.append(" And t2.FCompanyID in (").append(paramsrv.getParamsSql()).append(") \n");
            sql.append(" And t2.FVersionNumber like concat(fs.FVersionNumber,'.%') \n");
            sql.append(" And t2.FTemplateSource = 1");
            sql.append(" And fs.Fid IN (" + wherein + ") \n");
            rs = DbUtil.executeQuery(ctx, sql.toString());
            result = new ArrayList();
            try {
                result = this.filterDbAndGetDisID(rs, notDelDisIDs, 4);
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            if (result.size() > 0) {
                map.put("reason3", result);
            }
            if (notDelDisIDs.size() > 0) {
                map.put("notDelDisIDs", notDelDisIDs);
            }
        }
        finally {
            if (paramsrv != null) {
                paramsrv.release();
            }
        }
        return map;
    }

    private ArrayList filterDbAndGetDisID(IRowSet rs, Map disIDMap, int checkParamNum) throws SQLException {
        HashMap checkMap = new HashMap();
        ArrayList checkArrayList = new ArrayList();
        if (rs.size() == 0) {
            return checkArrayList;
        }
        while (rs.next()) {
            this.buildDisID(rs, disIDMap);
            this.buildCheckRs(rs, checkParamNum, checkMap);
        }
        this.transCheckMapToArray(checkMap, checkArrayList);
        return checkArrayList;
    }

    private void transCheckMapToArray(Map checkMap, ArrayList checkArrayList) {
        Iterator iter = checkMap.keySet().iterator();
        while (iter.hasNext()) {
            ArrayList list = (ArrayList)checkMap.get(iter.next().toString());
            checkArrayList.add(list);
        }
    }

    private void buildCheckRs(IRowSet rs, int checkParamNum, Map checkMap) throws SQLException {
        StringBuffer checkKeyBuf = new StringBuffer();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 1; i <= checkParamNum; ++i) {
            checkKeyBuf.append(rs.getString(i + 1));
            list.add(rs.getString(i + 1));
        }
        String checkKeyBufStr = checkKeyBuf.toString();
        if (!checkMap.containsKey(checkKeyBufStr.toString())) {
            checkMap.put(checkKeyBufStr, list);
        }
    }

    private void buildDisID(IRowSet rs, Map disIDMap) throws SQLException {
        String disID = rs.getString(1);
        if (!disIDMap.containsKey(disID)) {
            disIDMap.put(disID, null);
        }
    }

    @Override
    protected IObjectCollection _getFormulaSoluSameCompany(Context ctx, List formulaSoluIds, String orgtreeId, List companyIds) throws BOSException, EASBizException {
        if (formulaSoluIds != null && !formulaSoluIds.isEmpty()) {
            SQLBuilder sql = new SQLBuilder();
            sql.append(" select dis.fformulaSoluId fformulaSoluId,dis.fcompanyid fcompanyId");
            sql.append(" from T_Csl_FormulaSoluDispense dis ");
            if (!org.apache.commons.lang.StringUtils.isEmpty((String)orgtreeId)) {
                sql.append(" inner join t_org_structure stru on stru.funitid=dis.fcompanyid ");
            }
            sql.append(" where dis.FFormulaSoluId in", formulaSoluIds);
            if (!org.apache.commons.lang.StringUtils.isEmpty((String)orgtreeId)) {
                sql.append(" and stru.ftreeid=?", orgtreeId);
            }
            if (companyIds != null && !companyIds.isEmpty()) {
                sql.append(" and dis.fcompanyid  in", companyIds);
            }
            sql.append(" order by dis.fformulaSoluId asc ");
            try {
                IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
                HashSet<String> tmpCompanyIds1 = new HashSet<String>();
                HashSet<String> tmpCompanyIds2 = new HashSet<String>();
                String preSoluId = null;
                String curSoluId = null;
                String curCompanyId = null;
                HashSet<String> soluIds = new HashSet<String>();
                int soluIdCount = 0;
                Set<String>[] tmpSet = null;
                while (rowSet != null && rowSet.next()) {
                    curSoluId = rowSet.getString("fformulaSoluId");
                    curCompanyId = rowSet.getString("fcompanyId");
                    soluIds.add(curSoluId);
                    soluIdCount = soluIds.size();
                    if (soluIdCount == 1) {
                        preSoluId = curSoluId;
                        tmpCompanyIds1.add(curCompanyId);
                        continue;
                    }
                    tmpSet = this.getHandleSet(soluIdCount, tmpCompanyIds1, tmpCompanyIds2);
                    if (!StringUtils.equals((String)preSoluId, (String)curSoluId)) {
                        tmpSet[1].clear();
                        preSoluId = curSoluId;
                    }
                    if (!tmpSet[0].contains(curCompanyId)) continue;
                    tmpSet[1].add(curCompanyId);
                }
                if (soluIds.size() == formulaSoluIds.size() && !(tmpSet = this.getHandleSet(soluIdCount, tmpCompanyIds1, tmpCompanyIds2))[1].isEmpty()) {
                    return FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection("select id,number,name where id in(" + CslRptUtil.collection2String(tmpSet[1], (String)",", (boolean)true) + ")");
                }
                tmpCompanyIds1.clear();
                tmpCompanyIds2.clear();
                soluIds.clear();
            }
            catch (SQLException e) {
                logger.error((Object)"_getFormulaSoluSameCompany error.", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        return null;
    }

    private Set<String>[] getHandleSet(int soluIdCount, Set<String> tmpCompanyIds1, Set<String> tmpCompanyIds2) {
        int i = soluIdCount % 2;
        if (i == 1) {
            return new Set[]{tmpCompanyIds2, tmpCompanyIds1};
        }
        return new Set[]{tmpCompanyIds1, tmpCompanyIds2};
    }

    @Override
    protected Map _getTempDispenseOrgIdsAndOrgTreeInfoByTempIds(Context ctx, List templateIdList) throws BOSException, EASBizException {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        ArrayList<String> orgIds = new ArrayList<String>();
        OrgTreeCollection orgTrees = new OrgTreeCollection();
        returnMap.put("orgTrees", orgTrees);
        returnMap.put("orgIds", orgIds);
        if (templateIdList == null || templateIdList.size() == 0) {
            return returnMap;
        }
        StringBuffer getOrgIdsql = new StringBuffer("select distinct tempDis.FCOMPANYID orgId,template.FGROUP tempGroup  from t_csl_templetdispense tempDis \n");
        getOrgIdsql.append("join t_rpt_template template on  tempDis.FDISPENSESRCID=template.fid \n");
        getOrgIdsql.append("join T_CSL_FormulaSolu formulaSolu on formulaSolu.ftemplategroupid=template.fgroup and formulaSolu.ftemplatenumber=template.fnumber \n");
        getOrgIdsql.append("where formulaSolu.FAuditedStatus =2 and formulaSolu.fid in(");
        for (int i = 0; i < templateIdList.size(); ++i) {
            getOrgIdsql.append("?");
            if (i == templateIdList.size() - 1) continue;
            getOrgIdsql.append(",");
        }
        getOrgIdsql.append(")");
        IRowSet rs = DbUtil.executeQuery(ctx, getOrgIdsql.toString(), templateIdList.toArray());
        HashMap orgIdTemp = new HashMap();
        StringBuffer orgIdsqlStr = new StringBuffer();
        try {
            while (rs.next()) {
                String orgId = rs.getString("orgId");
                String tempGroup = rs.getString("tempGroup");
                ArrayList<Object> orgDisTempIds = (ArrayList<Object>)orgIdTemp.get(orgId);
                if (orgDisTempIds == null) {
                    orgDisTempIds = new ArrayList<Object>();
                    orgIdTemp.put(orgId, orgDisTempIds);
                }
                if (orgDisTempIds.contains(tempGroup)) continue;
                orgDisTempIds.add(tempGroup);
            }
            Set keySet = orgIdTemp.keySet();
            for (String orgId : keySet) {
                List templateIds = (List)orgIdTemp.get(orgId);
                if (templateIds.size() != templateIdList.size()) continue;
                orgIds.add(orgId);
                orgIdsqlStr.append(",?");
            }
        }
        catch (Exception e) {
            logger.error((Object)"FormulaSoluDispenseControllerBean._getTempDispenseOrgIdsAndOrgTreeInfoByTempIds getOrgIdsql executeQuery error", (Throwable)e);
        }
        if (orgIds.size() > 0) {
            StringBuffer getTreeSql = new StringBuffer();
            getTreeSql.append("select distinct tree2.fid treeId,tree2.fnumber treeNumber,tree2.FIsForBudget treeIsForBudget,tree2.fname_l2 treeName, tree2.fstartDate startDate, tree2.fendDate endDate from t_csl_templetdispense tempDis \n");
            getTreeSql.append("join t_org_tree tree2 on tempDis.FORGBOUNDID = tree2.fid\t\t\t\t\t\t\t\t\t\t\t\t \t\n");
            getTreeSql.append("join t_rpt_template template on  tempDis.FDISPENSESRCID=template.fid \n");
            getTreeSql.append("join T_CSL_FormulaSolu formulaSolu on formulaSolu.ftemplategroupid=template.fgroup and formulaSolu.ftemplatenumber=template.fnumber \n");
            getTreeSql.append("join (select distinct tree.fnumber from t_org_tree tree \t\t\t\t\t\t\t\t\t\t\t\t \t\t\t\t\n");
            getTreeSql.append("join t_org_structure str on str.FTREEID =tree.fid \t\t\t\t\t\t\t\t\t\t\t\t \t\t\t\t\t\n");
            getTreeSql.append("join t_org_baseunit unit on str.FUNITID =unit.fid\t\t\t\t\t\t\t\t\t\t\t\t \t\t\t\t\t\n");
            getTreeSql.append("where tree.fstatus=1 \t\t\t\t\t\t\t\t\t\t\t\t \t\t\t\t\t\t\t\t\t\t\t\t\n");
            getTreeSql.append("and tree.ftype=8\t\t\t\t\t\t\t\t\t\t\t\t \t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
            getTreeSql.append("and unit.fid in (").append(orgIdsqlStr.deleteCharAt(0)).append(")) tem on tem.fnumber = tree2.Fnumber\t\t\t\t\n");
            getTreeSql.append("where formulaSolu.FAuditedStatus =2 and formulaSolu.fid in(\t\t\t\t\t\n");
            for (int i = 0; i < templateIdList.size(); ++i) {
                getTreeSql.append("'").append(templateIdList.get(i)).append("'");
                if (i == templateIdList.size() - 1) continue;
                getTreeSql.append(",");
            }
            getTreeSql.append(")");
            ArrayList treeSqlParam = new ArrayList(orgIds);
            rs = DbUtil.executeQuery(ctx, getTreeSql.toString(), treeSqlParam.toArray());
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                while (rs.next()) {
                    OrgTreeInfo tree = new OrgTreeInfo();
                    tree.setId(BOSUuid.read((String)rs.getString("treeId")));
                    tree.setNumber(rs.getString("treeNumber"));
                    String startDate = dateFormat.format(rs.getDate("startDate"));
                    String endDate = rs.getDate("endDate") != null ? dateFormat.format(rs.getDate("endDate")) : null;
                    String treeName = rs.getString("treeName");
                    treeName = endDate != null ? treeName + "(" + startDate + " ~ " + endDate + ")" : treeName + "(" + startDate + ")";
                    tree.setName(treeName);
                    tree.setIsForBudget(rs.getInt("treeIsForBudget") > 0);
                    orgTrees.add(tree);
                }
            }
            catch (SQLException e) {
                logger.error((Object)"FormulaSoluDispenseControllerBean._getTempDispenseOrgIdsAndOrgTreeInfoByTempIds getTreeSql executeQuery error", (Throwable)e);
            }
        }
        return returnMap;
    }

    @Override
    protected void _updateSubCompanyTemplate(Context ctx, List soluIds, List companyIds) throws BOSException, EASBizException {
        if (soluIds == null || soluIds.isEmpty()) {
            return;
        }
        HashMap<String, FormulaSoluDispenseInfo> dispensedInfo = new HashMap<String, FormulaSoluDispenseInfo>();
        HashMap<String, List<String>> dispensedCompanyIds = new HashMap<String, List<String>>();
        this.getFormulaSoluDispense(ctx, companyIds, soluIds, dispensedCompanyIds, dispensedInfo);
        if (!dispensedInfo.isEmpty()) {
            Map<String, FormulaSoluInfo> formulaSoluMap = this.getFormulaSoluMap(ctx, soluIds);
            Iterator formulaSoluIds = dispensedInfo.keySet().iterator();
            boolean isCover = false;
            boolean isCoverUnLockCell = false;
            Book preVerBook = null;
            Map<String, SubVersionInfo> cacheSubTplVer = null;
            while (formulaSoluIds.hasNext()) {
                String formulaSoluId = (String)formulaSoluIds.next();
                FormulaSoluDispenseInfo formulaSoluDispenseInfo = (FormulaSoluDispenseInfo)dispensedInfo.get(formulaSoluId);
                FormulaSoluInfo formulaSoluInfo = formulaSoluMap.get(formulaSoluId);
                List comIds = (List)dispensedCompanyIds.get(formulaSoluId);
                isCover = !formulaSoluDispenseInfo.isIsCoverTmpFormula();
                isCoverUnLockCell = formulaSoluDispenseInfo.isIsCoverUnLockCell();
                String lastVersionNumber = this.getLastVersion(ctx, formulaSoluInfo);
                if (!isCover || lastVersionNumber == null) continue;
                FormulaSoluInfo lastVersionFormulaSoluInfo = this.getlastVersionFormulaSolu(ctx, formulaSoluInfo, lastVersionNumber);
                if (lastVersionFormulaSoluInfo != null) {
                    try {
                        preVerBook = lastVersionFormulaSoluInfo.getBook();
                    }
                    catch (Exception e) {
                        logger.error((Object)"updateSubCompanyTemplate", (Throwable)e);
                        throw new BOSException((Throwable)e);
                    }
                }
                if ((cacheSubTplVer = this.cacheSubCompanyTpl(ctx, lastVersionFormulaSoluInfo, comIds, lastVersionNumber)) == null || cacheSubTplVer != null && cacheSubTplVer.isEmpty()) continue;
                this.coverFormula(ctx, formulaSoluInfo, preVerBook, cacheSubTplVer, lastVersionNumber, isCover, isCoverUnLockCell);
            }
        }
    }

    private void coverFormula(Context ctx, FormulaSoluInfo formulaSoluInfo, Book preVerBook, Map<String, SubVersionInfo> cacheSubTplVer, String lastVersionNumber, boolean isCover, boolean isCoverUnLockCell) throws EASBizException, BOSException {
        for (String companyId : cacheSubTplVer.keySet()) {
            SubVersionInfo info = cacheSubTplVer.get(companyId);
            String oql = "select data,CU,CU.id,Creator,Creator.id,Company,company.id where id ='" + info._subTplId + "'";
            TemplateInfo subPreVerTpl = TemplateFactory.getLocalInstance((Context)ctx).getTemplateInfo(oql);
            try {
                Book currVerBook = formulaSoluInfo.getBook();
                Book subPreVerBook = subPreVerTpl.getBook();
                currVerBook.setCalculate(false);
                subPreVerBook.setCalculate(false);
                this.coverBookFormula(preVerBook, subPreVerBook, currVerBook, isCoverUnLockCell);
                this.saveSubTemplate(ctx, formulaSoluInfo, IOHelper.packBook((Book)(isCoverUnLockCell ? currVerBook : subPreVerBook)), subPreVerTpl.getCompany(), subPreVerTpl.getCU(), subPreVerTpl.getCreator(), info._versionNum);
            }
            catch (Exception e) {
                logger.error((Object)"coverFormula", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
    }

    private void saveSubTemplate(Context ctx, FormulaSoluInfo formulaSoluInfo, byte[] data, FullOrgUnitInfo corg, CtrlUnitInfo cu, UserInfo crt, String subVersion) throws EASBizException, BOSException {
        TemplateInfo tpl = this.getTemplateInfo(ctx, formulaSoluInfo);
        int oldTempType = tpl.getTemplateType().getValue();
        TemplateInfo copy = (TemplateInfo)tpl.clone();
        BOSUuid oldId = tpl.getId();
        copy.setData(data);
        copy.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        copy.setNumber(tpl.getNumber());
        copy.setName(tpl.getName());
        copy.setPublishedStatus(PublishedStatusEnum.UNPUBLISHED);
        copy.setAuditor(null);
        copy.setAuditedTime(null);
        copy.setVersionNumber(this.getSubVersionNumber(formulaSoluInfo.getVersionNumber(), subVersion));
        copy.setId(null);
        TemplateInfo oldTemp = new TemplateInfo();
        oldTemp.setId(oldId);
        if (oldTempType == 10) {
            copy.setTemplateType(RptTmpTypeEnum.DYNAMICNORMALREPORT);
        } else if (oldTempType == 15) {
            copy.setTemplateType(RptTmpTypeEnum.MULTIDYNAMICCSLREPORT);
        } else {
            copy.setTemplateType(RptTmpTypeEnum.GROUPCOMMREPORT);
        }
        copy.setGroupTemplate(oldTemp);
        copy.setCreator(crt);
        copy.setCreateTime(new Timestamp(Calendar.getInstance().getTimeInMillis()));
        copy.setPublishedStatus(PublishedStatusEnum.UNPUBLISHED);
        copy.setVersionStatus(VersionStatusEnum.CREATED);
        copy.setIsChangeByTemplate(true);
        copy.getOrgSavePoint().clear();
        copy.setCompany(corg);
        copy.setCU(cu);
        copy.setTemplateSource(TemplateSourceEnum.GRADETEMPLATE);
        IObjectPK pk = TemplateFactory.getLocalInstance((Context)ctx).submit((CoreBaseInfo)copy);
        TemplateFactory.getLocalInstance((Context)ctx).audit(pk);
    }

    private String getSubVersionNumber(String soluVersion, String subVersion) {
        String l = subVersion.substring(subVersion.lastIndexOf(".") + 1, subVersion.length());
        return soluVersion + "." + l;
    }

    private TemplateInfo getTemplateInfo(Context ctx, FormulaSoluInfo formulaSoluInfo) throws EASBizException, BOSException {
        String tplId = this.getLastestTemplateId(ctx, formulaSoluInfo);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("sheetParam.*");
        return TemplateFactory.getLocalInstance((Context)ctx).getTemplateInfo((IObjectPK)new ObjectUuidPK(tplId), selector);
    }

    private String getLastestTemplateId(Context ctx, FormulaSoluInfo formulaSoluInfo) throws EASBizException, BOSException {
        String tplGroupId = formulaSoluInfo.getTemplateGroupId();
        TemplateInfo template = TemplateFactory.getLocalInstance((Context)ctx).getTemplateInfo("select id where group = '" + tplGroupId + "' and versionStatus =" + 1 + " and isFreezed = 0 and isK3Tpl = 0 and groupTemplate is null");
        return template.getId().toString();
    }

    private void coverBookFormula(Book preVerBook, Book subPreVerBook, Book currVerBook, boolean isCoverUnLockCell) {
        for (int i = 0; i < currVerBook.getSheetCount(); ++i) {
            int maxr;
            Sheet currVerSheet = currVerBook.getSheet(i);
            boolean isLocked = false;
            SheetOption sheetOption = currVerSheet.getSheetOption();
            Protection protection = sheetOption.getProtection(false);
            isLocked = protection != null && protection.isProtected();
            Sheet subPreVerSheet = subPreVerBook.getSheet(currVerSheet.getSheetName());
            Sheet preVerSheet = preVerBook.getSheet(currVerSheet.getSheetName());
            if (subPreVerSheet == null || preVerSheet == null) continue;
            int maxc = subPreVerSheet.getMaxColIndex() > preVerSheet.getMaxColIndex() ? subPreVerSheet.getMaxColIndex() : preVerSheet.getMaxColIndex();
            int n = maxr = subPreVerSheet.getMaxRowIndex() > preVerSheet.getMaxRowIndex() ? subPreVerSheet.getMaxRowIndex() : preVerSheet.getMaxRowIndex();
            if (subPreVerSheet.getCell(0, 0, false) != null) {
                currVerSheet.getCell(0, 0, true).setUserObject("curDataCollectType", subPreVerSheet.getCell(0, 0, false).getUserObjectValue("curDataCollectType"));
            }
            for (int r = 0; r <= maxr; ++r) {
                for (int c = 0; c <= maxc; ++c) {
                    Cell subPreVerCell = subPreVerSheet.getCell(r, c, false);
                    Cell preVerCell = preVerSheet.getCell(r, c, false);
                    Cell currVerCell = currVerSheet.getCell(r, c, true);
                    String currVerFormula = "";
                    if (currVerCell != null) {
                        currVerFormula = currVerCell.getFormula() == null ? "" : currVerCell.getFormula();
                    }
                    String subPreVerFormula = "";
                    if (subPreVerCell != null) {
                        String string = subPreVerFormula = subPreVerCell.getFormula() == null ? "" : subPreVerCell.getFormula();
                    }
                    if (!this.hasBizFormula(currVerFormula) && !this.hasBizFormula(subPreVerFormula) && isCoverUnLockCell) continue;
                    String preVerFormula = "";
                    if (preVerCell != null) {
                        String string = preVerFormula = preVerCell.getFormula() == null ? "" : preVerCell.getFormula();
                    }
                    if (!subPreVerFormula.equals(preVerFormula) && isCoverUnLockCell) {
                        boolean needCover = false;
                        if (subPreVerFormula.trim().length() > 0 && this.hasBizFormula(subPreVerFormula)) {
                            needCover = true;
                        }
                        if (!needCover && preVerFormula.trim().length() > 0 && this.hasBizFormula(preVerFormula)) {
                            needCover = true;
                        }
                        if (!needCover || subPreVerCell == null) continue;
                        currVerSheet.getCell(r, c, true).setFormula(subPreVerCell.getFormula());
                        currVerSheet.removeUserObject("0");
                        currVerSheet.removeUserObject("1");
                        if (subPreVerCell.getUserObjectValue("0") != null) {
                            currVerSheet.getCell(r, c, true).setUserObject("0", subPreVerCell.getUserObjectValue("0"));
                        }
                        if (subPreVerCell.getUserObjectValue("1") == null) continue;
                        currVerSheet.getCell(r, c, true).setUserObject("1", subPreVerCell.getUserObjectValue("1"));
                        continue;
                    }
                    if (isCoverUnLockCell || !isLocked || !currVerSheet.getCell(r, c, true).isLocked() || !subPreVerFormula.equals(preVerFormula)) continue;
                    subPreVerCell = subPreVerSheet.getCell(r, c, true);
                    subPreVerCell.setFormula(currVerCell.getFormula());
                    if (currVerCell.getUserObjectValue("0") != null) {
                        subPreVerCell.setUserObject("0", currVerCell.getUserObjectValue("0"));
                    } else {
                        subPreVerCell.removeUserObject("0");
                    }
                    if (currVerCell.getUserObjectValue("1") != null) {
                        subPreVerCell.setUserObject("1", currVerCell.getUserObjectValue("1"));
                        continue;
                    }
                    subPreVerCell.removeUserObject("1");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, SubVersionInfo> cacheSubCompanyTpl(Context ctx, FormulaSoluInfo formulaSoluInfo, List<String> comIds, String lastVersionNumber) throws BOSException {
        HashMap<String, SubVersionInfo> cacheMap = new HashMap<String, SubVersionInfo>();
        RptTmpTypeEnum tplType = formulaSoluInfo.getTemplateType();
        boolean isMulti = tplType.equals((Object)RptTmpTypeEnum.MULTIDYNAMICCSLREPORT) || tplType.equals((Object)RptTmpTypeEnum.MULTIRPTDYNAMICREPORT);
        boolean isDyna = tplType.equals((Object)RptTmpTypeEnum.DYNAMICNORMALREPORT) || tplType.equals((Object)RptTmpTypeEnum.RPTDYNAMICREPORT);
        Integer templateType = null;
        templateType = isMulti ? new Integer(16) : (isDyna ? new Integer(12) : new Integer(2));
        String vnumber = lastVersionNumber + ".%";
        String tplGroupId = formulaSoluInfo.getTemplateGroupId();
        ParamTempTblService paramsrv = null;
        try {
            TableInfo table = new TableInfo("T_FS_COMPANY001");
            table.addColumn("companyID");
            paramsrv = new ParamTempTblService(ctx, table, comIds, null);
            StringBuffer sql = new StringBuffer();
            sql.append(" select t1.FID,t1.FCompanyID,t1.FVersionNumber from T_RPT_Template t1  \n").append(" join (").append(" select FCompanyID,max(FlastupdateTime)FlastupdateTime from T_RPT_Template  \n").append(" where FGroup = ? and  FtemplateType = ? and FauditedStatus = ? and FTemplateSource = ? \n").append(" and FversionNumber like '").append(vnumber).append("'").append(" and FCompanyID in(").append(paramsrv.getParamsSql()).append(") \n").append(" group by FCompanyID ) t2 \n").append(" on t1.FCompanyID = t2.FCompanyID and t1.FlastupdateTime = t2.FlastupdateTime \n").append(" where t1.FGroup = ? and  t1.FtemplateType = ? and t1.FauditedStatus = ? and t1.FTemplateSource = ? \n ").append(" and t1.FversionNumber like '").append(vnumber).append("'").append(" and t1.FCompanyID in(").append(paramsrv.getParamsSql()).append(") \n");
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(tplGroupId);
            params.add(templateType);
            params.add(new Integer(2));
            params.add(new Integer(1));
            params.add(tplGroupId);
            params.add(templateType);
            params.add(new Integer(2));
            params.add(new Integer(1));
            IRowSet rs = DbUtil.executeQuery(ctx, sql.toString(), params.toArray());
            if (rs == null || rs.size() == 0) {
                HashMap<String, SubVersionInfo> hashMap = cacheMap;
                return hashMap;
            }
            try {
                while (rs.next()) {
                    cacheMap.put(rs.getString("FCompanyID"), new SubVersionInfo(rs.getString("FID"), rs.getString("FVersionNumber")));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        finally {
            if (paramsrv != null) {
                paramsrv.release();
            }
        }
        return cacheMap;
    }

    private FormulaSoluInfo getlastVersionFormulaSolu(Context ctx, FormulaSoluInfo formulaSoluInfo, String lastVersionNumber) throws BOSException {
        String fomulaSoluNumber = formulaSoluInfo.getNumber();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("*"));
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)fomulaSoluNumber));
        view.getFilter().getFilterItems().add(new FilterItemInfo("versionNumber", (Object)lastVersionNumber));
        FormulaSoluCollection coll = FormulaSoluFactory.getLocalInstance(ctx).getFormulaSoluCollection(view);
        if (coll != null && !coll.isEmpty()) {
            FormulaSoluInfo lastVersionFormulaSoluInfo = coll.get(0);
            return lastVersionFormulaSoluInfo;
        }
        return null;
    }

    private String getLastVersion(Context ctx, FormulaSoluInfo formulaSoluInfo) throws EASBizException, BOSException {
        String lastVersionNumber = null;
        String versionNumber = formulaSoluInfo.getVersionNumber();
        String number = formulaSoluInfo.getNumber();
        String[] nums = versionNumber.split("\\.");
        int l = Integer.valueOf(nums[0]);
        int r = Integer.valueOf(nums[1]);
        int subl = l - 1;
        int subr = r - 1;
        boolean isExist = false;
        if (subl > 0) {
            lastVersionNumber = subl + "." + r;
            isExist = FormulaSoluFactory.getLocalInstance(ctx).exists("select id where number = '" + number + "' and versionNumber = '" + lastVersionNumber + "'");
        }
        if (!isExist && subr > 0) {
            lastVersionNumber = l + "." + subr;
            isExist = FormulaSoluFactory.getLocalInstance(ctx).exists("select id where number = '" + number + "' and versionNumber = '" + lastVersionNumber + "'");
        }
        return lastVersionNumber;
    }

    private void getFormulaSoluDispense(Context ctx, List companyIds, List soluIds, Map<String, List<String>> dispensedCompanyIds, Map<String, FormulaSoluDispenseInfo> dispensedInfo) throws BOSException {
        FormulaSoluDispenseCollection coll = this.getFormulaSoluCollectionByIds(ctx, companyIds, soluIds);
        if (coll != null && !coll.isEmpty()) {
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                List<Object> ids;
                FormulaSoluDispenseInfo formulaSoluDispenseInfo = (FormulaSoluDispenseInfo)it.next();
                String formulaSoluId = formulaSoluDispenseInfo.getFormulaSoluId();
                String dispensedCompanyId = formulaSoluDispenseInfo.getCompany().getId().toString();
                if (!dispensedInfo.containsKey(formulaSoluId)) {
                    dispensedInfo.put(formulaSoluId, formulaSoluDispenseInfo);
                }
                if (dispensedCompanyIds.containsKey(formulaSoluId)) {
                    ids = dispensedCompanyIds.get(formulaSoluId);
                    ids.add(dispensedCompanyId);
                    continue;
                }
                ids = new ArrayList();
                ids.add(dispensedCompanyId);
                dispensedCompanyIds.put(formulaSoluId, ids);
            }
        }
    }

    private Map<String, FormulaSoluInfo> getFormulaSoluMap(Context ctx, List soluIds) throws BOSException {
        HashMap<String, FormulaSoluInfo> map = new HashMap<String, FormulaSoluInfo>();
        HashSet soluSet = new HashSet(soluIds);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", soluSet, CompareType.INCLUDE));
        view.setFilter(filter);
        FormulaSoluCollection coll = FormulaSoluFactory.getLocalInstance(ctx).getFormulaSoluCollection(view);
        if (coll != null && !coll.isEmpty()) {
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                FormulaSoluInfo info = (FormulaSoluInfo)it.next();
                map.put(info.getId().toString(), info);
            }
        }
        return map;
    }

    private FormulaSoluDispenseCollection getFormulaSoluCollectionByIds(Context ctx, List<String> companyIds, List<String> soluIds) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<String> soluSet = new HashSet<String>(soluIds);
        filter.getFilterItems().add(new FilterItemInfo("formulaSoluId", soluSet, CompareType.INCLUDE));
        if (companyIds != null) {
            HashSet<String> companySet = new HashSet<String>(companyIds);
            filter.getFilterItems().add(new FilterItemInfo("company", companySet, CompareType.INCLUDE));
        }
        view.setFilter(filter);
        return FormulaSoluDispenseFactory.getLocalInstance(ctx).getFormulaSoluDispenseCollection(view);
    }

    private boolean hasBizFormula(String str) {
        try {
            if (org.apache.commons.lang.StringUtils.isEmpty((String)str) || str.trim().charAt(0) != '=') {
                return false;
            }
            this.initMethodSet();
            Expression exp = ExcelFormulaPaserHelper.parse((String)str);
            BizFormulaHandler handler = new BizFormulaHandler();
            ExcelFormulaPaserHelper.walk((Expression)exp, (IBreakableExpressionHandler)handler);
            return handler.hasBizFormula();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void initMethodSet() {
        if (this.methodSet != null) {
            return;
        }
        this.methodSet = new HashSet();
        this.methodSet.add("sum");
        this.methodSet.add("if");
        this.methodSet.add("and");
        this.methodSet.add("abs");
        this.methodSet.add("max");
        this.methodSet.add("min");
        this.methodSet.add("not");
        this.methodSet.add("or");
        this.methodSet.add("subtotal");
        this.methodSet.add("sumif");
        this.methodSet.add("acctname");
        this.methodSet.add("basicCurrency");
        this.methodSet.add("csref");
        this.methodSet.add("dholding");
        this.methodSet.add("exchangerate");
        this.methodSet.add("getcurrency");
        this.methodSet.add("getorgename");
        this.methodSet.add("getorgname");
        this.methodSet.add("getorgtree");
        this.methodSet.add("rptdate");
        this.methodSet.add("rptname");
        this.methodSet.add("stdcur");
    }

    @Override
    protected void _dispenseNewVersion(Context ctx, String tmplId, Map params) throws BOSException, EASBizException {
        try {
            TemplateInfo tpl = TemplateFactory.getLocalInstance((Context)ctx).getTemplateInfo("select templateType,group,data where id = '" + tmplId + "'");
            String groupId = tpl.getGroup();
            Book tplBook = tpl.getBook();
            int tplType = tpl.getTemplateType().getValue();
            FormulaSoluCollection solus = FormulaSoluFactory.getLocalInstance(ctx).getFormulaSoluCollection("where templateGroupId = '" + groupId + "' and versionStatus = " + 1 + "");
            if (solus != null && !solus.isEmpty()) {
                Iterator it = solus.iterator();
                Book currVerBook = null;
                boolean isCoverUnLockCell = Boolean.valueOf(String.valueOf(params.get("isCoverUnLockCell")));
                if (isCoverUnLockCell) {
                    while (it.hasNext()) {
                        FormulaSoluInfo solu = (FormulaSoluInfo)it.next();
                        currVerBook = solu.getBook();
                        FormulaSoluCalcHelp.getInstance().replaceCellContentBySolu(tplBook, currVerBook);
                        FormulaSoluCalcHelp.getInstance().synCheckSolution(tplBook, currVerBook);
                        this.addNewVersionFormulaSolu(ctx, solu, tmplId, IOHelper.packBook((Book)tplBook));
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"_dispenseNewVersion: ", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void addNewVersionFormulaSolu(Context ctx, FormulaSoluInfo solu, String tplId, byte[] data) throws EASBizException, BOSException {
        FormulaSoluInfo copy = (FormulaSoluInfo)solu.clone();
        copy.setId(null);
        copy.setData(data);
        copy.setTemplateId(tplId);
        copy.setCreateTime(null);
        copy.setCreator(null);
        copy.setLastUpdateTime(null);
        copy.setLastUpdateUser(null);
        copy.setIsAutoUpdate(true);
        copy.setVersionStatus(VersionStatusEnum.CREATED);
        copy.setAuditor(null);
        copy.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        copy.setVersionNumber(this.getNewVersionNumber(solu));
        IObjectPK pk = FormulaSoluFactory.getLocalInstance(ctx).submit((CoreBaseInfo)copy);
        FormulaSoluFactory.getLocalInstance(ctx).audit(pk.toString());
    }

    private String getNewVersionNumber(FormulaSoluInfo solu) {
        String verNumber = solu.getVersionNumber();
        String[] nums = verNumber.split("\\.");
        String l = nums[0];
        String r = nums[1];
        int lv = Integer.valueOf(l);
        return ++lv + "." + r;
    }

    @Override
    protected void _dispense_log(Context ctx, IObjectValue formulaSolu) throws BOSException {
    }

    @Override
    protected void _undispense_log(Context ctx, IObjectValue formulaSolu) throws BOSException {
    }

    private final class BizFormulaHandler
    implements IBreakableExpressionHandler {
        private boolean bHasBizFormula = false;

        private BizFormulaHandler() {
        }

        public boolean handle(Expression expr) {
            if (this.bHasBizFormula) {
                return false;
            }
            if (expr instanceof FunctionExpr) {
                String funcionName = ((FunctionExpr)expr).funcionName;
                if (!FormulaSoluDispenseControllerBean.this.methodSet.contains(funcionName.toLowerCase())) {
                    this.bHasBizFormula = true;
                    return false;
                }
                if ("acctname".equalsIgnoreCase(funcionName.toLowerCase())) {
                    this.bHasBizFormula = false;
                    return true;
                }
            }
            this.bHasBizFormula = false;
            return true;
        }

        public boolean hasBizFormula() {
            return this.bHasBizFormula;
        }
    }

    private class SubVersionInfo {
        protected String _subTplId;
        protected String _versionNum;

        public SubVersionInfo(String subTplId, String versionNum) {
            this._subTplId = subTplId;
            this._versionNum = versionNum;
        }
    }
}

