/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.image;

import com.kingdee.bos.ctrl.common.util.FontUtil;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.embed.HotSpot;
import com.kingdee.bos.ctrl.excel.model.struct.embed.RectEmbedment;
import com.kingdee.bos.ctrl.excel.util.KDSDataInputStream;
import com.kingdee.bos.ctrl.excel.util.KDSDataOutputStream;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.newrpt.image.DynamicAccessImageModel;
import com.kingdee.eas.fi.newrpt.image.EmbedImageType;
import com.kingdee.eas.fi.newrpt.image.EmbededImageModel;
import com.kingdee.eas.fi.newrpt.image.IImageModel;
import com.kingdee.eas.fi.newrpt.image.StaticURLImageModel;
import com.kingdee.eas.util.client.EASResource;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class EmbedImage
extends RectEmbedment
implements ImageObserver {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.client.designer.image.EmbedImage");
    private static String resource = "com.kingdee.eas.fi.newrpt.client.designer.DesignerResource";
    private IImageModel _model;
    private static final Color _color = new Color(77, 115, 153);
    private EmbedImageType _type;
    private BufferedImage _eclipse;
    private BufferedImage _rectangle;
    private Point _position;
    static final byte ID_End = 0;
    static final byte ID_ImgeURL = 1;
    static final byte ID_ImageType = 2;
    static final byte ID_Image_Data_Length = 3;
    static final byte ID_Image_Data = 4;
    static final byte ID_Image_Dragable = 5;
    private static Color dark = new Color(148, 148, 148);
    private static Color light = new Color(243, 243, 243);
    private static Color outline = new Color(43, 43, 43);
    private BufferedImage noImage;
    private boolean aborted;
    private boolean dragedEnable = false;

    public EmbedImage(Sheet sheet, IImageModel model) {
        super(sheet);
        this._model = model;
        if (this.getType() == EmbedImageType.Static_Embed_Image) {
            this.dragedEnable = true;
        }
    }

    public EmbedImage(Sheet sheet) {
        this(sheet, null);
    }

    public void setDragedEnable(boolean draged) {
        this.dragedEnable = draged;
    }

    public boolean isDragEnable() {
        if (this.getType() != EmbedImageType.Static_Embed_Image) {
            return this.dragedEnable;
        }
        this.dragedEnable = true;
        return true;
    }

    public void paintData(Graphics g) {
        Image image;
        Graphics2D g2d;
        block6: {
            g2d = (Graphics2D)g;
            if (this._model == null) {
                return;
            }
            image = null;
            try {
                image = this._model.getImage();
            }
            catch (IOException e) {
                if (!MiscUtil.shouldLog()) break block6;
                MiscUtil.log((int)4, (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"128_EmbedImage"));
                MiscUtil.log((Throwable)e);
            }
        }
        Rectangle rect = this.getBounds();
        if (image == null) {
            if (rect.height == Integer.MAX_VALUE && rect.width == Integer.MAX_VALUE) {
                rect.height = 100;
                rect.width = 100;
                this.setBounds(rect);
            }
            this.drawNoImage(g2d, rect);
            return;
        }
        if (rect.height == Integer.MAX_VALUE && rect.width == Integer.MAX_VALUE) {
            rect.width = image.getWidth(null);
            rect.height = image.getHeight(null);
            this.setBounds(rect);
        }
        this.aborted = false;
        this.preLoadImage(SwingUtilities.isEventDispatchThread());
        g2d.drawImage(image, rect.x, rect.y, rect.width, rect.height, this);
    }

    public void preLoadImage(boolean flag) {
        if (!flag) {
            return;
        }
        Image image = null;
        try {
            image = this._model.getImage();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (image != null && image.getClass().getName().equals("sun.awt.image.ToolkitImage")) {
            try {
                for (int index = 0; index < 1000; ++index) {
                    image.getClass().getMethod("preload", ImageObserver.class).invoke((Object)image, new Object[]{null});
                }
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }

    public IImageModel getModel() {
        return this._model;
    }

    private void drawNoImage(Graphics2D g2d, Rectangle rect) {
        g2d.setColor(Color.WHITE);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.fillRect(rect.x, rect.y, rect.width, rect.height);
        g2d.setColor(Color.BLACK);
        g2d.drawRect(rect.x, rect.y, rect.width, rect.height);
        if (this.noImage == null) {
            this.noImage = this.getNoImageAvailableImage();
        }
        g2d.drawImage(this.noImage, rect.x, rect.y, rect.width, rect.height, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BufferedImage getNoImageAvailableImage() {
        Font f;
        FontRenderContext frc;
        Graphics2D g2;
        BufferedImage bufferedImage;
        Rectangle rect;
        block15: {
            int i;
            String[] fontnames22;
            rect = this.getBounds();
            bufferedImage = new BufferedImage(rect.width, rect.height / 2, 2);
            g2 = (Graphics2D)bufferedImage.getGraphics();
            frc = g2.getFontRenderContext();
            f = null;
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(new File(System.getProperty("eas.properties.dir") + "/simsun.ttc"));
                f = Font.createFont(0, inputStream);
                f = f.deriveFont(1, (float)rect.width / 5.0f);
            }
            catch (FileNotFoundException fontnames) {
                CslRptUtil.close(inputStream);
                if (f != null) break block15;
                fontnames22 = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
                for (i = 0; i < fontnames22.length; ++i) {
                    if (!FontUtil.isChineseDrawable((Font)new Font(fontnames22[i], 0, 12))) continue;
                    f = new Font(fontnames22[i], 1, rect.width / 5);
                    break block15;
                }
                break block15;
                catch (FontFormatException fontnames22) {
                    CslRptUtil.close(inputStream);
                    if (f != null) break block15;
                    fontnames22 = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
                    for (i = 0; i < fontnames22.length; ++i) {
                        if (!FontUtil.isChineseDrawable((Font)new Font(fontnames22[i], 0, 12))) continue;
                        f = new Font(fontnames22[i], 1, rect.width / 5);
                        break block15;
                    }
                    break block15;
                    catch (IOException fontnames3) {
                        CslRptUtil.close(inputStream);
                        if (f != null) break block15;
                        fontnames22 = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
                        for (i = 0; i < fontnames22.length; ++i) {
                            if (!FontUtil.isChineseDrawable((Font)new Font(fontnames22[i], 0, 12))) continue;
                            f = new Font(fontnames22[i], 1, rect.width / 5);
                            break block15;
                        }
                        break block15;
                        catch (Throwable throwable) {
                            CslRptUtil.close(inputStream);
                            if (f != null) throw throwable;
                            String[] fontnames4 = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
                            int i2 = 0;
                            while (i2 < fontnames4.length) {
                                if (FontUtil.isChineseDrawable((Font)new Font(fontnames4[i2], 0, 12))) {
                                    f = new Font(fontnames4[i2], 1, rect.width / 5);
                                    throw throwable;
                                }
                                ++i2;
                            }
                            throw throwable;
                        }
                    }
                }
            }
            CslRptUtil.close((Object)inputStream);
            if (f == null) {
                fontnames22 = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
                for (i = 0; i < fontnames22.length; ++i) {
                    if (!FontUtil.isChineseDrawable((Font)new Font(fontnames22[i], 0, 12))) continue;
                    f = new Font(fontnames22[i], 1, rect.width / 5);
                    break;
                }
            }
        }
        String s = new String(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"129_EmbedImage"));
        TextLayout tl = new TextLayout(s, f, frc);
        AffineTransform transform = new AffineTransform();
        transform.setToTranslation(0.0, rect.height / 2);
        Shape shape = tl.getOutline(transform);
        Rectangle r = shape.getBounds();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        GradientPaint p = new GradientPaint(r.x, r.y, outline, r.x, r.y + r.height, light);
        g2.setPaint(p);
        g2.fill(shape);
        g2.setColor(dark);
        g2.draw(shape);
        g2.setClip(shape);
        bufferedImage = this.createReflection(bufferedImage);
        int x = rect.width - r.width / 2 + rect.x;
        int y = rect.height - r.height / 2 + rect.y;
        g2.drawImage((Image)bufferedImage, x - 2, y - 2, null);
        g2.dispose();
        return bufferedImage;
    }

    private BufferedImage createReflection(BufferedImage image) {
        int height = image.getHeight();
        BufferedImage result = new BufferedImage(image.getWidth(), height * 2, 2);
        Graphics2D g2 = result.createGraphics();
        g2.drawImage((Image)image, 0, 0, null);
        g2.scale(1.0, -1.0);
        g2.drawImage((Image)image, 0, -height - height, null);
        g2.scale(1.0, -1.0);
        g2.translate(0, height);
        GradientPaint mask = new GradientPaint(0.0f, 0.0f, new Color(1.0f, 1.0f, 1.0f, 0.5f), 0.0f, height / 2, new Color(1.0f, 1.0f, 1.0f, 0.0f));
        g2.setPaint(mask);
        g2.setComposite(AlphaComposite.DstIn);
        g2.fillRect(0, 0, image.getWidth(), height);
        g2.dispose();
        return result;
    }

    public void paintFocus(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(_color);
        g2d.setStroke(new BasicStroke(1.0f));
        Rectangle rect = this.getBounds();
        g2d.drawRect(rect.x, rect.y, rect.width, rect.height);
        if (!this.isDragEnable()) {
            return;
        }
        this.initHotspot();
        HotSpot[] hotspots = this.getHotSpots();
        for (int i = 0; i < hotspots.length; ++i) {
            HotSpot hotSpot = hotspots[i];
            if (hotSpot.getType() <= 4) {
                g2d.drawImage((Image)this._eclipse, hotSpot.getX() - 4, hotSpot.getY() - 4, null);
                continue;
            }
            g2d.drawImage((Image)this._rectangle, hotSpot.getX() - 3, hotSpot.getY() - 3, null);
        }
    }

    private void initHotspot() {
        Graphics2D g2d;
        if (this._eclipse != null && this._rectangle != null) {
            return;
        }
        Color dark = new Color(202, 234, 237);
        Color light = new Color(246, 255, 255);
        if (this._eclipse == null) {
            this._eclipse = new BufferedImage(9, 9, 2);
            g2d = this._eclipse.createGraphics();
            Color lineColor = new Color(119, 126, 135);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            GradientPaint p = new GradientPaint(0.0f, 0.0f, light, 8.0f, 8.0f, dark);
            Ellipse2D.Double s = new Ellipse2D.Double(0.0, 0.0, 8.0, 8.0);
            g2d.setPaint(p);
            g2d.setColor(light);
            g2d.fill(s);
            g2d.setColor(lineColor);
            g2d.draw(s);
            g2d.dispose();
        }
        if (this._rectangle == null) {
            this._rectangle = new BufferedImage(7, 7, 2);
            g2d = this._rectangle.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            GradientPaint p = new GradientPaint(0.0f, 0.0f, light, 6.0f, 6.0f, dark);
            Rectangle2D.Double s = new Rectangle2D.Double(0.0, 0.0, 6.0, 6.0);
            g2d.setColor(light);
            g2d.setPaint(p);
            g2d.fill(s);
            g2d.setColor(_color);
            g2d.draw(s);
            g2d.dispose();
        }
    }

    protected byte[] saveCustom() {
        EmbedImageType type = this.getType();
        if (type == EmbedImageType.Dynamic_Embed_Image) {
            return new byte[0];
        }
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        KDSDataOutputStream out = new KDSDataOutputStream((OutputStream)bs);
        try {
            out.writeString("1.0");
            if (type == EmbedImageType.Embeded_Image) {
                byte[] data;
                String str = "Embeded_Image";
                out.writeByte(2);
                out.writeString(str);
                EmbededImageModel model = (EmbededImageModel)this._model;
                if (model != null && (data = model.getImageData()) != null) {
                    out.writeByte(3);
                    out.writeInt(data.length);
                    out.writeByte(4);
                    out.write(data);
                    out.writeByte(5);
                    out.writeBoolean(this.dragedEnable);
                }
            } else {
                URL url;
                StaticURLImageModel model = (StaticURLImageModel)this._model;
                String str = "Static_Embed_Image";
                out.writeByte(2);
                out.writeString(str);
                if (model != null && (url = model.getUrl()) != null) {
                    str = url.toString();
                    out.writeByte(1);
                    out.writeString(str);
                    out.writeByte(5);
                    out.writeBoolean(this.dragedEnable);
                }
            }
            out.writeByte(0);
            out.close();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage());
        }
        return bs.toByteArray();
    }

    protected void loadCustom(byte[] str) {
        if (str == null || str.length == 0) {
            return;
        }
        try {
            KDSDataInputStream is = new KDSDataInputStream((InputStream)new ByteArrayInputStream(str));
            String ver = is.readString();
            if (ver.equals("1.0")) {
                byte id;
                block7: while ((id = is.readByte()) != 0) {
                    switch (id) {
                        case 2: {
                            String type = is.readString().trim();
                            if (type == null) break block7;
                            if (type.equals("Static_Embed_Image")) {
                                this._model = new StaticURLImageModel();
                                continue block7;
                            }
                            if (!type.equals("Embeded_Image")) continue block7;
                            this._model = new EmbededImageModel();
                            continue block7;
                        }
                        case 1: {
                            ((StaticURLImageModel)this._model).setUrl(new URL(is.readString()));
                            is.readByte();
                            this.setDragedEnable(is.readBoolean());
                            break block7;
                        }
                        case 3: {
                            int length = is.readInt();
                            if (length > 0) {
                                byte[] data = new byte[length];
                                is.readByte();
                                is.read(data);
                                ((EmbededImageModel)this._model).setImageData(data);
                            }
                            is.readByte();
                            this.setDragedEnable(is.readBoolean());
                            break block7;
                        }
                    }
                }
            }
            is.close();
        }
        catch (IOException ioe) {
            logger.error((Object)ioe);
        }
    }

    public EmbedImageType getType() {
        if (this._model != null) {
            if (this._model instanceof DynamicAccessImageModel) {
                this._type = EmbedImageType.Dynamic_Embed_Image;
                return this._type;
            }
            if (this._model instanceof StaticURLImageModel) {
                this._type = EmbedImageType.Static_Embed_Image;
                return this._type;
            }
            if (this._model instanceof EmbededImageModel) {
                this._type = EmbedImageType.Embeded_Image;
                return this._type;
            }
        }
        return null;
    }

    public Image getImage() throws IOException {
        return this._model.getImage();
    }

    public void _placeImageAt(Point position) {
        this._position = position;
    }

    public Point getPlacePosition() {
        return this._position;
    }

    public void _revalidate() {
        if (this._position != null) {
            this.setBounds(SheetBaseMath.getActualCellRect((Sheet)this._sheet, (int)((int)this._position.getX()), (int)((int)this._position.getY()), (boolean)false));
        }
    }

    public void setModel(IImageModel newModel) {
        this._model = newModel;
        this.noImage = null;
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if (this.aborted || (infoflags & 0x80) != 0) {
            this.aborted = true;
            return !true;
        }
        return true;
    }
}

