/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.image;

import com.kingdee.bos.ctrl.ext.ui.wizards.pic.ImageUtils;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.eas.fi.newrpt.image.AbstractImageModel;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class StaticURLImageModel
extends AbstractImageModel {
    private URL _url;

    public StaticURLImageModel() {
    }

    public StaticURLImageModel(URL url) {
        this._url = url;
    }

    @Override
    public Image getImage() throws IOException {
        if (this._url == null) {
            return null;
        }
        Image image = null;
        if (this.contain(this._url)) {
            image = (Image)this.get(this._url);
            return image;
        }
        if (ImageUtils.checkURL((URL)this._url)) {
            if (this._url.getProtocol().equals("file")) {
                short time = 10;
                image = CtrlSwingUtilities.readImgFromFile((String)this._url.toString().substring(6), (short)time);
            } else {
                image = Toolkit.getDefaultToolkit().createImage(this._url);
            }
            this.loadEnsured(image);
        } else {
            image = null;
        }
        this.add(this._url, image);
        return image;
    }

    @Override
    public byte[] getImageData() throws IOException {
        if (this._url == null) {
            return null;
        }
        try (InputStream in = null;){
            in = this._url.openStream();
            int contentLength = this._url.openConnection().getContentLength();
            byte[] imageData = new byte[contentLength];
            for (int counter = 0; counter < contentLength; counter += in.read(imageData, counter, imageData.length - counter)) {
            }
            in.read(imageData);
            byte[] byArray = imageData;
            return byArray;
        }
    }

    @Override
    public void dispose() {
        this.discard(this._url);
    }

    public void setUrl(URL imageUrl) {
        this._url = imageUrl;
    }

    public URL getUrl() {
        return this._url;
    }
}

