/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.investworkpaper.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorResultProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CSLPropertyAdapter;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateInfo;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.fi.newrpt.investworkpaper.SceneInfo;
import com.kingdee.eas.fi.newrpt.investworkpaper.TriggerConditionEntryCollection;
import com.kingdee.eas.fi.newrpt.investworkpaper.TriggerConditionEntryFactory;
import com.kingdee.eas.fi.newrpt.investworkpaper.TriggerConditionEntryInfo;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.util.client.EASResource;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CheckTriggerConditionFormulaUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.investworkpaper.app.CheckTriggerConditionFormulaUtil");
    private Context ctx = null;
    private List<SceneInfo> scenes = null;
    private List<ElimInvestRateInfo> rates = null;
    private String cslReportId = null;
    private String activeSheetName = null;

    public CheckTriggerConditionFormulaUtil(Context ctx, List<SceneInfo> scenes, List<ElimInvestRateInfo> rates, String cslReportId, String activeSheetName) {
        this.ctx = ctx;
        this.scenes = scenes;
        this.rates = rates;
        this.cslReportId = cslReportId;
        this.activeSheetName = activeSheetName;
    }

    public Map<String, Boolean> getSceneFormulaValues() throws BOSException, EASBizException {
        if (this.rates == null || this.scenes == null) {
            return null;
        }
        CslReportInfo cslReportInfo = CslReportFactory.getLocalInstance((Context)this.ctx).getCslReportInfo((IObjectPK)new ObjectUuidPK(this.cslReportId), this.getSelector());
        TriggerConditionEntryCollection entrys = this.getTriggerConditionEntrys();
        Map<String, List<String[]>> tcFormulas = this.getTriggerConditionFormulas(entrys);
        HashMap<String, String> sceneFormulasMap = new HashMap<String, String>();
        for (ElimInvestRateInfo rate : this.rates) {
            String investCompanyId = rate.getCompany().getId().toString();
            String investCompanyNumber = rate.getCompany().getNumber();
            String investCompanyName = rate.getCompany().getName();
            String targetCompanyId = rate.getTargetCompany().getId().toString();
            String targetCompanyNumber = rate.getTargetCompany().getNumber();
            String targetCompanyName = rate.getTargetCompany().getName();
            String date = CslRptUtil.formatDatetimeForSql((Date)rate.getDate());
            for (SceneInfo scene : this.scenes) {
                String sceneId = scene.getId().toString();
                List<String[]> formulaList = tcFormulas.get(sceneId);
                String sceneFormula = this.getSceneFormulaString(formulaList, investCompanyNumber, investCompanyName, targetCompanyNumber, targetCompanyName, date, cslReportInfo);
                String key = investCompanyId + targetCompanyId + sceneId;
                sceneFormulasMap.put(key, sceneFormula);
            }
        }
        Map<String, Boolean> result = this.caculateFormulas(sceneFormulasMap, cslReportInfo);
        return result;
    }

    private Map<String, Boolean> caculateFormulas(Map<String, String> sceneFormulasMap, CslReportInfo cslReportInfo) throws EASBizException, BOSException {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        try {
            Book book = CheckTriggerConditionFormulaUtil.initBook(this.ctx, cslReportInfo, this.activeSheetName);
            Sheet sheet = book.getSheet(0);
            Set<String> keySet = sceneFormulasMap.keySet();
            Iterator<String> it = keySet.iterator();
            int row = 0;
            while (it.hasNext()) {
                String key = it.next();
                String formula = sceneFormulasMap.get(key);
                sheet.getRange(row, 0).setValue(new Variant((Object)key));
                sheet.getRange(row, 1).setFormula("=" + formula);
                ++row;
            }
            book.calc();
            for (int i = 0; i <= sheet.getMaxRowIndex(); ++i) {
                String key = sheet.getRange(i, 0).getValue().toString();
                Variant obj = sheet.getRange(i, 1).getValue();
                if (obj == null) continue;
                if (obj.getVt() == 8) {
                    try {
                        if (obj.booleanValue()) {
                            result.put(key, Boolean.TRUE);
                            continue;
                        }
                        result.put(key, Boolean.FALSE);
                    }
                    catch (SyntaxErrorException e) {
                        result.put(key, Boolean.FALSE);
                    }
                    continue;
                }
                if (!obj.isNumeric()) continue;
                try {
                    if (obj.toBigDecimal().compareTo(new BigDecimal(0)) > 0) {
                        result.put(key, Boolean.TRUE);
                        continue;
                    }
                    result.put(key, Boolean.FALSE);
                    continue;
                }
                catch (SyntaxErrorException e) {
                    result.put(key, Boolean.FALSE);
                }
            }
        }
        catch (Exception e1) {
            logger.error((Object)"caculateFormulas: ", (Throwable)e1);
        }
        return result;
    }

    public static Book initBook(final Context ctx, final CslReportInfo rptInfo, String activeSheetName) throws BOSException, EASBizException {
        Book book = null;
        try {
            book = Book.Manager.getNewBook((String)"Book", (int)1);
            book.getSheet(0).setName(activeSheetName);
            book.setCalculate(false);
            FormulaDefinition.registerFormulaToBook(book, new ICalculateContextProvider(){

                public Context getServerContext() {
                    return ctx;
                }

                public ReportVariables getReportVariables() {
                    ReportVariables v = null;
                    try {
                        Book book = rptInfo.getBook();
                        v = ReportVariables.loadFromBook((Book)book);
                        if (v == null) {
                            v = new ReportVariables();
                            v.storeToBook(book);
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)"getReportVariablesError: ", (Throwable)e);
                    }
                    VariableEntry variableEntry = new VariableEntry("Check_Permissioin", null);
                    variableEntry.setDescription(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"47_variableName"));
                    variableEntry.setValue(Boolean.toString(false));
                    variableEntry.setType(1);
                    v.addOrReplace(variableEntry);
                    return v;
                }

                public IReportPropertyAdapter getReportAdapter() {
                    CSLPropertyAdapter adapter = new CSLPropertyAdapter(rptInfo, ctx);
                    return adapter;
                }

                public IErrorProvider getErrorProvider() {
                    return null;
                }

                public IErrorResultProvider getErrorResultProvider() {
                    return null;
                }
            });
        }
        catch (Exception e) {
            logger.error((Object)"initBook: ", (Throwable)e);
        }
        return book;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("company.name");
        selector.add("company.number");
        selector.add("company.id");
        selector.add("currency.name");
        selector.add("currency.number");
        selector.add("currency.id");
        selector.add("orgTree.name");
        selector.add("orgTree.number");
        selector.add("orgTree.id");
        selector.add("orgUnit.name");
        selector.add("orgUnit.number");
        selector.add("orgUnit.id");
        selector.add("sheetParam.*");
        return selector;
    }

    private String getSceneFormulaString(List<String[]> formulaList, String investCompanyNumber, String investCompanyName, String targetCompanyNumber, String targetCompanyName, String date, CslReportInfo cslReportInfo) {
        if (formulaList == null || formulaList.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (String[] formulas : formulaList) {
            String formula = formulas[0];
            String className = formulas[1];
            if (className.indexOf("com.") > -1) {
                formula = this.calculateDefaultTriggerCondition(formula, className, investCompanyNumber, targetCompanyNumber, cslReportInfo);
            } else {
                if (formula.indexOf("@") > -1) {
                    int accessSource = Integer.valueOf(formulas[1]);
                    if (10 == accessSource) {
                        formula = formula.replaceAll("@", investCompanyNumber);
                    } else if (20 == accessSource) {
                        formula = formula.replaceAll("@", targetCompanyNumber);
                    }
                }
                if (formula.indexOf("{invCompanyName}") > -1) {
                    formula = formula.replaceAll("\\{invCompanyName\\}", investCompanyName);
                }
                if (formula.indexOf("{tarCompanyName}") > -1) {
                    formula = formula.replaceAll("\\{tarCompanyName\\}", targetCompanyName);
                }
                if (formula.indexOf("{invCompanyNum}") > -1) {
                    formula = formula.replaceAll("\\{invCompanyNum\\}", investCompanyNumber);
                }
                if (formula.indexOf("{tarCompanyNum}") > -1) {
                    formula = formula.replaceAll("\\{tarCompanyNum\\}", targetCompanyNumber);
                }
                if (formula.indexOf("{changeDate}") > -1) {
                    formula = formula.replaceAll("\\{changeDate\\}", date);
                }
                if (formula.indexOf("{orgTreeNum}") > -1) {
                    formula = formula.replaceAll("\\{orgTreeNum\\}", cslReportInfo.getOrgTree().getNumber());
                }
                if (formula.indexOf("{orgTreeId}") > -1) {
                    formula = formula.replaceAll("\\{orgTreeId\\}", cslReportInfo.getOrgTree().getId().toString());
                }
                if (formula.indexOf("{groupOrgUnitNum}") > -1) {
                    formula = formula.replaceAll("\\{groupOrgUnitNum\\}", cslReportInfo.getOrgUnit().getId().toString());
                }
                if (formula.indexOf("{groupOrgUnitId}") > -1) {
                    formula = formula.replaceAll("\\{groupOrgUnitId\\}", cslReportInfo.getOrgUnit().getId().toString());
                }
                if (formula.indexOf("{year}") > -1) {
                    formula = formula.replaceAll("\\{year\\}", String.valueOf(cslReportInfo.getYear()));
                }
                if (formula.indexOf("{period}") > -1) {
                    formula = formula.replaceAll("\\{period\\}", String.valueOf(cslReportInfo.getPeriod()));
                }
            }
            sb.append(formula);
        }
        String aFormula = sb.toString();
        return aFormula;
    }

    private String calculateDefaultTriggerCondition(String formula, String className, String investCompanyNumber, String targetCompanyNumber, CslReportInfo cslReportInfo) {
        try {
            Class<?> clazz = Class.forName(className);
            Method methodName = clazz.getMethod("execute", Context.class, Map.class);
            Map params = this.genParams(investCompanyNumber, targetCompanyNumber, cslReportInfo);
            boolean result = Boolean.valueOf(String.valueOf(methodName.invoke(clazz.newInstance(), this.ctx, params)));
            formula = formula.replaceAll(className, String.valueOf(result));
        }
        catch (Exception e) {
            logger.error((Object)"calculateDefaultTriggerCondition error: ", (Throwable)e);
        }
        return formula;
    }

    private Map genParams(String investCompanyNumber, String targetCompanyNumber, CslReportInfo cslReportInfo) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("cslReportId", this.cslReportId);
        params.put("orgTreeNumber", cslReportInfo.getOrgTree().getNumber());
        params.put("year", cslReportInfo.getYear());
        params.put("period", cslReportInfo.getPeriod());
        params.put("invCompanyNum", investCompanyNumber);
        params.put("tarCompanyNum", targetCompanyNumber);
        return params;
    }

    private TriggerConditionEntryCollection getTriggerConditionEntrys() throws BOSException {
        Set<String> sceneIds = this.getSceneIdSet(this.scenes);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("scene.id"));
        sic.add(new SelectorItemInfo("leftBracket"));
        sic.add(new SelectorItemInfo("triggerCondition.lFormula"));
        sic.add(new SelectorItemInfo("triggerCondition.operateSymbol"));
        sic.add(new SelectorItemInfo("triggerCondition.rFormula"));
        sic.add(new SelectorItemInfo("triggerCondition.className"));
        sic.add(new SelectorItemInfo("triggerCondition.isDefault"));
        sic.add(new SelectorItemInfo("triggerCondition.accessSource"));
        sic.add(new SelectorItemInfo("triggerCondition.isForbit"));
        sic.add(new SelectorItemInfo("rightBracket"));
        sic.add(new SelectorItemInfo("logicFlag"));
        sic.add(new SelectorItemInfo("seq"));
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("scene.id", sceneIds, CompareType.INCLUDE));
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sorterItem = new SorterItemInfo("scene.number");
        sorterItem.setSortType(SortType.ASCEND);
        SorterItemInfo sorterItem1 = new SorterItemInfo("seq");
        sorterItem1.setSortType(SortType.ASCEND);
        sorter.add(sorterItem);
        sorter.add(sorterItem1);
        view.setSorter(sorter);
        TriggerConditionEntryCollection tcEntrys = TriggerConditionEntryFactory.getLocalInstance(this.ctx).getTriggerConditionEntryCollection(view);
        return tcEntrys;
    }

    private Map<String, List<String[]>> getTriggerConditionFormulas(TriggerConditionEntryCollection tcEntrys) {
        Iterator it = tcEntrys.iterator();
        HashMap<String, List<String[]>> trigerConditionFormulas = new HashMap<String, List<String[]>>();
        while (it.hasNext()) {
            String[] formulas;
            TriggerConditionEntryInfo entryInfo = (TriggerConditionEntryInfo)it.next();
            boolean isDefault = entryInfo.getTriggerCondition().isIsDefault();
            String sceneId = entryInfo.getScene().getId().toString();
            if (isDefault) {
                String className = entryInfo.getTriggerCondition().getClassName();
                if (trigerConditionFormulas.containsKey(sceneId)) {
                    formulas = this.getDefaultTriggerConditionFormulaArray(entryInfo, className);
                    ((List)trigerConditionFormulas.get(sceneId)).add(formulas);
                    continue;
                }
                ArrayList<String[]> tcList = new ArrayList<String[]>();
                String[] formulas2 = this.getDefaultTriggerConditionFormulaArray(entryInfo, className);
                tcList.add(formulas2);
                trigerConditionFormulas.put(sceneId, tcList);
                continue;
            }
            if (trigerConditionFormulas.containsKey(sceneId)) {
                String[] formulas3 = this.getTriggerConditionFormulaArray(entryInfo);
                ((List)trigerConditionFormulas.get(sceneId)).add(formulas3);
                continue;
            }
            ArrayList<String[]> tcList = new ArrayList<String[]>();
            formulas = this.getTriggerConditionFormulaArray(entryInfo);
            tcList.add(formulas);
            trigerConditionFormulas.put(sceneId, tcList);
        }
        return trigerConditionFormulas;
    }

    private String[] getDefaultTriggerConditionFormulaArray(TriggerConditionEntryInfo entryInfo, String className) {
        String[] formulas = new String[2];
        StringBuffer sb = new StringBuffer();
        if (entryInfo.getLeftBracket() != null) {
            sb.append(entryInfo.getLeftBracket());
        }
        if (entryInfo.getTriggerCondition().isIsForbit()) {
            sb.append("true");
        } else {
            sb.append(className);
        }
        if (entryInfo.getRightBracket() != null) {
            sb.append(entryInfo.getRightBracket());
        }
        if (entryInfo.getLogicFlag() != null) {
            String logicFlag = entryInfo.getLogicFlag().getValue();
            if ("and".equals(logicFlag)) {
                sb.append("*");
            } else if ("or".equals(logicFlag)) {
                sb.append("+");
            }
        }
        formulas[0] = sb.toString();
        formulas[1] = className;
        return formulas;
    }

    private String[] getTriggerConditionFormulaArray(TriggerConditionEntryInfo entryInfo) {
        String[] formulas = new String[2];
        StringBuffer sb = new StringBuffer();
        if (entryInfo.getLeftBracket() != null) {
            sb.append(entryInfo.getLeftBracket());
        }
        if (entryInfo.getTriggerCondition().isIsForbit()) {
            sb.append("true");
        } else {
            sb.append("(").append(entryInfo.getTriggerCondition().getLFormula().replaceFirst("=", ""));
            sb.append(entryInfo.getTriggerCondition().getOperateSymbol());
            sb.append(entryInfo.getTriggerCondition().getRFormula().replaceFirst("=", "")).append(")");
        }
        if (entryInfo.getRightBracket() != null) {
            sb.append(entryInfo.getRightBracket());
        }
        if (entryInfo.getLogicFlag() != null) {
            String logicFlag = entryInfo.getLogicFlag().getValue();
            if ("and".equals(logicFlag)) {
                sb.append("*");
            } else if ("or".equals(logicFlag)) {
                sb.append("+");
            }
        }
        String accessSource = String.valueOf(entryInfo.getTriggerCondition().getAccessSource().getValue());
        formulas[0] = sb.toString();
        formulas[1] = accessSource;
        return formulas;
    }

    private Set<String> getSceneIdSet(List<SceneInfo> scenes) {
        HashSet<String> sceneIdSet = new HashSet<String>();
        for (SceneInfo scene : scenes) {
            sceneIdSet.add(scene.getId().toString());
        }
        return sceneIdSet;
    }
}

