/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.investworkpaper.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorResultProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CSLPropertyAdapter;
import com.kingdee.eas.fi.gr.cslrpt.CompanyTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementCollection;
import com.kingdee.eas.fi.gr.cslrpt.DataElementFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateCollection;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateInfo;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.InvestItemDCRuleEnum;
import com.kingdee.eas.fi.gr.cslrpt.InvestNewAdjustElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.InvestTempletEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.InvestTempletEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.InvestTempletFactory;
import com.kingdee.eas.fi.gr.cslrpt.InvestTempletInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.FormulaUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.ClearCompanyItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.fi.newrpt.investworkpaper.SceneCollection;
import com.kingdee.eas.fi.newrpt.investworkpaper.SceneFactory;
import com.kingdee.eas.fi.newrpt.investworkpaper.SceneInfo;
import com.kingdee.eas.fi.newrpt.investworkpaper.SceneTypeMappingFactory;
import com.kingdee.eas.fi.newrpt.investworkpaper.SceneTypeMappingNewInfo;
import com.kingdee.eas.fi.newrpt.investworkpaper.TemplateEntryCollection;
import com.kingdee.eas.fi.newrpt.investworkpaper.TemplateEntryFactory;
import com.kingdee.eas.fi.newrpt.investworkpaper.TemplateEntryInfo;
import com.kingdee.eas.fi.newrpt.investworkpaper.app.AbstractInvestElimMnsFacadeControllerBean;
import com.kingdee.eas.fi.newrpt.investworkpaper.app.CheckTriggerConditionFormulaUtil;
import com.kingdee.eas.fi.newrpt.investworkpaper.util.InvestElimManuScriptUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.TemplateTypeInfo;
import com.kingdee.eas.fi.rpt.batch.log.LogService;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class InvestElimMnsFacadeControllerBean
extends AbstractInvestElimMnsFacadeControllerBean {
    private static final long serialVersionUID = -7238165689062042656L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.investworkpaper.app.InvestElimMnsFacadeControllerBean");
    private LogService logService;

    @Override
    protected List _genInvestElimMnsRecord(Context ctx, Map params) throws BOSException, EASBizException {
        this.logService = new LogService(logger, DebugLogger.isDebug);
        long startTime = System.currentTimeMillis();
        this.logService.addLogItem("startGenInvestElimMns: ", "----------start----------");
        this.autoCopyElimInvestRatePrePeriod(ctx, params);
        long endTime = System.currentTimeMillis();
        this.logService.addLogItem("autoCopyElimInvestRatePrePeriod: ", "keep " + String.valueOf(endTime - startTime) + " ms");
        startTime = System.currentTimeMillis();
        List<ElimInvestRateInfo> rates = this.getElimInvestRateCollection(ctx, params);
        endTime = System.currentTimeMillis();
        this.log("getElimInvestRate: ", "RateSize: " + rates.size(), "keep " + String.valueOf(endTime - startTime) + " ms");
        startTime = System.currentTimeMillis();
        List<SceneInfo> scenes = this.getSceneInfo(ctx, params);
        endTime = System.currentTimeMillis();
        this.log("getScene: ", "SceneSize: " + scenes.size(), "keep " + String.valueOf(endTime - startTime) + " ms");
        startTime = System.currentTimeMillis();
        Map<String, List<InvestTempletInfo>> validInvestTmplMap = this.getValidInvestTemplate(ctx, rates, scenes, params);
        endTime = System.currentTimeMillis();
        this.log("getValidInvestTemplate: ", "ValidInvestTemplateSize: " + validInvestTmplMap != null ? String.valueOf(validInvestTmplMap.size()) : "0", "keep " + String.valueOf(endTime - startTime) + " ms");
        if (validInvestTmplMap == null || validInvestTmplMap.isEmpty()) {
            this.logService.addLogItem("getValidInvestTemplate: ", "AllOfTheTriggerConditionsAreInvalid!");
            this.logService.addLogItem("EndGenInvestElimMns: ", "----------End----------");
            this.logService.logIt();
            this.logService.reset();
            return null;
        }
        startTime = System.currentTimeMillis();
        List<String[]> formulas = this.getInvestTemplateFormulas(ctx, params, rates, scenes, validInvestTmplMap);
        endTime = System.currentTimeMillis();
        this.log("getInvestTemplateFormulas: ", "formulasSize: " + formulas.size(), "keep " + String.valueOf(endTime - startTime) + " ms");
        startTime = System.currentTimeMillis();
        Map<String, String> formulasMap = this.getFormulaMap(ctx, params, formulas);
        endTime = System.currentTimeMillis();
        this.log("getFormulaMap: ", "formulasMapSize: " + formulasMap.size(), "keep " + String.valueOf(endTime - startTime) + " ms");
        startTime = System.currentTimeMillis();
        List<Map<String, Object>> result = this.genInvestElimMns(ctx, params, rates, scenes, validInvestTmplMap, formulasMap);
        endTime = System.currentTimeMillis();
        this.log("genInvestElimMns: ", "resultSize: " + result.size(), "keep " + String.valueOf(endTime - startTime) + " ms");
        this.logService.addLogItem("EndGenInvestElimMns: ", "----------End----------");
        this.logService.logIt();
        this.logService.reset();
        return result;
    }

    private void log(String title, String msg1, String msg2) {
        Object[] msgs = new Object[]{msg1, msg2};
        this.logService.addLogItem(title, msgs);
    }

    private List<Map<String, Object>> genInvestElimMns(Context ctx, Map params, List<ElimInvestRateInfo> rates, List<SceneInfo> scenes, Map<String, List<InvestTempletInfo>> validInvestTmplMap, Map<String, String> formulasMap) throws BOSException, EASBizException {
        int showType = Integer.valueOf(String.valueOf(params.get("showType")));
        if (10 == showType) {
            return this.genInvestElimMnsOrderBySceneNumber(ctx, params, rates, scenes, validInvestTmplMap, formulasMap);
        }
        if (20 == showType) {
            return this.genInvestElimMnsOrderByInvestCompanyNumber(ctx, params, rates, scenes, validInvestTmplMap, formulasMap);
        }
        return null;
    }

    private List<Map<String, Object>> genInvestElimMnsOrderBySceneNumber(Context ctx, Map params, List<ElimInvestRateInfo> rates, List<SceneInfo> scenes, Map<String, List<InvestTempletInfo>> validInvestTmplMap, Map<String, String> formulasMap) throws BOSException, EASBizException {
        Map genParams = this.genParams(params);
        HashMap<String, RPTItemInfo> itemMap = new HashMap<String, RPTItemInfo>();
        HashMap<String, DataElementInfo> deMap = new HashMap<String, DataElementInfo>();
        this.getBaseResource(ctx, validInvestTmplMap, itemMap, deMap);
        Map<String, TemplateTypeInfo> ElimTypeMap = this.getElimTypeNumberBySceneTypeId(ctx, params, scenes);
        ArrayList<Map<String, Object>> mnsRecords = new ArrayList<Map<String, Object>>();
        int index = 0;
        String currencyNumber = ((CurrencyInfo)params.get("currency")).getNumber();
        String mnsTmplNumber = ((TemplateInfo)params.get("mnsTmpl")).getNumber();
        for (SceneInfo scene : scenes) {
            String sceneId = scene.getId().toString();
            String sceneName = scene.getName();
            for (ElimInvestRateInfo rate : rates) {
                String validTmplKey;
                List<InvestTempletInfo> validInvestTmplList;
                String investCompanyId = rate.getCompany().getId().toString();
                String targetCompanyId = rate.getTargetCompany().getId().toString();
                FullOrgUnitInfo company = rate.getCompany();
                FullOrgUnitInfo invCompany = rate.getCompany();
                FullOrgUnitInfo targetCompany = rate.getTargetCompany();
                BigDecimal eRate = rate.getRate();
                if (rate.getEquivRate() != null && rate.getEquivRate().compareTo(BigDecimal.ZERO) > 0) {
                    eRate = rate.getEquivRate();
                }
                if ((validInvestTmplList = validInvestTmplMap.get(validTmplKey = investCompanyId + targetCompanyId + sceneId)) == null || validInvestTmplList.isEmpty()) continue;
                TemplateTypeInfo elimType = ElimTypeMap.get(sceneId);
                for (InvestTempletInfo investTmpl : validInvestTmplList) {
                    InvestTempletEntryCollection investTmplEntrys = investTmpl.getEntries();
                    InvestNewAdjustElimTypeEnum investNewType = investTmpl.getInvestNewType();
                    String tmplName = investTmpl.getName();
                    Object[] arrayEntry = investTmplEntrys.toArray();
                    Arrays.sort(arrayEntry, new InvestTempletComp());
                    BigDecimal diffValue = CslConstant.BGZERO;
                    BigDecimal bdValue = null;
                    int size = arrayEntry.length;
                    for (int i = 0; i < size; ++i) {
                        InvestTempletEntryInfo tmplEntry = (InvestTempletEntryInfo)arrayEntry[i];
                        String entryId = tmplEntry.getId().toString();
                        CompanyTypeEnum companyType = tmplEntry.getCompanyType();
                        RPTItemInfo rptItem = (RPTItemInfo)itemMap.get(tmplEntry.getItem());
                        DataElementInfo de = (DataElementInfo)deMap.get(String.valueOf(tmplEntry.getDataElement()));
                        String summary = tmplEntry.getSummary() == null ? tmplName : tmplEntry.getSummary();
                        HashMap result = new HashMap();
                        boolean isContinue = this.calculateDiffValue(ctx, genParams, sceneId, investNewType, investTmpl, rate, diffValue, i, size, itemMap, tmplEntry, result);
                        if (isContinue) continue;
                        company = (FullOrgUnitInfo)result.get("company");
                        i = Integer.valueOf(String.valueOf(result.get("index")));
                        bdValue = new BigDecimal(String.valueOf(result.get("bdValue")));
                        diffValue = new BigDecimal(String.valueOf(result.get("diffValue")));
                        if (investNewType.equals((Object)InvestNewAdjustElimTypeEnum.INVEST_ADJUST)) {
                            company = rate.getCompany();
                        }
                        String fkey = investCompanyId + targetCompanyId + sceneId + entryId;
                        String formula = formulasMap.get(fkey);
                        this.constructMnsRecord(ctx, tmplEntry, rptItem, de, company, invCompany, targetCompany, bdValue, summary, elimType, eRate, formula, investTmpl, sceneId, sceneName, index, mnsRecords, currencyNumber, mnsTmplNumber);
                    }
                    ++index;
                }
            }
        }
        return mnsRecords;
    }

    private List<Map<String, Object>> genInvestElimMnsOrderByInvestCompanyNumber(Context ctx, Map params, List<ElimInvestRateInfo> rates, List<SceneInfo> scenes, Map<String, List<InvestTempletInfo>> validInvestTmplMap, Map<String, String> formulasMap) throws BOSException, EASBizException {
        Map genParams = this.genParams(params);
        HashMap<String, RPTItemInfo> itemMap = new HashMap<String, RPTItemInfo>();
        HashMap<String, DataElementInfo> deMap = new HashMap<String, DataElementInfo>();
        this.getBaseResource(ctx, validInvestTmplMap, itemMap, deMap);
        Map<String, TemplateTypeInfo> ElimTypeMap = this.getElimTypeNumberBySceneTypeId(ctx, params, scenes);
        ArrayList<Map<String, Object>> mnsRecords = new ArrayList<Map<String, Object>>();
        int index = 0;
        String currencyNumber = ((CurrencyInfo)params.get("currency")).getNumber();
        String mnsTmplNumber = ((TemplateInfo)params.get("mnsTmpl")).getNumber();
        for (ElimInvestRateInfo rate : rates) {
            String investCompanyId = rate.getCompany().getId().toString();
            String targetCompanyId = rate.getTargetCompany().getId().toString();
            FullOrgUnitInfo company = rate.getCompany();
            FullOrgUnitInfo invCompany = rate.getCompany();
            FullOrgUnitInfo targetCompany = rate.getTargetCompany();
            BigDecimal eRate = rate.getEquivRate() != null && rate.getEquivRate().compareTo(BigDecimal.ZERO) > 0 ? rate.getEquivRate() : rate.getRate();
            for (SceneInfo scene : scenes) {
                String sceneId = scene.getId().toString();
                String sceneName = scene.getName();
                String validTmplKey = investCompanyId + targetCompanyId + sceneId;
                List<InvestTempletInfo> validInvestTmplList = validInvestTmplMap.get(validTmplKey);
                if (validInvestTmplList == null || validInvestTmplList.isEmpty()) continue;
                TemplateTypeInfo elimType = ElimTypeMap.get(sceneId);
                for (InvestTempletInfo investTmpl : validInvestTmplList) {
                    InvestTempletEntryCollection investTmplEntrys = investTmpl.getEntries();
                    InvestNewAdjustElimTypeEnum investNewType = investTmpl.getInvestNewType();
                    String tmplName = investTmpl.getName();
                    Object[] arrayEntry = investTmplEntrys.toArray();
                    Arrays.sort(arrayEntry, new InvestTempletComp());
                    BigDecimal diffValue = CslConstant.BGZERO;
                    BigDecimal bdValue = null;
                    int size = arrayEntry.length;
                    for (int i = 0; i < size; ++i) {
                        InvestTempletEntryInfo tmplEntry = (InvestTempletEntryInfo)arrayEntry[i];
                        String entryId = tmplEntry.getId().toString();
                        CompanyTypeEnum companyType = tmplEntry.getCompanyType();
                        RPTItemInfo rptItem = (RPTItemInfo)itemMap.get(tmplEntry.getItem());
                        DataElementInfo de = (DataElementInfo)deMap.get(String.valueOf(tmplEntry.getDataElement()));
                        String summary = tmplEntry.getSummary() == null ? tmplName : tmplEntry.getSummary();
                        HashMap result = new HashMap();
                        boolean isContinue = this.calculateDiffValue(ctx, genParams, sceneId, investNewType, investTmpl, rate, diffValue, i, size, itemMap, tmplEntry, result);
                        if (isContinue) continue;
                        company = (FullOrgUnitInfo)result.get("company");
                        i = Integer.valueOf(String.valueOf(result.get("index")));
                        bdValue = new BigDecimal(String.valueOf(result.get("bdValue")));
                        diffValue = new BigDecimal(String.valueOf(result.get("diffValue")));
                        if (investNewType.equals((Object)InvestNewAdjustElimTypeEnum.INVEST_ADJUST)) {
                            company = rate.getCompany();
                        }
                        String fkey = investCompanyId + targetCompanyId + sceneId + entryId;
                        String formula = formulasMap.get(fkey);
                        this.constructMnsRecord(ctx, tmplEntry, rptItem, de, company, invCompany, targetCompany, bdValue, summary, elimType, eRate, formula, investTmpl, sceneId, sceneName, index, mnsRecords, currencyNumber, mnsTmplNumber);
                    }
                    ++index;
                }
            }
        }
        return mnsRecords;
    }

    private List<Map<String, Object>> constructMnsRecord(Context ctx, InvestTempletEntryInfo tmplEntry, RPTItemInfo rptItem, DataElementInfo de, FullOrgUnitInfo company, FullOrgUnitInfo invCompany, FullOrgUnitInfo targetCompany, BigDecimal bdValue, String summary, TemplateTypeInfo elimType, BigDecimal eRate, String formula, InvestTempletInfo investTmpl, String sceneId, String sceneName, int index, List<Map<String, Object>> mnsRecords, String currencyNumber, String mnsTmplNumber) {
        HashMap<String, Object> mnsMap = new HashMap<String, Object>();
        String seq = InvestElimManuScriptUtil.getSequence(index);
        String bizNumber = InvestElimManuScriptUtil.getEntryNumber(currencyNumber, mnsTmplNumber, seq);
        mnsMap.put(String.valueOf(0), bizNumber);
        mnsMap.put(String.valueOf(0) + "id", investTmpl);
        String invCompanyId = invCompany.getId().toString();
        String InvCompanyName = invCompany.getName();
        mnsMap.put(String.valueOf(1), InvCompanyName);
        mnsMap.put(String.valueOf(1) + "id", invCompanyId);
        String targetCompanyId = targetCompany.getId().toString();
        String targerCompanyName = targetCompany.getName();
        mnsMap.put(String.valueOf(2), targerCompanyName);
        mnsMap.put(String.valueOf(2) + "id", targetCompanyId);
        String elimTypeId = elimType.getId().toString();
        String elimTypeName = elimType.getName();
        mnsMap.put(String.valueOf(4), elimTypeName);
        mnsMap.put(String.valueOf(4) + "id", elimTypeId);
        mnsMap.put(String.valueOf(5), sceneName);
        mnsMap.put(String.valueOf(6), summary);
        String itemNumber = rptItem.getNumber();
        String itemName = rptItem.getName();
        String itemId = rptItem.getId().toString();
        mnsMap.put(String.valueOf(8), itemName);
        mnsMap.put(String.valueOf(7), itemNumber);
        mnsMap.put(String.valueOf(7) + "id", itemId);
        if (tmplEntry.getCompanyType().getValue() == 4) {
            mnsMap.put(String.valueOf(7) + "diffEntry", Boolean.TRUE);
        } else {
            mnsMap.put(String.valueOf(7) + "diffEntry", Boolean.FALSE);
        }
        mnsMap.put(String.valueOf(7) + "dc", tmplEntry.getDcType().getValue());
        mnsMap.put(String.valueOf(7) + "sceneId", sceneId);
        String deName = de.getName();
        String interSeq = String.valueOf(de.getInterSeq());
        mnsMap.put(String.valueOf(9), deName);
        mnsMap.put(String.valueOf("9id"), interSeq);
        String rate = eRate.toString();
        mnsMap.put(String.valueOf(3), rate);
        String companyId = company.getId().toString();
        String companyName = company.getName();
        mnsMap.put(String.valueOf(10), companyName);
        mnsMap.put(String.valueOf(10) + "id", companyId);
        if (bdValue == null) {
            bdValue = BigDecimal.ZERO;
        }
        if (InvestItemDCRuleEnum.DEBIT.equals((Object)tmplEntry.getDcType())) {
            mnsMap.put(String.valueOf(11), bdValue.toString());
            mnsMap.put(String.valueOf(12), "0");
            if (!StringUtils.isEmpty((String)formula) && !"null".equals(formula)) {
                mnsMap.put(String.valueOf("11formula"), formula);
            }
        } else if (InvestItemDCRuleEnum.CREDIT.equals((Object)tmplEntry.getDcType())) {
            mnsMap.put(String.valueOf(11), "0");
            mnsMap.put(String.valueOf(12), bdValue.toString());
            if (!StringUtils.isEmpty((String)formula) && !"null".equals(formula)) {
                mnsMap.put(String.valueOf("12formula"), formula);
            }
        }
        mnsRecords.add(mnsMap);
        return mnsRecords;
    }

    private boolean calculateDiffValue(Context ctx, Map genParams, String sceneId, InvestNewAdjustElimTypeEnum investNewType, InvestTempletInfo investTmpl, ElimInvestRateInfo rate, BigDecimal diffValue, int i, int size, Map<String, RPTItemInfo> itemMap, InvestTempletEntryInfo investTmplEntry, Map result) throws EASBizException, BOSException {
        if (investTmplEntry.getItem() == null) {
            return true;
        }
        RPTItemInfo itemInfo = itemMap.get(investTmplEntry.getItem());
        String entryId = investTmplEntry.getId().toString();
        FullOrgUnitInfo company = rate.getCompany();
        FullOrgUnitInfo srcCompany = rate.getCompany();
        genParams.put("srcCompany", srcCompany);
        FullOrgUnitInfo targetCompany = rate.getTargetCompany();
        genParams.put("targetCompany", targetCompany);
        String investCompanyId = rate.getCompany().getId().toString();
        String targetCompanyId = rate.getTargetCompany().getId().toString();
        String valueKey = investCompanyId + targetCompanyId + sceneId + entryId;
        int iFseq = investTmplEntry.getSeq();
        CompanyTypeEnum companyType = investTmplEntry.getCompanyType();
        BigDecimal bdValue = null;
        switch (companyType.getValue()) {
            case 1: {
                company = rate.getCompany();
                break;
            }
            case 2: {
                company = rate.getTargetCompany();
                break;
            }
            case 4: {
                company = rate.getCompany();
                ++i;
                break;
            }
            case 3: {
                company = rate.getTargetCompany();
                try {
                    if (investTmplEntry.getDcType().equals((Object)InvestItemDCRuleEnum.DEBIT) && investTmplEntry.getDebitFormula() != null) {
                        bdValue = new BigDecimal(investTmplEntry.getDebitFormula());
                        break;
                    }
                    if (investTmplEntry.getCreditFormula() == null) break;
                    bdValue = new BigDecimal(investTmplEntry.getCreditFormula());
                }
                catch (NumberFormatException e) {
                    bdValue = CslConstant.BGZERO;
                    logger.error((Object)"getCreditFormula_NumberFormatException", (Throwable)e);
                }
                break;
            }
            default: {
                return true;
            }
        }
        result.put("company", company);
        result.put("index", i);
        result.put("bdValue", bdValue == null ? BigDecimal.ZERO : bdValue);
        result.put("diffValue", diffValue == null ? BigDecimal.ZERO : diffValue);
        return false;
    }

    private Map genParams(Map mapParams) {
        HashMap params = new HashMap();
        params.put("OrgTreeID", mapParams.get("orgTreeId"));
        params.put("OrgUnitID", mapParams.get("orgUnitId"));
        params.put("Year", mapParams.get("year"));
        params.put("Period", mapParams.get("period"));
        params.put("PeriodType", ((RptPeriodTypeEnum)mapParams.get("periodType")).getValue());
        params.put("KEY_SOURCECURRENCY", mapParams.get("sourceCurrency"));
        params.put("KEY_CURRENCY", mapParams.get("currency"));
        params.put("clearCompanysMap", mapParams.get("clearCompanysMap"));
        return params;
    }

    private List<String[]> getInvestTemplateFormulas(Context ctx, Map params, List<ElimInvestRateInfo> rates, List<SceneInfo> scenes, Map<String, List<InvestTempletInfo>> validInvestTmplMap) throws EASBizException, BOSException {
        Map<String, ClearCompanyItemInfo> clearCompanysMap = this.getClearCompanys(ctx, params);
        params.put("clearCompanysMap", clearCompanysMap);
        OrgTreeInfo orgTree = (OrgTreeInfo)params.get("orgTree");
        OrgUnitInfo orgUnit = (OrgUnitInfo)params.get("orgUnit");
        int year = (Integer)params.get("year");
        int period = (Integer)params.get("period");
        CurrencyInfo sourceCurrency = (CurrencyInfo)params.get("sourceCurrency");
        CurrencyInfo currency = (CurrencyInfo)params.get("currency");
        ArrayList<String[]> formulas = new ArrayList<String[]>();
        HashMap<Object, Object> mapForSubSection = new HashMap<Object, Object>();
        for (ElimInvestRateInfo rate : rates) {
            String investCompanyId = rate.getCompany().getId().toString();
            String targetCompanyId = rate.getTargetCompany().getId().toString();
            for (SceneInfo scene : scenes) {
                String sceneId = scene.getId().toString();
                String validTmplKey = investCompanyId + targetCompanyId + sceneId;
                List<InvestTempletInfo> validTmplList = validInvestTmplMap.get(validTmplKey);
                if (validTmplList == null || validTmplList.isEmpty()) continue;
                for (InvestTempletInfo tmpl : validTmplList) {
                    InvestTempletEntryCollection tmplEntrys = tmpl.getEntries();
                    String investNewType = String.valueOf(tmpl.getInvestNewType().getValue());
                    int size = tmplEntrys.size();
                    for (int i = 0; i < size; ++i) {
                        InvestTempletEntryInfo tmplEntry = tmplEntrys.get(i);
                        String tmplEntryId = tmplEntry.getId().toString();
                        String formula = null;
                        int dcType = tmplEntry.getDcType().getValue();
                        if (dcType == 1) {
                            formula = tmplEntry.getDebitFormula();
                        } else if (dcType == 2) {
                            formula = tmplEntry.getCreditFormula();
                        }
                        if (StringUtils.isEmpty((String)formula)) continue;
                        formula = this.replaceSpecialString(formula, rate, tmplEntry, orgTree, orgUnit, year, period);
                        Expression stmt = null;
                        try {
                            stmt = ExcelFormulaPaserHelper.parse((String)formula);
                        }
                        catch (Exception e) {
                            String formulaEx = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"125_CheckFormulaControllerBean", (Locale)ctx.getOriginLocale()) + formula + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"126_CheckFormulaControllerBean", (Locale)ctx.getOriginLocale());
                            String[] arrformula = new String[]{investCompanyId + targetCompanyId + sceneId + tmplEntryId, formulaEx};
                            formulas.add(arrformula);
                            continue;
                        }
                        Map<Object, Object> formulaParams = this.getParams(ctx, params, investNewType, tmplEntry, rate, orgTree, sourceCurrency, currency);
                        this.getClearCompanyParams(ctx, params, clearCompanysMap, tmplEntry, rate, orgTree, formulaParams);
                        stmt = FormulaUtil.fillFormulas((Expression)stmt, formulaParams);
                        this.getsubSectionParams(stmt, tmplEntry, rate, sceneId, tmplEntryId, formulaParams, mapForSubSection);
                        formula = stmt.toString();
                        String[] arrformula = new String[]{investCompanyId + targetCompanyId + sceneId + tmplEntryId, formula};
                        formulas.add(arrformula);
                    }
                }
            }
        }
        long startTime = System.currentTimeMillis();
        this.constructsSubsectionFormula(ctx, params, mapForSubSection, formulas);
        long endTime = System.currentTimeMillis();
        this.logService.addLogItem("constructsSubsectionFormula: ", "Keep: " + String.valueOf(endTime - startTime) + " ms");
        return formulas;
    }

    private String replaceSpecialString(String formula, ElimInvestRateInfo rate, InvestTempletEntryInfo tmplEntry, OrgTreeInfo orgTree, OrgUnitInfo orgUnit, int year, int period) {
        String invName = rate.getCompany().getName();
        String tarName = rate.getTargetCompany().getName();
        String invNumber = rate.getCompany().getNumber();
        String tarNumber = rate.getTargetCompany().getNumber();
        String date = CslRptUtil.formatDatetimeForSql((Date)rate.getDate());
        int companyType = tmplEntry.getCompanyType().getValue();
        if (formula.indexOf("@") > -1) {
            if (1 == companyType) {
                formula = formula.replaceAll("@", invNumber);
            } else if (2 == companyType) {
                formula = formula.replaceAll("@", tarNumber);
            }
        }
        if (formula.indexOf("{invCompanyName}") > -1) {
            formula = formula.replaceAll("\\{invCompanyName\\}", invName);
        }
        if (formula.indexOf("{tarCompanyName}") > -1) {
            formula = formula.replaceAll("\\{tarCompanyName\\}", tarName);
        }
        if (formula.indexOf("{invCompanyNum}") > -1) {
            formula = formula.replaceAll("\\{invCompanyNum\\}", invNumber);
        }
        if (formula.indexOf("{tarCompanyNum}") > -1) {
            formula = formula.replaceAll("\\{tarCompanyNum\\}", tarNumber);
        }
        if (formula.indexOf("{changeDate}") > -1) {
            formula = formula.replaceAll("\\{changeDate\\}", date);
        }
        if (formula.indexOf("{orgTreeNum}") > -1) {
            formula = formula.replaceAll("\\{orgTreeNum\\}", orgTree.getNumber());
        }
        if (formula.indexOf("{orgTreeId}") > -1) {
            formula = formula.replaceAll("\\{orgTreeId\\}", orgTree.getId().toString());
        }
        if (formula.indexOf("{groupOrgUnitNum}") > -1) {
            formula = formula.replaceAll("\\{groupOrgUnitNum\\}", orgUnit.getId().toString());
        }
        if (formula.indexOf("{groupOrgUnitId}") > -1) {
            formula = formula.replaceAll("\\{groupOrgUnitId\\}", orgUnit.getId().toString());
        }
        if (formula.indexOf("{year}") > -1) {
            formula = formula.replaceAll("\\{year\\}", String.valueOf(year));
        }
        if (formula.indexOf("{period}") > -1) {
            formula = formula.replaceAll("\\{period\\}", String.valueOf(period));
        }
        return formula;
    }

    private void constructsSubsectionFormula(Context ctx, Map mapParams, Map<Object, Object> mapForSubSection, List<String[]> formulas) throws EASBizException, BOSException {
        if (mapForSubSection == null || mapForSubSection.isEmpty()) {
            return;
        }
        int year = (Integer)mapParams.get("year");
        int period = (Integer)mapParams.get("period");
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)mapParams.get("periodType");
        OrgTreeInfo orgBound = (OrgTreeInfo)mapParams.get("orgTree");
        PeriodCollection periods = null;
        boolean isMergeByFiscalPeriod = FiscalPeriodHelper.isMergeByFiscalPeriod((Context)ctx);
        if (isMergeByFiscalPeriod) {
            periods = FiscalPeriodHelper.getPeriodCollection((Context)ctx, (OrgTreeInfo)orgBound);
        }
        for (Map.Entry<Object, Object> entry : mapForSubSection.entrySet()) {
            Map params;
            String key = (String)entry.getKey();
            Object[] stmtTemp = (Object[])entry.getValue();
            Expression stmt = (Expression)stmtTemp[0];
            int branchType = FormulaUtil.getBranchCalculateType((Expression)stmt, (Map)(params = (Map)stmtTemp[1]));
            if (0 == branchType) continue;
            boolean isAddFirstPeriod = true;
            boolean isClearCompany = params.containsKey("KEY_IS_CLEARCOMPANY") ? (Boolean)params.get("KEY_IS_CLEARCOMPANY") : false;
            for (int k = period = isClearCompany ? (Integer)params.get("Period") : period; k > 1; --k) {
                Date periodLastDate = this.getPeriodLastDate(ctx, orgBound, periods, year, k, periodType, isMergeByFiscalPeriod);
                params.put("Day", RPTDateUtil.formateDate((Date)periodLastDate, (String)"yyyy-MM-dd"));
                params.put("isNew", false);
                isAddFirstPeriod = this.getKperiodFormla(ctx, mapParams, formulas, period, key, stmt, params, k);
                if (!isAddFirstPeriod) break;
                this.getPreKPeriodFormula(formulas, key, stmt, params, k);
            }
            this.getPlusFormulas(ctx, formulas, year, period, periodType, orgBound, periods, isMergeByFiscalPeriod, key, stmt, params, branchType, isAddFirstPeriod);
            this.getFirstPeriodSpecialFormula(ctx, mapParams, formulas, year, period, periodType, orgBound, periods, isMergeByFiscalPeriod, key, stmt, params, branchType);
        }
        mapForSubSection.clear();
    }

    private void getFirstPeriodSpecialFormula(Context ctx, Map mapParams, List<String[]> formulas, int year, int period, RptPeriodTypeEnum periodType, OrgTreeInfo orgBound, PeriodCollection periods, boolean isMergeByFiscalPeriod, String key, Expression stmt, Map<Object, Object> params, int branchType) throws BOSException, EASBizException {
        if (2 == branchType) {
            Date rptDate = this.getPeriodLastDate(ctx, orgBound, periods, year, 1, RptPeriodTypeEnum.MONTHLY, isMergeByFiscalPeriod);
            Map keyDateMap = this.getMinDateFromElimInvestRate(ctx, mapParams, rptDate);
            FormulaUtil.constructFirstPeriodFormula(formulas, (Map)keyDateMap, (Expression)stmt, params, (String)key, (int)year, (int)period, (RptPeriodTypeEnum)periodType, (Date)rptDate);
        }
    }

    private Map getMinDateFromElimInvestRate(Context ctx, Map mapParams, Date rptDate) throws BOSException {
        ArrayList<Object> params = new ArrayList<Object>(5);
        HashMap<String, java.sql.Date> keyDateMap = new HashMap<String, java.sql.Date>();
        StringBuffer sql = new StringBuffer(500);
        sql.append(" select rate.FCompany,rate.FTargetCompany,min(rate.FDate) Fdate\t\t\n").append(" from t_csl_ElimInvestRate rate \t\t\t\t\t\t\t\t\t\n").append(" join t_org_BaseUnit com on com.FId = rate.FCompany \t\t\t\t\n").append(" join t_org_BaseUnit targCom on targCom.FId = rate.FTargetCompany \t\n").append(" where \trate.FOrgBoundId = ? and rate.FOrgUnit = ? \t\t\t\t\t\n").append(" and rate.FYear = ? and rate.FPeriod = ? and rate.FDate <= ? \t\t\n").append(" group by rate.FCompany,rate.FTargetCompany \t\t\t\t\t\t\n");
        params.add(mapParams.get("orgTreeId"));
        params.add(mapParams.get("orgUnitId"));
        params.add(mapParams.get("year"));
        params.add(mapParams.get("period"));
        Date date = new Date(rptDate.getTime());
        params.add(date);
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString(), params.toArray());
        try {
            while (rowSet.next()) {
                String companyId = rowSet.getString("FCompany");
                String targetCompanyId = rowSet.getString("FTargetCompany");
                String key = companyId + targetCompanyId;
                keyDateMap.put(key, rowSet.getDate("Fdate"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return keyDateMap;
    }

    private void getPlusFormulas(Context ctx, List<String[]> formulas, int year, int period, RptPeriodTypeEnum periodType, OrgTreeInfo orgBound, PeriodCollection periods, boolean isMergeByFiscalPeriod, String key, Expression stmt, Map<Object, Object> params, int branchType, boolean isAddFirstPeriod) throws EASBizException, BOSException {
        if (period != 1 && 1 == branchType && isAddFirstPeriod) {
            Date periodLastDate = this.getPeriodLastDate(ctx, orgBound, periods, year, 1, periodType, isMergeByFiscalPeriod);
            params.put("Day", RPTDateUtil.formateDate((Date)periodLastDate, (String)"yyyy-MM-dd"));
            params.put("Period", new Integer(1));
            params.put("isNew", false);
            Expression temp = FormulaUtil.fillFormulas((Expression)stmt, params);
            String[] arrformula = new String[]{key, temp.toString()};
            formulas.add(arrformula);
        }
    }

    private void getPreKPeriodFormula(List<String[]> formulas, String key, Expression stmt, Map<Object, Object> params, int k) throws EASBizException, BOSException {
        params.put("Period", new Integer(k - 1));
        Expression prePeriodFormula = FormulaUtil.fillFormulas((Expression)stmt, params);
        String[] arrformula2 = new String[]{key, "-(" + prePeriodFormula.toString() + ")"};
        formulas.add(arrformula2);
    }

    private boolean getKperiodFormla(Context ctx, Map mapParams, List<String[]> formulas, int period, String key, Expression stmt, Map<Object, Object> params, int k) throws EASBizException, BOSException {
        boolean isAddFirstPeriod = true;
        if (k != period) {
            params.put("Period", new Integer(k));
            Expression curPeriodFormula = FormulaUtil.fillFormulas((Expression)stmt, params);
            String[] arrformula = new String[]{key, curPeriodFormula.toString()};
            String formulaEsp = FormulaUtil.getformulaEspStr((Expression)curPeriodFormula);
            if (!"".equals(formulaEsp)) {
                BigDecimal bvalue;
                String[] arrformulaEsp = new String[]{key, formulaEsp};
                ArrayList<String[]> esp = new ArrayList<String[]>();
                esp.add(arrformulaEsp);
                Map espMapValue = this.getValues(ctx, mapParams, esp);
                if (espMapValue.get(arrformula[0]) != null && espMapValue.get(arrformula[0]) instanceof BigDecimal && (bvalue = (BigDecimal)espMapValue.get(arrformula[0])) != null && bvalue.compareTo(new BigDecimal("0")) == 0) {
                    isAddFirstPeriod = false;
                }
            }
            if (isAddFirstPeriod) {
                formulas.add(arrformula);
            }
        }
        return isAddFirstPeriod;
    }

    private Map getValues(Context ctx, Map mapParams, List formulas) throws BOSException, EASBizException {
        long time = System.currentTimeMillis();
        Book book = this.getNewBook(ctx, mapParams);
        FormulaUtil.putFormulaToTable((List)formulas, (Book)book, (Context)ctx);
        Map values = InvestElimMnsFacadeControllerBean.getResult(book, ctx, (CurrencyInfo)mapParams.get("currency"));
        logger.info((Object)("calculater:" + (System.currentTimeMillis() - time) + "ms"));
        return values;
    }

    public static Map getResult(Book table, Context ctx, CurrencyInfo currency) throws EASBizException, BOSException {
        table.calc();
        String formula = null;
        Sheet sheet = table.getSheet(0);
        HashMap<String, Object> result = new HashMap<String, Object>();
        int Precision = 2;
        if (currency != null) {
            Precision = currency.getPrecision();
        }
        for (int m = 0; m <= sheet.getMaxRowIndex(); ++m) {
            BigDecimal value;
            Variant objValue = sheet.getRange(m, 1).getValue();
            formula = sheet.getRange(m, 1).getFormula();
            if (formula != null && formula.length() > 0) {
                formula = formula.substring(1, formula.length());
            }
            if (objValue == null || objValue.isNull()) {
                objValue = new Variant((Object)CslConstant.BGZERO);
            }
            String key = sheet.getRange(m, 0).getValue().toString();
            if (DebugLogger.isDebug) {
                logger.error((Object)("NewInvestEliminateLog:key=" + key + " Formula =" + formula + ";value = " + objValue + "\r\n"));
            }
            if (objValue.isString() || objValue.isError()) {
                String error = "BadFunction";
                logger.info((Object)sheet.getRange(m, 1).getFormula());
                logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"213_FormulaUtil", (Locale)ctx.getOriginLocale()) + objValue.getVtAsString()));
                result.put(key, error);
                continue;
            }
            BigDecimal lValue = BigDecimal.ZERO;
            lValue = CslRptUtil.toBigDecimal((Object)objValue).setScale(Precision, 4);
            if (result.containsKey(key)) {
                value = (BigDecimal)result.get(key);
                value = value.add(lValue);
            } else {
                value = lValue;
            }
            result.put(key, value);
        }
        return result;
    }

    private Book getNewBook(Context ctx, Map mapParams) throws BOSException, EASBizException {
        CslReportInfo info = new CslReportInfo();
        info.setYear(((Integer)mapParams.get("year")).intValue());
        info.setPeriod((short)((Integer)mapParams.get("period")).intValue());
        info.setPeriodType((RptPeriodTypeEnum)mapParams.get("periodType"));
        info.setOrgTree((OrgTreeInfo)mapParams.get("orgTree"));
        info.setCurrency((CurrencyInfo)mapParams.get("currency"));
        String activeSheetName = (String)mapParams.get("activeSheetName");
        Book book = this.initBook(ctx, info, activeSheetName);
        return book;
    }

    private Book initBook(final Context ctx, final CslReportInfo rptInfo, String activeSheetName) throws BOSException, EASBizException {
        Book book = Book.Manager.getNewBook(null, (int)1);
        book.getSheet(0).setName(activeSheetName);
        book.setCalculate(false);
        try {
            FormulaDefinition.registerFormulaToBook(book, new ICalculateContextProvider(){

                public Context getServerContext() {
                    return ctx;
                }

                public ReportVariables getReportVariables() {
                    ReportVariables v = null;
                    try {
                        Book book = rptInfo.getBook();
                        v = ReportVariables.loadFromBook((Book)book);
                        if (v == null) {
                            v = new ReportVariables();
                            v.storeToBook(book);
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)"getReportVariablesError: ", (Throwable)e);
                    }
                    VariableEntry variableEntry = new VariableEntry("Check_Permissioin", null);
                    variableEntry.setDescription(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"47_variableName"));
                    variableEntry.setValue(Boolean.toString(false));
                    variableEntry.setType(1);
                    v.addOrReplace(variableEntry);
                    return v;
                }

                public IReportPropertyAdapter getReportAdapter() {
                    CSLPropertyAdapter adapter = new CSLPropertyAdapter(rptInfo, ctx);
                    return adapter;
                }

                public IErrorProvider getErrorProvider() {
                    return null;
                }

                public IErrorResultProvider getErrorResultProvider() {
                    return null;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return book;
    }

    private Map<String, String> getFormulaMap(Context ctx, Map mapParams, List formulas) throws BOSException, EASBizException {
        HashMap<String, String> formulasMap = new HashMap<String, String>();
        Book book = this.getNewBook(ctx, mapParams);
        Sheet sheet = book.getSheet(0);
        for (String[] temps : formulas) {
            String key = temps[0];
            String formula = temps[1];
            if (RptUtil.isFormulaValid((String)formula, (Sheet)sheet)) {
                formula = "Round(" + formula + ",2)";
            }
            if (formulasMap == null) continue;
            if (formulasMap.containsKey(key)) {
                String subFormula = (String)formulasMap.get(key);
                formula = subFormula + "+" + formula;
            }
            formulasMap.put(key, formula);
        }
        return formulasMap;
    }

    private void getsubSectionParams(Expression stmt, InvestTempletEntryInfo tmplEntry, ElimInvestRateInfo rate, String sceneId, String tmplEntryId, Map<Object, Object> formulaParams, Map<Object, Object> mapForSubSection) {
        if (this.isNeedToSubsection(stmt, tmplEntry)) {
            formulaParams.put("DataElement", tmplEntry.getDataElement() == 3 ? "YTDAMOUNT" : "ENDBALANCE");
            Object[] stmtTemp = new Object[]{stmt, formulaParams};
            String investCompanyId = rate.getCompany().getId().toString();
            String targetCompanyId = rate.getTargetCompany().getId().toString();
            mapForSubSection.put(investCompanyId + targetCompanyId + sceneId + tmplEntryId, stmtTemp);
        }
    }

    private boolean isNeedToSubsection(Expression stmt, InvestTempletEntryInfo tmplEntry) {
        int dataElement = tmplEntry.getDataElement();
        return stmt.toString().indexOf("ESP") >= 0 && stmt.toString().indexOf("ACCTITEM") >= 0 && (dataElement == 3 || dataElement == 4) && this.isSubsection(stmt);
    }

    private boolean isSubsection(Expression stmt) {
        if (stmt instanceof BinaryOperationExpr) {
            Expression formulaExpr = ((BinaryOperationExpr)stmt).left;
            return !(formulaExpr instanceof BinaryOperationExpr);
        }
        return false;
    }

    private void getClearCompanyParams(Context ctx, Map mapParams, Map<String, ClearCompanyItemInfo> clearCompanysMap, InvestTempletEntryInfo tmplEntry, ElimInvestRateInfo rate, OrgTreeInfo orgTree, Map<Object, Object> formulaParams) throws EASBizException, BOSException {
        String clearCompanyId;
        int companyType = tmplEntry.getCompanyType().getValue();
        String investCompanyId = rate.getCompany().getId().toString();
        String targetCompanyId = rate.getTargetCompany().getId().toString();
        String string = clearCompanyId = companyType == 1 ? investCompanyId : targetCompanyId;
        if (clearCompanysMap.containsKey(clearCompanyId)) {
            ClearCompanyItemInfo clearCompanyItemInfo = clearCompanysMap.get(clearCompanyId);
            formulaParams.put("Year", clearCompanyItemInfo.getYear());
            formulaParams.put("Period", clearCompanyItemInfo.getPeriod());
            formulaParams.put("KEY_ORGTREE_INFO", clearCompanyItemInfo.getTreeInfo());
            formulaParams.put("KEY_IS_CLEARCOMPANY", true);
            OrgTreeInfo orgBound = clearCompanyItemInfo.getTreeInfo();
            PeriodCollection periods = null;
            boolean isMergeByFiscalPeriod = FiscalPeriodHelper.isMergeByFiscalPeriod((Context)ctx);
            if (isMergeByFiscalPeriod) {
                periods = FiscalPeriodHelper.getPeriodCollection((Context)ctx, (OrgTreeInfo)orgBound);
            }
            Date periodLastDate = this.getPeriodLastDate(ctx, orgBound, periods, clearCompanyItemInfo.getYear(), clearCompanyItemInfo.getPeriod(), RptPeriodTypeEnum.MONTHLY, isMergeByFiscalPeriod);
            formulaParams.put("Day", RPTDateUtil.formateDate((Date)periodLastDate, (String)"yyyy-MM-dd"));
        } else {
            formulaParams.put("Year", mapParams.get("year"));
            formulaParams.put("Period", mapParams.get("period"));
            formulaParams.put("KEY_ORGTREE_INFO", orgTree);
        }
    }

    private Date getPeriodLastDate(Context ctx, OrgTreeInfo orgBound, PeriodCollection periods, int year, int period, RptPeriodTypeEnum periodType, boolean isMergeByFiscalPeriod) {
        if (!isMergeByFiscalPeriod || periods == null || periods.isEmpty()) {
            return RPTDateUtil.getPeriodLastDate((int)year, (int)period, (RptPeriodTypeEnum)periodType);
        }
        try {
            return FiscalPeriodHelper.getPeriodLastDate((PeriodCollection)periods, (int)year, (int)period, (RptPeriodTypeEnum)periodType, (boolean)isMergeByFiscalPeriod);
        }
        catch (Exception e) {
            logger.error((Object)"getPeriodLastDate_Exception", (Throwable)e);
            return null;
        }
    }

    private Map<Object, Object> getParams(Context ctx, Map mapParams, String investNewType, InvestTempletEntryInfo tmplEntry, ElimInvestRateInfo rate, OrgTreeInfo orgTree, CurrencyInfo sourceCurrency, CurrencyInfo currency) {
        HashMap<Object, Object> params = new HashMap<Object, Object>(32);
        params.put("KeyOrgTree", orgTree.getNumber());
        int companyType = tmplEntry.getCompanyType().getValue();
        String investCompanyId = rate.getCompany().getId().toString();
        String targetCompanyId = rate.getTargetCompany().getId().toString();
        String investCompanyNumber = rate.getCompany().getNumber();
        String targetCompanyNumber = rate.getTargetCompany().getNumber();
        String company = null;
        company = companyType == 1 ? investCompanyNumber : targetCompanyNumber;
        params.put("SRCCOMPANY", investCompanyNumber);
        params.put("TARCOMPANY", targetCompanyNumber);
        params.put("KEY_COMPANY_ID", investCompanyId);
        params.put("KEY_TARGETCOMPANY_ID", targetCompanyId);
        params.put("KEY_COMPANY", company);
        params.put("KEY_SOURCECURRENCY", sourceCurrency.getNumber());
        params.put("KEY_CURRENCY", currency.getNumber());
        params.put("Day", RPTDateUtil.formateDate((Date)((Date)mapParams.get("rptDate")), null).toString());
        params.put("CUR_Period", mapParams.get("period"));
        params.put("AdjustElimType", investNewType);
        params.put("isNew", true);
        params.put("KEY_CONTEXT", ctx);
        params.put("KEY_INVEST_COMPANYTYPE", new Integer(companyType));
        params.put("KeyOrgUnit", ((OrgUnitInfo)mapParams.get("orgUnit")).getNumber());
        return params;
    }

    private Map<String, ClearCompanyItemInfo> getClearCompanys(Context ctx, Map mapParams) throws EASBizException, BOSException {
        HashMap params = new HashMap();
        params.put("year", mapParams.get("year"));
        params.put("period", mapParams.get("period"));
        params.put("periodType", ((RptPeriodTypeEnum)mapParams.get("periodType")).getValue());
        params.put("orgTreeInfo", mapParams.get("orgTree"));
        params.put("orgUnitInfo", mapParams.get("orgUnit"));
        Map clearCompMap = ElimInvestRateFactory.getLocalInstance((Context)ctx).getClearingCompanyInfors(params);
        List clearCompanys = clearCompMap.get("clearCompList") == null ? new ArrayList(0) : (List)clearCompMap.get("clearCompList");
        HashMap<String, ClearCompanyItemInfo> clearCompanysMap = new HashMap<String, ClearCompanyItemInfo>(clearCompanys.size());
        for (ClearCompanyItemInfo companyItemInfo : clearCompanys) {
            clearCompanysMap.put(companyItemInfo.getClearCompany().getId().toString(), companyItemInfo);
        }
        return clearCompanysMap;
    }

    private Map<String, List<InvestTempletInfo>> getValidInvestTemplate(Context ctx, List<ElimInvestRateInfo> rates, List<SceneInfo> scenes, Map params) throws EASBizException, BOSException {
        HashMap<String, List<InvestTempletInfo>> validInvestTmplMap = new HashMap<String, List<InvestTempletInfo>>();
        Map<String, List<InvestTempletInfo>> investTmplMap = this.getInvestTemplate(ctx, scenes);
        String cslReportId = (String)params.get("cslReportId");
        String activeSheetName = (String)params.get("activeSheetName");
        CheckTriggerConditionFormulaUtil check = new CheckTriggerConditionFormulaUtil(ctx, scenes, rates, cslReportId, activeSheetName);
        Map<String, Boolean> checkResult = check.getSceneFormulaValues();
        for (ElimInvestRateInfo rate : rates) {
            String investCompanyId = rate.getCompany().getId().toString();
            String targetCompanyId = rate.getTargetCompany().getId().toString();
            for (SceneInfo scene : scenes) {
                String sceneId = scene.getId().toString();
                String key = investCompanyId + targetCompanyId + sceneId;
                if (!checkResult.containsKey(key) || !checkResult.get(key).booleanValue()) continue;
                List<InvestTempletInfo> validInvestTmplList = investTmplMap.get(sceneId);
                validInvestTmplMap.put(key, validInvestTmplList);
            }
        }
        return validInvestTmplMap;
    }

    private void getBaseResource(Context ctx, Map<String, List<InvestTempletInfo>> validInvestTmplMap, Map<String, RPTItemInfo> itemMap, Map<String, DataElementInfo> deMap) throws BOSException {
        Iterator<String> it = validInvestTmplMap.keySet().iterator();
        HashSet<String> rptItems = new HashSet<String>();
        HashSet<Integer> dataElements = new HashSet<Integer>();
        while (it.hasNext()) {
            String key = it.next();
            List<InvestTempletInfo> investTmplList = validInvestTmplMap.get(key);
            for (InvestTempletInfo investTmpl : investTmplList) {
                InvestTempletEntryCollection entrys = investTmpl.getEntries();
                int size = entrys.size();
                for (int i = 0; i < size; ++i) {
                    InvestTempletEntryInfo entry = entrys.get(i);
                    String rptItemId = entry.getItem();
                    if (rptItemId != null) {
                        rptItems.add(rptItemId);
                    }
                    int interseq = entry.getDataElement();
                    dataElements.add(interseq);
                }
            }
        }
        this.queryRptItemInfo(ctx, rptItems, itemMap);
        this.queryDataElementInfo(ctx, dataElements, deMap);
    }

    private void queryRptItemInfo(Context ctx, Set<String> rptItems, Map<String, RPTItemInfo> itemMap) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("control"));
        sic.add(new SelectorItemInfo("dc"));
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", rptItems, CompareType.INCLUDE));
        view.setFilter(filter);
        RPTItemCollection rptItemCollection = RPTItemFactory.getLocalInstance((Context)ctx).getRPTItemCollection(view);
        if (rptItemCollection != null && !rptItemCollection.isEmpty()) {
            int size = rptItemCollection.size();
            for (int i = 0; i < size; ++i) {
                RPTItemInfo rptItem = rptItemCollection.get(i);
                String rptItemId = rptItem.getId().toString();
                itemMap.put(rptItemId, rptItem);
            }
        }
    }

    private void queryDataElementInfo(Context ctx, Set<Integer> dataElements, Map<String, DataElementInfo> deMap) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("interSeq"));
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("interSeq", dataElements, CompareType.INCLUDE));
        view.setFilter(filter);
        DataElementCollection dataElementCollection = DataElementFactory.getLocalInstance((Context)ctx).getDataElementCollection(view);
        if (dataElementCollection != null && !dataElementCollection.isEmpty()) {
            int size = dataElementCollection.size();
            for (int i = 0; i < size; ++i) {
                DataElementInfo dataElement = dataElementCollection.get(i);
                String interSeq = String.valueOf(dataElement.getInterSeq());
                deMap.put(interSeq, dataElement);
            }
        }
    }

    private Map<String, List<InvestTempletInfo>> getInvestTemplate(Context ctx, List<SceneInfo> scenes) throws BOSException, EASBizException {
        LinkedHashMap<String, List<InvestTempletInfo>> investTmplMap = new LinkedHashMap<String, List<InvestTempletInfo>>();
        Set<String> sceneIds = this.getSceneIdSet(scenes);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("template.id"));
        sic.add(new SelectorItemInfo("scene.id"));
        sic.add(new SelectorItemInfo("seq"));
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("scene.id", sceneIds, CompareType.INCLUDE));
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sorterItem = new SorterItemInfo("seq");
        sorterItem.setSortType(SortType.ASCEND);
        sorter.add(sorterItem);
        view.setSorter(sorter);
        TemplateEntryCollection templateEntrys = TemplateEntryFactory.getLocalInstance(ctx).getTemplateEntryCollection(view);
        sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("investNewType"));
        sic.add(new SelectorItemInfo("summary"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.item"));
        sic.add(new SelectorItemInfo("entries.companyType"));
        sic.add(new SelectorItemInfo("entries.dcType"));
        sic.add(new SelectorItemInfo("entries.seq"));
        sic.add(new SelectorItemInfo("entries.debitFormula"));
        sic.add(new SelectorItemInfo("entries.creditFormula"));
        sic.add(new SelectorItemInfo("entries.dataElement"));
        sic.add(new SelectorItemInfo("entries.summary"));
        sic.add(new SelectorItemInfo("eliminationMode.id"));
        Iterator it = templateEntrys.iterator();
        ArrayList<InvestTempletInfo> tmplList = null;
        while (it.hasNext()) {
            TemplateEntryInfo entryInfo = (TemplateEntryInfo)it.next();
            String sceneId = entryInfo.getScene().getId().toString();
            InvestTempletInfo tmplInfo = entryInfo.getTemplate();
            if (tmplInfo == null || tmplInfo.getId() == null) continue;
            tmplInfo = InvestTempletFactory.getLocalInstance((Context)ctx).getInvestTempletInfo((IObjectPK)new ObjectUuidPK(tmplInfo.getId()), sic);
            if (investTmplMap.containsKey(sceneId)) {
                ((List)investTmplMap.get(sceneId)).add(tmplInfo);
                continue;
            }
            tmplList = new ArrayList<InvestTempletInfo>();
            tmplList.add(tmplInfo);
            investTmplMap.put(sceneId, tmplList);
        }
        return investTmplMap;
    }

    private Map<String, TemplateTypeInfo> getElimTypeNumberBySceneTypeId(Context ctx, Map params, List<SceneInfo> scenes) throws BOSException, EASBizException {
        HashMap<String, TemplateTypeInfo> sceneIdToElimType = new HashMap<String, TemplateTypeInfo>();
        List sceneTypeMappingInfos = SceneTypeMappingFactory.getLocalInstance(ctx).getSceneTypeMappingNewInfos(params);
        for (SceneTypeMappingNewInfo sceneTypeMapping : sceneTypeMappingInfos) {
            TemplateTypeInfo elimType = new TemplateTypeInfo();
            elimType.setId(BOSUuid.read((String)sceneTypeMapping.getElimTypeId()));
            elimType.setNumber(sceneTypeMapping.getElimTypeNumber());
            elimType.setName(sceneTypeMapping.getElimTypeName());
            String sceneTypeId = sceneTypeMapping.getSceneTypeId();
            for (SceneInfo scene : scenes) {
                String id = scene.getDisplayTemplateType().getId().toString();
                String sceneId = scene.getId().toString();
                if (!sceneTypeId.equals(id)) continue;
                sceneIdToElimType.put(sceneId, elimType);
            }
        }
        return sceneIdToElimType;
    }

    private Set<String> getSceneIdSet(List<SceneInfo> scenes) {
        HashSet<String> sceneIdSet = new HashSet<String>();
        for (SceneInfo scene : scenes) {
            sceneIdSet.add(scene.getId().toString());
        }
        return sceneIdSet;
    }

    private Set<String> getSceneTypeIdSet(List<SceneInfo> scenes) {
        HashSet<String> sceneTypeIdSet = new HashSet<String>();
        for (SceneInfo scene : scenes) {
            sceneTypeIdSet.add(scene.getDisplayTemplateType().getId().toString());
        }
        return sceneTypeIdSet;
    }

    private List<SceneInfo> getSceneInfo(Context ctx, Map params) throws BOSException {
        ArrayList<SceneInfo> scenes = new ArrayList<SceneInfo>();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("displayTemplateType"));
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        Set<String> sceneIdsSet = this.getSceneIdsSet(params);
        filter.getFilterItems().add(new FilterItemInfo("id", sceneIdsSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isFreezed", (Object)new Integer(0)));
        view.setFilter(filter);
        SceneCollection sceneCollection = SceneFactory.getLocalInstance(ctx).getSceneCollection(view);
        scenes.addAll(this.sortScenes(params, sceneCollection));
        return scenes;
    }

    private List<SceneInfo> sortScenes(Map params, SceneCollection sceneCollection) {
        ArrayList<SceneInfo> sortedSecnes = new ArrayList<SceneInfo>();
        String split = ",";
        String sceneIdString = (String)params.get("sceneIds");
        String[] sceneIds = sceneIdString.split(split);
        int size = sceneCollection.size();
        block0: for (int i = 0; i < sceneIds.length; ++i) {
            String sceneId = sceneIds[i];
            for (int j = 0; j < size; ++j) {
                SceneInfo scene = sceneCollection.get(j);
                String id = scene.getId().toString();
                if (!sceneId.equals(id)) continue;
                sortedSecnes.add(scene);
                continue block0;
            }
        }
        return sortedSecnes;
    }

    private Set<String> getSceneIdsSet(Map params) {
        String[] sceneIds;
        HashSet<String> scenes = new HashSet<String>();
        String split = ",";
        String sceneIdString = (String)params.get("sceneIds");
        for (String sceneId : sceneIds = sceneIdString.split(split)) {
            scenes.add(sceneId);
        }
        return scenes;
    }

    private void autoCopyElimInvestRatePrePeriod(Context ctx, Map mapParams) throws BOSException, EASBizException {
        HashMap params = new HashMap(7);
        params.put("reportDate", mapParams.get("rptDate"));
        params.put("rptYear", mapParams.get("year"));
        params.put("rptPeriod", mapParams.get("period"));
        params.put("orgUnit", mapParams.get("orgUnit"));
        params.put("orgBound", mapParams.get("orgTree"));
        params.put("rptPeriodType", mapParams.get("periodType"));
        int mergeType = 0;
        if (mapParams.containsKey("mergeType")) {
            mergeType = (Integer)mapParams.get("mergeType");
        }
        params.put("MERGETYPE", mergeType);
        try {
            ElimInvestRateFactory.getLocalInstance((Context)ctx).autoCopyElimInvestRatePrePeriod(params);
        }
        catch (BOSException e) {
            logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"187_EliminateByMainInvestFacadeControllerBean", (Locale)ctx.getOriginLocale()) + e.getStackTrace()));
            throw e;
        }
        catch (EASBizException e) {
            logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"187_EliminateByMainInvestFacadeControllerBean", (Locale)ctx.getOriginLocale()) + e.getStackTrace()));
            throw e;
        }
    }

    private List<ElimInvestRateInfo> getElimInvestRateCollection(Context ctx, Map params) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("targetCompany.id"));
        sic.add(new SelectorItemInfo("targetCompany.number"));
        sic.add(new SelectorItemInfo("targetCompany.name"));
        sic.add(new SelectorItemInfo("date"));
        sic.add(new SelectorItemInfo("rate"));
        sic.add(new SelectorItemInfo("equivRate"));
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgBound.id", params.get("orgTreeId")));
        Date date = (Date)params.get("rptDate");
        filter.getFilterItems().add(new FilterItemInfo("rptDate", (Object)date, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("year", params.get("year")));
        filter.getFilterItems().add(new FilterItemInfo("period", params.get("period")));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", params.get("orgUnitId")));
        filter.getFilterItems().add(new FilterItemInfo("islatest", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("rate", (Object)new Integer(0), CompareType.NOTEQUALS));
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sorterItem = new SorterItemInfo("company.number");
        sorterItem.setSortType(SortType.ASCEND);
        sorter.add(sorterItem);
        view.setSorter(sorter);
        ElimInvestRateCollection elimInvestRateCollection = ElimInvestRateFactory.getLocalInstance((Context)ctx).getElimInvestRateCollection(view);
        Iterator it = elimInvestRateCollection.iterator();
        ArrayList<ElimInvestRateInfo> rates = new ArrayList<ElimInvestRateInfo>();
        while (it.hasNext()) {
            rates.add((ElimInvestRateInfo)it.next());
        }
        return rates;
    }

    class InvestTempletComp
    implements Comparator {
        InvestTempletComp() {
        }

        public int compare(Object o1, Object o2) {
            InvestTempletEntryInfo entryInfo1 = (InvestTempletEntryInfo)o1;
            InvestTempletEntryInfo entryInfo2 = (InvestTempletEntryInfo)o2;
            return entryInfo1.getCompanyType().getValue() - entryInfo2.getCompanyType().getValue();
        }
    }
}

