/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.investworkpaper.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.OperateSymbolEnum;
import com.kingdee.eas.fi.newrpt.investworkpaper.AccessSourceEnum;
import com.kingdee.eas.fi.newrpt.investworkpaper.TriggerConditionCollection;
import com.kingdee.eas.fi.newrpt.investworkpaper.TriggerConditionFactory;
import com.kingdee.eas.fi.newrpt.investworkpaper.TriggerConditionInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.ResourceProviderManager;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class TriggerConditionImport
extends AbstractDataTransmission {
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return TriggerConditionFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        super.submit(coreBaseInfo, ctx);
    }

    private void checkDup(Context ctx, String number, String name) throws TaskExternalException {
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)name, CompareType.EQUALS));
            filter.setMaskString("#0 or #1");
            TriggerConditionCollection collection = TriggerConditionFactory.getLocalInstance(ctx).getTriggerConditionCollection(view);
            if (collection != null && !collection.isEmpty()) {
                TriggerConditionInfo tcInfo = collection.get(0);
                if (number.equals(tcInfo.getNumber())) {
                    String msg = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"84_triggerConditionNumDup", (Locale)ctx.getOriginLocale());
                    MessageFormat mf = new MessageFormat(msg);
                    msg = mf.format(new Object[]{number});
                    throw new TaskExternalException(msg);
                }
                if (name.equals(tcInfo.getName())) {
                    String msg = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"85_triggerConditionNameDup", (Locale)ctx.getOriginLocale());
                    MessageFormat mf = new MessageFormat(msg);
                    msg = mf.format(new Object[]{name});
                    throw new TaskExternalException(msg);
                }
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException("checkDup: ", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        TriggerConditionInfo info = new TriggerConditionInfo();
        String number = this.fecthData(hsData, "FNumber");
        if (StringUtil.isEmptyString((String)number)) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_NumberNull", (Locale)ctx.getOriginLocale()));
        }
        number = number.replaceAll(" ", "");
        info.setNumber(number);
        String name = this.fecthData(hsData, "FName");
        if (StringUtil.isEmptyString((String)name)) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_NameNull", (Locale)ctx.getOriginLocale()));
        }
        boolean isMultiLanguages = ResourceProviderManager.isMultiLanguages();
        if (isMultiLanguages) {
            info.setName(name, LocaleUtils.locale_en_US);
            info.setName(name, LocaleUtils.locale_zh_CN);
            info.setName(name, LocaleUtils.locale_zh_TW);
        } else {
            info.setName(name);
        }
        this.checkDup(ctx, number, name);
        String lFormula = this.fecthData(hsData, "FLFormula");
        if (StringUtil.isEmptyString((String)lFormula)) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"49_lFormulaNull", (Locale)ctx.getOriginLocale()));
        }
        info.setLFormula(lFormula);
        String operateSymbol = this.fecthData(hsData, "FOperateSymbol");
        OperateSymbolEnum operateSymbolEnum = this.getOperateSymbolEnum(ctx, operateSymbol);
        if (operateSymbolEnum == null) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"50_operateSymbolNull", (Locale)ctx.getOriginLocale()));
        }
        info.setOperateSymbol(operateSymbolEnum);
        String rFormula = this.fecthData(hsData, "FRFormula");
        if (StringUtil.isEmptyString((String)rFormula)) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"51_rFormulaNull", (Locale)ctx.getOriginLocale()));
        }
        info.setRFormula(rFormula);
        String isForbit = this.fecthData(hsData, "FIsForbit");
        if (StringUtil.isEmptyString((String)isForbit)) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"52_isForbitNull", (Locale)ctx.getOriginLocale()));
        }
        info.setIsForbit(this.getBooleanFromAlias(isForbit, ctx));
        String description = this.fecthData(hsData, "FDescription");
        if (isMultiLanguages) {
            info.setDescription(description, LocaleUtils.locale_en_US);
            info.setDescription(description, LocaleUtils.locale_zh_CN);
            info.setDescription(description, LocaleUtils.locale_zh_TW);
        } else {
            info.setDescription(description);
        }
        info.setDescription(description);
        String accessSource = this.fecthData(hsData, "FAccessSource");
        AccessSourceEnum accessSourceEnum = this.getAccessSourceEnum(ctx, accessSource);
        if (accessSourceEnum == null) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"53_accessSourceNull", (Locale)ctx.getOriginLocale()));
        }
        info.setAccessSource(accessSourceEnum);
        info.setIsDefault(Boolean.FALSE);
        info.setClassName(null);
        if (ContextUtil.getCurrentOrgUnit((Context)ctx) != null) {
            try {
                ObjectStringPK companyPK = new ObjectStringPK(ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString());
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)companyPK);
                info.setTrackRecordCreator(company);
            }
            catch (EASBizException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
        return info;
    }

    private AccessSourceEnum getAccessSourceEnum(Context ctx, String name) {
        Iterator iterator = AccessSourceEnum.iterator();
        while (iterator.hasNext()) {
            AccessSourceEnum accessSourceEnum = (AccessSourceEnum)((Object)iterator.next());
            if (!accessSourceEnum.getAlias(ctx.getOriginLocale()).equals(name)) continue;
            return accessSourceEnum;
        }
        return null;
    }

    private boolean getBooleanFromAlias(String bool, Context ctx) {
        if (StringUtils.isEmpty((String)bool)) {
            return false;
        }
        String upperCase = bool.toUpperCase(ctx.getOriginLocale());
        return ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"RptItem_Yes", (Locale)ctx.getOriginLocale()).equals(upperCase) || ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"RptItem_True", (Locale)ctx.getOriginLocale()).equals(upperCase) || "Y".equals(upperCase) || "TRUE".equals(upperCase);
    }

    private OperateSymbolEnum getOperateSymbolEnum(Context ctx, String name) {
        Iterator iterator = OperateSymbolEnum.iterator();
        while (iterator.hasNext()) {
            OperateSymbolEnum operateSymbolEnum = (OperateSymbolEnum)iterator.next();
            if (!operateSymbolEnum.getAlias(ctx.getOriginLocale()).equals(name)) continue;
            return operateSymbolEnum;
        }
        return null;
    }

    private String fecthData(Hashtable htData, String key) {
        DataToken dataToken = (DataToken)htData.get(key);
        if (dataToken != null) {
            return dataToken.toString();
        }
        return null;
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            if (rs.getString("number") != null) {
                result.put("FNumber", rs.getString("number"));
            }
            if (rs.getString("name") != null) {
                result.put("FName", rs.getString("name"));
            }
            if (rs.getString("lFormula") != null) {
                result.put("FLFormula", rs.getString("lFormula"));
            }
            result.put("FOperateSymbol", OperateSymbolEnum.getEnum((int)rs.getInt("operateSymbol")).getAlias(ctx.getOriginLocale()));
            if (rs.getString("rFormula") != null) {
                result.put("FRFormula", rs.getString("rFormula"));
            }
            if (rs.getBoolean("isForbit")) {
                result.put("FIsForbit", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"793_RptItemDataImport", (Locale)ctx.getOriginLocale()));
            } else {
                result.put("FIsForbit", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"794_RptItemDataImport", (Locale)ctx.getOriginLocale()));
            }
            if (rs.getString("description") != null) {
                result.put("FDescription", rs.getString("description"));
            }
            result.put("FAccessSource", AccessSourceEnum.getEnum(rs.getInt("accessSource")).getAlias(ctx.getOriginLocale()));
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.newrpt.investworkpaper.TriggerConditionForExportQuery";
    }

    public String getMainField() {
        return "FNumber";
    }

    public int getSubmitType() {
        return 0;
    }

    public void setContextParameter(Hashtable param) {
        param.put("mainQueryPK", MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fi.newrpt.investworkpaper.TriggerConditionForExportQuery"));
        super.setContextParameter((Map)param);
    }
}

