/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.jiuqirpa.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.jiuqirpa.EASJiuqiTempMappingEntryInfo;
import com.kingdee.eas.fi.newrpt.jiuqirpa.EASJiuqiTempMappingInfo;
import com.kingdee.eas.fi.newrpt.jiuqirpa.ExJiuqiRptSchmFactory;
import com.kingdee.eas.fi.newrpt.jiuqirpa.ExJiuqiRptSchmInfo;
import com.kingdee.eas.fi.newrpt.jiuqirpa.ExportJiuqiInfo;
import com.kingdee.eas.fi.newrpt.jiuqirpa.GroupOrCslEnum;
import com.kingdee.eas.fi.newrpt.jiuqirpa.app.AbstractExJiuqiRptSchmControllerBean;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ExJiuqiRptSchmControllerBean
extends AbstractExJiuqiRptSchmControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.jiuqirpa.app.ExJiuqiRptSchmControllerBean");

    @Override
    protected Map _getSchmReportForExeRPA(Context ctx, String schmInfoId) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(schmInfoId);
        ExJiuqiRptSchmInfo schmInfo = ExJiuqiRptSchmFactory.getLocalInstance(ctx).getExJiuqiRptSchmInfo((IObjectPK)pk);
        Calendar calender = Calendar.getInstance();
        List times = RPTDateUtil.getRptPeriod((Date)calender.getTime(), (RptPeriodTypeEnum)schmInfo.getPeriodType());
        int curYear = new Integer(times.get(0).toString());
        int curPeriod = new Integer(times.get(1).toString());
        int[] rptYearAndPeriod = RPTDateUtil.getRptYearAndPeriod((int)curYear, (int)curPeriod, (int)schmInfo.getPeriodType().getValue(), (int)schmInfo.getYear(), (int)schmInfo.getPeriod());
        ArrayList<Object> sqlParams = new ArrayList<Object>();
        StringBuffer getReportSql = new StringBuffer();
        getReportSql.append("select orgMapping.FJiuqiOrgNumber jqOrgNumber,orgMapping.FJiuqiOrgName jqOrgName,orgMapping.FJiuqiRptType jqRptType,\n");
        getReportSql.append("org.fnumber orgNumber,org.fid orgId,schmOrgE.FJiuqiRptType orgJQRptType,jiuqiTask.FNumber taskNumber, \n");
        getReportSql.append("report.fid rptId, report.fname rptName,report.fyear rptYear ,report.fperiod rptPeriod,report.FSOURCETYPE srcType,tempMapping.FCellMappingString cellM, \n");
        getReportSql.append("jiuqiTemp.Fnumber jqRptNumber, TempMappingE.FEASSheetName sheetName,TempMappingE.FCellData cellData,TempMappingE.FRate rate \n");
        if (GroupOrCslEnum.cslRpt.equals((Object)schmInfo.getGroupOrCsl())) {
            getReportSql.append(",tree.FNumber treeNumber \n");
        }
        getReportSql.append("from T_CSL_ExJiuqiRptSchm schm ");
        getReportSql.append("join T_CSL_EXJiuqiRptSchmOrgEntry schmOrgE on schm.fid=schmOrgE.FExJiuqiRptSchm \n");
        getReportSql.append("join T_CSL_EXJiuqiRptSchmTemp schmTempE on schm.fid=schmTempE.FExJiuqiRptSchm \n");
        getReportSql.append("join T_CSL_EASJiuqiTempMapping tempMapping on tempMapping.FEASTempGroup=schmTempE.FGroup \n");
        getReportSql.append("join T_CSL_EASJiuqiTempMappingEntry TempMappingE on tempMapping.FID=TempMappingE.FEASJiuqiTempMapping \n");
        getReportSql.append("join T_CSL_JiuqiRptTemplate jiuqiTemp on jiuqiTemp.FID=TempMappingE.FJiuqiRptTempId \n");
        getReportSql.append("join T_CSL_JiuqiTask jiuqiTask on jiuqiTask.FID=jiuqiTemp.FJjiuqiTask \n");
        getReportSql.append("join t_rpt_template template on template.FGroup=schmTempE.FGroup \n");
        getReportSql.append("join t_csl_cslreport report on template.fid=report.ftemplateid \n");
        getReportSql.append("join t_bd_currency currency on schm.FCurrencyID=currency.fid and report.FCURRENCYID=currency.fid \n");
        if (GroupOrCslEnum.groupRpt.equals((Object)schmInfo.getGroupOrCsl())) {
            getReportSql.append("join t_org_baseunit org on org.fid=schmOrgE.FOrgID and org.fid=report.FOrgUnitID \n");
            getReportSql.append("join T_CSL_EASJiuqiOrgMapping orgMapping on org.fid=orgMapping.FOrgUnit \n");
        } else {
            getReportSql.append("join T_CSL_EASJiuqiOrgMapping orgMapping on schmOrgE.FTreeNumber=orgMapping.FTreeNumber and  schmOrgE.FOrgNumber=orgMapping.FOrgNumber \n");
            getReportSql.append("join T_ORG_TREE tree on tree.FID = report.forgtreeid and schmOrgE.FTreeNumber=tree.fnumber \n");
            getReportSql.append("join T_ORG_BASEUNIT org on  report.FOrgUnitID = org.FID and schmOrgE.FOrgNumber=org.fnumber and org.fisunion=1 \n");
        }
        getReportSql.append("where report.fyear=? and report.fperiod=? and schm.fid=? \n");
        getReportSql.append("and schm.FgroupOrCsl=? \n ");
        getReportSql.append("order by ");
        if (GroupOrCslEnum.cslRpt.equals((Object)schmInfo.getGroupOrCsl())) {
            getReportSql.append("tree.FNumber ,");
        }
        getReportSql.append(" org.fnumber \n");
        sqlParams.add(rptYearAndPeriod[0]);
        sqlParams.add(rptYearAndPeriod[1]);
        sqlParams.add(schmInfoId);
        sqlParams.add(schmInfo.getGroupOrCsl().getValue());
        IRowSet rs = DbUtil.executeQuery(ctx, getReportSql.toString(), sqlParams.toArray());
        HashMap<String, ExportJiuqiInfo> datas = new HashMap<String, ExportJiuqiInfo>();
        try {
            String key = null;
            String treeNumber = "";
            String orgNumber = null;
            CslReportInfo rptInfo = null;
            ExportJiuqiInfo exportJiuqiInfo = null;
            EASJiuqiTempMappingInfo reportMappingData = null;
            EASJiuqiTempMappingEntryInfo reportMappingDataEntry = null;
            while (rs.next()) {
                key = orgNumber = rs.getString("orgNumber");
                if (GroupOrCslEnum.cslRpt.equals((Object)schmInfo.getGroupOrCsl())) {
                    treeNumber = rs.getString("treeNumber");
                    key = treeNumber + " " + orgNumber;
                }
                if ((exportJiuqiInfo = (ExportJiuqiInfo)datas.get(key)) == null) {
                    exportJiuqiInfo = new ExportJiuqiInfo();
                    exportJiuqiInfo.setJiuqiOrgNumber(rs.getString("jqOrgNumber").trim());
                    exportJiuqiInfo.setJiuqiOrgName(rs.getString("jqOrgName").trim());
                    String jiuqiRptType = rs.getString("orgJQRptType");
                    if (StringUtils.isEmpty((String)jiuqiRptType)) {
                        jiuqiRptType = rs.getString("jqRptType");
                    }
                    exportJiuqiInfo.setJiuqiRptType(jiuqiRptType);
                    datas.put(key, exportJiuqiInfo);
                }
                rptInfo = new CslReportInfo();
                rptInfo.setId(BOSUuid.read((String)rs.getString("rptId")));
                rptInfo.setName(rs.getString("rptName"));
                rptInfo.setYear(rs.getInt("rptYear"));
                rptInfo.setPeriod((short)rs.getInt("rptPeriod"));
                rptInfo.setSourceType(RptSrcTypeEnum.getEnum((int)rs.getInt("srcType")));
                FullOrgUnitInfo org = new FullOrgUnitInfo();
                org.setId(BOSUuid.read((String)rs.getString("orgId")));
                rptInfo.setOrgUnit(org);
                reportMappingData = exportJiuqiInfo.getReportMappingData().get(rptInfo);
                if (reportMappingData == null) {
                    reportMappingData = new EASJiuqiTempMappingInfo();
                    reportMappingData.setCellMappingString(rs.getString("cellM"));
                    reportMappingData.setJiuqiTaskNumber(rs.getString("taskNumber"));
                    exportJiuqiInfo.getReportMappingData().put(rptInfo, reportMappingData);
                }
                reportMappingDataEntry = new EASJiuqiTempMappingEntryInfo();
                reportMappingDataEntry.setEasSheetName(rs.getString("sheetName"));
                reportMappingDataEntry.setRate(rs.getInt("rate"));
                reportMappingDataEntry.setString("jqRptNumber", rs.getString("jqRptNumber"));
                reportMappingDataEntry.setCellData(this.toBytes(rs.getBlob("cellData")));
                reportMappingData.getEntry().add(reportMappingDataEntry);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"get report data for rpa error", (Throwable)e);
        }
        HashMap<ExJiuqiRptSchmInfo, HashMap<String, ExportJiuqiInfo>> result = new HashMap<ExJiuqiRptSchmInfo, HashMap<String, ExportJiuqiInfo>>();
        if (datas.size() > 0) {
            result.put(schmInfo, datas);
        }
        return result;
    }

    private byte[] toBytes(Blob data) throws SQLException {
        if (data == null) {
            return null;
        }
        InputStream in = data.getBinaryStream();
        if (in == null) {
            return null;
        }
        int blockSize = 1024;
        byte[] block = new byte[1024];
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        int len = -1;
        do {
            try {
                len = in.read(block);
            }
            catch (IOException e1) {
                throw new SQLException(e1.getMessage());
            }
            if (len <= 0) continue;
            byteOut.write(block, 0, len);
        } while (len == 1024);
        return byteOut.toByteArray();
    }

    @Override
    protected Map _getSchmReportForExeRPAByIds(Context ctx, List schmInfoIds) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        for (int i = 0; i < schmInfoIds.size(); ++i) {
            result.putAll(this._getSchmReportForExeRPA(ctx, (String)schmInfoIds.get(i)));
        }
        return result;
    }
}

