/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.mapping.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.newrpt.mapping.InteRptItemMappingInfo;
import com.kingdee.eas.fi.newrpt.mapping.MathSymbols;
import com.kingdee.eas.fi.newrpt.mapping.TemplateMappingInfo;
import com.kingdee.eas.fi.newrpt.mapping.app.AbstractTemplateMappingControllerBean;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class TemplateMappingControllerBean
extends AbstractTemplateMappingControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.mapping.app.TemplateMappingControllerBean");

    @Override
    protected Map _getTemplateMapData(Context ctx, Map params) throws BOSException, EASBizException {
        CslReportInfo reportInfo;
        String companyNumber = null;
        String orgTreeNumber = null;
        HashSet<String> treeSet = new HashSet<String>();
        MathSymbols symbols = null;
        HashMap<String, String> srcUnitInfo = new HashMap<String, String>();
        HashMap<String, Cloneable> resultData = new HashMap<String, Cloneable>();
        ArrayList<InteRptItemMappingInfo> itemMaps = new ArrayList<InteRptItemMappingInfo>();
        StringBuilder tempSQL = null;
        if (params.get("reportInfo") instanceof CslReportInfo) {
            reportInfo = (CslReportInfo)params.get("reportInfo");
            companyNumber = reportInfo.getOrgUnit().getNumber();
            orgTreeNumber = reportInfo.getOrgTree().getNumber();
        } else {
            reportInfo = (ReportBaseInfo)params.get("reportInfo");
            companyNumber = reportInfo.getCompany().getNumber();
            if (reportInfo.getOrgTree() != null) {
                orgTreeNumber = reportInfo.getOrgTree().getNumber();
            } else {
                String reportid = reportInfo.getId().toString();
                tempSQL = new StringBuilder();
                tempSQL.append(" SELECT tree.fnumber  fnumber FROM T_CSL_RptReceived  receive              \n");
                tempSQL.append(" inner join T_CSL_cslreport cslreport on cslreport.fid = receive.FREPORTID \n");
                tempSQL.append(" inner JOIN T_Rpt_REPORT report ON cslreport.fid = report.FCSLREPORTID     \n");
                tempSQL.append(" INNER JOIN T_ORG_Tree tree ON receive.FORGTREEID  = tree.fid              \n");
                tempSQL.append(" where report.fid ='").append(reportid).append("'");
                IRowSet rowsetss = DbUtil.executeQuery((Context)ctx, (String)tempSQL.toString());
                try {
                    while (rowsetss.next()) {
                        String treeNum = rowsetss.getString("fnumber");
                        if (treeNum == null) continue;
                        treeSet.add(treeNum);
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)("TemplateMappingControllerBean._extractData error,sql : \n" + tempSQL), (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
            }
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select  tree.fnumber treenumber, unit.fnumber unitnumber,unit.FIsUnion isUnion, itemmap.FSsourceDataElementNum FSsourceDataElementNum,         \n");
        sql.append(" itemmap.FSourceRptItemNum FSourceRptItemNum,itemmap.FTargetRptItemNum FTargetRptItemNum,solu.FNUMBER solunumber,itemmap.FPlusMinus FPlusMinus, \n");
        sql.append(" mapentry.FIsSupportGroupReport FIsSupportGroupReport,itemmap.FTargetDataElementNum FTargetDataElementNum                                       \n");
        sql.append(" from T_CSL_TemplateMapping map \n");
        sql.append(" INNER JOIN T_CSL_TemplateMappingentry  mapentry on map.fid = mapentry.FTemplateMappingId \n");
        sql.append(" INNER JOIN T_ORG_Tree tree on tree.fid = mapentry.FSrcOrgBoundId \n");
        sql.append(" INNER JOIN T_ORG_BaseUnit unit on unit.fid = mapentry.FSrcOrgId \n");
        sql.append(" INNER JOIN T_ORG_Tree TARGETtree ON TARGETtree.FID =  mapentry.FTargetOrgBoundId  \n");
        sql.append(" INNER JOIN T_ORG_BaseUnit TARGETunit on TARGETunit.fid = mapentry.FTargetOrgId  \n");
        sql.append(" INNER JOIN T_CSL_InteRptItemMapping itemmap on  itemmap.FTemplateMappingSolu = map.fid \n");
        sql.append(" LEFT  JOIN T_CSL_FastMergeSolu solu on solu.FID  = mapentry.FMergeSolutionId ");
        if (orgTreeNumber != null) {
            sql.append(" where  TARGETtree.FNUMBER = '").append(orgTreeNumber).append("'");
        } else if (treeSet.size() > 0) {
            sql.append(" where  TARGETtree.FNUMBER in (").append(this.getSqlIdsStrForColl(treeSet)).append(")");
        } else {
            return null;
        }
        sql.append(" and TARGETunit.FNUMBER = '").append(companyNumber).append("'");
        IRowSet rowsets = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowsets == null) {
                return null;
            }
            while (rowsets.next()) {
                srcUnitInfo.put("treenumber", rowsets.getString("treenumber"));
                srcUnitInfo.put("isUnion", rowsets.getInt("isUnion") == 1 ? "yes" : "no");
                srcUnitInfo.put("unitnumber", rowsets.getString("unitnumber"));
                srcUnitInfo.put("solunumber", rowsets.getString("solunumber"));
                srcUnitInfo.put("FIsSupportGroupReport", rowsets.getString("FIsSupportGroupReport"));
                InteRptItemMappingInfo itemmapInfo = new InteRptItemMappingInfo();
                itemmapInfo.setSourceRptItemNum(rowsets.getString("FSourceRptItemNum"));
                itemmapInfo.setSourceDataElementNum(rowsets.getString("FSsourceDataElementNum"));
                itemmapInfo.setTargetRptItemNum(rowsets.getString("FTargetRptItemNum"));
                itemmapInfo.setTargetDataElementNum(rowsets.getString("FTargetDataElementNum"));
                symbols = rowsets.getInt("FPlusMinus") == 1 ? MathSymbols.plus : MathSymbols.minus;
                itemmapInfo.setPlusMinus(symbols);
                itemMaps.add(itemmapInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)("TemplateMappingControllerBean._extractData error,sql : \n" + sql), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        resultData.put("srcUnitInfo", srcUnitInfo);
        resultData.put("itemMaps", itemMaps);
        return resultData;
    }

    public String getFmtDateAndTime(Date date) {
        Date bdate = new Date(date.getYear(), date.getMonth(), date.getDate());
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df.format(bdate);
    }

    public String getSqlIdsStrForColl(Collection coll) {
        StringBuffer str = new StringBuffer();
        Iterator it = coll.iterator();
        int i = 0;
        String id = null;
        while (it.hasNext()) {
            id = it.next().toString();
            if (id == null) continue;
            if (i != 0) {
                str.append(",'" + id + "'");
            } else {
                str.append("'" + id + "'");
            }
            ++i;
        }
        return str.toString();
    }

    @Override
    protected boolean _updateTempMapObject(Context ctx, IObjectCollection updateCols) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        TemplateMappingInfo mappingInfo = null;
        sql.append(" UPDATE T_CSL_TemplateMapping SET fnumber= ?,fname_l2= ?  WHERE  fid= ? ");
        for (int i = 0; i < updateCols.size(); ++i) {
            mappingInfo = (TemplateMappingInfo)updateCols.getObject(i);
            Object[] params = new Object[]{mappingInfo.getNumber(), mappingInfo.getName(), mappingInfo.getId().toString()};
            paramsList.add(params);
        }
        DbUtil.executeBatch((Context)ctx, (String)sql.toString(), paramsList);
        return true;
    }
}

