/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.online;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.BookFormulaHelper;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.DataElementFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.DebitOrCreditEnum;
import com.kingdee.eas.fi.gr.cslrpt.DynaEnumRptTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.IDataElement;
import com.kingdee.eas.fi.gr.cslrpt.IRPTItem;
import com.kingdee.eas.fi.gr.cslrpt.IReportClass;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTEffectItemEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemControlEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemGroupEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemMappingInfo;
import com.kingdee.eas.fi.gr.cslrpt.ReportClassFactory;
import com.kingdee.eas.fi.gr.cslrpt.ReportClassInfo;
import com.kingdee.eas.fi.newrpt.online.DownTemplateObject;
import com.kingdee.eas.fi.newrpt.online.FileObject;
import com.kingdee.eas.fi.newrpt.online.Resource;
import com.kingdee.eas.fi.newrpt.report.VariablesHelper;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.TemplateTypeFactory;
import com.kingdee.eas.fi.rpt.TemplateTypeInfo;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.IntEnum;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;

public class ResourceUtil {
    private static final Logger logger = CoreUIObject.getLogger(ResourceUtil.class);
    private static final String WEBURL = "http://web20.kingdee.com/user/res";
    private static String customerNum;
    public static final int IMPORT_TABLE = 0;
    public static final int IMPORT_ITEM = 1;
    public static final int IMPORT_FORMULA = 2;
    public static final int IMPORT_ALL = 3;
    public static final String CONFIG_TABLE = "Config Table";
    public static final String ITEM_PROPERTIES = "Item Properties";
    public static final String RESULT_SUCCESS = "success";
    public static final String ONLINE_RESOURCE = "com.kingdee.eas.fi.gr.cslrpt.RptSpecialResource";
    private static final Set<String> suffixSet;

    public ArrayList getResource(String type) {
        ArrayList<Resource> resList = new ArrayList<Resource>();
        JSONObject json = this.getResJson(type);
        if (json != null && json.get("error") == null) {
            JSONArray rsArray = json.getJSONArray("rs2");
            int len = rsArray.size();
            for (int j = 0; j < len; ++j) {
                JSONObject rs = rsArray.getJSONObject(j);
                String id = rs.getString("_id");
                String name = rs.getString("name");
                String desc = rs.getString("desc");
                String num = rs.getString("num");
                String updateTime = rs.getString("udate");
                String version = rs.getString("version");
                Resource res = new Resource(id, desc, name, num, updateTime, version);
                int sc = rs.optInt("scorec", 1);
                long ss = rs.optLong("scores", 5L);
                res.score = sc == 0 ? 5 : (int)(ss / (long)sc);
                res.tags = rs.optString("tags");
                res.doc = rs.optString("doc");
                res.profile = rs.optString("profile");
                res.user = rs.optString("user");
                resList.add(res);
            }
        }
        return resList;
    }

    private JSONObject getResJson(String type) {
        String uri = "http://web20.kingdee.com/user/res?type=" + type;
        return ResourceUtil.getJSON(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject getJSON(String uri) {
        JSONObject json = null;
        String encoding = "utf-8";
        customerNum = ResourceUtil.getCustomerNumber();
        HttpURLConnection con = null;
        BufferedReader reader = null;
        try {
            String lines;
            uri = uri + "&cno=" + customerNum;
            URL getUrl = new URL(uri);
            con = (HttpURLConnection)getUrl.openConnection();
            con.connect();
            reader = new BufferedReader(new InputStreamReader(con.getInputStream(), encoding));
            String jsonStr = "";
            while ((lines = reader.readLine()) != null) {
                jsonStr = jsonStr + lines;
            }
            json = JSONObject.fromObject((Object)jsonStr);
        }
        catch (MalformedURLException e) {
            logger.error((Object)("MalformedURLException:" + e));
        }
        catch (IOException e) {
            logger.error((Object)("IOException:" + e));
        }
        catch (JSONException e) {
            logger.error((Object)("JSONException:" + (Object)((Object)e)));
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.error((Object)"reader.close()", (Throwable)e);
                }
            }
        }
        return json;
    }

    public static String getCustomerNumber() {
        String cNum = "unkonwn";
        try {
            ILicenseSrvAgent agent = LicenseSrvAgentFactory.getRemoteInstance();
            LicenseBaseInfo baseInfo = agent.getLicenseBaseInfo();
            cNum = baseInfo.getSerialNum();
        }
        catch (Exception e) {
            logger.error((Object)("getLicenseException:" + e));
        }
        return cNum;
    }

    public static Resource getResList(String id, String searchName) throws Exception {
        JSONObject rs;
        Resource res = null;
        JSONObject json = null;
        json = null != searchName && !"".equals(searchName) ? ResourceUtil.getSearchFileJSON(id, searchName) : ResourceUtil.getFileJSON(id);
        if (json != null && !(rs = json.getJSONObject("u")).isNullObject()) {
            String desc = rs.optString("desc");
            String name = rs.optString("name");
            String num = rs.optString("num");
            String updateTime = rs.optString("udate");
            String version = rs.optString("version");
            res = new Resource(id, desc, name, num, updateTime, version);
            res.setFileList(ResourceUtil.getFileList(json, id, version));
        }
        return res;
    }

    private static JSONObject getFileJSON(String id) {
        String uri = "http://web20.kingdee.com/user/res/view?id=" + id;
        return ResourceUtil.getJSON(uri);
    }

    private static JSONObject getSearchFileJSON(String id, String searchName) {
        String codeName = null;
        try {
            codeName = URLEncoder.encode(searchName, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e);
        }
        String uri = "http://web20.kingdee.com/user/res/search?id=" + id + "&q=" + codeName;
        return ResourceUtil.getJSON(uri);
    }

    private static ArrayList getFileList(JSONObject json, String resId, String version) throws Exception {
        ArrayList fileList = new ArrayList();
        if (json != null && json.has("fs")) {
            JSONArray fs = json.getJSONArray("fs");
            int len = fs.size();
            for (int i = 0; i < len; ++i) {
                JSONObject fileJson = fs.getJSONObject(i);
                FileObject file = new FileObject(fileJson.getString("_id"), fileJson.getString("filename"), fileJson.getString("length"), fileJson.getString("uploadDate"));
                file.setAliases(fileJson.getString("aliases"));
                ResourceUtil.setDownTemplate(file, resId, version);
                fileList.add(file);
            }
        }
        fileList = ResourceUtil.sortFileList(fileList);
        return fileList;
    }

    private static ArrayList sortFileList(ArrayList fileList) {
        ArrayList rtnFileList = new ArrayList();
        for (int i = 0; i < fileList.size(); ++i) {
            boolean hasAdd = false;
            for (int j = 0; j < rtnFileList.size(); ++j) {
                FileObject fromFileObject = (FileObject)fileList.get(i);
                FileObject toFileObject = (FileObject)rtnFileList.get(j);
                if (fromFileObject.getDownTemplate() == null || toFileObject.getDownTemplate() == null || fromFileObject.getDownTemplate().getNumber().compareTo(toFileObject.getDownTemplate().getNumber()) >= 0) continue;
                rtnFileList.add(j, fileList.get(i));
                hasAdd = true;
                break;
            }
            if (hasAdd) continue;
            rtnFileList.add(fileList.get(i));
        }
        return rtnFileList;
    }

    private static void setDownTemplate(FileObject file, String resId, String version) throws Exception {
        Book book = ResourceUtil.generateBook(resId, version, file.getName());
        if (book == null) {
            return;
        }
        Sheet configTable = book.getSheet(CONFIG_TABLE);
        if (configTable != null) {
            String number = null;
            String name = null;
            String periodType = null;
            String templateType = null;
            String dynaRptType = null;
            if (configTable.getRange(7, 2).getValue() != null) {
                number = configTable.getRange(7, 2).getValue().toString();
            }
            if (configTable.getRange(8, 2).getValue() != null) {
                name = configTable.getRange(8, 2).getValue().toString();
            }
            if (configTable.getRange(9, 2).getValue() != null) {
                templateType = configTable.getRange(9, 2).getValue().toString();
                IntEnum templateTypeEnum = ResourceUtil.getEnumByAliase(RptTmpTypeEnum.class, templateType);
                templateType = templateTypeEnum.getValue() + "";
            }
            if (configTable.getRange(10, 2).getValue() != null) {
                periodType = configTable.getRange(10, 2).getValue().toString();
                IntEnum eriodTypeEnum = ResourceUtil.getEnumByAliase(RptPeriodTypeEnum.class, periodType);
                periodType = eriodTypeEnum.getValue() + "";
            }
            if (configTable.getRange(11, 2).getValue() != null) {
                dynaRptType = configTable.getRange(11, 2).getValue().toString();
                IntEnum dynaRptTypeEnum = ResourceUtil.getEnumByAliase(DynaEnumRptTypeEnum.class, dynaRptType);
                dynaRptType = dynaRptTypeEnum.getValue() + "";
            }
            file.setDownTemplate(number, name, periodType, templateType, dynaRptType);
        } else {
            file.setDownTemplate("lmp2014_ymb", "lmp2014_ymb", "3", "6", "1");
        }
    }

    public byte[] getFileAsByte(String resId, String version, String name) throws UnsupportedEncodingException {
        String codeName = URLEncoder.encode(name, "utf-8");
        String uri = "http://web20.kingdee.com/user/res/dnload?id=" + resId + "&version=" + version + "&name=" + codeName + "&cno=" + ResourceUtil.getCustomerNumber();
        HttpClient httpClient = new HttpClient();
        GetMethod httpGet = new GetMethod(uri);
        byte[] fileContent = null;
        try {
            httpClient.executeMethod((HttpMethod)httpGet);
            if (httpGet.getStatusCode() != 200) {
                MsgBox.showError((String)ResourceUtil.getResString("download.error"), (String)httpGet.getStatusLine().getReasonPhrase());
                return null;
            }
            InputStream in = httpGet.getResponseBodyAsStream();
            BufferedInputStream bis = new BufferedInputStream(in);
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int size = 0;
            while ((size = bis.read(buf)) != -1) {
                bao.write(buf, 0, size);
            }
            fileContent = bao.toByteArray();
            bao.close();
            bis.close();
        }
        catch (IOException e) {
            logger.error((Object)e);
            MsgBox.showError((String)ResourceUtil.getResString("download.error"));
        }
        httpGet.releaseConnection();
        return fileContent;
    }

    public static InputStream getStream(String resId, String name, String version) throws UnsupportedEncodingException {
        String codeName = URLEncoder.encode(name, "utf-8");
        String uri = "http://web20.kingdee.com/user/res/dnload?id=" + resId + "&version=" + version + "&name=" + codeName + "&cno=" + ResourceUtil.getCustomerNumber();
        HttpClient httpClient = new HttpClient();
        GetMethod httpGet = new GetMethod(uri);
        InputStream stream = null;
        try {
            httpClient.executeMethod((HttpMethod)httpGet);
            if (httpGet.getStatusCode() != 200) {
                MsgBox.showError((String)ResourceUtil.getResString("download.error"), (String)httpGet.getStatusLine().getReasonPhrase());
                return null;
            }
            stream = httpGet.getResponseBodyAsStream();
        }
        catch (IOException e) {
            logger.error((Object)e);
            MsgBox.showError((String)ResourceUtil.getResString("download.error"));
        }
        return stream;
    }

    public static String restoreTemplateByFile(String resId, String version, FileObject fileobject, int option, String displayTemplateType) throws Exception {
        String resultStr = RESULT_SUCCESS;
        Book book = ResourceUtil.generateBook(resId, version, fileobject.getName());
        ReportVariables variables = ReportVariables.loadFromBook((Book)book);
        TemplateInfo templateInfo = ResourceUtil.getTemplateInfoByDownTemplate(fileobject.getDownTemplate());
        templateInfo.getSheetParam().clear();
        if (templateInfo.getNumber().equals("004") && !ResourceUtil.checkDataElementIsExsit("TSPLY")) {
            IDataElement iDataElement = DataElementFactory.getRemoteInstance();
            DataElementInfo dataElementInfo = new DataElementInfo();
            dataElementInfo.setNumber("TSPLY");
            dataElementInfo.setName(EASCommonResource.getString((String)ONLINE_RESOURCE, (String)"downtemplate.dataelement.tsply", (Locale)LocaleUtils.locale_l1), LocaleUtils.locale_l1);
            dataElementInfo.setName(EASCommonResource.getString((String)ONLINE_RESOURCE, (String)"downtemplate.dataelement.tsply", (Locale)LocaleUtils.locale_l2), LocaleUtils.locale_l2);
            dataElementInfo.setName(EASCommonResource.getString((String)ONLINE_RESOURCE, (String)"downtemplate.dataelement.tsply", (Locale)LocaleUtils.locale_l3), LocaleUtils.locale_l3);
            dataElementInfo.setIsUsedElim(true);
            dataElementInfo.setIsSys(true);
            dataElementInfo.setInterSeq(6);
            dataElementInfo.setSeq(6);
            iDataElement.addnew((CoreBaseInfo)dataElementInfo);
        }
        if (option == 3 || option == 1) {
            Sheet itemSheet = book.getSheet(ITEM_PROPERTIES);
            if (itemSheet == null) {
                return ResourceUtil.getResString("downtemplate.itemproperties.donot.exist");
            }
            resultStr = ResourceUtil.importItemPorperties(itemSheet, false);
            if (!resultStr.equals(RESULT_SUCCESS)) {
                return resultStr;
            }
            resultStr = ResourceUtil.importItemPorperties(itemSheet, true);
            if (!resultStr.equals(RESULT_SUCCESS)) {
                return resultStr;
            }
        }
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            ResourceUtil.croppSheet(book, sheet, option);
            String name = sheet.getSheetName();
            if (name.equals(CONFIG_TABLE)) {
                book.removeSheet(i);
                --i;
                continue;
            }
            if (name.equals(ITEM_PROPERTIES)) {
                book.removeSheet(i);
                --i;
                continue;
            }
            RptSheetParamInfo info = VariablesHelper.variables2SheetParams(variables, name, true, null);
            info.setSheetID(sheet.getID());
            info.setRelaType(ReportTypeEnum.TEMPLATE);
            templateInfo.getSheetParam().add(info);
        }
        RptUtilForClient.prepareReportInfo4Save((IObjectValue)templateInfo, (Book)book);
        templateInfo.setBook(book);
        if (!StringUtil.isEmpty((String)displayTemplateType) && !"111111111111111111111111110=".equals(displayTemplateType)) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)displayTemplateType));
            TemplateTypeInfo templateTypeInfo = TemplateTypeFactory.getRemoteInstance().getTemplateTypeInfo((IObjectPK)pk);
            templateInfo.setDisplayTemplateType(templateTypeInfo);
        }
        TemplateFactory.getRemoteInstance().addnew((CoreBaseInfo)templateInfo);
        return resultStr;
    }

    public static boolean checkDataElementIsExsit(String number) throws Exception {
        boolean isExist = false;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)number);
        filter.getFilterItems().add(filterItem);
        isExist = DataElementFactory.getRemoteInstance().exists(filter);
        return isExist;
    }

    public static String importItemPorperties(Sheet sheet, boolean isImportSumItem) throws Exception {
        return ResourceUtil.importItemPorperties(sheet, isImportSumItem, false);
    }

    public static String importItemPorperties(Sheet sheet, boolean isImportSumItem, boolean isNewGovAcct) throws Exception {
        String resStr = RESULT_SUCCESS;
        IRPTItem iRPTItem = RPTItemFactory.getRemoteInstance();
        CoreBaseCollection rptItemCollection = new CoreBaseCollection();
        CompanyOrgUnitInfo info = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo("where id='00000000-0000-0000-0000-000000000000CCE7AED4'");
        for (int i = 2; i < sheet.getRows().size(); ++i) {
            if (isImportSumItem ? sheet.getRange(i, 3).getValue() != null && StringUtils.isEmpty((String)sheet.getRange(i, 3).getValue().toString()) : sheet.getRange(i, 3).getValue() != null && !StringUtils.isEmpty((String)sheet.getRange(i, 3).getValue().toString())) continue;
            if (isNewGovAcct) {
                ResourceUtil.importReportClassPorperties(info);
            }
            RPTItemInfo rptItemInfo = new RPTItemInfo();
            String number = null;
            if (sheet.getRange(i, 11).getValue() == null || StringUtils.isEmpty((String)sheet.getRange(i, 11).getValue().toString()) || ResourceUtil.checkItemIsExsit(number = sheet.getRange(i, 11).getValue().toString())) continue;
            rptItemInfo.setNumber(number);
            rptItemInfo.setId(BOSUuid.create((BOSObjectType)rptItemInfo.getBOSType()));
            String simpleCode = null;
            if (sheet.getRange(i, 1).getValue() != null) {
                simpleCode = sheet.getRange(i, 1).getValue().toString();
                rptItemInfo.setSimpleCode(simpleCode);
            }
            String effectItem = null;
            if (sheet.getRange(i, 2).getValue() != null && !StringUtils.isEmpty((String)sheet.getRange(i, 2).getValue().toString())) {
                effectItem = sheet.getRange(i, 2).getValue().toString();
                rptItemInfo.setEffectItem(RPTEffectItemEnum.getEnum((int)Integer.parseInt(effectItem)));
            }
            String sumItemFormula = null;
            if (sheet.getRange(i, 3).getValue() != null && !StringUtils.isEmpty((String)sheet.getRange(i, 3).getValue().toString())) {
                sumItemFormula = sheet.getRange(i, 3).getValue().toString();
                rptItemInfo.setSumItemFormula(sumItemFormula);
                IRPTItem ie = RPTItemFactory.getRemoteInstance();
                RPTItemCollection subItems = ie.getItemListBySumItemFormula(sumItemFormula);
                if (subItems != null && subItems.size() != 0) {
                    RPTItemMappingInfo itemMapping = null;
                    if (rptItemInfo.getSumItems() != null) {
                        rptItemInfo.getSumItems().clear();
                    }
                    for (int j = 0; j < subItems.size(); ++j) {
                        itemMapping = new RPTItemMappingInfo();
                        itemMapping.setTargetItem(rptItemInfo);
                        itemMapping.setSourceItem(subItems.get(j));
                        rptItemInfo.getSumItems().add(itemMapping);
                    }
                }
            }
            String dc = null;
            if (sheet.getRange(i, 4).getValue() != null) {
                dc = sheet.getRange(i, 4).getValue().toString();
                rptItemInfo.setDc(DebitOrCreditEnum.getEnum((int)Integer.parseInt(dc)));
            }
            String itemGroup = null;
            if (sheet.getRange(i, 5).getValue() != null) {
                itemGroup = sheet.getRange(i, 5).getValue().toString();
                rptItemInfo.setItemGroup(RPTItemGroupEnum.getEnum((int)Integer.parseInt(itemGroup)));
            }
            String isFreezed = null;
            if (sheet.getRange(i, 6).getValue() != null) {
                isFreezed = sheet.getRange(i, 6).getValue().toString();
                rptItemInfo.setIsFreezed(Boolean.parseBoolean(isFreezed));
            }
            String isProfitAndLosses = null;
            if (sheet.getRange(i, 7).getValue() != null) {
                isProfitAndLosses = sheet.getRange(i, 7).getValue().toString();
                rptItemInfo.setIsProfitAndLosses(Boolean.parseBoolean(isProfitAndLosses));
            }
            String description = null;
            if (sheet.getRange(i, 8).getValue() != null) {
                description = sheet.getRange(i, 8).getValue().toString();
                rptItemInfo.setDescription(description);
            }
            String isSumItem = null;
            if (sheet.getRange(i, 9).getValue() != null) {
                isSumItem = sheet.getRange(i, 9).getValue().toString();
                rptItemInfo.setIsSumItem(Boolean.parseBoolean(isSumItem));
            }
            String reportClassID = null;
            if (sheet.getRange(i, 10).getValue() != null && !StringUtil.isEmpty((String)(reportClassID = sheet.getRange(i, 10).getValue().toString()))) {
                ReportClassInfo reportClassInfo = new ReportClassInfo();
                reportClassInfo.setId(BOSUuid.read((String)reportClassID));
                rptItemInfo.setReportClass(reportClassInfo);
            }
            String control = null;
            if (sheet.getRange(i, 12).getValue() != null) {
                control = sheet.getRange(i, 12).getValue().toString();
                rptItemInfo.setControl(RPTItemControlEnum.getEnum((int)Integer.parseInt(control)));
            }
            String name = null;
            if (sheet.getRange(i, 13).getValue() != null) {
                name = sheet.getRange(i, 13).getValue().toString().trim();
                rptItemInfo.setName(name);
            }
            rptItemInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            rptItemInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            rptItemInfo.setTrackRecordCreator(info);
            rptItemCollection.add((CoreBaseInfo)rptItemInfo);
        }
        Result result = iRPTItem.addnew(rptItemCollection);
        for (int j = 0; j < result.size(); ++j) {
            if (result.getLineResult(j).isSucess()) continue;
            return "fail";
        }
        return resStr;
    }

    private static void importReportClassPorperties(CompanyOrgUnitInfo info) throws Exception {
        CoreBaseCollection rptClassCollection = new CoreBaseCollection();
        IReportClass iReportClass = ReportClassFactory.getRemoteInstance();
        String[] ids = new String[]{"c6oAAAEX5HQKlo3f", "c6oAAAEX5HUKlo3f", "c6oAAAEX5HYKlo3f", "c6oAAAEX5HcKlo3f", "c6oAAAEX5HgKlo3f", "c6oAAAEX9AwKlo3f", "c6oAAAEX9AsKlo3f", "c6oAAAEZ1HEKlo3f"};
        String[] numbers = new String[]{"GOV001", "GOV002", "GOV003", "GOV004", "GOV005", "GOV006", "GOV007", "GOV008"};
        String[] names = new String[]{"Auto-Newgoveracct-01", "Auto-Newgoveracct-02", "Auto-Newgoveracct-03", "Auto-Newgoveracct-04", "Auto-Newgoveracct-05", "Auto-Newgoveracct-06", "Auto-Newgoveracct-07", "Auto-Newgoveracct-08"};
        String rptResource = "com.kingdee.eas.fi.rpt.RPTAutoGenerateResource";
        for (int i = 0; i < 8; ++i) {
            if (ResourceUtil.checkReportClassIsExsit(numbers[i])) continue;
            ReportClassInfo rptClassInfo = new ReportClassInfo();
            rptClassInfo.setId(BOSUuid.read((String)ids[i]));
            rptClassInfo.setNumber(numbers[i]);
            rptClassInfo.setName(numbers[i] + "-" + EASResource.getString((String)rptResource, (String)names[i]));
            rptClassInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            rptClassInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            rptClassInfo.setTrackRecordCreator(info);
            rptClassCollection.add((CoreBaseInfo)rptClassInfo);
        }
        iReportClass.addnew(rptClassCollection);
    }

    private static boolean checkItemIsExsit(String number) throws Exception {
        boolean isExist = false;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)number);
        filter.getFilterItems().add(filterItem);
        isExist = RPTItemFactory.getRemoteInstance().exists(filter);
        return isExist;
    }

    private static boolean checkReportClassIsExsit(String number) throws Exception {
        boolean isExist = false;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)number);
        filter.getFilterItems().add(filterItem);
        isExist = ReportClassFactory.getRemoteInstance().exists(filter);
        return isExist;
    }

    private static void croppSheet(Book book, Sheet sheet, int option) {
        if (option == 3) {
            return;
        }
        Sheet.ICellsIterator it = sheet.getCellsIterator(null, false, false);
        while (it.hasNext()) {
            Object itemFormula;
            Cell cell = it.next();
            String formula = cell.getFormula();
            if (option == 0) {
                itemFormula = cell.getUserObjectValue("ITEM");
                if (itemFormula instanceof ItemFormula) {
                    cell.removeUserObject("ITEM");
                }
                if (formula == null || formula.length() <= 0 || formula.charAt(0) != '=' || BookFormulaHelper.isExcelFunctionNodigit((Book)book, (Sheet)sheet, (String)formula)) continue;
                cell.setFormula(null);
                cell.setValue(Variant.nullVariant);
                continue;
            }
            if (option == 2) {
                itemFormula = cell.getUserObjectValue("ITEM");
                if (!(itemFormula instanceof ItemFormula)) continue;
                cell.removeUserObject("ITEM");
                continue;
            }
            if (option != 1 || formula == null || formula.length() <= 0 || formula.charAt(0) != '=' || BookFormulaHelper.isExcelFunctionNodigit((Book)book, (Sheet)sheet, (String)formula)) continue;
            cell.setFormula(null);
            cell.setValue(Variant.nullVariant);
        }
    }

    public static String checkDownTemplate(DownTemplateObject downTemplateObject) throws Exception {
        String resultStr = RESULT_SUCCESS;
        String number = downTemplateObject.getNumber();
        if (StringUtil.isEmpty((String)number)) {
            return ResourceUtil.getResString("downtemplate.number.not.null");
        }
        String name = downTemplateObject.getName();
        if (StringUtil.isEmpty((String)name)) {
            return ResourceUtil.getResString("downtemplate.name.not.null");
        }
        String templateType = downTemplateObject.getTemplateType();
        if (StringUtil.isEmpty((String)templateType)) {
            return ResourceUtil.getResString("downtemplate.templatetype.not.null");
        }
        String periodType = downTemplateObject.getPeriodType();
        if (StringUtil.isEmpty((String)periodType)) {
            return ResourceUtil.getResString("downtemplate.periodtype.not.null");
        }
        String dynaRptType = downTemplateObject.getDynaRptType();
        if (StringUtil.isEmpty((String)dynaRptType)) {
            return ResourceUtil.getResString("downtemplate.dynarpttype.not.null");
        }
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem1 = new FilterItemInfo("number", (Object)number);
        filter.getFilterItems().add(filterItem1);
        FilterItemInfo filterItem2 = new FilterItemInfo("templateType", (Object)Integer.parseInt(templateType));
        filter.getFilterItems().add(filterItem2);
        boolean isExist = TemplateFactory.getRemoteInstance().exists(filter);
        if (isExist) {
            return ResourceUtil.getResString("downtemplate.has.exsit");
        }
        return resultStr;
    }

    private static TemplateInfo getTemplateInfoByDownTemplate(DownTemplateObject downTemplateObject) {
        TemplateInfo templateInfo = new TemplateInfo();
        CompanyOrgUnitInfo companyInfo = SysContext.getSysContext().getCurrentFIUnit();
        templateInfo.setCompany(companyInfo);
        if (downTemplateObject != null) {
            templateInfo.setName(downTemplateObject.getName());
            templateInfo.setNumber(downTemplateObject.getNumber());
            if (StringUtil.isInt((String)downTemplateObject.getPeriodType())) {
                int periodType = Integer.parseInt(downTemplateObject.getPeriodType());
                templateInfo.setPeriodType(RptPeriodTypeEnum.getEnum((int)periodType));
                Calendar calendar = Calendar.getInstance();
                List times = RPTDateUtil.getRptPeriod((Date)calendar.getTime(), (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)periodType));
                Integer year = (Integer)times.get(0);
                Integer period = (Integer)times.get(1);
                Date startDate = RPTDateUtil.getPeriodLastDate((int)year, (int)period, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)periodType));
                templateInfo.setStartDate(startDate);
            }
            if (StringUtil.isInt((String)downTemplateObject.getTemplateType())) {
                int templateType = Integer.parseInt(downTemplateObject.getTemplateType());
                templateInfo.setTemplateType(RptTmpTypeEnum.getEnum((int)templateType));
            }
            if (StringUtil.isInt((String)downTemplateObject.getDynaRptType())) {
                int dynaRptType = Integer.parseInt(downTemplateObject.getDynaRptType());
                templateInfo.setDynaRptType(DynaEnumRptTypeEnum.getEnum((int)dynaRptType));
            }
        }
        return templateInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Book generateBook(String resId, String version, String fileName) {
        String fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
        if (!ResourceUtil.checkFileSuffix(fileType)) {
            return null;
        }
        Book book = null;
        InputStream is = null;
        FileOutputStream fos1 = null;
        FilterOutputStream bos = null;
        try {
            File file;
            is = ResourceUtil.getStream(resId, fileName, version);
            byte[] b = CtrlUtil.Stream.readInputStream((InputStream)is);
            String tempFilePath = "C:" + File.separator + "temp.xml";
            if (!ResourceUtil.canCreateTempFile(tempFilePath)) {
                tempFilePath = "D:" + File.separator + "temp.xml";
            }
            if (!(file = new File(tempFilePath)).exists()) {
                file.createNewFile();
            }
            fos1 = new FileOutputStream(file, false);
            bos = new BufferedOutputStream(fos1);
            bos.write(b);
            fos1.close();
            bos.close();
            book = IOHelper.loadFile((String)tempFilePath);
            file.delete();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"is.close()", (Throwable)e);
            }
            try {
                if (fos1 != null) {
                    fos1.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"fos1.close()", (Throwable)e);
            }
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"bos.close()", (Throwable)e);
            }
        }
        return book;
    }

    public static boolean canCreateTempFile(String tempFilePath) {
        File file = null;
        try {
            file = new File(tempFilePath);
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            return false;
        }
        return true;
    }

    public static boolean checkFileSuffix(String fileType) {
        return suffixSet.contains(fileType);
    }

    public static String getResString(String resName) {
        return EASResource.getString((String)ONLINE_RESOURCE, (String)resName);
    }

    public static IntEnum getEnumByAliase(Class enumClass, String aliase) {
        IntEnum rtnEnum = null;
        if (StringUtil.isEmpty((String)aliase)) {
            return null;
        }
        List enumList = EnumUtils.getEnumList((Class)enumClass);
        for (int i = 0; i < enumList.size(); ++i) {
            if (!aliase.equals(((IntEnum)enumList.get(i)).getAlias())) continue;
            return (IntEnum)enumList.get(i);
        }
        return rtnEnum;
    }

    static {
        suffixSet = new HashSet<String>();
        suffixSet.add("xml");
    }
}

