/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.report;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.core.ICellDisplayProvider;
import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.InsertType;
import com.kingdee.bos.ctrl.excel.model.struct.PasteMode;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.fi.newrpt.report.AnalysisBasePointParams;
import com.kingdee.eas.fi.newrpt.report.ItemAnalysisCellObject;
import com.kingdee.eas.fi.newrpt.report.ItemAnalysisConstant;
import com.kingdee.eas.fi.newrpt.report.ItemAnalysisHepler;
import com.kingdee.eas.fi.newrpt.util.RptLoggerUtils;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DmAnalysisHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.report.DmAnalysisHelper");
    private static DmAnalysisHelper helper = null;
    private List<List<ItemAnalysisCellObject>> rowDatas = null;
    private List<List<ItemAnalysisCellObject>> colDatas = null;
    private Sheet sheet;
    private Point basePoint;
    private AnalysisBasePointParams basePointParams = null;
    private int headRowStart = 0;
    private int headColStart = 0;
    private int headRowEnd = 0;
    private int headColEnd = 0;
    private int rowEnd = 0;
    private int colEnd = 0;
    private int copyStartRow = 0;
    private int copyStartCol = 0;
    private int copyEndRow = 0;
    private int copyEndCol = 0;
    private boolean isItemAnalysis = false;
    private Map<String, Integer> parentKeys = new HashMap<String, Integer>();
    private List<Integer> hiddens = new ArrayList<Integer>();
    private List<Integer> rowOrColHiddens = new ArrayList<Integer>();
    private StyleAttributes sa = Styles.getEmptySA();

    public DmAnalysisHelper() {
        this.sa.setFontColor(Color.BLUE);
    }

    public static DmAnalysisHelper getInstance() {
        if (helper == null) {
            helper = new DmAnalysisHelper();
        }
        return helper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void fillHead(List<List<ItemAnalysisCellObject>> rowDatas, List<List<ItemAnalysisCellObject>> colDatas, Sheet sheet, Point basePoint) throws Exception {
        if (rowDatas == null || rowDatas.isEmpty() || colDatas == null || colDatas.isEmpty() || sheet == null) {
            return;
        }
        RptLoggerUtils.getInstance().printList(logger, rowDatas, "rowDatas:");
        RptLoggerUtils.getInstance().printList(logger, colDatas, "colDatas:");
        this.initParams(rowDatas, colDatas, sheet, basePoint);
        this.initBasePoint();
        this.handleBasePointRange(sheet, this.basePoint, this.basePointParams);
        Range range = sheet.getRange(basePoint.y, basePoint.x);
        ItemAnalysisHepler.getInstance().saveBasePointParametersToCell(range, this.basePointParams);
        try {
            this.fillHead();
        }
        finally {
            this.hiddens.clear();
            this.parentKeys.clear();
            this.rowOrColHiddens.clear();
        }
        ItemAnalysisHepler.getInstance().setBorder(sheet.getRange(this.headRowStart, this.headColStart, this.rowEnd, this.colEnd));
        ItemAnalysisHepler.getInstance().setHorizontalAlign(sheet.getRange(this.headRowEnd + 1, this.headColEnd + 1, this.rowEnd, this.colEnd), Styles.HorizontalAlignment.RIGHT);
        ItemAnalysisHepler.getInstance().setNumberFormat(sheet.getRange(this.headRowEnd + 1, this.headColEnd + 1, this.rowEnd, this.colEnd), "#,##0.00");
        sheet.getRange(this.headRowStart, this.headColStart, this.headRowEnd, this.headColEnd).merge();
    }

    public void autoSetColWidth(SpreadManager spreadManager, Sheet sheet, Point basePoint) throws Exception {
        if (sheet == null || basePoint == null || spreadManager == null) {
            return;
        }
        if (!this.initBasePoint(sheet, basePoint)) {
            return;
        }
        this.initBasePointRangeIndex();
        KDSpread spread = spreadManager.getSpreadContainer().getSpread();
        Graphics2D g2d = (Graphics2D)spread.getGraphics();
        for (int colIndex = this.headColStart; colIndex <= this.colEnd; ++colIndex) {
            Sheet.ICellsIterator iter = sheet.getCellsIterator(0, colIndex, 1048575, colIndex, false, true);
            int width = 0;
            while (iter.hasNext()) {
                int w = 0;
                Cell cell = iter.next();
                FontMetrics fm = g2d.getFontMetrics((Font)cell.getStyle().getKDFont());
                ICellDisplayProvider cvp = spread.getCellDisplayProvider();
                Object value = cvp.getBaseValue(cell, spread.getBook().getActiveSheet().getSheetOption().getCellDisplayMode());
                if (value instanceof String) {
                    w = fm.stringWidth((String)value);
                    int rotate = cell.getStyle().getRotation();
                    if (rotate != 0) {
                        double angel = Math.PI * (double)rotate / 180.0;
                        w = Math.abs(rotate) == 90 ? fm.getHeight() : (int)((double)w * Math.cos(angel));
                    }
                }
                width = w > width ? w : width;
            }
            if (width <= 0) continue;
            sheet.getColRange(colIndex, colIndex).setColumnWidth(width + 8);
        }
    }

    public boolean initBasePoint(Sheet sheet, Point basePoint) {
        this.sheet = sheet;
        this.basePoint = basePoint;
        this.basePointParams = ItemAnalysisHepler.getInstance().getParametersFromCell(sheet.getCell(basePoint.y, basePoint.x, true));
        return this.basePointParams != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void fillData(Sheet sheet, Point basePoint, Map<String, Object> datas) throws Exception {
        if (sheet == null || basePoint == null || datas == null || datas.isEmpty()) {
            return;
        }
        try {
            if (!this.initBasePoint(sheet, basePoint)) {
                return;
            }
            this.initBasePointRangeIndex();
            this.fillData(datas);
        }
        finally {
            this.isItemAnalysis = false;
        }
    }

    private void fillData(Map<String, Object> datas) throws Exception {
        Cell cell = null;
        ItemAnalysisCellObject cellObject = null;
        StringBuffer key = new StringBuffer();
        String sourceType = null;
        Object value = null;
        for (int i = this.colEnd; i > this.headColEnd; --i) {
            for (int j = this.rowEnd; j > this.headRowEnd; --j) {
                sourceType = ItemAnalysisConstant.cslType;
                key.setLength(0);
                key.append(ItemAnalysisConstant.splitStr);
                cell = this.sheet.getCell(j, i, true);
                for (int m = this.headColStart; m <= this.headColEnd; ++m) {
                    cellObject = this.getCellObject(null, j, m);
                    if (cellObject == null) continue;
                    key.append(cellObject.getKey()).append(ItemAnalysisConstant.splitStr);
                    if (!this.isItemAnalysis || !cellObject.isUnion()) continue;
                    sourceType = String.valueOf(cellObject.getSourceType());
                }
                for (int n = this.headRowStart; n <= this.headRowEnd; ++n) {
                    cellObject = this.getCellObject(null, n, i);
                    if (cellObject == null) continue;
                    key.append(cellObject.getKey()).append(ItemAnalysisConstant.splitStr);
                    if (!this.isItemAnalysis || !cellObject.isUnion()) continue;
                    sourceType = String.valueOf(cellObject.getSourceType());
                }
                if (this.isItemAnalysis && !this.basePointParams.isMidTableAnalysis()) {
                    key.append(sourceType).append(ItemAnalysisConstant.splitStr);
                }
                if ((value = datas.get(key.toString())) == null) continue;
                if (cell.getValue() != null && value instanceof BigDecimal) {
                    try {
                        value = ((BigDecimal)value).add(cell.getValue().toBigDecimal());
                    }
                    catch (Exception e) {
                        logger.error((Object)(cell.toString() + " change error."), (Throwable)e);
                    }
                }
                cell.setValue(new Variant(value));
            }
        }
    }

    public void initItemAnalysisParams(boolean isItemAnalysis) {
        this.isItemAnalysis = isItemAnalysis;
    }

    public ItemAnalysisCellObject getCellObject(Sheet sheet, int row, int col) throws Exception {
        ItemAnalysisCellObject cellObj = null;
        Sheet curSheet = sheet;
        if (curSheet == null) {
            curSheet = this.sheet;
        }
        CellBlock cellBlock = curSheet.getMergeBlock(row, col);
        String objectStr = null;
        objectStr = cellBlock == null ? (String)curSheet.getCell(row, col, true).getUserObjectValue(ItemAnalysisConstant.cellObjKey) : (String)curSheet.getCell(cellBlock.getRow(), cellBlock.getCol(), true).getUserObjectValue(ItemAnalysisConstant.cellObjKey);
        if (objectStr == null) {
            return null;
        }
        try {
            cellObj = new ItemAnalysisCellObject();
            cellObj.fromSerialString(objectStr);
        }
        catch (Exception e) {
            logger.error((Object)"getCellObject error", (Throwable)e);
            return null;
        }
        return cellObj;
    }

    private void initParams(List<List<ItemAnalysisCellObject>> rowDatas, List<List<ItemAnalysisCellObject>> colDatas, Sheet sheet, Point basePoint) {
        this.sheet = sheet;
        this.basePoint = basePoint;
        this.rowDatas = rowDatas;
        this.colDatas = colDatas;
    }

    private void fillHead() throws Exception {
        this.fillHead(this.rowDatas, true);
        ItemAnalysisHepler.getInstance().setShowOrHide(this.sheet, this.rowOrColHiddens, 0, true, true);
        this.fillHead(this.colDatas, false);
        ItemAnalysisHepler.getInstance().setShowOrHide(this.sheet, this.rowOrColHiddens, 0, true, false);
    }

    private void fillHead(List<List<ItemAnalysisCellObject>> dataList, boolean isRow) throws Exception {
        this.copyStartRow = isRow ? this.headRowEnd + 1 : this.headRowEnd;
        this.copyStartCol = isRow ? this.headColEnd : this.headColEnd + 1;
        this.copyEndRow = this.copyStartRow;
        this.copyEndCol = this.copyStartCol;
        for (int i = dataList.size() - 1; i >= 0; --i) {
            this.fillHeadRowOrCol(dataList, i, isRow);
        }
    }

    private void fillHeadRowOrCol(List<List<ItemAnalysisCellObject>> dataList, int index, boolean isRow) throws Exception {
        List<ItemAnalysisCellObject> values = dataList.get(index);
        if (index == dataList.size() - 1) {
            this.fillHeadLastRowOrCol(values, isRow);
        } else {
            this.fillHeadOtherRowOrCol(values, isRow);
        }
    }

    private void fillHeadLastRowOrCol(List<ItemAnalysisCellObject> itemValues, boolean isRow) throws Exception {
        int offSet = 0;
        if (itemValues != null && itemValues.size() > 0) {
            for (ItemAnalysisCellObject cellObj : itemValues) {
                int rowIndex = isRow ? this.copyStartRow + offSet : this.copyStartRow;
                int colIndex = isRow ? this.copyStartCol : this.copyStartCol + offSet;
                this.setCellValue(cellObj, rowIndex, colIndex, isRow);
                ++offSet;
            }
        }
        this.copyEndRow = isRow ? this.copyStartRow + offSet : this.copyStartRow;
        this.copyEndCol = isRow ? this.copyStartCol : this.copyStartCol + offSet;
    }

    private void fillHeadOtherRowOrCol(List<ItemAnalysisCellObject> itemValues, boolean isRow) throws Exception {
        int offSet = 0;
        int step = isRow ? this.copyEndRow - this.copyStartRow : this.copyEndCol - this.copyStartCol;
        this.sheet.getRange(this.copyStartRow, this.copyStartCol, this.copyEndRow, this.copyEndCol).copy();
        boolean isHidden = false;
        int index = 0;
        for (int i = isRow ? this.copyStartRow : this.copyStartCol; i <= (isRow ? this.copyEndRow : this.copyEndCol); ++i) {
            isHidden = isRow ? this.sheet.getRowRange(i, i).getHidden() : this.sheet.getColRange(i, i).getHidden();
            if (isHidden) {
                this.hiddens.add(index);
            }
            ++index;
        }
        if (itemValues != null && itemValues.size() > 0) {
            for (ItemAnalysisCellObject cellObj : itemValues) {
                offSet = this.fillRowOrCol(cellObj, offSet, step, isRow);
            }
        }
        this.copyStartRow = isRow ? this.copyStartRow : this.copyStartRow - 1;
        this.copyStartCol = isRow ? this.copyStartCol - 1 : this.copyStartCol;
        this.copyEndRow = isRow ? this.copyStartRow + offSet : this.copyEndRow;
        this.copyEndCol = isRow ? this.copyEndCol : this.copyStartCol + offSet;
    }

    private int fillRowOrCol(ItemAnalysisCellObject cellObj, int offSet, int step, boolean isRow) throws Exception {
        Range range = null;
        if (offSet > 0) {
            int startRow = isRow ? this.copyStartRow + offSet : this.copyStartRow;
            int startCol = isRow ? this.copyStartCol : this.copyStartCol + offSet;
            int endRow = isRow ? this.copyStartRow + offSet + step - 1 : this.copyStartRow;
            int endCol = isRow ? this.copyStartCol : this.copyStartCol + offSet + step - 1;
            this.sheet.getRange(startRow, startCol, endRow, endCol).paste(PasteMode.ALL, new String[]{ItemAnalysisConstant.cellObjKey});
            ItemAnalysisHepler.getInstance().setShowOrHide(this.sheet, this.hiddens, isRow ? startRow : startCol, true, isRow);
        }
        for (int k = 0; k < step; ++k) {
            int rowIndex = isRow ? this.copyStartRow + offSet : this.copyStartRow - 1;
            int colIndex = isRow ? this.copyStartCol - 1 : this.copyStartCol + offSet;
            this.setCellValue(cellObj, rowIndex, colIndex, isRow);
            ++offSet;
        }
        if (step > 1) {
            range = this.sheet.getRange(isRow ? this.copyStartRow + offSet - step : this.copyStartRow - 1, isRow ? this.copyStartCol - 1 : this.copyStartCol + offSet - step, isRow ? this.copyStartRow + offSet - 1 : this.copyStartRow - 1, isRow ? this.copyStartCol - 1 : this.copyStartCol + offSet - 1);
            range.merge();
        }
        return offSet;
    }

    private void setCellValue(ItemAnalysisCellObject cellObj, int rowIndex, int colIndex, boolean isRow) throws Exception {
        Cell cell = this.sheet.getCell(rowIndex, colIndex, true);
        String parentKey = cellObj.getParentKey();
        if (!StringUtils.isEmpty((String)parentKey)) {
            Integer curLevel = this.parentKeys.get(parentKey);
            curLevel = curLevel == null ? -1 : curLevel;
            if (cellObj.isUnion()) {
                this.parentKeys.put(cellObj.getKey(), curLevel < 0 ? 0 : 1);
                if (curLevel < 0) {
                    cellObj.setOpen(true);
                }
                cell.setSSA((ShareStyleAttributes)this.sa);
            }
            if (curLevel > 0) {
                this.rowOrColHiddens.add(isRow ? rowIndex : colIndex);
            }
        } else if (cellObj.isUnion()) {
            this.parentKeys.put(cellObj.getKey(), 0);
            cellObj.setOpen(true);
            cell.setSSA((ShareStyleAttributes)this.sa);
        }
        cell.setUserObject(ItemAnalysisConstant.cellObjKey, (Object)cellObj.toSerialString());
        cell.setValue(new Variant((Object)cellObj.getDisplayName()));
    }

    private void initBasePoint() {
        AnalysisBasePointParams basePointParams;
        if (this.basePoint == null) {
            this.basePoint = new Point(this.sheet.getActiveCell().getCol(), this.sheet.getActiveCell().getRow());
        }
        if ((basePointParams = ItemAnalysisHepler.getInstance().getParametersFromCell(this.sheet.getCell(this.basePoint.y, this.basePoint.x, true))) == null) {
            basePointParams = new AnalysisBasePointParams();
        }
        basePointParams.setHeadRowEndOffSet(this.colDatas.size());
        basePointParams.setHeadColEndOffSet(this.rowDatas.size());
        basePointParams.setRow_endOffSet(basePointParams.getHeadRowEndOffSet() + this.getCount(this.rowDatas));
        basePointParams.setCol_endOffSet(basePointParams.getHeadColEndOffSet() + this.getCount(this.colDatas));
        this.basePointParams = basePointParams;
        this.initBasePointRangeIndex();
    }

    private void initBasePointRangeIndex() {
        if (this.basePoint != null && this.basePointParams != null) {
            this.headRowStart = this.basePoint.y;
            this.headColStart = this.basePoint.x;
            this.headRowEnd = this.headRowStart + this.basePointParams.getHeadRowEndOffSet() - 1;
            this.headColEnd = this.headColStart + this.basePointParams.getHeadColEndOffSet() - 1;
            this.rowEnd = this.headRowStart + this.basePointParams.getRow_endOffSet() - 1;
            this.colEnd = this.headColStart + this.basePointParams.getCol_endOffSet() - 1;
        }
    }

    private void handleBasePointRange(Sheet sheet, Point newBasePoint, AnalysisBasePointParams newBasePointParams) {
        ArrayList basePoints = ItemAnalysisHepler.getInstance().getBasePointList(sheet);
        Cell curCell = null;
        Point point = null;
        int rows = 0;
        AnalysisBasePointParams oldParams = null;
        int oldHeadRowStart = 0;
        int oldHeadColStart = 0;
        int oldRowEnd = 0;
        int oldColEnd = 0;
        int newRowEnd = newBasePoint.y + newBasePointParams.getRow_endOffSet() - 1;
        for (int i = 0; i < basePoints.size(); ++i) {
            point = (Point)basePoints.get(i);
            curCell = sheet.getCell(point.y, point.x, true);
            oldParams = ItemAnalysisHepler.getInstance().getParametersFromCell(curCell);
            oldHeadRowStart = point.y;
            oldHeadColStart = point.x;
            oldRowEnd = point.y + oldParams.getRow_endOffSet() - 1;
            oldColEnd = point.x + oldParams.getCol_endOffSet() - 1;
            if (oldHeadRowStart <= newBasePoint.y && newBasePoint.y <= oldRowEnd) {
                UserObjectHelper.getUnprotectedRange((Range)sheet.getRange(oldHeadRowStart, oldHeadColStart, oldRowEnd, oldColEnd)).clear(true, true, true, true, new String[]{"ITEM"});
                UserObjectHelper.getUnprotectedRange((Range)sheet.getRowRange(oldHeadRowStart, oldRowEnd)).setHidden(false, true);
                UserObjectHelper.getUnprotectedRange((Range)sheet.getColRange(oldHeadColStart, oldColEnd)).setHidden(false, false);
                rows = newRowEnd - oldRowEnd;
                if (rows > 0) {
                    UserObjectHelper.getUnprotectedRange((Range)sheet.getRowRange(oldRowEnd + 1, newRowEnd)).insert(true, InsertType.NOSTYLE);
                    break;
                }
                if (rows >= 0) break;
                UserObjectHelper.getUnprotectedRange((Range)sheet.getRowRange(newRowEnd + 1, oldRowEnd)).delete();
                break;
            }
            if (oldHeadRowStart <= newBasePoint.y) continue;
            rows = newRowEnd - oldHeadRowStart;
            if (rows <= 0) break;
            UserObjectHelper.getUnprotectedRange((Range)sheet.getRowRange(oldHeadRowStart, newRowEnd + 1)).insert(true, InsertType.NOSTYLE);
            break;
        }
    }

    private int getCount(List<List<ItemAnalysisCellObject>> colOrRowList) {
        int result = 1;
        for (List<ItemAnalysisCellObject> dataList : colOrRowList) {
            if (dataList == null) continue;
            result *= dataList.size();
        }
        return result;
    }

    public boolean InitBatchFill(Sheet sheet, Point basePoint) throws Exception {
        if (sheet == null || basePoint == null) {
            return false;
        }
        if (!this.initBasePoint(sheet, basePoint)) {
            return false;
        }
        this.initBasePointRangeIndex();
        UserObjectHelper.getUnprotectedRange((Range)sheet.getRange(this.headRowEnd + 1, this.headColEnd + 1, this.rowEnd, this.colEnd)).clear(true, true, false, false);
        return true;
    }

    public void batchFillDatas(Map<String, Object> datas) throws Exception {
        this.fillData(datas);
    }

    public int getBatchCount() {
        int cellCount = (this.rowEnd - this.headRowEnd) * (this.colEnd - this.headColEnd);
        int batchCellCount = 2000;
        return cellCount / batchCellCount + 1;
    }
}

