/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.report;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportGroupEnum;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.util.client.EASResource;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

public class VariablesHelper {
    public static final String INCLUDE_POSTED = "IncludePosted";
    public static final String INCLUDE_SUB = "IncludeSub";
    public static final String INCLUDE_SUB_ACCOUNT = "IncludeSubAccount";
    public static final String INCLUDE_LEAF = "IncludeLeaf";
    public static final String INCLUDE_LEAF_ACCOUNT = "IncludeLeafAccount";
    public static final String CURRENCY = "Currency";
    public static final String END_PERIOD = "EndPeriod";
    public static final String START_PERIOD = "StartPeriod";
    public static final String END_DATE = "EndDate";
    public static final String START_DATE = "StartDate";
    public static final String END_YEAR = "EndYear";
    public static final String START_YEAR = "StartYear";
    public static final String SHEET_TYPE = "SheetClass";
    public static final String AUTOCALCULATESTATE = "autoCalculateState";
    public static final String INCLUDE_DETAILACCOUNT_ASSTITEM = "IncludeAllAssistItems";

    public static ReportVariables initSheetReservedVariables(String sheetName, RptPeriodTypeEnum periodType) {
        ReportVariables variables = new ReportVariables();
        variables.add(VariablesHelper.createReservedEntry(INCLUDE_POSTED, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"39_VariablesHelper"), sheetName, "N", 1));
        variables.addWithoutDup(VariablesHelper.createReservedEntry(INCLUDE_LEAF, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"41_VariablesHelper"), sheetName, "N", 1));
        variables.addWithoutDup(VariablesHelper.createReservedEntry(INCLUDE_LEAF_ACCOUNT, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"40_VariablesHelper"), sheetName, "N", 1));
        variables.addWithoutDup(VariablesHelper.createReservedEntry(INCLUDE_SUB, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"43_VariablesHelper"), sheetName, "N", 1));
        variables.addWithoutDup(VariablesHelper.createReservedEntry(INCLUDE_SUB_ACCOUNT, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"42_VariablesHelper"), sheetName, "N", 1));
        VariableEntry sheetType = VariablesHelper.createReservedEntry(SHEET_TYPE, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"44_VariablesHelper"), sheetName, String.valueOf(1));
        variables.add(VariablesHelper.createReservedEntry(INCLUDE_DETAILACCOUNT_ASSTITEM, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"45_VariablesHelper"), sheetName, "N", 1));
        sheetType.setVisible(false);
        variables.add(sheetType);
        VariableEntry v = VariablesHelper.createReservedEntry(CURRENCY, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"46_VariablesHelper"), sheetName, "");
        v.setQuery("com.kingdee.eas.basedata.assistant.app.CurrencyAllQuery");
        variables.add(v);
        variables.add(VariablesHelper.createReservedEntry(START_YEAR, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"47_VariablesHelper"), sheetName, "0", 3));
        variables.add(VariablesHelper.createReservedEntry(END_YEAR, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"48_VariablesHelper"), sheetName, "0", 3));
        int t = periodType.getValue();
        switch (t) {
            case 1: {
                variables.add(VariablesHelper.createReservedEntry(START_DATE, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"49_VariablesHelper"), sheetName, "", 2));
                variables.add(VariablesHelper.createReservedEntry(END_DATE, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"50_VariablesHelper"), sheetName, "", 2));
                break;
            }
            case 6: {
                break;
            }
            default: {
                variables.add(VariablesHelper.createReservedEntry(START_PERIOD, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"51_VariablesHelper"), sheetName, "0", 3));
                variables.add(VariablesHelper.createReservedEntry(END_PERIOD, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"52_VariablesHelper"), sheetName, "0", 3));
            }
        }
        variables.add(VariablesHelper.createReservedEntry("isCalcByPriorityAccount", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"82_AcctCalcByPriorityAccount"), sheetName, "0", 1));
        variables.add(VariablesHelper.createReservedEntry("isCalSaperateByAccountLevel", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"169_IsCalSaperateByAccountLevel"), sheetName, "0", 1));
        return variables;
    }

    public static VariableEntry createReservedEntry(String name, String desc, String sheetName, String value, int type) {
        VariableEntry entry = VariablesHelper.createReservedEntry(name, desc, sheetName, value);
        entry.setType(type);
        return entry;
    }

    public static VariableEntry createReservedEntry(String name, String desc, String sheetName, String value) {
        VariableEntry entry = new VariableEntry();
        entry.setEditable(true);
        entry.setReserved(true);
        entry.setName(name);
        entry.setScope(2);
        entry.setSheetName(sheetName);
        entry.setValue(value);
        entry.setDescription(desc);
        return entry;
    }

    public static ReportVariables initTemplateSheetReservedVariables(String sheetName, RptPeriodTypeEnum periodType) {
        ReportVariables variables = new ReportVariables();
        variables.addWithoutDup(VariablesHelper.createReservedEntry(INCLUDE_POSTED, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"39_VariablesHelper"), sheetName, "N", 1));
        variables.addWithoutDup(VariablesHelper.createReservedEntry(INCLUDE_LEAF, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"41_VariablesHelper"), sheetName, "N", 1));
        variables.addWithoutDup(VariablesHelper.createReservedEntry(INCLUDE_LEAF_ACCOUNT, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"40_VariablesHelper"), sheetName, "N", 1));
        variables.addWithoutDup(VariablesHelper.createReservedEntry(INCLUDE_SUB, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"43_VariablesHelper"), sheetName, "N", 1));
        variables.addWithoutDup(VariablesHelper.createReservedEntry(INCLUDE_SUB_ACCOUNT, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"42_VariablesHelper"), sheetName, "N", 1));
        variables.addWithoutDup(VariablesHelper.createReservedEntry(INCLUDE_DETAILACCOUNT_ASSTITEM, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"45_VariablesHelper"), sheetName, "N", 1));
        VariableEntry sheetType = VariablesHelper.createReservedEntry(SHEET_TYPE, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"44_VariablesHelper"), sheetName, String.valueOf(1));
        VariableEntry v = VariablesHelper.createReservedEntry(CURRENCY, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"46_VariablesHelper"), sheetName, "");
        v.setQuery("com.kingdee.eas.basedata.assistant.app.CurrencyAllQuery");
        variables.add(v);
        sheetType.setVisible(false);
        variables.add(sheetType);
        variables.add(VariablesHelper.createReservedEntry(START_YEAR, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"47_VariablesHelper"), sheetName, "0", 3));
        variables.add(VariablesHelper.createReservedEntry(END_YEAR, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"48_VariablesHelper"), sheetName, "0", 3));
        int t = periodType.getValue();
        switch (t) {
            case 1: {
                variables.add(VariablesHelper.createReservedEntry(START_DATE, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"49_VariablesHelper"), sheetName, "", 2));
                variables.add(VariablesHelper.createReservedEntry(END_DATE, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"50_VariablesHelper"), sheetName, "", 2));
                break;
            }
            case 6: {
                break;
            }
            default: {
                variables.add(VariablesHelper.createReservedEntry(START_PERIOD, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"51_VariablesHelper"), sheetName, "0", 3));
                variables.add(VariablesHelper.createReservedEntry(END_PERIOD, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"52_VariablesHelper"), sheetName, "0", 3));
            }
        }
        variables.add(VariablesHelper.createReservedEntry("isCalcByPriorityAccount", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"82_AcctCalcByPriorityAccount"), sheetName, "0", 1));
        return variables;
    }

    public static ReportVariables sheetParams2Variables(RptSheetParamInfo p, RptPeriodTypeEnum periodType) {
        boolean isTemplate = false;
        if (p.getReport() instanceof TemplateInfo) {
            isTemplate = true;
        }
        String sheetName = p.getSheetName();
        ReportVariables variables = null;
        variables = isTemplate ? VariablesHelper.initTemplateSheetReservedVariables(sheetName, periodType) : VariablesHelper.initSheetReservedVariables(sheetName, periodType);
        NewRptUtil.initDynaAndInterExFillVariables(p, null, null, variables);
        VariableEntry variableEntry = null;
        variableEntry = variables.get(START_YEAR, sheetName);
        variableEntry.setValue(String.valueOf(p.getStartYear()));
        variableEntry.setType(3);
        variableEntry = variables.get(END_YEAR, sheetName);
        variableEntry.setValue(String.valueOf(p.getEndYear()));
        variableEntry.setType(3);
        int t = periodType.getValue();
        switch (t) {
            case 1: {
                SimpleDateFormat s = new SimpleDateFormat();
                s.applyPattern("yyyy-MM-dd");
                if (p.getStartDate() != null) {
                    variables.get(START_DATE, sheetName).setValue(s.format(p.getStartDate()));
                }
                if (p.getEndDate() == null) break;
                variables.get(END_DATE, sheetName).setValue(s.format(p.getEndDate()));
                break;
            }
            case 6: {
                break;
            }
            default: {
                variableEntry = variables.get(START_PERIOD, sheetName);
                variableEntry.setValue(String.valueOf(p.getStartPeriod()));
                variableEntry.setType(3);
                variableEntry = variables.get(END_PERIOD, sheetName);
                variableEntry.setValue(String.valueOf(p.getEndPeriod()));
                variableEntry.setType(3);
            }
        }
        variableEntry = variables.get(CURRENCY, sheetName);
        variableEntry.setValue(p.getCurrency() == null ? "" : String.valueOf(p.getCurrency().getNumber()));
        variableEntry.setQuery("com.kingdee.eas.basedata.assistant.app.CurrencyAllQuery");
        variableEntry = variables.get(INCLUDE_POSTED, sheetName);
        variableEntry.setValue(String.valueOf(p.isIsIncludingUnposted()));
        variableEntry.setType(1);
        CSLReportGroupEnum reportClass = p.getReportClass();
        if (reportClass == null) {
            reportClass = CSLReportGroupEnum.COMMON;
        }
        variables.get(SHEET_TYPE, sheetName).setValue(String.valueOf(reportClass.getValue()));
        return variables;
    }

    public static ReportVariables sheetParams2Variables(ReportInfo rpt) {
        RptSheetParamCollection param = rpt.getSheetParam();
        ReportVariables result = new ReportVariables();
        for (int i = 0; param != null && i < param.size(); ++i) {
            ReportVariables variables = VariablesHelper.sheetParams2Variables(param.get(i), rpt.getPeriodType());
            result.addAll(variables, false);
        }
        return result;
    }

    public static RptSheetParamInfo variables2SheetParams(ReportVariables vs, String sheetName) {
        return VariablesHelper.variables2SheetParams(vs, sheetName, false, null);
    }

    public static RptSheetParamInfo variables2SheetParams(ReportVariables vs, String sheetName, boolean neecCurrency, Context ctx) {
        DateFormat df2;
        RptSheetParamInfo p = new RptSheetParamInfo();
        p.setSheetName(sheetName);
        p.setStartYear(vs.getIntValue(START_YEAR, sheetName, 0));
        p.setEndYear(vs.getIntValue(END_YEAR, sheetName, 0));
        p.setStartPeriod(vs.getIntValue(START_PERIOD, sheetName, 0));
        p.setEndPeriod(vs.getIntValue(END_PERIOD, sheetName, 0));
        if (vs.getStringValue(START_DATE, sheetName) != null) {
            try {
                df2 = DateFormat.getDateInstance();
                p.setStartDate(df2.parse(vs.getStringValue(START_DATE, sheetName)));
            }
            catch (Exception df2) {
                // empty catch block
            }
        }
        if (vs.getStringValue(END_DATE, sheetName) != null) {
            try {
                df2 = DateFormat.getDateInstance();
                p.setEndDate(df2.parse(vs.getStringValue(END_DATE, sheetName)));
            }
            catch (Exception df3) {
                // empty catch block
            }
        }
        p.setIsIncludingUnposted(vs.getBoolValue(INCLUDE_POSTED, sheetName, false));
        if (neecCurrency) {
            try {
                ICurrency ic = null;
                ic = ctx == null ? CurrencyFactory.getRemoteInstance() : CurrencyFactory.getLocalInstance((Context)ctx);
                CurrencyCollection curr = ic.getCurrencyCollection("select id, name, number where number='" + vs.getStringValue(CURRENCY, sheetName) + "'");
                if (curr.size() > 0) {
                    p.setCurrency(curr.get(0));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        p.setReportClass(CSLReportGroupEnum.getEnum((int)vs.getIntValue(SHEET_TYPE, sheetName, 1)));
        return p;
    }

    public static ReportVariables sheetParams2Variables(TemplateInfo template) {
        RptSheetParamCollection param = template.getSheetParam();
        ReportVariables result = new ReportVariables();
        for (int i = 0; param != null && i < param.size(); ++i) {
            ReportVariables variables = VariablesHelper.sheetParams2Variables(param.get(i), template.getPeriodType());
            result.addAll(variables, false);
        }
        return result;
    }
}

