/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.report;

public class YearPeriodCalendar {
    private int year;
    private int period;
    private int loopStep = 12;
    private int periodType = 0;

    public YearPeriodCalendar(int year, int period, int loopStep) {
        this.year = year;
        this.period = period;
        this.loopStep = loopStep;
    }

    public int compare(YearPeriodCalendar newCalendar) {
        if (newCalendar != null) {
            return this.getKey().compareTo(newCalendar.getKey());
        }
        return -1;
    }

    public void offSet(int yearOffSet, int periodOffSet) {
        int curPeriod = this.period + periodOffSet;
        int curYear = this.year + yearOffSet;
        if (curPeriod > this.loopStep) {
            int curYearOffSet = (curPeriod - 1) / this.loopStep;
            this.year = curYear + curYearOffSet;
            this.period = (curPeriod %= this.loopStep) == 0 ? this.loopStep : curPeriod;
        } else if (curPeriod > 0) {
            this.year = curYear;
            this.period = curPeriod;
        }
    }

    public String getKey() {
        if (this.period < 10) {
            return this.year + "0" + this.period;
        }
        return this.year + "" + this.period;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public int getLoopStep() {
        return this.loopStep;
    }

    public void setLoopStep(int loopStep) {
        this.loopStep = loopStep;
    }
}

