/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.rptInExcel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CheckFormulaFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormulaCheckResultFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.ServerException;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelFieldEnum;
import com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelMustInputInfo;
import com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelSchmCollection;
import com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelSchmEntryCollection;
import com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelSchmEntryInfo;
import com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelSchmInfo;
import com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelStatusEnum;
import com.kingdee.eas.fi.newrpt.rptInExcel.RptInExFieldSaveTypeEnum;
import com.kingdee.eas.fi.newrpt.rptInExcel.app.AbstractReportInExcelSchmControllerBean;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptAndTempException;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ReportInExcelSchmControllerBean
extends AbstractReportInExcelSchmControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.rptInExcel.app.ReportInExcelSchmControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._addnew(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkExists(ctx, model);
        return super._submit(ctx, model);
    }

    protected Result _update(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        return super._update(ctx, colls);
    }

    private void checkExists(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ReportInExcelSchmInfo reSchmInfo;
        ReportInExcelSchmInfo rExcelSchmInfo = (ReportInExcelSchmInfo)model;
        BOSUuid id = rExcelSchmInfo.getId();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        if (id != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)id.toString(), CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)rExcelSchmInfo.getNumber()));
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)rExcelSchmInfo.getName()));
            filter.setMaskString(" #0 and (#1 or #2 )");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)rExcelSchmInfo.getNumber()));
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)rExcelSchmInfo.getName()));
            filter.setMaskString(" #0 or #1 ");
        }
        view.setFilter(filter);
        ReportInExcelSchmCollection reportInExcelSchmCollection = this.getReportInExcelSchmCollection(ctx, view);
        if (!reportInExcelSchmCollection.isEmpty() && (reSchmInfo = reportInExcelSchmCollection.get(0)) != null) {
            if (reSchmInfo.getNumber().equals(model.get("number").toString())) {
                throw new ServerException(ServerException.NUMBER_DOUBLE);
            }
            if (reSchmInfo.getName().equals(model.get("name").toString())) {
                throw new ServerException(ServerException.NAME_DOUBLE);
            }
        }
    }

    @Override
    protected Map _analysisExcelName(Context ctx, ReportInExcelMustInputInfo mustInputInfo, List fileNameList) throws BOSException, EASBizException {
        boolean isCurrencyFindError;
        boolean isTempFindError;
        if (fileNameList.isEmpty()) {
            return null;
        }
        HashMap<String, ReportInExcelMustInputInfo> resultMap = new HashMap<String, ReportInExcelMustInputInfo>();
        HashMap<String, List<FullOrgUnitInfo>> unitMap = new HashMap<String, List<FullOrgUnitInfo>>();
        HashMap<String, List<TemplateInfo>> tempMap = new HashMap<String, List<TemplateInfo>>();
        HashMap<String, List<CurrencyInfo>> currencyMap = new HashMap<String, List<CurrencyInfo>>();
        HashMap<String, List> fileMap = new HashMap<String, List>();
        List PeriodTypeEnumList = RptPeriodTypeEnum.getEnumList();
        ReportInExcelMustInputInfo importFiledInfo = null;
        boolean unitFindByNumber = true;
        boolean tempFindByNumber = true;
        boolean currncyFindByNumber = true;
        for (int i = 0; i < fileNameList.size(); ++i) {
            importFiledInfo = new ReportInExcelMustInputInfo();
            importFiledInfo.setSchmInfo(mustInputInfo.getSchmInfo());
            importFiledInfo.setUnit(mustInputInfo.getUnit());
            importFiledInfo.setTemp(mustInputInfo.getTemp());
            importFiledInfo.setCurrency(mustInputInfo.getCurrency());
            importFiledInfo.setPeriodType(mustInputInfo.getPeriodType());
            importFiledInfo.setYear(mustInputInfo.getYear());
            importFiledInfo.setPeriod(mustInputInfo.getPeriod());
            importFiledInfo.setStatus(mustInputInfo.getStatus());
            importFiledInfo.setInfoMap(mustInputInfo.getInfoMap());
            String fileName = (String)fileNameList.get(i);
            this.analysisNameRule(ctx, PeriodTypeEnumList, importFiledInfo, fileName.substring(0, fileName.lastIndexOf(".")));
            resultMap.put(fileName, importFiledInfo);
            if (!StringUtils.isEmpty((String)importFiledInfo.getErrorMsg())) continue;
            FullOrgUnitInfo unit = importFiledInfo.getUnit();
            TemplateInfo temp = importFiledInfo.getTemp();
            CurrencyInfo currency = importFiledInfo.getCurrency();
            String unitKey = null;
            String tempKey = null;
            String currencyKey = null;
            if (unit.getId() == null) {
                if (!StringUtils.isEmpty((String)unit.getNumber())) {
                    unitKey = unit.getNumber();
                } else {
                    unitKey = unit.getName();
                    unitFindByNumber = false;
                }
                if (!unitMap.containsKey(unitKey)) {
                    unitMap.put(unitKey, new ArrayList());
                }
            }
            if (temp.getId() == null) {
                if (!StringUtils.isEmpty((String)temp.getNumber())) {
                    tempKey = temp.getNumber();
                } else {
                    tempKey = temp.getName();
                    tempFindByNumber = false;
                }
                if (!tempMap.containsKey(tempKey)) {
                    tempMap.put(tempKey, new ArrayList());
                }
            }
            if (currency.getId() == null) {
                if (!StringUtils.isEmpty((String)currency.getNumber())) {
                    currencyKey = currency.getNumber();
                } else {
                    currencyKey = currency.getName();
                    currncyFindByNumber = false;
                }
                if (!currencyMap.containsKey(currencyKey)) {
                    currencyMap.put(currencyKey, new ArrayList());
                }
            }
            ArrayList<String> list = new ArrayList<String>(3);
            list.add(unitKey);
            list.add(tempKey);
            list.add(currencyKey);
            fileMap.put(fileName, list);
        }
        Map<Object, Object> infoMap = importFiledInfo.getInfoMap();
        String openUI = (String)infoMap.get("openUI");
        int isUnionflag = (Integer)infoMap.get("isUnion");
        boolean isProf = Boolean.TRUE.equals((Boolean)infoMap.get("isProf"));
        HashSet<String> unitIdSet = new HashSet<String>();
        if (unitMap.size() > 0) {
            boolean isUnitFindError = this.getUnitInfo(ctx, resultMap, fileMap, unitMap, unitFindByNumber, isUnionflag, isProf, unitIdSet);
            if (isUnitFindError) {
                return resultMap;
            }
        } else if (importFiledInfo.getUnit() != null && importFiledInfo.getUnit().getId() != null) {
            unitIdSet.add(importFiledInfo.getUnit().getId().toString());
        }
        if (tempMap.size() > 0 && unitIdSet.size() > 0 && (isTempFindError = this.getTempInfo(ctx, resultMap, fileMap, tempMap, tempFindByNumber, isUnionflag, isProf, openUI, unitIdSet))) {
            return resultMap;
        }
        if (currencyMap.size() > 0 && (isCurrencyFindError = this.getCurrencyInfo(ctx, resultMap, fileMap, currencyMap, currncyFindByNumber))) {
            return resultMap;
        }
        return resultMap;
    }

    private boolean getCurrencyInfo(Context ctx, Map<String, ReportInExcelMustInputInfo> resultMap, Map<String, List> fileMap, Map<String, List<CurrencyInfo>> currencyMap, boolean currncyFindByNumber) {
        try {
            String unitIdStr = CslRptUtil.collection2String(currencyMap.keySet(), (String)",", (boolean)true);
            String oql = currncyFindByNumber ? "select id,name,number where number in(" + unitIdStr + ")" : "select id,name,number where name in(" + unitIdStr + ")";
            CurrencyCollection col = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(oql);
            for (int i = 0; i < col.size(); ++i) {
                CurrencyInfo curInfo = col.get(i);
                if (currncyFindByNumber) {
                    currencyMap.get(curInfo.getNumber()).add(curInfo);
                    continue;
                }
                currencyMap.get(curInfo.getName()).add(curInfo);
            }
        }
        catch (BOSException e) {
            logger.error((Object)("getCurrencyInfo_error_" + e.getMessage()));
            this.setSqlErrorMsg(resultMap, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"currency_findSql_error"));
            return true;
        }
        for (Map.Entry<String, ReportInExcelMustInputInfo> entry : resultMap.entrySet()) {
            String fileName = entry.getKey();
            List list = fileMap.get(fileName);
            if (list == null) continue;
            String currencyKey = (String)list.get(2);
            List<CurrencyInfo> sameCurrencyKeyList = currencyMap.get(currencyKey);
            ReportInExcelMustInputInfo inputInfo = entry.getValue();
            if (sameCurrencyKeyList.isEmpty()) {
                if (!StringUtils.isEmpty((String)inputInfo.getErrorMsg())) continue;
                inputInfo.setErrorMsg(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"currency_not_exist"));
                continue;
            }
            if (sameCurrencyKeyList.size() == 1) {
                inputInfo.setCurrency(sameCurrencyKeyList.get(0));
                continue;
            }
            String errorMsg = currncyFindByNumber ? EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"exist_sameNumberCurrency") : EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"exist_sameNameCurrency");
            inputInfo.setErrorMsg(errorMsg);
        }
        return false;
    }

    private boolean getTempInfo(Context ctx, Map<String, ReportInExcelMustInputInfo> resultMap, Map<String, List> fileMap, Map<String, List<TemplateInfo>> tempMap, boolean tempFindByNumber, int isUnionflag, boolean isProf, String openUI, Set<String> unitIdSet) {
        HashSet<Integer> templateTypeSet = new HashSet<Integer>();
        if (0 == isUnionflag) {
            templateTypeSet.add(6);
        } else if (1 == isUnionflag) {
            if ("CslRptListUI".equals(openUI) || "CslWorkTableListUI".equals(openUI)) {
                templateTypeSet.add(5);
            } else {
                templateTypeSet.add(3);
            }
        } else {
            templateTypeSet.add(3);
            templateTypeSet.add(5);
            templateTypeSet.add(6);
        }
        String unitIdStr = CslRptUtil.collection2String(unitIdSet, (String)",", (boolean)true);
        String tempTypeStr = CslRptUtil.collection2String(templateTypeSet, (String)",", (boolean)false);
        String tempKeyStr = CslRptUtil.collection2String(tempMap.keySet(), (String)",", (boolean)true);
        StringBuilder sql = new StringBuilder();
        sql.append("select distinct template.fid tempId, template.fname tempName, template.fnumber tempNumber, template.FVERSIONNUMBER tempVersionNum,template.FperiodType tempPeriodType,template.FTemplateType tempType,\t \n");
        sql.append("template2.fid tid, template2.fname tname, template2.fnumber tnumber, template2.FVERSIONNUMBER tversionNum, template2.FperiodType tPeriodType,template2.FTemplateType  tType\t \t\t\t\t\t\t \n");
        sql.append("from T_RPT_Template template\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t\t\t\t\t\t\t \t \t\t\t\t \n");
        sql.append("inner join T_CSL_TempletDispense templetdispense on template.fid = templetdispense.FDispenseSrcID \t\t\t\t\t\t\t\t\t\t\t\t\t\t \t\t\t\t \n");
        sql.append("INNER JOIN T_ORG_BaseUnit unit ON templetdispense.FCOMPANYID = unit.FID \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t\t\t\t \n");
        sql.append("left join  T_RPT_Template template2 on template.fid = template2.FGroupTemplateID and template2.FVERSIONSTATUS = 1 and template2.fcompanyid in(" + unitIdStr + ") \t \t \n");
        sql.append("where templetdispense.FSourceType = 1 \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t\t\t\t \n");
        sql.append("and templetdispense.fcompanyid in(" + unitIdStr + ") \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \n");
        sql.append("and template.FTemplateType in(" + tempTypeStr + ") \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t\t\t\t     \n");
        sql.append("and template.FIsFreezed = 0 \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t\t\t\t \n");
        sql.append("and template.FPublishedStatus = 1 \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t\t\t\t \n");
        sql.append("and template.FVersionStatus = 1 \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t\t\t\t \n");
        sql.append("and template.FIsK3Tpl = 0 \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t\t\t\t \n");
        if (isProf) {
            sql.append("and template.FOrgType = 6\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \n");
        } else {
            sql.append("and template.FOrgType = 1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \n");
        }
        if (tempFindByNumber) {
            sql.append("and template.Fnumber in(" + tempKeyStr + ") \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \n");
        } else {
            sql.append("and template.Fname in(" + tempKeyStr + ") \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \n");
        }
        try {
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString());
            while (rowSet.next()) {
                int tempType;
                int rptPeriodTypeEnum;
                String versionNumber;
                String number;
                String name;
                TemplateInfo tempInfo = new TemplateInfo();
                String temp2Id = rowSet.getString("tid");
                if (!StringUtils.isEmpty((String)temp2Id)) {
                    tempInfo.setId(BOSUuid.read((String)temp2Id));
                    tempInfo.put("isNotGroupTem", (Object)true);
                    name = rowSet.getString("tname");
                    number = rowSet.getString("tnumber");
                    versionNumber = rowSet.getString("tversionNum");
                    rptPeriodTypeEnum = rowSet.getInt("tPeriodType");
                    tempType = rowSet.getInt("tType");
                    tempInfo.put("groupTempId", (Object)rowSet.getString("tempId"));
                } else {
                    tempInfo.setId(BOSUuid.read((String)rowSet.getString("tempId")));
                    name = rowSet.getString("tempName");
                    number = rowSet.getString("tempNumber");
                    versionNumber = rowSet.getString("tempVersionNum");
                    rptPeriodTypeEnum = rowSet.getInt("tempPeriodType");
                    tempType = rowSet.getInt("tempType");
                }
                tempInfo.setName(name);
                tempInfo.setNumber(number);
                tempInfo.setVersionNumber(versionNumber);
                tempInfo.setPeriodType(RptPeriodTypeEnum.getEnum((int)rptPeriodTypeEnum));
                tempInfo.setTemplateType(RptTmpTypeEnum.getEnum((int)tempType));
                if (tempFindByNumber) {
                    tempMap.get(number).add(tempInfo);
                    continue;
                }
                tempMap.get(name).add(tempInfo);
            }
        }
        catch (Exception e) {
            logger.error((Object)("getTempInfo_error_" + e.getMessage()));
            this.setSqlErrorMsg(resultMap, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"temp_findSql_error"));
            return true;
        }
        for (Map.Entry<String, ReportInExcelMustInputInfo> entry : resultMap.entrySet()) {
            String fileName = entry.getKey();
            List list = fileMap.get(fileName);
            if (list == null) continue;
            String tempKey = (String)list.get(1);
            List<TemplateInfo> sameTempKeyList = tempMap.get(tempKey);
            ReportInExcelMustInputInfo inputInfo = entry.getValue();
            if (sameTempKeyList.isEmpty()) {
                if (!StringUtils.isEmpty((String)inputInfo.getErrorMsg())) continue;
                String typeInfo = tempFindByNumber ? EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"number") : EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"name");
                inputInfo.setErrorMsg(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"temp_unsupport"), typeInfo, tempKey));
                continue;
            }
            RptPeriodTypeEnum infoPeriodType = inputInfo.getPeriodType();
            TemplateInfo oldTemp = inputInfo.getTemp();
            boolean isExist = false;
            for (TemplateInfo templateInfo : sameTempKeyList) {
                RptPeriodTypeEnum periodType = templateInfo.getPeriodType();
                if (infoPeriodType.getValue() != periodType.getValue()) continue;
                if (!isExist) {
                    isExist = true;
                    inputInfo.setTemp(templateInfo);
                    continue;
                }
                inputInfo.setTemp(oldTemp);
                String errorMsg = tempFindByNumber ? EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"exist_sameNumberTemp") : EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"exist_sameNameTemp");
                inputInfo.setErrorMsg(errorMsg);
                break;
            }
            TemplateInfo temp = inputInfo.getTemp();
            if (isExist || !StringUtils.isEmpty((String)inputInfo.getErrorMsg()) || temp != null && temp.getId() != null) continue;
            inputInfo.setErrorMsg(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"periodType_unmatch"));
        }
        return false;
    }

    private boolean getUnitInfo(Context ctx, Map<String, ReportInExcelMustInputInfo> resultMap, Map<String, List> fileMap, Map<String, List<FullOrgUnitInfo>> unitMap, boolean unitFindByNumber, int unit_unionType, boolean isProf, Set<String> unitIdSet) {
        boolean isSupport13Period = CslRptUtil.isSupport13Period((Context)ctx);
        Set<String> unitKeySet = unitMap.keySet();
        StringBuilder sql = new StringBuilder();
        sql.append(" select tree.fid treeId, tree.FSTARTDATE treeSt,tree.FENDDATE treeEd,tree.FLayerType layerType, unit.fid unitId, unit.fnumber unitNumber,     \t\t\n");
        sql.append(" unit.fname_" + ctx.getLocale() + " unitName, unit.fisunion isunion \t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        if (1 != unit_unionType) {
            sql.append(" ,case when unit2.fisbizunit is not null then unit2.fisbizunit else 0 end isbizunit\t\t\t\t\t\t\t \t\t\t\n");
        }
        sql.append(" from t_org_structure str \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append(" join t_org_tree tree on str.ftreeid=tree.fid \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append(" join t_org_baseunit unit on str.funitid=unit.fid \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        if (1 != unit_unionType) {
            if (isProf) {
                sql.append(" left join T_ORG_ProfitCenter unit2 on unit2.fid = unit.fid \t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
            } else {
                sql.append(" left join T_ORG_Company unit2 on unit2.fid = unit.fid \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
            }
        }
        if (unitFindByNumber) {
            sql.append(" where unit.fnumber in(" + CslRptUtil.collection2String(unitKeySet, (String)",", (boolean)true) + ")\t\t\t\t\t\t\t\t\t\t\n");
        } else {
            sql.append(" where unit.fname_" + ctx.getLocale() + " in(" + CslRptUtil.collection2String(unitKeySet, (String)",", (boolean)true) + ")\t\t\t\t\n");
        }
        sql.append(" and tree.FSTARTDATE is not null\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        try {
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString());
            while (rowSet.next()) {
                int layerType;
                boolean fisbizunit;
                String number = rowSet.getString("unitNumber");
                String name = rowSet.getString("unitName");
                boolean isunion = rowSet.getBoolean("isunion");
                if (!isunion ? 1 != unit_unionType && !(fisbizunit = rowSet.getBoolean("isbizunit")) : 1 != (layerType = rowSet.getInt("layerType"))) continue;
                FullOrgUnitInfo unit = new FullOrgUnitInfo();
                unit.setNumber(number);
                unit.setName(name);
                unit.setId(BOSUuid.read((String)rowSet.getString("unitId")));
                unit.setIsUnion(isunion);
                unit.put("treeStartDate", (Object)rowSet.getDate("treeSt"));
                unit.put("treeEndDate", (Object)rowSet.getDate("treeEd"));
                unit.put("treeId", (Object)rowSet.getString("treeId"));
                if (unitFindByNumber) {
                    unitMap.get(number).add(unit);
                    continue;
                }
                unitMap.get(name).add(unit);
            }
        }
        catch (Exception e) {
            logger.error((Object)("getUnitInfo_error_" + e.getMessage()));
            this.setSqlErrorMsg(resultMap, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"unit_findSql_error"));
            return true;
        }
        for (Map.Entry<String, ReportInExcelMustInputInfo> entry : resultMap.entrySet()) {
            String typeInfo;
            String fileName = entry.getKey();
            List list = fileMap.get(fileName);
            if (list == null) continue;
            String unitKey = (String)list.get(0);
            List<FullOrgUnitInfo> sameUnitKeyList = unitMap.get(unitKey);
            ReportInExcelMustInputInfo inputInfo = entry.getValue();
            if (sameUnitKeyList.isEmpty()) {
                String typeInfo2;
                String string = typeInfo2 = unitFindByNumber ? EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"number") : EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"name");
                String sourceStr = 2 == unit_unionType ? "bizUnitOrUnionUnit_not_find" : (1 == unit_unionType ? "union_orgUnit_not_find" : (isProf ? "profitOrgUnit_not_find" : "companyOrgUnit_not_find"));
                inputInfo.setErrorMsg(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)sourceStr), typeInfo2, unitKey));
                continue;
            }
            RptPeriodTypeEnum periodType = inputInfo.getPeriodType();
            Integer year = inputInfo.getYear();
            Integer period = inputInfo.getPeriod();
            FullOrgUnitInfo oldUnitInfo = inputInfo.getUnit();
            Date date = this.getDate(periodType, year, period, isSupport13Period);
            for (FullOrgUnitInfo unitInfo : sameUnitKeyList) {
                boolean exist;
                Date treeStartDate = (Date)unitInfo.get("treeStartDate");
                Date treeEndDate = (Date)unitInfo.get("treeEndDate");
                boolean isUnion = unitInfo.isIsUnion();
                if (date.before(treeStartDate) || treeEndDate != null && !treeEndDate.after(date) || !(0 == unit_unionType ? !isUnion && (exist = this.isExistSameUnit(unitFindByNumber, inputInfo, unitInfo, oldUnitInfo)) : (1 == unit_unionType ? isUnion && (exist = this.isExistSameUnit(unitFindByNumber, inputInfo, unitInfo, oldUnitInfo)) : (exist = this.isExistSameUnit(unitFindByNumber, inputInfo, unitInfo, oldUnitInfo))))) continue;
                break;
            }
            if (inputInfo.getUnit().getId() != null) {
                unitIdSet.add(inputInfo.getUnit().getId().toString());
                continue;
            }
            if (!StringUtils.isEmpty((String)inputInfo.getErrorMsg())) continue;
            String string = typeInfo = unitFindByNumber ? EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"number") : EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"name");
            String sourceStr = 2 == unit_unionType ? "bizUnitOrUnionUnit_not_find" : (1 == unit_unionType ? "union_orgUnit_not_find" : (isProf ? "profitOrgUnit_not_find" : "companyOrgUnit_not_find"));
            inputInfo.setErrorMsg(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)sourceStr), typeInfo, unitKey));
        }
        return false;
    }

    private void setSqlErrorMsg(Map<String, ReportInExcelMustInputInfo> resultMap, String errorMsg) {
        Collection<ReportInExcelMustInputInfo> reCollection = resultMap.values();
        for (ReportInExcelMustInputInfo mustInputInfo : reCollection) {
            if (!StringUtils.isEmpty((String)mustInputInfo.getErrorMsg())) continue;
            mustInputInfo.setErrorMsg(errorMsg);
        }
    }

    private boolean isExistSameUnit(boolean unitFindByNumber, ReportInExcelMustInputInfo inputInfo, FullOrgUnitInfo newUnitInfo, FullOrgUnitInfo oldUnitInfo) {
        if (inputInfo.getUnit().getId() == null) {
            inputInfo.setUnit(newUnitInfo);
            return false;
        }
        FullOrgUnitInfo unitInfo = inputInfo.getUnit();
        if (!unitInfo.getId().toString().equals(newUnitInfo.getId().toString())) {
            inputInfo.setUnit(oldUnitInfo);
            String errorMsg = unitFindByNumber ? EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"exist_sameNumberUnit") : EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"exist_sameNameUnit");
            inputInfo.setErrorMsg(errorMsg);
            return true;
        }
        return false;
    }

    private Date getDate(RptPeriodTypeEnum periodType, int year, int period, boolean isSupport13Period) {
        int[] rptYearAndPeriod = RPTDate13Util.getRptYearAndPeriod((int)year, (int)period, (int)periodType.getValue(), (int)0, (int)0, (boolean)isSupport13Period);
        Date periodLastDate = RPTDate13Util.getPeriodLastDate((int)rptYearAndPeriod[0], (int)rptYearAndPeriod[1], (RptPeriodTypeEnum)periodType);
        return periodLastDate;
    }

    private void getCurrencyFromMapping(Context ctx, Map<String, ReportInExcelMustInputInfo> resultMap, Map<String, List> fileMap, Map<String, List<CurrencyInfo>> currencyMap, boolean currncyFindByNumber) {
    }

    private void getTempFromMapping(Context ctx, Map<String, ReportInExcelMustInputInfo> resultMap, Map<String, List> fileMap, Map<String, List<TemplateInfo>> tempMap, boolean tempFindByNumber) {
    }

    private void getUnitFromMapping(Context ctx, Map<String, ReportInExcelMustInputInfo> resultMap, Map<String, List> fileMap, Map<String, List<FullOrgUnitInfo>> unitMap, boolean unitFindByNumber) {
    }

    private void analysisNameRule(Context ctx, List periodTypeEnumList, ReportInExcelMustInputInfo mustInputInfo, String fileName) {
        ReportInExcelSchmEntryCollection entries = mustInputInfo.getSchmInfo().getEntries();
        for (int x = 0; x < entries.size(); ++x) {
            block13: for (int y = 0; y < entries.size(); ++y) {
                String fieldInfoStr;
                ReportInExcelSchmEntryInfo entryInfo = entries.get(y);
                int index = entryInfo.getIndex();
                if (index != x) continue;
                ReportInExcelFieldEnum nameField = entryInfo.getNameField();
                RptInExFieldSaveTypeEnum fieldSaveType = entryInfo.getFieldSaveType();
                if (x != entries.size() - 1) {
                    String connectStr = entryInfo.getConnectStr() == null ? " " : entryInfo.getConnectStr();
                    int connectStrIndex = fileName.indexOf(connectStr);
                    if (connectStrIndex < 0) {
                        mustInputInfo.setErrorMsg(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"analysisName_error"));
                        return;
                    }
                    fieldInfoStr = fileName.substring(0, connectStrIndex);
                    fileName = fileName.substring(connectStrIndex + 1);
                } else {
                    fieldInfoStr = fileName;
                }
                switch (nameField.getValue()) {
                    case 0: {
                        FullOrgUnitInfo unit = new FullOrgUnitInfo();
                        if (0 == fieldSaveType.getValue()) {
                            unit.setNumber(fieldInfoStr);
                        } else if (1 == fieldSaveType.getValue()) {
                            unit.setName(fieldInfoStr);
                        }
                        mustInputInfo.setUnit(unit);
                        continue block13;
                    }
                    case 1: {
                        TemplateInfo tempInfo = new TemplateInfo();
                        if (0 == fieldSaveType.getValue()) {
                            tempInfo.setNumber(fieldInfoStr);
                        } else if (1 == fieldSaveType.getValue()) {
                            tempInfo.setName(fieldInfoStr);
                        }
                        mustInputInfo.setTemp(tempInfo);
                        continue block13;
                    }
                    case 2: {
                        CurrencyInfo currencyInfo = new CurrencyInfo();
                        if (0 == fieldSaveType.getValue()) {
                            currencyInfo.setNumber(fieldInfoStr);
                        } else if (1 == fieldSaveType.getValue()) {
                            currencyInfo.setName(fieldInfoStr);
                        }
                        mustInputInfo.setCurrency(currencyInfo);
                        continue block13;
                    }
                    case 3: {
                        RptPeriodTypeEnum periodTypeEnum = null;
                        for (int i = 0; i < periodTypeEnumList.size(); ++i) {
                            RptPeriodTypeEnum periodTypeEn = (RptPeriodTypeEnum)periodTypeEnumList.get(i);
                            if (!periodTypeEn.toString().equals(fieldInfoStr)) continue;
                            periodTypeEnum = periodTypeEn;
                            break;
                        }
                        if (periodTypeEnum == null) {
                            mustInputInfo.setErrorMsg(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"analysisPeriodType_not_exist"));
                            return;
                        }
                        mustInputInfo.setPeriodType(periodTypeEnum);
                        continue block13;
                    }
                    case 4: {
                        try {
                            mustInputInfo.setYear(Integer.parseInt(fieldInfoStr));
                            continue block13;
                        }
                        catch (NumberFormatException e) {
                            logger.error((Object)("analysisNameRule_parseYear[" + fieldInfoStr + "]error::" + e.getMessage()));
                            mustInputInfo.setErrorMsg(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"analysisName_error"));
                            return;
                        }
                    }
                    case 5: {
                        try {
                            mustInputInfo.setPeriod(Integer.parseInt(fieldInfoStr));
                            continue block13;
                        }
                        catch (NumberFormatException e) {
                            logger.error((Object)("analysisNameRule_parsePeriod[" + fieldInfoStr + "]error::" + e.getMessage()));
                            mustInputInfo.setErrorMsg(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"analysisName_error"));
                            return;
                        }
                    }
                }
            }
        }
    }

    @Override
    protected void _updateRptInfo(Context ctx, int status, String cslRptId, String rptId, int commitStatus, String userId, Date date) throws BOSException, EASBizException {
        if (0 == status) {
            return;
        }
        boolean hasCslRpt = false;
        if (cslRptId != null) {
            hasCslRpt = true;
        }
        StringBuilder rptSql = new StringBuilder();
        StringBuilder cslRptSql = new StringBuilder();
        StringBuilder itemDataSql = new StringBuilder();
        StringBuilder itemDataEnTrySql = new StringBuilder();
        if (1 == status) {
            if (hasCslRpt) {
                cslRptSql.append("update t_csl_cslreport set fauditedstatus = 2 where fid = '" + cslRptId + "'");
            }
        } else if (2 == status) {
            if (rptId != null) {
                rptSql.append(" If exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='fcommitorid' and KSQL_COL_TABNAME='t_rpt_report') ");
                rptSql.append(" update t_rpt_report set fcommitorid = '" + userId + "' where fid = '" + rptId + "' ");
            }
            if (hasCslRpt) {
                cslRptSql.append("update t_csl_cslreport set fauditedstatus = 2 ");
                cslRptSql.append(" ,fcheckedstatus =  2");
                cslRptSql.append(" ,fcommittedstatus = " + commitStatus + " ");
                cslRptSql.append(" ,fcommittime = Timestamp'" + new Timestamp(date.getTime()).toString() + "'");
                cslRptSql.append(" ,fcommitorid = '" + userId + "' ");
                cslRptSql.append(" where fid = '" + cslRptId + "'");
                this.setItemDataSql(date, commitStatus, cslRptId, itemDataSql, itemDataEnTrySql);
            }
        } else if (3 == status) {
            if (rptId != null) {
                rptSql.append(" If exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='fcommitorid' and KSQL_COL_TABNAME='t_rpt_report') ");
                rptSql.append("update t_rpt_report set fcommitorid = '" + userId + "' where fid = '" + rptId + "'");
            }
            if (hasCslRpt) {
                String timeStr = new Timestamp(date.getTime()).toString();
                cslRptSql.append("update t_csl_cslreport set fauditedstatus = 2 ");
                cslRptSql.append(" ,fcheckedstatus =  2");
                cslRptSql.append(" ,fcommittedstatus = " + commitStatus + " ");
                cslRptSql.append(" ,fcommittime = Timestamp'" + timeStr + "'");
                cslRptSql.append(" ,fcommitorid = '" + userId + "' ");
                cslRptSql.append(" ,freceiverid = '" + userId + "' ");
                cslRptSql.append(" ,freceivetime = Timestamp'" + timeStr + "'");
                cslRptSql.append(" where fid = '" + cslRptId + "'");
                this.setItemDataSql(date, commitStatus, cslRptId, itemDataSql, itemDataEnTrySql);
            }
        }
        Statement st = null;
        Connection cn = null;
        try {
            cn = super.getConnection(ctx);
            st = cn.createStatement();
            if (rptSql.length() > 0) {
                st.addBatch(rptSql.toString());
            }
            if (cslRptSql.length() > 0) {
                st.addBatch(cslRptSql.toString());
            }
            if (itemDataSql.length() > 0) {
                st.addBatch(itemDataSql.toString());
            }
            if (itemDataEnTrySql.length() > 0) {
                st.addBatch(itemDataEnTrySql.toString());
            }
            st.executeBatch();
            st.clearBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)cn);
    }

    private void setItemDataSql(Date nowDate, int commitStatus, String cslRptId, StringBuilder itemDataSql, StringBuilder itemDataEnTrySql) {
        itemDataSql.append(" UPDATE T_CSL_ITEMDATA \r\n");
        itemDataSql.append(" SET FCommitStatus = ");
        itemDataSql.append(commitStatus);
        itemDataSql.append(" ,FCommitDate = Timestamp'" + new Timestamp(nowDate.getTime()).toString() + "' \r\n");
        itemDataSql.append(" WHERE FReportID ='" + cslRptId + "'");
        itemDataEnTrySql.append("UPDATE T_CSL_ITEMDATAENTRY \r\n");
        itemDataEnTrySql.append(" SET FCommitStatus = ");
        itemDataEnTrySql.append(commitStatus);
        itemDataEnTrySql.append(" WHERE FReportID ='" + cslRptId + "'");
    }

    @Override
    protected CslReportInfo _getReportByTmpVersion(Context ctx, String tree, String companyId, String currencyId, String templetId, int rptType, int periodType, int year, int period, String reportId, String dataCollectNumber) throws BOSException {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("\tselect top 1 cslRpt.fid cslRptId, cslRpt.fAuditedStatus cslRptAuditSt, cslRpt.fCommittedStatus cslRptCommitSt, cslRpt.FIsCommitReport isCommitReport \n");
        strSQL.append("\t,rpt.Fid rptId from t_csl_cslreport cslRpt\t\t\t\t\t\t\t\t\t\t\t\t\n");
        strSQL.append("\tleft join t_rpt_report rpt on rpt.fcslreportid = cslRpt.fid \t\t\t\t\t\t\t\n");
        strSQL.append("\twhere cslRpt.forgunitid = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        strSQL.append("\t\tand cslRpt.fadjuststatus = 0 \t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        strSQL.append("\t\tand cslRpt.fcurrencyid = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        strSQL.append("\t\tand cslRpt.FSourceCurrencyID = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        strSQL.append("\t\tand cslRpt.fsourcetype = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        strSQL.append("\t\tand cslRpt.fperiodtype = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        strSQL.append("\t\tand cslRpt.fyear = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        strSQL.append("\t\tand cslRpt.fperiod = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        strSQL.append("\t\tand cslRpt.ftemplateid in ( \t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        strSQL.append("\t\tselect b.FID from t_rpt_template a,t_rpt_template b \t\t\t\t\t\t\t\t\n");
        strSQL.append("\t\twhere  a.fid = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        strSQL.append("\t\t       and a.fgroup = b.fgroup \t)\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(companyId);
        params.add(currencyId);
        params.add(currencyId);
        params.add(new Integer(rptType));
        params.add(new Integer(periodType));
        params.add(new Integer(year));
        params.add(new Integer(period));
        params.add(templetId);
        if (!StringUtils.isEmpty((String)dataCollectNumber)) {
            strSQL.append(" and cslRpt.fdatacollectnumber = ?  \n");
            params.add(dataCollectNumber);
        }
        if (reportId != null && reportId.length() != 0) {
            strSQL.append("\t\tand cslRpt.fid <> ? ");
            params.add(reportId);
        }
        IRowSet rs = DbUtil.executeQuery(ctx, strSQL.toString(), params.toArray());
        try {
            if (rs != null && rs.next()) {
                CslReportInfo cslReportInfo = new CslReportInfo();
                cslReportInfo.setId(BOSUuid.read((String)rs.getString("cslRptId")));
                cslReportInfo.setAuditedStatus(AuditedStatusEnum.getEnum((int)rs.getInt("cslRptAuditSt")));
                cslReportInfo.setCommittedStatus(CommittedStatusEnum.getEnum((int)rs.getInt("cslRptCommitSt")));
                cslReportInfo.setIsCommitReport(rs.getBoolean("isCommitReport"));
                cslReportInfo.put("rptId", (Object)rs.getString("rptId"));
                return cslReportInfo;
            }
            return null;
        }
        catch (SQLException e) {
            logger.error((Object)("_getReportByTmpVersion:" + e.getMessage()));
            throw new SQLDataException(e);
        }
    }

    @Override
    protected FullOrgUnitCollection _getParentUnitCol(Context ctx, String orgIDStr, String tempId, int year, int period, RptPeriodTypeEnum periodType) throws BOSException, EASBizException {
        FullOrgUnitCollection orgCol = new FullOrgUnitCollection();
        boolean isSupport13Period = CslRptUtil.isSupport13Period((Context)ctx);
        Date date = this.getDate(periodType, year, period, isSupport13Period);
        Object[] params = new Object[]{orgIDStr, orgIDStr, tempId, new Timestamp(date.getTime()), new Timestamp(date.getTime())};
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("select unitParent.fid parentUnitId, unitParent.fname_" + ctx.getLocale() + " parentName from t_org_baseunit unitParent\t\n");
        strSQL.append("inner join t_org_structure strParent on strParent.funitid=unitParent.fid\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        strSQL.append("inner join t_org_structure str on str.fparentid=strParent.fid\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        strSQL.append("inner join t_org_tree tree on tree.fid=str.ftreeid\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        strSQL.append("inner join T_CSL_TempletDispense\tdis on dis.FOrgBoundID=tree.fid\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        strSQL.append("inner join t_org_baseunit unit on str.funitid=unit.fid\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        strSQL.append("where unit.fid=?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        strSQL.append("and dis.FSOURCETYPE=1 and dis.FCOMPANYID=? and dis.FDISPENSESRCID=?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        strSQL.append("and tree.FSTARTDATE<=? and (tree.FENDDATE is null or tree.FENDDATE > ?)\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        IRowSet rs = DbUtil.executeQuery(ctx, strSQL.toString(), params);
        try {
            while (rs.next()) {
                FullOrgUnitInfo unit = new FullOrgUnitInfo();
                unit.setId(BOSUuid.read((String)rs.getString("parentUnitId")));
                unit.setName(rs.getString("parentName"));
                orgCol.add(unit);
            }
        }
        catch (SQLException e) {
            logger.error((Object)("_getParentUnitId:" + e.getMessage()));
            throw new SQLDataException(e);
        }
        return orgCol;
    }

    @Override
    protected void _addOtherSystemRpt(Context ctx, boolean isDeleteRpt, String rptFromSystem, String rptId, String cslRptId, ReportInExcelStatusEnum status, CoreBaseInfo reportInfo) throws BOSException, EASBizException {
        IReport iRpt = ReportFactory.getLocalInstance((Context)ctx);
        ICslReport iCsl = CslReportFactory.getLocalInstance((Context)ctx);
        if (isDeleteRpt) {
            try {
                if (rptId != null) {
                    iRpt.delete((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)rptId)));
                } else {
                    iCsl.delete((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)cslRptId)));
                }
                if ("1".equals(rptFromSystem)) {
                    ItemFormulaCheckResultFactory.getLocalInstance((Context)ctx).batchDelete(Arrays.asList(new ObjectUuidPK(BOSUuid.read((String)cslRptId))));
                }
            }
            catch (Exception e) {
                logger.error((Object)("addOtherSystemRpt_delete_error:" + e.getMessage()));
                if (e instanceof RptAndTempException && RptAndTempException.CANNTDEL_AUDITED.getCode().equals(((RptAndTempException)e).getSubCode())) {
                    String errorMsg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"exist_report"), EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"audited_report"));
                    throw new BOSException(errorMsg);
                }
                throw new BOSException((Throwable)e);
            }
        }
        if ("0".equals(rptFromSystem)) {
            boolean pass;
            ReportInfo otherSystemRptInfo = (ReportInfo)reportInfo;
            boolean hasCslRpt = false;
            IObjectPK reportPk = iRpt.addnew((CoreBaseInfo)otherSystemRptInfo);
            SelectorItemCollection selectItem = new SelectorItemCollection();
            selectItem.add(new SelectorItemInfo("cslReport.id"));
            ReportInfo rptInfo = iRpt.getReportInfo("select cslReport.id where id = '" + reportPk + "'");
            if (0 != status.getValue()) {
                String cslReportId = null;
                if (rptInfo != null && rptInfo.getCslReport() != null && rptInfo.getCslReport().getId() != null) {
                    cslReportId = rptInfo.getCslReport().getId().toString();
                    hasCslRpt = true;
                }
                this.updateRptInfo(ctx, status.getValue(), cslReportId, reportPk.toString(), otherSystemRptInfo.getCommittedStatus().getValue(), (String)otherSystemRptInfo.get("userId"), (Date)otherSystemRptInfo.get("nowDate"));
            }
            if (3 == status.getValue() && hasCslRpt && !(pass = this.checkBtwRelation(ctx, iRpt, iCsl, rptInfo.getCslReport().getId(), reportPk))) {
                String errorMsg = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"checkBtwRelation_unpass");
                throw new BOSException(errorMsg);
            }
        } else {
            boolean pass;
            CslReportInfo otherSystemRptInfo = (CslReportInfo)reportInfo;
            IObjectPK reportPk = null;
            reportPk = 0 == status.getValue() ? iCsl.addnew((CoreBaseInfo)otherSystemRptInfo) : iCsl.importReport(otherSystemRptInfo);
            if (0 != status.getValue()) {
                this.updateRptInfo(ctx, status.getValue(), reportPk.toString(), null, otherSystemRptInfo.getCommittedStatus().getValue(), (String)otherSystemRptInfo.get("userId"), (Date)otherSystemRptInfo.get("nowDate"));
            }
            if (3 == status.getValue() && reportPk != null && !(pass = this.checkBtwRelation(ctx, iRpt, iCsl, BOSUuid.read((String)reportPk.toString()), null))) {
                String errorMsg = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"checkBtwRelation_unpass");
                throw new BOSException(errorMsg);
            }
        }
    }

    private boolean checkBtwRelation(Context ctx, IReport iRpt, ICslReport iCsl, BOSUuid cslRptId, IObjectPK rptId) throws EASBizException, BOSException {
        List listResult = CheckFormulaFactory.getLocalInstance((Context)ctx).checkBtwRelation(Arrays.asList(cslRptId.toString()), 1);
        String checkResult = null;
        boolean isPassed = true;
        if (listResult != null && listResult.size() > 0) {
            for (int i = 0; i < listResult.size(); ++i) {
                Map map = (Map)listResult.get(i);
                if (map != null && map.get("KEY_CHECK_MESSAGE") != null) {
                    checkResult = (String)map.get("KEY_CHECK_MESSAGE");
                }
                if (map == null || map.get("KEY_CHECK_FLAG") == null) continue;
                isPassed = (Boolean)map.get("KEY_CHECK_FLAG");
            }
        }
        ItemFormulaCheckResultFactory.getLocalInstance((Context)ctx).batchDelete(Arrays.asList(new ObjectUuidPK(cslRptId)));
        return isPassed;
    }
}

