/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.rptIndexAnalyze.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.AnalyzeIndexCollection;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.AnalyzeIndexFactory;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.AnalyzeIndexInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.app.AbstractAnalyzeIndexControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AnalyzeIndexControllerBean
extends AbstractAnalyzeIndexControllerBean {
    private static final long serialVersionUID = -1906994298977274530L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.app.AnalyzeIndexControllerBean");

    @Override
    protected Map _batchExecute(Context ctx, Map params) throws BOSException, EASBizException {
        ArrayList<Object[]> param;
        List addNewList = (List)params.get("addNewList");
        List modifyList = (List)params.get("modifyList");
        List deleteIds = (List)params.get("deleteIds");
        StringBuffer sql = new StringBuffer();
        AnalyzeIndexCollection analyzeIndexs = null;
        if (deleteIds != null && !deleteIds.isEmpty()) {
            analyzeIndexs = AnalyzeIndexFactory.getLocalInstance(ctx).getAnalyzeIndexCollection("select id,number,name where id in(" + CslRptUtil.list2String((List)deleteIds, (String)",", (boolean)true) + ")");
            sql.append(" delete from T_CSL_AnalyzeIndex where fid=? ");
            param = new ArrayList();
            for (Object obj : deleteIds) {
                param.add(new Object[]{obj});
            }
            DbUtil.executeBatch(ctx, sql.toString(), param);
        }
        if (modifyList != null && !modifyList.isEmpty()) {
            sql = new StringBuffer();
            sql.append(" update T_CSL_AnalyzeIndex set FNUMBER =?,FNAME=?,FFormula=?,FDescription=?,FLastUpdateUserID=?,FLastUpdateTime=? where fid=? ");
            param = new ArrayList<Object[]>();
            Timestamp time = this.getTime();
            for (Object obj : modifyList) {
                Object[] objs = (Object[])obj;
                param.add(new Object[]{objs[1], objs[2], objs[3], objs[4], ctx.getCaller().toString(), time, objs[0]});
            }
            DbUtil.executeBatch(ctx, sql.toString(), param);
        }
        if (addNewList != null && !addNewList.isEmpty()) {
            this.batchInsert(ctx, addNewList);
        }
        this.addLog(ctx, addNewList, modifyList, analyzeIndexs);
        return null;
    }

    private void addLog(Context ctx, List addNewList, List modifyList, AnalyzeIndexCollection analyzeIndexs) throws BOSException {
        AnalyzeIndexInfo info;
        int i;
        CoreBaseInfo[] delObjs;
        if (analyzeIndexs != null && !analyzeIndexs.isEmpty()) {
            delObjs = new CoreBaseInfo[analyzeIndexs.size()];
            for (i = 0; i < analyzeIndexs.size(); ++i) {
                info = analyzeIndexs.get(i);
                delObjs[i] = info;
            }
            this.delete_log(ctx, delObjs);
        }
        if (!addNewList.isEmpty()) {
            delObjs = new CoreBaseInfo[addNewList.size()];
            for (i = 0; i < addNewList.size(); ++i) {
                info = new AnalyzeIndexInfo();
                info.setNumber(((Object[])addNewList.get(i))[0].toString());
                info.setName(((Object[])addNewList.get(i))[1].toString());
                delObjs[i] = info;
            }
            this.addnew_log(ctx, delObjs);
        }
        if (!modifyList.isEmpty()) {
            delObjs = new CoreBaseInfo[modifyList.size()];
            for (i = 0; i < modifyList.size(); ++i) {
                info = new AnalyzeIndexInfo();
                info.setNumber(((Object[])modifyList.get(i))[1].toString());
                info.setName(((Object[])modifyList.get(i))[2].toString());
                delObjs[i] = info;
            }
            this.update_log(ctx, delObjs);
        }
    }

    private void batchInsert(Context ctx, List addNewList) throws BOSException {
        String companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        String userId = ctx.getCaller().toString();
        String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        Timestamp time = this.getTime();
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("Insert into T_CSL_AnalyzeIndex (FID, FNumber, FName, FFormula, FDescription, FCompanyId, FIndexType, FCreatorId, FCreateTime, FLastUpdateUserId, FLastUpdateTime, FControlUnitId)");
            sql.append(" values(?,?,?,?,?,?,?,?,?,?,?,?)");
            ps = conn.prepareStatement(sql.toString());
            boolean isInsert = false;
            for (int i = 0; i < addNewList.size(); ++i) {
                Object[] objects = (Object[])addNewList.get(i);
                String number = (String)objects[0];
                String name = (String)objects[1];
                String formula = (String)objects[2];
                String description = (String)objects[3];
                String typeId = (String)objects[4];
                String id = BOSUuid.create((BOSObjectType)new AnalyzeIndexInfo().getBOSType()).toString();
                ps.setObject(1, id);
                ps.setObject(2, number);
                ps.setObject(3, name);
                ps.setObject(4, formula);
                ps.setObject(5, description);
                ps.setObject(6, companyId);
                ps.setObject(7, typeId);
                ps.setObject(8, userId);
                ps.setObject(9, time);
                ps.setObject(10, userId);
                ps.setObject(11, time);
                ps.setObject(12, cuId);
                ps.addBatch();
                isInsert = true;
            }
            if (isInsert) {
                ps.executeBatch();
                ps.clearBatch();
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"AnalyzeIndexbatchInsert: ", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(null, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(null, (Statement)ps, (Connection)conn);
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    @Override
    protected void _addnew_log(Context ctx, CoreBaseInfo[] analyzeIndexInfos) throws BOSException {
    }

    @Override
    protected void _update_log(Context ctx, CoreBaseInfo[] analyzeIndexInfos) throws BOSException {
    }

    @Override
    protected void _delete_log(Context ctx, CoreBaseInfo[] analyzeIndexInfos) throws BOSException {
    }
}

