/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.rptIndexAnalyze.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.FunctionManager;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CSLPropertyAdapter;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.app.FormulaUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.ICalculator;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.ReportCalculateContext;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.AnalyzeIndexInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.CalculateProcessCollection;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.CalculateProcessEnum;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.CalculateProcessFactory;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.CalculateProcessInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.ICalculateProcess;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.app.AbstractCalulateRptQingAnalyze;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.util.PeriodIterator;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.util.RptQingAnalyzeUtil;
import com.kingdee.eas.fi.rpt.PeriodHandler;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fi.rpt.batch.log.LogService;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class CalculateIndexRptQingAnalyze
extends AbstractCalulateRptQingAnalyze {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.app.CalculateIndexRptQingAnalyze");
    public static final String SPLITSTR = "###";
    private LogService logService;

    public CalculateIndexRptQingAnalyze(Context ctx, RptQingAnalyzeInfo theme) {
        super(ctx, theme);
    }

    @Override
    public MetaInfo getMeta() {
        MetaInfo metaInfo = new MetaInfo();
        metaInfo.addField("FBizDate", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "102_bizDate"), DataType.DATE);
        metaInfo.addField("FYear", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "77_year"), DataType.STRING);
        metaInfo.addField("FPeriod", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "78_period"), DataType.STRING);
        metaInfo.addField("FOrgUnitId", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "88_orgId"), DataType.STRING);
        metaInfo.addField("FOrgUnitNumber", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "46_orgNum"), DataType.STRING);
        metaInfo.addField("FOrgUnitParent", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "63_orgPNum"), DataType.STRING);
        metaInfo.addField("FOrgUnitName", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "47_orgName"), DataType.STRING);
        metaInfo.addField("FAnalyzeIndexNumber", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "71_analyzeIndexNum"), DataType.STRING);
        metaInfo.addField("FAnalyzeIndexParent", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "72_analyzeIndexPNum"), DataType.STRING);
        metaInfo.addField("FAnalyzeIndexName", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "73_analyzeIndexName"), DataType.STRING);
        if (this.theme.getDataElement() != null && !this.theme.getDataElement().isEmpty()) {
            metaInfo.addField("FDataElementNumber", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "53_deNumber"), DataType.STRING);
            metaInfo.addField("FDataElementParent", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "66_dePNum"), DataType.STRING);
            metaInfo.addField("FDataElementName", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "54_deName"), DataType.STRING);
        }
        metaInfo.addField("FCurrencyNumber", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "48_curNum"), DataType.STRING);
        metaInfo.addField("FCurrencyParent", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "64_curPNum"), DataType.STRING);
        metaInfo.addField("FCurrencyName", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "49_curName"), DataType.STRING);
        if (this.theme.getDataType() != null) {
            metaInfo.addField("FdataType", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "55_dataType"), DataType.STRING);
        }
        metaInfo.addField("FAnalyzeIndexValue", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "70_analyzeIndex"), DataType.NUMBER);
        return metaInfo;
    }

    @Override
    public List<Object[]> getData() throws Exception {
        return this.getAnalyzeIndexData();
    }

    private List<Object[]> getAnalyzeIndexData() throws Exception {
        ArrayList<Object[]> datas = new ArrayList<Object[]>();
        Map<String, BigDecimal> results = this.calFormulas();
        Iterator<String> it = results.keySet().iterator();
        Object[] data = null;
        boolean hasDataElement = this.theme.getDataElement() != null && !this.theme.getDataElement().isEmpty();
        int de = hasDataElement ? 3 : 0;
        boolean hasDataType = this.theme.getDataType() != null;
        int dt = hasDataType ? 1 : 0;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        RptPeriodTypeEnum periodType = this.theme.getPeriodType();
        Date bizDate = null;
        while (it.hasNext()) {
            String key = it.next();
            BigDecimal value = results.get(key);
            String[] keys = key.split(SPLITSTR);
            data = new Object[14 + de + dt];
            String year = keys[0];
            String period = keys[1];
            period = this.getPeriodString(periodType, period);
            bizDate = this.getDate(dateFormat, periodType, year, period);
            data[0] = bizDate;
            data[1] = year;
            data[2] = period;
            data[3] = keys[2];
            data[4] = keys[3];
            data[5] = null;
            data[6] = keys[4];
            data[7] = keys[7];
            data[8] = null;
            data[9] = keys[8];
            if (this.theme.getDataElement() != null && !this.theme.getDataElement().isEmpty()) {
                data[10] = keys[9];
                data[11] = null;
                data[12] = keys[10];
                data[13] = keys[5];
                data[14] = null;
                data[15] = keys[6];
                if (this.theme.getDataType() != null) {
                    data[16] = keys[11];
                    data[17] = value;
                } else {
                    data[16] = value;
                }
            } else {
                data[10] = keys[5];
                data[11] = null;
                data[12] = keys[6];
                if (this.theme.getDataType() != null) {
                    data[13] = keys[9];
                    data[14] = value;
                } else {
                    data[13] = value;
                }
            }
            datas.add(data);
        }
        return datas;
    }

    private Map<String, BigDecimal> calBatchFormulas() throws Exception {
        List<AnalyzeIndexInfo> analyzeIndexes = this.getAnalyzeIndex();
        List<FullOrgUnitInfo> orgUnits = this.getOrgUnit();
        List<CurrencyInfo> currencys = this.getCurrency();
        List<DataElementInfo> dataElements = this.getDataElement();
        List<Integer> dataTypes = this.getDataType();
        Book book = null;
        Sheet sheet = null;
        ArrayList<Map<String, String>> formulaList = new ArrayList<Map<String, String>>();
        HashMap<String, BigDecimal> values = new HashMap<String, BigDecimal>();
        String yearString = RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "77_year");
        String periodString = RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "78_period");
        ReportInfo reportInfo = new ReportInfo();
        book = this.initReportBook(reportInfo);
        sheet = book.getSheet(0);
        this.setBatchSheetTitle(sheet);
        String treeNumber = this.getOrgTreeNumber();
        Set<String> startedFICompanyIds = this.getStartedCompanyIds(this.ctx);
        for (FullOrgUnitInfo orgUnit : orgUnits) {
            boolean isUnion = orgUnit.isIsUnion();
            for (CurrencyInfo currency : currencys) {
                PeriodIterator pit = this.getPeriodIterator();
                while (pit.hasNext()) {
                    Object[] yearPeriod = pit.next();
                    int year = (Integer)yearPeriod[0];
                    int period = (Integer)yearPeriod[1];
                    this.collectBatchFormula(analyzeIndexes, startedFICompanyIds, dataElements, dataTypes, formulaList, orgUnit, isUnion, currency, year, period, treeNumber);
                    if (period != 12) continue;
                    period = 13;
                    this.collectBatchFormula(analyzeIndexes, startedFICompanyIds, dataElements, dataTypes, formulaList, orgUnit, isUnion, currency, year, period, treeNumber);
                }
            }
        }
        if (!formulaList.isEmpty()) {
            this.batchFillFormulaToSheet(sheet, formulaList, yearString, periodString);
            sheet.calc();
            boolean isError = this.getFormulaValues(sheet, formulaList, values, 8);
            this.updateCalLog(isError, book);
        }
        return values;
    }

    private String getOrgTreeNumber() throws Exception {
        String treeNumber = null;
        OrgTreeInfo tree = this.theme.getOrgTree();
        if (tree == null) {
            OrgTreeCollection orgTrees;
            OrgTreeInfo orgTree;
            if (OrgTreeFactory.getLocalInstance((Context)this.ctx).exists("select number where basic = 1 and status = 1 and (isHide = 0 or isHide is null) and type = 8 and isForBudget = 0") && (orgTree = OrgTreeFactory.getLocalInstance((Context)this.ctx).getOrgTreeInfo("select number where basic = 1 and status = 1 and (isHide = 0 or isHide is null) and type = 8 and isForBudget = 0")) != null) {
                treeNumber = orgTree.getNumber();
            }
            if (treeNumber == null && OrgTreeFactory.getLocalInstance((Context)this.ctx).exists("select number where status = 1 and (isHide = 0 or isHide is null) and type = 8") && (orgTrees = OrgTreeFactory.getLocalInstance((Context)this.ctx).getOrgTreeCollection("select number where status = 1 and (isHide = 0 or isHide is null) and type = 8 order by number")) != null && !orgTrees.isEmpty()) {
                treeNumber = orgTrees.get(0).getNumber();
            }
        } else {
            treeNumber = tree.getNumber();
        }
        return treeNumber;
    }

    private Book initReportBook(ReportInfo reportInfo) throws Exception {
        Book book = Book.Manager.getNewBook(null, (int)1);
        FunctionManager fm = book.getDeps().getFunctionManager();
        ReportCalculateErrorProvider errorhandler = new ReportCalculateErrorProvider();
        ReportCalculateErrorProvider.addErrorProvider(Exception.class, (IErrorProvider)errorhandler);
        ReportCalculateContext calcContext = new ReportCalculateContext(this.ctx);
        calcContext.setReportAdapter((IReportPropertyAdapter)new RptReportPropertyAdapter(reportInfo));
        calcContext.setErrorProvider((IErrorProvider)errorhandler);
        ReportVariables iv = new ReportVariables();
        iv.add(new VariableEntry("Check_Permissioin", null, 1, "false", false));
        calcContext.setReportVariables(iv);
        this.registerFormulaToBook(calcContext, fm);
        book.setCalculate(false);
        return book;
    }

    private void registerFormulaToBook(ICalculateContextProvider context, FunctionManager fm) throws Exception {
        List implClass = FormulaDefinition.getInstance().getImplClass();
        for (int i = 0; i < implClass.size(); ++i) {
            String cname = (String)implClass.get(i);
            Class<?> clazz = Class.forName(cname);
            Object obj = clazz.newInstance();
            if (obj instanceof ICalculator) {
                ((ICalculator)obj).initCalculateContext(context);
            }
            fm.addFunctionProvider(obj, true);
        }
        List batchImplClass = FormulaDefinition.getInstance().getBatchImplClass();
        for (int i = 0; i < batchImplClass.size(); ++i) {
            String cname = (String)batchImplClass.get(i);
            Class<?> clazz = Class.forName(cname);
            Object obj = clazz.newInstance();
            if (obj instanceof ICalculator) {
                ((ICalculator)obj).initCalculateContext(context);
            }
            fm.addFunctionProvider(obj, true);
        }
    }

    private void updateCalLog(boolean isError, Book book) throws Exception {
        ICalculateProcess iCal = CalculateProcessFactory.getLocalInstance(this.ctx);
        String themeId = this.theme.getId().toString();
        CalculateProcessCollection calPros = iCal.getCalculateProcessCollection("where analyze = '" + themeId + "' and calculateProcess <> " + 4 + "");
        if (calPros != null && !calPros.isEmpty()) {
            CoreBaseCollection colls = new CoreBaseCollection();
            Iterator it = calPros.iterator();
            while (it.hasNext()) {
                CalculateProcessInfo calPro = (CalculateProcessInfo)it.next();
                calPro.setData(IOHelper.packBook((Book)book));
                if (isError) {
                    calPro.setCalculateProcess(CalculateProcessEnum.CALFAIL);
                }
                colls.add((CoreBaseInfo)calPro);
            }
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("data"));
            selector.add(new SelectorItemInfo("calculateProcess"));
            iCal.updatePartialBatchData((IObjectCollection)colls, selector);
        }
    }

    private void collectBatchFormula(List<AnalyzeIndexInfo> batchIndexes, Set<String> startedFICompanyIds, List<DataElementInfo> dataElements, List<Integer> dataTypes, List<Map<String, String>> formulaList, FullOrgUnitInfo orgUnit, boolean isUnion, CurrencyInfo currency, int year, int period, String treeNumber) throws BOSException {
        for (AnalyzeIndexInfo analyzeIndex : batchIndexes) {
            String indexNum = analyzeIndex.getNumber();
            String indexName = analyzeIndex.getName();
            String formula = analyzeIndex.getFormula();
            if (!this.isIFFormula(formula = this.formulaRelpace(formula, orgUnit, currency, year, period)) && this.isFIFormula(formula) && !startedFICompanyIds.contains(orgUnit.getId().toString())) continue;
            ConcurrentHashMap<String, String> formulaMap = new ConcurrentHashMap<String, String>();
            this.getFormulaMap(dataElements, dataTypes, formulaMap, indexNum, indexName, formula, orgUnit, isUnion, currency, year, period, treeNumber);
            formulaList.add(formulaMap);
        }
    }

    private String formulaRelpace(String formula, FullOrgUnitInfo orgUnit, CurrencyInfo currency, int year, int period) {
        formula = formula.replace("@O", orgUnit.getNumber());
        formula = formula.replace("@C", currency.getNumber());
        formula = formula.replace("@Y", String.valueOf(year));
        formula = formula.replace("@P", String.valueOf(period));
        return formula;
    }

    private void setBatchSheetTitle(Sheet sheet) {
        String keyTitle = "KEY";
        String companyNameTitle = RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "124_comName");
        String yearAndPeriodTitle = RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "125_yearPeriod");
        String currencyNameTitle = RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "126_currencyName");
        String indexNumberTitle = RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "74_indexNumber");
        String indexNameTitle = RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "75_indexName");
        String deNameTitle = RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "54_deName");
        String dataTypeTitle = RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "127_dataType");
        String result = RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "76_result");
        sheet.getCell(0, 0, true).setValue(new Variant((Object)keyTitle));
        sheet.getCell(0, 1, true).setValue(new Variant((Object)companyNameTitle));
        sheet.getCell(0, 2, true).setValue(new Variant((Object)yearAndPeriodTitle));
        sheet.getCell(0, 3, true).setValue(new Variant((Object)currencyNameTitle));
        sheet.getCell(0, 4, true).setValue(new Variant((Object)indexNumberTitle));
        sheet.getCell(0, 5, true).setValue(new Variant((Object)indexNameTitle));
        sheet.getCell(0, 6, true).setValue(new Variant((Object)deNameTitle));
        sheet.getCell(0, 7, true).setValue(new Variant((Object)dataTypeTitle));
        sheet.getCell(0, 8, true).setValue(new Variant((Object)result));
    }

    private void batchFillFormulaToSheet(Sheet sheet, List<Map<String, String>> formulaList, String yearString, String periodString) {
        int index = 1;
        for (Map<String, String> formulaMap : formulaList) {
            for (String key : formulaMap.keySet()) {
                String[] keys = key.split(SPLITSTR);
                String formula = formulaMap.get(key);
                sheet.getCell(index, 0, true).setValue(new Variant((Object)key));
                sheet.getCell(index, 1, true).setValue(new Variant((Object)keys[4]));
                String yearPeriod = keys[0] + yearString + keys[1] + periodString;
                sheet.getCell(index, 2, true).setValue(new Variant((Object)yearPeriod));
                sheet.getCell(index, 3, true).setValue(new Variant((Object)keys[6]));
                sheet.getCell(index, 4, true).setValue(new Variant((Object)keys[7]));
                sheet.getCell(index, 5, true).setValue(new Variant((Object)keys[8]));
                if (keys.length == 10) {
                    sheet.getCell(index, 7, true).setValue(new Variant((Object)keys[9]));
                    sheet.getCell(index, 8, true).setFormula("=" + formula);
                } else if (keys.length == 11) {
                    sheet.getCell(index, 6, true).setValue(new Variant((Object)keys[10]));
                    sheet.getCell(index, 8, true).setFormula("=" + formula);
                } else if (keys.length == 12) {
                    sheet.getCell(index, 6, true).setValue(new Variant((Object)keys[10]));
                    sheet.getCell(index, 7, true).setValue(new Variant((Object)keys[11]));
                    sheet.getCell(index, 8, true).setFormula("=" + formula);
                }
                ++index;
            }
        }
    }

    private Map<String, BigDecimal> calFormulas() throws Exception {
        long startTime = System.currentTimeMillis();
        this.logService = new LogService(logger, DebugLogger.isDebug);
        this.logService.addLogItem("ZTFX: CalFormulasBegin", "-------------start-------------");
        final List<AnalyzeIndexInfo> analyzeIndexes = this.getAnalyzeIndex();
        final List<FullOrgUnitInfo> orgUnits = this.getOrgUnit();
        final List<CurrencyInfo> currencys = this.getCurrency();
        final List<DataElementInfo> dataElements = this.getDataElement();
        final List<Integer> dataTypes = this.getDataType();
        final ConcurrentHashMap<String, BigDecimal> values = new ConcurrentHashMap<String, BigDecimal>();
        final String yearString = RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "77_year");
        final String periodString = RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "78_period");
        final String indexNumberTitle = RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "74_indexNumber");
        final String indexNameTitle = RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "75_indexName");
        final String deNameTitle = RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "54_deName");
        final String result = RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "76_result");
        final String treeNumber = this.getOrgTreeNumber();
        final Set<String> startedFICompanyIds = this.getStartedCompanyIds(this.ctx);
        PeriodIterator pit = this.getPeriodIterator();
        final String[] params = this.getFormulaCslParams(this.ctx, "ZTFX_SetThreadCountForIndexAnalyze");
        int threadCount = Integer.valueOf(params[0]);
        final AtomicInteger atomic = new AtomicInteger(0);
        while (pit.hasNext()) {
            Object[] yearPeriod = pit.next();
            final int year = (Integer)yearPeriod[0];
            final int period = (Integer)yearPeriod[1];
            while (atomic.get() >= threadCount) {
                Thread.sleep(50L);
            }
            atomic.addAndGet(1);
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        CalculateIndexRptQingAnalyze.this.calIndexAnalyzeForAllCurrency(analyzeIndexes, orgUnits, currencys, dataElements, dataTypes, values, yearString, periodString, indexNumberTitle, indexNameTitle, deNameTitle, result, treeNumber, startedFICompanyIds, params, year, period);
                    }
                    catch (Exception e) {
                        logger.error((Object)"calIndexAnalyzeForAllCurrency: ", (Throwable)e);
                    }
                    finally {
                        atomic.addAndGet(-1);
                    }
                }
            };
            thread.start();
        }
        if (atomic.get() > 0) {
            while (atomic.get() > 0) {
                Thread.sleep(100L);
            }
        }
        long endTime = System.currentTimeMillis();
        this.logService.addLogItem("ZTFX: CalFormulasSpanTime", String.valueOf(endTime - startTime));
        this.logService.addLogItem("ZTFX: CalFormulasEnd", "-------------end-------------");
        this.logService.logIt();
        this.logService.reset();
        return values;
    }

    private void calIndexAnalyzeForAllCurrency(final List<AnalyzeIndexInfo> analyzeIndexes, final List<FullOrgUnitInfo> orgUnits, List<CurrencyInfo> currencys, final List<DataElementInfo> dataElements, final List<Integer> dataTypes, final Map<String, BigDecimal> values, final String yearString, final String periodString, final String indexNumberTitle, final String indexNameTitle, final String deNameTitle, final String result, final String treeNumber, final Set<String> startedFICompanyIds, final String[] params, final int year, final int period) throws Exception {
        int threadCount = 2;
        final AtomicInteger atomic = new AtomicInteger(0);
        boolean isUseThread = false;
        if (currencys.size() > 1) {
            isUseThread = true;
        }
        for (final CurrencyInfo currency : currencys) {
            final String currencyId = currency.getId().toString();
            final String currencyNumber = currency.getNumber();
            final String currencyName = currency.getName();
            if (isUseThread) {
                while (atomic.get() >= 2) {
                    Thread.sleep(50L);
                }
                atomic.addAndGet(1);
                Thread thread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            long startTime = System.currentTimeMillis();
                            CalculateIndexRptQingAnalyze.this.calIndexAnalyzeForAllCompany(analyzeIndexes, orgUnits, dataElements, dataTypes, values, yearString, periodString, indexNumberTitle, indexNameTitle, deNameTitle, result, treeNumber, startedFICompanyIds, year, period, currency, currencyId, currencyNumber, currencyName, params);
                            long endTime = System.currentTimeMillis();
                            CalculateIndexRptQingAnalyze.this.logService.addLogItem("ZTFX: CalIndexAnalyzeForAllCompanyCurrncyId", new Object[]{currencyId, " OrgSize: " + orgUnits.size() + " YearPeriod: " + year + yearString + period + periodString + " ExecuteSpanTime: " + String.valueOf(endTime - startTime)});
                        }
                        catch (Exception e) {
                            logger.error((Object)"calIndexAnalyzeForAllCompany: ", (Throwable)e);
                        }
                        finally {
                            atomic.addAndGet(-1);
                        }
                    }
                };
                thread.start();
                continue;
            }
            long startTime = System.currentTimeMillis();
            this.calIndexAnalyzeForAllCompany(analyzeIndexes, orgUnits, dataElements, dataTypes, values, yearString, periodString, indexNumberTitle, indexNameTitle, deNameTitle, result, treeNumber, startedFICompanyIds, year, period, currency, currencyId, currencyNumber, currencyName, params);
            long endTime = System.currentTimeMillis();
            this.logService.addLogItem("ZTFX: calIndexAnalyzeForAllCompanyCurrncyId", new Object[]{currencyId, " OrgSize: " + orgUnits.size() + " YearPeriod: " + year + yearString + period + periodString + " ExecuteSpanTime: " + String.valueOf(endTime - startTime)});
        }
        if (isUseThread && atomic.get() > 0) {
            while (isUseThread && atomic.get() > 0) {
                Thread.sleep(100L);
            }
        }
    }

    private void calIndexAnalyzeForAllCompany(final List<AnalyzeIndexInfo> analyzeIndexes, List<FullOrgUnitInfo> orgUnits, final List<DataElementInfo> dataElements, final List<Integer> dataTypes, final Map<String, BigDecimal> values, final String yearString, final String periodString, final String indexNumberTitle, final String indexNameTitle, final String deNameTitle, final String result, final String treeNumber, final Set<String> startedFICompanyIds, final int year, final int period, final CurrencyInfo currency, final String currencyId, final String currencyNumber, final String currencyName, String[] params) throws Exception {
        int threadCount = Integer.valueOf(params[1]);
        final AtomicInteger atomic = new AtomicInteger(0);
        boolean isUseThread = false;
        if (orgUnits.size() > 1) {
            isUseThread = true;
        }
        for (final FullOrgUnitInfo orgUnit : orgUnits) {
            final String orgId = orgUnit.getId().toString();
            final String orgNum = orgUnit.getNumber();
            final String orgName = orgUnit.getName();
            final boolean isUnion = orgUnit.isIsUnion();
            if (isUseThread) {
                while (atomic.get() >= threadCount) {
                    Thread.sleep(50L);
                }
                atomic.addAndGet(1);
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            CalculateIndexRptQingAnalyze.this.calFormula(analyzeIndexes, startedFICompanyIds, dataElements, dataTypes, values, yearString, periodString, orgUnit, orgId, orgNum, orgName, isUnion, currency, currencyId, currencyNumber, currencyName, year, period, treeNumber, indexNumberTitle, indexNameTitle, deNameTitle, result);
                            if (period == 12) {
                                int periodnew = 13;
                                CalculateIndexRptQingAnalyze.this.calFormula(analyzeIndexes, startedFICompanyIds, dataElements, dataTypes, values, yearString, periodString, orgUnit, orgId, orgNum, orgName, isUnion, currency, currencyId, currencyNumber, currencyName, year, 13, treeNumber, indexNumberTitle, indexNameTitle, deNameTitle, result);
                            }
                        }
                        catch (Exception e) {
                            logger.error((Object)"calFormula: ", (Throwable)e);
                        }
                        finally {
                            atomic.addAndGet(-1);
                        }
                    }
                };
                thread.start();
                continue;
            }
            this.calFormula(analyzeIndexes, startedFICompanyIds, dataElements, dataTypes, values, yearString, periodString, orgUnit, orgId, orgNum, orgName, isUnion, currency, currencyId, currencyNumber, currencyName, year, period, treeNumber, indexNumberTitle, indexNameTitle, deNameTitle, result);
            if (period != 12) continue;
            int periodnew = 13;
            this.calFormula(analyzeIndexes, startedFICompanyIds, dataElements, dataTypes, values, yearString, periodString, orgUnit, orgId, orgNum, orgName, isUnion, currency, currencyId, currencyNumber, currencyName, year, 13, treeNumber, indexNumberTitle, indexNameTitle, deNameTitle, result);
        }
        if (isUseThread && atomic.get() > 0) {
            while (isUseThread && atomic.get() > 0) {
                Thread.sleep(100L);
            }
        }
    }

    private String[] getFormulaCslParams(Context ctx, String key) {
        String[] params = new String[2];
        String param = CSLParamUtil.getStringCslParamValue((Context)ctx, (String)key);
        if (param == null) {
            params[0] = "3";
            params[1] = "3";
        } else if (param.contains(",")) {
            params = param.split(",");
            if (params.length != 2) {
                params[0] = "3";
                params[1] = "3";
            }
        } else {
            params[0] = "3";
            params[1] = "3";
        }
        return params;
    }

    private void calFormula(List<AnalyzeIndexInfo> analyzeIndexs, Set<String> startedFICompanyIds, List<DataElementInfo> dataElements, List<Integer> dataTypes, Map<String, BigDecimal> values, String yearString, String periodString, FullOrgUnitInfo orgUnit, String orgId, String orgNum, String orgName, boolean isUnion, CurrencyInfo currency, String currencyId, String currencyNumber, String currencyName, int year, int period, String treeNumber, String indexNumberTitle, String indexNameTitle, String deNameTitle, String result) throws Exception {
        ArrayList<Map<String, String>> formulaList = new ArrayList<Map<String, String>>();
        this.collectBatchFormula(analyzeIndexs, startedFICompanyIds, dataElements, dataTypes, formulaList, orgUnit, isUnion, currency, year, period, treeNumber);
        if (!formulaList.isEmpty()) {
            CslReportInfo cslReportInfo = this.getCslReportInfo(orgUnit, currency, year, period);
            Book book = this.initBook(cslReportInfo);
            Sheet sheet = book.getSheet(0);
            this.setSheetTitle(sheet, indexNumberTitle, indexNameTitle, deNameTitle, result);
            this.fillFormulaToSheet(sheet, formulaList);
            sheet.calc();
            boolean isError = this.getFormulaValues(sheet, formulaList, values, 4);
            this.addCalProcessInfo(orgId, orgNum, orgName, currencyId, currencyNumber, currencyName, year, period, book, isError, yearString, periodString);
        }
    }

    private void setSheetTitle(Sheet sheet, String indexNumberTitle, String indexNameTitle, String deNameTitle, String result) {
        String keyTitle = "KEY";
        sheet.getCell(0, 0, true).setValue(new Variant((Object)keyTitle));
        sheet.getCell(0, 1, true).setValue(new Variant((Object)indexNumberTitle));
        sheet.getCell(0, 2, true).setValue(new Variant((Object)indexNameTitle));
        sheet.getCell(0, 3, true).setValue(new Variant((Object)deNameTitle));
        sheet.getCell(0, 4, true).setValue(new Variant((Object)result));
    }

    private void addLogs(List<CalculateProcessInfo> logs) throws EASBizException, BOSException {
        Connection conn = null;
        PreparedStatement ps = null;
        BOSObjectType bosType = new CalculateProcessInfo().getBOSType();
        StringBuffer sql = new StringBuffer();
        sql.append(" Insert Into T_CSL_CalculateProcess(FId,FAnalyzeId,FAnalyzeName,FOrgUnitId,FOrgUnitNumber,FOrgUnitName,FYear,FPeriod,");
        sql.append("FYearPeriod,FCurrencyId,FCurrencyNumber,FCurrencyName,FData,FCalculateProcess,FCalculatorId,FCalculateTime)");
        sql.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,getdate())");
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            ps = conn.prepareStatement(sql.toString());
            Iterator<CalculateProcessInfo> it = logs.iterator();
            boolean isEmpty = true;
            int index = 0;
            while (it.hasNext()) {
                CalculateProcessInfo info = it.next();
                ps.setObject(1, BOSUuid.create((BOSObjectType)bosType).toString());
                ps.setObject(2, info.getAnalyze().getId().toString());
                ps.setObject(3, info.getAnalyze().getName());
                ps.setObject(4, info.getOrgUnitId());
                ps.setObject(5, info.getOrgUnitNumber());
                ps.setObject(6, info.getOrgUnitName());
                ps.setObject(7, info.getYear());
                ps.setObject(8, info.getPeriod());
                ps.setObject(9, info.getYearPeriod());
                ps.setObject(10, info.getCurrencyId());
                ps.setObject(11, info.getCurrencyNumber());
                ps.setObject(12, info.getCurrencyName());
                ps.setObject(13, info.getData());
                ps.setObject(14, info.getCalculateProcess().getValue());
                ps.setObject(15, info.getCalculator().getId().toString());
                ps.addBatch();
                if (index % 500 == 0) {
                    ps.executeBatch();
                    ps.clearBatch();
                    isEmpty = true;
                } else {
                    isEmpty = false;
                }
                ++index;
            }
            if (!isEmpty) {
                ps.executeBatch();
                ps.clearBatch();
            }
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql1 execute exception : " + sql.toString(), (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    private void addCalProcessInfo(String orgId, String orgNum, String orgName, String currencyId, String currencyNumber, String currencyName, int year, int period, Book book, boolean isError, String yearString, String periodString) throws Exception {
        CalculateProcessInfo calProc = new CalculateProcessInfo();
        String number = this.theme.getNumber();
        String name = this.theme.getName();
        String analyzeName = number + "\uff08" + name + "\uff09";
        StringBuffer yearPeriod = new StringBuffer();
        yearPeriod.append(year).append(yearString).append(period).append(periodString);
        calProc.setAnalyze(this.theme);
        calProc.setAnalyzeName(analyzeName);
        calProc.setOrgUnitId(orgId);
        calProc.setOrgUnitNumber(orgNum);
        calProc.setOrgUnitName(orgName);
        calProc.setCurrencyId(currencyId);
        calProc.setCurrencyNumber(currencyNumber);
        calProc.setCurrencyName(currencyName);
        calProc.setYear(year);
        calProc.setPeriod(period);
        calProc.setYearPeriod(yearPeriod.toString());
        if (isError) {
            calProc.setCalculateProcess(CalculateProcessEnum.CALFAIL);
        } else {
            calProc.setCalculateProcess(CalculateProcessEnum.CALSUCCESS);
        }
        calProc.setData(IOHelper.packBook((Book)book));
        calProc.setCalculator(this.getUserInfo());
        calProc.setCalculateTime(this.getTime());
        CalculateProcessFactory.getLocalInstance(this.ctx).submit(calProc);
    }

    private boolean getFormulaValues(Sheet sheet, List<Map<String, String>> formulaList, Map<String, BigDecimal> values, int valueColumnIndex) throws EASBizException, BOSException {
        int size = 0;
        for (Map<String, String> formulaMap : formulaList) {
            size += formulaMap.size();
        }
        BigDecimal zero = BigDecimal.ZERO;
        boolean isError = false;
        for (int i = 0; i < size; ++i) {
            Variant key = sheet.getCell(i + 1, 0, true).getValue();
            Variant value = sheet.getCell(i + 1, valueColumnIndex, true).getValue();
            if (key == null) continue;
            if (value == null) {
                values.put(key.toString(), zero);
                continue;
            }
            if (value.isError()) {
                values.put(key.toString(), zero);
                isError = true;
                continue;
            }
            if (value != null) {
                if (value.toString().equalsIgnoreCase("false")) {
                    values.put(key.toString(), zero);
                    continue;
                }
                if (value.toString().equalsIgnoreCase("true")) {
                    values.put(key.toString(), zero);
                    continue;
                }
                if (value.toString().equalsIgnoreCase("#DIV/0!")) {
                    values.put(key.toString(), zero);
                    continue;
                }
                if (value.isString()) {
                    values.put(key.toString(), zero);
                    isError = true;
                    continue;
                }
            }
            BigDecimal bgValue = BigDecimal.ZERO;
            try {
                bgValue = value.toBigDecimal();
            }
            catch (SyntaxErrorException e) {
                throw new BOSException((Throwable)e);
            }
            CslRptUtil.checkBigDecimalLength((BigDecimal)bgValue);
            values.put(key.toString(), bgValue);
        }
        return isError;
    }

    private void getFormulaMap(List<DataElementInfo> dataElements, List<Integer> dataTypes, Map<String, String> formulaMap, String indexNum, String indexName, String formula, FullOrgUnitInfo orgUnit, boolean isUnion, CurrencyInfo currency, int year, int period, String treeNumber) throws BOSException {
        String key = null;
        String companyNumber = orgUnit.getNumber();
        String currencyNumber = currency.getNumber();
        if (!dataElements.isEmpty()) {
            for (DataElementInfo dataElement : dataElements) {
                String deNumber = dataElement.getNumber();
                if (!dataTypes.isEmpty()) {
                    for (int dataType : dataTypes) {
                        try {
                            key = this.constructAnalyzeKey(indexNum, indexName, orgUnit, currency, year, period, dataElement, ValueTypeEnum.getEnum((int)dataType).getAlias());
                            Expression stmt = ExcelFormulaPaserHelper.parse((String)formula);
                            Expression filledStmt = this.fillFormulas(stmt, treeNumber, isUnion, companyNumber, year, period, currencyNumber, deNumber, String.valueOf(dataType));
                            String filledFormula = filledStmt.toString();
                            formulaMap.put(key, filledFormula);
                        }
                        catch (Exception e) {
                            logger.error((Object)"getFormulaMap: ", (Throwable)e);
                        }
                    }
                    continue;
                }
                try {
                    key = this.constructAnalyzeKey(indexNum, indexName, orgUnit, currency, year, period, dataElement, null);
                    Expression stmt = ExcelFormulaPaserHelper.parse((String)formula);
                    Expression filledStmt = this.fillFormulas(stmt, treeNumber, isUnion, companyNumber, year, period, currencyNumber, deNumber, null);
                    String filledFormula = filledStmt.toString();
                    formulaMap.put(key, filledFormula);
                }
                catch (Exception e) {
                    logger.error((Object)"getFormulaMap: ", (Throwable)e);
                }
            }
        } else if (!dataTypes.isEmpty()) {
            for (int dataType : dataTypes) {
                try {
                    key = this.constructAnalyzeKey(indexNum, indexName, orgUnit, currency, year, period, null, ValueTypeEnum.getEnum((int)dataType).getAlias());
                    Expression stmt = ExcelFormulaPaserHelper.parse((String)formula);
                    Expression filledStmt = this.fillFormulas(stmt, treeNumber, isUnion, companyNumber, year, period, currencyNumber, null, String.valueOf(dataType));
                    String filledFormula = filledStmt.toString();
                    formulaMap.put(key, filledFormula);
                }
                catch (Exception e) {
                    logger.error((Object)"getFormulaMap: ", (Throwable)e);
                }
            }
        } else {
            try {
                key = this.constructAnalyzeKey(indexNum, indexName, orgUnit, currency, year, period, null, null);
                Expression stmt = ExcelFormulaPaserHelper.parse((String)formula);
                Expression filledStmt = this.fillFormulas(stmt, treeNumber, isUnion, companyNumber, year, period, currencyNumber, null, null);
                String filledFormula = filledStmt.toString();
                formulaMap.put(key, filledFormula);
            }
            catch (Exception e) {
                logger.error((Object)"getFormulaMap: ", (Throwable)e);
            }
        }
    }

    private void fillFormulaToSheet(Sheet sheet, List<Map<String, String>> formulaList) {
        int index = 1;
        for (Map<String, String> formulaMap : formulaList) {
            for (String key : formulaMap.keySet()) {
                String[] keys = key.split(SPLITSTR);
                String formula = formulaMap.get(key);
                sheet.getCell(index, 0, true).setValue(new Variant((Object)key));
                sheet.getCell(index, 1, true).setValue(new Variant((Object)keys[7]));
                sheet.getCell(index, 2, true).setValue(new Variant((Object)keys[8]));
                if (keys.length > 10) {
                    sheet.getCell(index, 3, true).setValue(new Variant((Object)keys[10]));
                }
                sheet.getCell(index, 4, true).setFormula("=" + formula);
                ++index;
            }
        }
    }

    private Expression fillFormulas(Expression stmt, String treeNumber, boolean isUnion, String companyNumber, int year, int period, String currencyNumber, String deNumber, String dataType) throws BOSException {
        if (stmt instanceof FunctionExpr) {
            String funName = ((FunctionExpr)stmt).funcionName;
            if (funName.equalsIgnoreCase("AcctItem")) {
                stmt = this.fillAcctItem((FunctionExpr)stmt, treeNumber, isUnion, companyNumber, year, period, currencyNumber, deNumber, dataType);
            } else if (funName.equalsIgnoreCase("AdjustData")) {
                stmt = this.fillAdjustData((FunctionExpr)stmt, treeNumber, isUnion, companyNumber, year, period, currencyNumber, deNumber, dataType);
            } else if (funName.equalsIgnoreCase("DyItem")) {
                stmt = this.fillDyItem((FunctionExpr)stmt, treeNumber, isUnion, companyNumber, year, period, currencyNumber, deNumber, dataType);
            } else if (funName.equalsIgnoreCase("ElimData")) {
                stmt = this.fillElimData((FunctionExpr)stmt, treeNumber, isUnion, companyNumber, year, period, currencyNumber, deNumber, dataType);
            } else if (funName.equalsIgnoreCase("ElimRpt")) {
                stmt = this.fillElimRpt((FunctionExpr)stmt, treeNumber, isUnion, companyNumber, year, period, currencyNumber, deNumber, dataType);
            } else if (funName.equalsIgnoreCase("CsRef")) {
                stmt = this.fillCsRef((FunctionExpr)stmt, treeNumber, isUnion, companyNumber, year, period, currencyNumber, deNumber, dataType);
            } else if (funName.equalsIgnoreCase("Esp")) {
                stmt = this.fillEsp((FunctionExpr)stmt, treeNumber, isUnion, companyNumber, year, period, currencyNumber, deNumber, dataType);
            } else if (funName.equalsIgnoreCase("Ref")) {
                stmt = this.fillRef((FunctionExpr)stmt, isUnion, companyNumber, year, period, currencyNumber, deNumber, dataType);
            } else if (funName.equalsIgnoreCase("Acct")) {
                stmt = this.fillAcct((FunctionExpr)stmt, isUnion, companyNumber, year, period, currencyNumber, deNumber, dataType);
            } else if (funName.equalsIgnoreCase("AcctAc")) {
                stmt = this.fillAcctAc((FunctionExpr)stmt, isUnion, companyNumber, year, period, currencyNumber, deNumber, dataType);
            } else if (funName.equalsIgnoreCase("AcctExt")) {
                stmt = this.fillAcctExt((FunctionExpr)stmt, isUnion, companyNumber, year, period, currencyNumber, deNumber, dataType);
            } else if (funName.equalsIgnoreCase("AcctCash")) {
                stmt = this.fillAcctCash((FunctionExpr)stmt, isUnion, companyNumber, year, period, currencyNumber, deNumber, dataType);
            } else if (funName.equalsIgnoreCase("AcctCashExt")) {
                stmt = this.fillAcctCashExt((FunctionExpr)stmt, isUnion, companyNumber, year, period, currencyNumber, deNumber, dataType);
            } else if (funName.equalsIgnoreCase("InCashFlow")) {
                stmt = this.fillInCashFlow((FunctionExpr)stmt, isUnion, companyNumber, year, period, currencyNumber, deNumber, dataType);
            } else if (funName.equalsIgnoreCase("Age")) {
                stmt = this.fillAge((FunctionExpr)stmt, isUnion, companyNumber, year, period, currencyNumber, deNumber, dataType);
            } else if (funName.equalsIgnoreCase("RefM")) {
                stmt = this.fillRefM((FunctionExpr)stmt, isUnion, companyNumber, year, period, currencyNumber, deNumber, dataType);
            } else if (funName.equalsIgnoreCase("IF") || funName.equalsIgnoreCase("Round")) {
                try {
                    String formula = stmt.toString();
                    String result = stmt.toString();
                    int index = 0;
                    result = this.getFormula("ACCTITEM", formula, result, treeNumber, isUnion, companyNumber, year, period, currencyNumber, deNumber, dataType, index);
                    result = this.getFormula("ADJUSTDATA", formula, result, treeNumber, isUnion, companyNumber, year, period, currencyNumber, deNumber, dataType, index);
                    result = this.getFormula("DYITEM", formula, result, treeNumber, isUnion, companyNumber, year, period, currencyNumber, deNumber, dataType, index);
                    result = this.getFormula("ELIMDATA", formula, result, treeNumber, isUnion, companyNumber, year, period, currencyNumber, deNumber, dataType, index);
                    result = this.getFormula("ELIMRPT", formula, result, treeNumber, isUnion, companyNumber, year, period, currencyNumber, deNumber, dataType, index);
                    result = this.getFormula("CSREF", formula, result, treeNumber, isUnion, companyNumber, year, period, currencyNumber, deNumber, dataType, index);
                    result = this.getFormula("ESP", formula, result, treeNumber, isUnion, companyNumber, year, period, currencyNumber, deNumber, dataType, index);
                    result = this.getFormula("REF", formula, result, treeNumber, isUnion, companyNumber, year, period, currencyNumber, deNumber, dataType, index);
                    result = this.getFormula("ACCT", formula, result, treeNumber, isUnion, companyNumber, year, period, currencyNumber, deNumber, dataType, index);
                    result = this.getFormula("ACCTAC", formula, result, treeNumber, isUnion, companyNumber, year, period, currencyNumber, deNumber, dataType, index);
                    result = this.getFormula("ACCTEXT", formula, result, treeNumber, isUnion, companyNumber, year, period, currencyNumber, deNumber, dataType, index);
                    result = this.getFormula("ACCTCASH", formula, result, treeNumber, isUnion, companyNumber, year, period, currencyNumber, deNumber, dataType, index);
                    result = this.getFormula("ACCTCASHEXT", formula, result, treeNumber, isUnion, companyNumber, year, period, currencyNumber, deNumber, dataType, index);
                    result = this.getFormula("INCASHFLOW", formula, result, treeNumber, isUnion, companyNumber, year, period, currencyNumber, deNumber, dataType, index);
                    result = this.getFormula("AGE", formula, result, treeNumber, isUnion, companyNumber, year, period, currencyNumber, deNumber, dataType, index);
                    result = this.getFormula("REFM", formula, result, treeNumber, isUnion, companyNumber, year, period, currencyNumber, deNumber, dataType, index);
                    stmt = ExcelFormulaPaserHelper.parse((String)result);
                }
                catch (Exception exception) {}
            }
        } else if (stmt instanceof BinaryOperationExpr) {
            Expression expr = this.fillFormulas(((BinaryOperationExpr)stmt).left, treeNumber, isUnion, companyNumber, year, period, currencyNumber, deNumber, dataType);
            if (expr == null) {
                return null;
            }
            ((BinaryOperationExpr)stmt).left = expr;
            expr = this.fillFormulas(((BinaryOperationExpr)stmt).right, treeNumber, isUnion, companyNumber, year, period, currencyNumber, deNumber, dataType);
            if (expr == null) {
                return null;
            }
            ((BinaryOperationExpr)stmt).right = expr;
        } else if (stmt instanceof UnaryOperationExpr) {
            Expression expr = this.fillFormulas(((UnaryOperationExpr)stmt).operand, treeNumber, isUnion, companyNumber, year, period, currencyNumber, deNumber, dataType);
            if (expr == null) {
                return null;
            }
            ((UnaryOperationExpr)stmt).operand = expr;
        }
        return stmt;
    }

    private String getFormula(String funName, String formula, String result, String treeNumber, boolean isUnion, String companyNumber, int year, int period, String currencyNumber, String deNumber, String dataType, int index) throws Exception {
        if (formula.indexOf(funName, 0) > 0) {
            int beginIndex = result.indexOf(funName, index);
            int endIndex = result.indexOf(")", beginIndex);
            String acctitem = result.substring(beginIndex, endIndex + 1);
            String search = result.substring(endIndex + 1, result.length());
            Expression expr = ExcelFormulaPaserHelper.parse((String)acctitem);
            expr = this.fillFormulas((Expression)((FunctionExpr)expr), treeNumber, isUnion, companyNumber, year, period, currencyNumber, deNumber, dataType);
            result = result.substring(0, beginIndex) + expr.toString() + result.substring(endIndex + 1);
            int beginIndex1 = result.indexOf(funName, index);
            int endIndex1 = result.indexOf(")", beginIndex1);
            result = this.getFormula(funName, search, result, treeNumber, isUnion, companyNumber, year, period, currencyNumber, deNumber, dataType, endIndex1);
        }
        return result;
    }

    private FunctionExpr fillAcctItem(FunctionExpr expr, String treeNumber, boolean isUnion, String companyNumber, int year, int period, String currencyNumber, String deNumber, String dataType) throws BOSException {
        StringExpr se;
        ArrayList para = new ArrayList();
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(0))) {
            para.add(expr.parameters.get(0));
        } else {
            OrgTreeInfo orgTree = this.theme.getOrgTree();
            if (orgTree != null) {
                treeNumber = orgTree.getNumber();
                se = new StringExpr(treeNumber);
                para.add(se);
            } else {
                para.add(new StringExpr(treeNumber));
            }
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(1))) {
            para.add(expr.parameters.get(1));
        } else {
            se = new StringExpr(companyNumber);
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(2))) {
            para.add(expr.parameters.get(2));
        } else {
            se = new StringExpr(currencyNumber);
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(3))) {
            para.add(expr.parameters.get(3));
        } else {
            se = new StringExpr(currencyNumber);
            para.add(se);
        }
        para.add(expr.parameters.get(4));
        para.add(expr.parameters.get(5));
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(6))) {
            para.add(expr.parameters.get(6));
        } else {
            se = new StringExpr(this.theme.getPeriodType().getName());
            para.add(se);
        }
        int[] yearPeriod = this.getYearPeriod(expr, year, period, 6, 7, 8, 9);
        if (Integer.valueOf(String.valueOf(expr.parameters.get(7))) > 0) {
            para.add(expr.parameters.get(7));
        } else {
            se = new StringExpr(String.valueOf(yearPeriod[0]));
            para.add(se);
        }
        if (Integer.valueOf(String.valueOf(expr.parameters.get(8))) > 0) {
            para.add(expr.parameters.get(8));
        } else {
            se = new StringExpr(String.valueOf(yearPeriod[1]));
            para.add(se);
        }
        if (Integer.valueOf(String.valueOf(expr.parameters.get(9))) > 0) {
            para.add(expr.parameters.get(9));
        } else {
            se = new StringExpr(String.valueOf(yearPeriod[2]));
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(10))) {
            para.add(expr.parameters.get(10));
        } else if (isUnion) {
            if (this.theme.isIsCombine()) {
                se = new StringExpr(RptSrcTypeEnum.CONSOLIDATION.getName());
                para.add(se);
            } else if (this.theme.isIsSum()) {
                se = new StringExpr(RptSrcTypeEnum.SUM.getName());
                para.add(se);
            }
        } else {
            se = new StringExpr(RptSrcTypeEnum.COMMITREPORT.getName());
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(11))) {
            para.add(expr.parameters.get(11));
        } else if (deNumber != null) {
            se = new StringExpr(deNumber);
            para.add(se);
        } else {
            para.add(expr.parameters.get(11));
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(12))) {
            para.add(expr.parameters.get(12));
        } else if (dataType != null) {
            se = new StringExpr(ValueTypeEnum.getEnum((int)Integer.valueOf(dataType)).getName());
            para.add(se);
        } else {
            para.add(expr.parameters.get(12));
        }
        para.add(expr.parameters.get(13));
        if (expr.parameters.size() > 14) {
            if (FormulaUtil.hasDispenseParameter(expr.parameters.get(14))) {
                para.add(expr.parameters.get(14));
            } else if (this.theme.isIsWeave() || this.theme.isIsAudit() || this.theme.isIsCommit()) {
                se = new StringExpr("true");
                para.add(se);
            } else {
                se = new StringExpr("false");
                para.add(se);
            }
        }
        if (expr.parameters.size() > 15) {
            para.add(expr.parameters.get(15));
        }
        if (expr.parameters.size() > 16) {
            para.add(expr.parameters.get(16));
        }
        expr.parameters = para;
        return expr;
    }

    private FunctionExpr fillAdjustData(FunctionExpr expr, String treeNumber, boolean isUnion, String companyNumber, int year, int period, String currencyNumber, String deNumber, String dataType) {
        StringExpr se;
        ArrayList para = new ArrayList();
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(0))) {
            para.add(expr.parameters.get(0));
        } else {
            OrgTreeInfo orgTree = this.theme.getOrgTree();
            if (orgTree != null) {
                treeNumber = orgTree.getNumber();
                se = new StringExpr(treeNumber);
                para.add(se);
            } else {
                para.add(new StringExpr(treeNumber));
            }
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(1))) {
            para.add(expr.parameters.get(1));
        } else {
            se = new StringExpr(companyNumber);
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(2))) {
            para.add(expr.parameters.get(2));
        } else {
            se = new StringExpr(currencyNumber);
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(3))) {
            para.add(expr.parameters.get(3));
        } else {
            se = new StringExpr(currencyNumber);
            para.add(se);
        }
        para.add(expr.parameters.get(4));
        para.add(expr.parameters.get(5));
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(6))) {
            para.add(expr.parameters.get(6));
        } else {
            se = new StringExpr(this.theme.getPeriodType().getName());
            para.add(se);
        }
        int[] yearPeriod = this.getYearPeriod(expr, year, period, 6, 7, 8, 9);
        if (Integer.valueOf(String.valueOf(expr.parameters.get(7))) > 0) {
            para.add(expr.parameters.get(7));
        } else {
            se = new StringExpr(String.valueOf(yearPeriod[0]));
            para.add(se);
        }
        if (Integer.valueOf(String.valueOf(expr.parameters.get(8))) > 0) {
            para.add(expr.parameters.get(8));
        } else {
            se = new StringExpr(String.valueOf(yearPeriod[1]));
            para.add(se);
        }
        if (Integer.valueOf(String.valueOf(expr.parameters.get(9))) > 0) {
            para.add(expr.parameters.get(9));
        } else {
            se = new StringExpr(String.valueOf(yearPeriod[2]));
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(10))) {
            para.add(expr.parameters.get(10));
        } else if (isUnion) {
            if (this.theme.isIsCombine()) {
                se = new StringExpr(RptSrcTypeEnum.CONSOLIDATION.getName());
                para.add(se);
            } else if (this.theme.isIsSum()) {
                se = new StringExpr(RptSrcTypeEnum.SUM.getName());
                para.add(se);
            }
        } else {
            se = new StringExpr(RptSrcTypeEnum.COMMITREPORT.getName());
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(11))) {
            para.add(expr.parameters.get(11));
        } else if (deNumber != null) {
            se = new StringExpr(deNumber);
            para.add(se);
        } else {
            para.add(expr.parameters.get(11));
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(12))) {
            para.add(expr.parameters.get(12));
        } else if (dataType != null) {
            se = new StringExpr(ValueTypeEnum.getEnum((int)Integer.valueOf(dataType)).getName());
            para.add(se);
        } else {
            para.add(expr.parameters.get(12));
        }
        para.add(expr.parameters.get(13));
        para.add(expr.parameters.get(14));
        if (expr.parameters.size() > 15) {
            para.add(expr.parameters.get(15));
        }
        expr.parameters = para;
        return expr;
    }

    private FunctionExpr fillDyItem(FunctionExpr expr, String treeNumber, boolean isUnion, String companyNumber, int year, int period, String currencyNumber, String deNumber, String dataType) throws BOSException {
        StringExpr se;
        ArrayList para = new ArrayList();
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(0))) {
            para.add(expr.parameters.get(0));
        } else {
            OrgTreeInfo orgTree = this.theme.getOrgTree();
            if (orgTree != null) {
                treeNumber = orgTree.getNumber();
                se = new StringExpr(treeNumber);
                para.add(se);
            } else {
                para.add(new StringExpr(treeNumber));
            }
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(1))) {
            para.add(expr.parameters.get(1));
        } else {
            se = new StringExpr(companyNumber);
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(2))) {
            para.add(expr.parameters.get(2));
        } else {
            se = new StringExpr(currencyNumber);
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(3))) {
            para.add(expr.parameters.get(3));
        } else {
            se = new StringExpr(currencyNumber);
            para.add(se);
        }
        para.add(expr.parameters.get(4));
        para.add(expr.parameters.get(5));
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(6))) {
            para.add(expr.parameters.get(6));
        } else {
            se = new StringExpr(this.theme.getPeriodType().getName());
            para.add(se);
        }
        int[] yearPeriod = this.getYearPeriod(expr, year, period, 6, 7, 8, 9);
        if (Integer.valueOf(String.valueOf(expr.parameters.get(7))) > 0) {
            para.add(expr.parameters.get(7));
        } else {
            se = new StringExpr(String.valueOf(yearPeriod[0]));
            para.add(se);
        }
        if (Integer.valueOf(String.valueOf(expr.parameters.get(8))) > 0) {
            para.add(expr.parameters.get(8));
        } else {
            se = new StringExpr(String.valueOf(yearPeriod[1]));
            para.add(se);
        }
        if (Integer.valueOf(String.valueOf(expr.parameters.get(9))) > 0) {
            para.add(expr.parameters.get(9));
        } else {
            se = new StringExpr(String.valueOf(yearPeriod[2]));
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(10))) {
            para.add(expr.parameters.get(10));
        } else if (isUnion) {
            if (this.theme.isIsCombine()) {
                se = new StringExpr(RptSrcTypeEnum.DYNAMICCSLREPORT.getName());
                para.add(se);
            } else if (this.theme.isIsSum()) {
                se = new StringExpr(RptSrcTypeEnum.DYNAMICSUMREPORT.getName());
                para.add(se);
            }
        } else {
            se = new StringExpr(RptSrcTypeEnum.DYNAMICNORMALREPORT.getName());
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(11))) {
            para.add(expr.parameters.get(11));
        } else if (deNumber != null) {
            se = new StringExpr(deNumber);
            para.add(se);
        } else {
            para.add(expr.parameters.get(11));
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(12))) {
            para.add(expr.parameters.get(12));
        } else if (dataType != null) {
            se = new StringExpr(ValueTypeEnum.getEnum((int)Integer.valueOf(dataType)).getName());
            para.add(se);
        } else {
            para.add(expr.parameters.get(12));
        }
        para.add(expr.parameters.get(13));
        if (expr.parameters.size() > 14) {
            para.add(expr.parameters.get(14));
        }
        if (expr.parameters.size() > 15) {
            para.add(expr.parameters.get(15));
        }
        if (expr.parameters.size() > 16) {
            para.add(expr.parameters.get(16));
        }
        if (expr.parameters.size() > 17) {
            if (FormulaUtil.hasDispenseParameter(expr.parameters.get(17))) {
                para.add(expr.parameters.get(17));
            } else if (this.theme.isIsWeave() || this.theme.isIsAudit() || this.theme.isIsCommit()) {
                se = new StringExpr("true");
                para.add(se);
            } else {
                se = new StringExpr("false");
                para.add(se);
            }
        }
        if (expr.parameters.size() > 18) {
            para.add(expr.parameters.get(18));
        }
        expr.parameters = para;
        return expr;
    }

    private FunctionExpr fillElimData(FunctionExpr expr, String treeNumber, boolean isUnion, String companyNumber, int year, int period, String currencyNumber, String deNumber, String dataType) {
        StringExpr se;
        ArrayList para = new ArrayList();
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(0))) {
            para.add(expr.parameters.get(0));
        } else {
            OrgTreeInfo orgTree = this.theme.getOrgTree();
            if (orgTree != null) {
                treeNumber = orgTree.getNumber();
                se = new StringExpr(treeNumber);
                para.add(se);
            } else {
                para.add(new StringExpr(treeNumber));
            }
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(1))) {
            para.add(expr.parameters.get(1));
        } else if (isUnion) {
            se = new StringExpr(companyNumber);
            para.add(se);
        } else {
            para.add(new StringExpr(""));
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(2))) {
            para.add(expr.parameters.get(2));
        } else if (isUnion) {
            para.add(new StringExpr(""));
        } else {
            se = new StringExpr(companyNumber);
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(3))) {
            para.add(expr.parameters.get(3));
        } else {
            se = new StringExpr(currencyNumber);
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(4))) {
            para.add(expr.parameters.get(4));
        } else {
            se = new StringExpr(currencyNumber);
            para.add(se);
        }
        para.add(expr.parameters.get(5));
        para.add(expr.parameters.get(6));
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(7))) {
            para.add(expr.parameters.get(7));
        } else {
            se = new StringExpr(this.theme.getPeriodType().getName());
            para.add(se);
        }
        int[] yearPeriod = this.getYearPeriod(expr, year, period, 7, 8, 9, 10);
        if (Integer.valueOf(String.valueOf(expr.parameters.get(8))) > 0) {
            para.add(expr.parameters.get(8));
        } else {
            se = new StringExpr(String.valueOf(yearPeriod[0]));
            para.add(se);
        }
        if (Integer.valueOf(String.valueOf(expr.parameters.get(9))) > 0) {
            para.add(expr.parameters.get(9));
        } else {
            se = new StringExpr(String.valueOf(yearPeriod[1]));
            para.add(se);
        }
        if (Integer.valueOf(String.valueOf(expr.parameters.get(10))) > 0) {
            para.add(expr.parameters.get(10));
        } else {
            se = new StringExpr(String.valueOf(yearPeriod[2]));
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(11))) {
            para.add(expr.parameters.get(11));
        } else if (deNumber != null) {
            se = new StringExpr(deNumber);
            para.add(se);
        } else {
            para.add(expr.parameters.get(11));
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(12))) {
            para.add(expr.parameters.get(12));
        } else if (dataType != null) {
            se = new StringExpr(ValueTypeEnum.getEnum((int)Integer.valueOf(dataType)).getName());
            para.add(se);
        } else {
            para.add(expr.parameters.get(12));
        }
        para.add(expr.parameters.get(13));
        para.add(expr.parameters.get(14));
        para.add(expr.parameters.get(15));
        if (expr.parameters.size() > 16) {
            para.add(expr.parameters.get(16));
        }
        expr.parameters = para;
        return expr;
    }

    private FunctionExpr fillElimRpt(FunctionExpr expr, String treeNumber, boolean isUnion, String companyNumber, int year, int period, String currencyNumber, String deNumber, String dataType) {
        StringExpr se;
        ArrayList para = new ArrayList();
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(0))) {
            para.add(expr.parameters.get(0));
        } else {
            OrgTreeInfo orgTree = this.theme.getOrgTree();
            if (orgTree != null) {
                treeNumber = orgTree.getNumber();
                se = new StringExpr(treeNumber);
                para.add(se);
            } else {
                para.add(new StringExpr(treeNumber));
            }
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(1))) {
            para.add(expr.parameters.get(1));
        } else {
            se = new StringExpr(companyNumber);
            para.add(se);
        }
        para.add(expr.parameters.get(2));
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(3))) {
            para.add(expr.parameters.get(3));
        } else {
            se = new StringExpr(currencyNumber);
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(4))) {
            para.add(expr.parameters.get(4));
        } else {
            se = new StringExpr(currencyNumber);
            para.add(se);
        }
        para.add(expr.parameters.get(5));
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(6))) {
            para.add(expr.parameters.get(6));
        } else if (deNumber != null) {
            se = new StringExpr(deNumber);
            para.add(se);
        } else {
            para.add(expr.parameters.get(6));
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(7))) {
            para.add(expr.parameters.get(7));
        } else {
            se = new StringExpr(this.theme.getPeriodType().getName());
            para.add(se);
        }
        int[] yearPeriod = this.getYearPeriod(expr, year, period, 7, 8, 9, 10);
        if (Integer.valueOf(String.valueOf(expr.parameters.get(8))) > 0) {
            para.add(expr.parameters.get(8));
        } else {
            se = new StringExpr(String.valueOf(yearPeriod[0]));
            para.add(se);
        }
        if (Integer.valueOf(String.valueOf(expr.parameters.get(9))) > 0) {
            para.add(expr.parameters.get(9));
        } else {
            se = new StringExpr(String.valueOf(yearPeriod[1]));
            para.add(se);
        }
        if (Integer.valueOf(String.valueOf(expr.parameters.get(10))) > 0) {
            para.add(expr.parameters.get(10));
        } else {
            se = new StringExpr(String.valueOf(yearPeriod[2]));
            para.add(se);
        }
        if (expr.parameters.size() > 11) {
            para.add(expr.parameters.get(11));
        }
        expr.parameters = para;
        return expr;
    }

    private FunctionExpr fillCsRef(FunctionExpr expr, String treeNumber, boolean isUnion, String companyNumber, int year, int period, String currencyNumber, String deNumber, String dataType) {
        StringExpr se;
        ArrayList para = new ArrayList();
        if (expr.parameters.size() >= 11) {
            if (FormulaUtil.hasDispenseParameter(expr.parameters.get(0))) {
                para.add(expr.parameters.get(0));
            } else {
                OrgTreeInfo orgTree = this.theme.getOrgTree();
                if (orgTree != null) {
                    treeNumber = orgTree.getNumber();
                    se = new StringExpr(treeNumber);
                    para.add(se);
                } else {
                    para.add(new StringExpr(treeNumber));
                }
            }
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(1))) {
            para.add(expr.parameters.get(1));
        } else {
            se = new StringExpr(companyNumber);
            para.add(se);
        }
        para.add(expr.parameters.get(2));
        para.add(expr.parameters.get(3));
        int[] yearPeriod = this.getStartYearPeriod(expr, year, period, -1, 4, 5);
        if (Integer.valueOf(String.valueOf(expr.parameters.get(4))) > 0) {
            para.add(expr.parameters.get(4));
        } else {
            se = new StringExpr(String.valueOf(yearPeriod[0]));
            para.add(se);
        }
        if (Integer.valueOf(String.valueOf(expr.parameters.get(5))) > 0) {
            para.add(expr.parameters.get(5));
        } else {
            se = new StringExpr(String.valueOf(yearPeriod[1]));
            para.add(se);
        }
        para.add(expr.parameters.get(6));
        para.add(expr.parameters.get(7));
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(8))) {
            para.add(expr.parameters.get(8));
        } else {
            se = new StringExpr(currencyNumber);
            para.add(se);
        }
        if (expr.parameters.size() >= 10) {
            if (FormulaUtil.hasDispenseParameter(expr.parameters.get(9))) {
                para.add(expr.parameters.get(9));
            } else {
                se = new StringExpr(currencyNumber);
                para.add(se);
            }
            para.add(expr.parameters.get(10));
        }
        if (expr.parameters.size() >= 11) {
            para.add(expr.parameters.get(11));
        }
        if (expr.parameters.size() >= 13) {
            para.add(expr.parameters.get(12));
        }
        expr.parameters = para;
        return expr;
    }

    private FunctionExpr fillEsp(FunctionExpr expr, String treeNumber, boolean isUnion, String companyNumber, int year, int period, String currencyNumber, String deNumber, String dataType) {
        StringExpr se;
        ArrayList para = new ArrayList();
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(0))) {
            para.add(expr.parameters.get(0));
        } else {
            OrgTreeInfo orgTree = this.theme.getOrgTree();
            if (orgTree != null) {
                treeNumber = orgTree.getNumber();
                se = new StringExpr(treeNumber);
                para.add(se);
            } else {
                para.add(new StringExpr(treeNumber));
            }
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(1))) {
            para.add(expr.parameters.get(1));
        } else {
            se = new StringExpr(companyNumber);
            para.add(se);
        }
        para.add(expr.parameters.get(2));
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(3))) {
            para.add(expr.parameters.get(3));
        } else {
            se = new StringExpr(this.theme.getPeriodType().getName());
            para.add(se);
        }
        int[] yearPeriod = this.getStartYearPeriod(expr, year, period, 3, 4, 5);
        if (Integer.valueOf(String.valueOf(expr.parameters.get(4))) > 0) {
            para.add(expr.parameters.get(4));
        } else {
            se = new StringExpr(String.valueOf(yearPeriod[0]));
            para.add(se);
        }
        if (Integer.valueOf(String.valueOf(expr.parameters.get(5))) > 0) {
            para.add(expr.parameters.get(5));
        } else {
            se = new StringExpr(String.valueOf(yearPeriod[1]));
            para.add(se);
        }
        para.add(expr.parameters.get(6));
        expr.parameters = para;
        return expr;
    }

    private FunctionExpr fillRef(FunctionExpr expr, boolean isUnion, String companyNumber, int year, int period, String currencyNumber, String deNumber, String dataType) {
        ArrayList para = new ArrayList();
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(0))) {
            para.add(expr.parameters.get(0));
        } else {
            StringExpr se = new StringExpr(companyNumber);
            para.add(se);
        }
        para.add(expr.parameters.get(1));
        para.add(expr.parameters.get(2));
        para.add(expr.parameters.get(3));
        expr.parameters = para;
        return expr;
    }

    private FunctionExpr fillAcct(FunctionExpr expr, boolean isUnion, String companyNumber, int year, int period, String currencyNumber, String deNumber, String dataType) {
        StringExpr se;
        ArrayList para = new ArrayList();
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(0))) {
            para.add(expr.parameters.get(0));
        } else {
            se = new StringExpr(companyNumber);
            para.add(se);
        }
        para.add(expr.parameters.get(1));
        para.add(expr.parameters.get(2));
        int[] yearPeriod = this.getAccYearPeriod(expr, year, period, 3, 4, 5, 6);
        if (Integer.valueOf(String.valueOf(expr.parameters.get(3))) > 0) {
            para.add(expr.parameters.get(3));
        } else {
            se = new StringExpr(String.valueOf(yearPeriod[0]));
            para.add(se);
        }
        if (Integer.valueOf(String.valueOf(expr.parameters.get(4))) > 0) {
            para.add(expr.parameters.get(4));
        } else {
            se = new StringExpr(String.valueOf(yearPeriod[1]));
            para.add(se);
        }
        if (Integer.valueOf(String.valueOf(expr.parameters.get(5))) > 0) {
            para.add(expr.parameters.get(5));
        } else {
            se = new StringExpr(String.valueOf(yearPeriod[2]));
            para.add(se);
        }
        if (Integer.valueOf(String.valueOf(expr.parameters.get(6))) > 0) {
            para.add(expr.parameters.get(6));
        } else {
            se = new StringExpr(String.valueOf(yearPeriod[3]));
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(7))) {
            para.add(expr.parameters.get(7));
        } else {
            se = new StringExpr(currencyNumber);
            para.add(se);
        }
        para.add(expr.parameters.get(8));
        expr.parameters = para;
        return expr;
    }

    private FunctionExpr fillAcctAc(FunctionExpr expr, boolean isUnion, String companyNumber, int year, int period, String currencyNumber, String deNumber, String dataType) {
        StringExpr se;
        ArrayList para = new ArrayList();
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(0))) {
            para.add(expr.parameters.get(0));
        } else {
            se = new StringExpr(companyNumber);
            para.add(se);
        }
        para.add(expr.parameters.get(1));
        para.add(expr.parameters.get(2));
        para.add(expr.parameters.get(3));
        int[] yearPeriod = this.getAccYearPeriod(expr, year, period, 4, 5, 6, 7);
        if (Integer.valueOf(String.valueOf(expr.parameters.get(4))) > 0) {
            para.add(expr.parameters.get(4));
        } else {
            se = new StringExpr(String.valueOf(yearPeriod[0]));
            para.add(se);
        }
        if (Integer.valueOf(String.valueOf(expr.parameters.get(5))) > 0) {
            para.add(expr.parameters.get(5));
        } else {
            se = new StringExpr(String.valueOf(yearPeriod[1]));
            para.add(se);
        }
        if (Integer.valueOf(String.valueOf(expr.parameters.get(6))) > 0) {
            para.add(expr.parameters.get(6));
        } else {
            se = new StringExpr(String.valueOf(yearPeriod[2]));
            para.add(se);
        }
        if (Integer.valueOf(String.valueOf(expr.parameters.get(7))) > 0) {
            para.add(expr.parameters.get(7));
        } else {
            se = new StringExpr(String.valueOf(yearPeriod[3]));
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(8))) {
            para.add(expr.parameters.get(8));
        } else {
            se = new StringExpr(currencyNumber);
            para.add(se);
        }
        expr.parameters = para;
        return expr;
    }

    private FunctionExpr fillAcctExt(FunctionExpr expr, boolean isUnion, String companyNumber, int year, int period, String currencyNumber, String deNumber, String dataType) {
        StringExpr se;
        ArrayList para = new ArrayList();
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(0))) {
            para.add(expr.parameters.get(0));
        } else {
            se = new StringExpr(companyNumber);
            para.add(se);
        }
        para.add(expr.parameters.get(1));
        para.add(expr.parameters.get(2));
        para.add(expr.parameters.get(3));
        para.add(expr.parameters.get(4));
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(5))) {
            para.add(expr.parameters.get(5));
        } else {
            se = new StringExpr(currencyNumber);
            para.add(se);
        }
        Date endDate = RPTDateUtil.getPeriodLastDate((int)year, (int)period, (RptPeriodTypeEnum)this.theme.getPeriodType());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(6))) {
            para.add(expr.parameters.get(6));
        } else {
            se = new StringExpr(dateFormat.format(endDate));
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(7))) {
            para.add(expr.parameters.get(7));
        } else {
            se = new StringExpr(dateFormat.format(endDate));
            para.add(se);
        }
        para.add(expr.parameters.get(8));
        expr.parameters = para;
        return expr;
    }

    private FunctionExpr fillAcctCash(FunctionExpr expr, boolean isUnion, String companyNumber, int year, int period, String currencyNumber, String deNumber, String dataType) {
        StringExpr se;
        ArrayList para = new ArrayList();
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(0))) {
            para.add(expr.parameters.get(0));
        } else {
            se = new StringExpr(companyNumber);
            para.add(se);
        }
        para.add(expr.parameters.get(1));
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(2))) {
            para.add(expr.parameters.get(2));
        } else {
            se = new StringExpr(currencyNumber);
            para.add(se);
        }
        int[] yearPeriod = this.getYearPeriod(expr, year, period, -1, 3, 4, 5);
        if (Integer.valueOf(String.valueOf(expr.parameters.get(3))) > 0) {
            para.add(expr.parameters.get(3));
        } else {
            se = new StringExpr(String.valueOf(yearPeriod[0]));
            para.add(se);
        }
        if (Integer.valueOf(String.valueOf(expr.parameters.get(4))) > 0) {
            para.add(expr.parameters.get(4));
        } else {
            se = new StringExpr(String.valueOf(yearPeriod[1]));
            para.add(se);
        }
        if (Integer.valueOf(String.valueOf(expr.parameters.get(5))) > 0) {
            para.add(expr.parameters.get(5));
        } else {
            se = new StringExpr(String.valueOf(yearPeriod[2]));
            para.add(se);
        }
        para.add(expr.parameters.get(6));
        para.add(expr.parameters.get(7));
        expr.parameters = para;
        return expr;
    }

    private FunctionExpr fillAcctCashExt(FunctionExpr expr, boolean isUnion, String companyNumber, int year, int period, String currencyNumber, String deNumber, String dataType) {
        StringExpr se;
        ArrayList para = new ArrayList();
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(0))) {
            para.add(expr.parameters.get(0));
        } else {
            se = new StringExpr(companyNumber);
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(1))) {
            para.add(expr.parameters.get(1));
        } else {
            se = new StringExpr(currencyNumber);
            para.add(se);
        }
        Date endDate = RPTDateUtil.getPeriodLastDate((int)year, (int)period, (RptPeriodTypeEnum)this.theme.getPeriodType());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(2))) {
            para.add(expr.parameters.get(2));
        } else {
            se = new StringExpr(dateFormat.format(endDate));
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(3))) {
            para.add(expr.parameters.get(3));
        } else {
            se = new StringExpr(dateFormat.format(endDate));
            para.add(se);
        }
        para.add(expr.parameters.get(4));
        expr.parameters = para;
        return expr;
    }

    private FunctionExpr fillInCashFlow(FunctionExpr expr, boolean isUnion, String companyNumber, int year, int period, String currencyNumber, String deNumber, String dataType) {
        StringExpr se;
        ArrayList para = new ArrayList();
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(0))) {
            para.add(expr.parameters.get(0));
        } else {
            se = new StringExpr(companyNumber);
            para.add(se);
        }
        para.add(expr.parameters.get(1));
        para.add(expr.parameters.get(2));
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(3))) {
            para.add(expr.parameters.get(3));
        } else {
            se = new StringExpr(currencyNumber);
            para.add(se);
        }
        int[] yearPeriod = this.getYearPeriod(expr, year, period, -1, 4, 5, 6);
        if (Integer.valueOf(String.valueOf(expr.parameters.get(4))) > 0) {
            para.add(expr.parameters.get(4));
        } else {
            se = new StringExpr(String.valueOf(yearPeriod[0]));
            para.add(se);
        }
        if (Integer.valueOf(String.valueOf(expr.parameters.get(5))) > 0) {
            para.add(expr.parameters.get(5));
        } else {
            se = new StringExpr(String.valueOf(yearPeriod[1]));
            para.add(se);
        }
        if (Integer.valueOf(String.valueOf(expr.parameters.get(6))) > 0) {
            para.add(expr.parameters.get(6));
        } else {
            se = new StringExpr(String.valueOf(yearPeriod[2]));
            para.add(se);
        }
        para.add(expr.parameters.get(7));
        expr.parameters = para;
        return expr;
    }

    private FunctionExpr fillAge(FunctionExpr expr, boolean isUnion, String companyNumber, int year, int period, String currencyNumber, String deNumber, String dataType) {
        String endDateString;
        Date date;
        RptPeriodTypeEnum periodType;
        StringExpr se;
        ArrayList para = new ArrayList();
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(0))) {
            para.add(expr.parameters.get(0));
        } else {
            se = new StringExpr(companyNumber);
            para.add(se);
        }
        para.add(expr.parameters.get(1));
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(2))) {
            para.add(expr.parameters.get(2));
        } else {
            se = new StringExpr(currencyNumber);
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(3))) {
            para.add(expr.parameters.get(3));
        } else {
            periodType = this.theme.getPeriodType();
            date = RPTDateUtil.getPeriodLastDate((int)year, (int)period, (RptPeriodTypeEnum)periodType);
            endDateString = BatchHelper.dateFormat.format(date);
            se = new StringExpr(endDateString);
            para.add(se);
        }
        para.add(expr.parameters.get(4));
        para.add(expr.parameters.get(5));
        para.add(expr.parameters.get(6));
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(7))) {
            para.add(expr.parameters.get(7));
        } else {
            periodType = this.theme.getPeriodType();
            date = RPTDateUtil.getPeriodLastDate((int)year, (int)period, (RptPeriodTypeEnum)periodType);
            endDateString = BatchHelper.dateFormat.format(date);
            se = new StringExpr(endDateString);
            para.add(se);
        }
        para.add(expr.parameters.get(8));
        para.add(expr.parameters.get(9));
        expr.parameters = para;
        return expr;
    }

    private FunctionExpr fillRefM(FunctionExpr expr, boolean isUnion, String companyNumber, int year, int period, String currencyNumber, String deNumber, String dataType) {
        StringExpr se;
        ArrayList para = new ArrayList();
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(0))) {
            para.add(expr.parameters.get(0));
        } else {
            se = new StringExpr(companyNumber);
            para.add(se);
        }
        para.add(expr.parameters.get(1));
        para.add(expr.parameters.get(2));
        int[] yearPeriod = this.getStartYearPeriod(expr, year, period, -1, 3, 4);
        if (Integer.valueOf(String.valueOf(expr.parameters.get(3))) > 0) {
            para.add(expr.parameters.get(3));
        } else {
            se = new StringExpr(String.valueOf(yearPeriod[0]));
            para.add(se);
        }
        if (Integer.valueOf(String.valueOf(expr.parameters.get(4))) > 0) {
            para.add(expr.parameters.get(4));
        } else {
            se = new StringExpr(String.valueOf(yearPeriod[1]));
            para.add(se);
        }
        para.add(expr.parameters.get(5));
        para.add(expr.parameters.get(6));
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(7))) {
            para.add(expr.parameters.get(7));
        } else {
            se = new StringExpr(currencyNumber);
            para.add(se);
        }
        para.add(expr.parameters.get(8));
        para.add(expr.parameters.get(9));
        para.add(expr.parameters.get(10));
        expr.parameters = para;
        return expr;
    }

    private String constructAnalyzeKey(String indexNum, String indexName, FullOrgUnitInfo orgUnit, CurrencyInfo currency, int year, int period, DataElementInfo dataElement, String dataType) {
        StringBuffer key = new StringBuffer();
        key.append(year).append(SPLITSTR).append(period).append(SPLITSTR).append(orgUnit.getId().toString()).append(SPLITSTR).append(orgUnit.getNumber()).append(SPLITSTR);
        key.append(orgUnit.getName()).append(SPLITSTR).append(currency.getNumber()).append(SPLITSTR).append(currency.getName()).append(SPLITSTR);
        key.append(indexNum).append(SPLITSTR).append(indexName);
        if (dataElement != null) {
            key.append(SPLITSTR).append(dataElement.getNumber()).append(SPLITSTR).append(dataElement.getName());
        }
        if (dataType != null) {
            key.append(SPLITSTR).append(dataType);
        }
        return key.toString();
    }

    private Book initBook(CslReportInfo cslReportInfo) throws Exception {
        Book book = Book.Manager.getNewBook(null, (int)1);
        FunctionManager fm = book.getDeps().getFunctionManager();
        ReportCalculateErrorProvider errorhandler = new ReportCalculateErrorProvider();
        ReportCalculateErrorProvider.addErrorProvider(Exception.class, (IErrorProvider)errorhandler);
        ReportCalculateContext calcContext = new ReportCalculateContext(this.ctx);
        calcContext.setReportAdapter((IReportPropertyAdapter)new CSLPropertyAdapter(cslReportInfo, this.ctx, false));
        calcContext.setErrorProvider((IErrorProvider)errorhandler);
        ReportVariables iv = new ReportVariables();
        iv.add(new VariableEntry("Check_Permissioin", null, 1, "false", false));
        calcContext.setReportVariables(iv);
        this.registerFormulaToBook(calcContext, fm);
        book.setCalculate(false);
        return book;
    }

    private CslReportInfo getCslReportInfo(FullOrgUnitInfo orgUnit, CurrencyInfo currency, int year, int period) {
        CslReportInfo cslReport = new CslReportInfo();
        cslReport.setOrgUnit(orgUnit);
        cslReport.setCompany(orgUnit);
        cslReport.setSourceCurrency(currency);
        cslReport.setCurrency(currency);
        cslReport.setYear(year);
        cslReport.setPeriod((short)period);
        cslReport.setPeriodType(this.theme.getPeriodType());
        if (this.theme.getOrgTree() != null) {
            cslReport.setOrgTree(this.theme.getOrgTree());
        }
        if (orgUnit.isIsUnion()) {
            if (this.theme.isIsCombine()) {
                cslReport.setSourceType(RptSrcTypeEnum.CONSOLIDATION);
            } else if (this.theme.isIsSum()) {
                cslReport.setSourceType(RptSrcTypeEnum.SUM);
            }
        } else {
            cslReport.setSourceType(RptSrcTypeEnum.NORMAL);
        }
        return cslReport;
    }

    private PeriodIterator getPeriodIterator() {
        List startTime = this.getStartTimes();
        List endTime = this.getEndTimes();
        int starty = (Integer)startTime.get(0);
        int startp = (Integer)startTime.get(1);
        int endy = (Integer)endTime.get(0);
        int endp = (Integer)endTime.get(1);
        int periodType = this.theme.getPeriodType().getValue();
        PeriodIterator pIt = new PeriodIterator(starty, endy, startp, endp, periodType);
        return pIt;
    }

    private int[] getYearPeriod(FunctionExpr expr, int year, int period, int periodTypePosition, int yearPosition, int startPosition, int endPosition) {
        int[] yearPeriod = new int[3];
        int startYear = year;
        int startPeriod = period;
        int endPeriod = period;
        int iyear = Integer.valueOf(String.valueOf(expr.parameters.get(yearPosition)));
        int istartPeriod = Integer.valueOf(String.valueOf(expr.parameters.get(startPosition)));
        int iendPeriod = Integer.valueOf(String.valueOf(expr.parameters.get(endPosition)));
        if (iyear < 0 || istartPeriod < 0 || iendPeriod < 0) {
            int int_periodType = this.theme.getPeriodType().getValue();
            if (periodTypePosition != -1 && FormulaUtil.hasDispenseParameter(expr.parameters.get(periodTypePosition))) {
                int_periodType = RptPeriodTypeEnum.getEnum((String)String.valueOf(expr.parameters.get(periodTypePosition))).getValue();
            }
            int[] start = FiscalPeriodHelper.getRptFormualYearAndPeriod((boolean)true, null, (int)year, (int)period, (int)int_periodType, (int)iyear, (int)istartPeriod, (boolean)false);
            int[] end = FiscalPeriodHelper.getRptFormualYearAndPeriod((boolean)true, null, (int)year, (int)period, (int)int_periodType, (int)iyear, (int)iendPeriod, (boolean)false);
            startYear = start[0];
            startPeriod = start[1];
            endPeriod = end[1];
        }
        yearPeriod[0] = startYear;
        yearPeriod[1] = startPeriod;
        yearPeriod[2] = endPeriod;
        return yearPeriod;
    }

    private int[] getAccYearPeriod(FunctionExpr expr, int year, int period, int startYearPosition, int startPeriodPosition, int endYearPosition, int endPeriodPosition) {
        int[] yearPeriod = new int[4];
        int startYear = year;
        int startPeriod = period;
        int endYear = year;
        int endPeriod = period;
        int iStartyear = Integer.valueOf(String.valueOf(expr.parameters.get(startYearPosition)));
        int iStartPeriod = Integer.valueOf(String.valueOf(expr.parameters.get(startPeriodPosition)));
        int iEndyear = Integer.valueOf(String.valueOf(expr.parameters.get(endYearPosition)));
        int iEndPeriod = Integer.valueOf(String.valueOf(expr.parameters.get(endPeriodPosition)));
        if (iStartyear < 0 || iStartPeriod < 0 || iEndyear < 0 || iEndPeriod < 0) {
            int[] yearAndPeriod;
            int int_periodType = this.theme.getPeriodType().getValue();
            PeriodHandler periodHandler = new PeriodHandler();
            if (iStartyear < 0 || iStartPeriod < 0) {
                yearAndPeriod = periodHandler.action(iStartyear, startPeriod, year, period, RptPeriodTypeEnum.getEnum((int)int_periodType), null, false);
                startYear = yearAndPeriod[0];
                startPeriod = yearAndPeriod[1];
                if (int_periodType != 3) {
                    yearAndPeriod = FiscalPeriodHelper.getYearAndFirstPeriodNumber(null, (int)startYear, (int)startPeriod, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)int_periodType), (boolean)false);
                    startYear = yearAndPeriod[0];
                    startPeriod = yearAndPeriod[1];
                }
            }
            if (iEndyear < 0 || iEndPeriod < 0) {
                yearAndPeriod = periodHandler.action(iEndyear, iEndPeriod, year, period, RptPeriodTypeEnum.getEnum((int)int_periodType), null, false);
                endYear = yearAndPeriod[0];
                endPeriod = yearAndPeriod[1];
                if (int_periodType != 3) {
                    yearAndPeriod = FiscalPeriodHelper.getYearAndFirstPeriodNumber(null, (int)endYear, (int)endPeriod, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)int_periodType), (boolean)false);
                    endYear = yearAndPeriod[0];
                    endPeriod = yearAndPeriod[1];
                }
            }
        }
        yearPeriod[0] = startYear;
        yearPeriod[1] = startPeriod;
        yearPeriod[2] = endYear;
        yearPeriod[3] = endPeriod;
        return yearPeriod;
    }

    private int[] getStartYearPeriod(FunctionExpr expr, int year, int period, int periodTypePosition, int yearPosition, int startPosition) {
        int[] yearPeriod = new int[2];
        int startYear = year;
        int startPeriod = period;
        int iyear = Integer.valueOf(String.valueOf(expr.parameters.get(yearPosition)));
        int istartPeriod = Integer.valueOf(String.valueOf(expr.parameters.get(startPosition)));
        if (iyear < 0 || istartPeriod < 0) {
            int int_periodType = this.theme.getPeriodType().getValue();
            if (periodTypePosition != -1 && FormulaUtil.hasDispenseParameter(expr.parameters.get(periodTypePosition))) {
                int_periodType = RptPeriodTypeEnum.getEnum((String)String.valueOf(expr.parameters.get(periodTypePosition))).getValue();
            }
            int[] start = FiscalPeriodHelper.getRptFormualYearAndPeriod((boolean)true, null, (int)year, (int)period, (int)int_periodType, (int)iyear, (int)istartPeriod, (boolean)false);
            startYear = start[0];
            startPeriod = start[1];
        }
        yearPeriod[0] = startYear;
        yearPeriod[1] = startPeriod;
        return yearPeriod;
    }

    private boolean isFIFormula(String formula) throws BOSException {
        try {
            Expression stmt = ExcelFormulaPaserHelper.parse((String)formula);
            if (!(stmt instanceof FunctionExpr)) {
                return false;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        String[] fiFormulas = new String[]{"age(", "acct(", "acctac(", "acctcash(", "acctcashext(", "acctext(", "incashflow(", "racct("};
        String formulaLowCase = formula.toLowerCase(Locale.ENGLISH);
        for (int i = 0; i < fiFormulas.length; ++i) {
            String name = fiFormulas[i];
            if (formulaLowCase.indexOf(name) <= -1) continue;
            return true;
        }
        return false;
    }

    private boolean isIFFormula(String formula) {
        String formulaLowCase = formula.toLowerCase(Locale.ENGLISH);
        return formulaLowCase.indexOf("if") > -1;
    }

    private Set<String> getStartedCompanyIds(Context ctx) throws Exception {
        HashSet<String> ids = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select ssc.FCompanyID companyId \n");
        sql.append(" From T_BD_SystemStatusCtrol ssc \n");
        sql.append(" Inner Join T_BD_SystemStatus ss On ssc.FSystemStatusID = ss.Fid \n");
        sql.append(" Where ssc.FISSTART = ? and ss.FNAME = ?");
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(1);
        params.add(6);
        IRowSet rs = DbUtil.executeQuery(ctx, sql.toString(), params.toArray());
        while (rs.next()) {
            String companyId = rs.getString("companyId");
            ids.add(companyId);
        }
        return ids;
    }
}

