/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.rptIndexAnalyze.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.qing.preparedata.handler.budget.BudgetFacade;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveUtil;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveParams;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.AnalyzeTypeEnum;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.CurrencyEntryCollection;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.CurrencyEntryFactory;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.DataElementEntryCollection;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.DataElementEntryFactory;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.DynaItemEntryCollection;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.DynaItemEntryFactory;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.ICurrencyEntry;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.IDataElementEntry;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.IDynaItemEntry;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.IIndexEntry;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.IItemEntry;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.IOrgUnitEntry;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.IndexEntryCollection;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.IndexEntryFactory;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.ItemEntryCollection;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.ItemEntryFactory;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.OrgUnitEntryCollection;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.OrgUnitEntryFactory;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeCollection;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeFactory;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.SchedulingSchemeEntryCollection;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.SchedulingSchemeEntryInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.SchedulingSchemeFactory;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.SchedulingSchemeInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.app.AbstractRptQingAnalyzeControllerBean;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.app.RptQingAnalyzeCalHandler;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.ResourceBase;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class RptQingAnalyzeControllerBean
extends AbstractRptQingAnalyzeControllerBean {
    private static final long serialVersionUID = -3085790972213133396L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.app.RptQingAnalyzeControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RptQingAnalyzeInfo analyzeInfo = (RptQingAnalyzeInfo)model;
        IObjectPK modelPK = super._submit(ctx, model);
        if (analyzeInfo.getId() == null) {
            analyzeInfo.setId(BOSUuid.read((String)modelPK.toString()));
        }
        this.addOrgUnitEntrys(ctx, analyzeInfo);
        this.addRptItemEntrys(ctx, analyzeInfo);
        this.addAnalyzeIndexEntrys(ctx, analyzeInfo);
        this.addDataElementEntys(ctx, analyzeInfo);
        this.addCurrencyEntrys(ctx, analyzeInfo);
        this.addDynaItemEntrys(ctx, analyzeInfo);
        return modelPK;
    }

    private void addDynaItemEntrys(Context ctx, RptQingAnalyzeInfo analyzeInfo) throws BOSException, EASBizException {
        AnalyzeTypeEnum analyzeType;
        DynaItemEntryCollection dynaItemEntrys = analyzeInfo.getDynaItem();
        IDynaItemEntry instance = DynaItemEntryFactory.getLocalInstance(ctx);
        instance.delete("where analyze = '" + analyzeInfo.getId().toString() + "'");
        if (dynaItemEntrys != null && !dynaItemEntrys.isEmpty() && (analyzeType = analyzeInfo.getAnalyzeType()).getValue() == 1) {
            CoreBaseCollection colls = new CoreBaseCollection();
            for (int i = 0; i < dynaItemEntrys.size(); ++i) {
                dynaItemEntrys.get(i).setId(null);
                dynaItemEntrys.get(i).setAnalyze(analyzeInfo);
            }
            colls.addObjectCollection((IObjectCollection)dynaItemEntrys);
            instance.addnew(colls);
        }
    }

    private void addCurrencyEntrys(Context ctx, RptQingAnalyzeInfo analyzeInfo) throws BOSException, EASBizException {
        CurrencyEntryCollection currencyEntrys = analyzeInfo.getCurrency();
        ICurrencyEntry instance = CurrencyEntryFactory.getLocalInstance(ctx);
        instance.delete("where analyze = '" + analyzeInfo.getId().toString() + "'");
        if (currencyEntrys != null && !currencyEntrys.isEmpty()) {
            CoreBaseCollection colls = new CoreBaseCollection();
            for (int i = 0; i < currencyEntrys.size(); ++i) {
                currencyEntrys.get(i).setId(null);
                currencyEntrys.get(i).setAnalyze(analyzeInfo);
            }
            colls.addObjectCollection((IObjectCollection)currencyEntrys);
            instance.addnew(colls);
        }
    }

    private void addDataElementEntys(Context ctx, RptQingAnalyzeInfo analyzeInfo) throws BOSException, EASBizException {
        DataElementEntryCollection dataElementEntrys = analyzeInfo.getDataElement();
        IDataElementEntry instance = DataElementEntryFactory.getLocalInstance(ctx);
        instance.delete("where analyze = '" + analyzeInfo.getId().toString() + "'");
        if (dataElementEntrys != null && !dataElementEntrys.isEmpty()) {
            CoreBaseCollection colls = new CoreBaseCollection();
            for (int i = 0; i < dataElementEntrys.size(); ++i) {
                dataElementEntrys.get(i).setId(null);
                dataElementEntrys.get(i).setAnalyze(analyzeInfo);
            }
            colls.addObjectCollection((IObjectCollection)dataElementEntrys);
            instance.addnew(colls);
        }
    }

    private void addAnalyzeIndexEntrys(Context ctx, RptQingAnalyzeInfo analyzeInfo) throws BOSException, EASBizException {
        AnalyzeTypeEnum analyzeType;
        IndexEntryCollection indexEntrys = analyzeInfo.getAnalyzeIndex();
        IIndexEntry instance = IndexEntryFactory.getLocalInstance(ctx);
        instance.delete("where analyze = '" + analyzeInfo.getId().toString() + "'");
        if (indexEntrys != null && !indexEntrys.isEmpty() && (analyzeType = analyzeInfo.getAnalyzeType()).getValue() == 2) {
            CoreBaseCollection colls = new CoreBaseCollection();
            for (int i = 0; i < indexEntrys.size(); ++i) {
                indexEntrys.get(i).setId(null);
                indexEntrys.get(i).setAnalyze(analyzeInfo);
            }
            colls.addObjectCollection((IObjectCollection)indexEntrys);
            instance.addnew(colls);
        }
    }

    private void addRptItemEntrys(Context ctx, RptQingAnalyzeInfo analyzeInfo) throws BOSException, EASBizException {
        ItemEntryCollection itemEntrys = analyzeInfo.getRptItem();
        IItemEntry instance = ItemEntryFactory.getLocalInstance(ctx);
        instance.delete("where analyze = '" + analyzeInfo.getId().toString() + "'");
        if (itemEntrys != null && !itemEntrys.isEmpty()) {
            AnalyzeTypeEnum analyzeType = analyzeInfo.getAnalyzeType();
            instance.delete("where analyze = '" + analyzeInfo.getId().toString() + "'");
            if (analyzeType.getValue() != 2) {
                CoreBaseCollection colls = new CoreBaseCollection();
                for (int i = 0; i < itemEntrys.size(); ++i) {
                    itemEntrys.get(i).setId(null);
                    itemEntrys.get(i).setAnalyze(analyzeInfo);
                }
                colls.addObjectCollection((IObjectCollection)itemEntrys);
                instance.addnew(colls);
            }
        }
    }

    private void addOrgUnitEntrys(Context ctx, RptQingAnalyzeInfo analyzeInfo) throws BOSException, EASBizException {
        OrgUnitEntryCollection orgunitEntrys = analyzeInfo.getOrgUnit();
        IOrgUnitEntry instance = OrgUnitEntryFactory.getLocalInstance(ctx);
        instance.delete("where analyze = '" + analyzeInfo.getId().toString() + "'");
        if (orgunitEntrys != null && !orgunitEntrys.isEmpty()) {
            CoreBaseCollection colls = new CoreBaseCollection();
            for (int i = 0; i < orgunitEntrys.size(); ++i) {
                orgunitEntrys.get(i).setId(null);
                orgunitEntrys.get(i).setAnalyze(analyzeInfo);
            }
            colls.addObjectCollection((IObjectCollection)orgunitEntrys);
            instance.addnew(colls);
        }
    }

    @Override
    protected void _delQingFile(Context ctx, String qingFileId) throws BOSException {
        try {
            BudgetFacade.deleteFile((String)qingFileId, (Context)ctx);
        }
        catch (BOSException e) {
            logger.error((Object)("delete qing file failed!!!!!!!!!,fileName:" + qingFileId), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        logger.info((Object)("delete qing file success ! file name: " + qingFileId));
    }

    @Override
    protected void _dispatchRptQingAnalyze(Context ctx, String schemeId) throws BOSException, EASBizException {
        Set<String> analyzeIds;
        RptQingAnalyzeCollection analyzes;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("creator"));
        selector.add(new SelectorItemInfo("entries.analyzeId"));
        SchedulingSchemeInfo schedulingScheme = SchedulingSchemeFactory.getLocalInstance(ctx).getSchedulingSchemeInfo((IObjectPK)new ObjectUuidPK(schemeId), selector);
        SchedulingSchemeEntryCollection entries = schedulingScheme.getEntries();
        if (entries != null && !entries.isEmpty() && (analyzes = this.getAnalyzeThemes(ctx, analyzeIds = this.getRptQingAnalyzeIds(entries))) != null && !analyzes.isEmpty()) {
            String mutex = "RptQingAnalyzeDispatch";
            RptWeaveParams param = null;
            int mutexFlag = 0;
            int size = analyzes.size();
            for (int i = 0; i < size; ++i) {
                RptQingAnalyzeInfo rptQingAnalyzeInfo = analyzes.get(i);
                param = new RptWeaveParams();
                param.setObject("theme", (Object)rptQingAnalyzeInfo);
                mutexFlag = i % 2;
                mutex = mutex + mutexFlag;
                String themeName = rptQingAnalyzeInfo.getNumber() + "(" + rptQingAnalyzeInfo.getName() + ")";
                String title = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"141_dispatchTitle", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{i, themeName});
                Job job = RptAutoWeaveUtil.createWeaveRptJob((Context)ctx, (RptWeaveParams)param, (String)title, (String)mutex, (IJobHandler)new RptQingAnalyzeCalHandler());
            }
        }
    }

    private Set<String> getRptQingAnalyzeIds(SchedulingSchemeEntryCollection entries) {
        HashSet<String> analyzeIds = new HashSet<String>();
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            SchedulingSchemeEntryInfo entry = (SchedulingSchemeEntryInfo)it.next();
            String id = entry.getAnalyzeId();
            analyzeIds.add(id);
        }
        return analyzeIds;
    }

    private RptQingAnalyzeCollection getAnalyzeThemes(Context ctx, Set<String> themeIds) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", themeIds, CompareType.INCLUDE));
        view.setSelector(this.getQingSelector());
        view.getSorter().add(new SorterItemInfo("analyzeType"));
        view.getSorter().add(new SorterItemInfo("number"));
        RptQingAnalyzeCollection analyzeThemes = RptQingAnalyzeFactory.getLocalInstance(ctx).getRptQingAnalyzeCollection(view);
        return analyzeThemes;
    }

    private SelectorItemCollection getQingSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("asstActType.id"));
        sic.add(new SelectorItemInfo("asstActType.number"));
        sic.add(new SelectorItemInfo("orgTree.id"));
        sic.add(new SelectorItemInfo("orgTree.number"));
        sic.add(new SelectorItemInfo("orgUnit.orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.orgUnit.number"));
        sic.add(new SelectorItemInfo("orgUnit.orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.orgUnit.isUnion"));
        sic.add(new SelectorItemInfo("rptItem.rptItem.id"));
        sic.add(new SelectorItemInfo("rptItem.rptItem.number"));
        sic.add(new SelectorItemInfo("rptItem.rptItem.name"));
        sic.add(new SelectorItemInfo("analyzeIndex.analyzeIndex.id"));
        sic.add(new SelectorItemInfo("analyzeIndex.analyzeIndex.number"));
        sic.add(new SelectorItemInfo("analyzeIndex.analyzeIndex.name"));
        sic.add(new SelectorItemInfo("analyzeIndex.analyzeIndex.formula"));
        sic.add(new SelectorItemInfo("dataElement.dataElement.id"));
        sic.add(new SelectorItemInfo("dataElement.dataElement.number"));
        sic.add(new SelectorItemInfo("dataElement.dataElement.name"));
        sic.add(new SelectorItemInfo("dataElement.dataElement.interseq"));
        sic.add(new SelectorItemInfo("currency.currency.id"));
        sic.add(new SelectorItemInfo("currency.currency.number"));
        sic.add(new SelectorItemInfo("currency.currency.name"));
        sic.add(new SelectorItemInfo("dynaItem.dynaNumber"));
        sic.add(new SelectorItemInfo("dynaItem.dynaName"));
        return sic;
    }
}

