/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.rptIndexAnalyze.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.bi.util.DynaItemInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveUtil;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveParams;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeCollection;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeFacade;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeFactory;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.app.AbstractRptQingAnalyzeFacadeControllerBean;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.app.CalculateRptQingAnalyzeFactory;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.app.RptQingAnalyzeCalHandler;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableJdbcTemplate;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RptQingAnalyzeFacadeControllerBean
extends AbstractRptQingAnalyzeFacadeControllerBean {
    private static final long serialVersionUID = 8864273166046631016L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.app.RptQingAnalyzeFacadeControllerBean");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected ArrayList _getDynaItems(Context ctx, Map params) throws BOSException, EASBizException {
        TempTableJdbcTemplate tempTableJdbcTemplate = null;
        String tmpTable = null;
        ArrayList<DynaItemInfo> dynaItemList = new ArrayList<DynaItemInfo>();
        try {
            tempTableJdbcTemplate = new TempTableJdbcTemplate(ctx);
            tempTableJdbcTemplate.initConnection();
            tmpTable = this.createTempTable(tempTableJdbcTemplate);
            this.insertToTempTable(ctx, params, tmpTable);
            ArrayList<Object> param = new ArrayList<Object>();
            StringBuilder sql = new StringBuilder();
            sql.append("Select Distinct entry.FKeyNumber dynaNumber, entry.FKeyName dynaName \n");
            sql.append(" From T_CSL_DynaItemDataEntry entry \n");
            sql.append(" Inner Join T_CSL_DynaItemData item On item.fid = entry.FItemDataId \n");
            sql.append(" Inner join T_CSL_RptReceived rec On rec.FReportId = item.FReportId \n");
            sql.append(" Inner Join ").append(tmpTable).append(" tmplTable On tmplTable.FOrgUnitId = item.FOrgUnitId \n");
            sql.append(" Inner Join T_CSL_TempletItemList list On list.FItemNumber = entry.FItemId And list.FDataElement = entry.FDataElement And list.FValueType = entry.FValueType \n");
            sql.append(" Inner Join T_RPT_Template tmpl On tmpl.fid = list.FTemplateId \n");
            sql.append(" Where tmpl.Fnumber = ? And tmpl.FTemplateType = ? And item.FDynaType = ? And item.FDataSource = ? And item.FPeriodType = ? And item.FOrgType = ? ");
            String tmplNumber = (String)params.get("tmplNumber");
            param.add(tmplNumber);
            int tmplType = (Integer)params.get("tmplType");
            param.add(tmplType);
            param.add(1);
            int dataSource = 10;
            if (tmplType == 11) {
                dataSource = 11;
            } else if (tmplType == 13) {
                dataSource = 13;
            }
            param.add(dataSource);
            int periodType = (Integer)params.get("periodType");
            param.add(periodType);
            int orgType = (Integer)params.get("orgType");
            param.add(orgType);
            int startYear = (Integer)params.get("startYear");
            int startPeriod = (Integer)params.get("startPeriod");
            int endYear = (Integer)params.get("endYear");
            int endPeriod = (Integer)params.get("endPeriod");
            if (startYear == endYear && startPeriod == endPeriod) {
                sql.append(" And entry.FYear = ? \n");
                param.add(startYear);
                sql.append(" And entry.FPeriod = ? \n");
                param.add(startPeriod);
            } else if (startYear == endYear) {
                sql.append(" And entry.FYear = ? \n");
                param.add(startYear);
                sql.append(" And entry.FPeriod >= ? \n");
                param.add(startPeriod);
                sql.append(" And entry.FPeriod <= ? \n");
                param.add(endPeriod);
            } else {
                sql.append(" AND (entry.FYear > ?");
                param.add(startYear);
                sql.append(" OR (entry.FYear = ?");
                param.add(startYear);
                sql.append(" AND entry.FPeriod >= ?");
                param.add(startPeriod);
                sql.append(")) ");
                sql.append(" AND (entry.FYear < ?");
                param.add(endYear);
                sql.append(" OR (entry.FYear = ?");
                param.add(endYear);
                sql.append(" AND entry.FPeriod <= ?");
                param.add(endPeriod);
                sql.append(")) ");
            }
            if (params.containsKey("asstActNumber")) {
                sql.append(" And list.FAsstActTypeNumber = ? ");
                String asstActNumber = (String)params.get("asstActNumber");
                param.add(asstActNumber);
            }
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString(), param.toArray());
            DynaItemInfo dynaItem = null;
            while (rowSet.next()) {
                String dynaNumber = rowSet.getString("dynaNumber");
                String dynaName = rowSet.getString("dynaName");
                dynaItem = new DynaItemInfo(dynaName, dynaNumber);
                dynaItemList.add(dynaItem);
            }
            if (tempTableJdbcTemplate == null || tmpTable == null) return dynaItemList;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                if (tempTableJdbcTemplate == null || tmpTable == null) throw throwable;
                tempTableJdbcTemplate.releaseDBSystemTempTable(tmpTable);
                tempTableJdbcTemplate.cleanupConnection();
                throw throwable;
            }
        }
        tempTableJdbcTemplate.releaseDBSystemTempTable(tmpTable);
        tempTableJdbcTemplate.cleanupConnection();
        return dynaItemList;
    }

    private String createTempTable(TempTableJdbcTemplate tempTableJdbcTemplate) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("create table Tmp_OrgUnitTable (FOrgUnitId varchar(44))");
        String tableName = tempTableJdbcTemplate.createDBSystemTempTable(sql.toString());
        return tableName;
    }

    private void insertToTempTable(Context ctx, Map params, String tmpTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(tmpTable).append("(FOrgUnitId) Values (?)");
        HashSet orgIds = new HashSet();
        if (params.get("companyIds") != null) {
            Set companyIds = (Set)params.get("companyIds");
            orgIds.addAll(companyIds);
        }
        if (params.get("orgIds") != null) {
            Set unitIds = (Set)params.get("orgIds");
            orgIds.addAll(unitIds);
        }
        if (!orgIds.isEmpty()) {
            Object[] param = null;
            ArrayList<Object[]> btachParams = new ArrayList<Object[]>();
            Iterator it = orgIds.iterator();
            while (it.hasNext()) {
                param = new Object[1];
                String orgId = (String)it.next();
                param[0] = orgId;
                btachParams.add(param);
            }
            if (btachParams.size() > 0) {
                DbUtil.executeBatch(ctx, sql.toString(), btachParams);
            }
        }
    }

    @Override
    protected void _calculate(Context ctx, String analyzeId) throws BOSException, EASBizException {
        RptQingAnalyzeInfo theme = this.getRptQingAnalyzeInfo(ctx, analyzeId);
        StringBuffer logName = new StringBuffer();
        String title = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"84_logTitle", (Locale)ctx.getOriginLocale());
        logName.append(title).append("-").append(theme.getNumber()).append(theme.getName());
        String logItem = "csl_analyze_calculate";
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"actionCalculate", (BOSObjectType)theme.getBOSType(), (IObjectPK)new ObjectUuidPK(theme.getId()), (String)logName.toString(), (String)logItem);
        CalculateRptQingAnalyzeFactory.getInstance(ctx, theme).writeAnalyzeData();
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
    }

    private RptQingAnalyzeInfo getRptQingAnalyzeInfo(Context ctx, String analyzeId) throws EASBizException, BOSException {
        RptQingAnalyzeInfo theme = (RptQingAnalyzeInfo)RptQingAnalyzeFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(analyzeId), this.getQingSelector());
        return theme;
    }

    private SelectorItemCollection getQingSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("asstActType.id"));
        sic.add(new SelectorItemInfo("asstActType.number"));
        sic.add(new SelectorItemInfo("orgTree.id"));
        sic.add(new SelectorItemInfo("orgTree.number"));
        sic.add(new SelectorItemInfo("orgUnit.orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.orgUnit.number"));
        sic.add(new SelectorItemInfo("orgUnit.orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.orgUnit.isUnion"));
        sic.add(new SelectorItemInfo("rptItem.rptItem.id"));
        sic.add(new SelectorItemInfo("rptItem.rptItem.number"));
        sic.add(new SelectorItemInfo("rptItem.rptItem.name"));
        sic.add(new SelectorItemInfo("analyzeIndex.analyzeIndex.id"));
        sic.add(new SelectorItemInfo("analyzeIndex.analyzeIndex.number"));
        sic.add(new SelectorItemInfo("analyzeIndex.analyzeIndex.name"));
        sic.add(new SelectorItemInfo("analyzeIndex.analyzeIndex.formula"));
        sic.add(new SelectorItemInfo("dataElement.dataElement.id"));
        sic.add(new SelectorItemInfo("dataElement.dataElement.number"));
        sic.add(new SelectorItemInfo("dataElement.dataElement.name"));
        sic.add(new SelectorItemInfo("dataElement.dataElement.interseq"));
        sic.add(new SelectorItemInfo("currency.currency.id"));
        sic.add(new SelectorItemInfo("currency.currency.number"));
        sic.add(new SelectorItemInfo("currency.currency.name"));
        sic.add(new SelectorItemInfo("dynaItem.dynaNumber"));
        sic.add(new SelectorItemInfo("dynaItem.dynaName"));
        return sic;
    }

    @Override
    protected void _batchCalculate(Context ctx, Set themeIds) throws BOSException, EASBizException {
        StringBuffer logName = new StringBuffer();
        logName.append(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"84_logTitle", (Locale)ctx.getOriginLocale()));
        logName.append("-").append(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"118_logName", (Locale)ctx.getOriginLocale()));
        String logItem = "csl_analyze_batchCalculate";
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"actionBatchCalculate", (BOSObjectType)new RptQingAnalyzeFacade().getType(), null, (String)logName.toString(), (String)logItem);
        RptQingAnalyzeCollection themes = this.getAnalyzeThemes(ctx, themeIds);
        String mutex = "RptQingAnalyze";
        int mutexFlag = 0;
        int size = themes.size();
        for (int i = 0; i < size; ++i) {
            RptQingAnalyzeInfo theme = themes.get(i);
            RptWeaveParams param = new RptWeaveParams();
            param.setObject("theme", (Object)theme);
            mutexFlag = i % 2;
            mutex = mutex + mutexFlag;
            String themeName = theme.getNumber() + "(" + theme.getName() + ")";
            String title = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"82_batchCalQueue", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{i, themeName});
            Job job = RptAutoWeaveUtil.createWeaveRptJob((Context)ctx, (RptWeaveParams)param, (String)title, (String)mutex, (IJobHandler)new RptQingAnalyzeCalHandler());
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
    }

    private RptQingAnalyzeCollection getAnalyzeThemes(Context ctx, Set<String> themeIds) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", themeIds, CompareType.INCLUDE));
        view.setSelector(this.getQingSelector());
        RptQingAnalyzeCollection analyzeThemes = RptQingAnalyzeFactory.getLocalInstance(ctx).getRptQingAnalyzeCollection(view);
        return analyzeThemes;
    }
}

