/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.rptnotes.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ColumnInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.TableInfo;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.newrpt.cslworktable.util.CslWorkTableUtil;
import com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesInfo;
import com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesTemplateFactory;
import com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesUtil;
import com.kingdee.eas.fi.newrpt.rptnotes.app.AbstractReportNotesControllerBean;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ReportNotesControllerBean
extends AbstractReportNotesControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.rptnotes.app.ReportNotesControllerBean");

    @Override
    protected List _getRptNotes(Context ctx, Map condition) throws BOSException, EASBizException {
        Boolean[] rptStatus = (Boolean[])condition.get("rptStatus");
        String sortStr = (String)condition.get("sortStr");
        ParamTempTblService service = null;
        try {
            Object orgUnitNumbers = condition.get("orgUnitNumbers");
            if (orgUnitNumbers != null && !((List)orgUnitNumbers).isEmpty()) {
                String inSql = null;
                if (((List)orgUnitNumbers).size() > 20) {
                    TableInfo table = new TableInfo("T_CSL_orgUnit");
                    table.addColumn(new ColumnInfo("ForgUnitNumber", "Nvarchar(80)"));
                    service = ParamTempTblService.getInstance((Context)ctx, (TableInfo)table, (Collection)((List)orgUnitNumbers), null);
                    inSql = "select ForgUnitNumber from " + service.getTmpTableName();
                } else {
                    inSql = CslRptUtil.list2String((List)((List)orgUnitNumbers), (String)",", (boolean)true);
                }
                condition.put("orgUnitNumberInSql", inSql);
            }
            SQLBuilder sql = new SQLBuilder();
            if (rptStatus[0].booleanValue()) {
                this.getRptNotesTemplateSql(ctx, condition, sql);
            }
            if (rptStatus[1].booleanValue() || rptStatus[2].booleanValue()) {
                if (sql.getSQL().length() > 0) {
                    sql.append(" union all ");
                }
                this.getRptNotesSql(ctx, condition, sql);
            }
            StringBuffer curSql = new StringBuffer();
            if (sql.getSQL().length() > 0) {
                curSql.append("select * from (").append(sql.getSQL()).append(") rptsTable order by  ");
                if (!StringUtils.isEmpty((String)sortStr)) {
                    curSql.append(sortStr);
                } else {
                    curSql.append("isTemplate").append(",templateNumber,orgUnitName  asc");
                }
                ArrayList resultList = new ArrayList();
                IRowSet rs = DbUtil.executeQuery(ctx, curSql.toString(), sql.getParams());
                IRowSetMetaData rowSetMeta = rs.getRowSetMetaData();
                int columnCount = rowSetMeta.getColumnCount();
                HashSet<String> columnNames = new HashSet<String>();
                columnNames.add("year");
                columnNames.add("period");
                columnNames.add("auditstatus");
                String columnName = null;
                Object columnValue = null;
                HashMap<String, Object> mapInfo = null;
                while (rs.next()) {
                    mapInfo = new HashMap<String, Object>();
                    for (int i = 1; i <= columnCount; ++i) {
                        columnName = rowSetMeta.getColumnName(i);
                        columnValue = rs.getObject(columnName);
                        if (columnNames.contains(columnName.toLowerCase(Locale.ENGLISH)) && columnValue != null && Integer.valueOf(columnValue.toString()).equals(-1)) {
                            columnValue = null;
                        }
                        mapInfo.put(columnName.toLowerCase(), columnValue);
                    }
                    mapInfo.put("select", false);
                    resultList.add(mapInfo);
                }
                ArrayList arrayList = resultList;
                return arrayList;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        finally {
            if (service != null && !DebugLogger.isDebug) {
                service.release();
            }
        }
        return null;
    }

    private void getRptNotesSql(Context ctx, Map condition, SQLBuilder sql) throws Exception {
        String lang = ctx.getLocale().getLanguage();
        Boolean[] rptStatus = (Boolean[])condition.get("rptStatus");
        sql.append("select distinct unit.fnumber as orgUnitNumber,").append("unit.fname_").append(lang).append(" as orgUnitName,").append("rpt.fcompanyId as orgUnitId,").append("rpt.FOrgTreeNumber as orgTreeNumber,").append("template.fnumber as templateNumber, ").append("rpt.fname as name,").append("currency.fname_").append(lang).append(" as currency, ").append("rpt.fperiodType as periodType,").append("rpt.fyear as year, ").append("rpt.fperiod as period, ").append("CONCAT(tochar(template.fversionNumber),'.0') as versionNumber, ").append("rpt.FAuditedStatus as auditStatus,").append("auditUser.fname_").append(lang).append(" as auditUser,").append("updateUser.fname_").append(lang).append(" as updateUser,").append("rpt.fLastUpdateTime as updateTime,").append("rpt.fdescription as description,").append("createUser.fname_").append(lang).append(" as createUser,").append("rpt.FAuditedTime as auditTime,").append("rpt.fcreateTime as createTime,").append("rpt.fid as id,").append("rpt.FWordAttachId as wordAttachId,").append("0 as ").append("isTemplate");
        sql.append(" from T_CSL_ReportNotes rpt ");
        sql.append(" inner join t_bd_currency currency on currency.fid=rpt.fcurrencyid ");
        sql.append(" inner join T_CSL_ReportNotesTemplate template on rpt.ftemplateid=template.fid ");
        sql.append(" inner join t_org_baseunit unit on unit.fid=rpt.fcompanyId ");
        sql.append(" left join t_pm_user auditUser on auditUser.fid=rpt.FAuditorID ");
        sql.append(" left join t_pm_user updateUser on updateUser.fid=rpt.fLastUpdateUserID ");
        sql.append(" left join t_pm_user createUser on createUser.fid=rpt.fCreatorId ");
        if (!((Boolean)condition.get("isSelectOrgTree")).booleanValue()) {
            this.filterUserOrgPermission(ctx, sql, "rpt.FOrgTreeNumber", null, "unit");
        }
        sql.append(" where  ");
        this.setRptNotesWhere(sql, condition, "rpt", "template");
        sql.append(" and template.FisFreezed=? ", 0);
        String auditedStatusFilter = CslWorkTableUtil.getRptAuditedStatusInStr(rptStatus);
        if (!StringUtils.isEmpty((String)auditedStatusFilter)) {
            sql.append(" and rpt.FAuditedStatus in(").append(auditedStatusFilter).append(")");
        }
        this.filterTemplate(ctx, sql, condition, "template.fgroup");
    }

    private void filterTemplate(Context ctx, SQLBuilder sql, Map condition, String templateGroupField) throws Exception {
        Set groups = (Set)condition.get("groups");
        if (groups != null && !groups.isEmpty()) {
            sql.append(" and ").append(templateGroupField);
            if (groups.size() == 1) {
                sql.append("=?", groups.iterator().next());
            } else {
                sql.append(" in (").append(CslRptUtil.collection2String((Collection)groups, (String)",", (boolean)true)).append(") ");
            }
        }
    }

    private void filterUserOrgPermission(Context ctx, SQLBuilder sql, String treeNumberField, String unitNumberField, String unitTableName) throws Exception {
        if (StringUtils.isEmpty((String)unitTableName)) {
            sql.append(" inner join t_org_baseunit unit1 on unit1.fNumber=").append(unitNumberField);
            unitTableName = "unit1";
            sql.append(" inner join t_org_tree tree on tree.fNumber=").append(treeNumberField);
            sql.append(" inner join t_org_structure stru on stru.ftreeid=tree.fid and stru.funitid=").append(unitTableName).append(".fid ");
        }
        sql.append(" inner join t_pm_orgrange range on range.forgid=").append(unitTableName).append(".fid and range.ftype = 10 and range.fuserid=?", ctx.getCaller().toString());
    }

    private void getRptNotesTemplateSql(Context ctx, Map condition, SQLBuilder sql) throws Exception {
        String orgUnitNumber = (String)condition.get("orgUnitNumber");
        String orgTreeNumber = (String)condition.get("orgTreeNumber");
        String orgUnitNumberInSql = (String)condition.get("orgUnitNumberInSql");
        String lang = ctx.getLocale().getLanguage();
        sql.append("select distinct ").append(" unit.fnumber as orgUnitNumber,").append(" unit.fname_").append(lang).append(" as orgUnitName,").append(" mainDisp.FOrgUnitId as orgUnitId,").append(" mainDisp.FOrgTreeNumber as orgTreeNumber,").append("mainTmp.fnumber as templateNumber, ").append("mainTmp.fname as name,").append("N'").append((String)condition.get("currencyName")).append("' as currency, ").append("mainTmp.FPERIODTYPE as periodType,").append("-1 as year, ").append("-1 as period, ").append("CONCAT(tochar(mainTmp.fversionNumber),'.0') as versionNumber, ").append("-1 as auditStatus,").append("auditor.fname_").append(lang).append(" as auditUser,").append("updateUser.fname_").append(lang).append(" as updateUser,").append("mainTmp.fLastUpdateTime as updateTime,").append("mainTmp.fdescription as description,").append("createUser.fname_").append(lang).append(" as createUser,").append("mainTmp.FAuditedTime as auditTime,").append("mainTmp.fcreateTime as createTime,").append("mainTmp.fid as id,").append("'' as wordAttachId,").append("1 as ").append("isTemplate");
        sql.append(" from T_CSL_ReportNotesTemplate mainTmp ");
        sql.append(" inner join T_CSL_RptNotesTemplateDispense mainDisp on mainDisp.FrptNotesTemplateId=mainTmp.fid ");
        sql.append(" inner join t_org_baseunit unit on unit.fid=mainDisp.FOrgUnitId ");
        sql.append(" inner join (");
        sql.append("\tselect max(sbuTmp.fversionNumber) as fversionNumber,sbuTmp.fgroup as fgroup,sbuTmp.FPERIODTYPE as periodType,");
        sql.append("\t\tsubDisp.FOrgTreeNumber,subDisp.ForgUnitNumber");
        sql.append(" \tfrom T_CSL_ReportNotesTemplate sbuTmp ");
        sql.append(" \tinner join T_CSL_RptNotesTemplateDispense subDisp on subDisp.FrptNotesTemplateId=sbuTmp.fid ");
        sql.append(" \tinner join t_org_baseunit subUnit on subUnit.fid=subDisp.FOrgUnitId ");
        sql.append(" \tleft join (select distinct verRpt.fid,verRpt.forgUnitNumber,verTmp.fgroup from T_CSL_ReportNotes verRpt  ");
        sql.append("     \t\t\tinner join T_CSL_ReportNotesTemplate verTmp on verTmp.fid=verRpt.ftemplateid and ");
        this.setRptNotesWhere(sql, condition, "verRpt", "verTmp");
        sql.append("   ) rpt on rpt.fgroup=sbuTmp.fgroup and rpt.forgUnitNumber=subDisp.ForgUnitNumber ");
        boolean isSelectOrgTree = (Boolean)condition.get("isSelectOrgTree");
        if (!isSelectOrgTree) {
            this.filterUserOrgPermission(ctx, sql, "subDisp.FOrgTreeNumber", null, "subUnit");
        }
        sql.append(" \twhere rpt.fid is null and sbuTmp.FisFreezed=?", 0);
        if (isSelectOrgTree) {
            sql.append(" \tand subDisp.FOrgTreeNumber=?", orgTreeNumber);
            if (!StringUtils.isEmpty((String)orgUnitNumberInSql)) {
                sql.append(" \tand subDisp.ForgUnitNumber in (").append(orgUnitNumberInSql).append(")");
            } else {
                sql.append(" \tand subDisp.ForgUnitNumber=?", orgUnitNumber);
            }
        } else {
            sql.append(" \tand sbuTmp.fgroup=?", (String)condition.get("group"));
        }
        Integer periodType = (Integer)condition.get("periodType");
        sql.append(" \tand sbuTmp.FPeriodType=?", periodType);
        this.filterTemplate(ctx, sql, condition, "sbuTmp.fgroup");
        sql.append(" \tgroup by sbuTmp.fgroup,sbuTmp.FPERIODTYPE,subDisp.FOrgTreeNumber,subDisp.ForgUnitNumber");
        sql.append(" ) sub on sub.fversionNumber=mainTmp.fversionNumber and sub.fgroup=mainTmp.fgroup and sub.periodType=mainTmp.fperiodType ");
        sql.append(" and sub.FOrgTreeNumber=mainDisp.FOrgTreeNumber and sub.ForgUnitNumber=mainDisp.ForgUnitNumber ");
        sql.append(" left join t_pm_user updateUser on updateUser.fid=mainTmp.fLastUpdateUserID ");
        sql.append(" left join t_pm_user createUser on createUser.fid=mainTmp.fCreatorId ");
        sql.append(" left join t_pm_user auditor on auditor.fid=mainTmp.FAuditorId ");
    }

    private void setRptNotesWhere(SQLBuilder sql, Map condition, String cslRptTable, String tmplateTable) throws Exception {
        Integer periodType = (Integer)condition.get("periodType");
        Integer year = (Integer)condition.get("year");
        Integer period = (Integer)condition.get("period");
        String currencyId = (String)condition.get("currencyId");
        sql.append(cslRptTable).append(".fperiodType=? and ", periodType);
        sql.append(cslRptTable).append(".fyear=? and ", year);
        sql.append(cslRptTable).append(".fperiod=? and ", period);
        sql.append(cslRptTable).append(".fcurrencyid=? and ", currencyId);
        if (((Boolean)condition.get("isSelectOrgTree")).booleanValue()) {
            String orgUnitNumber = (String)condition.get("orgUnitNumber");
            String orgTreeNumber = (String)condition.get("orgTreeNumber");
            String orgUnitNumberInSql = (String)condition.get("orgUnitNumberInSql");
            sql.append(cslRptTable).append(".FOrgTreeNumber=? and ", orgTreeNumber);
            if (!StringUtils.isEmpty((String)orgUnitNumberInSql)) {
                sql.append(cslRptTable).append(".FOrgUnitNumber in (").append(orgUnitNumberInSql).append(")");
            } else {
                sql.append(cslRptTable).append(".FOrgUnitNumber=? ", orgUnitNumber);
            }
        } else {
            sql.append(tmplateTable).append(".fgroup=? ", (String)condition.get("group"));
        }
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        try {
            if (this.isExists(ctx, model)) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"85_isExists", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{((ReportNotesInfo)model).getCompany().getName(), ((ReportNotesInfo)model).getName()}));
            }
            ((ReportNotesInfo)model).setAuditedStatus(AuditedStatusEnum.UNAUDITED);
            IObjectPK pk = super._addnew(ctx, model);
            this.createRptNotes(ctx, pk, model);
            return pk;
        }
        catch (Exception e) {
            logger.error((Object)"addnew error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    protected boolean isExists(Context ctx, IObjectValue model) throws Exception {
        ReportNotesInfo info = (ReportNotesInfo)model;
        if (!StringUtils.isEmpty((String)info.getOrgTreeNumber()) && !StringUtils.isEmpty((String)info.getOrgUnitNumber()) && info.getTemplate() != null && info.getTemplate().getId() != null && info.getCurrency() != null && info.getCurrency().getId() != null) {
            SQLBuilder sql = new SQLBuilder();
            sql.append("select  rptNote.fid from T_CSL_ReportNotes rptnote ");
            sql.append(" inner join T_CSL_ReportNotesTemplate rpttmp on rpttmp.fid=rptnote.ftemplateid ");
            sql.append(" inner join T_CSL_ReportNotesTemplate tmp on rpttmp.fgroup=tmp.fgroup ");
            sql.append(" where rptnote.FOrgTreeNumber=? ", info.getOrgTreeNumber());
            sql.append(" and FOrgUnitNumber=? ", info.getOrgUnitNumber());
            sql.append(" and rptnote.fyear=? ", info.getYear());
            sql.append(" and rptnote.fperiod=? ", info.getPeriod());
            sql.append(" and rptnote.fperiodtype=? ", info.getPeriodType().getValue());
            sql.append(" and tmp.fid=? ", info.getTemplate().getId().toString());
            sql.append(" and rptnote.FCurrencyId=? ", info.getCurrency().getId().toString());
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
            if (rowSet != null && rowSet.next()) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
        asm.deleteAttachemtsByBoID(pk.toString());
        super._delete(ctx, pk);
    }

    protected void createRptNotes(Context ctx, IObjectPK rptNoteId, IObjectValue model) throws Exception {
        String templateWordPath = null;
        String rptNotesWordPath = null;
        try {
            long time = System.currentTimeMillis();
            boolean isGenerByFile = CSLParamUtil.getBooleanCslParamValue((Context)ctx, (String)"KEY_CSLPARAM_CREATERPTNOTESBYFILE");
            String attchID = null;
            if (!isGenerByFile) {
                byte[] templateContent = this.getTemplate(ctx, rptNoteId, model);
                rptNotesWordPath = this.getFileFullName((ReportNotesInfo)model, isGenerByFile);
                byte[] notesContent = ReportNotesUtil.generateRptNotesWord(ctx, templateWordPath, rptNotesWordPath, (ReportNotesInfo)model, templateContent);
                attchID = ReportNotesUtil.uploadWordFile(ctx, rptNotesWordPath, rptNoteId.toString(), notesContent);
            } else {
                templateWordPath = this.downLoadTemplate(ctx, rptNoteId, model);
                rptNotesWordPath = this.getFileFullName((ReportNotesInfo)model, isGenerByFile);
                ReportNotesUtil.generateRptNotesWord(ctx, templateWordPath, rptNotesWordPath, (ReportNotesInfo)model, null);
                attchID = ReportNotesUtil.uploadWordFile(ctx, rptNotesWordPath, rptNoteId.toString(), null);
            }
            time = System.currentTimeMillis() - time;
            DbUtil.execute(ctx, "update T_CSL_ReportNotes set FWordAttachId=? where fid=?", new Object[]{attchID, rptNoteId.toString()});
        }
        catch (Exception e) {
            try {
                logger.error((Object)"createRptNotes error.", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                ReportNotesUtil.removeFile(templateWordPath);
                ReportNotesUtil.removeFile(rptNotesWordPath);
                throw throwable;
            }
        }
        ReportNotesUtil.removeFile(templateWordPath);
        ReportNotesUtil.removeFile(rptNotesWordPath);
    }

    protected String getFileFullName(ReportNotesInfo info, boolean isGenerByFile) throws Exception {
        File file;
        StringBuffer fileName = new StringBuffer();
        String yearName = EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51.Year");
        String periodName = EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51.Period");
        fileName.append(System.getProperty("EAS_INSTANCE_HOME")).append(File.separator);
        fileName.append(info.getCompany().getName()).append("-").append(info.getName()).append("(").append(info.getNumber()).append(")-");
        fileName.append(info.getPeriodType()).append("-").append(info.getYear()).append(yearName).append(info.getPeriod()).append(periodName);
        fileName.append("-").append(info.getCurrency().getName()).append(".docx");
        if (isGenerByFile && (file = new File(fileName.toString())).exists()) {
            fileName.insert(fileName.length() - 5, System.currentTimeMillis());
        }
        return fileName.toString();
    }

    protected String downLoadTemplate(Context ctx, IObjectPK rptNoteId, IObjectValue model) throws Exception {
        try {
            ReportNotesInfo info = (ReportNotesInfo)model;
            String temWordAttachId = ReportNotesTemplateFactory.getLocalInstance(ctx).getReportNotesTemplateInfo("select wordAttachId where id='" + info.getTemplate().getId().toString() + "'").getWordAttachId().toString();
            return ReportNotesUtil.downLoadWordForServer(ctx, temWordAttachId, "kd" + info.getName());
        }
        catch (Exception e) {
            logger.error((Object)"downLoadTemplate error.", (Throwable)e);
            throw e;
        }
    }

    protected byte[] getTemplate(Context ctx, IObjectPK rptNoteId, IObjectValue model) throws Exception {
        try {
            ReportNotesInfo info = (ReportNotesInfo)model;
            String temWordAttachId = ReportNotesTemplateFactory.getLocalInstance(ctx).getReportNotesTemplateInfo("select wordAttachId where id='" + info.getTemplate().getId().toString() + "'").getWordAttachId().toString();
            return ReportNotesUtil.getWordContent(ctx, temWordAttachId);
        }
        catch (Exception e) {
            logger.error((Object)"downLoadTemplate error.", (Throwable)e);
            throw e;
        }
    }

    @Override
    protected boolean _updateWordId(Context ctx, String rptNotesId, String wordId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_CSL_ReportNotes set FWordAttachId=?,FLastUpdateUserID=?,FLastUpdateTime=? where fid=? ");
        DbUtil.execute(ctx, sql.toString(), new Object[]{wordId, ctx.getCaller().toString(), ReportNotesUtil.getTime(), rptNotesId});
        AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
        String[] attachIds = asm.getAttachmentIDsByBoID(rptNotesId);
        if (attachIds != null) {
            IBoAttchAsso iBoAttchAsso = BoAttchAssoFactory.getLocalInstance((Context)ctx);
            for (String attachId : attachIds) {
                if (wordId.equals(attachId)) continue;
                iBoAttchAsso.deleteOneAssociation(rptNotesId, attachId);
            }
        }
        this.update_log(ctx, (IObjectPK)new ObjectStringPK(rptNotesId));
        return true;
    }

    @Override
    protected void _updateDescription(Context ctx, String id, String description) throws BOSException, EASBizException {
        String sql = "update T_CSL_ReportNotes set FDescription=? where fid=? ";
        DbUtil.execute(ctx, sql, new Object[]{description, id});
    }

    @Override
    protected void _update_log(Context ctx, IObjectPK pk) throws BOSException {
    }

    public String getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CoreBaseInfo info = this.getValue(ctx, "select periodtype,year,period,number,name,company.name where id='" + pk.toString() + "'");
        if (info != null) {
            return info.toString();
        }
        return super.getLogInfo(ctx, pk);
    }
}

