/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.rptnotes.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesTemplateInfo;
import com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesUtil;
import com.kingdee.eas.fi.newrpt.rptnotes.app.AbstractReportNotesTemplateControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.bireport.bimanager.util.StringUtils;
import com.kingdee.util.Uuid;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class ReportNotesTemplateControllerBean
extends AbstractReportNotesTemplateControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.rptnotes.app.ReportNotesTemplateControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ReportNotesTemplateInfo info = (ReportNotesTemplateInfo)model;
        if (StringUtils.isEmpty((String)info.getGroup())) {
            info.setGroup(Uuid.create().toString());
        }
        if (info.getVersionNumber() < 0) {
            info.setVersionNumber(1);
        }
        return super._addnew(ctx, (IObjectValue)info);
    }

    @Override
    protected byte[] _getInitTemplate(Context ctx) throws BOSException, EASBizException {
        InputStream is = null;
        try {
            is = ReportNotesTemplateControllerBean.class.getResourceAsStream("rptNotesTemplate.docx");
            int iAvail = is.available();
            byte[] bytes = new byte[iAvail];
            is.read(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        catch (Exception e) {
            logger.error((Object)"_getInitTemplate error.", (Throwable)e);
            throw new BOSException("_getInitTemplate error.", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.error((Object)"is.close error.", (Throwable)e);
                    throw new BOSException("_getInitTemplate error.", (Throwable)e);
                }
            }
        }
    }

    @Override
    protected boolean _updateWordId(Context ctx, String templateId, String wordId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_CSL_ReportNotesTemplate set FWordAttachId=?,FLastUpdateUserID=?,FLastUpdateTime=? where fid=? ");
        DbUtil.execute(ctx, sql.toString(), new Object[]{wordId, ctx.getCaller().toString(), ReportNotesUtil.getTime(), templateId});
        AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
        String[] attachIds = asm.getAttachmentIDsByBoID(templateId);
        if (attachIds != null) {
            IBoAttchAsso iBoAttchAsso = BoAttchAssoFactory.getLocalInstance((Context)ctx);
            for (String attachId : attachIds) {
                if (wordId.equals(attachId)) continue;
                iBoAttchAsso.deleteOneAssociation(templateId, attachId);
            }
        }
        this.update_log(ctx, (IObjectPK)new ObjectStringPK(templateId));
        return true;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_CSL_ReportNotesTemplate set FVersionStatus=? where fid in(");
        sql.append(" select preTmp.fid from T_CSL_ReportNotesTemplate curTmp ");
        sql.append(" inner join T_CSL_ReportNotesTemplate preTmp on preTmp.fgroup=curTmp.fgroup and preTmp.fversionnumber=curTmp.fversionNumber-1 ");
        sql.append(" where curTmp.fid=? ) ");
        DbUtil.execute(ctx, sql.toString(), new Object[]{1, pk.toString()});
        super._delete(ctx, pk);
        AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
        asm.deleteAttachemtsByBoID(pk.toString());
        this.update_log(ctx, pk);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        String name = ((ReportNotesTemplateInfo)model).getName();
        StringBuffer sql = new StringBuffer();
        sql.append("update T_CSL_ReportNotesTemplate set fname=? where fgroup in (");
        sql.append("select fgroup from T_CSL_ReportNotesTemplate where fid=? and fname<>? )");
        DbUtil.execute(ctx, sql.toString(), new Object[]{name, pk.toString(), name});
        super._update(ctx, pk, model);
    }

    public String getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CoreBaseInfo info = this.getValue(ctx, pk);
        if (info != null) {
            return info.toString();
        }
        return super.getLogInfo(ctx, pk);
    }

    @Override
    protected void _update_log(Context ctx, IObjectPK pk) throws BOSException {
    }
}

