/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.stat;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.BookFormulaHelper;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.fi.newrpt.stat.AbstractBookCheck;
import com.kingdee.eas.fi.newrpt.stat.Limit;
import com.kingdee.eas.fi.newrpt.stat.StatisticalResult;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import java.util.Map;

public class BookFormulaCheck
extends AbstractBookCheck {
    private IObjectValue editData;

    public BookFormulaCheck(Book book, Map<String, Limit> limitMap, IObjectValue editData) {
        super(book, limitMap);
        this.editData = editData;
    }

    @Override
    public StatisticalResult check() {
        if (this.isDynaReport()) {
            return this.checkDynaReport();
        }
        int formulaCount = this.getStatCount(2);
        StatisticalResult statisticalResult = new StatisticalResult();
        if (formulaCount > this.limit.max) {
            String str = this.limit.max + "";
            if (this.limit.max > 10000) {
                str = this.limit.max / 10000 + this.getString("wan");
            }
            statisticalResult.setMessage(this.getString("formulaCheck001", new Object[]{str}));
            statisticalResult.setPassCheck(false);
            StringBuffer detailMsg = new StringBuffer();
            detailMsg.append(this.getString("formulaCheck002")).append(formulaCount).append("\r\n");
            detailMsg.append(this.getString("formulaCheck003")).append(this.getStatCount(3)).append("\r\n");
            detailMsg.append(this.getString("formulaCheck004")).append(this.getStatCount(4)).append("\r\n");
            Map map = this.getFunctionMap();
            for (Map.Entry entry : map.entrySet()) {
                Object key = entry.getKey();
                if (BookFormulaHelper.All_Expr == key || BookFormulaHelper.All_Function == key || BookFormulaHelper.Biz_Function == key || BookFormulaHelper.Excel_Function == key) continue;
                Integer value = (Integer)entry.getValue();
                detailMsg.append(key.toString() + ": " + value).append("\r\n");
            }
            statisticalResult.setDetailMessage(detailMsg.toString());
        }
        if (formulaCount > this.limit.min && formulaCount <= this.limit.max) {
            statisticalResult.setMessage(this.getString("formulaCheck005"));
            statisticalResult.setPassCheck(true);
        }
        if (formulaCount <= this.limit.min) {
            statisticalResult.setPassCheck(true);
        }
        statisticalResult.setRunBack(true);
        return statisticalResult;
    }

    private boolean isDynaReport() {
        ReportBaseInfo report;
        RptSrcTypeEnum srcTypeEnum;
        boolean isDynaReport = false;
        if (this.editData != null && this.editData instanceof ReportBaseInfo && (srcTypeEnum = (report = (ReportBaseInfo)this.editData).getSourceType()) != null && (srcTypeEnum.getValue() == 10 || srcTypeEnum.getValue() == 11 || srcTypeEnum.getValue() == 12)) {
            isDynaReport = true;
        }
        return isDynaReport;
    }

    @Override
    protected Limit initLimit() {
        return (Limit)this.limitMap.get("BookStat_Formula_Limit");
    }

    private StatisticalResult checkDynaReport() {
        StatisticalResult statisticalResult = new StatisticalResult();
        statisticalResult.setPassCheck(true);
        statisticalResult.setRunBack(true);
        return statisticalResult;
    }
}

