/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.stat;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.newrpt.stat.AbstractBookCheck;
import com.kingdee.eas.fi.newrpt.stat.BookCellCheck;
import com.kingdee.eas.fi.newrpt.stat.BookFormulaCheck;
import com.kingdee.eas.fi.newrpt.stat.BookSheetCheck;
import com.kingdee.eas.fi.newrpt.stat.Limit;
import com.kingdee.eas.fi.newrpt.stat.StatisticalResult;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public final class BookStatHelper {
    private static final Logger logger = Logger.getLogger(BookStatHelper.class);
    public static final int TYPE_CAL = 0;
    public static final int TYPE_SAVE = 1;
    protected static final String KEY_FORMULA = "BookStat_Formula_Limit";
    protected static final String KEY_CELL = "BookStat_Cell_Limit";
    protected static final String KEY_SHEET = "BookStat_Sheet_Limit";
    private static final Limit LIMIT_FORMULA = new Limit(100000, 1000000);
    private static final Limit LIMIT_CELL = new Limit(1000000, 5000000);
    private static final Limit LIMIT_SHEET = new Limit(25, 50);
    private static final Map<String, Limit> limitMap = new HashMap<String, Limit>(4);

    private BookStatHelper() {
    }

    private static void loadBookStatLimit() {
        try {
            String[] keys = new String[]{KEY_FORMULA, KEY_CELL, KEY_SHEET};
            Object[] values = CSLParamUtil.batchGetCslParam(null, (String[])keys);
            Limit limit = null;
            for (int i = 0; i < keys.length; ++i) {
                String[] s = values[i].toString().trim().split(",");
                limit = new Limit(Integer.valueOf(s[0]), Integer.valueOf(s[1]));
                limitMap.put(keys[i], limit);
            }
        }
        catch (Exception e) {
            logger.info((Object)"load BookStat Limit error, use default");
        }
    }

    public static StatisticalResult statBook(IObjectValue editData, Book book, int type) {
        if (editData == null || book == null) {
            return new StatisticalResult();
        }
        StatisticalResult result = null;
        if (editData instanceof ReportBaseInfo || editData instanceof TemplateInfo) {
            BookStatHelper.loadBookStatLimit();
            AbstractBookCheck bookCheck = null;
            bookCheck = type == 1 ? (editData instanceof ReportBaseInfo ? new BookCellCheck(book, limitMap) : new BookSheetCheck(book, limitMap)) : new BookFormulaCheck(book, limitMap, editData);
            result = bookCheck.check();
        }
        if (result == null) {
            result = new StatisticalResult();
        }
        return result;
    }

    static {
        limitMap.put(KEY_SHEET, LIMIT_SHEET);
        limitMap.put(KEY_CELL, LIMIT_CELL);
        limitMap.put(KEY_FORMULA, LIMIT_FORMULA);
    }
}

