/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.InsertType;
import com.kingdee.bos.ctrl.excel.model.struct.PasteMode;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.newrpt.AnalysisIndexEvalValueCollection;
import com.kingdee.eas.fi.newrpt.AnalysisIndexEvalValueFactory;
import com.kingdee.eas.fi.newrpt.AnalysisIndexEvalValueInfo;
import com.kingdee.eas.fi.newrpt.AnalysisOrgIndexValueFactory;
import com.kingdee.eas.fi.newrpt.AnalysisOrgUnitCollection;
import com.kingdee.eas.fi.newrpt.AnalysisOrgUnitFactory;
import com.kingdee.eas.fi.newrpt.AnalysisOrgUnitInfo;
import com.kingdee.eas.fi.newrpt.AnalysisReportNewCollection;
import com.kingdee.eas.fi.newrpt.AnalysisReportNewFactory;
import com.kingdee.eas.fi.newrpt.AnalysisReportNewInfo;
import com.kingdee.eas.fi.newrpt.AnalysisRptTypeEnum;
import com.kingdee.eas.fi.newrpt.AnalysisSolutionForBmkInfo;
import com.kingdee.eas.fi.newrpt.IndustryCollection;
import com.kingdee.eas.fi.newrpt.IndustryFactory;
import com.kingdee.eas.fi.newrpt.IndustryInfo;
import com.kingdee.eas.fi.newrpt.IndustryOrgUnitMappingCollection;
import com.kingdee.eas.fi.newrpt.IndustryOrgUnitMappingFactory;
import com.kingdee.eas.fi.newrpt.IndustryOrgUnitMappingInfo;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.client.report.AnalysisRptProcessNewListener;
import com.kingdee.eas.fi.newrpt.formula.ReportCalculateContext;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.fi.newrpt.report.AnalysisRptNewPropertyAdapter;
import com.kingdee.eas.fi.newrpt.report.VariablesHelper;
import com.kingdee.eas.fi.newrpt.util.AnalysisTypeColIndex;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AnalysisRptNewUtil {
    private static Logger logger = Logger.getLogger(AnalysisRptNewUtil.class);
    private static String split = "##caso##";

    public static void fillAndCalSheetByIndustryCompany(Book book, AnalysisReportNewInfo reportInfo, AnalysisRptNewPropertyAdapter reportAdapter) throws Exception {
        boolean isAutoCal = book.isAutoCalculate();
        try {
            book.setAutoCalculate(false);
            book.getUndoManager().startGroup();
            book.getUndoManager().enable(false);
            book.setSkipListeners(true);
            AnalysisRptProcessNewListener.setListener((boolean)false);
            AnalysisRptNewUtil.initIndustry(reportInfo);
            Sheet[] templateSheets = AnalysisRptNewUtil.getTemplateAnalysisAndCompanySheet(book, reportInfo.getAnalysisRptType(), reportInfo.getYear());
            if (templateSheets == null || templateSheets.length != 3) {
                return;
            }
            HashMap<String, List<AnalysisOrgUnitInfo>[]> analysisOrgUnits = new HashMap<String, List<AnalysisOrgUnitInfo>[]>();
            if (!AnalysisRptNewUtil.insertCompanySheet(book, reportInfo, analysisOrgUnits, templateSheets)) {
                return;
            }
            Map<String, AnalysisTypeColIndex> analysisTypeColMap = AnalysisRptNewUtil.getAnalysisTypeColIndexMap(book, reportInfo.getAnalysisRptType());
            if (analysisTypeColMap == null || analysisTypeColMap.isEmpty()) {
                return;
            }
            if (!AnalysisRptNewUtil.initIndexValue(book, reportInfo, analysisTypeColMap)) {
                return;
            }
            AnalysisRptNewUtil.handleCompanyRowOrCol(book, reportInfo, analysisOrgUnits, analysisTypeColMap, templateSheets[1].getSheetName());
            if (reportInfo.getAnalysisRptType().equals((Object)AnalysisRptTypeEnum.BENHMARKING)) {
                AnalysisRptNewUtil.initIndustry(book, reportInfo.getSolution().getIndustry(), analysisTypeColMap, reportInfo.getYear());
            }
            if (reportInfo.getAnalysisRptType().equals((Object)AnalysisRptTypeEnum.SOCREANALYSIS)) {
                AnalysisRptNewUtil.initCompanySocreValue(book, analysisTypeColMap, reportInfo.getYear());
            }
            AnalysisRptNewUtil.calculate(book, reportInfo.getYear(), reportAdapter);
            AnalysisRptNewUtil.setBackGroundColor(book, analysisTypeColMap, reportInfo.getAnalysisRptType());
            analysisTypeColMap.clear();
            if (analysisOrgUnits != null) {
                analysisOrgUnits.clear();
            }
        }
        catch (Exception e) {
            logger.error((Object)"fillAndCalSheetByIndustryCompany error", (Throwable)e);
            throw e;
        }
        finally {
            if (book.getSheetByName("defaultSheet") != null) {
                book.getSheetByName("defaultSheet").setHide(true);
            }
            book.setAutoCalculate(isAutoCal);
            AnalysisRptProcessNewListener.setListener((boolean)true);
            book.getUndoManager().endGroup();
            book.getUndoManager().enable(true);
            book.setSkipListeners(false);
        }
    }

    public static void initIndustry(AnalysisReportNewInfo reportInfo) throws Exception {
        HashMap<String, AnalysisSolutionForBmkInfo> industryMap = new HashMap<String, AnalysisSolutionForBmkInfo>();
        if (reportInfo.getAnalysisRptType().equals((Object)AnalysisRptTypeEnum.SOCREANALYSIS)) {
            for (AnalysisSolutionForBmkInfo info : reportInfo.getSolutionList()) {
                industryMap.put(info.getIndustry().getId().toString(), info);
            }
        } else {
            industryMap.put(reportInfo.getSolution().getIndustry().getId().toString(), reportInfo.getSolution());
        }
        IndustryCollection coll = IndustryFactory.getRemoteInstance().getIndustryCollection("select id,number,name where id in(" + CslRptUtil.changeIdSet2String(industryMap.keySet()) + ")");
        for (int i = 0; i < coll.size(); ++i) {
            ((AnalysisSolutionForBmkInfo)industryMap.get(coll.get(i).getId().toString())).setIndustry(coll.get(i));
        }
        industryMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean insertCompanySheet(Book book, AnalysisReportNewInfo reportInfo, Map<String, List<AnalysisOrgUnitInfo>[]> analysisOrgUnits, Sheet[] templateSheets) throws Exception {
        ArrayList<String> solutionIds = new ArrayList<String>();
        HashMap<String, AnalysisSolutionForBmkInfo> solutionMap = new HashMap<String, AnalysisSolutionForBmkInfo>();
        ReportVariables v2 = ReportVariables.loadFromBook((Book)book);
        try {
            boolean isSocre = AnalysisRptTypeEnum.SOCREANALYSIS.equals((Object)reportInfo.getAnalysisRptType());
            AnalysisSolutionForBmkInfo solution = null;
            if (isSocre) {
                List<AnalysisSolutionForBmkInfo> solutionList = reportInfo.getSolutionList();
                Iterator<AnalysisSolutionForBmkInfo> iterator = solutionList.iterator();
                while (iterator.hasNext()) {
                    AnalysisSolutionForBmkInfo curSolution = iterator.next();
                    solutionIds.add(curSolution.getId().toString());
                    solutionMap.put(curSolution.getId().toString(), curSolution);
                }
                analysisOrgUnits.putAll(AnalysisRptNewUtil.getSolutionAnalysisOrgUnitMap(solutionIds));
            } else {
                solution = reportInfo.getSolution();
                solutionIds.add(solution.getId().toString());
                solutionMap.put(solution.getId().toString(), solution);
                Map<String, List<AnalysisOrgUnitInfo>[]> map = analysisOrgUnits;
                analysisOrgUnits = AnalysisRptNewUtil.getSolutionAnalysisOrgUnitMap(solutionIds);
                map.putAll(analysisOrgUnits);
            }
            for (String solutionId : solutionIds) {
                AnalysisRptNewUtil.insertTemplateSheet(book, reportInfo, analysisOrgUnits, (AnalysisSolutionForBmkInfo)solutionMap.get(solutionId), templateSheets, v2);
            }
            Sheet curSheet = templateSheets[0];
            curSheet = new Sheet(book, reportInfo.getAnalysisRptType().equals((Object)AnalysisRptTypeEnum.BENHMARKING) ? EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"119_AnalysisRptProcessNewUI") : EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"157_AnalysisRptNewUtil"));
            curSheet.copySheetFrom(templateSheets[0], false);
            curSheet.setUserObject("industryKey", (Object)(isSocre ? reportInfo.getSolutionList().get(0).getIndustry().getNumber() : solution.getIndustry().getNumber()));
            book.insertSheet(0, curSheet);
            if (v2.get("isAnalysis", curSheet.getSheetName()) == null) {
                v2.add(VariablesHelper.createReservedEntry("isAnalysis", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"110_AnalysisRptProcessNewUI"), curSheet.getSheetName(), "", 1));
            }
            v2.get("isAnalysis", curSheet.getSheetName()).setValue("1");
        }
        finally {
            solutionIds.clear();
            solutionMap.clear();
        }
        return true;
    }

    public static void initBenhmarkingOrgUnitData(Book book, int year) throws Exception {
        boolean isAutoCal = book.isAutoCalculate();
        try {
            book.setAutoCalculate(false);
            book.getUndoManager().startGroup();
            book.getUndoManager().enable(false);
            book.setSkipListeners(true);
            AnalysisRptProcessNewListener.setListener((boolean)false);
            AnalysisReportNewInfo templateInfo = null;
            try {
                templateInfo = AnalysisReportNewFactory.getRemoteInstance().getAnalysisReportNewInfo("select data where year=" + year + " and analysisRptType=" + 6);
            }
            catch (Exception ex) {
                logger.error((Object)"getAnalysisReportNewInfo error", (Throwable)ex);
            }
            if (templateInfo == null) {
                AnalysisReportNewCollection coll = AnalysisReportNewFactory.getRemoteInstance().getAnalysisReportNewCollection("select data where year<=" + year + " and analysisRptType=" + 6 + " order by year desc ");
                if (coll != null && coll.size() > 0) {
                    templateInfo = coll.get(0);
                } else {
                    return;
                }
            }
            for (int j = book.getSheetCount() - 1; j > 0; --j) {
                book.removeSheet(j);
            }
            book.getSheet(0).setName("templateDefaultSheet");
            String templateDefaultSheet = "templateDefaultSheet";
            Book tmpBook = templateInfo.getBook();
            Sheet sheet = null;
            for (int i = 0; i < tmpBook.getSheetCount(); ++i) {
                sheet = new Sheet(book, tmpBook.getSheet(i).getSheetName());
                sheet.copySheetFrom(tmpBook.getSheet(i), false);
                book.insertSheet(0, sheet);
            }
            book.removeSheet(templateDefaultSheet);
        }
        catch (Exception e) {
            logger.error((Object)"initBenhmarkingOrgUnitData error", (Throwable)e);
            throw e;
        }
        finally {
            book.removeSheet("defaultSheet");
            book.setAutoCalculate(isAutoCal);
            AnalysisRptProcessNewListener.setListener((boolean)true);
            book.getUndoManager().endGroup();
            book.getUndoManager().enable(true);
            book.setSkipListeners(false);
        }
    }

    private static void initCompanySocreValue(Book book, Map<String, AnalysisTypeColIndex> analysisTypeColMap, int year) throws Exception {
        Sheet sheet = null;
        String companyId = null;
        HashMap<String, String> companyId_Sheets = new HashMap<String, String>();
        for (String sheetName : analysisTypeColMap.keySet()) {
            sheet = book.getSheetByName(sheetName);
            companyId = (String)sheet.getUserObjectValue("companyKey");
            if (companyId == null) continue;
            companyId_Sheets.put(companyId, sheetName);
        }
        if (!companyId_Sheets.isEmpty()) {
            String curSheetName = null;
            ArrayList companyIds = new ArrayList();
            companyIds.addAll(companyId_Sheets.keySet());
            Map orgIndexValue = AnalysisOrgIndexValueFactory.getRemoteInstance().getOrgIndexValue(String.valueOf(year), companyIds);
            companyIds.clear();
            Map keyIndexValues = null;
            AnalysisTypeColIndex analysisTypeColIndex = null;
            String keyIndexNumber = null;
            if (orgIndexValue != null && !orgIndexValue.isEmpty()) {
                for (Object curCompanyId : orgIndexValue.keySet()) {
                    keyIndexValues = (Map)orgIndexValue.get(curCompanyId);
                    companyId = (String)curCompanyId;
                    curSheetName = (String)companyId_Sheets.get(companyId);
                    sheet = book.getSheetByName(curSheetName);
                    analysisTypeColIndex = analysisTypeColMap.get(curSheetName);
                    for (int i = analysisTypeColIndex.getKeyIndexStartRow(); i <= sheet.getMaxRowIndex(); ++i) {
                        keyIndexNumber = AnalysisRptNewUtil.getCellKeyIndexNumber(sheet.getCell(i, analysisTypeColIndex.getKeyIndexCol(), true));
                        if (StringUtils.isEmpty((String)keyIndexNumber)) continue;
                        sheet.getCell(i, analysisTypeColIndex.getKeyIndexValueCol(), true).setValue(new Variant(keyIndexValues.get(keyIndexNumber)));
                    }
                }
                orgIndexValue.clear();
            }
        }
    }

    private static void initIndustry(Book book, IndustryInfo industryInfo, Map<String, AnalysisTypeColIndex> analysisTypeColMap, int year) throws Exception {
        if (industryInfo != null) {
            Sheet curSheet = null;
            AnalysisTypeColIndex analysisTypeColIndex = null;
            for (String sheetName : analysisTypeColMap.keySet()) {
                curSheet = book.getSheetByName(sheetName);
                analysisTypeColIndex = analysisTypeColMap.get(sheetName);
                curSheet.getCell(analysisTypeColIndex.getIndustryRow(), analysisTypeColIndex.getIndustryCol(), true).setValue(new Variant((Object)(year + EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"113_AnalysisRptProcessNewUI") + industryInfo.getName() + EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"158_AnalysisRptNewUtil"))));
            }
        }
    }

    public static boolean setBackGroundColor(Book book, Map<String, AnalysisTypeColIndex> analysisTypeColMap, AnalysisRptTypeEnum analysisRptType) throws Exception {
        Sheet curSheet = null;
        AnalysisTypeColIndex analysisTypeColIndex = null;
        SortedCellBlockArray blockArray = new SortedCellBlockArray();
        CellBlock block = null;
        for (String sheetName : analysisTypeColMap.keySet()) {
            analysisTypeColIndex = analysisTypeColMap.get(sheetName);
            curSheet = book.getSheetByName(sheetName);
            if (curSheet.getUserObjectValue("industryKey") == null) continue;
            block = analysisRptType.equals((Object)AnalysisRptTypeEnum.BENHMARKING) ? CellBlock.getNewCellBlock((int)analysisTypeColIndex.getScoreRow(), (int)analysisTypeColIndex.getCompanyCol(), (int)curSheet.getMaxRowIndex(), (int)curSheet.getMaxColIndex()) : CellBlock.getNewCellBlock((int)analysisTypeColIndex.getCompanyRow(), (int)AnalysisRptNewUtil.getSocreValueCol(analysisTypeColIndex), (int)curSheet.getMaxRowIndex(), (int)AnalysisRptNewUtil.getSocreValueCol(analysisTypeColIndex));
            blockArray.insert((Object)block);
            AnalysisRptNewUtil.autoSetBackGround(blockArray, curSheet, analysisRptType);
        }
        return true;
    }

    public static int getSocreValueCol(AnalysisTypeColIndex analysisTypeColIndex) {
        return analysisTypeColIndex.getCompanyCol() + 8;
    }

    public static boolean calculate(Book book, int year, AnalysisRptNewPropertyAdapter reportAdapter) throws Exception {
        reportAdapter.setProperties("Report.Year", year);
        reportAdapter.setProperties("PeriodType", 3);
        book.calc();
        return true;
    }

    public static boolean handleCompanyRowOrCol(Book book, AnalysisReportNewInfo reportInfo, Map<String, List<AnalysisOrgUnitInfo>[]> analysisOrgUnits, Map<String, AnalysisTypeColIndex> analysisTypeColMap, String templateCompanySheetName) throws Exception {
        boolean isSocreAnalysis = AnalysisRptTypeEnum.SOCREANALYSIS.equals((Object)reportInfo.getAnalysisRptType());
        Sheet curSheet = null;
        AnalysisTypeColIndex analysisTypeColIndex = null;
        int startRowOrCol = -1;
        for (String sheetName : analysisTypeColMap.keySet()) {
            analysisTypeColIndex = analysisTypeColMap.get(sheetName);
            curSheet = book.getSheetByName(sheetName);
            if (isSocreAnalysis && (!isSocreAnalysis || curSheet.getUserObjectValue("industryKey") == null)) continue;
            int n = startRowOrCol = isSocreAnalysis ? analysisTypeColIndex.getCompanyRow() : analysisTypeColIndex.getCompanyCol();
            if (isSocreAnalysis) {
                for (AnalysisSolutionForBmkInfo solution : reportInfo.getSolutionList()) {
                    if (startRowOrCol >= 0) {
                        startRowOrCol = AnalysisRptNewUtil.handleCompanyColOrRow(book, curSheet, analysisTypeColIndex, reportInfo, analysisOrgUnits, solution, templateCompanySheetName, startRowOrCol);
                        continue;
                    }
                    return false;
                }
            } else {
                startRowOrCol = AnalysisRptNewUtil.handleCompanyColOrRow(book, curSheet, analysisTypeColIndex, reportInfo, analysisOrgUnits, reportInfo.getSolution(), templateCompanySheetName, startRowOrCol);
            }
            if (startRowOrCol < 0) continue;
            UserObjectHelper.getUnprotectedRange((Range)(isSocreAnalysis ? curSheet.getRange(startRowOrCol, analysisTypeColIndex.getCompanyCol(), startRowOrCol, analysisTypeColIndex.getExcellentValueCol() - 3) : curSheet.getColRange(startRowOrCol, startRowOrCol))).delete(true);
        }
        return true;
    }

    public static int handleCompanyColOrRow(Book book, Sheet curSheet, AnalysisTypeColIndex analysisTypeColIndex, AnalysisReportNewInfo reportInfo, Map<String, List<AnalysisOrgUnitInfo>[]> analysisOrgUnits, AnalysisSolutionForBmkInfo solution, String templateCompanySheetName, int startRowOrCol) throws Exception {
        List<AnalysisOrgUnitInfo> simpleAnalysisOrgUnits = analysisOrgUnits.get(solution.getId().toString())[0];
        List<AnalysisOrgUnitInfo> complexAnalysisOrgUnits = analysisOrgUnits.get(solution.getId().toString())[1];
        String formula = null;
        AnalysisRptTypeEnum analysisRptType = reportInfo.getAnalysisRptType();
        boolean isSocreAnalysis = AnalysisRptTypeEnum.SOCREANALYSIS.equals((Object)analysisRptType);
        String[] bhmkOrgUnits = null;
        if (!isSocreAnalysis) {
            bhmkOrgUnits = AnalysisRptNewUtil.getBhmkOrgUnits(solution.getBenhmarkingOrgUnit());
        }
        List periods = reportInfo.getPeriods();
        int rowOrCols = 0;
        rowOrCols = (simpleAnalysisOrgUnits != null ? simpleAnalysisOrgUnits.size() : 0) + rowOrCols;
        rowOrCols = (complexAnalysisOrgUnits != null && !complexAnalysisOrgUnits.isEmpty() ? 1 : 0) + rowOrCols;
        if (!isSocreAnalysis) {
            if (reportInfo.getPeriods() != null && !reportInfo.getPeriods().isEmpty()) {
                rowOrCols *= reportInfo.getPeriods().size();
            }
            rowOrCols = (bhmkOrgUnits != null ? bhmkOrgUnits.length : 0) + rowOrCols;
        }
        if (rowOrCols > 0) {
            int row = -1;
            int col = -1;
            Cell srcCell = null;
            UserObjectHelper.getUnprotectedRange((Range)(isSocreAnalysis ? curSheet.getRange(startRowOrCol, analysisTypeColIndex.getCompanyCol(), startRowOrCol + rowOrCols - 1, analysisTypeColIndex.getExcellentValueCol() - 3) : curSheet.getColRange(startRowOrCol, startRowOrCol + rowOrCols - 1))).insert(isSocreAnalysis, InsertType.NOSTYLE);
            for (int i = (isSocreAnalysis ? analysisTypeColIndex.getIndustryCol() : analysisTypeColIndex.getCompanyRow()) + 1; i < (isSocreAnalysis ? analysisTypeColIndex.getExcellentValueCol() - 3 : curSheet.getMaxRowIndex()); ++i) {
                for (int j = startRowOrCol; j < startRowOrCol + rowOrCols; ++j) {
                    row = isSocreAnalysis ? j : i;
                    col = isSocreAnalysis ? i : j;
                    srcCell = curSheet.getCell(isSocreAnalysis ? startRowOrCol + rowOrCols : row, isSocreAnalysis ? col : startRowOrCol + rowOrCols, true);
                    formula = srcCell.getFormula();
                    if (StringUtils.isEmpty((String)formula)) continue;
                    curSheet.getCell(row, col, true).setFormula(formula);
                    curSheet.getCell(row, col, true).setSSA(srcCell.getSSA());
                }
            }
            UserObjectHelper.getUnprotectedRange((Range)(isSocreAnalysis ? curSheet.getRange(startRowOrCol + rowOrCols, analysisTypeColIndex.getCompanyCol(), startRowOrCol + rowOrCols, analysisTypeColIndex.getExcellentValueCol() - 3) : curSheet.getColRange(startRowOrCol + rowOrCols, startRowOrCol + rowOrCols))).copy();
            UserObjectHelper.getUnprotectedRange((Range)(isSocreAnalysis ? curSheet.getRange(startRowOrCol, analysisTypeColIndex.getCompanyCol(), startRowOrCol + rowOrCols - 1, analysisTypeColIndex.getExcellentValueCol() - 3) : curSheet.getColRange(startRowOrCol, startRowOrCol + rowOrCols - 1))).paste(new PasteMode(PasteMode.All & ~PasteMode.Formulas), new String[]{"ITEM"});
            int index = 0;
            String period = null;
            if (simpleAnalysisOrgUnits != null && !simpleAnalysisOrgUnits.isEmpty()) {
                for (AnalysisOrgUnitInfo analysisOrgUnit : simpleAnalysisOrgUnits) {
                    if (!isSocreAnalysis && periods != null && !periods.isEmpty()) {
                        for (Object curPeriod : periods) {
                            period = String.valueOf(curPeriod);
                            AnalysisRptNewUtil.handleCellSheetDepend(book, curSheet, analysisTypeColIndex, AnalysisRptNewUtil.getCompanySheetName(analysisOrgUnit, period, analysisRptType), analysisOrgUnit.getOrgUnit().getId().toString(), null, period, startRowOrCol + index, analysisRptType, templateCompanySheetName);
                            ++index;
                        }
                        continue;
                    }
                    AnalysisRptNewUtil.handleCellSheetDepend(book, curSheet, analysisTypeColIndex, AnalysisRptNewUtil.getCompanySheetName(analysisOrgUnit, "0", analysisRptType), analysisOrgUnit.getOrgUnit().getId().toString(), AnalysisRptNewUtil.getCompanyNameStr(analysisOrgUnit), "0", startRowOrCol + index, analysisRptType, templateCompanySheetName);
                    ++index;
                }
            }
            String curSheetName = null;
            String companyName = null;
            if (complexAnalysisOrgUnits != null && !complexAnalysisOrgUnits.isEmpty()) {
                companyName = AnalysisRptNewUtil.getCompanyNameStr(complexAnalysisOrgUnits).toString();
                if (!isSocreAnalysis && periods != null && !periods.isEmpty()) {
                    for (Object curPeriod : periods) {
                        period = String.valueOf(curPeriod);
                        curSheetName = AnalysisRptNewUtil.getCompanySheetName(complexAnalysisOrgUnits, period, analysisRptType);
                        AnalysisRptNewUtil.handleCellSheetDepend(book, curSheet, analysisTypeColIndex, curSheetName, companyName, null, period, startRowOrCol + index, analysisRptType, templateCompanySheetName);
                        ++index;
                    }
                } else {
                    curSheetName = AnalysisRptNewUtil.getCompanySheetName(complexAnalysisOrgUnits, "0", analysisRptType);
                    AnalysisRptNewUtil.handleCellSheetDepend(book, curSheet, analysisTypeColIndex, curSheetName, companyName, companyName, "0", startRowOrCol + index, analysisRptType, templateCompanySheetName);
                    ++index;
                }
            }
            if (bhmkOrgUnits != null && bhmkOrgUnits.length > 0) {
                for (String bhmkOrgUnit : bhmkOrgUnits) {
                    curSheetName = AnalysisRptNewUtil.getCompanySheetName(bhmkOrgUnit, "0", analysisRptType);
                    AnalysisRptNewUtil.handleCellSheetDepend(book, curSheet, analysisTypeColIndex, curSheetName, bhmkOrgUnit, bhmkOrgUnit, "0", startRowOrCol + index, analysisRptType, templateCompanySheetName);
                    ++index;
                }
            }
            return rowOrCols + startRowOrCol;
        }
        return -1;
    }

    private static void handleCellSheetDepend(Book book, Sheet curSheet, AnalysisTypeColIndex analysisTypeColIndex, String sheetName, String companyKey, String companyName, String period, int curRowOrCol, AnalysisRptTypeEnum analysisRptType, String templateCompanySheetName) throws Exception {
        Cell curCell = null;
        String formula = null;
        boolean isSocreAnalysis = AnalysisRptTypeEnum.SOCREANALYSIS.equals((Object)analysisRptType);
        curCell = curSheet.getCell(isSocreAnalysis ? curRowOrCol : analysisTypeColIndex.getCompanyRow(), isSocreAnalysis ? analysisTypeColIndex.getCompanyCol() : curRowOrCol, true);
        curCell.setValue(new Variant((Object)(isSocreAnalysis ? companyName : sheetName)));
        curCell.setUserObject("companyKey", (Object)companyKey);
        if (!isSocreAnalysis && !StringUtils.isEmpty((String)period) && Integer.valueOf(period) > 0) {
            curSheet.getCell(analysisTypeColIndex.getCompanyRow(), curRowOrCol, true).setUserObject("periodKey", (Object)period);
        }
        if (isSocreAnalysis) {
            if (book.getSheetByName(sheetName) != null && book.getSheetByName(sheetName).getUserObjectValue("sheetIndustryKey") != null) {
                AnalysisSolutionForBmkInfo info = (AnalysisSolutionForBmkInfo)book.getSheetByName(sheetName).getUserObjectValue("sheetIndustryKey");
                curSheet.getCell(curRowOrCol, analysisTypeColIndex.getIndustryCol(), true).setValue(new Variant((Object)info.getIndustry().getName()));
            }
            sheetName = "'" + sheetName + "'";
        }
        for (int rowCol = isSocreAnalysis ? analysisTypeColIndex.getIndustryCol() + 1 : analysisTypeColIndex.getKeyIndexStartRow(); rowCol <= (isSocreAnalysis ? curSheet.getMaxColIndex() : curSheet.getMaxRowIndex()); ++rowCol) {
            curCell = curSheet.getCell(isSocreAnalysis ? curRowOrCol : rowCol, isSocreAnalysis ? rowCol : curRowOrCol, true);
            formula = curCell.getFormula();
            if (StringUtils.isEmpty((String)formula)) continue;
            curCell.setFormula(formula.replaceAll(templateCompanySheetName, sheetName));
        }
    }

    private static boolean initIndexValue(Book book, AnalysisReportNewInfo reportInfo, Map<String, AnalysisTypeColIndex> analysisTypeColMap) throws Exception {
        AnalysisRptTypeEnum analysisRptType = reportInfo.getAnalysisRptType();
        AnalysisIndexEvalValueCollection valueColl = null;
        AnalysisSolutionForBmkInfo solutionInfo = null;
        if (analysisRptType.equals((Object)AnalysisRptTypeEnum.BENHMARKING)) {
            valueColl = AnalysisIndexEvalValueFactory.getRemoteInstance().getAnalysisIndexEvalValueCollection("select industry.number,industryRange,excellentValue,goodValue,averageValue,fairValue,poorValue,keyIndex.number,keyIndex.unit where industry.number='" + reportInfo.getSolution().getIndustry().getNumber() + "' and industryRange=" + reportInfo.getSolution().getIndustryRange().getValue() + " and year=" + reportInfo.getYear());
        } else {
            Object obj = null;
            HashSet<String> keys = new HashSet<String>();
            for (String sheetName : analysisTypeColMap.keySet()) {
                obj = book.getSheetByName(sheetName).getUserObjectValue("sheetIndustryKey");
                if (obj == null || !(obj instanceof AnalysisSolutionForBmkInfo)) continue;
                keys.add(((AnalysisSolutionForBmkInfo)obj).getIndustry().getNumber() + "@@" + ((AnalysisSolutionForBmkInfo)obj).getIndustryRange().getValue());
            }
            StringBuffer sql = new StringBuffer();
            String[] tmpKey = null;
            for (String key : keys) {
                if (sql.length() > 0) {
                    sql.append(" or ");
                }
                tmpKey = key.split("@@");
                sql.append(" industry.number='").append(tmpKey[0]).append("' and industryRange=").append(tmpKey[1]);
            }
            keys.clear();
            valueColl = AnalysisIndexEvalValueFactory.getRemoteInstance().getAnalysisIndexEvalValueCollection("select industry.number,industryRange,excellentValue,goodValue,averageValue,fairValue,poorValue,keyIndex.number,keyIndex.unit where year=" + reportInfo.getYear() + " and (" + sql.toString() + ")");
        }
        HashMap valueMap = new HashMap();
        AnalysisIndexEvalValueInfo info = null;
        BigDecimal unit = null;
        Map indexValueMap = null;
        String key = null;
        for (int j = 0; j < valueColl.size(); ++j) {
            info = valueColl.get(j);
            key = info.getIndustry().getNumber() + "@@" + info.getIndustryRange().getValue();
            indexValueMap = (HashMap<String, BigDecimal[]>)valueMap.get(key);
            if (indexValueMap == null) {
                indexValueMap = new HashMap<String, BigDecimal[]>();
                valueMap.put(key, indexValueMap);
            }
            if (indexValueMap.containsKey(info.getKeyIndex().getNumber())) continue;
            if (analysisRptType.equals((Object)AnalysisRptTypeEnum.BENHMARKING)) {
                unit = info.getKeyIndex().getUnit();
                indexValueMap.put(info.getKeyIndex().getNumber(), new BigDecimal[]{info.getExcellentValue().divide(unit), info.getGoodValue().divide(unit), info.getAverageValue().divide(unit), info.getFairValue().divide(unit), info.getPoorValue().divide(unit)});
                continue;
            }
            indexValueMap.put(info.getKeyIndex().getNumber(), new BigDecimal[]{info.getExcellentValue(), info.getGoodValue(), info.getAverageValue(), info.getFairValue(), info.getPoorValue()});
        }
        valueColl.clear();
        Sheet curSheet = null;
        AnalysisTypeColIndex analysisTypeColIndex = null;
        String keyIndexNumber = null;
        BigDecimal[] scoreValues = null;
        for (String sheetName : analysisTypeColMap.keySet()) {
            curSheet = book.getSheetByName(sheetName);
            analysisTypeColIndex = analysisTypeColMap.get(sheetName);
            if (analysisRptType.equals((Object)AnalysisRptTypeEnum.SOCREANALYSIS) && curSheet.getUserObjectValue("companyKey") != null && curSheet.getUserObjectValue("sheetIndustryKey") != null) {
                solutionInfo = (AnalysisSolutionForBmkInfo)curSheet.getUserObjectValue("sheetIndustryKey");
                key = solutionInfo.getIndustry().getNumber() + "@@" + solutionInfo.getIndustryRange().getValue();
            } else {
                if (!analysisRptType.equals((Object)AnalysisRptTypeEnum.BENHMARKING)) continue;
                key = reportInfo.getSolution().getIndustry().getNumber() + "@@" + reportInfo.getSolution().getIndustryRange().getValue();
            }
            if ((indexValueMap = (Map)valueMap.get(key)) == null || indexValueMap.isEmpty()) continue;
            for (int row = analysisTypeColIndex.getKeyIndexStartRow(); row <= curSheet.getMaxRowIndex(); ++row) {
                keyIndexNumber = AnalysisRptNewUtil.getCellKeyIndexNumber(curSheet.getCell(row, analysisTypeColIndex.getKeyIndexCol(), true));
                if (StringUtils.isEmpty((String)keyIndexNumber) || (scoreValues = (BigDecimal[])indexValueMap.get(keyIndexNumber)) == null || scoreValues.length != 5) continue;
                curSheet.getCell(row, analysisTypeColIndex.getExcellentValueCol(), true).setValue(new Variant((Object)scoreValues[0]));
                curSheet.getCell(row, analysisTypeColIndex.getGoodValueCol(), true).setValue(new Variant((Object)scoreValues[1]));
                curSheet.getCell(row, analysisTypeColIndex.getAverageValueCol(), true).setValue(new Variant((Object)scoreValues[2]));
                curSheet.getCell(row, analysisTypeColIndex.getFairValueCol(), true).setValue(new Variant((Object)scoreValues[3]));
                curSheet.getCell(row, analysisTypeColIndex.getPoorValueCol(), true).setValue(new Variant((Object)scoreValues[4]));
            }
        }
        valueMap.clear();
        return true;
    }

    public static Map<String, AnalysisTypeColIndex> getAnalysisTypeColIndexMap(Book book, AnalysisRptTypeEnum analysisRptType) throws Exception {
        Sheet curSheet = null;
        HashMap<String, AnalysisTypeColIndex> sheetId_AnalysisTypeIndex = new HashMap<String, AnalysisTypeColIndex>();
        AnalysisTypeColIndex analysisTypeColIndex = null;
        int analysisType = -1;
        boolean isSocreAnalysis = analysisRptType.equals((Object)AnalysisRptTypeEnum.SOCREANALYSIS);
        boolean isAnalysisSheet = false;
        ReportVariables v = ReportVariables.loadFromBook((Book)book);
        for (int i = 0; i < book.getSheetCount(); ++i) {
            curSheet = book.getSheet(i);
            boolean bl = isAnalysisSheet = v.get("isAnalysis", curSheet.getSheetName()) != null && v.get("isAnalysis", curSheet.getSheetName()).getBoolValue(false);
            if (!isAnalysisSheet && (!isSocreAnalysis || (v.get("isCompany", curSheet.getSheetName()) == null || !v.get("isCompany", curSheet.getSheetName()).getBoolValue(false)) && (v.get("isBhmOrgUnitSheet", curSheet.getSheetName()) == null || !v.get("isBhmOrgUnitSheet", curSheet.getSheetName()).getBoolValue(false)))) continue;
            analysisTypeColIndex = new AnalysisTypeColIndex();
            boolean isFind = true;
            block12: for (int col = 0; col <= curSheet.getMaxColIndex() && !analysisTypeColIndex.isInited(); ++col) {
                for (int row = 0; row <= curSheet.getMaxRowIndex(); ++row) {
                    isFind = true;
                    analysisType = AnalysisRptNewUtil.getCellAnalysisType(curSheet.getCell(row, col, true));
                    switch (analysisType) {
                        case 0: {
                            analysisTypeColIndex.setIndustryCol(col);
                            analysisTypeColIndex.setIndustryRow(row);
                            if (isSocreAnalysis && isAnalysisSheet) break;
                            isFind = false;
                            break;
                        }
                        case 2: {
                            analysisTypeColIndex.setKeyIndexCol(col);
                            analysisTypeColIndex.setKeyIndexStartRow(row);
                            break;
                        }
                        case 1: {
                            analysisTypeColIndex.setCompanyCol(col);
                            analysisTypeColIndex.setCompanyRow(row);
                            break;
                        }
                        case 3: {
                            analysisTypeColIndex.setExcellentValueCol(col);
                            if (isSocreAnalysis && isAnalysisSheet) {
                                analysisTypeColIndex.setExcellentValueRow(row);
                                isFind = false;
                                break;
                            }
                            analysisTypeColIndex.setScoreRow(row);
                            break;
                        }
                        case 4: {
                            analysisTypeColIndex.setGoodValueCol(col);
                            if (isSocreAnalysis && isAnalysisSheet) {
                                analysisTypeColIndex.setGoodValueRow(row);
                                isFind = false;
                                break;
                            }
                            analysisTypeColIndex.setScoreRow(row);
                            break;
                        }
                        case 5: {
                            analysisTypeColIndex.setAverageValueCol(col);
                            if (isSocreAnalysis && isAnalysisSheet) {
                                analysisTypeColIndex.setAverageValueRow(row);
                                isFind = false;
                                break;
                            }
                            analysisTypeColIndex.setScoreRow(row);
                            break;
                        }
                        case 6: {
                            analysisTypeColIndex.setFairValueCol(col);
                            if (isSocreAnalysis && isAnalysisSheet) {
                                analysisTypeColIndex.setFairValueRow(row);
                                isFind = false;
                                break;
                            }
                            analysisTypeColIndex.setScoreRow(row);
                            break;
                        }
                        case 7: {
                            analysisTypeColIndex.setPoorValueCol(col);
                            if (isSocreAnalysis && isAnalysisSheet) {
                                analysisTypeColIndex.setPoorValueRow(row);
                                isFind = false;
                                break;
                            }
                            analysisTypeColIndex.setScoreRow(row);
                            break;
                        }
                        case 8: {
                            analysisTypeColIndex.setKeyIndexValueCol(col);
                            break;
                        }
                        default: {
                            isFind = false;
                        }
                    }
                    if (isFind) continue block12;
                }
            }
            sheetId_AnalysisTypeIndex.put(curSheet.getSheetName(), analysisTypeColIndex);
        }
        return sheetId_AnalysisTypeIndex;
    }

    private static int getCellAnalysisType(Cell cell) throws Exception {
        String analysisType;
        ItemFormula formula;
        if (cell != null && (formula = (ItemFormula)cell.getUserObjectValue("ITEM")) != null && !StringUtils.isEmpty((String)(analysisType = formula.getExt("analysisTypeKey")))) {
            return Integer.valueOf(analysisType);
        }
        return -1;
    }

    private static String getCellKeyIndexNumber(Cell cell) throws Exception {
        ItemFormula formula;
        if (cell != null && (formula = (ItemFormula)cell.getUserObjectValue("ITEM")) != null) {
            return formula.getExt("analysisKeyIndexNumber");
        }
        return null;
    }

    private static boolean insertTemplateSheet(Book book, AnalysisReportNewInfo reportInfo, Map<String, List<AnalysisOrgUnitInfo>[]> analysisOrgUnits, AnalysisSolutionForBmkInfo solution, Sheet[] templateSheets, ReportVariables v2) throws Exception {
        String[] bhmkOrgUnits;
        Sheet templateSheet;
        List<AnalysisOrgUnitInfo> simpleAnalysisOrgUnits = analysisOrgUnits.get(solution.getId().toString())[0];
        List<AnalysisOrgUnitInfo> complexAnalysisOrgUnits = analysisOrgUnits.get(solution.getId().toString())[1];
        boolean isSocreAnalysis = reportInfo.getAnalysisRptType().equals((Object)AnalysisRptTypeEnum.SOCREANALYSIS);
        Sheet sheet = templateSheet = isSocreAnalysis ? templateSheets[1] : templateSheets[2];
        if (!isSocreAnalysis && (bhmkOrgUnits = AnalysisRptNewUtil.getBhmkOrgUnits(solution.getBenhmarkingOrgUnit())) != null && bhmkOrgUnits.length > 0 && templateSheet != null) {
            for (String bhmkOrgUnit : bhmkOrgUnits) {
                if (StringUtils.isEmpty((String)bhmkOrgUnit)) continue;
                AnalysisRptNewUtil.handleBhmkOrgUnitSheet(book, bhmkOrgUnit, reportInfo, "0", templateSheet, v2);
            }
        }
        if (complexAnalysisOrgUnits != null && complexAnalysisOrgUnits.size() > 0) {
            if (reportInfo.getAnalysisRptType().equals((Object)AnalysisRptTypeEnum.BENHMARKING) && reportInfo.getPeriods() != null && !reportInfo.getPeriods().isEmpty()) {
                for (AnalysisOrgUnitInfo period : reportInfo.getPeriods()) {
                    AnalysisRptNewUtil.handleCompanySheet(book, null, String.valueOf(period).trim(), reportInfo.getAnalysisRptType(), templateSheets[1], v2, complexAnalysisOrgUnits, solution);
                }
            } else {
                AnalysisRptNewUtil.handleCompanySheet(book, null, "0", reportInfo.getAnalysisRptType(), templateSheets[1], v2, complexAnalysisOrgUnits, solution);
            }
        }
        for (AnalysisOrgUnitInfo simpleAnalysisOrgUnit : simpleAnalysisOrgUnits) {
            if (reportInfo.getAnalysisRptType().equals((Object)AnalysisRptTypeEnum.BENHMARKING) && reportInfo.getPeriods() != null && !reportInfo.getPeriods().isEmpty()) {
                for (Object period : reportInfo.getPeriods()) {
                    AnalysisRptNewUtil.handleCompanySheet(book, simpleAnalysisOrgUnit, String.valueOf(period).trim(), reportInfo.getAnalysisRptType(), templateSheets[1], v2, null, solution);
                }
                continue;
            }
            AnalysisRptNewUtil.handleCompanySheet(book, simpleAnalysisOrgUnit, "0", reportInfo.getAnalysisRptType(), templateSheets[1], v2, null, solution);
        }
        return true;
    }

    private static Map<String, IndustryOrgUnitMappingInfo> getOrgUnitIndustry(List<AnalysisOrgUnitInfo> simpleAnalysisOrgUnits, List<AnalysisOrgUnitInfo> complexAnalysisOrgUnits) throws Exception {
        HashMap<String, IndustryOrgUnitMappingInfo> orgUnitIndustryMap = new HashMap<String, IndustryOrgUnitMappingInfo>();
        HashSet<String> orgUnitIds = new HashSet<String>();
        if (simpleAnalysisOrgUnits != null) {
            for (AnalysisOrgUnitInfo info : simpleAnalysisOrgUnits) {
                orgUnitIds.add(info.getOrgUnit().getId().toString());
            }
        }
        if (complexAnalysisOrgUnits != null) {
            for (AnalysisOrgUnitInfo info : complexAnalysisOrgUnits) {
                orgUnitIds.add(info.getOrgUnit().getId().toString());
            }
        }
        if (!orgUnitIds.isEmpty()) {
            IndustryOrgUnitMappingCollection coll = IndustryOrgUnitMappingFactory.getRemoteInstance().getIndustryOrgUnitMappingCollection("select orgUnit.id,industry.name,industry.number,industry.id,industryRange where  orgUnit.id in (" + CslRptUtil.changeIdSet2String(orgUnitIds) + ")");
            for (int i = 0; i < coll.size(); ++i) {
                orgUnitIndustryMap.put(coll.get(i).getOrgUnit().getId().toString(), coll.get(i));
            }
        }
        return orgUnitIndustryMap;
    }

    private static void handleCompanySheet(Book book, AnalysisOrgUnitInfo analysisOrgUnit, String period, AnalysisRptTypeEnum analysisType, Sheet templateCompanySheet, ReportVariables v2, List<AnalysisOrgUnitInfo> complexCalcOrgUnits, AnalysisSolutionForBmkInfo solution) throws Exception {
        String sheetName = null;
        boolean isComplexAnalysis = false;
        if (complexCalcOrgUnits != null && !complexCalcOrgUnits.isEmpty()) {
            sheetName = AnalysisRptNewUtil.getCompanySheetName(complexCalcOrgUnits, period, analysisType);
            isComplexAnalysis = true;
        } else {
            sheetName = AnalysisRptNewUtil.getCompanySheetName(analysisOrgUnit, period, analysisType);
        }
        Sheet curSheet = new Sheet(book, sheetName);
        curSheet.copySheetFrom(templateCompanySheet, false);
        if (analysisType.equals((Object)AnalysisRptTypeEnum.BENHMARKING)) {
            if (isComplexAnalysis) {
                AnalysisRptNewUtil.handleAcctItem(curSheet, Integer.valueOf(period), complexCalcOrgUnits);
            } else {
                ArrayList<AnalysisOrgUnitInfo> calcSoluts = new ArrayList<AnalysisOrgUnitInfo>();
                calcSoluts.add(analysisOrgUnit);
                AnalysisRptNewUtil.handleAcctItem(curSheet, Integer.valueOf(period), calcSoluts);
            }
        }
        book.insertSheet(0, curSheet);
        if (v2.get("isCompany", curSheet.getSheetName()) == null) {
            v2.add(VariablesHelper.createReservedEntry("isCompany", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"159_AnalysisRptNewUtil"), curSheet.getSheetName(), "", 1));
        }
        v2.get("isCompany", curSheet.getSheetName()).setValue("1");
        if (analysisType.equals((Object)AnalysisRptTypeEnum.SOCREANALYSIS)) {
            curSheet.setUserObject("companyKey", (Object)(isComplexAnalysis ? AnalysisRptNewUtil.getCompanyNameStr(complexCalcOrgUnits) : analysisOrgUnit.getOrgUnit().getId().toString()));
            curSheet.setUserObject("sheetIndustryKey", (Object)solution);
        }
    }

    private static void handleBhmkOrgUnitSheet(Book book, String bhmkOrgUnit, AnalysisReportNewInfo reportInfo, String period, Sheet templateBhmkOrgSheet, ReportVariables v2) throws Exception {
        String sheetName = AnalysisRptNewUtil.getCompanySheetName(bhmkOrgUnit, period, reportInfo.getAnalysisRptType());
        Sheet curSheet = new Sheet(book, sheetName);
        curSheet.copySheetFrom(templateBhmkOrgSheet, false);
        if (reportInfo.getAnalysisRptType().equals((Object)AnalysisRptTypeEnum.BENHMARKING)) {
            AnalysisRptNewUtil.handleBref(curSheet, bhmkOrgUnit, reportInfo.getYear(), period);
        }
        book.insertSheet(0, curSheet);
        if (v2.get("isBhmOrgUnitSheet", curSheet.getSheetName()) == null) {
            v2.add(VariablesHelper.createReservedEntry("isBhmOrgUnitSheet", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"160_AnalysisRptNewUtil"), curSheet.getSheetName(), "", 1));
        }
        v2.get("isBhmOrgUnitSheet", curSheet.getSheetName()).setValue("1");
        if (reportInfo.getAnalysisRptType().equals((Object)AnalysisRptTypeEnum.SOCREANALYSIS)) {
            curSheet.setUserObject("companyKey", (Object)bhmkOrgUnit);
            IndustryOrgUnitMappingInfo industryOrgUnitMap = new IndustryOrgUnitMappingInfo();
            industryOrgUnitMap.setIndustry(reportInfo.getSolution().getIndustry());
            industryOrgUnitMap.setIndustryRange(reportInfo.getSolution().getIndustryRange());
            curSheet.setUserObject("sheetIndustryKey", (Object)industryOrgUnitMap);
        }
    }

    private static void handleBref(Sheet sheet, String bhmkOrgUnit, int year, String period) throws Exception {
        Cell curCell = null;
        String formula = null;
        StringBuffer formulaSb = new StringBuffer();
        int end = 0;
        String[] params = null;
        Locale locale = SysContext.getSysContext().getLocale();
        for (int row = 0; row <= sheet.getMaxRowIndex(); ++row) {
            for (int col = 0; col <= sheet.getMaxColIndex(); ++col) {
                curCell = sheet.getCell(row, col, true);
                formula = curCell.getFormula();
                if (StringUtils.isEmpty((String)formula) || !formula.trim().toLowerCase(locale).startsWith("=bref")) continue;
                end = AnalysisRptNewUtil.getFormularEnd("=bref(".length(), formula);
                if (end > 0 && (params = (formula = formula.substring("=bref(".length(), end)).split(",")).length > 4) {
                    formulaSb.setLength(0);
                    formulaSb.append("=bref(");
                    params[0] = "\"" + bhmkOrgUnit + "\"";
                    params[1] = String.valueOf(year);
                    params[2] = period;
                    for (int k = 0; k < params.length; ++k) {
                        if (k > 0) {
                            formulaSb.append(",");
                        }
                        formulaSb.append(params[k]);
                    }
                    formulaSb.append(")");
                }
                if (formulaSb.length() <= 0) continue;
                curCell.setFormula(formulaSb.toString());
            }
        }
    }

    private static String[] getBhmkOrgUnits(String benhmarkingOrgUnitStr) throws Exception {
        if (!StringUtils.isEmpty((String)benhmarkingOrgUnitStr)) {
            return benhmarkingOrgUnitStr.split(";");
        }
        return null;
    }

    private static boolean handleAcctItem(Sheet sheet, Integer period, List<AnalysisOrgUnitInfo> calcOrgUnits) throws Exception {
        Cell curCell = null;
        String formula = null;
        StringBuffer formulaSb = new StringBuffer();
        int end = 0;
        String[] params = null;
        Locale locale = SysContext.getSysContext().getLocale();
        for (int row = 0; row <= sheet.getMaxRowIndex(); ++row) {
            for (int col = 0; col <= sheet.getMaxColIndex(); ++col) {
                curCell = sheet.getCell(row, col, true);
                formula = curCell.getFormula();
                if (StringUtils.isEmpty((String)formula) || !formula.trim().toLowerCase(locale).startsWith("=acctitem")) continue;
                end = AnalysisRptNewUtil.getFormularEnd("=acctitem(".length(), formula);
                if (end > 0 && (params = (formula = formula.substring("=acctitem(".length(), end)).split(",")).length > 17) {
                    formulaSb.setLength(0);
                    formulaSb.append("=");
                    for (AnalysisOrgUnitInfo calcOrgUnit : calcOrgUnits) {
                        if (formulaSb.length() > 1) {
                            formulaSb.append("+");
                        }
                        formulaSb.append("acctitem(");
                        if (!StringUtils.isEmpty((String)calcOrgUnit.getOrgTreeNumber())) {
                            params[0] = "\"" + calcOrgUnit.getOrgTreeNumber() + "\"";
                        }
                        params[1] = "\"" + calcOrgUnit.getOrgUnit().getNumber() + "\"";
                        if (period > 0) {
                            params[8] = String.valueOf(period);
                            params[9] = String.valueOf(period);
                        }
                        params[10] = calcOrgUnit.getOrgUnit().isIsGrouping() ? "\"CONSOLIDATION\"" : "\"COMMITREPORT\"";
                        for (int k = 0; k < params.length; ++k) {
                            if (k > 0) {
                                formulaSb.append(",");
                            }
                            formulaSb.append(params[k]);
                        }
                        formulaSb.append(")");
                    }
                }
                if (formulaSb.length() <= 0) continue;
                curCell.setFormula(formulaSb.toString());
            }
        }
        return true;
    }

    private static int getFormularEnd(int startIndex, String acctItemStr) throws Exception {
        Stack<String> stack = new Stack<String>();
        for (int i = startIndex; i < acctItemStr.trim().length(); ++i) {
            if (acctItemStr.charAt(i) == '(') {
                stack.push("(");
                continue;
            }
            if (acctItemStr.charAt(i) != ')') continue;
            if (stack.isEmpty()) {
                return i;
            }
            stack.pop();
        }
        stack.clear();
        return -1;
    }

    private static String getCompanySheetName(AnalysisOrgUnitInfo orgUnit, String period, AnalysisRptTypeEnum analysisType) throws Exception {
        StringBuffer sb = new StringBuffer();
        if (analysisType.equals((Object)AnalysisRptTypeEnum.BENHMARKING)) {
            sb.append(AnalysisRptNewUtil.getCompanyNameStr(orgUnit));
            if (!StringUtils.isEmpty((String)period) && Integer.valueOf(period) > 0) {
                sb.append("(").append(period).append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"161_AnalysisRptNewUtil"));
            }
        } else {
            sb = new StringBuffer();
            sb.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"162_AnalysisRptNewUtil")).append(AnalysisRptNewUtil.getCompanyNameStr(orgUnit)).append(")");
        }
        return sb.toString();
    }

    private static String getCompanySheetName(String name, String period, AnalysisRptTypeEnum analysisType) throws Exception {
        StringBuffer sb = new StringBuffer();
        if (analysisType.equals((Object)AnalysisRptTypeEnum.BENHMARKING)) {
            sb.append(name);
            if (!StringUtils.isEmpty((String)period) && Integer.valueOf(period) > 0) {
                sb.append("(").append(period).append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"161_AnalysisRptNewUtil"));
            }
        } else {
            sb.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"162_AnalysisRptNewUtil")).append(name).append(")");
        }
        return sb.toString();
    }

    private static String getCompanyNameStr(List<AnalysisOrgUnitInfo> orgUnits) throws Exception {
        StringBuffer sb = new StringBuffer();
        for (AnalysisOrgUnitInfo orgUnit : orgUnits) {
            if (sb != null && sb.length() > 0) {
                sb.append("+");
            }
            sb.append(AnalysisRptNewUtil.getCompanyNameStr(orgUnit));
        }
        return sb.toString();
    }

    private static String getCompanyNameStr(AnalysisOrgUnitInfo orgUnit) throws Exception {
        StringBuffer sb = new StringBuffer();
        String name = orgUnit.getOrgUnit().getSimpleName();
        if (StringUtils.isEmpty((String)name)) {
            name = orgUnit.getOrgUnit().getName();
        }
        sb.append(name);
        return sb.toString();
    }

    private static String getCompanySheetName(List<AnalysisOrgUnitInfo> orgUnits, String period, AnalysisRptTypeEnum analysisType) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(AnalysisRptNewUtil.getCompanyNameStr(orgUnits));
        if (analysisType.equals((Object)AnalysisRptTypeEnum.BENHMARKING) && !StringUtils.isEmpty((String)period) && Integer.valueOf(period) > 0) {
            sb.append("(").append(period).append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"161_AnalysisRptNewUtil"));
        }
        return sb.toString();
    }

    public static Sheet[] getTemplateAnalysisAndCompanySheet(Book book, AnalysisRptTypeEnum analysisType, int year) throws Exception {
        AnalysisReportNewInfo templateInfo;
        int analysisTemplateType = 3;
        if (analysisType.equals((Object)AnalysisRptTypeEnum.SOCREANALYSIS)) {
            analysisTemplateType = 4;
        }
        if ((templateInfo = AnalysisReportNewFactory.getRemoteInstance().getAnalysisReportNewInfo("select data where year=" + year + " and analysisRptType=" + analysisTemplateType)) == null) {
            return null;
        }
        Book templateBook = templateInfo.getBook();
        Sheet analysisSheet = null;
        Sheet companySheet = null;
        Sheet bhmkOrgUnitSheet = null;
        templateBook.setAutoCalculate(false);
        ReportVariables v1 = ReportVariables.loadFromBook((Book)book);
        book.getSheet(0).setName("defaultSheet");
        for (int i = book.getSheetCount() - 1; i >= 1; --i) {
            if (book.getSheet(i).getSheetName().equals("defaultSheet")) continue;
            book.removeSheet(i);
        }
        ReportVariables v = ReportVariables.loadFromBook((Book)templateBook);
        for (int i = templateBook.getSheetCount() - 1; i >= 0; --i) {
            if (v.get("isCompany", templateBook.getSheetName(i)) != null && v.get("isCompany", templateBook.getSheetName(i)).getBoolValue(false)) {
                companySheet = templateBook.getSheet(i);
                continue;
            }
            if (v.get("isAnalysis", templateBook.getSheetName(i)) != null && v.get("isAnalysis", templateBook.getSheetName(i)).getBoolValue(false)) {
                analysisSheet = templateBook.getSheet(i);
                continue;
            }
            if (v.get("isBhmOrgUnitSheet", templateBook.getSheetName(i)) != null && v.get("isBhmOrgUnitSheet", templateBook.getSheetName(i)).getBoolValue(false)) {
                bhmkOrgUnitSheet = templateBook.getSheet(i);
                continue;
            }
            templateBook.getSheet(i).setUserObject("isTemplateOtherSheet", (Object)"Y");
            book.insertSheet(0, templateBook.getSheet(i));
        }
        if (analysisSheet != null) {
            return new Sheet[]{analysisSheet, companySheet, bhmkOrgUnitSheet};
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void autoSetBackGround(SortedCellBlockArray cells, Sheet sheet, AnalysisRptTypeEnum analysisRptType) throws Exception {
        block12: {
            if (sheet != null && sheet.getUserObjectValue("industryKey") != null) {
                boolean isAutoCal = sheet.getBook().isAutoCalculate();
                boolean isSocreAnalysis = analysisRptType.equals((Object)AnalysisRptTypeEnum.SOCREANALYSIS);
                if (analysisRptType == null || !analysisRptType.equals((Object)AnalysisRptTypeEnum.BENHMARKING) && !isSocreAnalysis) {
                    return;
                }
                try {
                    sheet.getBook().setAutoCalculate(false);
                    sheet.getBook().getUndoManager().startGroup();
                    sheet.getBook().getUndoManager().enable(false);
                    sheet.getBook().setSkipListeners(true);
                    if (cells == null) break block12;
                    Cell curCell = null;
                    AnalysisTypeColIndex analysisTypeColIndex = AnalysisRptNewUtil.getAnalysisTypeColIndexMap(sheet.getBook(), analysisRptType).get(sheet.getSheetName());
                    if (analysisTypeColIndex == null || (isSocreAnalysis || !analysisTypeColIndex.isInited()) && !isSocreAnalysis) break block12;
                    ArrayList<BigDecimal> socreValues = null;
                    if (isSocreAnalysis) {
                        socreValues = new ArrayList<BigDecimal>();
                    }
                    for (int i = 0; i < cells.size(); ++i) {
                        CellBlock block = cells.getBlock(i);
                        if (block == null) continue;
                        int startRow = block.getRow();
                        int endRow = block.getRow2();
                        int startCol = block.getCol();
                        int endCol = block.getCol2();
                        if (isSocreAnalysis && startCol > AnalysisRptNewUtil.getSocreValueCol(analysisTypeColIndex) && AnalysisRptNewUtil.getSocreValueCol(analysisTypeColIndex) > endCol) {
                            break;
                        }
                        if (isSocreAnalysis) {
                            startCol = endCol = AnalysisRptNewUtil.getSocreValueCol(analysisTypeColIndex);
                            startRow = startRow < analysisTypeColIndex.getCompanyRow() ? analysisTypeColIndex.getCompanyRow() : startRow;
                        } else {
                            startCol = startCol < analysisTypeColIndex.getPoorValueCol() ? analysisTypeColIndex.getPoorValueCol() : startCol;
                            int n = startRow = startRow < analysisTypeColIndex.getKeyIndexStartRow() ? analysisTypeColIndex.getKeyIndexStartRow() : startRow;
                        }
                        if (startCol > endCol || startRow > endRow) continue;
                        for (int col = startCol; col <= endCol; ++col) {
                            for (int row = startRow; row <= endRow; ++row) {
                                curCell = sheet.getCell(row, col, true);
                                AnalysisRptNewUtil.setCellBackGround(sheet, curCell, analysisTypeColIndex, socreValues, isSocreAnalysis);
                            }
                        }
                    }
                }
                finally {
                    sheet.getBook().setAutoCalculate(isAutoCal);
                    sheet.getBook().setSkipListeners(false);
                    sheet.getBook().getUndoManager().endGroup();
                    sheet.getBook().getUndoManager().enable(true);
                }
            }
        }
    }

    public static void setCellBackGround(Sheet sheet, Cell curCell, AnalysisTypeColIndex analysisTypeColIndex, List<BigDecimal> socreValues, boolean isSocreAnalysis) throws Exception {
        Color backGroundColor;
        BigDecimal cellValue;
        if (curCell.getValue() != null && !curCell.getValue().isNull() && (!isSocreAnalysis && AnalysisRptNewUtil.isKeyIndexCell(sheet, curCell.getRow(), analysisTypeColIndex.getKeyIndexCol()) || isSocreAnalysis && sheet.getCell(curCell.getRow(), analysisTypeColIndex.getCompanyCol(), true).getUserObjectValue("companyKey") != null) && (cellValue = AnalysisRptNewUtil.getCellBigDecimalValue(sheet, curCell.getRow(), curCell.getCol())) != null && (backGroundColor = AnalysisRptNewUtil.getCellBackGround(sheet, cellValue, curCell.getRow(), analysisTypeColIndex, socreValues, isSocreAnalysis)) != null) {
            StyleAttributes ssa = Styles.getSA((ShareStyleAttributes)curCell.getSSA());
            ssa.setBackground(backGroundColor);
            curCell.setSSA((ShareStyleAttributes)ssa);
        }
    }

    public static boolean isKeyIndexCell(Sheet sheet, int row, int col) throws Exception {
        String keyIndexInd = AnalysisRptNewUtil.getCellKeyIndexId(sheet, row, col);
        return !StringUtils.isEmpty((String)keyIndexInd);
    }

    public static String getCellKeyIndexId(Sheet sheet, int row, int col) throws Exception {
        ItemFormula formula = (ItemFormula)sheet.getCell(row, col, true).getUserObjectValue("ITEM");
        if (formula != null) {
            return formula.getExt("analysisKeyIndexId");
        }
        return null;
    }

    public static Color getCellBackGround(Sheet sheet, BigDecimal cellValue, int row, AnalysisTypeColIndex analysisTypeColIndex, List<BigDecimal> socreValues, boolean isSocreAnalysis) throws Exception {
        if (isSocreAnalysis) {
            AnalysisRptNewUtil.initSocreValues(sheet, analysisTypeColIndex, socreValues);
            BigDecimal[] socreValueArr = new BigDecimal[socreValues.size()];
            int postion = AnalysisRptNewUtil.binSearch(socreValues.toArray(socreValueArr), cellValue);
            if (postion != -1 && sheet.getCell(analysisTypeColIndex.getPoorValueRow() - postion, analysisTypeColIndex.getAverageValueCol() - 1, true).getStyle() != null) {
                return sheet.getCell(analysisTypeColIndex.getPoorValueRow() - postion, analysisTypeColIndex.getAverageValueCol() - 1, true).getStyle().getBackground();
            }
        } else {
            BigDecimal excellentValue = AnalysisRptNewUtil.getCellBigDecimalValue(sheet, row, analysisTypeColIndex.getExcellentValueCol());
            BigDecimal goodValue = AnalysisRptNewUtil.getCellBigDecimalValue(sheet, row, analysisTypeColIndex.getGoodValueCol());
            BigDecimal averageValue = AnalysisRptNewUtil.getCellBigDecimalValue(sheet, row, analysisTypeColIndex.getAverageValueCol());
            BigDecimal fairValue = AnalysisRptNewUtil.getCellBigDecimalValue(sheet, row, analysisTypeColIndex.getFairValueCol());
            BigDecimal poorValue = AnalysisRptNewUtil.getCellBigDecimalValue(sheet, row, analysisTypeColIndex.getPoorValueCol());
            if (goodValue != null && averageValue != null) {
                boolean isOrder = goodValue.compareTo(averageValue) > 0;
                BigDecimal[] arrary = null;
                int[] colArr = null;
                if (isOrder) {
                    arrary = new BigDecimal[]{poorValue, fairValue, averageValue, goodValue, excellentValue};
                    colArr = new int[]{analysisTypeColIndex.getPoorValueCol(), analysisTypeColIndex.getFairValueCol(), analysisTypeColIndex.getAverageValueCol(), analysisTypeColIndex.getGoodValueCol(), analysisTypeColIndex.getExcellentValueCol()};
                } else {
                    arrary = new BigDecimal[]{excellentValue, goodValue, averageValue, fairValue, poorValue};
                    colArr = new int[]{analysisTypeColIndex.getExcellentValueCol(), analysisTypeColIndex.getGoodValueCol(), analysisTypeColIndex.getAverageValueCol(), analysisTypeColIndex.getFairValueCol(), analysisTypeColIndex.getPoorValueCol()};
                }
                int postion = AnalysisRptNewUtil.binSearch(arrary, cellValue);
                if (postion != -1 && sheet.getCell(analysisTypeColIndex.getScoreRow(), colArr[postion], true).getStyle() != null) {
                    return sheet.getCell(analysisTypeColIndex.getScoreRow(), colArr[postion], true).getStyle().getBackground();
                }
            }
        }
        return null;
    }

    public static void initSocreValues(Sheet sheet, AnalysisTypeColIndex analysisTypeColIndex, List<BigDecimal> socreValues) throws Exception {
        if (socreValues != null && !socreValues.isEmpty()) {
            return;
        }
        int[] rows = new int[]{analysisTypeColIndex.getPoorValueRow(), analysisTypeColIndex.getFairValueRow(), analysisTypeColIndex.getAverageValueRow(), analysisTypeColIndex.getGoodValueRow(), analysisTypeColIndex.getExcellentValueRow()};
        Variant value = null;
        for (int row : rows) {
            value = sheet.getCell(row, analysisTypeColIndex.getPoorValueCol(), true).getValue();
            if (value == null) continue;
            String curValue = String.valueOf(value);
            curValue = curValue.replaceAll("\\[", "");
            curValue = curValue.replaceAll("\\]", "");
            String[] values = (curValue = curValue.replaceAll("\\)", "")).split("\uff0c");
            if (values.length != 2) continue;
            socreValues.add(new BigDecimal(values[0].trim()));
        }
    }

    public static int binSearch(BigDecimal[] srcArray, BigDecimal key) {
        int mid = srcArray.length / 2;
        if (key == srcArray[mid]) {
            return mid;
        }
        int start = 0;
        int end = srcArray.length - 1;
        while (start <= end) {
            mid = (end - start) / 2 + start;
            if (key.compareTo(srcArray[mid]) < 0) {
                if (mid - 1 >= 0 && key.compareTo(srcArray[mid - 1]) >= 0) {
                    return mid - 1;
                }
                if (mid - 1 < 0) {
                    return mid;
                }
                end = mid - 1;
                continue;
            }
            if (key.compareTo(srcArray[mid]) > 0) {
                if (mid + 1 <= srcArray.length - 1 && key.compareTo(srcArray[mid + 1]) < 0) {
                    return mid;
                }
                if (mid + 1 > srcArray.length - 1) {
                    return mid;
                }
                start = mid + 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    public static BigDecimal getCellBigDecimalValue(Sheet sheet, int row, int col) {
        Cell curCell = sheet.getCell(row, col, true);
        if (curCell != null) {
            BigDecimal cellValue = null;
            try {
                cellValue = curCell.getValue().isError() ? new BigDecimal(curCell.getText()) : curCell.getValue().toBigDecimal();
            }
            catch (Exception ex) {
                cellValue = null;
                logger.error((Object)curCell.getValue().toString(), (Throwable)ex);
            }
            return cellValue;
        }
        return null;
    }

    public static void insertCompanyIndexValue(Context ctx, AnalysisReportNewInfo model, String pk) throws Exception {
        int year = model.getYear();
        Book book = model.getBook();
        book.setCalculate(false);
        BookProperties p = BookProperties.loadFromBook((Book)book);
        AnalysisRptNewPropertyAdapter adapter = new AnalysisRptNewPropertyAdapter();
        adapter.initReportProperties((IObjectValue)model, ctx);
        FormulaDefinition.registerFormulaToBook(book, new ReportCalculateContext(ctx, adapter, p.getVariables(), (IErrorProvider)p.getErrorProvider(), null));
        if (book != null) {
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            Map<String, AnalysisTypeColIndex> AnalysisTypeIndexMap = AnalysisRptNewUtil.getAnalysisTypeColIndexMap(book, model.getAnalysisRptType());
            if (AnalysisTypeIndexMap != null && !AnalysisTypeIndexMap.isEmpty()) {
                AnalysisTypeColIndex analysisTypeColIndex = null;
                Sheet curSheet = null;
                String companyKey = null;
                String keyIndexId = null;
                Cell curCell = null;
                BigDecimal cellValue = null;
                String bosType = new AnalysisReportNewInfo().getBOSType().toString();
                String period = null;
                for (String sheetName : AnalysisTypeIndexMap.keySet()) {
                    analysisTypeColIndex = AnalysisTypeIndexMap.get(sheetName);
                    curSheet = book.getSheetByName(sheetName);
                    if (!analysisTypeColIndex.isInited()) continue;
                    for (int col = analysisTypeColIndex.getCompanyCol(); col <= curSheet.getMaxColIndex(); ++col) {
                        companyKey = (String)curSheet.getCell(analysisTypeColIndex.getCompanyRow(), col, true).getUserObjectValue("companyKey");
                        if (StringUtils.isEmpty((String)companyKey)) continue;
                        for (int row = analysisTypeColIndex.getKeyIndexStartRow(); row <= curSheet.getMaxRowIndex(); ++row) {
                            keyIndexId = AnalysisRptNewUtil.getCellKeyIndexId(curSheet, row, analysisTypeColIndex.getKeyIndexCol());
                            if (StringUtils.isEmpty((String)keyIndexId) || (curCell = curSheet.getCell(row, col, true)).getValue() == null) continue;
                            try {
                                cellValue = curCell.getValue().toBigDecimal();
                            }
                            catch (Exception e) {
                                throw new Exception(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"163_AnalysisRptNewUtil") + curCell.toString() + EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"164_AnalysisRptNewUtil"));
                            }
                            period = (String)curSheet.getCell(analysisTypeColIndex.getCompanyRow(), col, true).getUserObjectValue("periodKey");
                            params.add(new Object[]{BOSUuid.create((String)bosType).toString(), year, period, pk.toString(), keyIndexId, companyKey, cellValue});
                        }
                    }
                }
            }
            StringBuffer sql = new StringBuffer();
            if (pk != null) {
                sql.append("delete T_Csl_AnalysisOrgIndexValue where freportid in ('").append(pk).append("')");
                DbUtil.execute(ctx, sql.toString());
            }
            if (params.size() > 0) {
                sql.setLength(0);
                sql.append(" insert into T_Csl_AnalysisOrgIndexValue(FID,FYear,FPeriod,FReportId,FKeyIndexId,FCompany,FValue) values(?,?,?,?,?,?,?)");
                DbUtil.executeBatchAndReturn(ctx, sql.toString(), params);
                params.clear();
            }
        }
    }

    public static String getDisplayAnalysisOrg(List<FullOrgUnitInfo> simpleOrgUnits, List<FullOrgUnitInfo> complexOrgUnits) {
        StringBuffer sb = new StringBuffer();
        if (simpleOrgUnits != null && !simpleOrgUnits.isEmpty()) {
            for (FullOrgUnitInfo org : simpleOrgUnits) {
                sb.append(StringUtils.isEmpty((String)org.getSimpleName()) ? org.getName() : org.getSimpleName()).append(";");
            }
        }
        if (complexOrgUnits != null && !complexOrgUnits.isEmpty()) {
            for (FullOrgUnitInfo org : complexOrgUnits) {
                sb.append(StringUtils.isEmpty((String)org.getSimpleName()) ? org.getName() : org.getSimpleName()).append("+");
            }
            if (sb.charAt(sb.length() - 1) == '+') {
                sb.deleteCharAt(sb.length() - 1);
            }
        }
        return sb.toString();
    }

    public static Map<String, List<AnalysisOrgUnitInfo>[]> getSolutionAnalysisOrgUnitMap(List<String> solutionIds) throws Exception {
        AnalysisOrgUnitCollection coll = AnalysisOrgUnitFactory.getRemoteInstance().getAnalysisOrgUnitCollection("select orgUnit.name,orgUnit.simpleName,orgUnit.number,orgUnit.isGrouping,orgUnitType,orgUnit.id,solution.id,orgTreeNumber where solution.id in(" + CslRptUtil.list2String(solutionIds, (String)",", (boolean)true) + ")");
        if (coll != null && !coll.isEmpty()) {
            HashMap<String, List<AnalysisOrgUnitInfo>[]> analysisOrgUnitMap = new HashMap<String, List<AnalysisOrgUnitInfo>[]>();
            AnalysisOrgUnitInfo orgUnitInfo = null;
            List[] listArr = null;
            ArrayList<AnalysisOrgUnitInfo> list = null;
            StringBuffer ids = new StringBuffer();
            for (int i = 0; i < coll.size(); ++i) {
                orgUnitInfo = coll.get(i);
                listArr = (List[])analysisOrgUnitMap.get(orgUnitInfo.getSolution().getId().toString());
                if (listArr == null) {
                    listArr = new List[2];
                    analysisOrgUnitMap.put(orgUnitInfo.getSolution().getId().toString(), listArr);
                }
                if ((list = listArr[orgUnitInfo.getOrgUnitType() - 1]) == null) {
                    listArr[orgUnitInfo.getOrgUnitType() - 1] = list = new ArrayList<AnalysisOrgUnitInfo>();
                }
                list.add(orgUnitInfo);
                if (orgUnitInfo.getOrgUnitType() != 1) continue;
                ids.append("'").append(orgUnitInfo.getOrgUnit().getId().toString()).append("'");
            }
            return analysisOrgUnitMap;
        }
        return null;
    }
}

