/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.UserObject;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.util.Base64;
import com.kingdee.bos.sql.util.Rijndael_Util;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportGroupEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.RptItemRelationshipFactory;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeEntryInfo;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeInfo;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynaRptBasePointIndexHandle;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.report.VariablesHelper;
import com.kingdee.eas.fi.rpt.ISqlUtilFacade;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.SqlUtilFacadeFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.SqlResult;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Point;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class NewRptUtil {
    private static final Logger logger = Logger.getLogger((String)NewRptUtil.class.getName());
    public static Map<Integer, Map[]> itemRelationshipCatchMap = new ConcurrentHashMap<Integer, Map[]>();
    public static Map<String, String> checkageBillSetInfoMap = new HashMap<String, String>();
    public static final String DItemNumber = "6";
    public static final String IsGenerateDyItemFormula = "IsGenerateDyItemFormula";

    public static void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    public static void makeAccessible(Method method) {
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
            method.setAccessible(true);
        }
    }

    public static String encodePassword(char[] src) {
        if (src == null) {
            return null;
        }
        String startStr = "ksqle:";
        boolean isStartKsqle = true;
        if (src.length >= startStr.length()) {
            for (int i = 0; i < startStr.length(); ++i) {
                if (src[i] == startStr.charAt(i)) continue;
                isStartKsqle = false;
                break;
            }
        }
        if (isStartKsqle) {
            return new String(src);
        }
        try {
            Field field = KSqlUtil.class.getDeclaredField("kb");
            field.setAccessible(true);
            byte[] kb = (byte[])field.get("kb");
            byte[] pt = NewRptUtil.getBytes(src, "UTF-8");
            byte[] ct = Rijndael_Util.encode((byte[])kb, (byte[])pt, (int)16);
            return "ksqle:" + Base64.encodeBytes((byte[])ct, (boolean)false);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static byte[] getBytes(char[] chars, String code) throws Exception {
        if (chars != null) {
            Charset charset = Charset.forName(code);
            CharBuffer buffer = CharBuffer.allocate(chars.length);
            buffer.put(chars);
            buffer.flip();
            ByteBuffer bf = charset.encode(buffer);
            byte[] curBytes = bf.array();
            if (bf.limit() < bf.capacity()) {
                return Arrays.copyOfRange(curBytes, 0, bf.limit());
            }
            return curBytes;
        }
        return null;
    }

    public static void addInterExchVariables(String sheetName, ReportVariables variables) {
        VariableEntry v = VariablesHelper.createReservedEntry("IsOnlyFillHavingDataCompany", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"84_IsOnlyFillHavingDataCompany"), sheetName, "", 4);
        v.setComboBoxEnum("com.kingdee.eas.fi.newrpt.IsOnlyFillHavingDataCompanyEnum");
        variables.addWithoutDup(v);
    }

    public static void initDynaAndInterExFillVariables(RptSheetParamInfo p, String sheetName, IObjectValue editdata, ReportVariables variables) {
        boolean isInterExch;
        VirtualSheetParamInfo reportInfo = null;
        int reportClass = 1;
        if (!StringUtils.isEmpty((String)sheetName)) {
            reportClass = variables.getIntValue("SheetClass", sheetName, 1);
            if (editdata instanceof VirtualSheetParamInfo) {
                reportInfo = (VirtualSheetParamInfo)editdata;
            }
        } else {
            sheetName = p.getSheetName();
            reportInfo = p.getReport();
            CSLReportGroupEnum reportClassEnum = p.getReportClass();
            if (reportClassEnum != null) {
                reportClass = reportClassEnum.getValue();
            }
        }
        if (isInterExch = CslRptUtil.isInterOrExchSheet((int)reportClass)) {
            NewRptUtil.addInterExchVariables(sheetName, variables);
        } else if (reportInfo != null) {
            boolean isDynaRpt = false;
            if (reportInfo instanceof TemplateInfo) {
                TemplateInfo tmpInfo = (TemplateInfo)reportInfo;
                if (RptTmpTypeEnum.DYNAMICNORMALREPORT.equals((Object)tmpInfo.getTemplateType())) {
                    isDynaRpt = true;
                }
            } else {
                ReportBaseInfo rpt;
                int sourceType = -1;
                if (reportInfo instanceof ReportBaseInfo && (rpt = (ReportBaseInfo)reportInfo).getSourceType() != null) {
                    sourceType = rpt.getSourceType().getValue();
                }
                if (sourceType == -1 && reportInfo.get("sourceType") != null && reportInfo.get("sourceType") instanceof Integer) {
                    sourceType = (Integer)reportInfo.get("sourceType");
                }
                if (sourceType != -1 && sourceType == 10) {
                    isDynaRpt = true;
                }
            }
            if (isDynaRpt) {
                VariableEntry v = VariablesHelper.createReservedEntry("IsOnlyFillHavingDataItem", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"83_IsOnlyFillHavingDataItem"), sheetName, "", 4);
                v.setComboBoxEnum("com.kingdee.eas.fi.newrpt.IsOnlyFillHavingDataEnum");
                variables.addWithoutDup(v);
            }
        }
    }

    public static String getInterExchFillParamValue(Context ctx, Sheet curSheet, String groupParamValue) throws Exception {
        ReportVariables v;
        String isOnlyFillHavingDataCompany = null;
        if (curSheet != null && (v = ReportVariables.loadFromBook((Book)curSheet.getBook())) != null) {
            isOnlyFillHavingDataCompany = v.getStringValue("IsOnlyFillHavingDataCompany", curSheet.getSheetName());
            if (StringUtils.isEmpty((String)isOnlyFillHavingDataCompany)) {
                isOnlyFillHavingDataCompany = v.getStringValue("IsOnlyFillHavingDataCompany", null);
            }
            if (!StringUtils.isEmpty((String)isOnlyFillHavingDataCompany)) {
                return isOnlyFillHavingDataCompany.trim();
            }
        }
        if (!StringUtils.isEmpty((String)groupParamValue)) {
            return groupParamValue.trim();
        }
        return CslRptUtil.getCslParamToString((Context)ctx, (String)"IsOnlyFillHavingDataCompany");
    }

    public static boolean getDyRptFillParamValue(Context ctx, Sheet curSheet, DynaParameters param, String groupParamValue) throws Exception {
        ReportVariables v;
        String isOnlyListHasDataItem = null;
        if (param != null && !StringUtils.isEmpty((String)(isOnlyListHasDataItem = param.getOnlyListHasDataItem()))) {
            return isOnlyListHasDataItem.trim().equalsIgnoreCase("true");
        }
        if (curSheet != null && (v = ReportVariables.loadFromBook((Book)curSheet.getBook())) != null) {
            isOnlyListHasDataItem = v.getStringValue("IsOnlyFillHavingDataItem", curSheet.getSheetName());
            if (StringUtils.isEmpty((String)isOnlyListHasDataItem)) {
                isOnlyListHasDataItem = v.getStringValue("IsOnlyFillHavingDataItem", null);
            }
            if (!StringUtils.isEmpty((String)isOnlyListHasDataItem)) {
                return isOnlyListHasDataItem.trim().equalsIgnoreCase("true");
            }
        }
        if (!StringUtils.isEmpty((String)groupParamValue)) {
            return groupParamValue.trim().equalsIgnoreCase("true");
        }
        return CslRptUtil.getCslParam((Context)ctx, (String)"IsOnlyFillHavingDataItem");
    }

    public static void initBookGenerateDyItemFormulaParam(Book book, IObjectValue info, boolean isGenerateDyItemFormula) {
        if (book != null) {
            UserObject isBookGenerateDyItemFormula = book.getUserObject(IsGenerateDyItemFormula);
            if (isBookGenerateDyItemFormula != null) {
                return;
            }
            if (info instanceof ReportBaseInfo && RptSrcTypeEnum.DYNAMICNORMALREPORT.equals((Object)((ReportBaseInfo)info).getSourceType()) || info instanceof TemplateInfo && (RptTmpTypeEnum.DYNAMICNORMALREPORT.equals((Object)((TemplateInfo)info).getTemplateType()) || RptTmpTypeEnum.RPTDYNAMICREPORT.equals((Object)((TemplateInfo)info).getTemplateType()))) {
                book.setUserObject(IsGenerateDyItemFormula, (Object)isGenerateDyItemFormula);
            }
        }
    }

    public static ItemFormula generateCellDyItemFormula(Cell cell, Map<String, List<Point>> basePoints, Point point) {
        return NewRptUtil.generateCellDyItemFormula(cell, basePoints, point, true, false);
    }

    public static ItemFormula generateCellDyItemFormula(Cell cell, Map<String, List<Point>> basePoints, Point point, boolean checkPoint, boolean isChangeGenerateDyItem) {
        if (cell != null) {
            Sheet sheet = cell.getSheet();
            if (NewRptUtil.isGenerateDyItemFormula(sheet.getBook()) || !isChangeGenerateDyItem && cell.getUserObjectValue(DItemNumber) == null) {
                return null;
            }
            if (point == null) {
                List<Point> points = basePoints.get(sheet.getSheetName());
                if (points == null || points.isEmpty()) {
                    NewRptUtil.initBasePoints(cell, basePoints);
                    points = basePoints.get(sheet.getSheetName());
                } else if (checkPoint) {
                    for (Point curPoint : points) {
                        if (NewRptUtil.isBasePointCell(sheet, curPoint.y, curPoint.x)) continue;
                        NewRptUtil.initBasePoints(cell, basePoints);
                        points = basePoints.get(sheet.getSheetName());
                        break;
                    }
                }
                for (int i = 0; i < points.size(); ++i) {
                    Point curPoint;
                    curPoint = points.get(i);
                    if (cell.getRow() <= curPoint.y || cell.getCol() <= curPoint.x) continue;
                    if (i + 1 < points.size()) {
                        Point nextPoint = points.get(i + 1);
                        if (cell.getRow() >= nextPoint.y && cell.getCol() >= nextPoint.x) continue;
                        point = curPoint;
                        break;
                    }
                    point = curPoint;
                }
            }
            if (point != null) {
                ItemFormula item = NewRptUtil.getItemFormula(sheet, point.y, cell.getCol());
                Object ditemNumber = null;
                if (item != null) {
                    ditemNumber = sheet.getRange(cell.getRow(), point.x).getUserObject(DItemNumber);
                } else {
                    item = NewRptUtil.getItemFormula(sheet, cell.getRow(), point.x);
                    if (item != null) {
                        ditemNumber = sheet.getRange(point.y, cell.getCol()).getUserObject(DItemNumber);
                    }
                }
                if (item != null && ditemNumber != null && !StringUtils.isEmpty((String)ditemNumber.toString())) {
                    StringBuffer strBuffer = new StringBuffer();
                    strBuffer.append("=DItem(\"");
                    strBuffer.append(item.getItemNumber() + "\",\"");
                    strBuffer.append(ditemNumber + "\",");
                    strBuffer.append(item.getYearOffSet() + ",");
                    strBuffer.append(item.getPeriodOffSet() + ",\"");
                    strBuffer.append(item.getDataElementNumber() + "\",\"");
                    ValueTypeEnum type = ValueTypeEnum.getEnum((int)item.getValueType());
                    if (type == null) {
                        return null;
                    }
                    strBuffer.append(ValueTypeEnum.getEnum((int)item.getValueType()).getName());
                    strBuffer.append("\")");
                    return new ItemFormula(strBuffer.toString());
                }
            }
        }
        return null;
    }

    public static boolean isBasePointCell(Sheet sheet, int rowIndex, int colIndex) {
        String obj;
        ItemFormula f;
        Range range = sheet.getRange(rowIndex, colIndex);
        return range != null && (f = (ItemFormula)range.getUserObject("ITEM")) != null && (obj = f.getExt("DynaParameters")) != null && obj instanceof String;
    }

    public static boolean isGenerateDyItemFormula(Book book) {
        Object IsGenerateDyItemFormula = book.getUserObjectValue(IsGenerateDyItemFormula);
        return IsGenerateDyItemFormula == null || IsGenerateDyItemFormula instanceof Boolean && (Boolean)IsGenerateDyItemFormula != false;
    }

    public static void initBasePoints(Cell cell, Map<String, List<Point>> basePoints) {
        Sheet sheet = cell.getSheet();
        ArrayList points = DynamicTemplateUtility.getBasePointList((Sheet)sheet);
        basePoints.put(sheet.getSheetName(), points);
    }

    public static ItemFormula getItemFormula(Sheet sheet, int row, int col) {
        Cell cell = sheet.getCell(row, col, false);
        if (cell != null) {
            return (ItemFormula)cell.getUserObjectValue("ITEM");
        }
        return null;
    }

    public static ItemFormula getItemFormula(Sheet sheet, Range cell, Map<String, List<Point>> basePoints) {
        if (cell != null) {
            return NewRptUtil.getItemFormula(sheet.getCell(cell.getBlock(0).getRow(), cell.getBlock(0).getCol(), false), basePoints);
        }
        return null;
    }

    public static ItemFormula getItemFormula(Cell cell, Map<String, List<Point>> basePoints) {
        if (cell != null) {
            ItemFormula itemFormula = (ItemFormula)cell.getUserObjectValue("ITEM");
            if (itemFormula == null) {
                itemFormula = NewRptUtil.generateCellDyItemFormula(cell, basePoints, null);
            }
            return itemFormula;
        }
        return null;
    }

    public static ItemFormula getItemFormula(Cell cell, Point basePoint) {
        if (cell != null) {
            ItemFormula itemFormula = (ItemFormula)cell.getUserObjectValue("ITEM");
            if (itemFormula == null) {
                itemFormula = NewRptUtil.generateCellDyItemFormula(cell, null, basePoint, false, false);
            }
            return itemFormula;
        }
        return null;
    }

    public static ItemFormula getItemFormula(Cell cell, Point basePoint, boolean isChangeGenerateDyItem) {
        if (cell != null) {
            ItemFormula itemFormula = (ItemFormula)cell.getUserObjectValue("ITEM");
            if (itemFormula == null) {
                itemFormula = NewRptUtil.generateCellDyItemFormula(cell, null, basePoint, false, isChangeGenerateDyItem);
            }
            return itemFormula;
        }
        return null;
    }

    public static boolean isHasDItemFormula(Cell cell, Point point, boolean isVertical) {
        if (cell != null) {
            if (UserObjectHelper.getItemFormula((Cell)cell) == null) {
                Cell curCell = cell.getSheet().getCell(isVertical ? cell.getRow() : point.y, isVertical ? point.x : cell.getCol(), false);
                if (curCell != null && curCell.getUserObjectValue(DItemNumber) != null) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public static Set getIdsBySql(Context ctx, Sheet curSheet, DynaParameters param, Point activePoint, IReportPropertyAdapter reportPropertyAdapter) throws Exception {
        UserObject userObject;
        if (param != null && param.isGrade() && param.getDynaItemSource() == 0 && activePoint != null && (userObject = curSheet.getCell(activePoint.y, activePoint.x, true).getUserObject("sqlText")) != null && userObject.getValue() != null && !StringUtils.isEmpty((String)userObject.getValue().toString())) {
            String sql = userObject.getValue().toString().substring(0, userObject.getValue().toString().lastIndexOf("!"));
            sql = sql.replaceAll("\\{companyId\\}", "'" + (String)reportPropertyAdapter.getReportProperty("Company.ID") + "'");
            sql = sql.replaceAll("\\{companyNumber\\}", "'" + (String)reportPropertyAdapter.getReportProperty("Company.Number") + "'");
            sql = sql.replaceAll("\\{currencyNumber\\}", "'" + (String)reportPropertyAdapter.getReportProperty("Currency.Number") + "'");
            String year = reportPropertyAdapter.getReportProperty("Report.Year").toString();
            String period = reportPropertyAdapter.getReportProperty("Report.Period").toString();
            String yearPeriod = year + (period.length() < 2 ? "0" : "") + period;
            sql = sql.replaceAll("\\{year\\}", year);
            sql = sql.replaceAll("\\{period\\}", period);
            sql = sql.replaceAll("\\{periodType\\}", reportPropertyAdapter.getReportProperty("PeriodType").toString());
            sql = sql.replaceAll("\\{yearperiod\\}", yearPeriod);
            try {
                ISqlUtilFacade isql = null;
                isql = ctx == null ? SqlUtilFacadeFactory.getRemoteInstance() : SqlUtilFacadeFactory.getLocalInstance((Context)ctx);
                logger.error((Object)("getSqls:" + sql));
                SqlResult rs = isql.execute(sql);
                if (rs != null && rs.getRowSets().size() > 0) {
                    int size = rs.getRowSets().size();
                    IRowSet rowSet = (IRowSet)rs.getRowSets().get(size - 1);
                    HashSet<String> ids = new HashSet<String>();
                    while (rowSet != null && rowSet.next()) {
                        ids.add(rowSet.getString("fid"));
                    }
                    return ids;
                }
            }
            catch (Exception ex) {
                logger.error((Object)"getSqlCompanys error.", (Throwable)ex);
                throw ex;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setGenerateDyItem(Book book, boolean isTargetGenerateDyItem) {
        boolean isSrcGenerateDyItem = NewRptUtil.isGenerateDyItemFormula(book);
        boolean isGenerateDyItem = false;
        if (isTargetGenerateDyItem && !isSrcGenerateDyItem) {
            isGenerateDyItem = true;
        } else if (!isTargetGenerateDyItem && isSrcGenerateDyItem) {
            isGenerateDyItem = false;
        } else {
            return;
        }
        boolean isSuccess = false;
        try {
            for (int i = 0; i < book.getSheetCount(); ++i) {
                Sheet sheet = book.getSheet(i);
                ArrayList basePoints = DynamicTemplateUtility.getBasePointList((Sheet)sheet);
                for (Object basePoint : basePoints) {
                    ItemFormula itemFormula;
                    Cell cell;
                    String dItemNumber;
                    DynaParameters param = DynamicTemplateUtility.getDynaParameters((Sheet)sheet, (Point)((Point)basePoint));
                    if (param.isGrade() && param.getDynaItemSource() == 0) continue;
                    boolean isVertical = param.getSpreadStyle() == 0;
                    DynaRptBasePointIndexHandle indexHandle = new DynaRptBasePointIndexHandle(param, (Point)basePoint, sheet, false, true);
                    int rowCount = -1;
                    int colCount = -1;
                    int startRow = -1;
                    int endRow = -1;
                    int startCol = -1;
                    int endCol = -1;
                    if (isVertical) {
                        colCount = DynamicTemplateUtility.getColCount((Sheet)sheet, (int)((Point)basePoint).y, (int)((Point)basePoint).x);
                        rowCount = param.getDefaultCounter() + 1 + indexHandle.getSumRangeCount();
                    } else {
                        rowCount = DynamicTemplateUtility.getRowCount((Sheet)sheet, (int)((Point)basePoint).y, (int)((Point)basePoint).x);
                        colCount = param.getDefaultCounter() + 1 + indexHandle.getSumRangeCount();
                    }
                    startRow = isVertical ? ((Point)basePoint).y + indexHandle.getBeforeDynaItemSumRangeCount() + 1 : ((Point)basePoint).y;
                    endRow = isVertical ? ((Point)basePoint).y + rowCount - 1 - indexHandle.getAfterDynaItemSumRangeCount() : ((Point)basePoint).y + rowCount - 1;
                    startCol = isVertical ? ((Point)basePoint).x : ((Point)basePoint).x + indexHandle.getBeforeDynaItemSumRangeCount() + 1;
                    int n = endCol = isVertical ? ((Point)basePoint).x + colCount - 1 : ((Point)basePoint).x + colCount - 1 - indexHandle.getAfterDynaItemSumRangeCount();
                    if (isVertical) {
                        for (int row = endRow; row >= startRow; --row) {
                            dItemNumber = null;
                            for (int col = endCol; col >= startCol; --col) {
                                cell = sheet.getCell(row, col, false);
                                if (cell == null) continue;
                                if (col == ((Point)basePoint).x) {
                                    if (isGenerateDyItem) {
                                        cell.removeUserObject(DItemNumber);
                                        continue;
                                    }
                                    cell.setUserObject(DItemNumber, dItemNumber);
                                    continue;
                                }
                                if (isGenerateDyItem) {
                                    cell.removeUserObject(DItemNumber);
                                    itemFormula = NewRptUtil.getItemFormula(cell, (Point)basePoint, true);
                                    cell.setUserObject("ITEM", (Object)itemFormula);
                                    continue;
                                }
                                if (dItemNumber == null && (itemFormula = NewRptUtil.getItemFormula(sheet, row, col)) != null && itemFormula.getDItemNumber() != null) {
                                    dItemNumber = itemFormula.getDItemNumber();
                                }
                                cell.removeUserObject("ITEM");
                                cell.setUserObject(DItemNumber, (Object)1);
                            }
                        }
                        continue;
                    }
                    for (int col = endCol; col >= startCol; --col) {
                        dItemNumber = null;
                        for (int row = endRow; row >= startRow; --row) {
                            cell = sheet.getCell(row, col, false);
                            if (cell == null) continue;
                            if (row == ((Point)basePoint).y) {
                                if (isGenerateDyItem) {
                                    cell.removeUserObject(DItemNumber);
                                    continue;
                                }
                                cell.setUserObject(DItemNumber, dItemNumber);
                                continue;
                            }
                            if (isGenerateDyItem) {
                                cell.removeUserObject(DItemNumber);
                                itemFormula = NewRptUtil.getItemFormula(cell, (Point)basePoint, true);
                                cell.setUserObject("ITEM", (Object)itemFormula);
                                continue;
                            }
                            if (dItemNumber == null && (itemFormula = NewRptUtil.getItemFormula(sheet, row, col)) != null && itemFormula.getDItemNumber() != null) {
                                dItemNumber = itemFormula.getDItemNumber();
                            }
                            cell.removeUserObject("ITEM");
                            cell.setUserObject(DItemNumber, (Object)1);
                        }
                    }
                }
            }
            isSuccess = true;
        }
        finally {
            if (isSuccess) {
                book.setUserObject(IsGenerateDyItemFormula, (Object)isTargetGenerateDyItem);
            }
        }
    }

    public static Object[] getCheckageBillSetFieldsInfo(Sheet activeSheet) {
        Object[] infos = new Object[2];
        int rowCount = activeSheet.getRows().getMaxIntMark() + 1;
        int cloCount = activeSheet.getCols().getMaxIntMark() + 1;
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < cloCount; ++j) {
                Object fieldsCount = activeSheet.getRange(i, j).getUserObject("fieldsCount");
                if (fieldsCount == null) continue;
                infos[0] = fieldsCount;
                infos[1] = new Point(j, i);
                return infos;
            }
        }
        return infos;
    }

    public static boolean veriyfCheckageBillSet(Context ctx, Book book, StringBuilder sb, boolean isVeriyfAllHead) {
        if (book == null) {
            return true;
        }
        ReportVariables variable = ReportVariables.loadFromBook((Book)book);
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            int sheet_type = variable.getIntValue("SheetClass", sheet.getSheetName(), 1);
            if (sheet_type != 51) continue;
            Object[] fieldsInfo = NewRptUtil.getCheckageBillSetFieldsInfo(sheet);
            Point basePoint = (Point)fieldsInfo[1];
            if (basePoint != null) {
                HashSet<String> existFieldsSet = new HashSet<String>();
                int cloCount = sheet.getCols().getMaxIntMark() + 1;
                for (int j = basePoint.x; j < cloCount; ++j) {
                    Range range = sheet.getRange(basePoint.y, j);
                    String fieldKey = (String)range.getUserObject("fieldKey");
                    if (StringUtils.isEmpty((String)fieldKey)) continue;
                    existFieldsSet.add(fieldKey);
                }
                Set<String> keySet = checkageBillSetInfoMap.keySet();
                HashSet<String> mustInputKeySet = new HashSet<String>();
                mustInputKeySet.addAll(keySet);
                mustInputKeySet.removeAll(existFieldsSet);
                if (mustInputKeySet.size() <= 0) continue;
                for (String key : mustInputKeySet) {
                    sb.append(AccountCheckUtil.getResourceString(ctx, "CheckageBillSet_Null", new Object[]{AccountCheckUtil.getResourceString(ctx, checkageBillSetInfoMap.get(key), null)}));
                    sb.append("\n");
                }
                continue;
            }
            if (!isVeriyfAllHead) continue;
            sb.append(AccountCheckUtil.getResourceString(ctx, "CheckageBillSet_HeadNull", new Object[]{sheet.getSheetName()}));
            sb.append("\n");
        }
        return sb.length() <= 0;
    }

    public static void printDebugLog(Logger logger, String msg) {
        if (DebugLogger.isDebug && logger != null) {
            logger.error((Object)msg);
        }
    }

    public static void catchItemRelationshipMap(Context ctx, int scope) throws Exception {
        if (scope >= 0) {
            itemRelationshipCatchMap.remove(scope);
            Map[] itemRelationShipMaps = NewRptUtil.getItemRelationShipMaps(ctx, scope);
            itemRelationshipCatchMap.put(scope, itemRelationShipMaps);
        }
    }

    public static void clearItemRelationshipMapCatch(int scope) {
        itemRelationshipCatchMap.remove(scope);
    }

    public static Map[] getItemRelationShipMaps(Context ctx, int scope) throws BOSException, EASBizException {
        Map[] itemRelationships = itemRelationshipCatchMap.get(scope);
        if (itemRelationships != null) {
            return itemRelationships;
        }
        ConcurrentHashMap itemNumCatchMap = new ConcurrentHashMap();
        ConcurrentHashMap itemIdDRemarkCatchMap = new ConcurrentHashMap();
        ConcurrentHashMap itemNumDCatchMap = new ConcurrentHashMap();
        Map relaShipMap = RptItemRelationshipFactory.getLocalInstance((Context)ctx).getItemRelationshipMap(scope);
        if (relaShipMap != null) {
            Map remarkMap = (Map)relaShipMap.get("remarkMap");
            relaShipMap.remove("remarkMap");
            for (Map.Entry entry : remarkMap.entrySet()) {
                itemIdDRemarkCatchMap.put(entry.getKey(), entry.getValue() == null ? "" : (String)entry.getValue());
            }
            Map itemIdMap = (Map)relaShipMap.get("itemIdMap");
            itemNumCatchMap.putAll(itemIdMap);
            relaShipMap.remove("itemIdMap");
            itemNumDCatchMap.putAll(relaShipMap);
        }
        return new Map[]{itemNumCatchMap, itemIdDRemarkCatchMap, itemNumDCatchMap};
    }

    public static void fillDItem(Context ctx, ReportBaseInfo info, Book book) {
        try {
            if (RptSrcTypeEnum.DYNAMICNORMALREPORT.equals((Object)info.getSourceType())) {
                for (int i = 0; i < book.getSheetCount(); ++i) {
                    Sheet sheet = book.getSheet(i);
                    if (!sheet.isEnableCalculation()) continue;
                    NewRptUtil.fillDItem(ctx, info, sheet);
                }
            }
        }
        catch (Throwable e) {
            logger.error((Object)"fillDItem error.", e);
        }
    }

    public static void fillDItem(Context ctx, ReportBaseInfo info, Sheet sheet) {
        try {
            if (RptSrcTypeEnum.DYNAMICNORMALREPORT.equals((Object)info.getSourceType())) {
                ArrayList basePoints = DynamicTemplateUtility.getBasePointList((Sheet)sheet);
                for (Object basePoint : basePoints) {
                    DynaParameters param = DynamicTemplateUtility.getDynaParameters((Sheet)sheet, (Point)((Point)basePoint));
                    if (param.isGrade() && param.getDynaItemSource() == 0) {
                        NewRptUtil.fillDItemByGrade(ctx, sheet, (Point)basePoint, param);
                        continue;
                    }
                    NewRptUtil.fillDItemNotGrade(ctx, sheet, (Point)basePoint, param);
                }
            }
        }
        catch (Throwable e) {
            logger.error((Object)"fillDItem error.", e);
        }
    }

    public static void fillDItemNotGrade(Context ctx, Sheet sheet, Point basePoint, DynaParameters param) throws Exception {
        boolean isVertical = param.getSpreadStyle() == 0;
        List<Integer> headItemIndexs = NewRptUtil.getHeadItemIndex(sheet, basePoint, isVertical);
        if (headItemIndexs == null || headItemIndexs.isEmpty()) {
            return;
        }
        if (param.getDynaItemSource() != 0) {
            return;
        }
        DynaRptBasePointIndexHandle indexHandle = new DynaRptBasePointIndexHandle(param, basePoint, sheet, true, true);
        int[] sumFormulaIndex = indexHandle.getSumRangeIndex(isVertical);
        int start = (isVertical ? basePoint.y : basePoint.x) + 1;
        int end = start + param.getDefaultCounter() + indexHandle.getSumRangeCount();
        for (int j = start; j <= end; ++j) {
            Variant value;
            Cell dCell;
            if (NewRptUtil.isSumItem(sumFormulaIndex, j) || (dCell = sheet.getCell(isVertical ? j : basePoint.y, isVertical ? basePoint.x : j, false)) == null || dCell.getFormula() == null || !dCell.getFormula().trim().startsWith("=") || (value = dCell.getValue()) == null || StringUtils.isEmpty((String)value.toString())) continue;
            String number = value.toString().trim();
            NewRptUtil.fillDItemByRowOrCol(sheet, headItemIndexs, number, j, isVertical ? basePoint.y : basePoint.x, isVertical);
        }
    }

    public static boolean isSumItem(int[] sumFormulaIndex, int index) {
        for (int i = 0; i < sumFormulaIndex.length - 1; ++i) {
            if (sumFormulaIndex[i] != index) continue;
            return true;
        }
        return false;
    }

    public static void fillDItemByGrade(Context ctx, Sheet sheet, Point basePoint, DynaParameters param) throws Exception {
        HashMap<Integer, DItemGradeEntryInfo> index_gradeMap = new HashMap<Integer, DItemGradeEntryInfo>();
        List<Integer> gradeIndexs = NewRptUtil.getHandleGradeIndexs(sheet, basePoint, index_gradeMap, param);
        if (gradeIndexs == null || gradeIndexs.isEmpty()) {
            return;
        }
        NewRptUtil.generateGradeDItem(ctx, sheet, basePoint, param, index_gradeMap, gradeIndexs);
    }

    public static List<Integer> getHandleGradeIndexs(Sheet sheet, Point basePoint, Map<Integer, DItemGradeEntryInfo> index_gradeMap, DynaParameters param) throws Exception {
        boolean isVertical = param.getSpreadStyle() == 0;
        int start = (isVertical ? basePoint.y : basePoint.x) + 1;
        int end = start + param.getDefaultCounter();
        ArrayList<Integer> gradeIndexs = new ArrayList<Integer>();
        boolean isHasFormula = false;
        DItemGradeInfo gradeInfo = DynamicTemplateUtility.getGradeInfo((Range)sheet.getRange(basePoint.y, basePoint.x));
        for (int i = start; i < end; ++i) {
            DItemGradeEntryInfo entry;
            ItemFormula item;
            Cell curCell = sheet.getCell(isVertical ? i : basePoint.y, isVertical ? basePoint.x : i, false);
            if (curCell != null && !StringUtils.isEmpty((String)curCell.getFormula()) && curCell.getFormula().trim().startsWith("=")) {
                isHasFormula = true;
            }
            if ((item = UserObjectHelper.getItemFormula((Cell)curCell)) == null || (entry = gradeInfo.find(item.getExt("GRADE_NUMBER"))) == null || entry.isLeaf() || !entry.isIncludeUnknowDetail()) continue;
            gradeIndexs.add(i);
            index_gradeMap.put(i, entry);
        }
        if (!isHasFormula) {
            return null;
        }
        return gradeIndexs;
    }

    public static void generateGradeDItem(Context ctx, Sheet sheet, Point basePoint, DynaParameters param, Map<Integer, DItemGradeEntryInfo> index_gradeMap, List<Integer> gradeIndexs) throws Exception {
        boolean isLeft = param.getPosition() == 1;
        boolean isVertical = param.getSpreadStyle() == 0;
        List<Integer> headItemIndexs = NewRptUtil.getHeadItemIndex(sheet, basePoint, isVertical);
        if (headItemIndexs == null || headItemIndexs.isEmpty()) {
            return;
        }
        int start = -1;
        int end = -1;
        int gradeSize = gradeIndexs.size();
        for (int i = 0; i < gradeSize; ++i) {
            boolean isManual;
            int gradeIndex = gradeIndexs.get(i);
            DItemGradeEntryInfo gradeEntry = index_gradeMap.get(gradeIndex);
            boolean bl = isManual = gradeEntry.getDetailSource() == 0;
            if (!isManual) continue;
            if (isLeft) {
                start = gradeIndex + 1;
                end = i + 1 < gradeSize ? gradeIndexs.get(i + 1) - 1 : (isVertical ? basePoint.y : basePoint.x) + param.getDefaultCounter();
            } else {
                start = i == 0 ? (isVertical ? basePoint.y : basePoint.x) : gradeIndexs.get(i - 1) + 1;
                end = gradeIndex - 1;
            }
            if (start >= end) continue;
            for (int j = start; j <= end; ++j) {
                Variant value;
                Cell dCell = sheet.getCell(isVertical ? j : basePoint.y, isVertical ? basePoint.x : j, false);
                if (dCell == null || dCell.getFormula() == null || !dCell.getFormula().trim().startsWith("=") || (value = dCell.getValue()) == null || StringUtils.isEmpty((String)value.toString())) continue;
                String number = gradeEntry.getGrade() + ".D_" + value.toString().trim();
                NewRptUtil.fillDItemByRowOrCol(sheet, headItemIndexs, number, j, gradeIndex, isVertical);
            }
        }
    }

    public static void fillDItemByRowOrCol(Sheet sheet, List<Integer> headItemIndexs, String number, int rowOrColIndex, int headIndex, boolean isVertical) throws Exception {
        if (!StringUtils.isEmpty((String)number)) {
            for (int headItemIndex : headItemIndexs) {
                ItemFormula headItem = UserObjectHelper.getItemFormula((Range)sheet.getRange(isVertical ? headIndex : headItemIndex, isVertical ? headItemIndex : headIndex), (boolean)false);
                if (headItem == null) {
                    return;
                }
                StringBuffer strBuffer = new StringBuffer();
                strBuffer.append("=DItem(\"");
                strBuffer.append(headItem.getItemNumber() + "\",\"");
                strBuffer.append(number + "\",");
                strBuffer.append(headItem.getYearOffSet() + ",");
                strBuffer.append(headItem.getPeriodOffSet() + ",\"");
                strBuffer.append(headItem.getDataElementNumber() + "\",\"");
                ValueTypeEnum type = ValueTypeEnum.getEnum((int)headItem.getValueType());
                if (type == null) {
                    return;
                }
                strBuffer.append(type.getName());
                strBuffer.append("\")");
                ItemFormula ditem = new ItemFormula(strBuffer.toString());
                Range rangeFill = sheet.getRange(isVertical ? rowOrColIndex : headItemIndex, isVertical ? headItemIndex : rowOrColIndex);
                rangeFill.setUserObject("ITEM", (Object)ditem);
            }
        }
    }

    public static List<Integer> getHeadItemIndex(Sheet sheet, Point basePoint, boolean isVertical) throws Exception {
        ArrayList<Integer> headItemIndexs = new ArrayList<Integer>();
        int start = isVertical ? basePoint.x : basePoint.y;
        int end = isVertical ? sheet.getMaxColIndex() : sheet.getMaxRowIndex();
        for (int i = start; i <= end; ++i) {
            if (!DynamicTemplateUtility.isDynaHeadItemCell((Sheet)sheet, (int)(isVertical ? basePoint.y : i), (int)(isVertical ? i : basePoint.x))) continue;
            headItemIndexs.add(i);
        }
        return headItemIndexs;
    }

    public static void main(String[] args) {
        char[] chars = new char[]{'k', 's', '4', 'l', 'e', ':', 't', 'c', 's', 'y', 't', 'r', 'd', 'l', 'o', 'p', 'e', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4'};
        String pw1 = NewRptUtil.encodePassword(chars);
        String pw2 = KSqlUtil.encodePassword((String)new String(chars));
        System.out.println("------------------" + pw1.equals(pw2));
    }

    static {
        checkageBillSetInfoMap.put("year", "CheckageBillSet_Year");
        checkageBillSetInfoMap.put("period", "CheckageBillSet_Period");
        checkageBillSetInfoMap.put("companyNumber", "CheckageBillSet_CompanyNumber");
        checkageBillSetInfoMap.put("tarCompanyNumber", "CheckageBillSet_TarCompanyNumber");
        checkageBillSetInfoMap.put("itemTypeNumber", "CheckageBillSet_ItemTypeNumber");
        checkageBillSetInfoMap.put("itemNumber", "CheckageBillSet_ItemNumber");
        checkageBillSetInfoMap.put("dataElementNumber", "CheckageBillSet_DataElementNumber");
        checkageBillSetInfoMap.put("currencyNumber", "CheckageBillSet_CurrencyNumber");
        checkageBillSetInfoMap.put("debit", "CheckageBillSet_Debit");
        checkageBillSetInfoMap.put("credit", "CheckageBillSet_Credit");
    }
}

