/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.web.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveUtil;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveCalcHelper;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveExecParams;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveParams;
import com.kingdee.eas.fi.newrpt.web.TaskExecuteException;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.util.Locale;
import org.apache.log4j.Logger;

public abstract class AbstractRptTaskExecute {
    protected static final Logger logger = Logger.getLogger(AbstractRptTaskExecute.class);
    protected RptWeaveParams taskParam;
    protected Context ctx;
    protected String userId;

    public AbstractRptTaskExecute(RptWeaveParams taskParam, Context ctx) {
        this.taskParam = taskParam;
        this.ctx = ctx;
    }

    protected void beforeExecute() throws Exception {
        RptWeaveExecParams execParam = (RptWeaveExecParams)this.taskParam.getObject("rpt_web_execparams");
        this.userId = execParam.getUserId();
    }

    public void execute() throws Exception {
        this.beforeExecute();
        this.executeRptTask();
        this.afterExecute();
    }

    protected void afterExecute() {
    }

    protected abstract void executeRptTask() throws Exception;

    private FullOrgUnitInfo getCompanyOrgUnitInfo() {
        return (FullOrgUnitInfo)this.taskParam.getObject("KEY_COMPANY");
    }

    private TemplateInfo getTemplateInfo() {
        return (TemplateInfo)this.taskParam.getObject("KEY_TEMPLATE");
    }

    protected String getExistRptId() throws BOSException, EASBizException {
        RptWeaveExecParams execParam = (RptWeaveExecParams)this.taskParam.getObject("rpt_web_execparams");
        FullOrgUnitInfo orgUnitInfo = this.getCompanyOrgUnitInfo();
        String cslrptId = execParam.getCslrptId();
        if (StringUtils.isEmpty((String)cslrptId)) {
            TemplateInfo templateInfo = this.getTemplateInfo();
            int periodType = templateInfo.getPeriodType().getValue();
            int period = this.taskParam.getInt("Period");
            int year = this.taskParam.getInt("Year");
            CurrencyInfo currency = null;
            if (this.taskParam.containsKey("currency")) {
                currency = (CurrencyInfo)this.taskParam.getObject("currency");
            }
            if ((cslrptId = RptWeaveCalcHelper.getRptidInSameVersion((TemplateInfo)templateInfo, (OrgUnitInfo)orgUnitInfo, (CurrencyInfo)currency, (int)periodType, (int)period, (int)year, (Context)this.ctx)) == null) {
                throw new TaskExecuteException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"NOREPORT_CannotOPER", (Locale)this.ctx.getOriginLocale()));
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("isCommitReport"));
            ICslReport iReport = CslReportFactory.getLocalInstance((Context)this.ctx);
            CslReportInfo cslrptInfo = iReport.getCslReportInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)cslrptId)), sic);
            execParam.setCommitReport(cslrptInfo.isIsCommitReport());
            if (cslrptInfo.isIsCommitReport()) {
                try {
                    return RptAutoWeaveUtil.getReportInfoByCslrpt((Context)this.ctx, (String)cslrptInfo.getId().toString()).getId().toString();
                }
                catch (BOSException e) {
                    logger.error((Object)("getExistRptId:" + cslrptInfo.getId()), (Throwable)e);
                    throw e;
                }
            }
        }
        return cslrptId;
    }

    protected SelectorItemCollection getRptSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("dataCollect.*"));
        sic.add(new SelectorItemInfo("dataCollectNumber"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("sourceCurrency.name"));
        sic.add(new SelectorItemInfo("sourceCurrency.number"));
        sic.add(new SelectorItemInfo("sourceCurrency.precision"));
        sic.add(new SelectorItemInfo("orgRela.id"));
        sic.add(new SelectorItemInfo("orgRela.orgType"));
        sic.add(new SelectorItemInfo("orgRela.relaType"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.report.id"));
        sic.add(new SelectorItemInfo("postils.sheet.id"));
        sic.add(new SelectorItemInfo("postils.creator.id"));
        sic.add(new SelectorItemInfo("postils.creator.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.number"));
        sic.add(new SelectorItemInfo("savePoint.relaType"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.number"));
        sic.add(new SelectorItemInfo("savePoint.rptType.rptTypeStd"));
        sic.add(new SelectorItemInfo("sheetParam.*"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgType"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.id"));
        sic.add(new SelectorItemInfo("sheetParam.currency.number"));
        sic.add(new SelectorItemInfo("sheetParam.currency.name"));
        sic.add(new SelectorItemInfo("sheetParam.postils.*"));
        sic.add(new SelectorItemInfo("sheetParam.postils.report.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.sheet.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.name"));
        sic.add(new SelectorItemInfo("template.id"));
        sic.add(new SelectorItemInfo("template.name"));
        sic.add(new SelectorItemInfo("template.number"));
        sic.add(new SelectorItemInfo("template.templateType"));
        sic.add(new SelectorItemInfo("template.group"));
        sic.add(new SelectorItemInfo("template.dynaRptType"));
        return sic;
    }

    protected CslReportInfo getCslReportInfo(Context ctx, String reportID) throws Exception {
        ICslReport iReport = CslReportFactory.getLocalInstance((Context)ctx);
        return iReport.getCslReportInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)reportID)), RptAutoWeaveUtil.getCslRptSelectors());
    }
}

