/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.web.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.job.core.JobState;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.app.service.OrgPermissionService;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ColumnInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.TableInfo;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.newrpt.web.ReportCheckStatusEnum;
import com.kingdee.eas.fi.newrpt.web.ReportOperateEnum;
import com.kingdee.eas.fi.newrpt.web.ReportStatusEnum;
import com.kingdee.eas.fi.newrpt.web.ReportTaskExecuteFacadeFactory;
import com.kingdee.eas.fi.newrpt.web.TaskExecuteException;
import com.kingdee.eas.fi.newrpt.web.app.AbstractReportTaskFacadeControllerBean;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.ReportCollection;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ReportTaskFacadeControllerBean
extends AbstractReportTaskFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.web.app.ReportTaskFacadeControllerBean");
    private final String path = "com.kingdee.eas.fi.newrpt.web.RptWebResource";

    @Override
    protected List _getReportTastTemplate(Context ctx, int periodType, int orgType, String searchContent) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer sql = new StringBuffer();
        sql.append("select fid id,fnumber number,fname name,ftemplatetype templateType \n");
        sql.append("from t_rpt_template \n");
        sql.append("where fauditedstatus = ? \n");
        params.add(2);
        sql.append("and fversionstatus = ? \n");
        params.add(1);
        sql.append("and fpublishedstatus = ? \n");
        params.add(1);
        sql.append("and fisfreezed = 0 \n");
        sql.append("and fisk3tpl = 0 \n");
        sql.append("and ftemplatetype in (?,?,?) \n");
        params.add(6);
        params.add(10);
        params.add(15);
        sql.append("and fgrouptemplateid is null \n");
        sql.append("and fperiodtype = ? \n");
        params.add(periodType);
        sql.append("and forgtype = ? \n");
        params.add(orgType == 1 ? 1 : 6);
        if (!StringUtils.isEmpty((String)searchContent)) {
            sql.append("and (fnumber like ? or fname like ?) \n");
            params.add("%" + searchContent + "%");
            params.add("%" + searchContent + "%");
        }
        sql.append("order by number");
        IRowSet rs = DbUtil.executeQuery(ctx, sql.toString(), params.toArray());
        try {
            while (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("templateid", rs.getString("id"));
                map.put("templateNumber", rs.getString("number"));
                map.put("templateName", rs.getString("name"));
                String tmplType = RptTmpTypeEnum.getEnum((int)rs.getInt("templateType")).getAlias(ctx.getLocale());
                map.put("templateType", tmplType);
                result.add(map);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"Method[getReportTastTemplate]QueryError", (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _getReportTaskCompany(Context ctx, String templateid, int taskOperation, int orgType, int periodType, String taskNumber, String searchContent) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        ParamTempTblService srv = this.getAuthorizedOrg(ctx, orgType);
        String tblName = srv.getTmpTableName();
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append("select distinct unit.fid companyid,unit.fnumber companyNumber,case when unit.fname_" + ctx.getLocale() + " is null then unit.fname_l2 else unit.fname_" + ctx.getLocale() + " end companyName  \n");
        sql.append("from T_CSL_TempletDispense dispense \n");
        sql.append("inner join ").append(tblName).append(" temp on temp.Fid = dispense.fcompanyid \n");
        sql.append("inner join T_ORG_BaseUnit unit on unit.fid = dispense.fcompanyid \n");
        sql.append("where dispense.fdispensesrcid = ? \n");
        params.add(templateid);
        if (taskOperation != 3) {
            sql.append("and dispense.fcompanyid not in( \n");
            sql.append("select entry.funitid \n");
            sql.append("from T_CSL_ReportTaskentry entry \n");
            sql.append("inner join T_CSL_reportTask task on task.fid = entry.ftaskid \n");
            sql.append("where task.forgtype = ? \n");
            params.add(orgType == 1 ? 1 : 6);
            sql.append("and task.freportoperate = ? \n");
            params.add(taskOperation);
            sql.append("and task.fperiodtype= ? \n");
            params.add(periodType);
            if (!StringUtils.isEmpty((String)taskNumber)) {
                sql.append("and task.fnumber <> ? \n");
                params.add(taskNumber);
            }
            sql.append("and entry.ftemplateid in ( \n");
            sql.append(" select t.fid \n");
            sql.append(" from t_rpt_template t \n");
            sql.append(" inner join t_rpt_template t1 on t1.Fgroup = t.Fgroup \n");
            sql.append(" where t1.Fid = ?) \n");
            params.add(templateid);
            sql.append(") \n");
        }
        if (!StringUtils.isEmpty((String)searchContent)) {
            sql.append("and (unit.fnumber like ? or unit.fname_" + ctx.getLocale() + " like ?) \n");
            params.add("%" + searchContent + "%");
            params.add("%" + searchContent + "%");
        }
        sql.append("order by companyNumber");
        IRowSet rs = DbUtil.executeQuery(ctx, sql.toString(), params.toArray());
        try {
            while (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", rs.getString("companyid"));
                map.put("companyid", rs.getString("companyid"));
                map.put("companyNumber", rs.getString("companyNumber"));
                map.put("companyName", rs.getString("companyName"));
                result.add(map);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"Method[getReportTaskCompany]QueryError", (Throwable)e);
        }
        finally {
            srv.release();
        }
        return result;
    }

    private ParamTempTblService getAuthorizedOrg(Context ctx, int orgType) throws BOSException, EASBizException {
        Set result = this.getBizOrg(ctx, orgType);
        ParamTempTblService srv = this.getParamTempTblService(ctx, result);
        return srv;
    }

    private Set convertValueType(Set authorizedOrgidSet) {
        HashSet<String> result = new HashSet<String>();
        Iterator it = authorizedOrgidSet.iterator();
        while (it.hasNext()) {
            String orgid = String.valueOf(it.next());
            result.add(orgid);
        }
        return result;
    }

    private Set getBizOrg(Context ctx, int orgType) {
        HashSet<String> result = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append(" SELECT  unit.FID id \n").append(" FROM T_PM_OrgRange range \n").append(" INNER JOIN T_ORG_BaseUnit unit ON unit.FID = range.FOrgID \n").append(" WHERE  range.FUserID = ? AND range.FType = ? \n");
        params.add(ctx.getCaller().toString());
        params.add(10);
        try {
            IRowSet rs = DbUtil.executeQuery(ctx, sql.toString(), params.toArray());
            while (rs.next()) {
                String id = rs.getString("id");
                result.add(id);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"Method[getBizOrg]QueryError", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)"Method[getBizOrg]QueryError", (Throwable)e);
        }
        return result;
    }

    private ParamTempTblService getParamTempTblService(Context ctx, Collection ids) {
        TableInfo table = new TableInfo("t_temp_rpttask");
        table.addColumn(new ColumnInfo("fid", "varchar(44)"));
        ParamTempTblService service = ParamTempTblService.getInstance((Context)ctx, (TableInfo)table, (Collection)ids, null);
        return service;
    }

    @Override
    protected List _getTaskEntry(Context ctx, String taskid) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        StringBuffer sql = new StringBuffer();
        ArrayList<String> params = new ArrayList<String>();
        sql.append("select unit.fid unitid,unit.fnumber unitNumber,case when unit.fname_" + ctx.getLocale() + " is null then unit.fname_l2 else unit.fname_" + ctx.getLocale() + " end unitName,");
        sql.append("tmpl.fid tmplid,tmpl.fnumber tmplNumber,tmpl.fname tmplName \n");
        sql.append("from t_csl_reportTaskEntry entry \n");
        sql.append("inner join t_org_baseUnit unit on entry.funitid = unit.fid \n");
        sql.append("inner join t_rpt_template tmpl on entry.ftemplateid = tmpl.fid \n");
        sql.append("where entry.ftaskid=? \n");
        params.add(taskid);
        sql.append("order by tmplNumber");
        IRowSet rs = DbUtil.executeQuery(ctx, sql.toString(), params.toArray());
        try {
            while (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("tmplid", rs.getString("tmplid"));
                map.put("tmplNumber", rs.getString("tmplNumber"));
                map.put("tmplName", rs.getString("tmplName"));
                map.put("comid", rs.getString("unitid"));
                map.put("comNumber", rs.getString("unitNumber"));
                map.put("comName", rs.getString("unitName"));
                result.add(map);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"Method[getTaskEntry]QueryError", (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _getExistEntryInfo(Context ctx, List entry, Map task) throws BOSException, EASBizException {
        StringBuffer result = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        ArrayList<Integer> params = new ArrayList<Integer>();
        ParamTempTblService srv = this.getTempTblService(ctx, this.getParams(entry));
        String tblName = srv.getTmpTableName();
        int periodType = Integer.valueOf(String.valueOf(task.get("periodType")));
        int orgType = Integer.valueOf(String.valueOf(task.get("orgType")));
        int taskOperation = Integer.valueOf(String.valueOf(task.get("operation")));
        sql.append("select case when task.fname_" + ctx.getLocale() + " is null then task.fname_l2 else task.fname_" + ctx.getLocale() + " end taskname,unit.fnumber unitNumber,tmpl.fnumber tmplNumber \n");
        sql.append("from t_csl_reportTaskEntry entry \n");
        sql.append("inner join t_csl_reportTask task on task.fid = entry.ftaskid \n");
        sql.append("inner join t_org_baseUnit unit on entry.funitid = unit.fid \n");
        sql.append("inner join t_rpt_template tmpl on entry.ftemplateid = tmpl.fid \n");
        sql.append("inner join ").append(tblName).append(" temp on temp.ftemplateid = entry.ftemplateid").append(" and temp.fcompanyid = entry.funitid \n");
        sql.append("where task.forgtype = ? \n");
        params.add(orgType == 1 ? 1 : 6);
        sql.append("and task.freportoperate = ? \n");
        params.add(taskOperation);
        sql.append("and task.fperiodtype= ? \n");
        params.add(periodType);
        sql.append("order by taskname,tmplNumber,unitNumber");
        IRowSet rs = DbUtil.executeQuery(ctx, sql.toString(), params.toArray());
        int index = 0;
        String diffTaskName = null;
        try {
            String operation = ReportOperateEnum.getEnum(taskOperation).getAlias();
            String message = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.web.RptWebResource", (String)"errorInfoTitle", (Locale)ctx.getLocale());
            String detailMess = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.web.RptWebResource", (String)"errorInfoDetail", (Locale)ctx.getLocale());
            while (rs.next()) {
                String taskName = rs.getString("taskname");
                String templateNumber = rs.getString("tmplNumber");
                String companyNumber = rs.getString("unitNumber");
                if (index == 0 || diffTaskName != null && !diffTaskName.equals(taskName)) {
                    String title = MessageFormat.format(message, taskName);
                    result.append(title).append("<br/>");
                    diffTaskName = taskName;
                }
                String detail = MessageFormat.format(detailMess, operation, templateNumber, companyNumber);
                result.append(detail).append("<br/>");
                ++index;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"Method[getExistEntryInfo]QueryError", (Throwable)e);
        }
        finally {
            srv.release();
        }
        return result.toString();
    }

    private Set getParams(List entry) {
        HashSet result = new HashSet();
        int size = entry.size();
        for (int i = 0; i < size; ++i) {
            ArrayList<String> list = new ArrayList<String>();
            Map entryMap = (Map)entry.get(i);
            String tempalteid = String.valueOf(entryMap.get("tempalteid"));
            list.add(tempalteid);
            String companyid = String.valueOf(entryMap.get("companyid"));
            list.add(companyid);
            String groupid = String.valueOf(entryMap.get("groupid"));
            list.add(groupid);
            result.add(list);
        }
        return result;
    }

    private ParamTempTblService getTempTblService(Context ctx, Collection ids) {
        TableInfo table = new TableInfo("t_temp_rpttaskentry");
        table.addColumn(new ColumnInfo("ftemplateid", "varchar(44)"));
        table.addColumn(new ColumnInfo("fcompanyid", "varchar(44)"));
        table.addColumn(new ColumnInfo("fgroupid", "varchar(44)"));
        ParamTempTblService service = ParamTempTblService.getInstance((Context)ctx, (TableInfo)table, (Collection)ids, null);
        return service;
    }

    @Override
    protected List _getReportTask(Context ctx, boolean isScheme) throws BOSException, EASBizException {
        List result = new ArrayList();
        ArrayList<Object> params = new ArrayList<Object>();
        String currentOrgUnitid = ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
        this.updateCurrentOrgUnitID(ctx, currentOrgUnitid);
        StringBuffer sql = new StringBuffer();
        sql.append("select task.fid id,task.fnumber number,case when task.fname_" + ctx.getLocale() + " is null then task.fname_l2 else task.fname_" + ctx.getLocale() + " end name,task.freportoperate operateNum,case when creator.fname_" + ctx.getLocale() + " is null then creator.fname_l2 else creator.fname_" + ctx.getLocale() + " end creatorName,case when mender.fname_" + ctx.getLocale() + " is null then mender.fname_l2 else mender.fname_" + ctx.getLocale() + " end mender,task.FLastUpdateTime lastUpdateTime,");
        sql.append("case when dispenseduser.fname_" + ctx.getLocale() + " is null then dispenseduser.fname_l2 else dispenseduser.fname_" + ctx.getLocale() + " end  dispensedName,case when task.FRemark_" + ctx.getLocale() + " is null then task.FRemark_l2 else task.FRemark_" + ctx.getLocale() + " end remark,task.FIsForbidden isForbidden,task.FPeriodType periodType,case when task.FJobProcessDefId is null then 1 else 0 end isSchedule,task.FExcuteStatus excuteStatus \n");
        sql.append("from T_CSL_ReportTask task \n");
        sql.append("inner join T_PM_User creator on task.fcreatorid = creator.fid \n");
        sql.append("inner join T_PM_User mender on task.fLastUpdateuserid = mender.fid \n");
        sql.append("left outer join T_CSL_DispensedUser dispense on dispense.ftaskid = task.fid \n");
        sql.append("left outer join T_PM_User dispenseduser on dispense.fuserid = dispenseduser.fid \n");
        sql.append("where task.FCreateOrgUnitId=? \n");
        params.add(currentOrgUnitid);
        if (isScheme) {
            sql.append("and task.freportoperate in (?,?) \n");
            params.add(1);
            params.add(2);
        }
        sql.append("order by number");
        IRowSet rs = DbUtil.executeQuery(ctx, sql.toString(), params.toArray());
        try {
            while (rs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", rs.getString("id"));
                map.put("taskid", rs.getString("id"));
                map.put("number", rs.getString("number"));
                map.put("name", rs.getString("name"));
                map.put("operateNum", rs.getInt("operateNum"));
                map.put("operate", (Object)ReportOperateEnum.getEnum(rs.getInt("operateNum")));
                map.put("creator", rs.getString("creatorName"));
                map.put("mender", rs.getString("mender"));
                map.put("lastUpdateTime", this.timeFormat(rs.getString("lastUpdateTime")));
                map.put("user", rs.getString("dispensedName"));
                map.put("remark", rs.getString("remark"));
                map.put("isForbidden", rs.getString("isForbidden"));
                map.put("periodType", rs.getInt("periodType"));
                map.put("isSchedule", rs.getInt("isSchedule"));
                map.put("excuteStatus", rs.getInt("excuteStatus"));
                result = this.executeResult(result, map);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"Method[getReportTask]QueryError", (Throwable)e);
        }
        return result;
    }

    private List executeResult(List result, Map map) {
        if (result.size() == 0) {
            result.add(map);
        } else {
            boolean canAdd = true;
            String taskid = (String)map.get("taskid");
            String user = (String)map.get("user");
            for (int i = 0; i < result.size(); ++i) {
                Map map1 = (Map)result.get(i);
                String taskid1 = (String)map1.get("taskid");
                String user1 = (String)map1.get("user");
                if (!taskid.equals(taskid1)) continue;
                user1 = user1 + ',' + user;
                map1.put("user", user1);
                canAdd = false;
                break;
            }
            if (canAdd) {
                result.add(map);
            }
        }
        return result;
    }

    protected void updateCurrentOrgUnitID(Context ctx, String currentOrgUnitid) throws BOSException {
        try {
            StringBuffer sql = new StringBuffer();
            ArrayList<String> params = new ArrayList<String>();
            String userid = ctx.getCaller().toString();
            sql.append("select fid from T_CSL_ReportTask where fcreatorid =? and fcreateorgunitid is null ");
            params.add(userid);
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString(), params.toArray());
            StringBuffer sb = new StringBuffer();
            while (rowSet.next()) {
                String id = rowSet.getString("fid");
                sb.append("'").append(id).append("'").append(",");
            }
            if (sb.length() > 0) {
                params = new ArrayList();
                String ids = sb.substring(0, sb.length() - 1);
                sql = new StringBuffer();
                sql.append("update T_CSL_ReportTask set fcreateorgunitid = ? where fid in (").append(ids).append(")");
                params.add(currentOrgUnitid);
                DbUtil.execute(ctx, sql.toString(), params.toArray());
            }
        }
        catch (SQLException e) {
            logger.error((Object)"Method[getReportTask]QueryError", (Throwable)e);
        }
    }

    @Override
    protected Map _getDispensedRptTask(Context ctx, String taskids, List taskList) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> params = new ArrayList<String>();
        StringBuffer msg = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        sql.append("select task.fid taskid,case when task.fname_" + ctx.getLocale() + " is null then task.fname_l2 else task.fname_" + ctx.getLocale() + " end taskName \n");
        sql.append("from T_CSL_DispensedUser disp \n");
        sql.append("inner join T_CSL_ReportTask task on task.fid = disp.ftaskid \n");
        if (taskids.contains(",")) {
            String[] arrays = taskids.split(",");
            sql.append("where task.fid in ( ");
            int length = arrays.length;
            for (int i = 0; i < length; ++i) {
                sql.append("?");
                if (i < length - 1) {
                    sql.append(",");
                }
                params.add(arrays[i]);
            }
            sql.append(") \n");
        } else {
            sql.append("where task.fid = ? \n");
            params.add(taskids);
        }
        sql.append("order by task.fnumber");
        IRowSet rs = DbUtil.executeQuery(ctx, sql.toString(), params.toArray());
        ArrayList needDeletedList = new ArrayList();
        needDeletedList.addAll(taskList);
        try {
            String message = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.web.RptWebResource", (String)"isExistTask", (Locale)ctx.getLocale());
            while (rs.next()) {
                String taskid = rs.getString("taskid");
                int size = taskList.size();
                for (int i = 0; i < size; ++i) {
                    String id = (String)taskList.get(i);
                    if (!taskid.equals(id)) continue;
                    needDeletedList.remove(id);
                }
                String taskName = rs.getString("taskName");
                String detail = MessageFormat.format(message, taskName);
                msg.append(detail).append("<br/>");
            }
        }
        catch (SQLException e) {
            logger.error((Object)"Method[getDispensedRptTask]QueryError", (Throwable)e);
        }
        result.put("list", needDeletedList);
        result.put("msg", msg.toString());
        return result;
    }

    @Override
    protected List _getUserList(Context ctx, String search, int orgType) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        String permItemName = "fssc_rptWeb_view";
        OrgPermissionService service = new OrgPermissionService(ctx);
        Set authorizedOrgidSet = service.getAuthorizedOrgWithNoDetails(ctx.getCaller(), orgType == 1 ? OrgType.Company : OrgType.ProfitCenter, permItemName);
        Set ids = this.convertValueType(authorizedOrgidSet);
        ParamTempTblService srv = this.getParamTempTblService(ctx, ids);
        String tblName = srv.getTmpTableName();
        sql.append("select fid id,fnumber number,case when fname_" + ctx.getLocale() + " is null then fname_l2 else fname_" + ctx.getLocale() + " end name \n");
        sql.append("from T_PM_User \n");
        sql.append("where FIsDelete = 0 AND FAgentUser = 0 \n");
        sql.append("and ftype not in (?,?,?) \n");
        params.add(10);
        params.add(60);
        params.add(70);
        sql.append("and fid in( \n");
        sql.append("select distinct range.FUserID \n");
        sql.append("from T_PM_OrgRange range \n");
        sql.append("inner join ").append(tblName).append(" temp on temp.fID = range.FOrgID  \n");
        sql.append("where range.FType =?) \n");
        params.add(10);
        if (!StringUtils.isEmpty((String)search)) {
            sql.append("and (fnumber like ? or fname_" + ctx.getLocale() + " like ?) \n");
            params.add("%" + search + "%");
            params.add("%" + search + "%");
        }
        sql.append("order by number");
        IRowSet rs = DbUtil.executeQuery(ctx, sql.toString(), params.toArray());
        try {
            while (rs.next()) {
                String id = rs.getString("id");
                String number = rs.getString("number");
                String name = rs.getString("name");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("userid", id);
                map.put("userNumber", number);
                map.put("userName", name);
                result.add(map);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"Method[getUserList]QueryError", (Throwable)e);
        }
        return result;
    }

    @Override
    protected Map _getCommonQueryTask(Context ctx, boolean isQueryTaskForDispensedUser, List schemes) throws BOSException {
        HashMap result = new HashMap();
        ArrayList list = new ArrayList();
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append("select task.fid id,task.fnumber number,case when task.fname_" + ctx.getLocale() + " is null then task.fname_l2 else task.fname_" + ctx.getLocale() + " end name \n");
        sql.append("from t_csl_reportTask task \n");
        if (isQueryTaskForDispensedUser) {
            sql.append("inner join T_CSL_DispensedUser dispense on task.fid = dispense.ftaskid \n");
            sql.append("where  dispense.fuserid = ? \n");
            params.add(ctx.getCaller().toString());
        } else {
            sql.append(" where task.FCreateOrgUnitId= ? and task.FReportOperate in (?,?) \n");
            String currentOrgUnitid = ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
            params.add(currentOrgUnitid);
            params.add(1);
            params.add(2);
        }
        sql.append("order by number");
        IRowSet rs = DbUtil.executeQuery(ctx, sql.toString(), params.toArray());
        try {
            while (rs.next()) {
                String id = rs.getString("id");
                String number = rs.getString("number");
                String name = rs.getString("name");
                HashMap<String, Object> map = new HashMap<String, Object>();
                if (schemes != null && schemes.size() > 0) {
                    int size = schemes.size();
                    for (int i = 0; i < size; ++i) {
                        String schemeid = (String)schemes.get(i);
                        if (!id.equals(schemeid)) continue;
                        map.put("isDefault", true);
                        break;
                    }
                }
                map.put("id", id);
                map.put("number", number);
                map.put("name", name);
                list.add(map);
            }
            result.put("rows", list);
        }
        catch (SQLException e) {
            logger.error((Object)"Method[getCommonQueryTask]QueryError", (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _getCommonQueryCompany(Context ctx, String taskid, List companys) throws BOSException {
        HashMap result = new HashMap();
        ArrayList list = new ArrayList();
        StringBuffer sql = new StringBuffer();
        ArrayList<String> params = new ArrayList<String>();
        Object srv = null;
        try {
            sql.append("select distinct unit.fid id,unit.fnumber number,case when unit.fname_" + ctx.getLocale() + " is null then unit.fname_l2 else unit.fname_" + ctx.getLocale() + " end name,unit.flongnumber longnumber \n");
            sql.append("from t_csl_reportTaskEntry entry \n");
            sql.append("inner join t_org_baseUnit unit on entry.funitid = unit.fid \n");
            if (!StringUtils.isEmpty((String)taskid)) {
                if (taskid.contains(",")) {
                    sql.append(" and entry.ftaskid in ( ");
                    String[] schemeArray = taskid.split(",");
                    int length = schemeArray.length;
                    for (int i = 0; i < length; ++i) {
                        sql.append("?");
                        if (i < length - 1) {
                            sql.append(",");
                        }
                        params.add(schemeArray[i]);
                    }
                    sql.append(" ) \n");
                } else {
                    sql.append(" and entry.ftaskid = ? ");
                    params.add(taskid);
                }
            }
            sql.append("order by number");
            IRowSet rs = DbUtil.executeQuery(ctx, sql.toString(), params.toArray());
            HashMap<String, Object> map = new HashMap<String, Object>();
            while (rs.next()) {
                String id = rs.getString("id");
                String number = rs.getString("number");
                String name = rs.getString("name");
                String longnumber = rs.getString("longnumber");
                map = new HashMap();
                if (companys != null && companys.size() > 0) {
                    int size = companys.size();
                    for (int i = 0; i < size; ++i) {
                        String companyid = (String)companys.get(i);
                        if (!id.equals(companyid)) continue;
                        map.put("isDefault", true);
                        break;
                    }
                }
                map.put("id", id);
                map.put("number", number);
                map.put("name", name);
                map.put("longnumber", longnumber);
                list.add(map);
            }
            result.put("rows", list);
        }
        catch (SQLException e) {
            logger.error((Object)"Method[getCommonQueryTask]QueryError", (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _getCommonQueryTemplate(Context ctx, String taskid, String orgType, String companyid) throws BOSException {
        HashMap result = new HashMap();
        ArrayList list = new ArrayList();
        StringBuffer sql = new StringBuffer();
        int orgTypeInt = Integer.valueOf(orgType);
        String entrytempTable = this.getTempTable(ctx, taskid, orgTypeInt, companyid);
        sql.append(" SELECT distinct tmpl.fid id,tmpl.fnumber number,tmpl.fname name \n").append(" FROM T_RPT_Template tmpl \n").append(" INNER JOIN (Select distinct d.fdispensesrcid dispensesrcid,d.fcompanyid companyid \n").append(" FROM T_CSL_TempletDispense d \n").append(" INNER JOIN T_RPT_Template template ON d.fdispensesrcid = template.fid \n").append(" INNER JOIN ").append(entrytempTable).append(" temp ").append(" ON (temp.fTemplateid = template.FGroupTemplateid and d.fcompanyid = temp.fcompanyid) ").append(" OR (temp.fgroupid = template.fgroup and d.fcompanyid = temp.fcompanyid) \n").append(" WHERE template.fversionstatus = 1 AND template.FIsFreezed = 0) disp ").append(" ON tmpl.fid = disp.dispensesrcid \n").append(" ORDER BY number");
        IRowSet rs = DbUtil.executeQuery(ctx, sql.toString());
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            while (rs.next()) {
                String id = rs.getString("id");
                String number = rs.getString("number");
                String name = rs.getString("name");
                map = new HashMap();
                map.put("id", id);
                map.put("number", number);
                map.put("name", name);
                list.add(map);
            }
            result.put("rows", list);
        }
        catch (SQLException e) {
            logger.error((Object)"Method[getCommonQueryTemplate]QueryError", (Throwable)e);
        }
        finally {
            TempTablePool.getInstance((Context)ctx).releaseTable(entrytempTable);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _getReportsAndTemplates(Context ctx, Map condition) throws BOSException {
        String taskid = condition.get("taskid").toString();
        String templateids = condition.get("templateids").toString();
        String companyid = condition.get("companyid").toString();
        String currencyid = condition.get("currencyid").toString();
        int orgType = Integer.valueOf(condition.get("orgType").toString());
        SQLBuilder yearPeriodStr = new SQLBuilder();
        if (condition.containsKey("yearPeriodStr")) {
            Map map = (Map)condition.get("yearPeriodStr");
            this.getYearPeriodStr(map, yearPeriodStr);
        }
        int status = Integer.valueOf(condition.get("status").toString());
        boolean isNewQuery = Boolean.valueOf(condition.get("isNewQuery").toString());
        String searchTxt = null;
        if (condition.get("searchTxt") != null && condition.get("searchTxt") != "") {
            searchTxt = condition.get("searchTxt").toString();
        }
        String tplTable = null;
        String entryTempName = null;
        if (isNewQuery) {
            try {
                this.releaseTempTable(ctx, condition);
                tplTable = this.createTmplTable(ctx);
                entryTempName = this.getTempTable(ctx, taskid, orgType, null);
                this.insertReportData2TmplTbl(ctx, tplTable, entryTempName, yearPeriodStr, templateids, companyid, currencyid);
                if (yearPeriodStr.getSQL() != null && !yearPeriodStr.getSQL().contains(">")) {
                    this.insertTemplateData(ctx, tplTable, entryTempName);
                }
                TempTablePool.getInstance((Context)ctx).releaseTable(entryTempName);
            }
            catch (EASBizException e) {
                logger.error((Object)"Method[getReportsAndTemplates]QueryError", (Throwable)e);
            }
            finally {
                TempTablePool.getInstance((Context)ctx).releaseTable(entryTempName);
            }
        } else {
            tplTable = condition.get("tempName").toString();
        }
        List statusList = this.getStatistic(ctx, tplTable, status, currencyid, templateids, companyid, searchTxt);
        List list = this.getReportsAndTemplates(ctx, tplTable, currencyid, templateids, companyid, status, searchTxt);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", statusList);
        result.put("grid", list);
        result.put("tempName", tplTable);
        return result;
    }

    private void getYearPeriodStr(Map map, SQLBuilder yearPeriodStr) {
        String key = map.keySet().toArray()[0].toString();
        List dateList = (List)map.get(key);
        if (key.contains("range")) {
            this.getRangeYearPeriodStr(dateList, yearPeriodStr);
        } else if (key.contains("date")) {
            String[] keystrs = key.split("date");
            String keyStr = keystrs[1];
            String dateType = null;
            String periodType = null;
            if (keyStr.contains("cp")) {
                dateType = "cp";
                periodType = keyStr.split("cp")[1];
            } else if (keyStr.contains("tp")) {
                dateType = "tp";
                periodType = keyStr.split("tp")[1];
            } else if (keyStr.contains("lp")) {
                dateType = "lp";
                periodType = keyStr.split("lp")[1];
            } else if (keyStr.contains("sp")) {
                dateType = "sp";
                periodType = keyStr.split("sp")[1];
            } else if (keyStr.contains("yp")) {
                dateType = "yp";
                periodType = keyStr.split("yp")[1];
            }
            this.getDateYearPeriodStr(dateType, periodType, dateList, yearPeriodStr);
        } else if (key.contains("dateRange")) {
            this.getDateRangeYearPeriodStr(dateList, yearPeriodStr);
        }
    }

    private void getDateRangeYearPeriodStr(List<String> dateList, SQLBuilder yearPeriodStr) {
        int size = dateList.size();
        if (size == 2) {
            yearPeriodStr.append("rpt.fyear =? ", dateList.get(0)).append(" and rpt.fperiod =? ", dateList.get(1));
        } else {
            yearPeriodStr.append("rpt.fyear >=? ", dateList.get(0)).append(" and rpt.fperiod >=? ", dateList.get(1)).append(" and rpt.fyear <=? ", dateList.get(2)).append(" and rpt.fperiod <=? ", dateList.get(3));
        }
    }

    private void getRangeYearPeriodStr(List<String> dateList, SQLBuilder yearPeriodStr) {
        int size = dateList.size();
        if (size == 3) {
            yearPeriodStr.append(" rpt.fyear = ? ", dateList.get(0)).append(" and rpt.fperiod >= ?", dateList.get(1));
            yearPeriodStr.append(" and rpt.fperiod <= ?", dateList.get(2));
        } else {
            yearPeriodStr.append(" ((rpt.fyear = ? ", dateList.get(0)).append(" and rpt.fperiod >= ?", dateList.get(1)).append(")");
            yearPeriodStr.append(" or (rpt.fyear> ?", dateList.get(2)).append(" and rpt.fyear <? ", dateList.get(3)).append(") ");
            yearPeriodStr.append(" or (rpt.fyear =? ", dateList.get(4)).append(" and rpt.fperiod <= ? ", dateList.get(5)).append("))");
        }
    }

    private void getDateYearPeriodStr(String dateType, String periodType, List<String> dateList, SQLBuilder yearPeriodStr) {
        if ("cp".equals(dateType)) {
            if ("6".equals(periodType)) {
                yearPeriodStr.append("rpt.fyear = ?", dateList.get(0));
            } else {
                yearPeriodStr.append("rpt.fyear = ?", dateList.get(0)).append(" and rpt.fperiod =? ", dateList.get(1));
            }
        } else if ("tp".equals(dateType)) {
            if ("1".equals(periodType)) {
                yearPeriodStr.append("rpt.fyear = ?", dateList.get(0)).append(" and rpt.fperiod >=? ", dateList.get(1)).append(" and rpt.fperiod <=? ", dateList.get(2));
            } else if ("6".equals(periodType)) {
                yearPeriodStr.append("rpt.fyear = ?", dateList.get(0));
            } else {
                yearPeriodStr.append("rpt.fyear = ?", dateList.get(0)).append(" and rpt.fperiod =? ", dateList.get(1));
            }
        } else if ("lp".equals(dateType)) {
            if ("1".equals(periodType) || "2".equals(periodType)) {
                yearPeriodStr.append("rpt.fyear = ?", dateList.get(0)).append(" and rpt.fperiod >=? ", dateList.get(1)).append(" and rpt.fperiod <=? ", dateList.get(2));
            } else if ("3".equals(periodType)) {
                if (Integer.valueOf(dateList.get(1)) < 1) {
                    yearPeriodStr.append("rpt.fyear = ?", dateList.get(0)).append(" and rpt.fperiod in (12,13) ");
                } else {
                    yearPeriodStr.append("rpt.fyear = ?", dateList.get(0)).append(" and rpt.fperiod = ? ", dateList.get(1));
                }
            } else if ("4".equals(periodType)) {
                yearPeriodStr.append("rpt.fyear = ?", dateList.get(0)).append(" and rpt.fperiod = 3 ");
            } else if ("6".equals(periodType)) {
                yearPeriodStr.append("rpt.fyear = ?", dateList.get(0));
            }
        } else if ("sp".equals(dateType)) {
            if ("1".equals(periodType) || "2".equals(periodType)) {
                int size = dateList.size();
                if (size == 3) {
                    yearPeriodStr.append("rpt.fyear = ?", dateList.get(0)).append(" and rpt.fperiod >=? ", dateList.get(1)).append(" and rpt.fperiod <=? ", dateList.get(2));
                } else {
                    yearPeriodStr.append("((rpt.fyear = ?", dateList.get(0)).append(" and rpt.fperiod >=? ", dateList.get(1)).append(") ");
                    yearPeriodStr.append(" or (rpt.fyear>? ", dateList.get(2)).append(" and rpt.fyear <? ", dateList.get(3)).append(") ");
                    yearPeriodStr.append(" or (rpt.fyear=? ", dateList.get(4)).append(" and rpt.fperiod <= ? ", dateList.get(5)).append(")) ");
                }
            } else if ("3".equals(periodType)) {
                int period = Integer.valueOf(dateList.get(1));
                if (period == 1 || period == 2 || period == 3) {
                    yearPeriodStr.append("rpt.fyear =? ", dateList.get(0)).append(" and rpt.fperiod >= 1 and rpt.fperiod <= 3 ");
                } else if (period == 4 || period == 5 || period == 6) {
                    yearPeriodStr.append("rpt.fyear =? ", dateList.get(0)).append(" and rpt.fperiod >= 4 and rpt.fperiod <= 6 ");
                } else if (period == 7 || period == 8 || period == 9) {
                    yearPeriodStr.append("rpt.fyear = ?", dateList.get(0)).append(" and rpt.fperiod >= 7 and rpt.fperiod <= 9 ");
                } else if (period == 10 || period == 11 || period == 12) {
                    yearPeriodStr.append("rpt.fyear =? ", dateList.get(0)).append(" and rpt.fperiod >= 10 and rpt.fperiod <= 13 ");
                }
            } else if ("4".equals(periodType)) {
                yearPeriodStr.append("rpt.fyear =? ", dateList.get(0)).append(" and rpt.fperiod = 4");
            } else if ("6".equals(periodType)) {
                yearPeriodStr.append("rpt.fyear =? ", dateList.get(0));
            }
        } else if ("yp".equals(dateType)) {
            if ("3".equals(periodType)) {
                yearPeriodStr.append("rpt.fyear =? ", dateList.get(0)).append(" and rpt.fperiod >= 1 and rpt.fperiod <= 13 ");
            } else if ("6".equals(periodType)) {
                yearPeriodStr.append("rpt.fyear =? ", dateList.get(0));
            }
        }
    }

    private List getReportsAndTemplates(Context ctx, String tplTable, String currencyid, String templateids, String companyid, int status, String searchTxt) throws BOSException {
        ArrayList list = new ArrayList();
        StringBuffer sql = new StringBuffer(800);
        ArrayList<String> params = new ArrayList<String>();
        boolean isAddAnd = false;
        IRowSet rs = null;
        sql.append(" SELECT * FROM ").append(tplTable);
        if (!StringUtils.isEmpty((String)currencyid) || !StringUtils.isEmpty((String)templateids) || !StringUtils.isEmpty((String)companyid) || !StringUtils.isEmpty((String)searchTxt) || (StringUtils.isEmpty((String)currencyid) || StringUtils.isEmpty((String)currencyid) || StringUtils.isEmpty((String)currencyid)) && status != 0) {
            sql.append(" WHERE \n");
        }
        if (!StringUtils.isEmpty((String)currencyid) && status != 1) {
            if (status == 0) {
                sql.append(" ((isReport = 1 and sourceCurrID = ?) or isReport = 0) \n");
            } else {
                sql.append(" sourceCurrID = ? \n");
            }
            params.add(currencyid);
            isAddAnd = true;
        }
        if (!StringUtils.isEmpty((String)templateids)) {
            if (isAddAnd) {
                sql.append(" AND ");
            }
            this.getTemplateCondition(templateids, sql, params);
            isAddAnd = true;
        }
        if (!StringUtils.isEmpty((String)companyid)) {
            if (isAddAnd) {
                sql.append(" AND ");
            }
            sql.append(" companyID = ? \n");
            params.add(companyid);
            isAddAnd = true;
        }
        if (!StringUtils.isEmpty((String)searchTxt)) {
            if (isAddAnd) {
                sql.append(" AND ");
            }
            sql.append(" (tmplNumber like ? or tmplName like ? or rptNumber like ? or rptName like ?) \n");
            params.add(searchTxt);
            params.add(searchTxt);
            params.add(searchTxt);
            params.add(searchTxt);
            isAddAnd = true;
        }
        if (status != 0) {
            sql = this.getStatusCondition(status, sql, isAddAnd);
        }
        sql.append(" ORDER BY companyNumber,tmplNumber");
        rs = params.size() > 0 ? DbUtil.executeQuery(ctx, sql.toString(), params.toArray()) : DbUtil.executeQuery(ctx, sql.toString());
        try {
            Locale locale = ctx.getLocale();
            String yearMess = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.web.RptWebResource", (String)"year", (Locale)ctx.getLocale());
            String periodMess = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.web.RptWebResource", (String)"period", (Locale)ctx.getLocale());
            while (rs.next()) {
                this.setGridData(list, rs, locale, yearMess, periodMess);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"Method[getReportsAndTemplates]QueryError", (Throwable)e);
        }
        return list;
    }

    private void getTemplateCondition(String templateids, StringBuffer sql, List params) {
        if (templateids.contains(",")) {
            String[] tmplArray = templateids.split(",");
            sql.append(" tmplID in ( ");
            sql.append(" select t.fid \n");
            sql.append(" from t_rpt_template t \n");
            sql.append(" inner join t_rpt_template t1 on t1.Fgroup = t.Fgroup \n");
            sql.append(" where t1.Fid in ( \n");
            int length = tmplArray.length;
            for (int i = 0; i < length; ++i) {
                sql.append("?");
                if (i < length - 1) {
                    sql.append(",");
                }
                params.add(tmplArray[i]);
            }
            sql.append(" )) \n");
        } else {
            sql.append(" tmplID in ( \n");
            sql.append(" select t.fid \n");
            sql.append(" from t_rpt_template t \n");
            sql.append(" inner join t_rpt_template t1 on t1.Fgroup = t.Fgroup \n");
            sql.append(" where t1.Fid = ?) \n");
            params.add(templateids);
        }
    }

    private void setGridData(List list, IRowSet rs, Locale locale, String yearMess, String periodMess) throws SQLException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int isReport = rs.getInt("isReport");
        String id = rs.getString("ID");
        String tmplID = rs.getString("tmplID");
        int auditedStatus = rs.getInt("auditedStatus");
        int committedStatus = rs.getInt("committedStatus");
        int year = rs.getInt("year");
        int period = rs.getInt("period");
        int periodType = rs.getInt("periodType");
        String companyName = rs.getString("companyName");
        String companyid = rs.getString("companyID");
        int sourceType = rs.getInt("sourceType");
        String sourceCurrName = rs.getString("sourceCurrName");
        String tmplNumber = rs.getString("tmplNumber");
        String tmplName = rs.getString("tmplName");
        String versionNumber = rs.getString("versionNumber");
        String rptNumber = rs.getString("rptNumber");
        String rptName = rs.getString("rptName");
        String creatorName = rs.getString("creatorName");
        String createTime = rs.getString("createTime");
        String auditorName = rs.getString("auditorName");
        String auditedTime = rs.getString("auditedTime");
        String commitTime = rs.getString("commitTime");
        String reportTime = year + yearMess + period + periodMess;
        map.put("id", BOSUuid.create((BOSObjectType)new BOSObjectType("K511")));
        map.put("tmplID", tmplID);
        map.put("companyid", companyid);
        map.put("company", companyName);
        map.put("currency", sourceCurrName);
        map.put("tmplNumber", tmplNumber);
        map.put("tmplName", tmplName);
        map.put("versionNumber", versionNumber);
        if (isReport == 0) {
            map.put("reportid", null);
            map.put("statusNumber", 1);
            map.put("status", ReportStatusEnum.getEnum(1).getAlias(locale));
            map.put("rptNumber", null);
            map.put("rptName", null);
            map.put("reportTime", null);
            map.put("reportType", RptTmpTypeEnum.getEnum((int)sourceType).getAlias(locale));
            map.put("auditeTime", null);
            map.put("creator", null);
            map.put("createTime", null);
            map.put("auditor", null);
        } else {
            map.put("reportid", id);
            if (auditedStatus == 1) {
                map.put("statusNumber", 2);
                map.put("status", ReportStatusEnum.getEnum(2).getAlias(locale));
            } else if (auditedStatus == 2 && committedStatus == 1) {
                map.put("statusNumber", 3);
                map.put("status", ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.web.RptWebResource", (String)"auditedAndUncommit", (Locale)locale));
            } else if (auditedStatus == 2 && committedStatus == 3) {
                map.put("statusNumber", 4);
                map.put("status", ReportStatusEnum.getEnum(4).getAlias(locale));
            } else if (auditedStatus == 2 && committedStatus == 2) {
                map.put("statusNumber", 5);
                map.put("status", ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.web.RptWebResource", (String)"auditedAndCommit", (Locale)locale));
            }
            map.put("rptNumber", rptNumber);
            map.put("rptName", rptName);
            map.put("reportTime", reportTime);
            map.put("reportType", RptSrcTypeEnum.getEnum((int)sourceType).getAlias(locale));
            if (auditedStatus == 2 && committedStatus == 3) {
                map.put("auditeTime", this.timeFormat(commitTime));
            } else {
                map.put("auditeTime", this.timeFormat(auditedTime));
            }
            map.put("creator", creatorName);
            map.put("createTime", this.timeFormat(createTime));
            map.put("auditor", auditorName);
        }
        list.add(map);
    }

    private String timeFormat(String time) {
        if (time != null && time.length() >= 19) {
            time = time.substring(0, 19);
        }
        return time;
    }

    private StringBuffer getStatusCondition(int status, StringBuffer sql, boolean isAddAnd) {
        if (status == 1) {
            if (isAddAnd) {
                sql.append(" AND ");
            }
            sql.append(" isReport = 0 \n");
        } else if (status == 2) {
            if (isAddAnd) {
                sql.append(" AND ");
            }
            sql.append(" isReport = 1 and auditedStatus = 1 \n");
        } else if (status == 3) {
            if (isAddAnd) {
                sql.append(" AND ");
            }
            sql.append(" isReport = 1 and auditedStatus = 2 and committedStatus in (1,2) \n");
        } else if (status == 4) {
            if (isAddAnd) {
                sql.append(" AND ");
            }
            sql.append(" isReport = 1 and auditedStatus = 2 and committedStatus = 3 \n");
        }
        return sql;
    }

    private List getStatistic(Context ctx, String tmplTable, int statusCondition, String currencyid, String templateids, String companyid, String searchTxt) throws BOSException {
        ArrayList<Map<Object, Object>> list = new ArrayList<Map<Object, Object>>();
        StringBuffer sql = new StringBuffer(100);
        ArrayList params = new ArrayList();
        this.getStatusSql(tmplTable, currencyid, templateids, companyid, sql, params);
        IRowSet rs = DbUtil.executeQuery(ctx, sql.toString(), params.toArray());
        try {
            int total = 0;
            int uncreated = 0;
            int created = 0;
            int audited = 0;
            int received = 0;
            Locale locale = ctx.getOriginLocale();
            Map<String, Integer> map = new HashMap<String, Object>();
            map.put("name", (Integer)((Object)""));
            map.put("value", 0);
            if (statusCondition == 0) {
                map.put("isDefault", (Integer)((Object)Boolean.valueOf(true)));
            }
            list.add(map);
            while (rs.next()) {
                map = new HashMap();
                int status = rs.getInt("state");
                String name = ReportStatusEnum.getEnum(status).getAlias(locale);
                if (status == 1) {
                    uncreated = rs.getInt("cnt");
                    map.put("name", (Integer)((Object)(name + "\uff08" + uncreated + "\uff09")));
                    map.put("value", status);
                    if (statusCondition == 1) {
                        map.put("isDefault", (Integer)((Object)Boolean.valueOf(true)));
                    }
                } else if (status == 2) {
                    created = rs.getInt("cnt");
                    map.put("name", (Integer)((Object)(name + "\uff08" + created + "\uff09")));
                    map.put("value", status);
                    if (statusCondition == 2) {
                        map.put("isDefault", (Integer)((Object)Boolean.valueOf(true)));
                    }
                } else if (status == 3) {
                    audited = rs.getInt("cnt");
                    map.put("name", (Integer)((Object)(name + "\uff08" + audited + "\uff09")));
                    map.put("value", status);
                    if (statusCondition == 3) {
                        map.put("isDefault", (Integer)((Object)Boolean.valueOf(true)));
                    }
                } else if (status == 4) {
                    received = rs.getInt("cnt");
                    map.put("name", (Integer)((Object)(name + "\uff08" + received + "\uff09")));
                    map.put("value", status);
                    if (statusCondition == 4) {
                        map.put("isDefault", (Integer)((Object)Boolean.valueOf(true)));
                    }
                }
                list.add(map);
            }
            total = uncreated + created + audited + received;
            String name = ReportStatusEnum.getEnum(0).getAlias(locale);
            map = (Map)list.get(0);
            map.put("name", (Integer)((Object)(name + "\uff08" + total + "\uff09")));
        }
        catch (SQLException e) {
            logger.error((Object)"Method[getStatistic]QueryError", (Throwable)e);
        }
        return list;
    }

    private void getStatusSql(String tmplTable, String currencyid, String templateids, String companyid, StringBuffer sql, List params) {
        sql.append(" SELECT count(1) as cnt, 1 as state FROM ").append(tmplTable).append("  \n").append(" WHERE isReport = 0 ");
        if (!StringUtils.isEmpty((String)companyid)) {
            sql.append(" AND companyID = ? \n");
            params.add(companyid);
        }
        if (!StringUtils.isEmpty((String)templateids)) {
            sql.append(" AND ");
            this.getTemplateCondition(templateids, sql, params);
        }
        sql.append(" union all \n").append(" Select count(1) as cnt, 2 as state from ").append(tmplTable).append("   \n").append(" where isReport = 1 and auditedStatus = 1  \n");
        if (!StringUtils.isEmpty((String)currencyid)) {
            sql.append(" AND sourceCurrID = ?");
            params.add(currencyid);
        }
        if (!StringUtils.isEmpty((String)companyid)) {
            sql.append(" AND companyID = ? \n");
            params.add(companyid);
        }
        if (!StringUtils.isEmpty((String)templateids)) {
            sql.append(" AND ");
            this.getTemplateCondition(templateids, sql, params);
        }
        sql.append(" union all \n").append(" Select count(1) as cnt, 3 as state from ").append(tmplTable).append("   \n").append(" where isReport = 1 and auditedStatus = 2 and committedStatus in (1,2) \n");
        if (!StringUtils.isEmpty((String)currencyid)) {
            sql.append(" AND sourceCurrID = ?");
            params.add(currencyid);
        }
        if (!StringUtils.isEmpty((String)companyid)) {
            sql.append(" AND companyID = ? \n");
            params.add(companyid);
        }
        if (!StringUtils.isEmpty((String)templateids)) {
            sql.append(" AND ");
            this.getTemplateCondition(templateids, sql, params);
        }
        sql.append(" union all \n").append(" Select count(1) as cnt, 4 as state from ").append(tmplTable).append("   \n").append(" where isReport = 1 and auditedStatus = 2 and committedStatus = 3 \n");
        if (!StringUtils.isEmpty((String)currencyid)) {
            sql.append(" AND sourceCurrID = ?");
            params.add(currencyid);
        }
        if (!StringUtils.isEmpty((String)companyid)) {
            sql.append(" AND companyID = ? \n");
            params.add(companyid);
        }
        if (!StringUtils.isEmpty((String)templateids)) {
            sql.append(" AND ");
            this.getTemplateCondition(templateids, sql, params);
        }
    }

    private void releaseTempTable(Context ctx, Map condition) {
        if (condition.containsKey("tempName")) {
            String tplTable = condition.get("tempName").toString();
            TempTablePool.getInstance((Context)ctx).releaseTable(tplTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTempTable(Context ctx, String taskid, int orgType, String companyid) throws BOSException {
        StringBuffer sql = new StringBuffer();
        ArrayList<String> params = new ArrayList<String>();
        ArrayList list = new ArrayList();
        String tblName = null;
        sql.append(" SELECT entry.ftemplateid tmplid,entry.funitid unitid,tmpl.fgroup groupid \n");
        sql.append(" FROM t_csl_reportTaskEntry entry \n");
        sql.append(" INNER JOIN t_rpt_template tmpl ON tmpl.fid = entry.ftemplateid \n");
        sql.append(" WHERE entry.ftaskid = ? \n");
        params.add(taskid);
        if (!StringUtils.isEmpty((String)companyid)) {
            sql.append(" and entry.funitid = ? \n");
            params.add(companyid);
        }
        IRowSet rs = DbUtil.executeQuery(ctx, sql.toString(), params.toArray());
        try {
            while (rs.next()) {
                String tmplid = rs.getString("tmplid");
                String unitid = rs.getString("unitid");
                String groupid = rs.getString("groupid");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("tempalteid", tmplid);
                map.put("companyid", unitid);
                map.put("groupid", groupid);
                list.add(map);
            }
            ParamTempTblService srv = this.getTempTblService(ctx, this.getParams(list));
            tblName = srv.getTmpTableName();
        }
        catch (SQLException e) {
            logger.error((Object)"Method[getTempTable]QueryError", (Throwable)e);
        }
        return tblName;
    }

    private String createTmplTable(Context ctx) throws BOSException {
        String tableName;
        StringBuffer createSql = new StringBuffer(300);
        createSql.append(" create table Tmp_ReportWorkTable_Table(").append(" ID VARCHAR(44),tmplID VARCHAR(44),companyID VARCHAR(44),").append(" companyName NVARCHAR(80),companyNumber NVARCHAR(80),sourceType INT,").append(" rptNumber NVARCHAR(80),rptName NVARCHAR(80),").append(" periodType INT,reportPeriod DateTime,year INT,period INT,").append(" sourceCurrName NVARCHAR(80),sourceCurrID VARCHAR(44),").append(" auditedStatus INT, committedStatus INT,").append(" tmplNumber NVARCHAR(80),tmplName NVARCHAR(80),").append(" versionNumber NVARCHAR(80),groupid VARCHAR(44),").append(" auditedTime DateTime,commitTime DateTime,auditorName NVARCHAR(80),").append(" creatorName NVARCHAR(80),createTime DateTime,").append(" isReport INT,creatorId VARCHAR(44))");
        try {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            tableName = pool.createTempTable(createSql.toString());
            pool.createIndex(tableName, "isReport", false, false);
            pool.createIndex(tableName, "auditedStatus,committedStatus", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tableName;
    }

    private void insertReportData2TmplTbl(Context ctx, String tplTable, String entryTplTable, SQLBuilder yearPeriodStr, String templateids, String companyid, String currencyid) throws BOSException, EASBizException {
        SQLBuilder sql = this.getInsertReportDataSQL(ctx, tplTable, entryTplTable, yearPeriodStr, templateids, companyid, currencyid);
        ArrayList<Object> params = new ArrayList<Object>();
        if (!StringUtils.isEmpty((String)currencyid)) {
            sql.append(" AND rpt.FSourceCurrencyID = ?", currencyid);
        }
        if (!StringUtils.isEmpty((String)companyid)) {
            sql.append(" AND rpt.FCompanyID = ?  \n", companyid);
        }
        if (!StringUtils.isEmpty((String)templateids)) {
            if (templateids.contains(",")) {
                String[] tmplArray = templateids.split(",");
                sql.append(" AND rpt.FTemplateID in ( ");
                sql.append(" select t.fid \n");
                sql.append(" from t_rpt_template t \n");
                sql.append(" inner join t_rpt_template t1 on t1.Fgroup = t.Fgroup \n");
                sql.append(" where t1.Fid in  \n", tmplArray);
                sql.append(") \n");
            } else {
                sql.append(" AND rpt.FTemplateID in ( \n");
                sql.append(" select t.fid \n");
                sql.append(" from t_rpt_template t \n");
                sql.append(" inner join t_rpt_template t1 on t1.Fgroup = t.Fgroup \n");
                sql.append(" where t1.Fid = ?) \n", templateids);
            }
        }
        Object[] parameters = sql.getParams();
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i] instanceof ArrayList) {
                ArrayList list = (ArrayList)parameters[i];
                for (Object param : list) {
                    params.add(param);
                }
                continue;
            }
            params.add(parameters[i]);
        }
        DbUtil.execute(ctx, sql.getSQL(), params.toArray());
    }

    private SQLBuilder getInsertReportDataSQL(Context ctx, String tplTable, String entryTplTable, SQLBuilder yearPeriodStr, String templateids, String companyid, String currencyid) throws BOSException {
        String lan = ctx.getLocale().getLanguage();
        SQLBuilder sql = new SQLBuilder();
        sql.append(" INSERT INTO ").append(tplTable).append(" \n").append(" SELECT rpt.FID ID,rpt.FTemplateID tmplID,company.FID companyID,case when company.FName_" + lan + " is null then company.FName_l2 else company.FName_" + lan + " end companyName, \n").append(" company.FNumber companyNumber,rpt.FSourceType sourceType,rpt.FNumber rptNumber,rpt.FName rptName, \n").append(" rpt.FPeriodType periodType,rpt.FEndDate as reportPeriod,rpt.FYear Fyear, \n").append(" rpt.FPeriod period,sourceCurr.FName_" + lan + " sourceCurrName, \n").append(" sourceCurr.fID sourceCurrID,rpt.FAuditedStatus auditedStatus, \n").append(" rpt.FCommittedStatus committedStatus, \n").append(" tmpl.FNumber tmplNumber,tmpl.FName tmplName,tmpl.FVersionNumber versionNumber,tmpl.FGroup groupid, \n").append(" rpt.FAuditedTime auditedTime,rpt.FCommitTime commitTime,auditor.FName_" + lan + " auditName,\n").append(" creator.FName_" + lan + " creatorName,rpt.FCreateTime createTime, \n").append(" 1 AS isReport,rpt.FcreatorId creatorId \n").append(" FROM t_rpt_report rpt \n").append(" INNER JOIN t_org_BaseUnit company ON rpt.FCompanyID = company.FID \n").append(" INNER JOIN t_rpt_template tmpl ON rpt.FTemplateID = tmpl.FID \n").append(" INNER JOIN ").append(entryTplTable).append(" temp ON (rpt.FTemplateID=temp.ftemplateid AND rpt.FCompanyID=temp.fcompanyid) ").append(" OR (tmpl.FGroupTemplateid=temp.ftemplateid AND rpt.FCompanyID=temp.fcompanyid) OR (tmpl.fgroup=temp.fgroupid AND rpt.FCompanyID=temp.fcompanyid) \n").append(" INNER JOIN t_bd_currency sourceCurr ON sourceCurr.FID = rpt.FSourceCurrencyID \n").append(" LEFT JOIN t_pm_user auditor ON rpt.FAuditorID = auditor.FID \n").append(" INNER JOIN t_pm_user creator ON rpt.FCreatorID = creator.FID \n").append(" WHERE rpt.FIsSupportGroup =1 AND ").append(yearPeriodStr).append(" And rpt.FSourceType != 100 \n");
        return sql;
    }

    private void insertTemplateData(Context ctx, String tmplTable, String entrytempTable) throws BOSException, EASBizException {
        StringBuffer sql = this.getInsertTemplateDataSQL(ctx, tmplTable, entrytempTable);
        DbUtil.execute(ctx, sql.toString());
    }

    private StringBuffer getInsertTemplateDataSQL(Context ctx, String tempTable, String entrytempTable) throws BOSException {
        String lan = ctx.getLocale().getLanguage();
        StringBuffer sql = new StringBuffer(1000);
        sql.append(" INSERT INTO ").append(tempTable).append(" \n").append(" SELECT * FROM (").append(" SELECT template.FID ID,template.FID tmplID,company.FID companyID,case when company.FName_" + lan + " is null then company.FName_l2 else company.FName_" + lan + " end companyName,\n").append(" company.FNumber companyNumber,template.FTemplateType sourceType, \n").append(" NULL AS rptNumber,NULL AS rptName,template.FperiodType periodType , CONVERT(DATETIME,NULL) as reportPeriod, \n").append(" -1 as fyear,-1 period,null AS sourceCurrName, null AS sourceCurrID, \n").append(" -1 as auditedStatus,-1 AS committedStatus, \n").append(" template.FNumber tmplNumber,template.FName tmplName,template.FVersionNumber versionNumber,template.FGroup groupid, \n").append(" template.fAuditedTime auditedTime, CONVERT(DATETIME,NULL) AS commitTime,auditor.FName_" + lan + " auditName,\n").append(" creator.FName_" + lan + " creatorName,template.FCreateTime createTime , \n").append(" 0 AS isReport,template.FcreatorId creatorId \n").append(" FROM T_RPT_Template template \n").append(" INNER JOIN (Select distinct d.fdispensesrcid dispensesrcid,d.fcompanyid companyid \n").append(" FROM T_CSL_TempletDispense d \n").append(" INNER JOIN T_RPT_Template template ON d.fdispensesrcid = template.fid \n").append(" INNER JOIN ").append(entrytempTable).append(" temp ").append(" ON (temp.fTemplateid = template.FGroupTemplateid and d.fcompanyid = temp.fcompanyid) ").append(" OR (template.fgroup=temp.fgroupid and d.fcompanyid = temp.fcompanyid) \n").append(" WHERE template.fversionstatus = 1 AND template.FIsFreezed = 0) disp ").append(" ON template.fid = disp.dispensesrcid \n").append(" INNER JOIN t_org_BaseUnit AS company ON disp.companyid = company.FID \n").append(" INNER JOIN T_PM_User AS creator ON template.FCreatorID = creator.FID \n").append(" LEFT JOIN T_PM_User AS auditor ON template.FAuditorID = auditor.FID \n").append(" WHERE template.FVersionStatus = 1 and template.fisfreezed = 0 \n").append(" and template.FPublishedStatus = 1 ) t \n").append(" WHERE NOT EXISTS ( \n").append(" SELECT 'X' FROM ").append(tempTable).append(" t1  WHERE t.groupid = t1.groupid and t.companyID = t1.companyID) \n");
        return sql;
    }

    @Override
    protected String _batchDeleteReport(Context ctx, List reportids) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        int size = reportids.size();
        for (int i = 0; i < size; ++i) {
            String id = reportids.get(i).toString();
            ObjectUuidPK pk = new ObjectUuidPK(id);
            ReportFactory.getLocalInstance((Context)ctx).delete((IObjectPK)pk);
        }
        return null;
    }

    @Override
    protected void _batchCheckReport(Context ctx, List reportids) throws BOSException, EASBizException {
        try {
            reportids = Arrays.asList(this.getCheckReportCollection(ctx, reportids).toArray());
            IReport ireport = ReportFactory.getLocalInstance((Context)ctx);
            IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
            BatchCheckTask job = new BatchCheckTask(ctx, reportids, ireport, iFullOrgUnit);
            job.start();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchDeleteCheckResultByReportIds(Context ctx, List ids) {
        PreparedStatement ps;
        Connection cn;
        block5: {
            cn = null;
            ps = null;
            StringBuffer sql = new StringBuffer();
            sql.append("DELETE FROM T_CSL_ReportCheckResult WHERE FReportid = ?");
            try {
                cn = EJBFactory.getConnection((Context)ctx);
                ps = cn.prepareStatement(sql.toString());
                boolean isEmpty = true;
                int size = ids.size();
                for (int i = 0; i < size; ++i) {
                    isEmpty = false;
                    String id = ids.get(i).toString();
                    ps.setObject(1, id);
                    ps.addBatch();
                }
                if (isEmpty) break block5;
                ps.executeBatch();
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"batchDeleteCheckResultByReportIds", (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(ps, (Connection)cn);
                    throw throwable;
                }
                SQLUtils.cleanup((Statement)ps, (Connection)cn);
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)cn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchAddCheckResult(Context ctx, List ids, Map map) {
        PreparedStatement ps;
        Connection cn;
        block5: {
            cn = null;
            ps = null;
            StringBuffer sql = new StringBuffer();
            sql.append("INSERT INTO T_CSL_ReportCheckResult VALUES (?,?,?,?,?,?,?,?,?)");
            try {
                cn = EJBFactory.getConnection((Context)ctx);
                ps = cn.prepareStatement(sql.toString());
                boolean isEmpty = true;
                int size = ids.size();
                for (int i = 0; i < size; ++i) {
                    isEmpty = false;
                    String id = ids.get(i).toString();
                    Map reportMap = (Map)map.get(id);
                    String number = (String)reportMap.get("number");
                    String name = (String)reportMap.get("name");
                    Integer year = Integer.valueOf(reportMap.get("year").toString());
                    Integer period = Integer.valueOf(reportMap.get("period").toString());
                    Integer status = 0;
                    String company = (String)reportMap.get("company");
                    ps.setObject(1, id);
                    ps.setObject(2, company);
                    ps.setObject(3, id);
                    ps.setObject(4, number);
                    ps.setObject(5, name);
                    ps.setObject(6, year);
                    ps.setObject(7, period);
                    ps.setObject(8, status);
                    ps.setObject(9, null);
                    ps.addBatch();
                }
                if (isEmpty) break block5;
                ps.executeBatch();
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"batchAddCheckResult", (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(ps, (Connection)cn);
                    throw throwable;
                }
                SQLUtils.cleanup((Statement)ps, (Connection)cn);
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)cn);
    }

    private void excuteCheck(Context ctx, List ids, IReport ireport) {
        List rlist = null;
        try {
            rlist = ireport.reportBatchCheckNoParam(ids);
            Iterator it = rlist.iterator();
            ArrayList list = new ArrayList();
            while (it.hasNext()) {
                Integer status;
                String dtail;
                String id;
                Object obj = it.next();
                if (!(obj instanceof HashMap)) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                Map tempmap = (Map)obj;
                if (Boolean.TRUE.equals((Boolean)tempmap.get("CHECKPASSED"))) {
                    id = tempmap.get("REPORTID").toString();
                    dtail = null;
                    status = 1;
                    if (!StringUtils.isEmpty((String)((String)tempmap.get("CHECKMSG")))) {
                        dtail = tempmap.get("CHECKMSG").toString();
                        status = 2;
                    }
                    map.put("id", id);
                    map.put("status", status);
                    map.put("detail", dtail);
                } else {
                    id = tempmap.get("REPORTID").toString();
                    dtail = tempmap.get("CHECKMSG").toString();
                    status = 2;
                    map.put("id", id);
                    map.put("status", status);
                    map.put("detail", dtail);
                }
                list.add(map);
            }
            this.updateCheckResult(ctx, list);
        }
        catch (EASBizException e) {
            logger.error((Object)"excuteCheck", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"excuteCheck", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCheckResult(Context ctx, List list) {
        Connection cn = null;
        PreparedStatement ps = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_CSL_ReportCheckResult SET FStatus=?,FDetail=? WHERE Freportid = ?");
        if (list != null && list.size() > 0) {
            block7: {
                try {
                    cn = EJBFactory.getConnection((Context)ctx);
                    ps = cn.prepareStatement(sql.toString());
                    boolean isEmpty = true;
                    int size = list.size();
                    for (int i = 0; i < size; ++i) {
                        isEmpty = false;
                        Map map = (Map)list.get(i);
                        String id = map.get("id").toString();
                        String detail = null;
                        if (map.get("detail") != null) {
                            detail = map.get("detail").toString();
                        }
                        Integer status = Integer.valueOf(map.get("status").toString());
                        ps.setObject(1, status);
                        ps.setObject(2, detail);
                        ps.setObject(3, id);
                        ps.addBatch();
                    }
                    if (isEmpty) break block7;
                    ps.executeBatch();
                }
                catch (SQLException e) {
                    try {
                        logger.error((Object)"updateCheckResult", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(ps, (Connection)cn);
                        throw throwable;
                    }
                    SQLUtils.cleanup((Statement)ps, (Connection)cn);
                }
            }
            SQLUtils.cleanup((Statement)ps, (Connection)cn);
        }
    }

    private ReportCollection getCheckReportCollection(Context ctx, List ids) throws Exception {
        HashSet set = new HashSet(ids);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("company"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        view.setFilter(filter);
        ReportCollection reportCollection = ReportFactory.getLocalInstance((Context)ctx).getReportCollection(view);
        return reportCollection;
    }

    @Override
    protected List _getCheckResult(Context ctx, List reportids) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        StringBuffer sql = new StringBuffer();
        ArrayList<String> params = new ArrayList<String>();
        sql.append(" SELECT FReportid id,Fcompany company,FNumber number,FName name,FYear year,FPeriod period,FStatus status,FDetail detail \n");
        sql.append(" FROM T_CSL_ReportCheckResult \n");
        sql.append(" WHERE FReportid in ( ");
        int size = reportids.size();
        for (int i = 0; i < size; ++i) {
            sql.append("?");
            if (i < size - 1) {
                sql.append(",");
            }
            params.add(reportids.get(i).toString());
        }
        sql.append(") \n");
        try {
            IRowSet rs = DbUtil.executeQuery(ctx, sql.toString(), params.toArray());
            while (rs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                String company = rs.getString("company");
                String reportid = rs.getString("id");
                String number = rs.getString("number");
                String name = rs.getString("name");
                Integer year = rs.getInt("year");
                Integer period = rs.getInt("period");
                int status = rs.getInt("status");
                String detail = rs.getString("detail");
                if (!StringUtils.isEmpty((String)detail)) {
                    detail = "<p><b>" + detail + "</b></p>";
                }
                map.put("company", company);
                map.put("reportid", reportid);
                map.put("number", number);
                map.put("name", name);
                map.put("year", year);
                map.put("period", period);
                map.put("statusNumber", status);
                map.put("status", ReportCheckStatusEnum.getEnum(status).getAlias());
                map.put("detail", detail);
                result.add(map);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"getCheckResult", (Throwable)e);
        }
        return result;
    }

    @Override
    protected void _deleteCheckResult(Context ctx, List reportids) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        ArrayList<String> params = new ArrayList<String>();
        sql.append("DELETE FROM T_CSL_ReportCheckResult ");
        sql.append("WHERE FReportid in (");
        int size = reportids.size();
        for (int i = 0; i < size; ++i) {
            sql.append("?");
            if (i < size - 1) {
                sql.append(",");
            }
            params.add(reportids.get(i).toString());
        }
        sql.append(") \n");
        DbUtil.execute(ctx, sql.toString(), params.toArray());
    }

    @Override
    protected Map _getAuditResult(Context ctx) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        StringBuffer sql = new StringBuffer();
        ArrayList params = new ArrayList();
        sql.append("SELECT FID id,FDetail detail FROM T_CSL_ReportAuditResult ");
        IRowSet rs = DbUtil.executeQuery(ctx, sql.toString(), params.toArray());
        try {
            while (rs.next()) {
                String id = rs.getString("id");
                String detail = rs.getString("detail");
                result.put("id", id);
                result.put("detail", detail);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"getAuditResult", (Throwable)e);
        }
        return result;
    }

    @Override
    protected void _deleteAuditResult(Context ctx) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM T_CSL_ReportAuditResult ");
        DbUtil.execute(ctx, sql.toString());
    }

    @Override
    protected void _addAuditMessage(Context ctx, String id, String message) throws BOSException, EASBizException {
        this.deleteAuditResult(ctx);
        StringBuffer sql = new StringBuffer();
        ArrayList<String> params = new ArrayList<String>();
        sql.append("INSERT INTO T_CSL_ReportAuditResult VALUES(?,?)");
        params.add(id);
        params.add(message);
        DbUtil.execute(ctx, sql.toString(), params.toArray());
    }

    @Override
    protected CurrencyCollection _getCurrencyCollection(Context ctx) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        CurrencyCollection col = new CurrencyCollection();
        sql.append(" SELECT FID id,FNumber number,case when FName_" + ctx.getLocale().getLanguage() + " is null then FName_l2 else FName_" + ctx.getLocale().getLanguage() + " end name \n").append(" FROM T_BD_Currency \n").append(" WHERE FNumber NOT IN ('GRC','GLC') \n").append(" ORDER BY FNumber");
        IRowSet rs = DbUtil.executeQuery(ctx, sql.toString());
        try {
            while (rs.next()) {
                CurrencyInfo info = new CurrencyInfo();
                String id = rs.getString("id");
                String number = rs.getString("number");
                String name = rs.getString("name");
                info.setId(BOSUuid.read((String)id));
                info.setNumber(number);
                info.setName(name);
                col.add(info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"getCurrencyCollection", (Throwable)e);
        }
        return col;
    }

    @Override
    protected void _taskExecute(Context ctx, String taskid, Map params) throws BOSException, EASBizException {
        if (this.isCreateJobAndNOComplate(ctx, taskid)) {
            throw new TaskExecuteException(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.web.RptWebResource", (String)"EXECUTE_WARNING_CANNOT_DUP_EXECUTE"));
        }
        String userid = ctx.getCaller().toString();
        ReportTaskExecuteFacadeFactory.getLocalInstance(ctx).handExecuteRptTask(taskid, userid, params);
    }

    private boolean isCreateJobAndNOComplate(Context ctx, String taskId) throws BOSException {
        StringBuffer sql = new StringBuffer("select top 1 fid from T_CSL_RptTaskExecutedTask task");
        sql.append(" inner join T_JOB_INST  job on task.FJobinstid=job.fjobinstid ");
        sql.append(" where task.ftaskId=?  and task.fisusage=1 ");
        sql.append(" and fstate in('");
        sql.append(JobState.Created).append("','").append(JobState.ReScheduled).append("','").append(JobState.Running).append("')");
        Object[] params = new Object[]{taskId};
        try {
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString(), params);
            if (rowSet.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            return false;
        }
        return false;
    }

    @Override
    protected List _getUnassignUserList(Context ctx, List taskids, String search) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        ArrayList<String> params = new ArrayList<String>();
        HashMap<String, String> map = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct u.fid id,u.fnumber number,case when u.FName_" + ctx.getLocale().getLanguage() + " is null then u.FName_l2 else u.FName_" + ctx.getLocale().getLanguage() + " end name \n");
        sql.append(" from T_CSL_DispensedUser dispense \n");
        sql.append(" inner join t_pm_user u on dispense.fuserid = u.fid \n");
        sql.append(" where dispense.ftaskid in(");
        int size = taskids.size();
        for (int i = 0; i < size; ++i) {
            Map taskidmap = (Map)taskids.get(i);
            String taskid = (String)taskidmap.get("taskid");
            sql.append("?");
            if (i != size - 1) {
                sql.append(",");
            }
            params.add(taskid);
        }
        sql.append(") \n");
        if (!StringUtils.isEmpty((String)search)) {
            sql.append(" and (u.fnumber like ? or u.fname_" + ctx.getLocale().getLanguage() + " like ?) \n");
            params.add("%" + search + "%");
            params.add("%" + search + "%");
        }
        sql.append(" order by u.fnumber");
        try {
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString(), params.toArray());
            while (rowSet.next()) {
                map = new HashMap<String, String>();
                map.put("userid", rowSet.getString("id"));
                map.put("userNumber", rowSet.getString("number"));
                map.put("userName", rowSet.getString("name"));
                result.add(map);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"getUnassignUserList", (Throwable)e);
        }
        return result;
    }

    @Override
    protected void _startScheme(Context ctx, String schemeid) throws BOSException, EASBizException {
        String sql = "update t_csl_reportTask set FIsForbidden = 0 where fid = ?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(schemeid);
        DbUtil.execute(ctx, sql, params.toArray());
    }

    @Override
    protected void _forbiddenScheme(Context ctx, String schemeid) throws BOSException, EASBizException {
        String sql = "update t_csl_reportTask set FIsForbidden = 1 where fid = ?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(schemeid);
        DbUtil.execute(ctx, sql, params.toArray());
    }

    @Override
    protected List _getCompanyTaskList(Context ctx, Map params) throws BOSException, EASBizException {
        String search;
        String companyids;
        int i;
        int length;
        String schemeids;
        ArrayList result = new ArrayList();
        ArrayList<Object> param = new ArrayList<Object>();
        HashMap<String, Object> map = null;
        String currentOrgUnitid = ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" Select schms.schemeid schemeid,schms.schemeNumber schemeNumber,schms.schemeName schemeName,schms.operateNum operateNum, \n");
        sql.append(" schms.companyid companyid,case when unit.FNAME_" + ctx.getLocale() + " is null then unit.FNAME_L2 else unit.FNAME_" + ctx.getLocale() + " end companyName,schms.schemeStatus schemeStatus, \n");
        sql.append(" case when u.FName_" + ctx.getLocale() + " is null then u.FName_L2 else u.FName_" + ctx.getLocale() + " end operator,case when logs.FResultType = 2 then 1 else 0 end taskStatus,schms.periodType periodType \n");
        sql.append(" From ( \n");
        sql.append(" Select distinct schm.Fid schemeid,schm.FNumber schemeNumber,case when schm.FNAME_" + ctx.getLocale() + " is null then schm.FNAME_L2 else schm.FNAME_" + ctx.getLocale() + " end schemeName,schm.FReportOperate operateNum, \n");
        sql.append(" entry.FunitId companyid,schm.FIsForbidden schemeStatus,schm.FPeriodType periodType \n");
        sql.append(" from T_CSL_ReportTask schm \n");
        sql.append(" inner join T_CSL_ReportTaskEntry entry ON schm.Fid = entry.FTaskId \n");
        sql.append(" where schm.FCreateOrgUnitId= ? and schm.FReportOperate in (?,?) \n");
        param.add(currentOrgUnitid);
        param.add(1);
        param.add(2);
        if (params.containsKey("schemeids") && !StringUtils.isEmpty((String)(schemeids = (String)params.get("schemeids")))) {
            if (schemeids.contains(",")) {
                sql.append(" and schm.Fid in ( ");
                String[] schemeArray = schemeids.split(",");
                length = schemeArray.length;
                for (i = 0; i < length; ++i) {
                    sql.append("?");
                    if (i < length - 1) {
                        sql.append(",");
                    }
                    param.add(schemeArray[i]);
                }
                sql.append(" ) \n");
            } else {
                sql.append(" and schm.Fid = ? ");
                param.add(schemeids);
            }
        }
        if (params.containsKey("companyids") && !StringUtils.isEmpty((String)(companyids = (String)params.get("companyids")))) {
            if (companyids.contains(",")) {
                sql.append(" and entry.FunitId in ( ");
                String[] companyArray = companyids.split(",");
                length = companyArray.length;
                for (i = 0; i < length; ++i) {
                    sql.append("?");
                    if (i < length - 1) {
                        sql.append(",");
                    }
                    param.add(companyArray[i]);
                }
                sql.append(" ) \n");
            } else {
                sql.append(" and entry.FunitId = ? ");
                param.add(companyids);
            }
        }
        if (params.containsKey("search") && !StringUtils.isEmpty((String)(search = (String)params.get("search")))) {
            sql.append(" and (schm.FNumber like ?").append(" or schm.FNAME_" + ctx.getLocale() + " like ?) \n");
            param.add("%" + search + "%");
            param.add("%" + search + "%");
        }
        sql.append(" ) schms \n");
        sql.append(" inner join T_ORG_BaseUnit unit ON schms.companyid = unit.FId \n");
        sql.append(" left outer join T_CSL_RptAutoWeaveLog logs ON schms.schemeid = logs.FRptWeaveSchmId and schms.companyid = logs.FCompanyId and logs.FTemplateId is null \n");
        sql.append(" left outer join T_PM_User u ON u.Fid = logs.FLastUpdateUserId \n");
        sql.append(" order by schms.schemeNumber,unit.FNumber ");
        try {
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString(), param.toArray());
            ArrayList removeRepeat = new ArrayList();
            while (rowSet.next()) {
                map = new HashMap<String, Object>();
                map.put("schemeid", rowSet.getString("schemeid"));
                map.put("schemeNumber", rowSet.getString("schemeNumber"));
                map.put("schemeName", rowSet.getString("schemeName"));
                map.put("operateNum", rowSet.getInt("operateNum"));
                map.put("operate", ReportOperateEnum.getEnum(rowSet.getInt("operateNum")).getAlias());
                map.put("companyid", rowSet.getString("companyid"));
                map.put("companyName", rowSet.getString("companyName"));
                map.put("schemeStatus", rowSet.getInt("schemeStatus"));
                map.put("operator", rowSet.getString("operator"));
                map.put("taskStatus", rowSet.getInt("taskStatus"));
                map.put("periodType", rowSet.getInt("periodType"));
                result.add(map);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"_getCompanyTaskList: ", (Throwable)e);
        }
        return result;
    }

    @Override
    protected void _checkFunctionPermission(Context ctx, String permItemName) throws BOSException, EASBizException {
        IObjectPK userPK = ctx.getCaller();
        OrgUnitInfo orgUnitInfo = ContextUtil.getCurrentOrgUnit((Context)ctx);
        String curOrgid = orgUnitInfo.getId().toString();
        ObjectUuidPK orgPK = new ObjectUuidPK(curOrgid);
        PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission(userPK, (IObjectPK)orgPK, permItemName);
    }

    private class BatchCheckTask
    extends Thread {
        List objList = null;
        Context ctx = null;
        IReport ireport = null;
        IFullOrgUnit iFullOrgUnit = null;

        BatchCheckTask(Context context, List list, IReport report, IFullOrgUnit iOrgUnit) {
            this.objList = list;
            this.ctx = context;
            this.ireport = report;
            this.iFullOrgUnit = iOrgUnit;
        }

        @Override
        public void run() {
            HashMap map = new HashMap();
            ArrayList<String> ids = new ArrayList<String>();
            for (int i = 0; i < this.objList.size(); ++i) {
                ReportInfo info = (ReportInfo)this.objList.get(i);
                String id = info.getId().toString();
                String number = info.getNumber();
                String name = info.getName();
                Integer year = info.getYear();
                Integer period = info.getPeriod();
                String companyid = info.getCompany().getId().toString();
                FullOrgUnitInfo companyInfo = null;
                try {
                    companyInfo = this.iFullOrgUnit.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid));
                }
                catch (EASBizException e) {
                    logger.error((Object)"getCompnyName", (Throwable)e);
                }
                catch (BOSException e) {
                    logger.error((Object)"getCompnyName", (Throwable)e);
                }
                ids.add(id);
                HashMap<String, Object> newMap = new HashMap<String, Object>();
                newMap.put("number", number);
                newMap.put("name", name);
                newMap.put("year", year);
                newMap.put("period", period);
                newMap.put("company", companyInfo.getName());
                map.put(id, newMap);
            }
            ReportTaskFacadeControllerBean.this.batchDeleteCheckResultByReportIds(this.ctx, ids);
            ReportTaskFacadeControllerBean.this.batchAddCheckResult(this.ctx, ids, map);
            ReportTaskFacadeControllerBean.this.excuteCheck(this.ctx, ids, this.ireport);
        }
    }
}

