/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.web.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveLogCollection;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveLogFactory;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveLogInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveException;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveExecParams;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveLinkEnum;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveLogSuccEnum;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveParams;
import com.kingdee.eas.fi.gr.weaverpt.app.RptCalcSchemeHandle;
import com.kingdee.eas.fi.gr.weaverpt.app.RptWeaveExecStrategy;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.web.LogNodeTypeEnum;
import com.kingdee.eas.fi.newrpt.web.ReportTaskInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;

public class RptTaskExecuteHandle
implements IJobHandler {
    public Object execute(Job job) throws Exception {
        RptWeaveParams taskParam = (RptWeaveParams)job.getParameters();
        Context ctx = job.getContext();
        ReportTaskInfo task = (ReportTaskInfo)taskParam.getObject("rpt_web_rptExecObj");
        Map templateMap = (Map)taskParam.getObject("rpt_web_templateCol");
        RptWeaveExecParams execParam = (RptWeaveExecParams)taskParam.getObject("rpt_weave_execparams");
        String userId = execParam.getUserId();
        FullOrgUnitInfo companyInfo = (FullOrgUnitInfo)taskParam.getObject("KEY_COMPANY");
        TemplateCollection template = (TemplateCollection)templateMap.get(companyInfo.getId().toString());
        int year = taskParam.getInt("Year");
        int period = taskParam.getInt("Period");
        RptPeriodTypeEnum periodType = task.getPeriodType();
        RptCalcSchemeHandle schemeHandle = new RptCalcSchemeHandle();
        schemeHandle.addCtxObject(ctx, userId, companyInfo, taskParam);
        CurrencyInfo currency = (CurrencyInfo)taskParam.getObject("currency");
        if (currency == null) {
            currency = this.setCompanyBaseCurrency(currency, ctx, companyInfo);
        }
        boolean currencyExist = CurrencyFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(currency.getId()));
        String taskid = task.getId().toString();
        String companyId = companyInfo.getId().toString();
        String currencyid = currency.getId().toString();
        RptAutoWeaveLogInfo log = null;
        RptAutoWeaveLogInfo companylog = (RptAutoWeaveLogInfo)taskParam.getObject("rpt_web_companyLog");
        this.updateCompanyLog(ctx, companylog);
        for (int j = 0; j < template.size() && !execParam.isCalcException(); ++j) {
            Timestamp time;
            try {
                String templateid = template.get(j).getId().toString();
                if (!currencyExist) {
                    throw new RptWeaveException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"CURRENCY_IS_ERROR", (Locale)ctx.getOriginLocale()));
                }
                log = schemeHandle.initLogInfo(ctx, companyId, templateid, taskid, periodType, year, period, userId);
                time = new Timestamp(System.currentTimeMillis());
                log.setNodeType(LogNodeTypeEnum.TEMPLATELOG);
                log.setStartTime(time);
                log.setCurrencyId(currencyid);
                TemplateInfo tempInfo = schemeHandle.getLastestByTemapIdAndComp(ctx, companyId, templateid);
                taskParam.setObject("KEY_TEMPLATE", (Object)tempInfo);
                String cslrptTemaplateId = schemeHandle.getCurrentPeriodRptTempalteId(tempInfo, companyInfo, currency, periodType.getValue(), period, year, ctx);
                if (!StringUtils.isEmpty((String)cslrptTemaplateId)) {
                    log.setTemplateId(cslrptTemaplateId);
                } else {
                    log.setTemplateId(tempInfo.getId().toString());
                }
                schemeHandle.addInitLog(ctx, log);
                schemeHandle.resetParam(execParam);
                RptWeaveExecStrategy stratery = new RptWeaveExecStrategy(log);
                stratery.rptWeaveExceute(taskParam, ctx);
                this.updateLog(ctx, log, RptWeaveLogSuccEnum.SUCCESS);
                continue;
            }
            catch (Exception e) {
                if (log != null) {
                    log.setResultType(RptWeaveLogSuccEnum.FAILED);
                    time = new Timestamp(System.currentTimeMillis());
                    log.setEndTime(time);
                    if (e instanceof RptWeaveException) {
                        String linkType;
                        String[] msgArray;
                        RptWeaveException ex = (RptWeaveException)e;
                        String code = ex.getCode();
                        if (!("10000".equals(code) || "10001".equals(code) || "10-10000".equals(code))) {
                            String detailMsg = ex.getLocalizedMessage();
                            if (detailMsg.contains("$")) {
                                msgArray = detailMsg.split("\\$");
                                linkType = msgArray[0];
                                detailMsg = msgArray[1];
                                log.setLinkType(RptWeaveLinkEnum.getEnum((String)linkType));
                            }
                            if (detailMsg.length() > 2000) {
                                detailMsg = detailMsg.substring(0, 2000);
                            }
                            log.setError(detailMsg);
                            schemeHandle.writeLog(ctx, log, ex.getCode(), RptWeaveLogSuccEnum.FAILED);
                        } else {
                            String msg = e.getLocalizedMessage();
                            if (msg.contains("$")) {
                                msgArray = msg.split("\\$");
                                if (msgArray.length == 2) {
                                    linkType = msgArray[0];
                                    msg = msgArray[1];
                                    if (msg.equals("null")) {
                                        msg = null;
                                    }
                                    log.setLinkType(RptWeaveLinkEnum.getEnum((String)linkType));
                                } else {
                                    linkType = msgArray[0];
                                    log.setLinkType(RptWeaveLinkEnum.getEnum((String)linkType));
                                }
                            }
                            schemeHandle.writeLog(ctx, log, msg, RptWeaveLogSuccEnum.FAILED);
                        }
                    } else {
                        schemeHandle.writeLog(ctx, log, e.getLocalizedMessage(), RptWeaveLogSuccEnum.FAILED);
                    }
                }
                execParam.setException((Throwable)e);
            }
        }
        if (!execParam.isCalcException()) {
            this.updateLog(ctx, companylog, RptWeaveLogSuccEnum.SUCCESS);
        } else {
            this.updateLog(ctx, companylog, RptWeaveLogSuccEnum.FAILED);
        }
        RptAutoWeaveLogInfo taskLog = (RptAutoWeaveLogInfo)taskParam.getObject("rpt_web_taskLog");
        int companyCount = taskParam.getInt("rpt_web_companyCount");
        boolean isFromTask = taskParam.getBoolean("rpt_web_isFromTask");
        this.updateTaskProgress(ctx, taskid, taskLog, companyCount, isFromTask);
        return null;
    }

    private void updateLog(Context ctx, RptAutoWeaveLogInfo logInfo, RptWeaveLogSuccEnum status) throws EASBizException, BOSException {
        Timestamp time = new Timestamp(System.currentTimeMillis());
        logInfo.setEndTime(time);
        logInfo.setResultType(status);
        SelectorItemCollection itemColl = new SelectorItemCollection();
        itemColl.add(new SelectorItemInfo("endTime"));
        itemColl.add(new SelectorItemInfo("resultType"));
        RptAutoWeaveLogFactory.getLocalInstance((Context)ctx).updatePartial(logInfo, itemColl);
    }

    private void updateCompanyLog(Context ctx, RptAutoWeaveLogInfo logInfo) throws EASBizException, BOSException {
        logInfo.setResultType(RptWeaveLogSuccEnum.EXCEUTING);
        Timestamp ctime = new Timestamp(System.currentTimeMillis());
        logInfo.setStartTime(ctime);
        SelectorItemCollection itemColl = new SelectorItemCollection();
        itemColl.add(new SelectorItemInfo("startTime"));
        itemColl.add(new SelectorItemInfo("resultType"));
        RptAutoWeaveLogFactory.getLocalInstance((Context)ctx).updatePartial(logInfo, itemColl);
    }

    private void updateTaskProgress(Context ctx, String taskid, RptAutoWeaveLogInfo taskLog, int companyCount, boolean isFromTask) throws BOSException, EASBizException {
        if (isFromTask) {
            this.updateNotExcuteStatus(ctx, taskid);
        } else {
            RptAutoWeaveLogCollection coll = RptAutoWeaveLogFactory.getLocalInstance((Context)ctx).getRptAutoWeaveLogCollection("select id where rptWeaveSchmId ='" + taskid + "' and nodeType = " + 1 + " and resultType in (" + 1 + "," + 0 + ")");
            int size = coll.size();
            SelectorItemCollection itemColl = new SelectorItemCollection();
            if (companyCount == size) {
                Timestamp time = new Timestamp(System.currentTimeMillis());
                taskLog.setEndTime(time);
                taskLog.setProgress(100);
                taskLog.setResultType(RptWeaveLogSuccEnum.SUCCESS);
                itemColl.add(new SelectorItemInfo("endTime"));
                itemColl.add(new SelectorItemInfo("resultType"));
                this.updateNotExcuteStatus(ctx, taskid);
            } else {
                float sizef = size;
                float countf = companyCount;
                float progressf = sizef / countf * 100.0f;
                int progress = (int)progressf;
                taskLog.setProgress(progress);
            }
            itemColl.add(new SelectorItemInfo("progress"));
            RptAutoWeaveLogFactory.getLocalInstance((Context)ctx).updatePartial(taskLog, itemColl);
        }
    }

    private CurrencyInfo setCompanyBaseCurrency(CurrencyInfo currency, Context ctx, FullOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        FullOrgUnitInfo fullOrgUnitInfo = null;
        ObjectStringPK pk = new ObjectStringPK(companyInfo.getId().toString());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("partFI.id"));
        selector.add(new SelectorItemInfo("partFI.baseCurrency.id"));
        selector.add(new SelectorItemInfo("partFI.baseCurrency.number"));
        selector.add(new SelectorItemInfo("partFI.baseCurrency.name"));
        selector.add(new SelectorItemInfo("partFI.baseCurrency.precision"));
        try {
            fullOrgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)pk, selector);
        }
        catch (Exception e) {
            currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectStringPK("dfd38d11-00fd-1000-e000-1ebdc0a8100dDEB58FDC"));
            return currency;
        }
        if (fullOrgUnitInfo.getPartFI() == null || fullOrgUnitInfo.getPartFI().getBaseCurrency() == null) {
            currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectStringPK("dfd38d11-00fd-1000-e000-1ebdc0a8100dDEB58FDC"));
            return currency;
        }
        currency = fullOrgUnitInfo.getPartFI().getBaseCurrency();
        return currency;
    }

    private void updateNotExcuteStatus(Context ctx, String taskid) throws EASBizException, BOSException {
        String sql = "update T_CSL_ReportTask set FExcuteStatus = 0 where Fid = ?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(taskid);
        DbUtil.execute(ctx, sql, params.toArray());
    }
}

