/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.nlm.DepreciationMethodEnum;
import com.kingdee.eas.fi.nlm.FaAmortizedCostRptCollection;
import com.kingdee.eas.fi.nlm.FaAmortizedCostRptEntryCollection;
import com.kingdee.eas.fi.nlm.FaAmortizedCostRptEntryFactory;
import com.kingdee.eas.fi.nlm.FaAmortizedCostRptEntryInfo;
import com.kingdee.eas.fi.nlm.FaAmortizedCostRptFactory;
import com.kingdee.eas.fi.nlm.FaAmortizedCostRptInfo;
import com.kingdee.eas.fi.nlm.FaDepreAndAmortFactory;
import com.kingdee.eas.fi.nlm.FaLeaseBizStatusEnum;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewCollection;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewFactory;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.nlm.FaLeaseSourceTypeEnum;
import com.kingdee.eas.fi.nlm.FaLeaseStartDeprTimeRuleEnum;
import com.kingdee.eas.fi.nlm.FaLeaseTypeEnum;
import com.kingdee.eas.fi.nlm.FaLiabilitiesCvMethodEnum;
import com.kingdee.eas.fi.nlm.FaNewLeasePolicyFactory;
import com.kingdee.eas.fi.nlm.FaNewLeasePolicyInfo;
import com.kingdee.eas.fi.nlm.FaPaymentPlanNewCollection;
import com.kingdee.eas.fi.nlm.FaRentTime;
import com.kingdee.eas.fi.nlm.IFaDepreAndAmort;
import com.kingdee.eas.fi.nlm.IFaLeaseInBillNew;
import com.kingdee.eas.fi.nlm.app.AbstractFaAmortizedCostRptControllerBean;
import com.kingdee.eas.fi.nlm.app.faleasestrategy.FaAmortizedCostRptContext;
import com.kingdee.eas.fi.nlm.app.faleasestrategy.FaAmortizedCostRptStrategy;
import com.kingdee.eas.fi.nlm.app.faleasestrategy.impl.FLAmortizedCostRptAllPayStrategy;
import com.kingdee.eas.fi.nlm.app.prc.PrcFaLeaseInNewStrategy;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.poi.ss.formula.functions.FinanceLib;
import org.apache.poi.ss.formula.functions.Irr;

public class FaAmortizedCostRptControllerBean
extends AbstractFaAmortizedCostRptControllerBean {
    private static final long serialVersionUID = 2344604523048825393L;
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.nlm.app.FaAmortizedCostRptControllerBean");
    private static final String RES_PATH = "com.kingdee.eas.fi.fa.rpt.FaRptResource";
    private static final int CALC_SCALE = 16;
    private static final int DEFAULT_SAVE_SCALE = 4;
    private static final String YEAR_DATES = "365";
    private static final long DATE_TIME_MILLIS = 86400000L;
    private FaAmortizedCostRptInfo curACRpt;
    private FaAmortizedCostRptEntryCollection curACERptCol;
    private boolean isInitBill = false;
    private boolean isDiscount2ImplDate = false;
    private boolean isEnableStockContract = false;
    private int originScale;
    private int amountScale;
    private CompanyOrgUnitInfo curCompany;

    public FaAmortizedCostRptInfo _calc(Context ctx, IObjectValue leaseInBill) throws BOSException, EASBizException {
        FaAmortizedCostRptStrategy fLAmortizedCostRptAllPayStrategy;
        FaLeaseInBillNewInfo paramLeaseInBill = (FaLeaseInBillNewInfo)leaseInBill;
        ObjectUuidPK pk = new ObjectUuidPK(paramLeaseInBill.getId());
        FaLeaseInBillNewInfo billInfo = this.getLeaseInBill(ctx, (IObjectPK)pk);
        if (billInfo == null) {
            String leaseInBillIsNull = FaLocalUtils.getResource((Context)ctx, (String)RES_PATH, (String)"leaseInBillIsNull");
            throw new EASBizException(new NumericExceptionSubItem("001", leaseInBillIsNull));
        }
        billInfo.put("scInitialAsset", paramLeaseInBill.getInitialAsset());
        billInfo.put("scInitAccDepreciation", paramLeaseInBill.getInitAccDepreciation());
        this.curACRpt = new FaAmortizedCostRptInfo();
        this.curACERptCol = new FaAmortizedCostRptEntryCollection();
        FaLeaseTypeEnum leaseType = billInfo.getLeaseType() == null ? FaLeaseTypeEnum.OPERATING_LEASE : billInfo.getLeaseType();
        logger.error((Object)"============================ calc amortized cost rpt start ============================");
        long startTime = System.currentTimeMillis();
        if (billInfo.getLeaseType() == FaLeaseTypeEnum.FINANCE_LEASE) {
            FaAmortizedCostRptStrategy faAmortizedCostRptStrategy = FaAmortizedCostRptContext.getFaAmortizedCostRptStrategy("FLAmortizedCostRptStrategy");
            this.curACRpt = faAmortizedCostRptStrategy.calcACRData(ctx, billInfo, this.curACRpt, this.curACERptCol);
        } else if (6 == billInfo.getPayFrequency().getValue() && leaseType == FaLeaseTypeEnum.OPERATING_LEASE) {
            fLAmortizedCostRptAllPayStrategy = FaAmortizedCostRptContext.getFaAmortizedCostRptStrategy("FLAmortizedCostRptAllPayStrategy");
            this.curACRpt = fLAmortizedCostRptAllPayStrategy.calcACRData(ctx, billInfo, this.curACRpt, this.curACERptCol);
        } else if (billInfo.getLeaseType() == FaLeaseTypeEnum.GL_BALANCE_ENTRY) {
            fLAmortizedCostRptAllPayStrategy = FaAmortizedCostRptContext.getFaAmortizedCostRptStrategy("FLAmortizedCostRptStrategy");
            this.curACRpt = fLAmortizedCostRptAllPayStrategy.calcACRData(ctx, billInfo, this.curACRpt, this.curACERptCol);
        } else {
            this.calcACRData(ctx, billInfo, true, false);
        }
        long endTime = System.currentTimeMillis();
        logger.error((Object)("============================ spend time: " + (endTime - startTime) + "ms"));
        logger.error((Object)"============================ calc amortized cost rpt end   ============================");
        this.curACRpt.setLeaseInBill(billInfo);
        BOSUuid billId = this.getACRptIdByBillId(ctx, (IObjectPK)pk);
        this.curACRpt.setId(billId);
        this.save(ctx, (CoreBaseInfo)this.curACRpt);
        return this.curACRpt;
    }

    public FaAmortizedCostRptInfo _getACRptByBillId(Context ctx, IObjectPK billId) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("leaseInBill.id");
        sic.add("leaseInBill.number");
        sic.add("leaseInBill.isHistory");
        sic.add("leaseInBill.liabilitiesCvMethod");
        sic.add("leaseInBill.contractNumber");
        sic.add("leaseInBill.contractName");
        sic.add("leaseInBill.contractCat.name");
        sic.add("leaseInBill.discountRate");
        sic.add("leaseInBill.initialDirectFee");
        sic.add("leaseInBill.currency.name");
        sic.add("leaseInBill.company.name");
        sic.add("leaseInBill.depreciationMethod");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("leaseInBill.id", (Object)billId.toString()));
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        view.setFilter(filter);
        FaAmortizedCostRptCollection col = this.getFaAmortizedCostRptCollection(ctx, view);
        if (col == null || col.size() <= 0) {
            return null;
        }
        if (col.get(0).getLeaseInBill().getDepreciationMethod() == DepreciationMethodEnum.Second && col.get(0).getLeaseInBill().getLiabilitiesCvMethod() == FaLiabilitiesCvMethodEnum.DAY) {
            col.get(0).put("entry", (Object)this.transformACRptDataInMonth(ctx, col.get(0).getLeaseInBill().getId().toString()));
            return col.get(0);
        }
        sic = new SelectorItemCollection();
        sic.add("*");
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("amortizedCostRpt.id", (Object)col.get(0).getId().toString()));
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("date"));
        view = new EntityViewInfo();
        view.setSelector(sic);
        view.setFilter(filter);
        view.setSorter(sorter);
        FaAmortizedCostRptEntryCollection entryCol = FaAmortizedCostRptEntryFactory.getLocalInstance(ctx).getFaAmortizedCostRptEntryCollection(view);
        if (entryCol == null || entryCol.size() <= 0) {
            return null;
        }
        col.get(0).put("entry", (Object)entryCol);
        return col.get(0);
    }

    public BOSUuid getACRptIdByBillId(Context ctx, IObjectPK billId) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("leaseInBill.id", (Object)billId));
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        view.setFilter(filter);
        FaAmortizedCostRptCollection col = this.getFaAmortizedCostRptCollection(ctx, view);
        if (col.size() <= 0) {
            return null;
        }
        return col.get(0).getId();
    }

    @Override
    protected IObjectValue _calc4Adjustment(Context ctx, IObjectValue leaseInBillInfo) throws BOSException, EASBizException {
        FaLeaseTypeEnum leaseType;
        if (leaseInBillInfo == null) {
            String leaseInBillIsNull = FaLocalUtils.getResource((Context)ctx, (String)RES_PATH, (String)"leaseInBillIsNull");
            throw new EASBizException(new NumericExceptionSubItem("001", leaseInBillIsNull));
        }
        FaLeaseInBillNewInfo paramLeaseInBill = (FaLeaseInBillNewInfo)leaseInBillInfo;
        ObjectUuidPK pk = new ObjectUuidPK(paramLeaseInBill.getId());
        FaLeaseInBillNewInfo billInfo = this.getLeaseInBill(ctx, (IObjectPK)pk);
        this.curACRpt = new FaAmortizedCostRptInfo();
        this.curACERptCol = new FaAmortizedCostRptEntryCollection();
        FaLeaseTypeEnum faLeaseTypeEnum = leaseType = billInfo.getLeaseType() == null ? FaLeaseTypeEnum.OPERATING_LEASE : billInfo.getLeaseType();
        if (billInfo.getBizStatus() == FaLeaseBizStatusEnum.DECING || billInfo.getBizStatus() == FaLeaseBizStatusEnum.HAVE_DEC) {
            FaAmortizedCostRptStrategy fLDecValueAmortizedCostRptStrategy = FaAmortizedCostRptContext.getFaAmortizedCostRptStrategy("FLDecValueAmortizedCostRptStrategy");
            fLDecValueAmortizedCostRptStrategy.calcACRData(ctx, billInfo, this.curACRpt, this.curACERptCol);
        } else if (billInfo.getSourceType() == FaLeaseSourceTypeEnum.ASSET_CHANGE_CREAT) {
            FaAmortizedCostRptStrategy adjustmentAmortizedCostRptStrategy = FaAmortizedCostRptContext.getFaAmortizedCostRptStrategy("AdjustmentAmortizedCostRptStrategy");
            this.curACRpt = adjustmentAmortizedCostRptStrategy.calcACRData(ctx, billInfo, this.curACRpt, this.curACERptCol);
            this.curACRpt.setLeaseInBill(billInfo);
            BOSUuid billId = this.getACRptIdByBillId(ctx, (IObjectPK)pk);
            this.curACRpt.setId(billId);
            this.save(ctx, (CoreBaseInfo)this.curACRpt);
        } else if (billInfo.getSourceType() == FaLeaseSourceTypeEnum.TERMINATION_CREAT) {
            FaAmortizedCostRptStrategy adjustmentAmortizedCostRptStrategy = FaAmortizedCostRptContext.getFaAmortizedCostRptStrategy("TerminateAmortizedCostRptStrategy");
            this.curACRpt = adjustmentAmortizedCostRptStrategy.calcACRData(ctx, billInfo, this.curACRpt, this.curACERptCol);
            this.curACRpt.setLeaseInBill(billInfo);
            BOSUuid billId = this.getACRptIdByBillId(ctx, (IObjectPK)pk);
            if (billId != null) {
                FaAmortizedCostRptFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(billId));
                FaAmortizedCostRptEntryFactory.getLocalInstance(ctx).delete("where amortizedCostRpt = '" + billId.toString() + "'");
            }
            this.curACRpt.setId(null);
            this.save(ctx, (CoreBaseInfo)this.curACRpt);
        } else if (6 == billInfo.getPayFrequency().getValue() && leaseType == FaLeaseTypeEnum.OPERATING_LEASE) {
            FLAmortizedCostRptAllPayStrategy fLAmortizedCostRptAllPayStrategy = (FLAmortizedCostRptAllPayStrategy)FaAmortizedCostRptContext.getFaAmortizedCostRptStrategy("FLAmortizedCostRptAllPayStrategy");
            this.curACRpt = fLAmortizedCostRptAllPayStrategy.calc4Adjustment(ctx, billInfo, this.curACRpt, this.curACERptCol);
        } else {
            this.calcACRData(ctx, billInfo, false, false);
        }
        return this.curACRpt;
    }

    @Override
    protected IObjectValue _calc4StockContract(Context ctx, IObjectValue leaseInBillInfo) throws BOSException, EASBizException {
        FaLeaseTypeEnum leaseType;
        if (leaseInBillInfo == null) {
            String leaseInBillIsNull = FaLocalUtils.getResource((Context)ctx, (String)RES_PATH, (String)"leaseInBillIsNull");
            throw new EASBizException(new NumericExceptionSubItem("001", leaseInBillIsNull));
        }
        FaLeaseInBillNewInfo paramLeaseInBill = (FaLeaseInBillNewInfo)leaseInBillInfo;
        ObjectUuidPK pk = new ObjectUuidPK(paramLeaseInBill.getId());
        FaLeaseInBillNewInfo billInfo = this.getLeaseInBill(ctx, (IObjectPK)pk);
        this.curACRpt = new FaAmortizedCostRptInfo();
        this.curACERptCol = new FaAmortizedCostRptEntryCollection();
        FaLeaseTypeEnum faLeaseTypeEnum = leaseType = billInfo.getLeaseType() == null ? FaLeaseTypeEnum.OPERATING_LEASE : billInfo.getLeaseType();
        if (6 == billInfo.getPayFrequency().getValue() && leaseType == FaLeaseTypeEnum.OPERATING_LEASE) {
            FLAmortizedCostRptAllPayStrategy fLAmortizedCostRptAllPayStrategy = (FLAmortizedCostRptAllPayStrategy)FaAmortizedCostRptContext.getFaAmortizedCostRptStrategy("FLAmortizedCostRptAllPayStrategy");
            this.curACRpt = fLAmortizedCostRptAllPayStrategy.calc4StockContract(ctx, billInfo, this.curACRpt, this.curACERptCol);
        } else {
            this.calcACRData(ctx, billInfo, false, true);
        }
        return this.curACRpt;
    }

    @Override
    protected void _deleteByBillId(Context ctx, IObjectPK billId) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("leaseInBill.id", (Object)billId));
        this.delete(ctx, filter);
        FaDepreAndAmortFactory.getLocalInstance(ctx).delete(filter);
    }

    @Override
    protected FaAmortizedCostRptCollection _getACRptColByBillIdSet(Context ctx, Set billIdSet) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("entry.*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("leaseInBill.id", (Object)billIdSet, CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        view.setFilter(filter);
        FaAmortizedCostRptCollection col = this.getFaAmortizedCostRptCollection(ctx, view);
        return col;
    }

    private void calcACRData(Context ctx, FaLeaseInBillNewInfo billInfo, boolean isCalcAfterStartEntries, boolean isIgnoreNLM303) throws EASBizException, BOSException {
        FaNewLeasePolicyInfo newLeasePolicy = FaNewLeasePolicyFactory.getLocalInstance(ctx).getEnabledNewLeasePolicy(billInfo.getCompany().getId().toString());
        this.originScale = this.getCurrencyScale(billInfo.getCurrency().getId().toString(), ctx);
        this.amountScale = this.getCurrentCompany(ctx).getBaseCurrency().getPrecision();
        FaPaymentPlanNewCollection ppCol = billInfo.getPaymentEntry();
        if (ppCol.size() < 0) {
            String paymentEntryIsNull = FaLocalUtils.getResource((Context)ctx, (String)RES_PATH, (String)"paymentEntryIsNull");
            throw new EASBizException(new NumericExceptionSubItem("1", paymentEntryIsNull));
        }
        ppCol.sort("payDate");
        ppCol.removeObject(0);
        ArrayList<Date> payDateList = new ArrayList<Date>();
        Date beginDate = billInfo.getBeginDate();
        Date endDate = billInfo.getEndDate();
        Date firstPayDate = billInfo.getFirstPayTime();
        Date endPayDate = ppCol.get(ppCol.size() - 1).getPayDate();
        Date advPayDate = null;
        double advCf = new Double("0");
        ArrayList<Double> cfPayArr = new ArrayList<Double>();
        double dayRate4PeriodCvMethod = Math.pow(new Double("1") + this.BD2db(billInfo.getDiscountRate()) / new Double("100"), new Double("1") / new Double("360")) - new Double("1");
        double discountRate = this.calcDiscountRate(billInfo, newLeasePolicy);
        this.isInitBill = PrcFaLeaseInNewStrategy.isInitBill(ctx, billInfo, null);
        this.isDiscount2ImplDate = FaManageUtils.getIntFaParamValue((Context)ctx, (String)"NLM_303", (String)billInfo.getCompany().getId().toString()) == 0;
        this.isEnableStockContract = FaManageUtils.getFaParamValue((Context)ctx, (String)"NLM_HIDE_001", (String)billInfo.getCompany().getId().toString());
        Date endAmortizedCostDate = endDate.compareTo(endPayDate) > 0 ? endDate : endPayDate;
        int ppIdx = 0;
        if (newLeasePolicy.getTranslationMethod() == FaLiabilitiesCvMethodEnum.DAY) {
            int i;
            Date curDate;
            if (this.isInitBill && !isIgnoreNLM303 && this.isEnableStockContract) {
                if (beginDate.compareTo(billInfo.getDpInitCfmDate()) < 0) {
                    curDate = billInfo.getDpInitCfmDate();
                    if (ppCol.get(0).getPayDate().compareTo(billInfo.getDpInitCfmDate()) < 0) {
                        ppIdx = this.getFirstImpDateIndex(ppCol, billInfo);
                    }
                } else {
                    curDate = beginDate;
                }
            } else {
                curDate = beginDate;
                if (firstPayDate.compareTo(beginDate) < 0) {
                    Calendar cld = Calendar.getInstance();
                    cld.setTimeInMillis(beginDate.getTime() - 86400000L);
                    advPayDate = cld.getTime();
                    for (i = 0; i < ppCol.size() && ppCol.get(i).getPayDate().compareTo(beginDate) < 0; ++i) {
                        advCf += billInfo.isIsDeductible() ? this.BD2db(ppCol.get(0).getPaymentWithoutTax()) : this.BD2db(ppCol.get(0).getPaymentWithTax());
                        ++ppIdx;
                    }
                }
            }
            int subDates = this.subDate(endAmortizedCostDate, curDate);
            for (i = 0; i < subDates + 1; ++i) {
                payDateList.add(curDate);
                if (ppIdx >= 0 && ppIdx < ppCol.size() && curDate.compareTo(ppCol.get(ppIdx).getPayDate()) == 0) {
                    cfPayArr.add(billInfo.isIsDeductible() ? this.BD2db(ppCol.get(ppIdx).getPaymentWithoutTax()) : this.BD2db(ppCol.get(ppIdx).getPaymentWithTax()));
                    ++ppIdx;
                } else {
                    cfPayArr.add(new Double("0"));
                }
                curDate = this.nextDate(curDate);
            }
        } else {
            Date curDate;
            boolean advFlag = true;
            if (this.isInitBill && !isIgnoreNLM303 && this.isEnableStockContract) {
                if (beginDate.compareTo(billInfo.getDpInitCfmDate()) < 0) {
                    curDate = billInfo.getDpInitCfmDate();
                    if (ppCol.get(0).getPayDate().compareTo(billInfo.getDpInitCfmDate()) < 0) {
                        ppIdx = this.getFirstImpDateIndex(ppCol, billInfo);
                        advFlag = true;
                    } else {
                        advFlag = false;
                    }
                } else {
                    curDate = beginDate;
                    advFlag = false;
                }
            } else {
                curDate = beginDate;
                boolean bl = advFlag = !billInfo.isIsExistsFreePeriod();
            }
            if (advFlag && billInfo.getRentTime() == FaRentTime.PERIODBEGIN) {
                advCf = billInfo.isIsDeductible() ? this.calcPWOT(this.BD2db(ppCol.get(0).getPaymentWithTax()), this.BD2db(ppCol.get(0).getTaxRate())) : this.BD2db(ppCol.get(0).getPaymentWithTax());
            }
            int subMonths = this.subMonth(endAmortizedCostDate, curDate);
            Calendar curCld = Calendar.getInstance();
            Calendar payCld = Calendar.getInstance();
            for (int i = 0; i < subMonths + 1; ++i) {
                payDateList.add(curDate);
                cfPayArr.add(new Double("0"));
                if (ppIdx >= 0 && ppIdx < ppCol.size()) {
                    curCld.setTime(curDate);
                    payCld.setTime(ppCol.get(ppIdx).getPayDate());
                    if (curCld.get(1) == payCld.get(1) && curCld.get(2) == payCld.get(2)) {
                        cfPayArr.set(i, billInfo.isIsDeductible() ? this.calcPWOT(this.BD2db(ppCol.get(ppIdx).getPaymentWithTax()), this.BD2db(ppCol.get(ppIdx).getTaxRate())) : this.BD2db(ppCol.get(ppIdx).getPaymentWithTax()));
                        ++ppIdx;
                    }
                }
                curDate = this.nextMonth(curDate);
            }
        }
        if (newLeasePolicy.getTranslationMethod() == FaLiabilitiesCvMethodEnum.DAY) {
            this.calcBillNPV(billInfo, advPayDate, advCf, cfPayArr, discountRate);
            this.calcStartEntriesByDayCvMethod(billInfo, newLeasePolicy, payDateList, cfPayArr, advPayDate, advCf, discountRate, isIgnoreNLM303, ctx);
        } else {
            this.calcStartEntriesByPeriodCvMethod(billInfo, newLeasePolicy, payDateList, cfPayArr, advPayDate, advCf, discountRate, dayRate4PeriodCvMethod, isIgnoreNLM303, ctx);
        }
        if (isCalcAfterStartEntries) {
            double[][] entries = this.calcAfterStartEntriesUseArray(ctx, billInfo, newLeasePolicy, payDateList, cfPayArr, advPayDate, endPayDate, discountRate, isIgnoreNLM303);
            this.setEntries(entries, payDateList, newLeasePolicy.getTranslationMethod());
        }
        this.curACRpt.put("entry", (Object)this.curACERptCol);
    }

    private double calcDiscountRate(FaLeaseInBillNewInfo billInfo, FaNewLeasePolicyInfo newLeasePolicy) {
        double discountRate;
        int interestCalcMethod = newLeasePolicy.getInterestCalculationMethod().getValue();
        if (newLeasePolicy.getTranslationMethod() == FaLiabilitiesCvMethodEnum.DAY) {
            discountRate = interestCalcMethod == 1 ? Math.pow(this.BD2db(billInfo.getDiscountRate()) / new Double("100") + new Double("1"), new Double("1") / new Double(YEAR_DATES)) - new Double("1") : this.BD2db(billInfo.getDiscountRate()) / new Double("100") / new Double(YEAR_DATES);
        } else {
            Double N;
            switch (billInfo.getPayFrequency().getValue()) {
                case 0: {
                    N = new Double("1");
                    break;
                }
                case 1: {
                    N = new Double("1") / new Double("2");
                    break;
                }
                case 2: {
                    N = new Double("1") / new Double("4");
                    break;
                }
                case 3: {
                    N = new Double("1") / new Double("12");
                    break;
                }
                case 5: {
                    N = new Double("1");
                    break;
                }
                default: {
                    N = new Double("1");
                }
            }
            discountRate = interestCalcMethod == 3 ? Math.pow(this.BD2db(billInfo.getDiscountRate()) / new Double("100") + new Double("1"), N) - new Double("1") : this.BD2db(billInfo.getDiscountRate()) / new Double("100") * N;
        }
        return discountRate;
    }

    private Date getPayFrequencyLastMonth(FaLeaseInBillNewInfo billInfo, Date date) {
        int n = 12;
        switch (billInfo.getPayFrequency().getValue()) {
            case 0: {
                n = 12;
                break;
            }
            case 1: {
                n = 6;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            case 3: 
            case 5: {
                return date;
            }
        }
        return this.getPayFrequencyLastMonth(date, n);
    }

    private void calcBillNPV(FaLeaseInBillNewInfo billInfo, Date advPayDate, double advCf, List<Double> cfPayArr, double discountRate) {
        double npv = this.calcNPV(discountRate, cfPayArr);
        this.curACRpt.setNPV(new BigDecimal(npv += advCf).setScale(this.amountScale, 4));
    }

    private double calcLeasePaymentNPV(FaLeaseInBillNewInfo billInfo, List<Double> cfPayArr, double advCf, double dayRate, double discountRate, boolean isIgnoreNLM303) {
        int freePeriodDays = billInfo.isIsExistsFreePeriod() ? this.subDate(billInfo.getBeginRentDate(), billInfo.getBeginFreePeriodDate()) : 0;
        double ppNPV = this.calcNPV(discountRate, this.getNPVCfArr(billInfo, isIgnoreNLM303));
        double leasePaymentNPV = (ppNPV + advCf) / Math.pow(new Double("1") + dayRate, freePeriodDays);
        return leasePaymentNPV;
    }

    private List<Double> getNPVCfArr(FaLeaseInBillNewInfo billInfo, boolean isIgnoreNLM303) {
        ArrayList<Double> cfArr = new ArrayList<Double>();
        FaPaymentPlanNewCollection ppCol = billInfo.getPaymentEntry();
        int startIndex = 0;
        boolean flag = true;
        if (this.isInitBill && this.isEnableStockContract && !isIgnoreNLM303) {
            if (billInfo.getBeginDate().compareTo(billInfo.getDpInitCfmDate()) < 0 && ppCol.get(0).getPayDate().compareTo(billInfo.getDpInitCfmDate()) < 0) {
                startIndex = this.getFirstImpDateIndex(ppCol, billInfo);
                flag = true;
            } else {
                flag = false;
            }
        } else {
            flag = !billInfo.isIsExistsFreePeriod();
        }
        for (int i = startIndex; startIndex >= 0 && i < ppCol.size(); ++i) {
            if (flag && billInfo.getRentTime() == FaRentTime.PERIODBEGIN && i == startIndex) continue;
            if (billInfo.isIsDeductible()) {
                cfArr.add(this.calcPWOT(this.BD2db(ppCol.get(i).getPaymentWithTax()), this.BD2db(ppCol.get(i).getTaxRate())));
                continue;
            }
            cfArr.add(this.BD2db(ppCol.get(i).getPaymentWithTax()));
        }
        return cfArr;
    }

    private int getFirstImpDateIndex(FaPaymentPlanNewCollection ppCol, FaLeaseInBillNewInfo billInfo) {
        int index = -1;
        for (int i = 0; i < ppCol.size(); ++i) {
            if (ppCol.get(i).getPayDate().compareTo(billInfo.getDpInitCfmDate()) < 0) continue;
            index = i;
            break;
        }
        return index;
    }

    private double calcAdvPaymentNPV(FaLeaseInBillNewInfo billInfo, double dayRate) {
        if (billInfo.getCostDate1() == null || billInfo.getCostPmWithTaxOC1() == null) {
            return new Double("0");
        }
        if (billInfo.getCostDate1().compareTo(billInfo.getBeginDate()) <= 0) {
            return this.BD2db(billInfo.isIsDeductible() ? billInfo.getCostPmWithoutTaxOC1() : billInfo.getCostPmWithTaxOC1());
        }
        int advDates = this.subDate(billInfo.getCostDate1(), billInfo.getBeginDate()) + 1;
        double advPaymentNPV = this.BD2db(billInfo.isIsDeductible() ? billInfo.getCostPmWithoutTaxOC1() : billInfo.getCostPmWithTaxOC1()) / Math.pow(new Double("1") + dayRate, advDates);
        return advPaymentNPV;
    }

    private double calcCostNPV(double cost, double periodDiscountRate, int timeCycle) {
        return cost / Math.pow(new Double("1") + periodDiscountRate, timeCycle);
    }

    private double calcPeriodDiscountRate(FaLeaseInBillNewInfo billInfo, FaNewLeasePolicyInfo newLeasePolicy) {
        double periodDiscountRate = newLeasePolicy.getInterestCalculationMethod().getValue() == 3 ? Math.pow(this.BD2db(billInfo.getDiscountRate()) / new Double("100") + new Double("1"), new Double("1") / new Double("12")) - new Double("1") : this.BD2db(billInfo.getDiscountRate()) / new Double("100") / new Double("12");
        return periodDiscountRate;
    }

    private double irr(List<Double> cfPayArr, double iLB, double guess) {
        double[] income = new double[cfPayArr.size() + 1];
        income[0] = -iLB;
        for (int i = 1; i < cfPayArr.size() + 1; ++i) {
            income[i] = cfPayArr.get(i - 1);
        }
        return Irr.irr((double[])income, (double)guess);
    }

    private void calcStartEntriesByDayCvMethod(FaLeaseInBillNewInfo billInfo, FaNewLeasePolicyInfo newLeasePolicy, List<Date> payDateList, List<Double> cfPayArr, Date advPayDate, double advCf, double discountRate, boolean isIgnoreNLM303, Context ctx) throws EASBizException, BOSException {
        BigDecimal cDpr;
        double iROUA;
        if (payDateList == null || payDateList.size() <= 0) {
            return;
        }
        Date beginDate = billInfo.getBeginDate();
        Date endDate = this.getNewEndDate(billInfo.getBeginDate(), billInfo.getTimeCycle());
        if (advPayDate != null) {
            FaAmortizedCostRptEntryInfo advEntry = new FaAmortizedCostRptEntryInfo();
            advEntry.setDate(advPayDate);
            advEntry.setCashflow(new BigDecimal(String.valueOf(advCf)));
            advEntry.setInitRightOfUseAsset(BigDecimal.ZERO);
            advEntry.setInitLiabilityPrincipal(BigDecimal.ZERO);
            advEntry.setInitUnCfmFncCost(BigDecimal.ZERO);
            advEntry.setInitLiabilityBalance(BigDecimal.ZERO);
            advEntry.setCurDepreciation(BigDecimal.ZERO);
            advEntry.setCurAccDepreciation(BigDecimal.ZERO);
            advEntry.setCurInterestPayment(BigDecimal.ZERO);
            advEntry.setCurAccInterestPayment(BigDecimal.ZERO);
            advEntry.setEndRightOfUseAsset(BigDecimal.ZERO);
            advEntry.setEndLiabilityPrincipal(BigDecimal.ZERO);
            advEntry.setEndUnCfmFncCost(BigDecimal.ZERO);
            advEntry.setEndLiabilityBalance(BigDecimal.ZERO);
            this.curACERptCol.add(advEntry);
        }
        FaAmortizedCostRptEntryInfo firstBizEntry = new FaAmortizedCostRptEntryInfo();
        firstBizEntry.setDate(payDateList.get(0));
        firstBizEntry.setCashflow(this.formatBD4Save(this.db2BD(cfPayArr.get(0)), this.originScale));
        firstBizEntry.setInitialAssetDecValue(billInfo.getInitialAssetDecValue());
        BigDecimal totalCf = new BigDecimal("0");
        for (Double cf : cfPayArr) {
            totalCf = totalCf.add(this.formatBD4Save(new BigDecimal(cf), this.originScale));
        }
        totalCf = totalCf.add(this.formatBD4Save(new BigDecimal(advCf), this.originScale));
        if (billInfo.isIsDeductible()) {
            billInfo.setRentWithoutTax(totalCf);
        } else {
            billInfo.setRentWithTax(totalCf);
        }
        double advNPV = this.calcAdvPaymentNPV(billInfo, discountRate);
        double idfCost = new Double("0");
        double riCost = new Double("0");
        double stampTaxStM = new Double("0");
        double rcvNPV = new Double("0");
        Double exchangeRateInfo = new Double(billInfo.getExchangeRateValue().toString());
        if (billInfo.getExchangeRate() != null && billInfo.getExchangeRate().getExchangeAux().getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE) {
            exchangeRateInfo = 1.0 / exchangeRateInfo;
        }
        if (!(this.isInitBill && this.isEnableStockContract && beginDate.compareTo(billInfo.getDpInitCfmDate()) < 0 && this.isDiscount2ImplDate)) {
            idfCost = exchangeRateInfo * this.BD2db(billInfo.isIsDeductible() ? billInfo.getCostPmWithoutTaxOC2() : billInfo.getCostPmWithTaxOC2());
            riCost = exchangeRateInfo * this.BD2db(billInfo.isIsDeductible() ? billInfo.getCostPmWithoutTaxOC7() : billInfo.getCostPmWithTaxOC7());
            stampTaxStM = new Double(billInfo.getStampTaxStM() == null ? "0" : billInfo.getStampTaxStM().toString());
        }
        if (billInfo.getCostPmWithTaxOC6() != null) {
            int subDates = this.subDate(billInfo.getCostDate6(), billInfo.getBeginDate()) + 1;
            rcvNPV = exchangeRateInfo * this.BD2db(billInfo.getCostPmWithTaxOC6());
            rcvNPV = this.calcCostNPV(rcvNPV, discountRate, subDates);
        }
        String updateSQL = " UPDATE T_FA_FaLeaseInBillNew SET FRECOVERYCOSTNPV = ? WHERE FID = ?";
        Object[] params = new Object[]{rcvNPV, billInfo.getId().toString()};
        DbUtil.execute((Context)ctx, (String)updateSQL, (Object[])params);
        advNPV = this.BD2db(this.formatBD4Save(new BigDecimal(advNPV), this.amountScale));
        idfCost = this.BD2db(this.formatBD4Save(new BigDecimal(idfCost), this.amountScale));
        stampTaxStM = this.BD2db(this.formatBD4Save(new BigDecimal(stampTaxStM), this.amountScale));
        rcvNPV = this.BD2db(this.formatBD4Save(new BigDecimal(rcvNPV), this.amountScale));
        riCost = this.BD2db(this.formatBD4Save(new BigDecimal(riCost), this.amountScale));
        double initialAssetDecValue = this.BD2db(billInfo.getInitialAssetDecValue());
        if (this.isInitBill && !isIgnoreNLM303 && this.isEnableStockContract) {
            int remainDprTimes;
            if (newLeasePolicy.getDepreciationMethod() == DepreciationMethodEnum.First) {
                remainDprTimes = this.subDate(endDate, billInfo.getBeginDate().compareTo(billInfo.getDpInitCfmDate()) <= 0 ? billInfo.getDpInitCfmDate() : billInfo.getBeginDate()) + 1;
            } else {
                int n = remainDprTimes = billInfo.getBeginDate().compareTo(billInfo.getDpInitCfmDate()) < 0 ? billInfo.getTimeCycle() - this.subMonth(billInfo.getDpInitCfmDate(), billInfo.getBeginDate()) : billInfo.getTimeCycle();
            }
            if (remainDprTimes > 0 && beginDate.compareTo(billInfo.getDpInitCfmDate()) < 0) {
                if (this.isDiscount2ImplDate) {
                    iROUA = this.BD2db(this.curACRpt.getNPV()) + advNPV;
                    iROUA *= exchangeRateInfo.doubleValue();
                    iROUA += rcvNPV;
                    iROUA -= initialAssetDecValue;
                } else {
                    iROUA = this.BD2db(billInfo.getBigDecimal("scInitialAsset")) - this.BD2db(billInfo.getBigDecimal("scInitAccDepreciation"));
                    Double remainingLiability = idfCost + advNPV + stampTaxStM + rcvNPV - riCost;
                    String updateRemainingLiabilitySQL = " UPDATE T_FA_FaLeaseInBillNew SET FRemainingLiability = ? WHERE FID = ?";
                    DbUtil.execute((Context)ctx, (String)updateRemainingLiabilitySQL, (Object[])new Object[]{remainingLiability, billInfo.getId().toString()});
                }
            } else {
                iROUA = this.BD2db(this.curACRpt.getNPV()) + advNPV;
                iROUA *= exchangeRateInfo.doubleValue();
                iROUA += idfCost + stampTaxStM - riCost + rcvNPV;
                iROUA -= initialAssetDecValue;
            }
            cDpr = this.formatBD4Save(this.db2BD(iROUA), this.amountScale).divide(this.db2BD(new Double(String.valueOf(remainDprTimes))), this.amountScale);
            firstBizEntry.put("remainTimeCycle", new Double(String.valueOf(remainDprTimes)));
        } else {
            iROUA = this.BD2db(this.curACRpt.getNPV()) + advNPV;
            iROUA *= exchangeRateInfo.doubleValue();
            iROUA += idfCost + stampTaxStM - riCost + rcvNPV;
            iROUA -= initialAssetDecValue;
            if (newLeasePolicy.getDepreciationMethod() == DepreciationMethodEnum.First) {
                double dprDateAmt = this.getDepDayCount(beginDate, billInfo.getDepEndDate());
                cDpr = this.formatBD4Save(this.db2BD(iROUA), this.amountScale).divide(this.db2BD(dprDateAmt), this.amountScale);
            } else {
                cDpr = this.formatBD4Save(this.db2BD(iROUA), this.amountScale).divide(this.db2BD(new Double(String.valueOf(billInfo.getTimeCycle()))), this.amountScale);
            }
        }
        BigDecimal iLP = this.formatBD4Save(billInfo.isIsDeductible() ? billInfo.getRentWithoutTax() : billInfo.getRentWithTax(), this.originScale).subtract(this.formatBD4Save(this.db2BD(advCf), this.originScale));
        BigDecimal iUCFC = this.formatBD4Save(billInfo.isIsDeductible() ? billInfo.getRentWithoutTax() : billInfo.getRentWithTax(), this.originScale).subtract(this.formatBD4Save(this.curACRpt.getNPV(), this.originScale));
        BigDecimal iLB = iLP.subtract(iUCFC);
        firstBizEntry.setInitRightOfUseAsset(this.formatBD4Save(this.db2BD(iROUA), this.amountScale));
        firstBizEntry.setInitLiabilityPrincipal(iLP);
        firstBizEntry.setInitUnCfmFncCost(iUCFC);
        firstBizEntry.setInitLiabilityBalance(iLB);
        BigDecimal cIP = this.formatBD4Save(iLB.multiply(this.db2BD(discountRate)), this.originScale);
        firstBizEntry.setCurDepreciation(this.formatBD4Save(cDpr, this.amountScale));
        firstBizEntry.setCurAccDepreciation(this.formatBD4Save(cDpr, this.amountScale));
        firstBizEntry.setCurInterestPayment(cIP);
        firstBizEntry.setCurAccInterestPayment(cIP);
        BigDecimal eROUA = this.formatBD4Save(this.db2BD(iROUA), this.amountScale).subtract(this.formatBD4Save(cDpr, this.amountScale));
        BigDecimal eLP = iLP.subtract(firstBizEntry.getCashflow());
        BigDecimal eUCFC = iUCFC.subtract(cIP);
        BigDecimal eLB = eLP.subtract(eUCFC);
        firstBizEntry.setEndRightOfUseAsset(eROUA);
        firstBizEntry.setEndLiabilityPrincipal(eLP);
        firstBizEntry.setEndUnCfmFncCost(eUCFC);
        firstBizEntry.setEndLiabilityBalance(eLB);
        this.curACERptCol.add(firstBizEntry);
    }

    private void calcStartEntriesByPeriodCvMethod(FaLeaseInBillNewInfo billInfo, FaNewLeasePolicyInfo newLeasePolicy, List<Date> payDateList, List<Double> cfPayArr, Date advPayDate, double advCf, double discountRate, double dayRate, boolean isIgnoreNLM303, Context ctx) {
        double cIP;
        double cDpr;
        double iROUA;
        if (payDateList == null || payDateList.size() <= 0) {
            return;
        }
        FaAmortizedCostRptEntryInfo firstBizEntry = new FaAmortizedCostRptEntryInfo();
        Calendar cld = Calendar.getInstance();
        cld.setTime(payDateList.get(0));
        firstBizEntry.setDate(payDateList.get(0));
        firstBizEntry.setMonth(cld.get(1) * 100 + cld.get(2) + 1);
        firstBizEntry.setCashflow(this.db2BD(cfPayArr.get(0)));
        Double totalCf = new Double("0");
        for (Double cf : cfPayArr) {
            totalCf = totalCf + cf;
        }
        if (billInfo.isIsDeductible()) {
            billInfo.setRentWithoutTax(new BigDecimal(totalCf));
        } else {
            billInfo.setRentWithTax(new BigDecimal(totalCf));
        }
        double periodDiscountRate = this.calcPeriodDiscountRate(billInfo, newLeasePolicy);
        double advNPV = this.calcAdvPaymentNPV(billInfo, dayRate);
        double idfCost = new Double("0");
        double grvNPV = new Double("0");
        double eeNPV = new Double("0");
        double tmNPV = new Double("0");
        double rcvNPV = new Double("0");
        double riCost = new Double("0");
        double stampTaxStM = new Double("0");
        Double exchangeRateInfo = new Double(billInfo.getExchangeRateValue().toString());
        if (billInfo.getExchangeRate() != null && billInfo.getExchangeRate().getExchangeAux().getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE) {
            exchangeRateInfo = 1.0 / exchangeRateInfo;
        }
        if (!this.isInitBill || !this.isEnableStockContract || billInfo.getBeginDate().compareTo(billInfo.getDpInitCfmDate()) >= 0) {
            idfCost = exchangeRateInfo * this.BD2db(billInfo.isIsDeductible() ? billInfo.getCostPmWithoutTaxOC2() : billInfo.getCostPmWithTaxOC2());
            grvNPV = this.calcCostNPV(this.BD2db(billInfo.isIsDeductible() ? billInfo.getCostPmWithoutTax3() : billInfo.getCostPmWithTax3()), periodDiscountRate, billInfo.getTimeCycle());
            eeNPV = this.calcCostNPV(this.BD2db(billInfo.isIsDeductible() ? billInfo.getCostPmWithoutTax4() : billInfo.getCostPmWithTax4()), periodDiscountRate, billInfo.getTimeCycle());
            tmNPV = this.calcCostNPV(this.BD2db(billInfo.isIsDeductible() ? billInfo.getCostPmWithoutTax5() : billInfo.getCostPmWithTax5()), periodDiscountRate, billInfo.getTimeCycle());
            rcvNPV = this.calcCostNPV(this.BD2db(billInfo.isIsDeductible() ? billInfo.getCostPmWithoutTax6() : billInfo.getCostPmWithTax6()), periodDiscountRate, billInfo.getTimeCycle());
            riCost = exchangeRateInfo * this.BD2db(billInfo.isIsDeductible() ? billInfo.getCostPmWithoutTaxOC7() : billInfo.getCostPmWithTaxOC7());
            stampTaxStM = new Double(billInfo.getStampTaxStM() == null ? "0" : billInfo.getStampTaxStM().toString());
        }
        double lpNPV = this.calcLeasePaymentNPV(billInfo, cfPayArr, advCf, dayRate, discountRate, isIgnoreNLM303);
        if (this.isInitBill && !isIgnoreNLM303 && this.isEnableStockContract) {
            int remainTimeCycle;
            int n = remainTimeCycle = billInfo.getBeginDate().compareTo(billInfo.getDpInitCfmDate()) < 0 ? billInfo.getTimeCycle() - this.subMonth(billInfo.getDpInitCfmDate(), billInfo.getBeginDate()) : billInfo.getTimeCycle();
            if (remainTimeCycle > 0 && billInfo.getBeginDate().compareTo(billInfo.getDpInitCfmDate()) < 0) {
                if (this.isDiscount2ImplDate) {
                    iROUA = lpNPV + advNPV;
                    iROUA *= exchangeRateInfo.doubleValue();
                } else {
                    iROUA = this.BD2db(billInfo.getBigDecimal("scInitialAsset")) - this.BD2db(billInfo.getBigDecimal("scInitAccDepreciation"));
                }
            } else {
                iROUA = lpNPV + advNPV;
                iROUA *= exchangeRateInfo.doubleValue();
                iROUA += idfCost + stampTaxStM - riCost;
            }
            cDpr = iROUA / new Double(String.valueOf(remainTimeCycle));
            firstBizEntry.put("remainTimeCycle", new Double(String.valueOf(remainTimeCycle)));
        } else {
            iROUA = lpNPV + advNPV;
            iROUA *= exchangeRateInfo.doubleValue();
            cDpr = (iROUA += idfCost + stampTaxStM - riCost) / new Double(String.valueOf(billInfo.getTimeCycle()));
        }
        firstBizEntry.setInitRightOfUseAsset(this.db2BD(iROUA));
        double iLP = this.BD2db(billInfo.isIsDeductible() ? billInfo.getRentWithoutTax() : billInfo.getRentWithTax()) + this.BD2db(billInfo.getCostPmWithTax3()) + this.BD2db(billInfo.getCostPmWithTax4()) + this.BD2db(billInfo.getCostPmWithTax5());
        double iUCFC = this.BD2db(billInfo.isIsDeductible() ? billInfo.getRentWithoutTax() : billInfo.getRentWithTax()) - lpNPV + this.BD2db(billInfo.getCostPmWithTax3()) - grvNPV + this.BD2db(billInfo.getCostPmWithTax4()) - eeNPV + this.BD2db(billInfo.getCostPmWithTax5()) - tmNPV + this.BD2db(billInfo.getCostPmWithTax6()) - rcvNPV;
        double iLB = iLP - iUCFC + this.BD2db(billInfo.getCostPmWithTax6()) - rcvNPV;
        firstBizEntry.setInitLiabilityPrincipal(this.db2BD(iLP));
        firstBizEntry.setInitUnCfmFncCost(this.db2BD(iUCFC));
        firstBizEntry.setInitLiabilityBalance(this.db2BD(iLB));
        if (this.isInitBill && !isIgnoreNLM303 && this.isEnableStockContract) {
            cIP = billInfo.getBeginDate().compareTo(billInfo.getDpInitCfmDate()) < 0 && billInfo.getPaymentEntry().get(0).getPayDate().compareTo(billInfo.getDpInitCfmDate()) < 0 ? (billInfo.getRentTime() == FaRentTime.PERIODBEGIN ? new Double("0") : iLB * periodDiscountRate) : iLB * periodDiscountRate;
            firstBizEntry.put("interestRate", periodDiscountRate);
        } else if (billInfo.isIsExistsFreePeriod()) {
            double irr = this.irr(cfPayArr, iLB, periodDiscountRate);
            irr = Double.isNaN(irr) ? new Double("0") : irr;
            cIP = iLB * irr;
            firstBizEntry.put("interestRate", irr);
        } else {
            cIP = billInfo.getRentTime() == FaRentTime.PERIODBEGIN ? new Double("0") : iLB * periodDiscountRate;
            firstBizEntry.put("interestRate", periodDiscountRate);
        }
        firstBizEntry.setCurDepreciation(this.db2BD(cDpr));
        firstBizEntry.setCurAccDepreciation(this.db2BD(cDpr));
        firstBizEntry.setCurInterestPayment(this.db2BD(cIP));
        firstBizEntry.setCurAccInterestPayment(this.db2BD(cIP));
        double eROUA = iROUA - cDpr;
        double eLP = iLP - this.BD2db(firstBizEntry.getCashflow());
        double eUCFC = iUCFC - cIP;
        double eLB = eLP - eUCFC;
        firstBizEntry.setEndRightOfUseAsset(this.db2BD(eROUA));
        firstBizEntry.setEndLiabilityPrincipal(this.db2BD(eLP));
        firstBizEntry.setEndUnCfmFncCost(this.db2BD(eUCFC));
        firstBizEntry.setEndLiabilityBalance(this.db2BD(eLB));
        this.curACERptCol.add(firstBizEntry);
    }

    private double[][] calcAfterStartEntriesUseArray(Context ctx, FaLeaseInBillNewInfo billInfo, FaNewLeasePolicyInfo newLeasePolicy, List<Date> payDateList, List<Double> cfPayArr, Date advPayDate, Date endPayDate, double discountRate, boolean isIgnoreNLM303) throws BOSException, EASBizException {
        boolean isNextDepAndIsBeforeImplDate;
        boolean isDepLessThanOrEqualToLease;
        double[][] entries = new double[payDateList.size()][13];
        if (payDateList.size() <= 1) {
            return entries;
        }
        FaAmortizedCostRptEntryInfo firstEntry = this.curACERptCol.get(this.curACERptCol.size() - 1);
        boolean isDayCvMethod = newLeasePolicy.getTranslationMethod() == FaLiabilitiesCvMethodEnum.DAY;
        int depTimeCycle = billInfo.getTimeCycle();
        int leaseTimeCycle = this.getLeaseCycle(billInfo.getBeginDate(), billInfo.getEndDate());
        boolean bl = isDepLessThanOrEqualToLease = depTimeCycle <= leaseTimeCycle;
        int endDateIndex = isDayCvMethod && newLeasePolicy.getDepreciationMethod() == DepreciationMethodEnum.First ? (this.isInitBill && !isIgnoreNLM303 && this.isEnableStockContract && billInfo.getBeginDate().compareTo(billInfo.getDpInitCfmDate()) < 0 ? this.getDepDayCount(billInfo.getDpInitCfmDate(), billInfo.getDepEndDate()) - 1 : this.getDepDayCount(billInfo.getBeginDate(), billInfo.getDepEndDate()) - 1) : (firstEntry.get("remainTimeCycle") == null ? (depTimeCycle < leaseTimeCycle ? billInfo.getTimeCycle() - 1 : leaseTimeCycle - 1) : firstEntry.getInt("remainTimeCycle") - 1);
        int monthCount = 0;
        Date lastDate = null;
        entries[0][0] = this.BD2db(this.formatBD4Save(this.db2BD(cfPayArr.get(1)), this.originScale));
        entries[0][1] = this.BD2db(firstEntry.getInitRightOfUseAsset());
        entries[0][2] = this.BD2db(firstEntry.getInitLiabilityPrincipal());
        entries[0][3] = this.BD2db(firstEntry.getInitUnCfmFncCost());
        entries[0][4] = this.BD2db(firstEntry.getInitLiabilityBalance());
        entries[0][5] = this.BD2db(firstEntry.getCurDepreciation());
        entries[0][6] = this.BD2db(firstEntry.getCurAccDepreciation());
        entries[0][7] = this.BD2db(firstEntry.getCurInterestPayment());
        entries[0][8] = this.BD2db(firstEntry.getCurAccInterestPayment());
        entries[0][9] = this.BD2db(firstEntry.getEndRightOfUseAsset());
        entries[0][10] = this.BD2db(firstEntry.getEndLiabilityPrincipal());
        entries[0][11] = this.BD2db(firstEntry.getEndUnCfmFncCost());
        entries[0][12] = this.BD2db(firstEntry.getEndLiabilityBalance());
        boolean isNewNextDep = billInfo.getContractCat().getDepreciationPolicy() != null && billInfo.getContractCat().getDepreciationPolicy().getStartDeprTime() == FaLeaseStartDeprTimeRuleEnum.NEW_NEXT_DEP;
        double curDepreciationTmp = this.BD2db(firstEntry.getCurDepreciation());
        boolean bl2 = isNextDepAndIsBeforeImplDate = isNewNextDep && (this.isDiscount2ImplDate || !billInfo.isIsBeforeImplDate());
        if (isNextDepAndIsBeforeImplDate && newLeasePolicy.getDepreciationMethod() == DepreciationMethodEnum.Second) {
            entries[0][5] = 0.0;
            firstEntry.setCurDepreciation(BigDecimal.ZERO);
            entries[0][6] = 0.0;
            firstEntry.setCurAccDepreciation(BigDecimal.ZERO);
            entries[0][9] = this.BD2db(firstEntry.getInitRightOfUseAsset());
            firstEntry.setEndRightOfUseAsset(firstEntry.getInitRightOfUseAsset());
            if (depTimeCycle < leaseTimeCycle) {
                ++endDateIndex;
            }
        }
        for (int i = 1; i < payDateList.size(); ++i) {
            entries[i][0] = this.BD2db(this.formatBD4Save(this.db2BD(cfPayArr.get(i)), this.originScale));
            entries[i][1] = entries[i - 1][9];
            entries[i][2] = entries[i - 1][10];
            entries[i][3] = entries[i - 1][11];
            entries[i][4] = entries[i - 1][12];
            double cIP = i == payDateList.size() - 1 ? this.BD2db(firstEntry.getInitUnCfmFncCost()) - entries[i - 1][8] : (isDayCvMethod ? this.BD2db(this.formatBD4Save(this.db2BD(entries[i][4] * discountRate), this.originScale)) : entries[i][4] * firstEntry.getDouble("interestRate"));
            double cAIP = new Double("0");
            for (double[] entry : entries) {
                cAIP += entry[7];
            }
            cAIP += cIP;
            if (isDayCvMethod && newLeasePolicy.getDepreciationMethod() == DepreciationMethodEnum.Second) {
                if (lastDate == null) {
                    lastDate = payDateList.get(0);
                }
                if (this.compareYearMonth(lastDate, payDateList.get(i))) {
                    lastDate = payDateList.get(i);
                    if (++monthCount <= endDateIndex) {
                        entries[i][5] = isNextDepAndIsBeforeImplDate ? curDepreciationTmp : this.BD2db(firstEntry.getCurDepreciation());
                        entries[i][6] = entries[i][5] * new Double(String.valueOf(isNextDepAndIsBeforeImplDate ? monthCount : monthCount + 1));
                        if (monthCount == endDateIndex && isDepLessThanOrEqualToLease) {
                            entries[i][5] = entries[i][1];
                            entries[i][6] = entries[0][1];
                        }
                    } else if (!isDepLessThanOrEqualToLease) {
                        entries[i][5] = isNextDepAndIsBeforeImplDate ? curDepreciationTmp : this.BD2db(firstEntry.getCurDepreciation());
                        entries[i][6] = entries[i][5] * new Double(String.valueOf(isNextDepAndIsBeforeImplDate ? monthCount : monthCount + 1));
                    } else {
                        entries[i][5] = new Double("0");
                        entries[i][6] = entries[i - 1][6];
                    }
                } else {
                    entries[i][5] = new Double("0");
                    entries[i][6] = entries[i - 1][6];
                }
            } else if (i <= endDateIndex) {
                entries[i][5] = entries[i - 1][5];
                entries[i][6] = entries[i - 1][5] * new Double(String.valueOf(i + 1));
                if (i == endDateIndex && isDepLessThanOrEqualToLease) {
                    entries[i][5] = entries[i][1];
                    entries[i][6] = entries[0][1];
                }
            } else {
                entries[i][5] = new Double("0");
                entries[i][6] = entries[0][1];
            }
            entries[i][7] = cIP;
            entries[i][8] = cAIP;
            if (payDateList.get(i).getTime() == endPayDate.getTime()) {
                entries[i][7] = entries[0][3] - entries[i - 1][8];
                entries[i][8] = entries[0][3];
            } else if (payDateList.get(i).getTime() > endPayDate.getTime()) {
                entries[i][7] = new Double("0");
                entries[i][8] = entries[0][3];
            }
            entries[i][9] = entries[i][1] - entries[i][5];
            entries[i][10] = entries[i][2] - entries[i][0];
            entries[i][11] = entries[i][3] - entries[i][7];
            entries[i][12] = entries[i][10] - entries[i][11];
        }
        return entries;
    }

    private void setEntries(double[][] entries, List<Date> payDateList, FaLiabilitiesCvMethodEnum cvMethod) {
        int scale = 8;
        this.formatBD4Save(this.curACRpt.getNPV(), this.originScale);
        Calendar cld = Calendar.getInstance();
        for (int i = 1; i < entries.length; ++i) {
            FaAmortizedCostRptEntryInfo entry = new FaAmortizedCostRptEntryInfo();
            entry.setDate(payDateList.get(i));
            if (cvMethod == FaLiabilitiesCvMethodEnum.PERIOD) {
                cld.setTime(payDateList.get(i));
                entry.setMonth(cld.get(1) * 100 + cld.get(2) + 1);
            }
            entry.setCashflow(this.formatBD4Save(this.db2BD(entries[i][0]), this.originScale));
            entry.setInitRightOfUseAsset(this.formatBD4Save(this.db2BD(entries[i][1]), this.amountScale));
            entry.setInitLiabilityPrincipal(this.formatBD4Save(this.db2BD(entries[i][2]), this.originScale));
            entry.setInitUnCfmFncCost(this.formatBD4Save(this.db2BD(entries[i][3]), this.originScale));
            entry.setInitLiabilityBalance(this.formatBD4Save(this.db2BD(entries[i][4]), this.originScale));
            entry.setCurDepreciation(this.formatBD4Save(this.db2BD(entries[i][5]), this.amountScale));
            entry.setCurAccDepreciation(this.formatBD4Save(this.db2BD(entries[i][6]), this.amountScale));
            entry.setCurInterestPayment(this.formatBD4Save(this.db2BD(entries[i][7]), this.originScale));
            entry.setCurAccInterestPayment(this.formatBD4Save(this.db2BD(entries[i][8]), this.originScale));
            entry.setEndRightOfUseAsset(this.formatBD4Save(this.db2BD(entries[i][9]), this.amountScale));
            entry.setEndLiabilityPrincipal(this.formatBD4Save(this.db2BD(entries[i][10]), this.originScale));
            entry.setEndUnCfmFncCost(this.formatBD4Save(this.db2BD(entries[i][11]), this.originScale));
            entry.setEndLiabilityBalance(this.formatBD4Save(this.db2BD(entries[i][12]), this.originScale));
            this.curACERptCol.add(entry);
        }
    }

    private double BD2db(BigDecimal bd) {
        return bd == null ? new Double("0").doubleValue() : bd.doubleValue();
    }

    private BigDecimal db2BD(double d) {
        return new BigDecimal(String.valueOf(d));
    }

    private BigDecimal formatBD4Save(BigDecimal bd, int saveScale) {
        if (bd != null) {
            bd = bd.setScale(saveScale, 4);
        }
        return bd;
    }

    private double calcPWOT(double pwt, double taxRate) {
        return pwt / (new Double("1") + taxRate / new Double("100"));
    }

    private double calcNPV(double discountRate, List<Double> cfPayArr) {
        double[] cfArr = new double[cfPayArr.size()];
        for (int i = 0; i < cfPayArr.size(); ++i) {
            cfArr[i] = cfPayArr.get(i);
        }
        return FinanceLib.npv((double)discountRate, (double[])cfArr);
    }

    private Date nextDate(Date curDate) {
        Calendar curCld = Calendar.getInstance();
        Calendar nxtCld = Calendar.getInstance();
        curCld.setTime(curDate);
        nxtCld.setTimeInMillis(curCld.getTimeInMillis() + 86400000L);
        return nxtCld.getTime();
    }

    private int subDate(Date date1, Date date2) {
        Calendar cld1 = Calendar.getInstance();
        Calendar cld2 = Calendar.getInstance();
        cld1.setTime(date1);
        cld2.setTime(date2);
        cld1.set(cld1.get(1), cld1.get(2), cld1.get(5), 0, 0, 0);
        cld2.set(cld2.get(1), cld2.get(2), cld2.get(5), 0, 0, 0);
        return (int)((cld1.getTimeInMillis() - cld2.getTimeInMillis()) / 86400000L);
    }

    private Date nextMonth(Date curDate) {
        Calendar curCld = Calendar.getInstance();
        Calendar nxtCld = Calendar.getInstance();
        curCld.setTime(curDate);
        nxtCld.set(curCld.get(1), curCld.get(2) + 1, 1, 0, 0, 0);
        return nxtCld.getTime();
    }

    private int subMonth(Date date1, Date date2) {
        Calendar cld1 = Calendar.getInstance();
        Calendar cld2 = Calendar.getInstance();
        cld1.setTime(date1);
        cld2.setTime(date2);
        return (cld1.get(1) - cld2.get(1)) * 12 + cld1.get(2) - cld2.get(2);
    }

    private Date getPayFrequencyLastMonth(Date curDate, int n) {
        Calendar curCld = Calendar.getInstance();
        Calendar nxtCld = Calendar.getInstance();
        curCld.setTime(curDate);
        nxtCld.set(curCld.get(1), curCld.get(2) + (n - 1), 1, 0, 0, 0);
        return nxtCld.getTime();
    }

    private boolean compareYearMonth(Date date1, Date date2) {
        Calendar cld1 = Calendar.getInstance();
        Calendar cld2 = Calendar.getInstance();
        cld1.setTime(date1);
        cld2.setTime(date2);
        return cld1.get(1) < cld2.get(1) || cld1.get(1) == cld2.get(1) && cld1.get(2) < cld2.get(2);
    }

    private Date getLastDay(Date date) {
        Calendar cld = Calendar.getInstance();
        cld.setTime(date);
        cld.set(5, cld.getActualMaximum(5));
        return cld.getTime();
    }

    private Date getNewEndDate(Date date, int month) {
        Calendar cld = Calendar.getInstance();
        cld.setTime(date);
        cld.add(5, -1);
        cld.add(2, month);
        return cld.getTime();
    }

    private FaAmortizedCostRptEntryCollection transformACRptDataInMonth(Context ctx, String leaseInBillId) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tt1.*, t2.*, t3.* \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("FROM \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("( \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tSELECT \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t    \r\n");
        sql.append("\t\tt.month month1, t.minDate, entry.FInitLiabilityPrincipal FInitLiabilityPrincipal, entry.FInitUnCfmFncCost FInitUnCfmFncCost, \t\t\t\t\r\n");
        sql.append("\t\tentry.FInitLiabilityBalance FInitLiabilityBalance, entry.FCurDepreciation FCurDepreciation, entry.FCurAccDepreciation FCurAccDepreciation, \t\r\n");
        sql.append("\t\tentry.FInitRightOfUseAsset FInitRightOfUseAsset, entry.FInitialAssetDecValue FInitialAssetDecValue\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tFROM  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t\r\n");
        sql.append("\t(  \t\t\t \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\t\tSELECT t.rptID, t.month, MIN(t.FDate) minDate FROM  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\t\t(  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\t\t\tSELECT  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\t\t\t\trpt.FID rptID, TO_NUMBER(TO_NUMBER(YEAR(FDATE)) * 100 + TO_NUMBER(MONTH(FDATE))) AS month, entry.* \t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\t\t\tFROM T_Fa_FaAmortizedCostRpt rpt \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\t\t\tLEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FID = entry.FAmortizedCostRptID \t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\t\t\tWHERE rpt.FLeaseInBillID = ?\t\t\t\t \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\t\t) t  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\t\tGROUP BY t.rptID,t.month  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\t) t  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tLEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON t.minDate = entry.FDate AND t.rptID = entry.FAmortizedCostRptID \t\t\t\t\t\t\t\t\r\n");
        sql.append(") t1 \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("INNER JOIN (  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tSELECT  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\t\tt.month month2, entry.FCurAccInterestPayment FCurAccInterestPayment, entry.FEndLiabilityPrincipal FEndLiabilityPrincipal,\t\t\t\t\t\r\n");
        sql.append(" \t\tentry.FEndUnCfmFncCost FEndUnCfmFncCost, entry.FEndLiabilityBalance FEndLiabilityBalance, \t\t\t\t\t\t\t\t\t\t\t\t \t\r\n");
        sql.append("\t\tentry.FEndRightOfUseAsset FEndRightOfUseAsset, entry.FInitialAssetDecValue FInitialAssetDecValue\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tFROM \t\t\t \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\t( \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\t\tSELECT t.rptID, t.month, MAX(t.FDate) maxDate FROM \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\t\t( \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\t\t\tSELECT  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\t\t\t\trpt.FID rptID, TO_NUMBER(TO_NUMBER(YEAR(FDATE)) * 100 + TO_NUMBER(MONTH(FDATE))) AS month, entry.* \t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\t\t\tFROM T_Fa_FaAmortizedCostRpt rpt \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\t\t\tLEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FID = entry.FAmortizedCostRptID \t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\t\t\tWHERE rpt.FLeaseInBillID = ?\t\t\t\t  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\t\t) t  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\t\tGROUP BY t.rptID,t.month  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\t) t  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tLEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON t.maxDate = entry.FDate AND t.rptID = entry.FAmortizedCostRptID \t\t\t\t\t\t\t\t\r\n");
        sql.append(") t2 ON t1.month1 = t2.month2  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("INNER JOIN (  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tSELECT  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\t\tt.month month3, MAX(t.FDate) maxDate, SUM(FCashFlow) FCashFlow, SUM(FCurInterestPayment) FCurInterestPayment\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tFROM  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\t(  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\t\tSELECT  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\t\t\tTO_NUMBER(TO_NUMBER(YEAR(FDATE)) * 100 + TO_NUMBER(MONTH(FDATE))) AS month, entry.* \t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\t\tFROM T_Fa_FaAmortizedCostRpt rpt  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\t\tLEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FID = entry.FAmortizedCostRptID \t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\t\tWHERE rpt.FLeaseInBillID = ?\t\t\t\t \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\t) t  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tGROUP BY t.month  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append(") t3 ON t2.month2 = t3.month3  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("ORDER BY t1.month1  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        FaAmortizedCostRptEntryCollection entryCol = new FaAmortizedCostRptEntryCollection();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{leaseInBillId, leaseInBillId, leaseInBillId});
        try {
            if (rs == null) {
                return null;
            }
            while (rs.next()) {
                FaAmortizedCostRptEntryInfo entry = new FaAmortizedCostRptEntryInfo();
                entry.setMonth(rs.getInt("month1"));
                entry.setCashflow(rs.getBigDecimal("FCashflow"));
                entry.setInitRightOfUseAsset(rs.getBigDecimal("FInitRightOfUseAsset"));
                entry.setInitLiabilityPrincipal(rs.getBigDecimal("FInitLiabilityPrincipal"));
                entry.setInitUnCfmFncCost(rs.getBigDecimal("FInitUnCfmFncCost"));
                entry.setInitLiabilityBalance(rs.getBigDecimal("FInitLiabilityBalance"));
                entry.setCurDepreciation(rs.getBigDecimal("FCurDepreciation"));
                entry.setCurAccDepreciation(rs.getBigDecimal("FCurAccDepreciation"));
                entry.setCurInterestPayment(rs.getBigDecimal("FCurInterestPayment"));
                entry.setCurAccInterestPayment(rs.getBigDecimal("FCurAccInterestPayment"));
                entry.setEndRightOfUseAsset(rs.getBigDecimal("FEndRightOfUseAsset"));
                entry.setEndLiabilityPrincipal(rs.getBigDecimal("FEndLiabilityPrincipal"));
                entry.setEndUnCfmFncCost(rs.getBigDecimal("FEndUnCfmFncCost"));
                entry.setEndLiabilityBalance(rs.getBigDecimal("FEndLiabilityBalance"));
                entry.setInitialAssetDecValue(rs.getBigDecimal("FInitialAssetDecValue"));
                entryCol.add(entry);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return entryCol;
    }

    private FaLeaseInBillNewInfo getLeaseInBill(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("contractCat.id");
        sic.add("contractCat.name");
        sic.add("contractCat.depreciationPolicy");
        sic.add("contractCat.depreciationPolicy.*");
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("company.id");
        sic.add("company.name");
        sic.add("company.baseCurrency.precision");
        sic.add("company.accountPeriodType.*");
        sic.add("paymentEntry.*");
        sic.add("exchangeRate.*");
        sic.add("exchangeRate.exchangeAux.*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString()));
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("paymentEntry.payDate"));
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        view.setFilter(filter);
        view.setSorter(sorter);
        FaLeaseInBillNewCollection col = this.getLIBNBizInterface(ctx).getFaLeaseInBillNewCollection(view);
        if (col.size() < 0) {
            return null;
        }
        return col.get(0);
    }

    private IFaLeaseInBillNew getLIBNBizInterface(Context ctx) throws BOSException {
        return FaLeaseInBillNewFactory.getLocalInstance(ctx);
    }

    private IFaDepreAndAmort getDABizInterface(Context ctx) throws BOSException {
        return FaDepreAndAmortFactory.getLocalInstance(ctx);
    }

    protected CompanyOrgUnitInfo getCurrentCompany(Context ctx) throws BOSException, EASBizException {
        if (this.curCompany == null) {
            String companyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
            this.curCompany = this.getCompanyById(companyID, ctx);
        }
        return this.curCompany;
    }

    protected CompanyOrgUnitInfo getCompanyById(String companyID, Context ctx) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("basecurrency.precision"));
        sic.add(new SelectorItemInfo("isbizunit"));
        sic.add(new SelectorItemInfo("accountTable"));
        return CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID), sic);
    }

    protected int getCurrencyScale(String Id, Context ctx) throws EASBizException, BOSException {
        return CurrencyFactory.getLocalInstance((Context)ctx).getValue("select precision where id='" + Id + "'").getInt("precision");
    }

    private int getLeaseCycle(Date beginDate, Date endDate) {
        if (beginDate == null || endDate == null) {
            return 0;
        }
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(beginDate);
        c2.setTime(endDate);
        int monthCount = c2.get(2) - c1.get(2);
        int yearCount = (c2.get(1) - c1.get(1)) * 12;
        int dayCount = c2.get(5) - c1.get(5);
        int leaseCycle = monthCount + yearCount;
        if (dayCount >= 0) {
            ++leaseCycle;
        }
        return leaseCycle;
    }

    private int getDepDayCount(Date beginDate, Date depEndDate) {
        return this.subDate(depEndDate, beginDate) + 1;
    }
}

