/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaBaseDataSouceEnum;
import com.kingdee.eas.fi.fa.basedata.FaBasicException;
import com.kingdee.eas.fi.nlm.FaContractCatCollection;
import com.kingdee.eas.fi.nlm.FaContractCatFactory;
import com.kingdee.eas.fi.nlm.FaContractCatInfo;
import com.kingdee.eas.fi.nlm.NLMAccountBalanceDetailCollection;
import com.kingdee.eas.fi.nlm.NLMAccountBalanceDetailFactory;
import com.kingdee.eas.fi.nlm.NLMAccountBalanceDetailInfo;
import com.kingdee.eas.fi.nlm.NLMBillContractCatFieldNameEnum;
import com.kingdee.eas.fi.nlm.app.AbstractFaContractCatControllerBean;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;

public class FaContractCatControllerBean
extends AbstractFaContractCatControllerBean {
    private Object object;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.nlm.app.FaContractCatControllerBean");

    private UserInfo getUserInfo(Context ctx) throws BOSException {
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        return userInfo;
    }

    protected IObjectPK _importData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AccountViewInfo assetDisposalAcct;
        AccountViewInfo assetsDepreciationAcct;
        AccountViewInfo leaseLiabilitiesAcct;
        AccountViewInfo interestAdjustmentAcct;
        AccountViewInfo principalPayableAcct;
        AccountViewInfo usufructAssetAcctACM;
        UserInfo userInfo = this.getUserInfo(ctx);
        FaContractCatInfo info = (FaContractCatInfo)model;
        info.setCreator(userInfo);
        Date date = new Date();
        long time = date.getTime();
        info.setCreateTime(new Timestamp(time));
        info.setLastUpdateUser(userInfo);
        info.setLastUpdateTime(new Timestamp(time));
        String companyId = info.getCompany().getId().toString();
        if (info.getCompany().getAccountTable() == null) {
            throw new FaBasicException(FaBasicException.ACCOUNTTABLE_NOT_ENABLE);
        }
        String accountTableId = info.getCompany().getAccountTable().getId().toString();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("usufructAssetAcct.id"));
        selector.add(new SelectorItemInfo("usufructAssetAcct.number"));
        selector.add(new SelectorItemInfo("usufructAssetAcctACM.number"));
        selector.add(new SelectorItemInfo("principalPayableAcct.number"));
        selector.add(new SelectorItemInfo("interestAdjustmentAcct.number"));
        selector.add(new SelectorItemInfo("leaseLiabilitiesAcct.number"));
        selector.add(new SelectorItemInfo("assetsDepreciationAcct.number"));
        selector.add(new SelectorItemInfo("assetDisposalAcct.number"));
        FaContractCatInfo catinfo = (FaContractCatInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(info.get("treeId").toString()), selector);
        AccountViewInfo usufructAssetAcct = catinfo.getUsufructAssetAcct();
        if (usufructAssetAcct != null) {
            info.setUsufructAssetAcct(FaContractCatControllerBean.getAccountViewCByNumber(ctx, usufructAssetAcct.getNumber(), companyId, accountTableId));
        }
        if ((usufructAssetAcctACM = catinfo.getUsufructAssetAcctACM()) != null) {
            info.setUsufructAssetAcctACM(FaContractCatControllerBean.getAccountViewCByNumber(ctx, usufructAssetAcctACM.getNumber(), companyId, accountTableId));
        }
        if ((principalPayableAcct = catinfo.getPrincipalPayableAcct()) != null) {
            info.setPrincipalPayableAcct(FaContractCatControllerBean.getAccountViewCByNumber(ctx, principalPayableAcct.getNumber(), companyId, accountTableId));
        }
        if ((interestAdjustmentAcct = catinfo.getInterestAdjustmentAcct()) != null) {
            info.setInterestAdjustmentAcct(FaContractCatControllerBean.getAccountViewCByNumber(ctx, interestAdjustmentAcct.getNumber(), companyId, accountTableId));
        }
        if ((leaseLiabilitiesAcct = catinfo.getLeaseLiabilitiesAcct()) != null) {
            info.setLeaseLiabilitiesAcct(FaContractCatControllerBean.getAccountViewCByNumber(ctx, leaseLiabilitiesAcct.getNumber(), companyId, accountTableId));
        }
        if ((assetsDepreciationAcct = catinfo.getAssetsDepreciationAcct()) != null) {
            info.setAssetsDepreciationAcct(FaContractCatControllerBean.getAccountViewCByNumber(ctx, assetsDepreciationAcct.getNumber(), companyId, accountTableId));
        }
        if ((assetDisposalAcct = catinfo.getAssetDisposalAcct()) != null) {
            info.setAssetDisposalAcct(FaContractCatControllerBean.getAccountViewCByNumber(ctx, assetDisposalAcct.getNumber(), companyId, accountTableId));
        }
        IObjectPK pk = this.innerAddnew(ctx, model);
        return pk;
    }

    public static AccountViewInfo getAccountViewCByNumber(Context ctx, String number, String companyInfoPK, String accountTableInfoPK) throws BOSException, EASBizException {
        if (companyInfoPK == null || StringUtils.isEmpty((String)number)) {
            return null;
        }
        AccountViewInfo accountViewInfo = null;
        AccountViewCollection accounts = null;
        IAccountView iAccountView = AccountViewFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CompanyID.id", (Object)companyInfoPK));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTableInfoPK));
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)1));
        accounts = iAccountView.getAccountViewCollection(evi);
        if (accounts != null && accounts.size() > 0) {
            accountViewInfo = accounts.get(0);
        }
        return accountViewInfo;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FaContractCatInfo faContractCatInfo = (FaContractCatInfo)this._getValue(ctx, pk);
        if (faContractCatInfo.getSourceMode().getValue() == 2) {
            throw new FaBasicException(FaBasicException.CANNOT_DELETE_IMPORT_CONTRACTCAT);
        }
        this.checkHasBeanImported(ctx, pk);
        super._delete(ctx, pk);
    }

    protected void checkHasBeanImported(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.longNumber"));
        FaContractCatInfo info = FaContractCatFactory.getLocalInstance(ctx).getFaContractCatInfo(pk, sic);
        String useStatusNumber = info.getNumber();
        String companyLongNumber = info.getCompany().getLongNumber();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)useStatusNumber, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("sourceMode", (Object)FaBaseDataSouceEnum.IMPORT, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.longNumber", (Object)(companyLongNumber + "!%"), CompareType.LIKE));
        view.setSelector(selector);
        view.setFilter(filter);
        FaContractCatCollection imported = FaContractCatFactory.getLocalInstance(ctx).getFaContractCatCollection(view);
        if (imported.size() > 0) {
            throw new FaBasicException(FaBasicException.HAVE_IMPORTED);
        }
    }

    protected void checkLNForTree(Context ctx, TreeBaseInfo treeBaseInfo) throws BOSException, EASBizException, TreeBaseException {
        FilterInfo lNfilter = new FilterInfo();
        lNfilter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)treeBaseInfo.getLongNumber()));
        lNfilter.getFilterItems().add(new FilterItemInfo("id", (Object)treeBaseInfo.getId().toString(), CompareType.NOTEQUALS));
        FaContractCatInfo faContractCatInfo = (FaContractCatInfo)treeBaseInfo;
        if (faContractCatInfo.getCompany() != null) {
            lNfilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)faContractCatInfo.getCompany().getId().toString(), CompareType.EQUALS));
        }
        if (this.exists(ctx, lNfilter)) {
            throw new TreeBaseException(TreeBaseException.CHECKNUMBERDUPLICATED, new Object[]{treeBaseInfo.getNumber()});
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaContractCatInfo faContractCatInfo = (FaContractCatInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)faContractCatInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (faContractCatInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)faContractCatInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (faContractCatInfo.getCompany() != null) {
            filterItem = new FilterItemInfo("company.id", (Object)faContractCatInfo.getCompany().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("company.id", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        filter.setMaskString(sb.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, (DataBaseInfo)faContractCatInfo, "number") + faContractCatInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK iObjectPK = super._submit(ctx, model);
        this.updateAccountBalanceDetailValue(ctx, (FaContractCatInfo)model);
        return iObjectPK;
    }

    private void updateAccountBalanceDetailValue(Context ctx, FaContractCatInfo faContractCatInfo) throws BOSException, EASBizException {
        if (faContractCatInfo == null || faContractCatInfo.getId() == null) {
            return;
        }
        NLMAccountBalanceDetailCollection accountBalanceDetailCollection = NLMAccountBalanceDetailFactory.getLocalInstance(ctx).getNLMAccountBalanceDetailCollection("where nlmBillContractCat.id = '" + faContractCatInfo.getId().toString() + "'");
        if (accountBalanceDetailCollection == null || accountBalanceDetailCollection.size() == 0) {
            return;
        }
        int j = accountBalanceDetailCollection.size();
        for (int i = 0; i < j; ++i) {
            NLMAccountBalanceDetailInfo detailInfo = accountBalanceDetailCollection.get(i);
            if (detailInfo.getContractCatFieldName() == NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_ACT) {
                this.updateDetailValue(ctx, faContractCatInfo.getUsufructAssetAcct(), detailInfo.getId().toString());
            }
            if (detailInfo.getContractCatFieldName() == NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_ACC_DEP) {
                this.updateDetailValue(ctx, faContractCatInfo.getUsufructAssetAcctACM(), detailInfo.getId().toString());
            }
            if (detailInfo.getContractCatFieldName() != NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_DEC_VALUE) continue;
            this.updateDetailValue(ctx, faContractCatInfo.getUsufructAssetAcctDEC(), detailInfo.getId().toString());
        }
    }

    private void updateDetailValue(Context ctx, AccountViewInfo contractCatFieldValue, String accountBalanceDetailId) throws BOSException {
        String contractCatFieldValueID = "";
        if (contractCatFieldValue != null && contractCatFieldValue.getId() != null) {
            contractCatFieldValueID = contractCatFieldValue.getId().toString();
        }
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("update T_NLM_NLMAccountBalanceDetail set FContractCatFieldValueID = ? where FID = ? ");
        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{contractCatFieldValueID, accountBalanceDetailId});
    }
}

