/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.app.SystemStatusCtrolUtils;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.nlm.FaAmortizedCostRptEntryCollection;
import com.kingdee.eas.fi.nlm.FaAmortizedCostRptEntryInfo;
import com.kingdee.eas.fi.nlm.FaAmortizedCostRptFactory;
import com.kingdee.eas.fi.nlm.FaAmortizedCostRptInfo;
import com.kingdee.eas.fi.nlm.FaDepreAndAmortCollection;
import com.kingdee.eas.fi.nlm.FaDepreAndAmortFactory;
import com.kingdee.eas.fi.nlm.FaDepreAndAmortInfo;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewFactory;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.nlm.FaLeaseNewDepCostSharingFactory;
import com.kingdee.eas.fi.nlm.FaLeaseNewDepCostSharingInfo;
import com.kingdee.eas.fi.nlm.FaLiabilitiesCvMethodEnum;
import com.kingdee.eas.fi.nlm.FaPaymentPlanNewCollection;
import com.kingdee.eas.fi.nlm.FaTerminateBillFactory;
import com.kingdee.eas.fi.nlm.app.AbstractFaDepreAndAmortControllerBean;
import com.kingdee.eas.fi.nlm.app.fleventlistener.utils.RPCMethodMappingUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class FaDepreAndAmortControllerBean
extends AbstractFaDepreAndAmortControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.nlm.app.FaDepreAndAmortControllerBean");
    private static final String RES_PATH = "com.kingdee.eas.fi.nlm.FaDepreAndAmortResources";
    private static Set<String> leaseInIdSet = new HashSet<String>();
    private static Set<String> leaseInIdSetForTerminateDep = new HashSet<String>();
    private static Set<String> deleteTerminateDepData = new HashSet<String>();

    @Override
    protected void _calculateDepreAndAmort(Context ctx, String leaseInBillId) throws BOSException, EASBizException {
        int entryCount;
        FaAmortizedCostRptInfo amortizedCostRpt;
        FaAmortizedCostRptEntryCollection entry;
        int rptCount;
        FaLeaseInBillNewInfo billInfo = FaLeaseInBillNewFactory.getLocalInstance(ctx).getFaLeaseInBillNewInfo((IObjectPK)new ObjectUuidPK(leaseInBillId));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("leaseInBill.id", (Object)leaseInBillId);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add("leaseInBill.id");
        selector.add("leaseInBill.number");
        selector.add("leaseInBill.contractCat.id");
        selector.add("leaseInBill.contractNumber");
        selector.add("leaseInBill.contractCat.name");
        selector.add("leaseInBill.company.id");
        selector.add("leaseInBill.company.name");
        selector.add("entry.*");
        view.setSelector(selector);
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        sorter.add(new SorterItemInfo("entry.date"));
        view.setSorter(sorter);
        CoreBaseCollection amortizedCostRptColl = FaAmortizedCostRptFactory.getLocalInstance(ctx).getCollection(view);
        if (amortizedCostRptColl != null && (rptCount = amortizedCostRptColl.size()) > 0 && (entry = (amortizedCostRpt = (FaAmortizedCostRptInfo)amortizedCostRptColl.get(0)).getEntry()) != null && (entryCount = entry.size()) > 0) {
            FaAmortizedCostRptEntryInfo firstInfo = entry.get(0);
            FaAmortizedCostRptEntryInfo lasetInfo = entry.get(entryCount - 1);
            PeriodCollection periodColl = PeriodUtils.getPeriodCollection((Context)ctx, (Date)firstInfo.getDate(), (Date)lasetInfo.getDate(), (CompanyOrgUnitInfo)amortizedCostRpt.getLeaseInBill().getCompany());
            if (periodColl != null && periodColl.size() > 0) {
                HashMap<String, FaDepreAndAmortInfo> periodDeroreAmortMap = new HashMap<String, FaDepreAndAmortInfo>(periodColl.size());
                FaDepreAndAmortCollection depreAndAmortColl = new FaDepreAndAmortCollection();
                for (PeriodInfo period : periodColl) {
                    if (period.isIsAdjustPeriod()) continue;
                    FaDepreAndAmortInfo depreAndAmort = new FaDepreAndAmortInfo();
                    depreAndAmort.setPeriod(period);
                    depreAndAmort.setLeaseInBill(billInfo);
                    depreAndAmort.setContractName(billInfo.getContractName());
                    depreAndAmort.setContractNumber(billInfo.getContractNumber());
                    depreAndAmort.setContractType(billInfo.getContractCat());
                    depreAndAmort.setBeginAssets(billInfo.getInitialAsset());
                    depreAndAmort.setBeginLiabilities(billInfo.getInitialLiability());
                    depreAndAmort.setAcumDepreAmt(BigDecimal.ZERO);
                    depreAndAmort.setAcumInterestExpe(BigDecimal.ZERO);
                    depreAndAmort.setMonthlyDepreAmt(BigDecimal.ZERO);
                    depreAndAmort.setMonthlyInterestExpe(BigDecimal.ZERO);
                    depreAndAmort.setFiVouchered(false);
                    depreAndAmort.setCompany(amortizedCostRpt.getLeaseInBill().getCompany());
                    periodDeroreAmortMap.put(String.valueOf(period.getNumber()), depreAndAmort);
                }
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
                BigDecimal acumDepreAmt = BigDecimal.ZERO;
                BigDecimal acumInterestExpe = BigDecimal.ZERO;
                FaPaymentPlanNewCollection ppCol = billInfo.getPaymentEntry();
                ppCol.sort("payDate");
                Date lastPayDate = ppCol.get(ppCol.size() - 1).getPayDate();
                for (int i = 0; i < entry.size(); ++i) {
                    FaDepreAndAmortInfo lastDepreAndAmort;
                    PeriodInfo lasPeriodInfo;
                    FaAmortizedCostRptEntryInfo entryInfo = entry.get(i);
                    String periodKey = sdf.format(entryInfo.getDate());
                    FaDepreAndAmortInfo depreAndAmort = (FaDepreAndAmortInfo)periodDeroreAmortMap.get(periodKey);
                    if (depreAndAmort == null) continue;
                    PeriodInfo period = depreAndAmort.getPeriod();
                    BigDecimal monthlyDepreAmt = depreAndAmort.getMonthlyDepreAmt();
                    BigDecimal monthlyInterestExpe = depreAndAmort.getMonthlyInterestExpe();
                    monthlyDepreAmt = monthlyDepreAmt.add(entryInfo.getCurDepreciation());
                    depreAndAmort.setMonthlyDepreAmt(monthlyDepreAmt);
                    monthlyInterestExpe = monthlyInterestExpe.add(entryInfo.getCurInterestPayment());
                    depreAndAmort.setMonthlyInterestExpe(monthlyInterestExpe);
                    if (period.getEndDate().getTime() == entryInfo.getDate().getTime() || i + 1 == entry.size()) {
                        acumDepreAmt = acumDepreAmt.add(monthlyDepreAmt);
                        acumInterestExpe = acumInterestExpe.add(monthlyInterestExpe);
                        depreAndAmort.setAcumDepreAmt(acumDepreAmt);
                        depreAndAmort.setAcumInterestExpe(acumInterestExpe);
                    }
                    if (entryInfo.getDate().compareTo(lastPayDate) == 0) {
                        lasPeriodInfo = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)period);
                        lastDepreAndAmort = (FaDepreAndAmortInfo)periodDeroreAmortMap.get(String.valueOf(lasPeriodInfo.getNumber()));
                        BigDecimal lastAcumInterestExpe = BigDecimal.ZERO;
                        BigDecimal initUnCfmFncCost = BigDecimal.ZERO;
                        if (lastDepreAndAmort != null) {
                            lastAcumInterestExpe = lastDepreAndAmort.getAcumInterestExpe();
                        }
                        initUnCfmFncCost = billInfo.getFirstPayTime().compareTo(billInfo.getBeginDate()) >= 0 ? entry.get(0).getInitUnCfmFncCost() : entry.get(1).getInitUnCfmFncCost();
                        BigDecimal lastMonthlyInterestExpe = initUnCfmFncCost.subtract(lastAcumInterestExpe);
                        depreAndAmort.setMonthlyInterestExpe(lastMonthlyInterestExpe);
                    }
                    if (i + 1 != entry.size()) continue;
                    lasPeriodInfo = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)period);
                    lastDepreAndAmort = (FaDepreAndAmortInfo)periodDeroreAmortMap.get(String.valueOf(lasPeriodInfo.getNumber()));
                    BigDecimal lastAcumDepreAmt = BigDecimal.ZERO;
                    BigDecimal initRightOfUseAsset = BigDecimal.ZERO;
                    if (lastDepreAndAmort != null) {
                        lastAcumDepreAmt = lastDepreAndAmort.getAcumDepreAmt();
                    }
                    initRightOfUseAsset = billInfo.getFirstPayTime().compareTo(billInfo.getBeginDate()) >= 0 ? entry.get(0).getInitRightOfUseAsset() : entry.get(1).getInitRightOfUseAsset();
                    BigDecimal lastMonthlyDepreAmt = initRightOfUseAsset.subtract(lastAcumDepreAmt);
                    depreAndAmort.setMonthlyDepreAmt(lastMonthlyDepreAmt);
                }
                for (FaDepreAndAmortInfo depreAndAmort : periodDeroreAmortMap.values()) {
                    FaDepreAndAmortFactory.getLocalInstance(ctx).save((CoreBaseInfo)depreAndAmort);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _calcMonthDepreAndAmort(Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = this.getCurCompany(ctx);
        PeriodInfo curPeriod = this.getCurPeriod(ctx, company);
        if (curPeriod.isIsAdjustPeriod()) {
            throw new EASBizException(new NumericExceptionSubItem("001", EASResource.getString((String)RES_PATH, (String)"Not_Need_Calc_In_Adjust_Period")));
        }
        this.checkNeedCalcLeaseInBillExists(ctx, curPeriod, company);
        String tempTableName = null;
        try {
            tempTableName = this.createTempTable(ctx);
            this.calcMonthDepreAndAmort(ctx, FaLiabilitiesCvMethodEnum.DAY, curPeriod, company, tempTableName);
            this.calcMonthDepreAndAmort(ctx, FaLiabilitiesCvMethodEnum.PERIOD, curPeriod, company, tempTableName);
            this.insertCalcResult(ctx, tempTableName, curPeriod, company);
        }
        finally {
            if (tempTableName != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
            }
        }
        for (String str : leaseInIdSetForTerminateDep) {
            leaseInIdSet.remove(str);
        }
        FaTerminateBillFactory.getLocalInstance(ctx).calcNewDepreAndAmortForOthers(leaseInIdSet);
    }

    private void checkAudited(Context ctx, PeriodInfo curPeriod, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        try {
            StringBuilder ckAuditedSQL = new StringBuilder();
            ckAuditedSQL.append("SELECT 1 FROM T_FA_FaDepreAndAmort WHERE FPeriodID = ? AND FCheckedStatus = 2 AND FCompanyID = ?");
            IRowSet ckAuditedRs = DbUtil.executeQuery((Context)ctx, (String)ckAuditedSQL.toString(), (Object[])new Object[]{curPeriod.getId().toString(), company.getId().toString()});
            if (ckAuditedRs != null && ckAuditedRs.next()) {
                throw new EASBizException(new NumericExceptionSubItem("002", EASResource.getString((String)RES_PATH, (String)"Exists_Audited_DepreAndAmort_Record")));
            }
        }
        catch (SQLException e) {
            throw new EASBizException(new NumericExceptionSubItem("003", e.getMessage()));
        }
    }

    private void checkVouchered(Context ctx, PeriodInfo curPeriod, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        try {
            StringBuilder ckVoucheredSQL = new StringBuilder();
            ckVoucheredSQL.append("SELECT 1 FROM T_FA_FaDepreAndAmort WHERE FPeriodID = ? AND FiVouchered = 1 AND FCompanyID = ?");
            IRowSet ckVoucheredRs = DbUtil.executeQuery((Context)ctx, (String)ckVoucheredSQL.toString(), (Object[])new Object[]{curPeriod.getId().toString(), company.getId().toString()});
            if (ckVoucheredRs.next()) {
                throw new EASBizException(new NumericExceptionSubItem("004", EASResource.getString((String)RES_PATH, (String)"Exists_Vouchered_DepreAndAmort_Record")));
            }
        }
        catch (SQLException e) {
            throw new EASBizException(new NumericExceptionSubItem("006", e.getMessage()));
        }
    }

    private void checkNeedCalcLeaseInBillExists(Context ctx, PeriodInfo curPeriod, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        try {
            leaseInIdSet.clear();
            leaseInIdSetForTerminateDep.clear();
            deleteTerminateDepData.clear();
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT lease.FID leaseInID, lease.FBizStatus leaseBizStatus, lease.FTerminatedType leaseTerminatedType, \r\n");
            sql.append("CASE WHEN contractcat.FDepreciationPolicyID is null THEN 0 ELSE depreciationPolicy.FStartDeprTime END AS startDeprTime \r\n");
            sql.append("FROM T_FA_FALEASEINBILLNEW lease \r\n");
            sql.append("LEFT JOIN T_FA_FAAMORTIZEDCOSTRPT rpt ON lease.FID = rpt.FLeaseInBillID \r\n");
            sql.append("LEFT JOIN T_FA_FAAMORTIZEDCOSTRPTENTRY rptEntry ON rptEntry.FAmortizedCostRptID = rpt.FID \r\n");
            sql.append("LEFT JOIN T_FA_FaTerminateBillEntry tme ON lease.FID = tme.FLeaseInBillID \r\n");
            sql.append("LEFT JOIN T_FA_FaTerminateBill tm ON tme.FBillID = tm.FID \r\n");
            sql.append("LEFT JOIN ").append("T_FA_FAContractCat contractcat ON lease.FContractCatID = contractcat.FID \r\n");
            sql.append("LEFT JOIN ").append("T_FA_FaLeaseDepreciationPolicy depreciationPolicy ON contractcat.FDepreciationPolicyID = depreciationPolicy.FID \r\n");
            sql.append("LEFT JOIN ").append("T_BD_PERIOD period ON period.FID = lease.FPERIODID \r\n");
            sql.append("WHERE ");
            sql.append("lease.FID NOT IN (SELECT FLeaseInBillID FROM T_Fa_FaDepreAndAmort WHERE FPeriodID = ? AND FCompanyId = ?) \r\n");
            sql.append("AND lease.FCompanyID = ? \r\n");
            sql.append("AND lease.FCheckedStatus = 2 \r\n");
            sql.append("\t\tAND (lease.FBizStatus <> 5 OR (lease.FBizStatus = 5 AND tm.FPeriodID = ? AND lease.FTerminatedType <> '3' AND lease.FTerminatedType <> '2')) \r\n");
            sql.append("AND (lease.FBizStatus <> 7) \r\n");
            sql.append("AND (lease.FBizStatus <> 11) \r\n");
            sql.append("AND (lease.FSourceType <> 3 OR (lease.FSourceType = 3 AND period.FNumber <= " + curPeriod.getNumber() + ")) \r\n");
            sql.append("AND lease.FIsExempt = 0 \r\n");
            sql.append("AND rptEntry.FDate >= ?  \r\n");
            sql.append("AND rptEntry.FDate <= ? \r\n");
            String companyId = company.getId().toString();
            String curPeriodId = curPeriod.getId().toString();
            Timestamp beginTime = new Timestamp(curPeriod.getBeginDate().getTime());
            Timestamp endTime = curPeriod.getEndDate();
            IRowSet needCalcRs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{curPeriodId, companyId, companyId, curPeriodId, beginTime, endTime});
            int count = 0;
            while (needCalcRs.next()) {
                ++count;
                if (needCalcRs.getInt("leaseBizStatus") != 5) continue;
                if (needCalcRs.getInt("leaseTerminatedType") != 3) {
                    leaseInIdSet.add(needCalcRs.getString("leaseInID"));
                }
                if (needCalcRs.getInt("startDeprTime") == 1) {
                    leaseInIdSetForTerminateDep.add(needCalcRs.getString("leaseInID"));
                }
                if (needCalcRs.getInt("leaseTerminatedType") != 3 || needCalcRs.getInt("startDeprTime") == 1) continue;
                deleteTerminateDepData.add(needCalcRs.getString("leaseInID"));
                --count;
            }
            if (count == 0) {
                throw new EASBizException(new NumericExceptionSubItem("007", EASResource.getString((String)RES_PATH, (String)"Need_Calc_LeaseInBill_Not_Exists")));
            }
        }
        catch (SQLException e) {
            throw new EASBizException(new NumericExceptionSubItem("008", e.getMessage()));
        }
    }

    private String createTempTable(Context ctx) throws BOSException {
        String tempTableName = null;
        StringBuilder tempTableSQL = new StringBuilder();
        tempTableSQL.append("CREATE TABLE T_Temp_DepreAndAmort(");
        tempTableSQL.append("\tt1_leaseInID  VARCHAR(44), initialAsset NUMERIC(19,8) DEFAULT 0, initialLiability NUMERIC(19,8) DEFAULT 0, \r\n");
        tempTableSQL.append("\tendDate DateTime, maxPPDate DateTime, iROUA NUMERIC(19,8) DEFAULT 0, iUCFC NUMERIC(19,8) DEFAULT 0, \r\n");
        tempTableSQL.append("\tmaxMonthDate DateTime, accDep NUMERIC(19,8) DEFAULT 0, accIP NUMERIC(19,8) DEFAULT 0, preMaxMonthDate DateTime, \r\n");
        tempTableSQL.append("\tpreAccDep NUMERIC(19,8) DEFAULT 0, preAccIP NUMERIC(19,8) DEFAULT 0, monthDep NUMERIC(19,8) DEFAULT 0, monthIP NUMERIC(19,8) DEFAULT 0) \r\n");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(tempTableSQL.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    private void calcMonthDepreAndAmort(Context ctx, FaLiabilitiesCvMethodEnum cvMethod, PeriodInfo curPeriod, CompanyOrgUnitInfo company, String tempTableName) throws EASBizException, BOSException {
        StringBuilder calcSQL = new StringBuilder();
        calcSQL.append("INSERT INTO ");
        calcSQL.append(tempTableName);
        calcSQL.append("\r\n");
        calcSQL.append("\tSELECT \r\n");
        calcSQL.append("\t\tt1.leaseInID t1_leaseInID, t1.initialAsset, t1.initialLiability, t1.endDate,  \r\n");
        calcSQL.append("\t\tt1.maxPPDate, t2.iROUA, t2.iUCFC, t3.maxMonthDate, t3.accDep, t3.accIP, \r\n");
        calcSQL.append("\t\tt4.preMaxMonthDate, t4.preAccDep, t4.preAccIP, \r\n");
        if (cvMethod == FaLiabilitiesCvMethodEnum.DAY) {
            calcSQL.append("\tt3.monthDep monthDep, \r\n");
            calcSQL.append("\tt3.monthIP monthIP \r\n");
        }
        if (cvMethod == FaLiabilitiesCvMethodEnum.PERIOD) {
            calcSQL.append("\t\t\tCASE WHEN TO_NUMBER(YEAR(t1.endDate) * 100 + MONTH(t1.endDate)) = TO_NUMBER(YEAR(t3.maxMonthDate) * 100 + MONTH(t3.maxMonthDate)) \r\n");
            calcSQL.append("\t\t\t\tTHEN t2.iROUA - t4.preAccDep ELSE t3.monthDep END monthDep, \r\n");
            calcSQL.append("\t\t\tCASE WHEN TO_NUMBER(YEAR(t1.maxPPDate) * 100 + MONTH(t1.maxPPDate)) = TO_NUMBER(YEAR(t3.maxMonthDate) * 100 + MONTH(t3.maxMonthDate)) \r\n");
            calcSQL.append("\t\t\t\tTHEN t2.iUCFC - t4.preAccIP ELSE t3.monthIP END monthIP \r\n");
        }
        calcSQL.append("\tFROM ( \r\n");
        calcSQL.append("\t\tSELECT \r\n");
        calcSQL.append("\t\t\tlease.FID leaseInID, lease.FInitialAsset initialAsset, lease.FInitialLiability initialLiability, \r\n");
        calcSQL.append("\t\t\tlease.FEndDate endDate, MAX(pp.FPayDate) maxPPDate \r\n");
        calcSQL.append("\t\tFROM T_FA_FALEASEINBILLNEW lease \r\n");
        calcSQL.append("\t\tLEFT JOIN T_FA_FAPAYMENTPLANNEW pp ON lease.FID = pp.FHeadID \r\n");
        calcSQL.append("\t\tLEFT JOIN T_FA_FaTerminateBillEntry tme ON tme.FLeaseInBillID = lease.FID \r\n");
        calcSQL.append("\t\tLEFT JOIN T_FA_FaTerminateBill tm ON tme.FBillID = tm.FID \r\n");
        calcSQL.append("\t\tLEFT JOIN T_BD_PERIOD period ON period.FID = lease.FPERIODID \r\n");
        calcSQL.append("\t\tWHERE  \r\n");
        calcSQL.append("\t\t\tlease.FID NOT IN (SELECT FLeaseInBillID FROM T_Fa_FaDepreAndAmort WHERE FPeriodID = ? AND FCompanyId = ?) \r\n");
        calcSQL.append("\t\tAND lease.FCompanyID = ? \r\n");
        calcSQL.append("\t\tAND lease.FCheckedStatus = 2 \r\n");
        calcSQL.append("\t\tAND lease.FIsExempt = 0 \r\n");
        calcSQL.append("\t\tAND (lease.FBizStatus <> 5 OR (lease.FBizStatus = 5 AND tm.FPeriodID = ? AND lease.FTerminatedType <> '3' AND lease.FTerminatedType <> '2')) \r\n");
        calcSQL.append("AND (lease.FBizStatus <> 7) \r\n");
        calcSQL.append("AND (lease.FBizStatus <> 11) \r\n");
        calcSQL.append("AND (lease.FSourceType <> 3 OR (lease.FSourceType = 3 AND period.FNumber <= " + curPeriod.getNumber() + ")) \r\n");
        if (cvMethod == FaLiabilitiesCvMethodEnum.DAY) {
            calcSQL.append("\t\tAND (lease.FLiabilitiesCvMethod = 1 OR lease.FLiabilitiesCvMethod IS NULL) \r\n");
        }
        if (cvMethod == FaLiabilitiesCvMethodEnum.PERIOD) {
            calcSQL.append("\t\tAND lease.FLiabilitiesCvMethod = 2 \r\n");
        }
        calcSQL.append("\t\tGROUP BY lease.FID, lease.FInitialAsset, lease.FInitialLiability, lease.FEndDate) t1 \r\n");
        calcSQL.append("\tLEFT JOIN ( \r\n");
        calcSQL.append("\t\tSELECT \r\n");
        calcSQL.append("\t\t\tlease.FID leaseInID, MAX(rptEntry.FInitRightOfUseAsset) iROUA, MAX(rptEntry.FInitUnCfmFncCost) iUCFC \r\n");
        calcSQL.append("\t\tFROM T_FA_FALEASEINBILLNEW lease \r\n");
        calcSQL.append("\t\tLEFT JOIN T_FA_FAAMORTIZEDCOSTRPT rpt ON lease.FID = rpt.FLeaseInBillID \r\n");
        calcSQL.append("\t\tLEFT JOIN T_FA_FAAMORTIZEDCOSTRPTENTRY rptEntry ON rptEntry.FAmortizedCostRptID = rpt.FID \r\n");
        calcSQL.append("\t\tLEFT JOIN T_FA_FaTerminateBillEntry tme ON tme.FLeaseInBillID = lease.FID \r\n");
        calcSQL.append("\t\tLEFT JOIN T_FA_FaTerminateBill tm ON tme.FBillID = tm.FID \r\n");
        calcSQL.append("\t\tLEFT JOIN T_BD_PERIOD period ON period.FID = lease.FPERIODID \r\n");
        calcSQL.append("\t\tWHERE lease.FCheckedStatus = 2 \r\n");
        calcSQL.append("\t\tAND lease.FCompanyID = ? \r\n");
        calcSQL.append("\t\tAND lease.FIsExempt = 0 \r\n");
        calcSQL.append("\t\tAND (lease.FBizStatus <> 5 OR (lease.FBizStatus = 5 AND tm.FPeriodID = ? AND lease.FTerminatedType <> '3' AND lease.FTerminatedType <> '2')) \r\n");
        calcSQL.append("AND (lease.FBizStatus <> 7) \r\n");
        calcSQL.append("AND (lease.FBizStatus <> 11) \r\n");
        calcSQL.append("AND (lease.FSourceType <> 3 OR (lease.FSourceType = 3 AND period.FNumber <= " + curPeriod.getNumber() + ")) \r\n");
        if (cvMethod == FaLiabilitiesCvMethodEnum.DAY) {
            calcSQL.append("\t\tAND (lease.FLiabilitiesCvMethod = 1 OR lease.FLiabilitiesCvMethod IS NULL) \r\n");
        }
        if (cvMethod == FaLiabilitiesCvMethodEnum.PERIOD) {
            calcSQL.append("\t\tAND lease.FLiabilitiesCvMethod = 2 \r\n");
        }
        calcSQL.append("\t\tGROUP BY lease.FID, lease.FInitialAsset, lease.FInitialLiability, lease.FEndDate) t2 ON t2.leaseInID = t1.leaseInID \r\n");
        calcSQL.append("\tINNER JOIN ( \r\n");
        calcSQL.append("\t\tSELECT \r\n");
        calcSQL.append("\t\t\tlease.FID leaseInID, MAX(rptEntry.FDate) maxMonthDate, SUM(rptEntry.FCurDepreciation) monthDep, \r\n");
        calcSQL.append("\t\t\tSUM(rptEntry.FCurInterestPayment) monthIP, MAX(rptEntry.FCURACCDEPRECIATION) accDep, \r\n");
        calcSQL.append("\t\t\tMAX(rptEntry.FCurAccInterestPayment) accIP \r\n");
        calcSQL.append("\t\tFROM T_FA_FALEASEINBILLNEW lease \r\n");
        calcSQL.append("\t\tLEFT JOIN T_FA_FAAMORTIZEDCOSTRPT rpt ON lease.FID = rpt.FLeaseInBillID \r\n");
        calcSQL.append("\t\tLEFT JOIN T_FA_FAAMORTIZEDCOSTRPTENTRY rptEntry ON rptEntry.FAmortizedCostRptID = rpt.FID \r\n");
        calcSQL.append("\t\tLEFT JOIN T_FA_FaTerminateBillEntry tme ON lease.FID = tme.FLeaseInBillID \r\n");
        calcSQL.append("\t\tLEFT JOIN T_FA_FaTerminateBill tm ON tme.FBillID = tm.FID \r\n");
        calcSQL.append("\t\tLEFT JOIN T_BD_PERIOD period ON period.FID = lease.FPERIODID \r\n");
        calcSQL.append("\t\tWHERE \r\n");
        calcSQL.append("\t\t\tlease.FID NOT IN (SELECT FLeaseInBillID FROM T_Fa_FaDepreAndAmort WHERE FPeriodID = ? AND FCompanyId = ?) \r\n");
        calcSQL.append("\t\tAND lease.FCompanyID = ? \r\n");
        calcSQL.append("\t\tAND lease.FCheckedStatus = 2 \r\n");
        calcSQL.append("\t\tAND lease.FIsExempt = 0 \r\n");
        calcSQL.append("\t\tAND (lease.FBizStatus <> 5 OR (lease.FBizStatus = 5 AND tm.FPeriodID = ? AND lease.FTerminatedType <> '3' AND lease.FTerminatedType <> '2')) \r\n");
        calcSQL.append("AND (lease.FBizStatus <> 7) \r\n");
        calcSQL.append("AND (lease.FBizStatus <> 11) \r\n");
        calcSQL.append("AND (lease.FSourceType <> 3 OR (lease.FSourceType = 3 AND period.FNumber <= " + curPeriod.getNumber() + ")) \r\n");
        if (cvMethod == FaLiabilitiesCvMethodEnum.DAY) {
            calcSQL.append("\t\tAND (lease.FLiabilitiesCvMethod = 1 OR lease.FLiabilitiesCvMethod IS NULL) \r\n");
        }
        if (cvMethod == FaLiabilitiesCvMethodEnum.PERIOD) {
            calcSQL.append("\t\tAND lease.FLiabilitiesCvMethod = 2 \r\n");
        }
        calcSQL.append("\t\tAND rptEntry.FDate >= ?  \r\n");
        calcSQL.append("\t\tAND rptEntry.FDate <= ? \r\n");
        calcSQL.append("\t\tGROUP BY lease.FID \r\n");
        calcSQL.append("\t\t) t3 ON t2.leaseInID = t3.leaseInID \r\n");
        calcSQL.append("\tLEFT JOIN ( \r\n");
        calcSQL.append("\t\tSELECT \r\n");
        calcSQL.append("\t\t\tlease.FID leaseInID, MAX(rptEntry.FDate) preMaxMonthDate, MAX(rptEntry.FCURACCDEPRECIATION) preAccDep, \r\n");
        calcSQL.append("\t\t\tMAX(rptEntry.FCurAccInterestPayment) preAccIP \r\n");
        calcSQL.append("\t\tFROM T_FA_FAAMORTIZEDCOSTRPT rpt \r\n");
        calcSQL.append("\t\tLEFT JOIN T_FA_FAAMORTIZEDCOSTRPTENTRY rptEntry ON rptEntry.FAmortizedCostRptID = rpt.FID \r\n");
        calcSQL.append("\t\tLEFT JOIN T_FA_FALEASEINBILLNEW lease ON lease.FID = rpt.FLeaseInBillID \r\n");
        calcSQL.append("\t\tWHERE rptEntry.FDate >= ? AND rptEntry.FDate <= ? \r\n");
        calcSQL.append("\t\tGROUP BY lease.FID \r\n");
        calcSQL.append("\t\t) t4 ON t3.leaseInID = t4.leaseInID \r\n");
        String curPeriodId = curPeriod.getId().toString();
        String companyId = company.getId().toString();
        Timestamp beginTime = new Timestamp(curPeriod.getBeginDate().getTime());
        Timestamp endTime = curPeriod.getEndDate();
        PeriodInfo prePeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)curPeriod);
        Timestamp preBeginTime = null;
        Timestamp preEndTime = null;
        if (prePeriod != null) {
            preBeginTime = new Timestamp(prePeriod.getBeginDate().getTime());
            preEndTime = prePeriod.getEndDate();
        }
        Object[] calcParams = new Object[]{curPeriodId, companyId, companyId, curPeriodId, companyId, curPeriodId, curPeriodId, companyId, companyId, curPeriodId, beginTime, endTime, preBeginTime, preEndTime};
        DbUtil.execute((Context)ctx, (String)calcSQL.toString(), (Object[])calcParams);
    }

    private void insertCalcResult(Context ctx, String tempTableName, PeriodInfo curPeriod, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        StringBuilder insertSQL = new StringBuilder();
        insertSQL.append("INSERT INTO T_FA_FaDepreAndAmort ( \r\n");
        insertSQL.append("\tFID, FLeaseInBillID, FBeginAssets, FBeginLiabilities, FMonthlyDepreAmt, FAcumDepreAmt, \r\n");
        insertSQL.append("\tFMonthlyInterestExpe, FAcumInterestExpe, FPeriodID, FCompanyID, FCreatorID, \r\n");
        insertSQL.append("\tFCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FiVouchered) \r\n");
        insertSQL.append("(SELECT \r\n");
        insertSQL.append("\tnewBosId('E139C643') FID, t1_leaseInID FLeaseInBillID, initialAsset FBeginAssets, initialLiability FBeginLiabilities, \r\n");
        insertSQL.append("\tmonthDep FMonthlyDepreAmt, accDep FAcumDepreAmt, monthIP FMonthlyInterestExpe, accIP FAcumInterestExpe, \r\n");
        insertSQL.append("\t? FPeriodID, ? FCompanyID, ? FCreatorID, ? FCreateTime, ? FLastUpdateUserID, ? FLastUpdateTime, ? FControlUnitID, 0 FiVouchered \r\n");
        insertSQL.append("FROM \r\n");
        insertSQL.append(tempTableName);
        insertSQL.append(") \r\n");
        String curPeriodId = curPeriod.getId().toString();
        String companyId = company.getId().toString();
        Timestamp now = new Timestamp(System.currentTimeMillis());
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String cuId = company.getCU().getId().toString();
        Object[] params = new Object[]{curPeriodId, companyId, userId, now, userId, now, cuId};
        DbUtil.execute((Context)ctx, (String)insertSQL.toString(), (Object[])params);
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT ").append(" t2.FID depId, t1_leaseInID FLeaseInBillID \r\n");
        sql.append(" FROM ").append(tempTableName).append(" t1 \r\n");
        sql.append(" inner join T_FA_FaDepreAndAmort t2 on t1.t1_leaseInID = t2.FLeaseInBillID \r\n");
        sql.append(" where FPERIODID = '" + curPeriodId + "' and FCompanyID = '" + companyId + "' \r\n");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        FaLeaseNewDepCostSharingFactory.getLocalInstance(ctx).autoSaveFaLeaseNewDepCostSharing(rowSet, null);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkVouchered(ctx, pk);
        this.checkTerminated(ctx, pk);
        super._delete(ctx, pk);
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkAudited(ctx, pk);
        String auditSQL = "UPDATE T_FA_FaDepreAndAmort SET FCheckedStatus = 2 WHERE FID = ?";
        DbUtil.execute((Context)ctx, (String)auditSQL.toString(), (Object[])new Object[]{pk.toString()});
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkVouchered(ctx, pk);
        String unAuditSQL = "UPDATE T_FA_FaDepreAndAmort SET FCheckedStatus = 1 WHERE FID = ?";
        DbUtil.execute((Context)ctx, (String)unAuditSQL.toString(), (Object[])new Object[]{pk.toString()});
    }

    protected DAPTransformResult _generateVoucher(Context ctx, IObjectCollection sourceBillCollection, IObjectPK botMappingPK) throws BOSException, EASBizException {
        return super._generateVoucher(ctx, sourceBillCollection, botMappingPK);
    }

    protected DAPTransformResult _generateVoucher(Context ctx, IObjectPK[] sourceBillPkList, IObjectPK botMappingPK, SelectorItemCollection botpSelectors) throws BOSException, EASBizException {
        for (IObjectPK iObjectPK : sourceBillPkList) {
            if (FaDepreAndAmortFactory.getLocalInstance(ctx).exists(iObjectPK)) continue;
            throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"45_FaDepreAndAmortControllerBean", (Locale)ctx.getLocale())));
        }
        return super._generateVoucher(ctx, sourceBillPkList, botMappingPK, botpSelectors);
    }

    private void checkTerminated(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            StringBuilder ckTerminatedSQL = new StringBuilder();
            ckTerminatedSQL.append("SELECT 1 FROM T_Fa_FaTerminateBill tm \r\n");
            ckTerminatedSQL.append("LEFT JOIN T_Fa_FaTerminateBillEntry tmEntry ON tm.FID = tmEntry.FBillID \r\n");
            ckTerminatedSQL.append("LEFT JOIN T_Fa_FaDepreAndAmort da ON da.FLeaseInBillID = tmEntry.FLeaseInBillID \r\n");
            ckTerminatedSQL.append("WHERE da.FID = ? AND da.FPeriodID = ? AND tm.FCheckedStatus = 2 \r\n");
            CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
            PeriodInfo curPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)company);
            IRowSet ckTerminatedRs = DbUtil.executeQuery((Context)ctx, (String)ckTerminatedSQL.toString(), (Object[])new String[]{pk.toString(), curPeriod.getId().toString()});
            if (ckTerminatedRs != null && ckTerminatedRs.next()) {
                throw new EASBizException(new NumericExceptionSubItem("009", EASResource.getString((String)RES_PATH, (String)"LeaseInBill_Terminated_Can_Not_Delete")));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void checkTerminated(Context ctx, String leaseInBillID) throws BOSException, EASBizException {
        try {
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT 1 FROM T_Fa_FaTerminateBill tm \r\n");
            sql.append("LEFT JOIN T_Fa_FaTerminateBillEntry tmEntry ON tm.FID = tmEntry.FBillID \r\n");
            sql.append("LEFT JOIN T_Fa_FaDepreAndAmort da ON da.FLeaseInBillID = tmEntry.FLeaseInBillID \r\n");
            sql.append("WHERE da.FLeaseInBillID = ? AND da.FPeriodID = ? AND tm.FCheckedStatus = 2 \r\n");
            CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
            PeriodInfo curPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)company);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{leaseInBillID, curPeriod.getId().toString()});
            if (rs != null && rs.next()) {
                throw new EASBizException(new NumericExceptionSubItem("009", EASResource.getString((String)RES_PATH, (String)"LeaseInBill_Terminated_Can_Not_Delete")));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void checkAudited(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            String ckAuditedSQL = "SELECT 1 FROM T_FA_FaDepreAndAmort WHERE FID = ? AND FCheckedStatus = 2";
            IRowSet ckAuditedRs = DbUtil.executeQuery((Context)ctx, (String)ckAuditedSQL, (Object[])new Object[]{pk.toString()});
            if (ckAuditedRs != null && ckAuditedRs.next()) {
                throw new EASBizException(new NumericExceptionSubItem("009", EASResource.getString((String)RES_PATH, (String)"Exists_Audited_DepreAndAmort_Record")));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void checkIsInCurPeriod(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            PeriodInfo curPeriod = this.getCurPeriod(ctx);
            String sql = "SELECT 1 FROM T_FA_FaDepreAndAmort WHERE FID = ? AND FPeriodID = ?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString(), curPeriod.getId().toString()});
            if (rs == null || !rs.next()) {
                throw new EASBizException(new NumericExceptionSubItem("011", EASResource.getString((String)RES_PATH, (String)"Not_In_CurPeriod_Can_Not_Delete")));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void checkVouchered(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            String ckVoucheredSQL = "SELECT 1 FROM T_FA_FaDepreAndAmort WHERE FID = ? AND FiVouchered = 1";
            IRowSet ckVoucheredRs = DbUtil.executeQuery((Context)ctx, (String)ckVoucheredSQL, (Object[])new Object[]{pk.toString()});
            if (ckVoucheredRs != null && ckVoucheredRs.next()) {
                throw new EASBizException(new NumericExceptionSubItem("012", EASResource.getString((String)RES_PATH, (String)"Exists_Vouchered_DepreAndAmort_Record")));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void checkVouchered(Context ctx, String leaseInBillID) throws BOSException, EASBizException {
        try {
            String sql = "SELECT 1 FROM T_FA_FaDepreAndAmort WHERE FLeaseInBillID = ? AND FiVouchered = 1";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{leaseInBillID});
            if (rs != null && rs.next()) {
                throw new EASBizException(new NumericExceptionSubItem("012", EASResource.getString((String)RES_PATH, (String)"Exists_Vouchered_DepreAndAmort_Record")));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        VoucherInfo voucher = this.lookVoucherInfo(ctx, bOTRelationInfo);
        if (voucher != null && voucher.getId() != null) {
            if (bOTBillOperStateEnum == BOTBillOperStateEnum.ADDNEW) {
                DbUtil.execute((Context)ctx, (String)("update t_fa_FaDepreAndAmort set FiVouchered = 1 ,FVoucherid='" + voucher.getId() + "',FVoucherNumber='" + voucher.getNumber() + "',FVoucherTypeID ='" + voucher.getVoucherType().getId().toString() + "'  where fid = ?"), (Object[])new Object[]{srcBillVO.get("id").toString()});
            } else if (bOTBillOperStateEnum == BOTBillOperStateEnum.EDIT) {
                DbUtil.execute((Context)ctx, (String)("update t_fa_FaDepreAndAmort set FVoucherNumber = '" + voucher.getNumber() + "' ,FVoucherTypeID ='" + voucher.getVoucherType().getId().toString() + "' where fid = ?"), (Object[])new Object[]{srcBillVO.get("id").toString()});
            }
        } else {
            super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
        }
        if (new VoucherInfo().getBOSType().toString().equals(bOTRelationInfo.get("destentityid")) && bOTBillOperStateEnum == BOTBillOperStateEnum.DELETE) {
            DbUtil.execute((Context)ctx, (String)"update t_fa_FaDepreAndAmort set FiVouchered = 0 , FVoucherid=null, FVoucherNumber=null, FVoucherTypeID = null where fid = ?", (Object[])new Object[]{srcBillVO.get("id").toString()});
        }
    }

    private VoucherInfo lookVoucherInfo(Context ctx, IObjectValue bOTRelationInfo) throws BOSException {
        Iterator iter;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("voucherAbstract"));
        sic.add(new SelectorItemInfo("voucherType.id"));
        EntityViewInfo entityView = new EntityViewInfo();
        entityView.getSelector().addObjectCollection((IObjectCollection)sic);
        FilterInfo filter = new FilterInfo();
        if (((BOTRelationInfo)bOTRelationInfo).getDestObjectID() == null) {
            return null;
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)((BOTRelationInfo)bOTRelationInfo).getDestObjectID()));
        entityView.setFilter(filter);
        IVoucher voucher = VoucherFactory.getLocalInstance((Context)ctx);
        VoucherCollection voucherCollection = voucher.getVoucherCollection(entityView);
        if (voucherCollection.size() > 0 && (iter = voucherCollection.iterator()).hasNext()) {
            VoucherInfo voucherInfo = (VoucherInfo)iter.next();
            return voucherInfo;
        }
        return null;
    }

    private PeriodInfo getCurPeriod(Context ctx) throws EASBizException, BOSException {
        return this.getCurPeriod(ctx, this.getCurCompany(ctx));
    }

    private PeriodInfo getCurPeriod(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        return SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)company);
    }

    private CompanyOrgUnitInfo getCurCompany(Context ctx) {
        return ContextUtil.getCurrentFIUnit((Context)ctx);
    }

    @Override
    public CoreBillBaseCollection getCoreBillBaseCollection(Context ctx, EntityViewInfo view) throws BOSException {
        CoreBillBaseCollection collection = (CoreBillBaseCollection)this.getFaDepreAndAmortCollection(ctx, view).cast(CoreBillBaseCollection.class);
        if (view.getSelector().toString().contains("faLeaseDepCostSharingEntry")) {
            for (int n = 0; n < collection.size(); ++n) {
                FaDepreAndAmortInfo faDepreAndAmortInfo = (FaDepreAndAmortInfo)collection.get(n);
                if (faDepreAndAmortInfo.getFaLeaseDepCostSharingEntry().get(0) == null) continue;
                String faDepId = faDepreAndAmortInfo.getFaLeaseDepCostSharingEntry().get(0).getId().toString();
                FaLeaseNewDepCostSharingInfo faLeaseDepCostSharingInfo = null;
                try {
                    faLeaseDepCostSharingInfo = FaLeaseNewDepCostSharingFactory.getLocalInstance(ctx).getFaLeaseNewDepCostSharingInfo((IObjectPK)new ObjectUuidPK(faDepId));
                }
                catch (EASBizException e) {
                    throw new BOSException((Throwable)e);
                }
                faDepreAndAmortInfo.getFaLeaseDepCostSharingEntry().set(0, faLeaseDepCostSharingInfo);
            }
        }
        return collection;
    }

    protected void invokeServiceAfter(ServiceContext svcCtx) throws BOSException {
        RPCMethodMappingUtils.invokeRPCMethodEventListener(svcCtx, new FaDepreAndAmortCollection());
        super.invokeServiceAfter(svcCtx);
    }
}

