/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.nlm.FaNewLeasePolicyCollection;
import com.kingdee.eas.fi.nlm.FaNewLeasePolicyInfo;
import com.kingdee.eas.fi.nlm.app.AbstractFaNewLeasePolicyControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.log4j.Logger;

public class FaNewLeasePolicyControllerBean
extends AbstractFaNewLeasePolicyControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.nlm.app.FaNewLeasePolicyControllerBean");
    public static final String RESOURCE_POLICY = "com.kingdee.eas.fi.nlm.FaNewLeasePolicyResource";

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        FaNewLeasePolicyInfo policy;
        BOSUuid companyId = ((FaNewLeasePolicyInfo)model).getCompany().getId();
        if (companyId == null) {
            companyId = ContextUtil.getCurrentOrgUnit((Context)ctx).getId();
        }
        if ((policy = this.queryEnabledNewLeasePolicy(ctx, companyId.toString())) != null) {
            throw new EASBizException(new NumericExceptionSubItem("001", ResourceBase.getString((String)RESOURCE_POLICY, (String)"Has_Enabled", (Locale)ctx.getOriginLocale(), (Object[])new String[]{policy.getNumber()})));
        }
        super._cancelCancel(ctx, pk, model);
    }

    @Override
    protected IObjectValue _getEnabledNewLeasePolicy(Context ctx, String orgUnitId) throws BOSException, EASBizException {
        String parentId;
        FaNewLeasePolicyInfo policy = this.queryEnabledNewLeasePolicy(ctx, orgUnitId);
        if (policy != null) {
            return policy;
        }
        String parentSQL = "SELECT FParentID FROM T_ORG_BASEUNIT WHERE FID = ?";
        IRowSet parentRS = DbUtil.executeQuery((Context)ctx, (String)parentSQL, (Object[])new Object[]{orgUnitId});
        try {
            if (parentRS == null || !parentRS.next()) {
                return null;
            }
            parentId = parentRS.getString("FParentID");
            if (parentId == null || "".equals(parentId.trim())) {
                return null;
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return this._getEnabledNewLeasePolicy(ctx, parentId);
    }

    private FaNewLeasePolicyInfo queryEnabledNewLeasePolicy(Context ctx, String orgUnitId) throws BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)orgUnitId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)1, CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(selector);
        view.setFilter(filter);
        FaNewLeasePolicyCollection policyCol = this.getFaNewLeasePolicyCollection(ctx, view);
        if (policyCol != null && policyCol.size() > 0) {
            return policyCol.get(0);
        }
        return null;
    }
}

