/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaBillBaseInfo;
import com.kingdee.eas.fi.fa.manage.FaBillBizProcessor;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.nlm.FaDepreAndAmortFactory;
import com.kingdee.eas.fi.nlm.FaLeaseBizStatusEnum;
import com.kingdee.eas.fi.nlm.FaLeaseInBillEntryNewInfo;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewCollection;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewFactory;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.nlm.FaLeaseSourceTypeEnum;
import com.kingdee.eas.fi.nlm.FaLeaseTypeEnum;
import com.kingdee.eas.fi.nlm.FaNewLeasePolicyFactory;
import com.kingdee.eas.fi.nlm.FaNewLeasePolicyInfo;
import com.kingdee.eas.fi.nlm.FaPaymentPlanNewCollection;
import com.kingdee.eas.fi.nlm.FaTerminateBillEntryCollection;
import com.kingdee.eas.fi.nlm.FaTerminateBillEntryFactory;
import com.kingdee.eas.fi.nlm.FaTerminateBillEntryInfo;
import com.kingdee.eas.fi.nlm.FaTerminateBillFactory;
import com.kingdee.eas.fi.nlm.FaTerminateBillInfo;
import com.kingdee.eas.fi.nlm.FaTerminateException;
import com.kingdee.eas.fi.nlm.FaTerminateMode;
import com.kingdee.eas.fi.nlm.FlCalcTreeCalcTypeEnum;
import com.kingdee.eas.fi.nlm.IFaLeaseInBillNew;
import com.kingdee.eas.fi.nlm.IFaTerminateBill;
import com.kingdee.eas.fi.nlm.app.AbstractFaTerminateBillControllerBean;
import com.kingdee.eas.fi.nlm.app.flenum.TerminateBillForAfterDepEnum;
import com.kingdee.eas.fi.nlm.app.flenum.TerminateBillForBeforeDepEnum;
import com.kingdee.eas.fi.nlm.app.fleventlistener.utils.RPCMethodMappingUtils;
import com.kingdee.eas.fi.nlm.app.prc.AbstractPrcFaManageStrategy;
import com.kingdee.eas.fi.nlm.app.prc.PrcFaCoreManager;
import com.kingdee.eas.fi.nlm.app.prc.PrcFaTerminateBillStrategy;
import com.kingdee.eas.fi.nlm.app.utils.FlLocalUtils;
import com.kingdee.eas.fi.nlm.calctree.CalcTree;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.IBillBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FaTerminateBillControllerBean
extends AbstractFaTerminateBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.nlm.app.FaTerminateBillControllerBean");

    public String getMasterTable() {
        return "T_FA_FaTerminateBill";
    }

    protected void checkBeforeSave(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void checkBeforeSubmit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected AbstractPrcFaManageStrategy getBillStrategy() {
        return new PrcFaTerminateBillStrategy();
    }

    public boolean checkStatusValid(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        return true;
    }

    protected void _saveSelf(Context ctx, IObjectPK pk, FaBillBaseInfo model) throws BOSException, EASBizException {
        model.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        this._save(ctx, pk, (IObjectValue)model);
    }

    protected IObjectPK _saveSelf(Context ctx, FaBillBaseInfo model) throws BOSException, EASBizException {
        IObjectPK retValue;
        FaBillBaseInfo coreBaseInfo = model;
        if (this._isExistPropertyName(ctx, (CoreBaseInfo)coreBaseInfo, "effectedStatus")) {
            coreBaseInfo.setInt("effectedStatus", 1);
        }
        ServiceStateManager.getInstance().enableNextCallServices();
        if (coreBaseInfo.getId() != null && this._exists(ctx, (IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
            retValue = new ObjectUuidPK(coreBaseInfo.getId());
            super.update(ctx, retValue, (CoreBaseInfo)coreBaseInfo);
        } else {
            retValue = super.addnew(ctx, (CoreBaseInfo)coreBaseInfo);
        }
        return retValue;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String pk = model.get("id") == null ? null : model.get("id").toString();
        FaTerminateBillInfo bill = (FaTerminateBillInfo)model;
        FaTerminateBillEntryCollection entry = bill.getEntry();
        FaBillBizProcessor.lockTable((Context)ctx, (String)pk);
        this.checkBeforeSave(ctx, model);
        this.dealDeleteEntry(ctx, pk, entry);
        if (entry != null && entry.size() > 0) {
            this.dealLeaseBill(ctx, entry, 4);
        }
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(this.getBillStrategy());
        FaBillBaseInfo billBaseInfo = (FaBillBaseInfo)model;
        if (billBaseInfo.getBOSUuid("id") != null) {
            prcFaCoreManager.getFaManageStrategy().checkForSave(ctx, (IObjectValue)billBaseInfo);
        }
        return prcFaCoreManager.getFaManageStrategy().saveBill(ctx, model);
    }

    private void dealDeleteEntry(Context ctx, String pk, FaTerminateBillEntryCollection entry) throws BOSException, EASBizException {
        if (pk != null) {
            ArrayList<String> saveLeaseBillIdList = new ArrayList<String>();
            for (int i = 0; i < entry.size(); ++i) {
                saveLeaseBillIdList.add(entry.get(i).getLeaseInBill().getId().toString());
            }
            FaTerminateBillInfo oldBill = this.getFaTerminateBillInfo(ctx, (IObjectPK)new ObjectUuidPK(pk), this.getSelfSelctor());
            if (oldBill != null) {
                FaTerminateBillEntryCollection oldentry = oldBill.getEntry();
                FaTerminateBillEntryCollection deleteEntry = new FaTerminateBillEntryCollection();
                for (int i = 0; i < oldentry.size(); ++i) {
                    FaTerminateBillEntryInfo oldEntry = oldentry.get(i);
                    if (saveLeaseBillIdList.contains(oldEntry.getLeaseInBill().getId().toString())) continue;
                    deleteEntry.add(oldEntry);
                }
                this.dealLeaseBill(ctx, deleteEntry, 1);
            }
        }
    }

    private void dealLeaseBill(Context ctx, FaTerminateBillEntryCollection entry, int status) throws BOSException {
        if (entry == null || entry.size() == 0) {
            return;
        }
        StringBuffer leaseSql = new StringBuffer("update T_FA_FaLeaseInBillNew set fbizstatus = ? where fid in (");
        for (int i = 0; i < entry.size(); ++i) {
            if (i != 0) {
                leaseSql.append(",");
            }
            leaseSql.append("'").append(entry.get(i).getLeaseInBill().getId().toString()).append("'");
        }
        leaseSql.append(")");
        DbUtil.execute((Context)ctx, (String)leaseSql.toString(), (Object[])new Object[]{status});
    }

    private void dealLeaseBillTmrminatedType(Context ctx, FaTerminateBillEntryCollection entry, FaTerminateMode status) throws BOSException {
        if (entry == null || entry.size() == 0) {
            return;
        }
        StringBuffer leaseSql = new StringBuffer("update T_FA_FaLeaseInBillNew set FTerminatedType = ? where fid in (");
        for (int i = 0; i < entry.size(); ++i) {
            if (i != 0) {
                leaseSql.append(",");
            }
            leaseSql.append("'").append(entry.get(i).getLeaseInBill().getId().toString()).append("'");
        }
        leaseSql.append(")");
        DbUtil.execute((Context)ctx, (String)leaseSql.toString(), (Object[])new Object[]{status == null ? null : status.getValue()});
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(this.getBillStrategy());
        FaTerminateBillInfo info = (FaTerminateBillInfo)model;
        info.setPeriod(FlLocalUtils.getFLCurrentPeriod(info.getCompany().getId().toString(), ctx));
        info.setBizDate(DateTimeUtils.truncateDate((java.util.Date)info.getTerminateDate()));
        info.setDeletedStatus(DeletedStatusEnum.NORMAL);
        info.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        info.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        info.setFiVouchered(false);
        info.setHasEffected(true);
        info.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        IFaTerminateBill iLeaseInBillNew = FaTerminateBillFactory.getLocalInstance(ctx);
        prcFaCoreManager.getFaManageStrategy();
        AbstractPrcFaManageStrategy.setBillInfoNumber(ctx, (BillBaseInfo)info, (IBillBase)iLeaseInBillNew);
        CoreBaseInfo coreBaseInfo = (CoreBaseInfo)model;
        FaTerminateBillInfo bill = (FaTerminateBillInfo)model;
        FaTerminateBillEntryCollection entry = bill.getEntry();
        String pk = model.get("id") == null ? null : model.get("id").toString();
        this.dealDeleteEntry(ctx, pk, entry);
        this.dealLeaseBill(ctx, entry, 4);
        if (this._isExistPropertyName(ctx, coreBaseInfo, "effectedStatus")) {
            coreBaseInfo.setInt("effectedStatus", 2);
        }
        ServiceStateManager.getInstance().enableNextCallServices();
        if (coreBaseInfo.getId() != null && this._exists(ctx, (IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
            ObjectUuidPK retValue = new ObjectUuidPK(coreBaseInfo.getId());
            super.update(ctx, (IObjectPK)retValue, coreBaseInfo);
            return retValue;
        }
        IObjectPK retValue = super.addnew(ctx, coreBaseInfo);
        return retValue;
    }

    protected void _deleteSelf(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_FA_FALEASEINBILLNEW SET FBIZSTATUS=3 WHERE FID IN (");
        sql.append("SELECT FLEASEINBILLID FROM T_FA_FATERMINATEBILLENTRY ");
        sql.append("WHERE FLEASEINBILLID IN (SELECT FLEASEINBILLID FROM T_FA_FALEASECHANGEBILLENTRY) ");
        sql.append("AND FBILLID = '");
        sql.append(pk.toString());
        sql.append("')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("UPDATE T_FA_FALEASEINBILLNEW SET FBIZSTATUS=1 WHERE FID IN (");
        sql.append("SELECT FLEASEINBILLID FROM T_FA_FATERMINATEBILLENTRY ");
        sql.append("WHERE FLEASEINBILLID NOT IN (SELECT FLEASEINBILLID FROM T_FA_FALEASECHANGEBILLENTRY) ");
        sql.append("AND FBILLID = '");
        sql.append(pk.toString());
        sql.append("')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        super._deleteSelf(ctx, pk);
    }

    protected void _passAuditSelf(Context ctx, IObjectPK pk, FaBillBaseInfo model) throws BOSException, EASBizException {
        FaTerminateBillInfo billInfo = (FaTerminateBillInfo)model;
        FaTerminateBillEntryCollection entry = billInfo.getEntry();
        PeriodInfo tmPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)ContextUtil.getCurrentFIUnit((Context)ctx));
        FlLocalUtils.checkLeaseChangeGenInFuturePeriod(ctx, (IObjectCollection)entry, tmPeriod);
        FlLocalUtils.checkDeprAndAmortGenInFuturePeriod(ctx, (IObjectCollection)entry, tmPeriod);
        FlLocalUtils.checkRSDownBillGenInFuturePeriod(ctx, (IObjectCollection)entry, tmPeriod);
        this.dealLeaseBill(ctx, entry, 5);
        this.dealLeaseBillTmrminatedType(ctx, entry, billInfo.getTerminateMode());
        boolean isCreateLeaseBill = billInfo.isIsCreateLease();
        this.createLeaseBill(ctx, billInfo);
        StringBuffer _sql = new StringBuffer("update " + this.getMasterTable() + "  set");
        _sql.append(" FCheckedStatus = ?");
        _sql.append(",FAuditorId = ?");
        _sql.append(",FAuditTime = ?");
        _sql.append(",FBizDate = ?");
        _sql.append(" where fid = ?");
        Object[] params = new Object[5];
        java.util.Date date = new java.util.Date();
        long time = date.getTime();
        CompanyOrgUnitInfo company = model.getCompany();
        if (company == null || company.getId() == null) {
            company = (CompanyOrgUnitInfo)this.getValue(ctx, "select company.id where id ='" + pk + "'").get("company");
        }
        params[0] = 2;
        params[1] = ctx.getCaller().toString();
        params[2] = new Timestamp(time);
        params[3] = new Timestamp(FlLocalUtils.getBizDate4Fl(ctx, company.getId().toString()).getTime());
        params[4] = pk.toString();
        DbUtil.execute((Context)ctx, (String)_sql.toString(), (Object[])params);
        java.util.Date tmDate = billInfo.getTerminateDate();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("isExempt");
        IFaLeaseInBillNew iFaLeaseInBillNew = FaLeaseInBillNewFactory.getLocalInstance(ctx);
        try {
            this.storeOldDepreAndAmort(ctx, billInfo, tmPeriod);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        for (int i = 0; i < entry.size(); ++i) {
            String leaseInBillId = entry.get(i).getLeaseInBill().getId().toString();
            FaLeaseInBillNewInfo leaseInBillInfo = iFaLeaseInBillNew.getFaLeaseInBillNewInfo((IObjectPK)new ObjectUuidPK(leaseInBillId), sic);
            if (leaseInBillInfo.isIsExempt()) continue;
            try {
                this.storeNewDepreAndAmort(ctx, billInfo, tmPeriod);
                continue;
            }
            catch (SQLException throwables) {
                throw new BOSException((Throwable)throwables);
            }
        }
    }

    private void createLeaseBill(Context ctx, FaTerminateBillInfo billInfo) throws BOSException, EASBizException {
        FaTerminateBillEntryCollection entryColl = FaTerminateBillEntryFactory.getLocalInstance(ctx).getFaTerminateBillEntryCollection("select id,leaseInBill.id,isCreateLeaseInBill where bill.id = '" + billInfo.getId().toString() + "'");
        PeriodInfo period = FlLocalUtils.getFLCurrentPeriod(billInfo.getCompany().getId().toString(), ctx);
        for (int i = 0; i < entryColl.size(); ++i) {
            FaTerminateBillEntryInfo entry = entryColl.get(i);
            if (!entry.isIsCreateLeaseInBill()) continue;
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("contractCat.id");
            sic.add("contractCat.name");
            sic.add("company.id");
            sic.add("company.name");
            sic.add("company.baseCurrency.id");
            sic.add("company.baseCurrency.name");
            sic.add("company.baseCurrency.precision");
            sic.add("paymentEntry.*");
            sic.add("faLeaseDepCostSharingEntry.*");
            IFaLeaseInBillNew leaseInBillInstance = FaLeaseInBillNewFactory.getLocalInstance(ctx);
            FaLeaseInBillNewInfo leaseInfo = leaseInBillInstance.getFaLeaseInBillNewInfo((IObjectPK)new ObjectUuidPK(entry.getLeaseInBill().getId().toString()), sic);
            FaLeaseInBillNewInfo newLeaseInfo = (FaLeaseInBillNewInfo)leaseInfo.clone();
            newLeaseInfo.setId(null);
            newLeaseInfo.setFiAccountDate(period.getEndDate());
            if (!leaseInfo.isIsExistsFreePeriod()) {
                newLeaseInfo.setBeginRentDate(period.getEndDate());
                newLeaseInfo.setBeginDate(period.getEndDate());
            }
            newLeaseInfo.setPeriod(period);
            newLeaseInfo.setInitialAsset(BigDecimal.ZERO);
            newLeaseInfo.setInitialLiability(BigDecimal.ZERO);
            newLeaseInfo.setInitialDirectFee(BigDecimal.ZERO);
            newLeaseInfo.setUnrecognizedFinanceFee(BigDecimal.ZERO);
            newLeaseInfo.setIsExempt(false);
            newLeaseInfo.setIsExpire(false);
            newLeaseInfo.setIsHistory(false);
            newLeaseInfo.setHasRented(0);
            newLeaseInfo.setHasPayedRent(BigDecimal.ZERO);
            newLeaseInfo.getPaymentEntry().clear();
            newLeaseInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
            newLeaseInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
            newLeaseInfo.setHasEffected(false);
            newLeaseInfo.setFiVouchered(false);
            newLeaseInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
            newLeaseInfo.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
            newLeaseInfo.setVoucher(null);
            newLeaseInfo.setSourceType(FaLeaseSourceTypeEnum.TERMINATION_CREAT);
            newLeaseInfo.setBizStatus(FaLeaseBizStatusEnum.HAVE_ADDED);
            newLeaseInfo.setLeaseType(FaLeaseTypeEnum.OPERATING_LEASE);
            try {
                FaNewLeasePolicyInfo newLeasePolicy = FaNewLeasePolicyFactory.getLocalInstance(ctx).getEnabledNewLeasePolicy(newLeaseInfo.getCompany().getId().toString());
                newLeaseInfo.setDepreciationMethod(newLeasePolicy.getDepreciationMethod());
            }
            catch (Exception e) {
                throw new BOSException("\u83b7\u53d6\u65b0\u79df\u8d41\u8ba1\u7b97\u89c4\u5219\u62a5\u9519\uff01\n" + e.getMessage());
            }
            for (int j = 0; j < newLeaseInfo.getEntry().size(); ++j) {
                FaLeaseInBillEntryNewInfo faLeaseInBillEntryNewInfo = newLeaseInfo.getEntry().get(j);
                faLeaseInBillEntryNewInfo.setId(null);
                faLeaseInBillEntryNewInfo.setHead(newLeaseInfo);
            }
            Timestamp time = new Timestamp(new java.util.Date().getTime());
            UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            newLeaseInfo.setCreateTime(time);
            newLeaseInfo.setLastUpdateTime(time);
            newLeaseInfo.setCreator(currentUserInfo);
            newLeaseInfo.setLastUpdateUser(currentUserInfo);
            newLeaseInfo.setAuditor(null);
            newLeaseInfo.setAuditTime(null);
            if (newLeaseInfo.getFaLeaseDepCostSharingEntry() != null) {
                int m = newLeaseInfo.getFaLeaseDepCostSharingEntry().size();
                for (int n = 0; n < m; ++n) {
                    BOSUuid id = BOSUuid.create((BOSObjectType)newLeaseInfo.getFaLeaseDepCostSharingEntry().get(n).getBOSType());
                    newLeaseInfo.getFaLeaseDepCostSharingEntry().get(n).setId(id);
                }
            }
            int cycle = this.calculateTimeCycle(newLeaseInfo.getBeginDate(), newLeaseInfo.getEndDate());
            newLeaseInfo.setTimeCycle(cycle);
            newLeaseInfo.setLeaseCycle(cycle);
            newLeaseInfo.setInitialAssetDecValue(new BigDecimal("0"));
            FaPaymentPlanNewCollection faPaymentPlanNewCollection = leaseInfo.getPaymentEntry();
            if (faPaymentPlanNewCollection != null && faPaymentPlanNewCollection.size() != 0) {
                faPaymentPlanNewCollection.sort("payDate");
                faPaymentPlanNewCollection.removeObject(0);
            }
            int totalPayPeriodt = 0;
            java.util.Date firstPayTime = newLeaseInfo.getBeginDate();
            boolean inFirstPayTime = true;
            int m = faPaymentPlanNewCollection.size();
            for (int n = 0; n < m; ++n) {
                if (this.compareDateIfMonthNextDate(faPaymentPlanNewCollection.get(n).getPayDate(), billInfo.getTerminateDate())) {
                    ++totalPayPeriodt;
                }
                if (!inFirstPayTime || !this.compareDateIfDayNextDate(faPaymentPlanNewCollection.get(n).getPayDate(), firstPayTime)) continue;
                firstPayTime = faPaymentPlanNewCollection.get(n).getPayDate();
                inFirstPayTime = false;
            }
            newLeaseInfo.setTotalPayPeriod(totalPayPeriodt);
            newLeaseInfo.setFirstPayTime(firstPayTime);
            newLeaseInfo.setWholeProcessAsset(null);
            newLeaseInfo.setWholeProcessLiability(null);
            newLeaseInfo.setWholeProcessUFF(null);
            newLeaseInfo.setAdjustAccDepAsset(null);
            newLeaseInfo.setAdjustDecAsset(null);
            newLeaseInfo.setAdjustInterestPayment(null);
            newLeaseInfo.setAdjustmentAsset(null);
            newLeaseInfo.setAdjustmentLiability(null);
            newLeaseInfo.setAdjustmentUnFncFee(null);
            newLeaseInfo.setRentWithTax(BigDecimal.ZERO);
            newLeaseInfo.setRentWithoutTax(BigDecimal.ZERO);
            newLeaseInfo.setRentWithTaxNew(BigDecimal.ZERO);
            newLeaseInfo.setRentWithoutTaxNew(BigDecimal.ZERO);
            newLeaseInfo.setAccDepOfAsset(BigDecimal.ZERO);
            newLeaseInfo.setAccUnrFinExpenses(BigDecimal.ZERO);
            newLeaseInfo.setRecoveryCostNPV(BigDecimal.ZERO);
            newLeaseInfo.setCostDate1(null);
            newLeaseInfo.setCostDate2(null);
            newLeaseInfo.setCostDate7(null);
            newLeaseInfo.setCostTaxRate1(null);
            newLeaseInfo.setCostTaxRate2(null);
            newLeaseInfo.setCostTaxRate7(null);
            newLeaseInfo.setCostPmWithoutTax1(null);
            newLeaseInfo.setCostPmWithoutTax2(null);
            newLeaseInfo.setCostPmWithoutTax7(null);
            newLeaseInfo.setCostPmWithoutTaxOC1(null);
            newLeaseInfo.setCostPmWithoutTaxOC2(null);
            newLeaseInfo.setCostPmWithoutTaxOC7(null);
            newLeaseInfo.setCostPmWithTax1(null);
            newLeaseInfo.setCostPmWithTax2(null);
            newLeaseInfo.setCostPmWithTax7(null);
            newLeaseInfo.setCostPmWithTaxOC1(null);
            newLeaseInfo.setCostPmWithTaxOC2(null);
            newLeaseInfo.setCostPmWithTaxOC7(null);
            newLeaseInfo.setCostTax1(null);
            newLeaseInfo.setCostTax2(null);
            newLeaseInfo.setCostTax7(null);
            IObjectPK newLeaseBillPk = leaseInBillInstance.save((CoreBaseInfo)newLeaseInfo);
            StringBuffer _sql = new StringBuffer("update T_FA_FaTerminateBillEntry set");
            _sql.append(" FCreatedLeaseInBillID = ?");
            _sql.append(" WHERE fid = ?");
            Object[] params = new Object[]{newLeaseBillPk.toString(), entry.getId().toString()};
            DbUtil.execute((Context)ctx, (String)_sql.toString(), (Object[])params);
        }
    }

    protected void _unpassAuditSelf(Context ctx, IObjectPK pk, FaBillBaseInfo model) throws BOSException, EASBizException {
        if (model.isFiVouchered()) {
            throw new FaTerminateException(FaTerminateException.ISVOUCHER, new Object[]{model.getNumber()});
        }
        PeriodInfo tmPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)ContextUtil.getCurrentFIUnit((Context)ctx));
        FaTerminateBillInfo bill = (FaTerminateBillInfo)model;
        FaTerminateBillEntryCollection entry = bill.getEntry();
        this.checkLeaseBillAudit(ctx, pk);
        this.dealLeaseBill(ctx, entry, 4);
        this.dealLeaseBillTmrminatedType(ctx, entry, null);
        StringBuffer _sql = new StringBuffer("update " + this.getMasterTable() + "  set");
        _sql.append(" FCheckedStatus = ?");
        _sql.append(",FAuditorId = null");
        _sql.append(",FAuditTime = null");
        _sql.append(" where fid = ?");
        Object[] params = new Object[]{new Integer(1), pk.toString()};
        CompanyOrgUnitInfo company = model.getCompany();
        if (company == null || company.getId() == null) {
            company = (CompanyOrgUnitInfo)this.getValue(ctx, "select company.id where id ='" + pk + "'").get("company");
        }
        DbUtil.execute((Context)ctx, (String)_sql.toString(), (Object[])params);
        _sql = new StringBuffer("delete T_FA_FaLeaseInBillNew where fid in (select FCreatedLeaseInBillID from  T_FA_FaTerminateBillEntry where fbillid = ?)");
        DbUtil.execute((Context)ctx, (String)_sql.toString(), (Object[])new Object[]{pk.toString()});
        _sql = new StringBuffer("update T_FA_FaTerminateBillEntry  set FCreatedLeaseInBillID = ''");
        _sql.append(" where fbillid = ?");
        params = new Object[]{pk.toString()};
        DbUtil.execute((Context)ctx, (String)_sql.toString(), (Object[])params);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("isExempt");
        IFaLeaseInBillNew iFaLeaseInBillNew = FaLeaseInBillNewFactory.getLocalInstance(ctx);
        for (int i = 0; i < entry.size(); ++i) {
            String leaseInBillId = entry.get(i).getLeaseInBill().getId().toString();
            FaLeaseInBillNewInfo leaseInBillInfo = iFaLeaseInBillNew.getFaLeaseInBillNewInfo((IObjectPK)new ObjectUuidPK(leaseInBillId), sic);
            if (leaseInBillInfo.isIsExempt()) continue;
            BigDecimal[] oldDepreAndAmort = new BigDecimal[]{entry.get(i).getOldMonthlyDepreAmt(), entry.get(i).getOldAcumDepreAmt(), entry.get(i).getOldMonthlyInterestExpe(), entry.get(i).getOldAcumInterestExpe()};
            this.setCurPeriodNewDepreAndAmort(ctx, leaseInBillId, tmPeriod, oldDepreAndAmort);
        }
    }

    @Override
    protected Map _getPaidRentAmt(Context ctx, Set leaseInIdSet, java.util.Date terminateDate, FaTerminateMode terminateMode, java.util.Date adjustDate) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        FaLeaseInBillNewCollection faLeaseInBillNewCollection = this.changeIdSetToObjectCollection(ctx, leaseInIdSet);
        int j = faLeaseInBillNewCollection.size();
        for (int i = 0; i < j; ++i) {
            FaLeaseInBillNewInfo billNewInfo = faLeaseInBillNewCollection.get(i);
            billNewInfo.put("calcType", FlCalcTreeCalcTypeEnum.CALC_PAID_RENT_AMT.getName());
            billNewInfo.put("terminateType", terminateMode.getName());
            billNewInfo.put("ctx", ctx);
            params.put("leaseInBillId", billNewInfo.getId().toString());
            params.put("initCfmDate", billNewInfo.getDpInitCfmDate());
            params.put("terminateDate", terminateDate);
            params.put("adjustDate", adjustDate);
            params.put("billBeginDate", billNewInfo.getBeginDate());
            params.put("isDeductible", billNewInfo.isIsDeductible());
            params.put("leaseInBill", billNewInfo);
            try {
                CalcTree.calc(ctx, billNewInfo, params, resultMap);
                if (terminateMode != FaTerminateMode.RETROSPECT_TERMINATION) continue;
                billNewInfo.put("calcType", FlCalcTreeCalcTypeEnum.CALC_RETR_PAID_RENT_AMT.getName());
                CalcTree.calc(ctx, billNewInfo, params, resultMap);
                continue;
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return resultMap;
    }

    @Override
    protected Map _getDeprInterestAmt(Context ctx, Set leaseInIdSet, java.util.Date terminateDate, FaTerminateMode terminateMode, java.util.Date adjustDate) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        FaLeaseInBillNewCollection faLeaseInBillNewCollection = this.changeIdSetToObjectCollection(ctx, leaseInIdSet);
        PeriodInfo tmPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)ContextUtil.getCurrentFIUnit((Context)ctx));
        int j = faLeaseInBillNewCollection.size();
        for (int i = 0; i < j; ++i) {
            FaLeaseInBillNewInfo billNewInfo = faLeaseInBillNewCollection.get(i);
            billNewInfo.put("terminateType", terminateMode.getName());
            params.put("leaseInBillId", billNewInfo.getId().toString());
            params.put("leaseInBill", billNewInfo);
            params.put("initCfmDate", billNewInfo.getDpInitCfmDate());
            params.put("terminateDate", terminateDate);
            params.put("adjustDate", adjustDate);
            params.put("billBeginDate", billNewInfo.getBeginDate());
            params.put("tmPeriod", tmPeriod);
            params.put("billEndDate", billNewInfo.getEndDate());
            params.put("isDeductible", billNewInfo.isIsDeductible());
            try {
                resultMap.put(billNewInfo.getId().toString(), new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
                this.calcDeprStatus(ctx, billNewInfo.getId().toString(), resultMap);
                billNewInfo.put("calcType", FlCalcTreeCalcTypeEnum.CALC_ACUM_DEPRE_AMT.getName());
                CalcTree.calc(ctx, billNewInfo, params, resultMap);
                billNewInfo.put("calcType", FlCalcTreeCalcTypeEnum.CALC_UNRECOGNIZED_FINANCING.getName());
                CalcTree.calc(ctx, billNewInfo, params, resultMap);
                if (terminateMode != FaTerminateMode.RETROSPECT_TERMINATION) continue;
                billNewInfo.put("calcType", FlCalcTreeCalcTypeEnum.CALC_RETR_ACUM_DEPRE_AMT.getName());
                CalcTree.calc(ctx, billNewInfo, params, resultMap);
                billNewInfo.put("calcType", FlCalcTreeCalcTypeEnum.CALC_RETR_ACUM_INTEREST_EXPE.getName());
                CalcTree.calc(ctx, billNewInfo, params, resultMap);
                continue;
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return resultMap;
    }

    @Override
    protected String _calcNewDepreAndAmortForOthers(Context ctx, Set leaseInIdSet) throws BOSException, EASBizException {
        if (leaseInIdSet == null || leaseInIdSet.size() == 0) {
            return null;
        }
        PeriodInfo tmPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)ContextUtil.getCurrentFIUnit((Context)ctx));
        HashMap<Object, Date> dateMap = new HashMap<Object, Date>();
        HashMap<Object, FaTerminateMode> terminateModeMap = new HashMap<Object, FaTerminateMode>();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FLEASEINBILLID, FTerminateDate, FTerminateMode \n");
        sql.append(" FROM T_FA_FATERMINATEBILLENTRY tme \n");
        sql.append(" LEFT JOIN T_FA_FaTerminateBill tm ON tme.FBillID = tm.FID \n");
        sql.append(" WHERE FLEASEINBILLID IN (");
        sql.append(this.idSet2Str(leaseInIdSet));
        sql.append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                String id = rs.getString("FLEASEINBILLID");
                Date terminatedDate = rs.getDate("FTerminateDate");
                String terminateMode = rs.getString("FTerminateMode");
                dateMap.put(id, terminatedDate);
                terminateModeMap.put(id, FaTerminateMode.getEnum(terminateMode));
            }
            for (Object leaseInBillId : leaseInIdSet) {
                this.calcNewDepreAndAmort(ctx, (java.util.Date)dateMap.get(leaseInBillId.toString()), leaseInBillId.toString(), tmPeriod, (FaTerminateMode)((Object)terminateModeMap.get(leaseInBillId.toString())), false);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public String idSet2Str(Set<String> idSet) {
        StringBuffer ids = new StringBuffer();
        Iterator<String> it = idSet.iterator();
        while (it.hasNext()) {
            ids.append("'");
            ids.append(it.next());
            ids.append("'");
            if (!it.hasNext()) continue;
            ids.append(",");
        }
        return ids.toString();
    }

    private Timestamp[] queryAmortBeginEndDate(Context ctx, String leaseInBillId) throws BOSException, FaTerminateException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT MIN(entry.FDATE) beginDate, MAX(entry.FDATE) endDate FROM T_FA_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_FA_FaAmortizedCostRptEntry entry ON RPT.FID = ENTRY.FAMORTIZEDCOSTRPTID");
        sql.append(" WHERE rpt.FLEASEINBILLID = ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{leaseInBillId});
        if (rs.next()) {
            return new Timestamp[]{rs.getTimestamp("beginDate"), rs.getTimestamp("endDate")};
        }
        throw new FaTerminateException(FaTerminateException.GENERATE_NEW_DEPREANDAMORT_FAIL);
    }

    private BigDecimal[] calcTmMonDeprInterest(Context ctx, String leaseInBillId, Timestamp beginDate, Timestamp tmDate, boolean isContainTmDate) throws BOSException, SQLException, FaTerminateException {
        BigDecimal[] resArr = new BigDecimal[2];
        IRowSet maRs = null;
        StringBuffer monthAmtSql = new StringBuffer();
        monthAmtSql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        monthAmtSql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        monthAmtSql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        monthAmtSql.append(" WHERE rpt.FLeaseInBillId = ?");
        if (beginDate != null) {
            monthAmtSql.append(" AND entry.FDate >= ?");
            monthAmtSql.append(" AND entry.FDate < ?");
            maRs = DbUtil.executeQuery((Context)ctx, (String)monthAmtSql.toString(), (Object[])new Object[]{leaseInBillId, beginDate, tmDate});
        } else {
            monthAmtSql.append(" AND entry.FDate <" + (isContainTmDate ? "= " : " ") + "?");
            maRs = DbUtil.executeQuery((Context)ctx, (String)monthAmtSql.toString(), (Object[])new Object[]{leaseInBillId, tmDate});
        }
        if (maRs.next() && maRs.getBigDecimal("monthDep") != null) {
            resArr[0] = maRs.getBigDecimal("monthDep");
            resArr[1] = maRs.getBigDecimal("monthIP");
        } else {
            resArr[0] = new BigDecimal("0");
            resArr[1] = new BigDecimal("0");
        }
        return resArr;
    }

    private BigDecimal[] queryBeforeTmAccDeprInterest(Context ctx, String leaseInBillId, int periodNumber) throws BOSException, FaTerminateException, SQLException {
        BigDecimal[] resArr = new BigDecimal[2];
        StringBuffer accAmtSql = new StringBuffer();
        accAmtSql.append(" SELECT TOP 1 dep.FACUMDEPREAMT accDep, dep.FACUMINTERESTEXPE accIP FROM T_Fa_FaDepreAndAmort dep");
        accAmtSql.append(" LEFT OUTER JOIN T_BD_Period period ON DEP.FPERIODID = PERIOD.FID");
        accAmtSql.append(" WHERE period.FNUMBER < ? AND FLEASEINBILLID = ?");
        accAmtSql.append(" ORDER BY period.FNUMBER DESC");
        IRowSet aaRs = DbUtil.executeQuery((Context)ctx, (String)accAmtSql.toString(), (Object[])new Object[]{periodNumber, leaseInBillId});
        if (aaRs.next()) {
            resArr[0] = aaRs.getBigDecimal("accDep");
            resArr[1] = aaRs.getBigDecimal("accIP");
        } else {
            resArr[0] = BigDecimal.ZERO;
            resArr[1] = BigDecimal.ZERO;
        }
        return resArr;
    }

    private BigDecimal[] queryTmAccDeprInterestAdjust(Context ctx, String leaseInBillId, Timestamp adjustDate, PeriodInfo tmPeriodDate, boolean adjustType) throws BOSException, FaTerminateException, SQLException {
        BigDecimal[] resArr = new BigDecimal[2];
        IRowSet maRs = null;
        StringBuffer monthAmtSql = new StringBuffer();
        monthAmtSql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        monthAmtSql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        monthAmtSql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        monthAmtSql.append(" WHERE rpt.FLeaseInBillId = ?");
        monthAmtSql.append(" AND entry.FDate >= ?");
        if (adjustType) {
            monthAmtSql.append(" AND entry.FDate <= ?");
            maRs = DbUtil.executeQuery((Context)ctx, (String)monthAmtSql.toString(), (Object[])new Object[]{leaseInBillId, adjustDate, new Timestamp(tmPeriodDate.getEndDate().getTime())});
        } else {
            monthAmtSql.append(" AND entry.FDate < ?");
            maRs = DbUtil.executeQuery((Context)ctx, (String)monthAmtSql.toString(), (Object[])new Object[]{leaseInBillId, adjustDate, new Timestamp(tmPeriodDate.getBeginDate().getTime())});
        }
        if (maRs.next() && maRs.getBigDecimal("monthDep") != null) {
            resArr[0] = maRs.getBigDecimal("monthDep");
            resArr[1] = maRs.getBigDecimal("monthIP");
        } else {
            resArr[0] = new BigDecimal("0");
            resArr[1] = new BigDecimal("0");
        }
        return resArr;
    }

    private BigDecimal[] calcTmAccDeprInterest(BigDecimal[] beforeTmAccDeprInterest, BigDecimal[] monDeprInterest) {
        BigDecimal[] tmAccDeprInterest = new BigDecimal[]{beforeTmAccDeprInterest[0].add(monDeprInterest[0]), beforeTmAccDeprInterest[1].add(monDeprInterest[1])};
        return tmAccDeprInterest;
    }

    private void updateDADelStatus(Context ctx, int delStatus, String leaseBillId, String periodId, boolean isIncloudCurPeriod) throws BOSException {
        StringBuffer updateSql = new StringBuffer();
        updateSql.append(" UPDATE T_Fa_FaDepreAndAmort SET FDeletedStatus = ?");
        updateSql.append(" WHERE FID IN (");
        updateSql.append(" SELECT depr.FID FID FROM T_Fa_FaDepreAndAmort depr");
        updateSql.append(" LEFT JOIN T_BD_PERIOD period ON depr.FPERIODID = period.FID");
        updateSql.append(" WHERE depr.FLeaseInBillId = ?");
        if (isIncloudCurPeriod) {
            updateSql.append(" AND period.FNUMBER >= (SELECT FNUMBER FROM T_BD_PERIOD WHERE FID = ?)");
        } else {
            updateSql.append(" AND period.FNUMBER > (SELECT FNUMBER FROM T_BD_PERIOD WHERE FID = ?)");
        }
        updateSql.append(" )");
        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{delStatus, leaseBillId, periodId});
    }

    private void checkLeaseBillAudit(Context ctx, IObjectPK pk) throws BOSException, FaTerminateException {
        StringBuffer checkSql = new StringBuffer();
        checkSql.append("select fte.fid from  T_FA_FaTerminateBillEntry fte,T_FA_FaLeaseInBillNew fl");
        checkSql.append(" where fte.FBillID = ? and fl.fid = fte.FCreatedLeaseInBillID and fl.FCHECKEDSTATUS = ?");
        Object[] params = new Object[]{pk.toString(), 2};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString(), (Object[])params);
        try {
            if (rs.next()) {
                throw new FaTerminateException(FaTerminateException.LEASEIN_AUDIT);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected SelectorItemCollection getSelfSelctor() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("handler.id"));
        sic.add(new SelectorItemInfo("period.id"));
        sic.add(new SelectorItemInfo("period.beginDate"));
        sic.add(new SelectorItemInfo("isCreateLease"));
        sic.add(new SelectorItemInfo("fiVouchered"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("terminateDate"));
        sic.add(new SelectorItemInfo("terminateMode"));
        sic.add(new SelectorItemInfo("entry.id"));
        sic.add(new SelectorItemInfo("entry.paidRent"));
        sic.add(new SelectorItemInfo("entry.acumDepreAmt"));
        sic.add(new SelectorItemInfo("entry.acumInterestExpe"));
        sic.add(new SelectorItemInfo("entry.assetDisposalGain"));
        sic.add(new SelectorItemInfo("entry.leaseInBill.id"));
        sic.add(new SelectorItemInfo("entry.leaseInBill.number"));
        sic.add(new SelectorItemInfo("entry.isCreateLeaseInBill"));
        sic.add(new SelectorItemInfo("entry.createdLeaseInBill.id"));
        sic.add(new SelectorItemInfo("entry.retrospectAdjustDate"));
        sic.add(new SelectorItemInfo("entry.retrospectAcumDepreAmt"));
        sic.add(new SelectorItemInfo("entry.retrospectUFFee"));
        sic.add(new SelectorItemInfo("entry.retrospectPaidRent"));
        sic.add(new SelectorItemInfo("entry.deprStatus"));
        sic.add(new SelectorItemInfo("entry.oldMonthlyDepreAmt"));
        sic.add(new SelectorItemInfo("entry.oldAcumDepreAmt"));
        sic.add(new SelectorItemInfo("entry.oldMonthlyInterestExpe"));
        sic.add(new SelectorItemInfo("entry.oldAcumInterestExpe"));
        return sic;
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        VoucherInfo voucher = this.lookVoucherInfo(ctx, bOTRelationInfo);
        if (voucher != null && voucher.getId() != null) {
            if (bOTBillOperStateEnum == BOTBillOperStateEnum.ADDNEW) {
                DbUtil.execute((Context)ctx, (String)("update T_FA_FaTerminateBill set FFiVouchered = 1 ,FVoucher='" + voucher.getId() + "'  where fid = ?"), (Object[])new Object[]{srcBillVO.get("id").toString()});
            }
        } else {
            super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
        }
        if (new VoucherInfo().getBOSType().toString().equals(bOTRelationInfo.get("destentityid")) && bOTBillOperStateEnum == BOTBillOperStateEnum.DELETE) {
            DbUtil.execute((Context)ctx, (String)"update T_FA_FaTerminateBill set FFiVouchered = 0 ,FVoucher=null where fid = ?", (Object[])new Object[]{srcBillVO.get("id").toString()});
        }
    }

    private VoucherInfo lookVoucherInfo(Context ctx, IObjectValue bOTRelationInfo) throws BOSException {
        Iterator iter;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("voucherAbstract"));
        sic.add(new SelectorItemInfo("voucherType.id"));
        FilterInfo filter = new FilterInfo();
        if (((BOTRelationInfo)bOTRelationInfo).getDestObjectID() == null) {
            return null;
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)((BOTRelationInfo)bOTRelationInfo).getDestObjectID()));
        EntityViewInfo entityView = new EntityViewInfo();
        entityView.getSelector().addObjectCollection((IObjectCollection)sic);
        entityView.setFilter(filter);
        IVoucher voucher = VoucherFactory.getLocalInstance((Context)ctx);
        VoucherCollection voucherCollection = voucher.getVoucherCollection(entityView);
        if (voucherCollection.size() > 0 && (iter = voucherCollection.iterator()).hasNext()) {
            VoucherInfo voucherInfo = (VoucherInfo)iter.next();
            return voucherInfo;
        }
        return null;
    }

    private void calcDeprStatus(Context ctx, String leaseBillId, Map<String, Object> resMap) throws BOSException, EASBizException {
        PeriodInfo curPeriod = FlLocalUtils.getFLCurrentPeriod(FlLocalUtils.getCurrentCompanyId(ctx), ctx);
        boolean deprStatus = FaDepreAndAmortFactory.getLocalInstance(ctx).exists("where leaseInBill.id = '" + leaseBillId + "' and period.id = '" + curPeriod.getId().toString() + "'");
        if (deprStatus) {
            resMap.put(leaseBillId + "deprStatus", new BigDecimal[]{new BigDecimal("1")});
        }
    }

    private void storeOldDepreAndAmort(Context ctx, FaTerminateBillInfo faTerminateBillInfo, PeriodInfo periodInfo) throws BOSException, SQLException, EASBizException {
        FaTerminateBillEntryCollection entry = faTerminateBillInfo.getEntry();
        if (entry == null || entry.size() == 0) {
            return;
        }
        StringBuffer depreAndAmortSql = new StringBuffer("SELECT * FROM T_FA_FaDepreAndAmort WHERE FPERIODID = ? and FLEASEINBILLID in (");
        for (int i = 0; i < entry.size(); ++i) {
            if (i != 0) {
                depreAndAmortSql.append(",");
            }
            depreAndAmortSql.append("'").append(entry.get(i).getLeaseInBill().getId().toString()).append("'");
        }
        depreAndAmortSql.append(")");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)depreAndAmortSql.toString(), (Object[])new Object[]{periodInfo.getId().toString()});
        while (rowSet.next()) {
            String leaseBillId = rowSet.getString("FLEASEINBILLID");
            BigDecimal oldMonthlyDepreAmt = rowSet.getBigDecimal("FMonthlyDepreAmt");
            BigDecimal oldAcumDepreAmt = rowSet.getBigDecimal("FAcumDepreAmt");
            BigDecimal oldMonthlyInterestExpe = rowSet.getBigDecimal("FMonthlyInterestExpe");
            BigDecimal oldAcumInterestExpe = rowSet.getBigDecimal("FAcumInterestExpe");
            for (int i = 0; i < entry.size(); ++i) {
                if (!leaseBillId.equals(entry.get(i).getLeaseInBill().getId().toString())) continue;
                StringBuffer _sql = new StringBuffer("update T_FA_FaTerminateBillEntry set");
                _sql.append(" FOldMonthlyDepreAmt = ?,");
                _sql.append(" FOldAcumDepreAmt = ?,");
                _sql.append(" FOldMonthlyInterestExpe = ?,");
                _sql.append(" FOldAcumInterestExpe = ?");
                _sql.append(" WHERE fid = ?");
                Object[] params = new Object[]{oldMonthlyDepreAmt == null ? null : Double.valueOf(oldMonthlyDepreAmt.doubleValue()), oldAcumDepreAmt == null ? null : Double.valueOf(oldAcumDepreAmt.doubleValue()), oldMonthlyInterestExpe == null ? null : Double.valueOf(oldMonthlyInterestExpe.doubleValue()), oldAcumInterestExpe == null ? null : Double.valueOf(oldAcumInterestExpe.doubleValue()), entry.get(i).getId().toString()};
                DbUtil.execute((Context)ctx, (String)_sql.toString(), (Object[])params);
            }
        }
    }

    private void storeNewDepreAndAmort(Context ctx, FaTerminateBillInfo faTerminateBillInfo, PeriodInfo periodInfo) throws EASBizException, BOSException, SQLException {
        FaTerminateBillEntryCollection entry = faTerminateBillInfo.getEntry();
        if (entry == null || entry.size() == 0) {
            return;
        }
        for (int i = 0; i < entry.size(); ++i) {
            if (!entry.get(i).isDeprStatus()) continue;
            this.calcNewDepreAndAmort(ctx, faTerminateBillInfo.getTerminateDate(), entry.get(i).getLeaseInBill().getId().toString(), periodInfo, faTerminateBillInfo.getTerminateMode(), true);
        }
    }

    private void calcNewDepreAndAmort(Context ctx, java.util.Date terminateDate, String faLeaseInBillID, PeriodInfo tmPeriod, FaTerminateMode faTerminateMode, boolean isBeforeDep) throws EASBizException, BOSException, SQLException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("contractCat.id");
        selectors.add("contractCat.name");
        selectors.add("contractCat.depreciationPolicy");
        selectors.add("contractCat.depreciationPolicy.*");
        selectors.add("currency.id");
        selectors.add("currency.name");
        selectors.add("company.id");
        selectors.add("company.name");
        selectors.add("company.baseCurrency.precision");
        selectors.add("paymentEntry.*");
        selectors.add("exchangeRate.*");
        selectors.add("exchangeRate.exchangeAux.*");
        FaLeaseInBillNewInfo faLeaseInBillNewInfo = FaLeaseInBillNewFactory.getLocalInstance(ctx).getFaLeaseInBillNewInfo((IObjectPK)new ObjectUuidPK(faLeaseInBillID), selectors);
        if (isBeforeDep) {
            TerminateBillForBeforeDepEnum terminateBillForBeforeDepEnum = TerminateBillForBeforeDepEnum.getEnumAccordingToBillType(faTerminateMode.getName());
            if (terminateBillForBeforeDepEnum == null) {
                throw new BOSException("\u7ec8\u6b62\u7c7b\u578b\u9519\u8bef");
            }
            terminateBillForBeforeDepEnum.calcNewDepreAndAmort(ctx, terminateDate, faLeaseInBillNewInfo, tmPeriod);
        } else {
            TerminateBillForAfterDepEnum terminateBillForAfterDepEnum = TerminateBillForAfterDepEnum.getEnumAccordingToBillType(faTerminateMode.getName());
            if (terminateBillForAfterDepEnum == null) {
                throw new BOSException("\u7ec8\u6b62\u7c7b\u578b\u9519\u8bef");
            }
            terminateBillForAfterDepEnum.calcNewDepreAndAmort(ctx, terminateDate, faLeaseInBillNewInfo, tmPeriod);
        }
    }

    private void setCurPeriodNewDepreAndAmort(Context ctx, String leasebillID, PeriodInfo curPeriod, BigDecimal[] newDepreAndAmort) throws BOSException {
        StringBuffer updateSql = new StringBuffer();
        if (newDepreAndAmort[0] == null && newDepreAndAmort[1] == null && newDepreAndAmort[2] == null && newDepreAndAmort[3] == null) {
            updateSql.append("DELETE FROM T_FA_FaDepreAndAmort WHERE FLEASEINBILLID = ? and FPERIODID = ?");
            DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{leasebillID, curPeriod.getId().toString()});
            return;
        }
        updateSql.append("update T_FA_FaDepreAndAmort set FMonthlyDepreAmt = ?, FAcumDepreAmt = ?, FMonthlyInterestExpe = ?, FAcumInterestExpe = ? ");
        updateSql.append("where FLEASEINBILLID = ? and FPERIODID = ?");
        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{newDepreAndAmort[0], newDepreAndAmort[1], newDepreAndAmort[2], newDepreAndAmort[3], leasebillID, curPeriod.getId().toString()});
    }

    public static java.util.Date getMinMonthDate(java.util.Date date) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMinimum(5));
        return calendar.getTime();
    }

    private int calculateTimeCycle(java.util.Date beginDate, java.util.Date endDate) {
        if (beginDate == null || endDate == null) {
            return 0;
        }
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(beginDate);
        c2.setTime(endDate);
        int monthCount = c2.get(2) - c1.get(2);
        int yearCount = (c2.get(1) - c1.get(1)) * 12;
        int dayCount = c2.get(5) - c1.get(5);
        int timeCycle = monthCount + yearCount;
        if (dayCount >= 0) {
            ++timeCycle;
        }
        return timeCycle;
    }

    private FaLeaseInBillNewCollection changeIdSetToObjectCollection(Context ctx, Set leaseInIdSet) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("contractCat.id");
        sic.add("contractCat.name");
        sic.add("contractCat.depreciationPolicy");
        sic.add("contractCat.depreciationPolicy.*");
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("company.id");
        sic.add("company.name");
        sic.add("company.baseCurrency.precision");
        sic.add("paymentEntry.*");
        sic.add("exchangeRate.*");
        sic.add("exchangeRate.exchangeAux.*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)leaseInIdSet, CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        view.setFilter(filter);
        return FaLeaseInBillNewFactory.getLocalInstance(ctx).getFaLeaseInBillNewCollection(view);
    }

    @Override
    protected Map _queryCalcTreePath(Context ctx, Object conditionValue, Map params, Map result) throws BOSException, EASBizException {
        try {
            HashMap<String, Object> tmpMap = new HashMap<String, Object>();
            ((FaLeaseInBillNewInfo)conditionValue).put("calcType", FlCalcTreeCalcTypeEnum.CALC_PAID_RENT_AMT.getName());
            CalcTree.getCalcMessage(ctx, conditionValue, params, tmpMap);
            result.put(FlCalcTreeCalcTypeEnum.CALC_PAID_RENT_AMT.getName(), tmpMap);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    protected void invokeServiceAfter(ServiceContext svcCtx) throws BOSException {
        RPCMethodMappingUtils.invokeRPCMethodEventListener(svcCtx, new FaTerminateBillInfo());
        super.invokeServiceAfter(svcCtx);
    }

    private boolean compareDateIfMonthNextDate(java.util.Date date1, java.util.Date date2) {
        Calendar cld1 = Calendar.getInstance();
        Calendar cld2 = Calendar.getInstance();
        cld1.setTime(date1);
        cld2.setTime(date2);
        int subMonth = (cld2.get(1) - cld1.get(1)) * 12 + cld2.get(2) - cld1.get(2);
        return subMonth <= 0;
    }

    private boolean compareDateIfDayNextDate(java.util.Date date1, java.util.Date date2) {
        Calendar cld1 = Calendar.getInstance();
        Calendar cld2 = Calendar.getInstance();
        cld1.setTime(date1);
        cld2.setTime(date2);
        int subMonth = (cld2.get(1) - cld1.get(1)) * 12 + cld2.get(2) - cld1.get(2);
        int subDay = cld2.get(5) - cld1.get(5);
        return subMonth < 0 || subMonth == 0 && subDay <= 0;
    }
}

