/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaBillBizProcessor;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.nlm.FaContractCatInfo;
import com.kingdee.eas.fi.nlm.FaLeaseBizStatusEnum;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.nlm.FaleaseDecValueCollection;
import com.kingdee.eas.fi.nlm.FaleaseDecValueEntryCollection;
import com.kingdee.eas.fi.nlm.FaleaseDecValueEntryInfo;
import com.kingdee.eas.fi.nlm.FaleaseDecValueFactory;
import com.kingdee.eas.fi.nlm.FaleaseDecValueInfo;
import com.kingdee.eas.fi.nlm.app.AbstractFaleaseDecValueControllerBean;
import com.kingdee.eas.fi.nlm.app.fleventlistener.utils.RPCMethodMappingUtils;
import com.kingdee.eas.fi.nlm.app.prc.AbstractPrcFaManageStrategy;
import com.kingdee.eas.fi.nlm.app.prc.PrcFaCoreManager;
import com.kingdee.eas.fi.nlm.app.prc.PrcFaLeaseDecValueStrategy;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class FaleaseDecValueControllerBean
extends AbstractFaleaseDecValueControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.nlm.app.FaleaseDecValueControllerBean");
    public static final String FACARDRESOURCE = "com.kingdee.eas.fi.fa.manage.FaCardResource";
    private static final String RES_PATH = "com.kingdee.eas.fi.nlm.FaDecValueResource";
    private int periodYear;
    private int periodNumber;

    @Override
    protected boolean _isDecAudited(Context ctx, int periodYear, int periodNumber) throws BOSException {
        CompanyOrgUnitInfo currCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("period.periodYear", (Object)new Integer(periodYear)));
        filterInfo.getFilterItems().add(new FilterItemInfo("period.periodNumber", (Object)new Integer(periodNumber)));
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)currCompany.getId().toString()));
        view.setFilter(filterInfo);
        view.getSelector().add(new SelectorItemInfo("checkedStatus"));
        FaleaseDecValueCollection coll = this.getFaleaseDecValueCollection(ctx, view);
        if (!coll.isEmpty()) {
            return CheckedStatusEnum.AUDITED.equals((Object)coll.get(0).getCheckedStatus());
        }
        return false;
    }

    @Override
    protected boolean _isNotDecValue(Context ctx, int periodYear, int periodNumber) throws BOSException {
        CompanyOrgUnitInfo currCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("period.periodYear", (Object)new Integer(periodYear)));
        filterInfo.getFilterItems().add(new FilterItemInfo("period.periodNumber", (Object)new Integer(periodNumber)));
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)currCompany.getId().toString()));
        view.setFilter(filterInfo);
        view.getSelector().add(new SelectorItemInfo("id"));
        FaleaseDecValueCollection coll = this.getFaleaseDecValueCollection(ctx, view);
        return coll.isEmpty();
    }

    @Override
    protected boolean _isFiVouchered(Context ctx, int periodYear, int periodNumber) throws BOSException {
        CompanyOrgUnitInfo currCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("period.periodYear", (Object)new Integer(periodYear)));
        filterInfo.getFilterItems().add(new FilterItemInfo("period.periodNumber", (Object)new Integer(periodNumber)));
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)currCompany.getId().toString()));
        view.setFilter(filterInfo);
        view.getSelector().add(new SelectorItemInfo("fiVouchered"));
        FaleaseDecValueCollection coll = this.getFaleaseDecValueCollection(ctx, view);
        if (!coll.isEmpty()) {
            return coll.get(0).isFiVouchered();
        }
        return false;
    }

    private boolean isFiVouchered(Context ctx, IObjectPK sourceBillPk) throws BOSException, EASBizException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("fiVouchered"));
        FaleaseDecValueInfo decValueInfo = this.getFaleaseDecValueInfo(ctx, sourceBillPk, selectors);
        if (decValueInfo != null) {
            return decValueInfo.isFiVouchered();
        }
        return false;
    }

    @Override
    protected FaleaseDecValueInfo _getFaleaseDecValueInfo(Context ctx, EntityViewInfo view) throws BOSException, EASBizException {
        FaleaseDecValueInfo editData = new FaleaseDecValueInfo();
        editData.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        try {
            this.periodYear = (Integer)view.get("periodYear");
            this.periodNumber = (Integer)view.get("periodNumber");
            PeriodInfo period = new PeriodInfo();
            period.setPeriodYear(this.periodYear);
            period.setPeriodNumber(this.periodNumber);
            editData.setPeriod(period);
            String fName = "FName_" + ctx.getLocale().toString();
            StringBuffer sql = new StringBuffer();
            CompanyOrgUnitInfo currCompanyInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
            editData.setCompany(currCompanyInfo);
            PeriodInfo currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)currCompanyInfo);
            boolean isCurrPeriod = currPeriod.getPeriodYear() == this.periodYear && currPeriod.getPeriodNumber() == this.periodNumber;
            Calendar cld1 = Calendar.getInstance();
            cld1.setTime(currPeriod.getBeginDate());
            cld1.set(cld1.get(1), cld1.get(2), 1, 0, 0, 0);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String curDate = dateFormat.format(cld1.getTime());
            sql.append("select distinct assetCat, leaseNumber, leaseName, neatValue, decedValue, decValue, bakDecValue, status, cardID, leaseBizStatus from (");
            if (isCurrPeriod && !this._isDecAudited(ctx, this.periodYear, this.periodNumber)) {
                sql.append("select contractcat.FNAME_L2 AS assetCat, ");
                sql.append("lease.FNumber AS leaseNumber, ");
                sql.append("lease.FContractName AS leaseName, ");
                sql.append("lease.FBizStatus AS leaseBizStatus, ");
                sql.append("b.neatValue as neatValue, ");
                sql.append("lease.FInitialAssetDecValue AS decedValue, ");
                sql.append("0 AS decValue, ");
                sql.append("0 AS bakDecValue, ");
                sql.append("1 AS status, ");
                sql.append("lease.FID AS cardID \n");
                sql.append(" FROM ").append("T_FA_FALEASEINBILLNEW lease \n");
                sql.append(" inner join ").append("T_FA_FAContractCat contractcat ON lease.FContractCatID = contractcat.FID \n");
                sql.append(" inner join ").append("t_bd_period pd on lease.fperiodid = pd.fid \n");
                sql.append(" inner join ");
                sql.append(" (select lease.FID AS cardID, max(rptEntry.FInitRightOfUseAsset) AS neatValue \n");
                sql.append(" FROM ").append("T_FA_FALEASEINBILLNEW lease \n");
                sql.append(" inner join ").append("T_FA_FAAMORTIZEDCOSTRPT rpt ON lease.FID = rpt.FLeaseInBillID \n");
                sql.append(" inner join ").append("T_FA_FAAMORTIZEDCOSTRPTENTRY rptEntry ON rptEntry.FAmortizedCostRptID = rpt.FID \n");
                sql.append(" where rptEntry.FDate >= ").append("{d '").append(curDate).append("'}");
                sql.append(" and rptEntry.FDate <= ").append("{d '").append(dateFormat.format(FaleaseDecValueControllerBean.getMaxMonthDate(cld1.getTime()))).append("'}");
                sql.append(" group by lease.FID ) b on lease.fid = b.cardID ");
                sql.append(" where lease.fcheckedstatus = ").append(2);
                sql.append(" and lease.fblockedStatus = ").append(1);
                sql.append(" and lease.fdeletedstatus != ").append(2);
                sql.append(" and lease.FEffectedStatus = ").append(2);
                sql.append(" and (lease.FBizStatus = ").append(1).append(" or ").append("lease.FBizStatus = ").append(3).append(" or ").append("lease.FBizStatus = ").append("9) \n");
                sql.append(" and lease.fid not in (select entry.FLeaseBillID from T_FA_FaleaseDecValue decv");
                sql.append(" inner join T_FA_FaleaseDecValueEntry entry on entry.fheadid = decv.fid");
                sql.append(" inner join t_bd_period period on decv.fperiodid = period.fid");
                sql.append(" where period.fperiodyear = ").append(this.periodYear);
                sql.append(" and period.fperiodnumber = ").append(this.periodNumber);
                sql.append(" and decv.fcompanyid = '").append(currCompanyInfo.getId().toString()).append("')");
                sql.append(" and lease.fcompanyid = '").append(currCompanyInfo.getId().toString()).append("'");
                sql.append(" and pd.fnumber <= ").append(100 * this.periodYear + this.periodNumber);
                sql.append(" union all ");
            }
            sql.append("select contractcat.FNAME_L2 AS assetCat, ");
            sql.append("lease.FNumber AS leaseNumber, ");
            sql.append("lease.FContractName AS leaseName, ");
            sql.append("lease.FBizStatus AS leaseBizStatus, ");
            sql.append("entry.FCurrentNetAssets AS neatValue, ");
            sql.append("lease.FInitialAssetDecValue AS decedValue, ");
            sql.append("entry.fdecvalue as decValue, ");
            sql.append("entry.fdecvalue AS bakDecValue, ");
            sql.append("1 AS status, ");
            sql.append("lease.FID AS cardID \n");
            sql.append(" from T_FA_FaleaseDecValue decv ");
            sql.append(" inner join T_FA_FaleaseDecValueEntry entry on decv.fid = entry.fheadid");
            sql.append(" inner join t_bd_period period on decv.fperiodid = period.fid");
            sql.append(" inner join T_FA_FALEASEINBILLNEW lease on lease.fid = entry.FLeaseBillID");
            sql.append(" inner join ").append("T_FA_FAContractCat contractcat ON lease.FContractCatID = contractcat.FID \n");
            sql.append(" where period.fperiodyear = ").append(this.periodYear);
            sql.append(" and period.fperiodnumber = ").append(this.periodNumber);
            sql.append(" and decv.fcompanyid = '").append(currCompanyInfo.getId().toString()).append("'");
            sql.append(") as c");
            FilterInfo filter = view.getFilter();
            if (filter != null && filter.toString().trim().length() > 0) {
                sql.append(" where ").append("1 = 1");
            }
            if (view.getSorter().toString() != null && view.getSorter().toString().trim().length() > 0) {
                sql.append(" order by ").append(view.getSorter().toString());
            } else {
                sql.append(" order by leaseNumber");
            }
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)FaLocalUtils.transformLocal((Context)ctx, (String)sql.toString()));
            while (rowSet.next()) {
                FaleaseDecValueEntryInfo entryInfo = new FaleaseDecValueEntryInfo();
                FaLeaseInBillNewInfo faLeaseInBillNewInfo = new FaLeaseInBillNewInfo();
                FaContractCatInfo faContractCatInfo = new FaContractCatInfo();
                faContractCatInfo.setName(rowSet.getString("assetCat"));
                faLeaseInBillNewInfo.setContractCat(faContractCatInfo);
                faLeaseInBillNewInfo.setNumber(rowSet.getString("leaseNumber"));
                faLeaseInBillNewInfo.setContractName(rowSet.getString("leaseName"));
                faLeaseInBillNewInfo.setInitialAssetDecValue(rowSet.getBigDecimal("decedValue"));
                faLeaseInBillNewInfo.setId(BOSUuid.read((String)rowSet.getString("cardId")));
                entryInfo.setLeaseBill(faLeaseInBillNewInfo);
                entryInfo.setCurrentNetAssets(rowSet.getBigDecimal("neatValue"));
                entryInfo.setAlreadyDecValue(rowSet.getBigDecimal("decedValue") == null ? new BigDecimal("0") : rowSet.getBigDecimal("decedValue"));
                entryInfo.setDecValue(rowSet.getBigDecimal("decValue"));
                entryInfo.setOldLeaseBillbizStatus(FaLeaseBizStatusEnum.getEnum(rowSet.getInt("leaseBizStatus")));
                editData.getEntry().add(entryInfo);
            }
            Object[] params = new Object[]{this.periodYear, this.periodNumber, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString()};
            sql = new StringBuffer();
            sql.append("select decv.fid as fid, decv.fcheckedstatus as fcheckedstatus, decv.FiVouchered as ffivouchered");
            sql.append(" from T_FA_FaleaseDecValue decv inner join t_bd_period period on period.fid = decv.fperiodid");
            sql.append(" where period.fperiodyear = ? and period.fperiodnumber = ? and decv.fcompanyid = ?");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            if (rowSet.next()) {
                editData.setId(BOSUuid.read((String)rowSet.getString("fid")));
                editData.setCheckedStatus(CheckedStatusEnum.getEnum((int)rowSet.getInt("fcheckedstatus")));
                editData.setFiVouchered(rowSet.getBoolean("ffivouchered"));
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        return editData;
    }

    @Override
    protected void _passAudit(Context ctx) throws EASBizException, BOSException {
        CompanyOrgUnitInfo currCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        PeriodInfo currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)currCompany);
        String getDecValueSql = "select *, company.id, company.number, period.id, entry.decValue, entry.leaseBill.id where period.id ='" + currPeriod.getId().toString() + "' and company.id ='" + currCompany.getId().toString() + "'";
        FaleaseDecValueInfo decValueInfo = FaleaseDecValueFactory.getLocalInstance(ctx).getFaleaseDecValueInfo(getDecValueSql);
        FaBillBizProcessor.lockTable((Context)ctx, (String)decValueInfo.getId().toString());
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(this.getBillStrategy());
        ObjectUuidPK pk = new ObjectUuidPK(decValueInfo.getId());
        prcFaCoreManager.getFaManageStrategy().checkForAudit(ctx, (IObjectPK)pk);
        prcFaCoreManager.getFaManageStrategy().auditBill(ctx, (IObjectValue)decValueInfo);
        this.passAuditSelf(ctx, (IObjectPK)pk, decValueInfo);
        logger.debug((Object)"_passAudit");
    }

    @Override
    protected void _unpassAudit(Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo currCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        PeriodInfo currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)currCompany);
        String getDecValueSql = "select *, period.id, entry.decValue, entry.leaseBill.id where period.id ='" + currPeriod.getId().toString() + "' and company.id = '" + currCompany.getId().toString() + "'";
        FaleaseDecValueInfo decValueinfo = FaleaseDecValueFactory.getLocalInstance(ctx).getFaleaseDecValueInfo(getDecValueSql);
        FaBillBizProcessor.lockTable((Context)ctx, (String)decValueinfo.getId().toString());
        ObjectUuidPK pk = new ObjectUuidPK(decValueinfo.getId());
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(this.getBillStrategy());
        prcFaCoreManager.getFaManageStrategy().checkForUnAudit(ctx, (IObjectPK)pk);
        prcFaCoreManager.getFaManageStrategy().unAuditBill(ctx, (IObjectValue)decValueinfo);
        this.unpassAuditSelf(ctx, (IObjectPK)pk, decValueinfo);
        logger.debug((Object)"_unpassAudit");
    }

    @Override
    protected void _passAuditSelf(Context ctx, IObjectPK pk, FaleaseDecValueInfo model) throws BOSException, EASBizException {
        StringBuffer _sql = new StringBuffer("update T_Fa_FaleaseDecValue set");
        _sql.append(" FCheckedStatus = ?");
        _sql.append(",FAuditorId = ?");
        _sql.append(",FBizDate = ?");
        _sql.append(" where fid = ?");
        Object[] params = new Object[4];
        params[0] = new Integer(2);
        params[1] = ctx.getCaller().toString();
        CompanyOrgUnitInfo company = model.getCompany();
        if (company == null || company.getId() == null) {
            company = (CompanyOrgUnitInfo)this.getValue(ctx, "select company.id where id ='" + pk + "'").get("company");
        }
        params[2] = new Timestamp(FaLocalUtils.getBizDate4Fl((Context)ctx, (String)company.getId().toString()).getTime());
        params[3] = pk.toString();
        DbUtil.execute((Context)ctx, (String)_sql.toString(), (Object[])params);
    }

    @Override
    protected void _unpassAuditSelf(Context ctx, IObjectPK pk, FaleaseDecValueInfo model) throws BOSException, EASBizException {
        StringBuffer _sql = new StringBuffer("update T_Fa_FaleaseDecValue set");
        _sql.append(" FCheckedStatus = ?");
        _sql.append(",FAuditorId = null");
        _sql.append(" where fid = ?");
        Object[] params = new Object[]{new Integer(1), pk.toString()};
        DbUtil.execute((Context)ctx, (String)_sql.toString(), (Object[])params);
    }

    @Override
    protected FaleaseDecValueInfo _verifySubmit(Context ctx, FaleaseDecValueInfo decValueInfo) throws BOSException, EASBizException {
        FaleaseDecValueEntryCollection entryColl = decValueInfo.getEntry();
        FaleaseDecValueInfo decVInfo = decValueInfo.getId() == null ? null : this.getFaleaseDecValueInfo(ctx, decValueInfo);
        FaleaseDecValueEntryCollection newEntryColl = new FaleaseDecValueEntryCollection();
        if (entryColl.isEmpty()) {
            return null;
        }
        Iterator items = entryColl.iterator();
        StringBuffer ids = new StringBuffer();
        while (items.hasNext()) {
            boolean isDecValue = false;
            FaleaseDecValueEntryInfo entryInfo = (FaleaseDecValueEntryInfo)items.next();
            if (entryInfo.getLeaseBill() == null) continue;
            if (decVInfo != null && decVInfo.getEntry().size() > 0) {
                int size = decVInfo.getEntry().size();
                for (int i = 0; i < size; ++i) {
                    FaleaseDecValueEntryInfo entry = decVInfo.getEntry().get(i);
                    if (entry.getLeaseBill() == null || !entryInfo.getLeaseBill().getId().equals((Object)entry.getLeaseBill().getId())) continue;
                    isDecValue = true;
                    break;
                }
            }
            if (entryInfo.getDecValue() == null && !isDecValue) {
                String strExecption = ResourceBase.getString((String)RES_PATH, (String)"neatValueIsNull", (Locale)ctx.getOriginLocale());
                throw new EASBizException(new NumericExceptionSubItem("1", strExecption));
            }
            if (entryInfo.getDecValue().doubleValue() == 0.0 && !isDecValue) continue;
            ids.append(",'").append(entryInfo.getLeaseBill().getId().toString()).append("'");
            newEntryColl.add(entryInfo);
        }
        entryColl.clear();
        entryColl.addCollection(newEntryColl);
        if (ids.length() == 0) {
            return decValueInfo;
        }
        StringBuffer info = new StringBuffer();
        if (info.length() > 0) {
            info.append("\u3002").append(ResourceBase.getString((String)RES_PATH, (String)"isContinue", (Locale)ctx.getOriginLocale()));
            decValueInfo.put("errorInfo", info.substring(1));
        }
        if (decValueInfo.getPeriod().getId() == null) {
            PeriodInfo periodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (int)this.periodYear, (int)this.periodNumber, (CompanyOrgUnitInfo)ContextUtil.getCurrentFIUnit((Context)ctx));
            decValueInfo.setPeriod(periodInfo);
        }
        return decValueInfo;
    }

    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        String pk = model.get("id") == null ? null : model.get("id").toString();
        FaBillBizProcessor.lockTable((Context)ctx, (String)pk);
        this.checkBeforeSubmin(ctx, (IObjectValue)model);
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(this.getBillStrategy());
        FaleaseDecValueInfo decValueInfo = (FaleaseDecValueInfo)model;
        if (decValueInfo.getId() != null) {
            prcFaCoreManager.getFaManageStrategy().checkForEdit(ctx, (IObjectValue)decValueInfo);
        }
        logger.debug((Object)"_submit");
        return prcFaCoreManager.getFaManageStrategy().submitBill(ctx, (IObjectValue)model);
    }

    private FaleaseDecValueInfo getFaleaseDecValueInfo(Context ctx, FaleaseDecValueInfo decValueInfo) throws EASBizException, BOSException {
        CompanyOrgUnitInfo currCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        boolean hasSeved = decValueInfo != null && decValueInfo.getPeriod() != null && decValueInfo.getPeriod().getId() != null;
        PeriodInfo currentPeriod = hasSeved ? decValueInfo.getPeriod() : SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)currCompany);
        String getDecValueSql = "select id, entry.decValue, entry.leaseBill.id where period.id = '" + currentPeriod.getId() + "' and company.id = '" + currCompany.getId().toString() + "'";
        FaleaseDecValueInfo faDecValueInfo = FaleaseDecValueFactory.getLocalInstance(ctx).getFaleaseDecValueInfo(getDecValueSql);
        return faDecValueInfo;
    }

    @Override
    protected IObjectPK _submitSelf(Context ctx, FaleaseDecValueInfo decValueInfo) throws BOSException, EASBizException {
        IObjectPK pk = super._submit(ctx, (IObjectValue)decValueInfo);
        return pk;
    }

    protected AbstractPrcFaManageStrategy getBillStrategy() {
        return new PrcFaLeaseDecValueStrategy();
    }

    private void checkBeforeSubmin(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaleaseDecValueInfo decValue = (FaleaseDecValueInfo)model;
        FaleaseDecValueEntryCollection entryColl = decValue.getEntry();
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            FaLeaseInBillNewInfo card = entryColl.get(i).getLeaseBill();
            if (card == null || card.getId() == null) continue;
            Timestamp lastUpdateTime = FaBillBizProcessor.lockCurCard((Context)ctx, (String)card.getId().toString());
            FaBillBizProcessor.checkFaCurCardVersion((Context)ctx, (String)card.getId().toString(), (Timestamp)lastUpdateTime);
        }
    }

    public static Date getMaxMonthDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    protected void invokeServiceAfter(ServiceContext svcCtx) throws BOSException {
        RPCMethodMappingUtils.invokeRPCMethodEventListener(svcCtx, new FaleaseDecValueInfo());
        super.invokeServiceAfter(svcCtx);
    }
}

