/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.STConverter;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.base.commonquery.CustomerParams;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.nlm.FlContrastSolutionFactory;
import com.kingdee.eas.fi.nlm.FlContrastSolutionInfo;
import com.kingdee.eas.fi.nlm.app.AbstractFlContrastSolutionControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class FlContrastSolutionControllerBean
extends AbstractFlContrastSolutionControllerBean {
    private static final long serialVersionUID = 5509790644718875663L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.nlm.app.FlContrastSolutionControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._save(ctx, model);
        this.updateMultiLanguageField(ctx, model, pk);
        return pk;
    }

    private void updateMultiLanguageField(Context ctx, IObjectValue model, IObjectPK pk) throws BOSException {
        String enName;
        String tcName;
        String scName;
        FlContrastSolutionInfo solutionInfo = (FlContrastSolutionInfo)model;
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        if ("l2".equals(loc)) {
            scName = solutionInfo.getName();
            tcName = STConverter.sc2tc((String)scName);
            enName = null;
        } else if ("l3".equals(loc)) {
            tcName = solutionInfo.getName();
            scName = STConverter.tc2sc((String)tcName);
            enName = null;
        } else {
            scName = solutionInfo.getName();
            tcName = solutionInfo.getName();
            enName = solutionInfo.getName();
        }
        StringBuffer sql = new StringBuffer();
        sql.append("update t_fa_flcontrastsolution set fname_l1 = ?, ");
        sql.append("fname_l2 = ?, ");
        sql.append("fname_l3 = ? ");
        sql.append("where fid = ? ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{enName, scName, tcName, pk.toString()});
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
        this.updateMultiLanguageField(ctx, model, pk);
    }

    @Override
    protected List _getInitData(Context ctx) throws BOSException, EASBizException {
        ArrayList resultList = new ArrayList();
        StringBuffer sbFilter = new StringBuffer();
        sbFilter = this.getHasPermissionOrgRange(ctx);
        if (sbFilter.length() == 0) {
            return resultList;
        }
        String sql = "select a.fid orgId, a.fnumber orgNumber, a.fname_l2 orgName, d.fnumber currPeriod, a.fcontrolunitid cuid,\t\r\n\t\td.fperiodyear curYear, d.fperiodnumber curPeriodNumber, d.fid periodId \t        \r\n\t\tfrom t_org_company a \t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n      inner join t_pm_orgrange as range on a.fid = range.forgid               \t\r\n\t\tinner join t_bd_systemstatusctrol b on a.fid=b.fcompanyid \t\t\t\t\t\r\n\t\tinner join t_bd_systemstatus c on c.fid=b.fsystemstatusid\t\t\t\t\t\r\n\t\tinner join t_bd_period d on d.fid=b.fcurrentperiodid \t\t\t\t\t\t\r\n\t\twhere c.fname=2001 and a.fisbizunit=1 \t\t\t\t\t\t\t\t\t\t\r\n\t\tand a.fid in (" + sbFilter.toString() + ")\t\t\t\t\t\t\t\t\t\r\n      and range.ftype=10 and  range.fuserid = '" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "'   \r\n\t\torder by a.fnumber\t\t\t\t\t\t\t\t\r\n";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (set != null) {
            try {
                while (set.next()) {
                    HashMap<String, Object> dataMap = new HashMap<String, Object>();
                    String orgId = set.getString("orgId");
                    dataMap.put("orgId", orgId);
                    dataMap.put("orgNumber", set.getString("orgNumber"));
                    dataMap.put("orgName", set.getString("orgName"));
                    dataMap.put("currPeriod", set.getString("curYear") + "." + set.getString("curPeriodNumber"));
                    ObjectUuidPK companyPK = new ObjectUuidPK(orgId);
                    PeriodInfo startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.FINANCE_LEASE, (IObjectPK)companyPK);
                    if (startPeriodInfo == null) continue;
                    dataMap.put("startPeriod", startPeriodInfo);
                    CoreBaseCollection solutionColl = this.getSolutionCollection(ctx, orgId);
                    int n = solutionColl.size();
                    for (int i = 0; i < n; ++i) {
                        CustomerParams cp;
                        boolean isDefaultSolution;
                        FlContrastSolutionInfo solution = (FlContrastSolutionInfo)solutionColl.get(i);
                        if (solution == null || solution.getParams() == null || !(isDefaultSolution = (cp = XMLBean.transStrToCommonCustParams((String)solution.getParams())).getBoolean("IsDefaultSolution"))) continue;
                        dataMap.put("solutionId", solution.getId().toString());
                        dataMap.put("solutionName", solution.getName(ctx.getLocale()));
                        dataMap.put("solution", solution);
                        break;
                    }
                    if (dataMap.get("solutionId") == null) {
                        dataMap.put("solutionId", "");
                        dataMap.put("solutionName", "");
                        dataMap.put("solution", null);
                    }
                    resultList.add(dataMap);
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return resultList;
    }

    private StringBuffer getHasPermissionOrgRange(Context ctx) throws EASBizException, BOSException {
        StringBuffer sbFilter = new StringBuffer();
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        FullOrgUnitCollection permCompany = null;
        permCompany = iPermission.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId()), OrgType.Company, null, "fa_leasecontrast_view");
        if (permCompany == null || permCompany.size() == 0) {
            return sbFilter;
        }
        for (int i = 0; i < permCompany.size(); ++i) {
            if (i == 0) {
                sbFilter.append("'").append(permCompany.get(i).getId().toString()).append("'");
                continue;
            }
            sbFilter.append(",'").append(permCompany.get(i).getId().toString()).append("'");
        }
        return sbFilter;
    }

    private CoreBaseCollection getSolutionCollection(Context ctx, String orgID) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("orgID", (Object)orgID));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterInfo);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.getSorter().add(new SorterItemInfo("name"));
        view.setSorter(sorter);
        return FlContrastSolutionFactory.getLocalInstance(ctx).getCollection(view);
    }

    @Override
    protected Map _getPeriodRangeData(Context ctx) throws BOSException, EASBizException {
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        CompanyOrgUnitInfo currCompanyInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        String periodType = currCompanyInfo.getAccountPeriodType().getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select a.fperiodyear periodyear from (");
        sql.append("select min(fperiodyear) fperiodyear from t_bd_period where ftypeid = ? ");
        sql.append("union all ");
        sql.append("select max(fperiodyear) fperiodyear from t_bd_period where ftypeid = ? ");
        sql.append(") a order by a.fperiodyear");
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{periodType, periodType});
        int startYear = 0;
        int endYear = 0;
        int k = 0;
        if (set != null) {
            try {
                while (set.next()) {
                    if (k == 0) {
                        startYear = set.getInt("periodyear") == 0 ? 0 : set.getInt("periodyear");
                    } else {
                        endYear = set.getInt("periodyear") == 0 ? 0 : set.getInt("periodyear");
                    }
                    ++k;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (startYear == 0 || endYear == 0) {
            return resultMap;
        }
        resultMap.put("startYear", startYear);
        resultMap.put("endYear", endYear);
        for (int i = startYear; i <= endYear; ++i) {
            int max = PeriodUtils.getMaxPeriodNumber((Context)ctx, (int)i, (IObjectPK)new ObjectUuidPK(currCompanyInfo.getId()));
            int min = PeriodUtils.getMinPeriodNumber((Context)ctx, (int)i, (IObjectPK)new ObjectUuidPK(currCompanyInfo.getId()));
            resultMap.put("maxNumber" + i, new Integer(max));
            resultMap.put("minNumber" + i, new Integer(min));
        }
        return resultMap;
    }
}

