/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewCollection;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewFactory;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.nlm.FaLeaseTypeEnum;
import com.kingdee.eas.fi.nlm.FaPayFrequencyEnum;
import com.kingdee.eas.fi.nlm.FaPaymentPlanNewCollection;
import com.kingdee.eas.fi.nlm.NLMAssetCalculationDetailCollection;
import com.kingdee.eas.fi.nlm.NLMAssetCalculationDetailEntryCollection;
import com.kingdee.eas.fi.nlm.NLMAssetCalculationDetailEntryFactory;
import com.kingdee.eas.fi.nlm.NLMAssetCalculationDetailEntryInfo;
import com.kingdee.eas.fi.nlm.NLMAssetCalculationDetailFactory;
import com.kingdee.eas.fi.nlm.NLMAssetCalculationDetailInfo;
import com.kingdee.eas.fi.nlm.app.AbstractNLMAssetCalculationDetailControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.apache.poi.ss.formula.functions.FinanceLib;
import org.apache.poi.ss.formula.functions.Irr;

public class NLMAssetCalculationDetailControllerBean
extends AbstractNLMAssetCalculationDetailControllerBean {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.nlm.app.NLMAssetCalculationDetailControllerBean");
    private static final String RES_PATH_POLICY = "com.kingdee.eas.fi.nlm.FaNewLeasePolicyResource";
    private static final String YEAR_DATES = "365";
    private static final long DATE_TIME_MILLIS = 86400000L;
    private static final String INITIAL_ASSET = ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"60_NLMAssetCalculationDetailControllerBean", (Locale)ContextUtils.getContextFromSession().getLocale());
    private static final String Cost_Type_Advance_Payment_NPV = ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"61_NLMAssetCalculationDetailControllerBean", (Locale)ContextUtils.getContextFromSession().getLocale());
    private static final String Cost_Type_Init_Direct_Fee = ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"62_NLMAssetCalculationDetailControllerBean", (Locale)ContextUtils.getContextFromSession().getLocale());
    private static final String STAMP_TAX = ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"63_NLMAssetCalculationDetailControllerBean", (Locale)ContextUtils.getContextFromSession().getLocale());
    private static final String Cost_Type_Recovery_Costs_NPV = ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"64_NLMAssetCalculationDetailControllerBean", (Locale)ContextUtils.getContextFromSession().getLocale());
    private static final String Cost_Type_Rent_Incentive = ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"65_NLMAssetCalculationDetailControllerBean", (Locale)ContextUtils.getContextFromSession().getLocale());
    private static final String PAYMENT_AMOUNT_NPV = ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"66_NLMAssetCalculationDetailControllerBean", (Locale)ContextUtils.getContextFromSession().getLocale());
    private FaLeaseInBillNewInfo faLeaseInBillNewInfo;
    private FaPaymentPlanNewCollection ppCol;
    private List<Date> payDateList;
    private List<Double> cfPayArr = new ArrayList<Double>();
    private Date advPayDate;
    private double advCf;
    private Integer ppIndexNumber;
    Date npvDate;
    private Integer originScale;
    private Integer amountScale;
    private CompanyOrgUnitInfo curCompany;
    private double exchangeRateInfo;
    private static StringBuffer initialAssetExpression;
    private static StringBuffer initialAssetCalculation;
    private static StringBuffer advancePaymentNpvExpression;
    private static StringBuffer advancePaymentNpvCalculation;
    private static StringBuffer recoveryCostsNpvExpression;
    private static StringBuffer recoveryCostsNpvCalculation;

    private void initFaLeaseBillInfoRelatedData(Context ctx, IObjectPK billId) throws EASBizException, BOSException {
        int i;
        Date curDate;
        boolean isDiscount2ImplDate;
        this.faLeaseInBillNewInfo = this.getLeaseInBill(ctx, billId);
        this.originScale = CurrencyFactory.getLocalInstance((Context)ctx).getValue("select precision where id='" + this.faLeaseInBillNewInfo.getCurrency().getId().toString() + "'").getInt("precision");
        this.amountScale = this.getCurrentCompany(ctx).getBaseCurrency().getPrecision();
        this.exchangeRateInfo = new Double(this.faLeaseInBillNewInfo.getExchangeRateValue().toString());
        if (this.faLeaseInBillNewInfo.getExchangeRate() != null && this.faLeaseInBillNewInfo.getExchangeRate().getExchangeAux().getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE) {
            this.exchangeRateInfo = 1.0 / this.exchangeRateInfo;
        }
        this.ppCol = this.faLeaseInBillNewInfo.getPaymentEntry();
        if (this.ppCol.size() == 0) {
            return;
        }
        this.ppCol.sort("payDate");
        this.ppCol.removeObject(0);
        this.payDateList = new ArrayList<Date>();
        this.cfPayArr = new ArrayList<Double>();
        this.advPayDate = null;
        this.advCf = new Double("0");
        Date beginDate = this.faLeaseInBillNewInfo.getBeginDate();
        Date endDate = this.faLeaseInBillNewInfo.getEndDate();
        Date firstPayDate = this.faLeaseInBillNewInfo.getFirstPayTime();
        Date endPayDate = this.ppCol.get(this.ppCol.size() - 1).getPayDate();
        Date endAmortizedCostDate = endDate.compareTo(endPayDate) > 0 ? endDate : endPayDate;
        int ppIdx = 0;
        boolean bl = isDiscount2ImplDate = FaManageUtils.getIntFaParamValue((Context)ctx, (String)"NLM_303", (String)this.faLeaseInBillNewInfo.getCompany().getId().toString()) == 0;
        if (this.faLeaseInBillNewInfo.isIsHistory() && isDiscount2ImplDate) {
            if (beginDate.compareTo(this.faLeaseInBillNewInfo.getDpInitCfmDate()) < 0) {
                curDate = this.faLeaseInBillNewInfo.getDpInitCfmDate();
                if (this.ppCol.get(0).getPayDate().compareTo(this.faLeaseInBillNewInfo.getDpInitCfmDate()) < 0) {
                    ppIdx = this.getFirstImpDateIndex(this.ppCol, this.faLeaseInBillNewInfo);
                }
            } else {
                curDate = beginDate;
            }
        } else {
            curDate = beginDate;
            if (firstPayDate.compareTo(beginDate) < 0) {
                Calendar cld = Calendar.getInstance();
                cld.setTimeInMillis(beginDate.getTime() - 86400000L);
                this.advPayDate = cld.getTime();
                for (i = 0; i < this.ppCol.size() && this.ppCol.get(i).getPayDate().compareTo(beginDate) < 0; ++i) {
                    this.advCf += this.faLeaseInBillNewInfo.isIsDeductible() ? this.calcPWOT(this.BD2db(this.ppCol.get(0).getPaymentWithTax()), this.BD2db(this.ppCol.get(0).getTaxRate())) : this.BD2db(this.ppCol.get(0).getPaymentWithTax());
                    ++ppIdx;
                }
            }
        }
        if (this.faLeaseInBillNewInfo.getLeaseType() == FaLeaseTypeEnum.FINANCE_LEASE) {
            curDate = this.faLeaseInBillNewInfo.getDpInitCfmDate();
        }
        this.ppIndexNumber = ppIdx;
        this.npvDate = curDate;
        int subDates = this.subDate(endAmortizedCostDate, curDate);
        for (i = 0; i < subDates + 1; ++i) {
            this.payDateList.add(curDate);
            if (ppIdx >= 0 && ppIdx < this.ppCol.size() && curDate.compareTo(this.ppCol.get(ppIdx).getPayDate()) == 0) {
                this.cfPayArr.add(this.faLeaseInBillNewInfo.isIsDeductible() ? this.calcPWOT(this.BD2db(this.ppCol.get(ppIdx).getPaymentWithTax()), this.BD2db(this.ppCol.get(ppIdx).getTaxRate())) : this.BD2db(this.ppCol.get(ppIdx).getPaymentWithTax()));
                ++ppIdx;
            } else {
                this.cfPayArr.add(new Double("0"));
            }
            curDate = this.nextDate(curDate);
        }
    }

    @Override
    protected synchronized void _saveNLMAssetCalcByBillId(Context ctx, IObjectPK billId) throws BOSException, EASBizException {
        this.initFaLeaseBillInfoRelatedData(ctx, billId);
        if (this.faLeaseInBillNewInfo.isIsExempt() || this.faLeaseInBillNewInfo.getPayFrequency() == FaPayFrequencyEnum.PAY_OFF_ONCE || this.faLeaseInBillNewInfo.getLeaseType() == FaLeaseTypeEnum.FINANCE_LEASE || this.faLeaseInBillNewInfo.getLeaseType() == FaLeaseTypeEnum.GL_BALANCE_ENTRY) {
            return;
        }
        BigDecimal discountRateForDay = this.calcRealDiscountRate(this.faLeaseInBillNewInfo, false);
        NLMAssetCalculationDetailInfo detailInfo = this.getDetailInfo(ctx, this.faLeaseInBillNewInfo, discountRateForDay);
        NLMAssetCalculationDetailEntryCollection detailEntryCollection = this.getDetailEntryInfo(ctx, this.faLeaseInBillNewInfo, detailInfo, discountRateForDay);
        detailInfo.put("entry", (Object)detailEntryCollection);
        BOSUuid nlmAssetCalcId = this.getNLMAssetCalcIdByBillId(ctx, billId);
        if (nlmAssetCalcId != null) {
            NLMAssetCalculationDetailFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(nlmAssetCalcId));
            NLMAssetCalculationDetailEntryFactory.getLocalInstance(ctx).delete("where head = '" + nlmAssetCalcId.toString() + "'");
        }
        detailInfo.setId(null);
        this.save(ctx, (CoreBaseInfo)detailInfo);
    }

    @Override
    protected synchronized void _saveNLMAssetCalcByBillIdForOldValue(Context ctx, IObjectPK billId) throws BOSException, EASBizException {
        this.initFaLeaseBillInfoRelatedData(ctx, billId);
        if (this.faLeaseInBillNewInfo.isIsExempt() || this.faLeaseInBillNewInfo.getPayFrequency() == FaPayFrequencyEnum.PAY_OFF_ONCE || this.faLeaseInBillNewInfo.getLeaseType() == FaLeaseTypeEnum.FINANCE_LEASE || this.faLeaseInBillNewInfo.getLeaseType() == FaLeaseTypeEnum.GL_BALANCE_ENTRY) {
            return;
        }
        BigDecimal discountRateForDay = this.calcRealDiscountRate(this.faLeaseInBillNewInfo, true);
        NLMAssetCalculationDetailInfo detailInfo = this.getDetailInfo(ctx, this.faLeaseInBillNewInfo, discountRateForDay);
        NLMAssetCalculationDetailEntryCollection detailEntryCollection = this.getDetailEntryInfo(ctx, this.faLeaseInBillNewInfo, detailInfo, discountRateForDay);
        detailInfo.put("entry", (Object)detailEntryCollection);
        BOSUuid nlmAssetCalcId = this.getNLMAssetCalcIdByBillId(ctx, billId);
        if (nlmAssetCalcId != null) {
            NLMAssetCalculationDetailFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(nlmAssetCalcId));
            NLMAssetCalculationDetailEntryFactory.getLocalInstance(ctx).delete("where head = '" + nlmAssetCalcId.toString() + "'");
        }
        detailInfo.setId(null);
        this.save(ctx, (CoreBaseInfo)detailInfo);
    }

    @Override
    protected IObjectValue _getNLMAssetCalcByBillId(Context ctx, IObjectPK billId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("leaseInBill.id");
        sic.add("entry.*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("leaseInBill.id", (Object)billId.toString()));
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("entry.sortNumber"));
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        view.setFilter(filter);
        view.setSorter(sorter);
        NLMAssetCalculationDetailCollection col = NLMAssetCalculationDetailFactory.getLocalInstance(ctx).getNLMAssetCalculationDetailCollection(view);
        if (col.size() < 0) {
            return null;
        }
        return col.get(0);
    }

    @Override
    protected void _deleteByBillId(Context ctx, IObjectPK billId) throws BOSException, EASBizException {
        FaLeaseInBillNewInfo faLeaseInBillNewInfo = FaLeaseInBillNewFactory.getLocalInstance(ctx).getFaLeaseInBillNewInfo(billId);
        if (faLeaseInBillNewInfo.isIsExempt() || faLeaseInBillNewInfo.getPayFrequency() == FaPayFrequencyEnum.PAY_OFF_ONCE) {
            return;
        }
        if (!NLMAssetCalculationDetailFactory.getLocalInstance(ctx).exists("where leaseInBill = '" + billId.toString() + "'")) {
            return;
        }
        NLMAssetCalculationDetailInfo detailInfo = NLMAssetCalculationDetailFactory.getLocalInstance(ctx).getNLMAssetCalculationDetailInfo("where leaseInBill = '" + billId.toString() + "'");
        NLMAssetCalculationDetailFactory.getLocalInstance(ctx).delete("where id = '" + detailInfo.getId().toString() + "'");
        NLMAssetCalculationDetailEntryFactory.getLocalInstance(ctx).delete("where head = '" + detailInfo.getId().toString() + "'");
    }

    private NLMAssetCalculationDetailInfo getDetailInfo(Context ctx, FaLeaseInBillNewInfo billNewInfo, BigDecimal discountRateForDay) {
        NLMAssetCalculationDetailInfo detailInfo = new NLMAssetCalculationDetailInfo();
        detailInfo.setLeaseInBill(billNewInfo);
        detailInfo.setLeaseBillNumber(billNewInfo.getNumber());
        detailInfo.setExchangeRateValue(String.valueOf(this.exchangeRateInfo));
        detailInfo.setDiscountRateForYear(String.valueOf(billNewInfo.getDiscountRate()));
        detailInfo.setDiscountRateForDay(String.valueOf(discountRateForDay));
        detailInfo.setIsDeductible(billNewInfo.isIsDeductible());
        detailInfo.setAdvancePaymentValue(this.faLeaseInBillNewInfo.isIsDeductible() ? this.isNull(this.faLeaseInBillNewInfo.getCostPmWithoutTaxOC1()) : this.isNull(this.faLeaseInBillNewInfo.getCostPmWithTaxOC1()));
        detailInfo.setInitDirectFeeValue(this.faLeaseInBillNewInfo.isIsDeductible() ? this.isNull(this.faLeaseInBillNewInfo.getCostPmWithoutTaxOC2()) : this.isNull(this.faLeaseInBillNewInfo.getCostPmWithTaxOC2()));
        detailInfo.setRentIncentiveValue(this.faLeaseInBillNewInfo.isIsDeductible() ? this.isNull(this.faLeaseInBillNewInfo.getCostPmWithoutTaxOC7()) : this.isNull(this.faLeaseInBillNewInfo.getCostPmWithTaxOC7()));
        detailInfo.setRecoveryCostValue(this.faLeaseInBillNewInfo.isIsDeductible() ? this.isNull(this.faLeaseInBillNewInfo.getCostPmWithoutTaxOC6()) : this.isNull(this.faLeaseInBillNewInfo.getCostPmWithTaxOC6()));
        detailInfo.setStampTaxStMValue(this.isNull(billNewInfo.getStampTaxStM()));
        detailInfo.setBeginDate(billNewInfo.getBeginDate());
        detailInfo.setDiscountDate(this.npvDate);
        detailInfo.setAdvancePaymentDate(this.faLeaseInBillNewInfo.getCostDate1());
        detailInfo.setRecoveryCostDate(this.faLeaseInBillNewInfo.getCostDate6());
        return detailInfo;
    }

    private NLMAssetCalculationDetailEntryCollection getDetailEntryInfo(Context ctx, FaLeaseInBillNewInfo billNewInfo, NLMAssetCalculationDetailInfo detailInfo, BigDecimal discountRateForDay) {
        NLMAssetCalculationDetailEntryCollection detailEntryCollection = new NLMAssetCalculationDetailEntryCollection();
        String[] rowNameArrays = new String[this.ppCol.size() + 6];
        rowNameArrays[0] = INITIAL_ASSET;
        rowNameArrays[1] = Cost_Type_Advance_Payment_NPV;
        rowNameArrays[2] = Cost_Type_Init_Direct_Fee;
        rowNameArrays[3] = STAMP_TAX;
        rowNameArrays[4] = Cost_Type_Recovery_Costs_NPV;
        rowNameArrays[5] = Cost_Type_Rent_Incentive;
        int j = this.ppCol.size();
        for (int i = 0; i < j; ++i) {
            rowNameArrays[i + 6] = PAYMENT_AMOUNT_NPV + this.ppCol.get(i).getRentPeriod();
        }
        initialAssetExpression = new StringBuffer();
        initialAssetCalculation = new StringBuffer();
        BigDecimal sumTmp = new BigDecimal("0");
        int tmpInt = 1;
        int startIndex = 0;
        int endIndex = 0;
        boolean isFirstIn = true;
        int j2 = rowNameArrays.length;
        for (int i = 0; i < j2; ++i) {
            NLMAssetCalculationDetailEntryInfo detailEntryInfo = new NLMAssetCalculationDetailEntryInfo();
            detailEntryInfo.setSortNumber(i);
            detailEntryInfo.setCalculationName(rowNameArrays[i]);
            detailEntryInfo.setCalculationValue("");
            detailEntryInfo.setCalculationProcess("");
            detailEntryInfo.setCalculationFormula("");
            detailEntryCollection.add(detailEntryInfo);
            if (INITIAL_ASSET.equals(rowNameArrays[i])) {
                if (this.faLeaseInBillNewInfo.isIsBeforeImplDate()) {
                    initialAssetExpression.append(INITIAL_ASSET).append(" = ").append(Cost_Type_Advance_Payment_NPV).append(" + ").append(Cost_Type_Recovery_Costs_NPV);
                } else {
                    initialAssetExpression.append(INITIAL_ASSET).append(" = ").append(Cost_Type_Advance_Payment_NPV).append(" + ").append(Cost_Type_Init_Direct_Fee).append(" + ").append(STAMP_TAX).append(" + ").append(Cost_Type_Recovery_Costs_NPV).append(" - ").append(Cost_Type_Rent_Incentive);
                }
                if (this.ppCol.size() != 0) {
                    initialAssetExpression.append(" + (").append(PAYMENT_AMOUNT_NPV).append(ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"67_NLMAssetCalculationDetailControllerBean", (Locale)ctx.getLocale()));
                }
                detailEntryInfo.setCalculationValue(this.faLeaseInBillNewInfo.getInitialAsset() == null ? "" : this.faLeaseInBillNewInfo.getInitialAsset().toString());
                detailEntryInfo.setCalculationProcess("");
                detailEntryInfo.setCalculationFormula(initialAssetExpression.toString());
            }
            if (Cost_Type_Advance_Payment_NPV.equals(rowNameArrays[i])) {
                detailEntryInfo.setCalculationValue(this.calcAdvPaymentNPV(this.faLeaseInBillNewInfo, discountRateForDay.doubleValue(), this.exchangeRateInfo));
                detailEntryInfo.setCalculationProcess(advancePaymentNpvCalculation.toString());
                detailEntryInfo.setCalculationFormula(advancePaymentNpvExpression.toString());
                initialAssetCalculation.append(this.formatBD4Save(new BigDecimal(detailEntryInfo.getCalculationValue()), this.amountScale));
            }
            if (Cost_Type_Init_Direct_Fee.equals(rowNameArrays[i])) {
                detailEntryInfo.setCalculationValue(this.isZero(this.exchangeRateInfo * new Double(detailInfo.getInitDirectFeeValue())));
                detailEntryInfo.setCalculationProcess(detailInfo.getInitDirectFeeValue() + " * " + this.exchangeRateInfo);
                detailEntryInfo.setCalculationFormula(Cost_Type_Init_Direct_Fee + ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"68_NLMAssetCalculationDetailControllerBean", (Locale)ctx.getLocale()));
                if (!this.faLeaseInBillNewInfo.isIsBeforeImplDate()) {
                    initialAssetCalculation.append(" + ").append(this.formatBD4Save(new BigDecimal(detailEntryInfo.getCalculationValue()), this.amountScale));
                }
            }
            if (STAMP_TAX.equals(rowNameArrays[i])) {
                detailEntryInfo.setCalculationValue(detailInfo.getStampTaxStMValue());
                detailEntryInfo.setCalculationProcess(detailInfo.getStampTaxStMValue());
                detailEntryInfo.setCalculationFormula(STAMP_TAX + ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"69_NLMAssetCalculationDetailControllerBean", (Locale)ctx.getLocale()));
                if (!this.faLeaseInBillNewInfo.isIsBeforeImplDate()) {
                    initialAssetCalculation.append(" + ").append(this.formatBD4Save(new BigDecimal(detailEntryInfo.getCalculationValue()), this.amountScale));
                }
            }
            if (Cost_Type_Recovery_Costs_NPV.equals(rowNameArrays[i])) {
                this.calcRcvNPV(this.faLeaseInBillNewInfo, discountRateForDay.doubleValue(), this.exchangeRateInfo);
                detailEntryInfo.setCalculationValue(this.faLeaseInBillNewInfo.getRecoveryCostNPV() == null ? "0" : String.valueOf(this.faLeaseInBillNewInfo.getRecoveryCostNPV()));
                detailEntryInfo.setCalculationProcess(recoveryCostsNpvCalculation.toString());
                detailEntryInfo.setCalculationFormula(recoveryCostsNpvExpression.toString());
                initialAssetCalculation.append(" + ").append(this.formatBD4Save(new BigDecimal(detailEntryInfo.getCalculationValue()), this.amountScale).toString());
            }
            if (Cost_Type_Rent_Incentive.equals(rowNameArrays[i])) {
                detailEntryInfo.setCalculationValue(this.isZero(this.exchangeRateInfo * new Double(detailInfo.getRentIncentiveValue())));
                detailEntryInfo.setCalculationProcess(detailInfo.getRentIncentiveValue() + " * " + this.exchangeRateInfo);
                detailEntryInfo.setCalculationFormula(Cost_Type_Rent_Incentive + ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"70_NLMAssetCalculationDetailControllerBean", (Locale)ctx.getLocale()));
                if (!this.faLeaseInBillNewInfo.isIsBeforeImplDate()) {
                    initialAssetCalculation.append(" - ").append(this.formatBD4Save(new BigDecimal(detailEntryInfo.getCalculationValue()), this.amountScale));
                }
            }
            if (this.ppCol.size() == 0 || !(PAYMENT_AMOUNT_NPV + tmpInt).equals(rowNameArrays[i])) continue;
            if (tmpInt <= this.ppIndexNumber) {
                detailEntryInfo.setCalculationValue("");
                detailEntryInfo.setCalculationProcess("");
                detailEntryInfo.setCalculationFormula(ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"71_NLMAssetCalculationDetailControllerBean", (Locale)ctx.getLocale()));
            } else {
                String ppColValue;
                Date startDate = this.ppCol.get(tmpInt - 1).getPayDate();
                if (isFirstIn) {
                    startDate = this.npvDate;
                }
                if (this.ppCol.get(tmpInt) != null) {
                    Date endDate = this.ppCol.get(tmpInt).getPayDate();
                    startIndex = endIndex;
                    endIndex = startIndex + this.subDate(endDate, startDate);
                } else {
                    endIndex = this.cfPayArr.size();
                }
                String npvValue = this.calcNPV(discountRateForDay.doubleValue(), this.cfPayArr, 0, endIndex);
                if (isFirstIn) {
                    Date startDateTmp = this.ppCol.get(tmpInt - 1).getPayDate();
                    this.cfPayArr.set(this.subDate(startDateTmp, this.npvDate), new Double("0"));
                    isFirstIn = false;
                } else {
                    this.cfPayArr.set(startIndex, new Double("0"));
                }
                sumTmp = sumTmp.add(new BigDecimal(npvValue));
                detailEntryInfo.setCalculationValue(npvValue);
                detailEntryInfo.setCalculationFormula(rowNameArrays[i] + ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"72_NLMAssetCalculationDetailControllerBean", (Locale)ctx.getLocale()));
                String string = ppColValue = this.faLeaseInBillNewInfo.isIsDeductible() ? String.valueOf(this.ppCol.get(tmpInt - 1).getPaymentWithoutTax()) : String.valueOf(this.ppCol.get(tmpInt - 1).getPaymentWithTax());
                if (this.ppCol.get(tmpInt) != null || this.ppCol.size() == 1) {
                    if (tmpInt == this.ppIndexNumber + 1) {
                        Date tmpDate = this.ppCol.get(tmpInt - 1).getPayDate();
                        detailEntryInfo.setCalculationProcess(ppColValue + " / (1 + " + discountRateForDay + ") ^ " + (this.subDate(tmpDate, this.npvDate) + 1));
                    } else {
                        detailEntryInfo.setCalculationProcess(ppColValue + " / (1 + " + discountRateForDay + ") ^ " + (startIndex + 1));
                    }
                } else {
                    detailEntryInfo.setCalculationProcess(ppColValue + " / (1 + " + discountRateForDay + ") ^ " + (this.subDate(startDate, this.npvDate) + 1));
                }
            }
            ++tmpInt;
        }
        if (this.ppCol.size() != 0) {
            initialAssetCalculation.append(" + (").append(this.formatBD4Save(new BigDecimal(sumTmp.toString()), this.amountScale)).append(" * ").append(this.exchangeRateInfo).append(")");
        }
        detailEntryCollection.get(0).setCalculationProcess(initialAssetCalculation.toString());
        return detailEntryCollection;
    }

    private BOSUuid getNLMAssetCalcIdByBillId(Context ctx, IObjectPK billId) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("leaseInBill.id", (Object)billId));
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        view.setFilter(filter);
        NLMAssetCalculationDetailCollection col = this.getNLMAssetCalculationDetailCollection(ctx, view);
        if (col.size() <= 0) {
            return null;
        }
        return col.get(0).getId();
    }

    private FaLeaseInBillNewInfo getLeaseInBill(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("contractCat.id");
        sic.add("contractCat.name");
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("company.id");
        sic.add("company.name");
        sic.add("company.baseCurrency.precision");
        sic.add("paymentEntry.*");
        sic.add("exchangeRate.*");
        sic.add("exchangeRate.exchangeAux.*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString()));
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("paymentEntry.payDate"));
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        view.setFilter(filter);
        view.setSorter(sorter);
        FaLeaseInBillNewCollection col = FaLeaseInBillNewFactory.getLocalInstance(ctx).getFaLeaseInBillNewCollection(view);
        if (col.size() < 0) {
            return null;
        }
        return col.get(0);
    }

    private double BD2db(BigDecimal bd) {
        return bd == null ? new Double("0").doubleValue() : bd.doubleValue();
    }

    private int subDate(Date date1, Date date2) {
        Calendar cld1 = Calendar.getInstance();
        Calendar cld2 = Calendar.getInstance();
        cld1.setTime(date1);
        cld2.setTime(date2);
        cld1.set(cld1.get(1), cld1.get(2), cld1.get(5), 0, 0, 0);
        cld2.set(cld2.get(1), cld2.get(2), cld2.get(5), 0, 0, 0);
        return (int)((cld1.getTimeInMillis() - cld2.getTimeInMillis()) / 86400000L);
    }

    private int getFirstImpDateIndex(FaPaymentPlanNewCollection ppCol, FaLeaseInBillNewInfo billInfo) {
        int index = -1;
        for (int i = 0; i < ppCol.size(); ++i) {
            if (ppCol.get(i).getPayDate().compareTo(billInfo.getDpInitCfmDate()) < 0) continue;
            index = i;
            break;
        }
        return index;
    }

    private double calcPWOT(double pwt, double taxRate) {
        return new BigDecimal(pwt / (new Double("1") + taxRate / new Double("100"))).setScale((int)this.originScale, 4).doubleValue();
    }

    private Date nextDate(Date curDate) {
        Calendar curCld = Calendar.getInstance();
        Calendar nxtCld = Calendar.getInstance();
        curCld.setTime(curDate);
        nxtCld.setTimeInMillis(curCld.getTimeInMillis() + 86400000L);
        return nxtCld.getTime();
    }

    private double irr(List<Double> cfPayArr, double iLB, double guess) {
        double[] income = new double[cfPayArr.size() + 1];
        income[0] = -iLB;
        for (int i = 1; i < cfPayArr.size() + 1; ++i) {
            income[i] = cfPayArr.get(i - 1);
        }
        return Irr.irr((double[])income, (double)guess);
    }

    private CompanyOrgUnitInfo getCurrentCompany(Context ctx) throws BOSException, EASBizException {
        if (this.curCompany == null) {
            String companyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
            this.curCompany = this.getCompanyById(companyID, ctx);
        }
        return this.curCompany;
    }

    private CompanyOrgUnitInfo getCompanyById(String companyID, Context ctx) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("basecurrency.precision"));
        sic.add(new SelectorItemInfo("isbizunit"));
        sic.add(new SelectorItemInfo("accountTable"));
        return CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID), sic);
    }

    private BigDecimal calcRealDiscountRate(FaLeaseInBillNewInfo billInfo, boolean isOldValue) {
        int interestCalcMethod;
        BigDecimal iLB;
        double npv;
        double irr;
        double discountRate = isOldValue ? (irr = Double.isNaN(irr = this.irr(this.cfPayArr, npv = (iLB = billInfo.getInitialLiability().subtract(billInfo.getUnrecognizedFinanceFee())).doubleValue(), new Double("0"))) ? new Double("0") : irr) : ((interestCalcMethod = billInfo.getInterestCalculationMethod().getValue()) == 1 ? Math.pow(this.BD2db(billInfo.getDiscountRate()) / new Double("100") + new Double("1"), new Double("1") / new Double(YEAR_DATES)) - new Double("1") : this.BD2db(billInfo.getDiscountRate()) / new Double("100") / new Double(YEAR_DATES));
        return BigDecimal.valueOf(discountRate);
    }

    private String isNull(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return "0";
        }
        return String.valueOf(bigDecimal);
    }

    private String calcAdvPaymentNPV(FaLeaseInBillNewInfo billInfo, double dayRate, double exchangeRateInfo) {
        advancePaymentNpvExpression = new StringBuffer();
        advancePaymentNpvCalculation = new StringBuffer();
        advancePaymentNpvExpression.append(Cost_Type_Advance_Payment_NPV).append(" = ");
        if (billInfo.getCostDate1() == null || billInfo.getCostPmWithTaxOC1() == null) {
            advancePaymentNpvCalculation.append("0");
            advancePaymentNpvExpression.append("0").append(ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"73_NLMAssetCalculationDetailControllerBean", (Locale)ContextUtils.getContextFromSession().getLocale()));
            return "0";
        }
        if (billInfo.getCostDate1().compareTo(billInfo.getBeginDate()) <= 0) {
            BigDecimal tmp = billInfo.isIsDeductible() ? billInfo.getCostPmWithoutTaxOC1() : billInfo.getCostPmWithTaxOC1();
            advancePaymentNpvCalculation.append(tmp.toString()).append(" * ").append(exchangeRateInfo);
            advancePaymentNpvExpression.append(ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"74_NLMAssetCalculationDetailControllerBean", (Locale)ContextUtils.getContextFromSession().getLocale())).append(ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"75_NLMAssetCalculationDetailControllerBean", (Locale)ContextUtils.getContextFromSession().getLocale()));
            return String.valueOf(tmp.multiply(new BigDecimal(exchangeRateInfo)));
        }
        int advDates = this.subDate(billInfo.getCostDate1(), billInfo.getBeginDate()) + 1;
        BigDecimal tmp = billInfo.isIsDeductible() ? billInfo.getCostPmWithoutTaxOC1() : billInfo.getCostPmWithTaxOC1();
        advancePaymentNpvCalculation.append("(").append(tmp.toString()).append(" / (1 + ").append(dayRate).append(") ^ ").append(advDates).append(") * ").append(exchangeRateInfo);
        advancePaymentNpvExpression.append("(").append(ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"76_NLMAssetCalculationDetailControllerBean", (Locale)ContextUtils.getContextFromSession().getLocale()));
        return String.valueOf(BigDecimal.valueOf(this.BD2db(tmp) / Math.pow(new Double("1") + dayRate, advDates)).multiply(new BigDecimal(exchangeRateInfo)));
    }

    private String calcRcvNPV(FaLeaseInBillNewInfo billInfo, double dayRate, double exchangeRateInfo) {
        recoveryCostsNpvCalculation = new StringBuffer();
        recoveryCostsNpvExpression = new StringBuffer();
        recoveryCostsNpvExpression.append(Cost_Type_Recovery_Costs_NPV).append(" = ");
        double rcvNPV = 0.0;
        double rcvNPVTmp = 0.0;
        int subDates = 0;
        if (billInfo.getCostPmWithTaxOC6() != null) {
            subDates = this.subDate(billInfo.getCostDate6(), billInfo.getBeginDate()) + 1;
            rcvNPVTmp = new Double(this.faLeaseInBillNewInfo.isIsDeductible() ? this.isNull(billInfo.getCostPmWithoutTaxOC6()) : this.isNull(billInfo.getCostPmWithTaxOC6()));
            rcvNPV = this.calcCostNPV(rcvNPVTmp, dayRate, subDates) * exchangeRateInfo;
        }
        recoveryCostsNpvCalculation.append("(").append(rcvNPVTmp == 0.0 ? "0" : Double.valueOf(rcvNPVTmp)).append(" / (1 + ").append(BigDecimal.valueOf(dayRate)).append(") ^ ").append(subDates).append(") * ").append(exchangeRateInfo);
        recoveryCostsNpvExpression.append(ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"77_NLMAssetCalculationDetailControllerBean", (Locale)ContextUtils.getContextFromSession().getLocale()));
        return String.valueOf(rcvNPV == 0.0 ? "0" : Double.valueOf(rcvNPV));
    }

    private double calcCostNPV(double cost, double periodDiscountRate, int timeCycle) {
        return cost / Math.pow(new Double("1") + periodDiscountRate, timeCycle);
    }

    private BigDecimal formatBD4Save(BigDecimal bd, int saveScale) {
        if (bd != null) {
            bd = bd.setScale(saveScale, 4);
        }
        return bd;
    }

    private String isZero(double number) {
        if (number == 0.0) {
            return "0";
        }
        return String.valueOf(number);
    }

    private String calcNPV(double discountRate, List<Double> cfPayArr, int startIndex, int endIndex) {
        double[] cfArr = new double[endIndex - startIndex];
        for (int i = startIndex; i < endIndex; ++i) {
            cfArr[i - startIndex] = cfPayArr.get(i);
        }
        return String.valueOf(FinanceLib.npv((double)discountRate, (double[])cfArr));
    }
}

