/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.rpt.FaCreateTempTableResult;
import com.kingdee.eas.fi.fa.rpt.FaDBUtil;
import com.kingdee.eas.fi.fa.rpt.FaDBUtilConfig;
import com.kingdee.eas.fi.fa.rpt.app.FaRptLocalUtils;
import com.kingdee.eas.fi.fa.rpt.app.dao.FaDaoBase;
import com.kingdee.eas.fi.nlm.FaContractCatInfo;
import com.kingdee.eas.fi.nlm.model.FaLeaseInNewStatusRptObject;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class FaLeaseInNewStatusDao
extends FaDaoBase {
    private static final Logger logger = Logger.getLogger(FaLeaseInNewStatusDao.class);
    private String sumSql;
    private String select;
    private int beginDateFrom;
    private int beginDateTo;
    private String companyID;
    private FaContractCatInfo contractCat;
    private CostCenterOrgUnitInfo costCenter;
    private AdminOrgUnitInfo useDepartment;
    private boolean expired;
    private boolean expireNG;
    private boolean expireALL;
    private boolean exempted;
    private boolean exemptNG;
    private boolean exemptALL;
    private boolean companyGroup;
    private boolean currencyGroup;
    private boolean lessorTypeGroup;
    private boolean lessorGroup;
    private int tempTableTotal;
    private boolean includeTerminateBill;
    private boolean includeChangeBill;

    public void init(Context ctx, EntityViewInfo ev) throws EASBizException, BOSException {
        this.ctx = ctx;
        FaRptLocalUtils.chgNumberKeyWord((EntityViewInfo)ev);
        this.fName = "FName_" + ctx.getLocale().toString();
        this.fDisplayName = "FDisplayName_" + ctx.getLocale().toString();
        this.currCompanyInfo = this.getRptCompany(ctx, ev);
        this.isVirCompany = !this.currCompanyInfo.isIsBizUnit();
        this.setProperCurPeriod(ctx);
        this.initEvVar(ev);
        if (this.isCreateTempTable()) {
            this.tempTable = this.getProperTempTable(ctx);
        }
        this.filter = this.buildFilterSql(ev);
        this.sorter = this.buildSorterSql(ev);
        if (this.isCreateTempTable()) {
            this.sorter = this.sorter == null || this.sorter.equals("") ? "FID" : this.sorter + "FID";
        }
    }

    protected void initEvVar(EntityViewInfo ev) throws EASBizException, BOSException {
        super.initEvVar(ev);
        Map m = (Map)ev.get("customcond");
        this.beginDateFrom = (Integer)m.get("beginDateFrom");
        this.beginDateTo = (Integer)m.get("beginDateTo");
        this.companyID = (String)m.get("def_company_id");
        this.contractCat = (FaContractCatInfo)m.get("contractCat");
        this.costCenter = (CostCenterOrgUnitInfo)m.get("costCenter");
        this.useDepartment = (AdminOrgUnitInfo)m.get("useDepartment");
        this.expired = (Boolean)m.get("expired");
        this.expireNG = (Boolean)m.get("expireNG");
        this.expireALL = (Boolean)m.get("expireALL");
        this.exempted = (Boolean)m.get("exempted");
        this.exemptNG = (Boolean)m.get("exemptNG");
        this.exemptALL = (Boolean)m.get("exemptALL");
        this.companyGroup = (Boolean)m.get("companyGroup");
        this.currencyGroup = (Boolean)m.get("currencyGroup");
        this.lessorTypeGroup = (Boolean)m.get("lessorTypeGroup");
        this.lessorGroup = (Boolean)m.get("lessorGroup");
        this.includeTerminateBill = (Boolean)m.get("includeTerminateBill");
        this.includeChangeBill = (Boolean)m.get("includeChangeBill");
    }

    public Map getResult() throws BOSException {
        this.buildSql();
        this.buildData();
        this.resultSql.setFrom(this.tempTable);
        this.resultSql.setSecondTable(this.scTempTable);
        this.dropTable(this.acctAsstTableName);
        this.acctAsstTableName = null;
        this.result.put("sumOption", this.sumOption);
        this.result.put("resultSql", this.resultSql);
        this.result.put("tempTableName", this.tempTable);
        this.result.put("sumColumnName", null);
        this.result.put("tempTableTotal", this.tempTableTotal);
        this.clearInnerTempTable();
        return this.result;
    }

    protected void buildSql() throws BOSException {
        this.select = this.getSelectResultSql();
        this.buildResultSql();
    }

    protected void buildData() throws BOSException {
        this.addDataTempTable(FaLocalUtils.transformLocal((Context)this.ctx, (String)this.buildQueryLeaseStatusSQL()));
        this.updateDataTempTable();
        this.removeDataTempTable();
    }

    private void updateDataTempTable() throws BOSException {
        StringBuilder updateSql = new StringBuilder();
        updateSql.append(" UPDATE ").append(this.tempTable).append(" \n").append(" SET WHOLEPROCESSASSET = INITIALASSET, WHOLEPROCESSLIABILITY = INITIALLIABILITY, WHOLEPROCESSUFF = UNRECOGNIZEDFINANCEFEE \n").append(" WHERE SOURCETYPE = 0 \n");
        DbUtil.execute((Context)this.ctx, (String)updateSql.toString());
    }

    private void removeDataTempTable() throws BOSException {
        try {
            IRowSet rs;
            HashSet<String> removeID = new HashSet<String>();
            if (!this.includeTerminateBill) {
                StringBuilder terminateBillSql = new StringBuilder();
                terminateBillSql.append(" select tmp.FID billID from ").append(this.tempTable).append(" tmp \n");
                terminateBillSql.append(" left join T_FA_FaTerminateBillEntry terEntry on tmp.FID = terEntry.FLeaseInBillID \n");
                terminateBillSql.append(" left join T_FA_FaTerminateBill ter on ter.FID = terEntry.FBillID \n");
                terminateBillSql.append(" left join T_BD_Period period on ter.FPeriodID = period.FID \n");
                terminateBillSql.append(" where tmp.BIZTYPE = '5' and period.FNumber <= ").append(this.beginDateTo).append(" \n");
                rs = DbUtil.executeQuery((Context)this.ctx, (String)terminateBillSql.toString());
                while (rs.next()) {
                    removeID.add(rs.getString("billID"));
                }
            }
            if (!this.includeChangeBill) {
                StringBuilder changeBillSql = new StringBuilder();
                changeBillSql.append(" select tmp.FID billID from ").append(this.tempTable).append(" tmp \n");
                changeBillSql.append(" left join T_FA_FaNLMChangeAssetItem nlmChange on tmp.FID = nlmChange.FLeaseInBillOldID \n");
                changeBillSql.append(" left join T_FA_FaLeaseInBillNew newBill on newBill.FID = nlmChange.FLeaseInBillNewID \n");
                changeBillSql.append(" left join T_BD_Period period on newBill.FPeriodID = period.FID \n");
                changeBillSql.append(" where tmp.BIZTYPE = '7' and period.FNumber <= ").append(this.beginDateTo).append(" \n");
                rs = DbUtil.executeQuery((Context)this.ctx, (String)changeBillSql.toString());
                while (rs.next()) {
                    removeID.add(rs.getString("billID"));
                }
            }
            if (removeID.size() > 0) {
                StringBuilder removeSql = new StringBuilder();
                removeSql.append(" delete from ").append(this.tempTable).append(" \n");
                removeSql.append(" where FID in ( ");
                for (String billID : removeID) {
                    removeSql.append("'").append(billID).append("',");
                }
                removeSql.deleteCharAt(removeSql.length() - 1);
                removeSql.append(" )");
                this.tempTableTotal -= removeID.size();
                DbUtil.execute((Context)this.ctx, (String)removeSql.toString());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String buildQueryLeaseStatusSQL() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT * FROM (");
        sql.append(" SELECT  ");
        sql.append(this.getLeaseStatusSelectSql());
        sql.append(" FROM ").append(this.getJoinSql());
        sql.append(" WHERE ").append(this.getCondSql());
        sql.append(") t ");
        if (this.filter != null) {
            sql.append(" WHERE ").append(this.filter);
        }
        return sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String addDataTempTable(String sql) throws BOSException {
        sql = "select * into " + this.tempTable + " from (" + sql + ") as tempTable ";
        Connection con = null;
        try {
            con = EJBFactory.getConnection((Context)this.ctx);
            FaCreateTempTableResult result = FaDBUtil.executeSelectInto((Context)this.ctx, (String)FaLocalUtils.transformLocal((Context)this.ctx, (String)sql), (SqlParams)this.params, (Connection)con, (FaDBUtilConfig)this.cf);
            this.tempTableTotal = result.getSuccessNum();
            this.tempTable = result.getTempTable();
        }
        catch (Exception exc) {
            try {
                throw new BOSException("Sql execute exception : " + this.params.getSqlWithParams(sql), (Throwable)exc);
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        return this.tempTable;
    }

    private String getLeaseStatusSelectSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" FALEASEINBILLNEW.FID AS FID,");
        sql.append(" COMPANY.FName_l2 AS COMPANY,");
        sql.append(" CURRENCY.FName_" + this.ctx.getLocale().toString() + " AS CURRENCY,");
        sql.append(ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"5_FaLeaseInNewStatusDao", (Locale)this.ctx.getLocale()));
        sql.append(" ((CASE  WHEN (SUPPLIERLESSOR.FName_l2 IS NULL) THEN N'' ELSE SUPPLIERLESSOR.FName_l2 END || CASE  WHEN (INNERCOMPANYLESSOR.FName_l2 IS NULL) THEN N'' ELSE INNERCOMPANYLESSOR.FName_l2 END) || CASE  WHEN (CUSTOMERLESSOR.FName_l2 IS NULL) THEN N'' ELSE CUSTOMERLESSOR.FName_l2 END) AS LESSOR,");
        sql.append(" FALEASEINBILLNEW.FLessorType as LESSORTYPENUMBER,");
        sql.append(" FALEASEINBILLNEW.FNumber AS ASSETNUMBER,");
        sql.append(" FALEASEINBILLNEW.FContractNumber AS CONTRACTNUMBER,");
        sql.append(" FALEASEINBILLNEW.FContractName AS CONTRACTNAME,");
        sql.append(" CONTRACTCAT.FNumber AS CONTRACTCATNUMBER,");
        sql.append(" CONTRACTCAT.FName_l2  AS CONTRACTCATNAME,");
        sql.append(" FALEASEINBILLNEW.FBeginRentDate AS BEGINRENTDATE,");
        sql.append(" FALEASEINBILLNEW.FBeginDate AS BEGINDATE,");
        sql.append(" FALEASEINBILLNEW.FEndDate AS ENDDATE,");
        sql.append(" FALEASEINBILLNEW.FirstPayTime AS FIRSTPAYTIME,");
        sql.append(" FALEASEINBILLNEW.FTimeCycle AS TIMECYCLE,");
        sql.append(" FALEASEINBILLNEW.FLeaseCycle AS LEASECYCLE,");
        sql.append(" FALEASEINBILLNEW.FPayFrequency AS PAYFREQUENCY,");
        sql.append(" FALEASEINBILLNEW.FTotalPayPeriod AS TOTALPAYPERIOD,");
        sql.append(" FALEASEINBILLNEW.FRentTime AS RENTTIME,");
        sql.append(" FALEASEINBILLNEW.FRentWithTax AS RENTWITHTAX,");
        sql.append(" FALEASEINBILLNEW.FRentWithoutTax AS RENTWITHOUTTAX,");
        sql.append(" FALEASEINBILLNEW.FRentWithTaxNew AS RENTWITHTAXNEW,");
        sql.append(" FALEASEINBILLNEW.FRentWithoutTaxNew AS RENTWITHOUTTAXNEW,");
        sql.append(" FALEASEINBILLNEW.FDiscountRate AS DISCOUNTRATE,");
        sql.append(" FALEASEINBILLNEW.FInitialAsset AS INITIALASSET,");
        sql.append(" FALEASEINBILLNEW.FInitialLiability AS INITIALLIABILITY,");
        sql.append(" FALEASEINBILLNEW.FUnrecognizedFinanceFee AS UNRECOGNIZEDFINANCEFEE,");
        sql.append(" FALEASEINBILLNEW.FIsExistsFreePeriod AS ISEXISTSFREEPERIOD,");
        sql.append(" FALEASEINBILLNEW.FBeginFreePeriodDate AS BEGINFREEPERIODDATE,");
        sql.append(" FALEASEINBILLNEW.FEndFreePeriodDate AS ENDFREEPERIODDATE,");
        sql.append(" COSTCENTER.FName_l2 AS COSTCENTER,");
        sql.append(" FALEASEINBILLNEW.FInvoiceType AS INVOICETYPE,");
        sql.append(" FALEASEINBILLNEW.FIsDeductible AS ISDEDUCTIBLE,");
        sql.append(" FALEASEINBILLNEW.FDescription AS DESCRIPTION,");
        sql.append(" USEDEPARTMENT.FName_l2 AS USEDEPARTMENT,");
        sql.append(" FALEASEINBILLNEW.FIsExempt AS ISEXEMPT,");
        sql.append(" FALEASEINBILLNEW.FIsExpire AS ISEXPIRE,");
        sql.append(" EXCHANGERATE.FConvertRate AS EXCHANGERATE,");
        sql.append(" FALEASEINBILLNEW.FTaxRate AS TAXRATE,");
        sql.append(" FALEASEINBILLNEW.FRecoveryCostNPV AS RECOVERYCOSTNPV,");
        sql.append(" FALEASEINBILLNEW.FAccDepOfAsset AS ACCDEPOFASSET,");
        sql.append(" FALEASEINBILLNEW.FAccUnrFinExpenses AS ACCUNRFINEXPENSES,");
        sql.append(" FALEASEINBILLNEW.FAdjustmentAsset AS ADJUSTMENTASSET,");
        sql.append(" FALEASEINBILLNEW.FAdjustmentLiability AS ADJUSTMENTLIABILITY,");
        sql.append(" FALEASEINBILLNEW.FAdjustmentUnFncFee AS ADJUSTMENTUNFNCFEE,");
        sql.append(" FALEASEINBILLNEW.FWholeProcessAsset AS WHOLEPROCESSASSET,");
        sql.append(" FALEASEINBILLNEW.FWholeProcessLiability AS WHOLEPROCESSLIABILITY,");
        sql.append(" FALEASEINBILLNEW.FWholeProcessUFF AS WHOLEPROCESSUFF,");
        sql.append(" FALEASEINBILLNEW.FBizStatus AS BIZTYPE,");
        sql.append(" FALEASEINBILLNEW.FSourceType AS SOURCETYPE");
        return sql.toString();
    }

    private String getSelectResultSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" FID,");
        sql.append(" COMPANY,");
        sql.append(" CURRENCY,");
        sql.append(" LESSORTYPE,");
        sql.append(" LESSOR,");
        sql.append(" ASSETNUMBER,");
        sql.append(" CONTRACTNUMBER,");
        sql.append(" CONTRACTNAME,");
        sql.append(" CONTRACTCATNUMBER,");
        sql.append(" CONTRACTCATNAME,");
        sql.append(" BEGINRENTDATE,");
        sql.append(" BEGINDATE,");
        sql.append(" ENDDATE,");
        sql.append(" FIRSTPAYTIME,");
        sql.append(" TIMECYCLE,");
        sql.append(" LEASECYCLE,");
        sql.append(" PAYFREQUENCY,");
        sql.append(" TOTALPAYPERIOD,");
        sql.append(" RENTTIME,");
        sql.append(" RENTWITHTAX,");
        sql.append(" RENTWITHOUTTAX,");
        sql.append(" RENTWITHTAXNEW,");
        sql.append(" RENTWITHOUTTAXNEW,");
        sql.append(" DISCOUNTRATE,");
        sql.append(" INITIALASSET,");
        sql.append(" INITIALLIABILITY,");
        sql.append(" UNRECOGNIZEDFINANCEFEE,");
        sql.append(" ISEXISTSFREEPERIOD,");
        sql.append(" BEGINFREEPERIODDATE,");
        sql.append(" ENDFREEPERIODDATE,");
        sql.append(" COSTCENTER,");
        sql.append(" INVOICETYPE,");
        sql.append(" ISDEDUCTIBLE,");
        sql.append(" DESCRIPTION,");
        sql.append(" USEDEPARTMENT,");
        sql.append(" ISEXEMPT,");
        sql.append(" ISEXPIRE,");
        sql.append(" EXCHANGERATE,");
        sql.append(" TAXRATE,");
        sql.append(" RECOVERYCOSTNPV,");
        sql.append(" ACCDEPOFASSET,");
        sql.append(" ACCUNRFINEXPENSES,");
        sql.append(" ADJUSTMENTASSET,");
        sql.append(" ADJUSTMENTLIABILITY,");
        sql.append(" ADJUSTMENTUNFNCFEE,");
        sql.append(" WHOLEPROCESSASSET,");
        sql.append(" WHOLEPROCESSLIABILITY,");
        sql.append(" WHOLEPROCESSUFF,");
        sql.append(" BIZTYPE,");
        sql.append(" SOURCETYPE");
        return sql.toString();
    }

    private void buildResultSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(this.select);
        this.resultSql.setSelect(sql.toString());
        this.resultSql.setFrom(this.tempTable);
        this.resultSql.setOrder(this.sorter);
    }

    private String getJoinSql() {
        StringBuffer sql = new StringBuffer("");
        sql.append(" T_FA_FaLeaseInBillNew AS FALEASEINBILLNEW");
        sql.append(" LEFT OUTER JOIN T_ORG_CostCenter AS COSTCENTER");
        sql.append(" ON FALEASEINBILLNEW.FCostCenterID = COSTCENTER.FID");
        sql.append(" LEFT OUTER JOIN T_FA_FAContractCat AS CONTRACTCAT");
        sql.append(" ON FALEASEINBILLNEW.FContractCatID = CONTRACTCAT.FID");
        sql.append(" LEFT OUTER JOIN T_ORG_Company AS COMPANY");
        sql.append(" ON FALEASEINBILLNEW.FCompanyID = COMPANY.FID");
        sql.append(" LEFT OUTER JOIN T_GL_Voucher AS VOUCHER");
        sql.append(" ON FALEASEINBILLNEW.FVoucher = VOUCHER.FID");
        sql.append(" LEFT OUTER JOIN T_PM_User AS CREATOR");
        sql.append(" ON FALEASEINBILLNEW.FCreatorID = CREATOR.FID");
        sql.append(" LEFT OUTER JOIN T_PM_User AS LASTUPDATEUSER");
        sql.append(" ON FALEASEINBILLNEW.FLastUpdateUserID = LASTUPDATEUSER.FID");
        sql.append(" LEFT OUTER JOIN T_FA_FaLeaseInBillEntryNew AS ENTRY");
        sql.append(" ON FALEASEINBILLNEW.FID = ENTRY.FHeadID");
        sql.append(" LEFT OUTER JOIN T_BD_ExchangeRate AS EXCHANGERATE");
        sql.append(" ON FALEASEINBILLNEW.FExchangeRateID = EXCHANGERATE.FID");
        sql.append(" LEFT OUTER JOIN T_PM_User AS AUDITOR");
        sql.append(" ON FALEASEINBILLNEW.FAuditorID = AUDITOR.FID");
        sql.append(" LEFT OUTER JOIN T_ORG_Admin AS USEDEPARTMENT");
        sql.append(" ON FALEASEINBILLNEW.FUseDepartmentID = USEDEPARTMENT.FID");
        sql.append(" LEFT OUTER JOIN T_BD_Supplier AS LESSOR");
        sql.append(" ON FALEASEINBILLNEW.FLessor = LESSOR.FID");
        sql.append(" LEFT OUTER JOIN T_BD_Currency AS CURRENCY");
        sql.append(" ON FALEASEINBILLNEW.FCurrencyID = CURRENCY.FID");
        sql.append(" LEFT OUTER JOIN T_BD_Supplier AS SUPPLIERLESSOR");
        sql.append(" ON FALEASEINBILLNEW.FSupplierLessorID = SUPPLIERLESSOR.FID");
        sql.append(" LEFT OUTER JOIN T_ORG_Company AS INNERCOMPANYLESSOR");
        sql.append(" ON FALEASEINBILLNEW.FInnerCompanyLessorID = INNERCOMPANYLESSOR.FID");
        sql.append(" LEFT OUTER JOIN T_BD_Customer AS CUSTOMERLESSOR");
        sql.append(" ON FALEASEINBILLNEW.FCustomerLessorID = CUSTOMERLESSOR.FID");
        sql.append(" LEFT OUTER JOIN T_BD_Period AS period");
        sql.append(" ON FALEASEINBILLNEW.FPeriodID = period.FID");
        return sql.toString();
    }

    private String getCondSql() {
        StringBuffer condSql = new StringBuffer();
        if (this.isVirCompany) {
            condSql.append("COMPANY.FID in (" + this.strCompanyInclude + ")");
        } else {
            condSql.append("COMPANY.FID = '" + this.companyID + "'");
        }
        condSql.append(" AND period.FNumber >= " + this.beginDateFrom);
        condSql.append(" AND period.FNumber <= " + this.beginDateTo);
        if (this.contractCat != null) {
            condSql.append(" AND CONTRACTCAT.FNUMBER ='" + this.contractCat.getNumber() + "'");
        }
        if (this.costCenter != null) {
            condSql.append(" AND COSTCENTER.FID ='" + this.costCenter.getId() + "'");
        }
        if (this.useDepartment != null) {
            condSql.append(" AND USEDEPARTMENT.FID ='" + this.useDepartment.getId() + "'");
        }
        if (this.expired) {
            condSql.append(" AND FALEASEINBILLNEW.FIsExpire='1'");
        } else if (this.expireNG) {
            condSql.append(" AND FALEASEINBILLNEW.FIsExpire='0'");
        }
        if (this.exempted) {
            condSql.append(" AND FALEASEINBILLNEW.FIsExempt='1'");
        } else if (this.exemptNG) {
            condSql.append(" AND FALEASEINBILLNEW.FIsExempt='0'");
        }
        return condSql.toString();
    }

    protected String buildFilterSql(EntityViewInfo ev) {
        FilterInfo filterInfo = ev.getFilter();
        if (filterInfo == null || filterInfo.getFilterItems() == null || filterInfo.getFilterItems().isEmpty()) {
            return null;
        }
        return filterInfo.toString();
    }

    protected String buildSorterSql(EntityViewInfo ev) {
        StringBuffer sorterSql = new StringBuffer();
        SorterItemCollection sorters = ev.getSorter();
        if (this.companyGroup) {
            sorterSql.append("company, ");
        }
        if (this.currencyGroup) {
            sorterSql.append("currency, ");
        }
        if (this.lessorTypeGroup) {
            sorterSql.append("lessorType, ");
        }
        if (this.lessorGroup) {
            sorterSql.append("lessor, ");
        }
        Map map = (Map)ev.get("selectfield");
        ArrayList selOption = (ArrayList)map.get("selOption");
        for (SorterItemInfo sorterItem : sorters) {
            boolean isSelected = this.getSelectedByFields(selOption, sorterItem);
            if (!isSelected) continue;
            sorterSql.append(sorterItem.toString() + ",");
        }
        return sorterSql.toString();
    }

    protected void setProperCurPeriod(Context ctx) throws BOSException, EASBizException {
        this.currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)this.currCompanyInfo);
    }

    protected String getCompanysInPeriod(String selectedIds, int startYear, int startNumber, int endYear, int endNumber) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT company.FID AS COMPANYID FROM T_BD_SystemStatusCtrol ssc");
        sql.append(" INNER JOIN T_BD_Period currPeriod ON ssc.FCurrentPeriodID = currPeriod.FID");
        sql.append(" INNER JOIN T_BD_Period startPeriod ON ssc.FStartPeriodID = startPeriod.FID");
        sql.append(" INNER JOIN T_ORG_Company company ON ssc.FCompanyID = company.FID");
        sql.append(" INNER JOIN T_BD_SystemStatus ss ON ss.FID = ssc.FSystemStatusID");
        sql.append(" WHERE ss.FName = ").append(2001);
        String inSql = FaDBUtil.getSplitInSql((String)selectedIds, (String)"company.FID");
        sql.append(" AND company.FID ").append(inSql);
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        StringBuffer companyIds = new StringBuffer();
        try {
            while (rs.next()) {
                companyIds.append(",").append("'").append(rs.getString("COMPANYID")).append("'");
            }
        }
        catch (SQLException e) {
            throw new BOSException("Sql execute exception : " + sql, (Throwable)e);
        }
        if (companyIds.length() == 0) {
            return "''";
        }
        return companyIds.substring(1);
    }

    private boolean getSelectedByFields(List selOption, SorterItemInfo sorterItem) {
        String sorterField = sorterItem.getPropertyName();
        for (int i = 0; i < selOption.size(); ++i) {
            FaLeaseInNewStatusRptObject flo = (FaLeaseInNewStatusRptObject)selOption.get(i);
            if (flo == null) continue;
            String selField = flo.getColumnKey();
            boolean isSelected = flo.isSelected();
            if (!sorterField.equals(selField)) continue;
            return isSelected;
        }
        return true;
    }

    public static String changeDateToString(Date curDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(curDate);
    }
}

