/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.app.dataimp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.manage.FaBillBaseCollection;
import com.kingdee.eas.fi.fa.manage.FlDataUtils;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewFactory;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.nlm.FaPaymentPlanNewFactory;
import com.kingdee.eas.fi.nlm.FaPaymentPlanNewInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class FaPaymentPlanDataImport
extends AbstractDataTransmission {
    private static final Logger logger = Logger.getLogger(FaPaymentPlanDataImport.class);
    private StringBuffer invalidMsg;
    private BigDecimal ZERO = new BigDecimal("0");
    private HashSet<String> isAlreadyDeletedSet = new HashSet();
    private HashMap<String, FaPaymentPlanNewInfo> totalMap = new HashMap();
    private HashMap<String, String> bill2PaymentPlanMap = new HashMap();
    private String leaseBillID;
    private boolean isInit = true;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return FaPaymentPlanNewFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            if (coreBaseInfo == null) {
                return;
            }
            FaLeaseInBillNewInfo faLeaseInBillNewInfo = new FaLeaseInBillNewInfo();
            faLeaseInBillNewInfo.setId(BOSUuid.read((String)this.leaseBillID));
            ((FaPaymentPlanNewInfo)coreBaseInfo).setHead(faLeaseInBillNewInfo);
            if (coreBaseInfo.getId() == null) {
                this.getController(ctx).addnew(coreBaseInfo);
                this.calculateTotal(ctx, coreBaseInfo);
            } else {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
                this.calculateTotal(ctx, coreBaseInfo);
            }
            String sql = "update T_FA_FaLeaseInBillNew set FEffectedStatus=1 where fid='" + this.leaseBillID + "'";
            DbUtil.execute((Context)ctx, (String)sql);
            if (this.isInit) {
                String sql1 = "update T_FA_FaLeaseInBillNew set FCHECKEDSTATUS=1 where fid='" + this.leaseBillID + "'";
                DbUtil.execute((Context)ctx, (String)sql1);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    private void calculateTotal(Context ctx, CoreBaseInfo coreBaseInfo) throws EASBizException, TaskExternalException, BOSException {
        FaPaymentPlanNewInfo info = (FaPaymentPlanNewInfo)coreBaseInfo;
        String headId = info.getHead().getId().toString();
        String totalId = this.bill2PaymentPlanMap.get(headId);
        FaPaymentPlanNewInfo totalInfo = this.totalMap.get(totalId);
        BigDecimal paymentWithTax = info.getPaymentWithTax();
        BigDecimal taxAmount = info.getTaxAmount();
        BigDecimal paymentWithoutTax = info.getPaymentWithoutTax();
        BigDecimal paymentWithTaxTotal = totalInfo.getPaymentWithTax().add(paymentWithTax);
        totalInfo.setPaymentWithTax(paymentWithTaxTotal);
        BigDecimal taxAmountTotal = totalInfo.getTaxAmount().add(taxAmount);
        totalInfo.setTaxAmount(taxAmountTotal);
        BigDecimal paymentWithoutTaxTotal = totalInfo.getPaymentWithoutTax().add(paymentWithoutTax);
        totalInfo.setPaymentWithoutTax(paymentWithoutTaxTotal);
        FaLeaseInBillNewInfo faLeaseInBillNewInfo = FaLeaseInBillNewFactory.getLocalInstance(ctx).getFaLeaseInBillNewInfo((IObjectPK)new ObjectUuidPK(headId));
        faLeaseInBillNewInfo.setRentWithoutTax(paymentWithoutTaxTotal);
        FaLeaseInBillNewFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(info.getHead().getId().toString()), (CoreBaseInfo)faLeaseInBillNewInfo);
        this.getController(ctx).submit((IObjectPK)new ObjectUuidPK(totalInfo.getId()), (CoreBaseInfo)totalInfo);
    }

    public CoreBaseInfo transmit(Hashtable data, Context ctx) throws TaskExternalException {
        String paymentWithTax;
        this.invalidMsg = null;
        FaPaymentPlanNewInfo info = new FaPaymentPlanNewInfo();
        String head_number = this.getValue(data, "FHead_number");
        String companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        if (head_number != null && !"".equals(head_number)) {
            try {
                String needDeleteBillId;
                FaLeaseInBillNewInfo faLeaseInBillNewInfo = (FaLeaseInBillNewInfo)FaLeaseInBillNewFactory.getLocalInstance(ctx).getValue("select id,checkedStatus,isHistory where number = '" + head_number + "' and company = '" + companyId + "'");
                if (faLeaseInBillNewInfo == null) {
                    this.appendInvalidMsg(ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"37_FaPaymentPlanDataImport", (Locale)ctx.getLocale()));
                }
                this.leaseBillID = faLeaseInBillNewInfo.getId().toString();
                if (!faLeaseInBillNewInfo.isIsHistory()) {
                    this.verifyLeaseForOverride(ctx, faLeaseInBillNewInfo);
                    this.isInit = false;
                }
                if (!this.isAlreadyDeletedSet.contains(needDeleteBillId = faLeaseInBillNewInfo.getId().toString())) {
                    try {
                        this.getController(ctx).delete(" where head.id ='" + needDeleteBillId + "'");
                        this.isAlreadyDeletedSet.add(needDeleteBillId);
                    }
                    catch (Exception ex) {
                        throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
                    }
                }
                if (!this.bill2PaymentPlanMap.containsKey(needDeleteBillId)) {
                    FaPaymentPlanNewInfo totalInfo = new FaPaymentPlanNewInfo();
                    String newBosid = BOSUuid.create((BOSObjectType)new FaPaymentPlanNewInfo().getBOSType()).toString();
                    totalInfo.setId(BOSUuid.read((String)newBosid));
                    totalInfo.setHead(faLeaseInBillNewInfo);
                    totalInfo.setRentPeriod(FlDataUtils.paymentPlanLastRow);
                    totalInfo.setPaymentWithTax(this.ZERO);
                    totalInfo.setTaxAmount(this.ZERO);
                    totalInfo.setPaymentWithoutTax(this.ZERO);
                    this.totalMap.put(newBosid, totalInfo);
                    this.bill2PaymentPlanMap.put(needDeleteBillId, newBosid);
                }
                info.setHead(faLeaseInBillNewInfo);
            }
            catch (Exception ex) {
                throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
            }
        } else {
            this.appendInvalidMsg(ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"38_FaPaymentPlanDataImport", (Locale)ctx.getLocale()));
        }
        String rentPeriod = this.getValue(data, "FRentPeriod");
        if (rentPeriod != null && !"".equals(rentPeriod)) {
            info.setRentPeriod(this.handleIntValue(rentPeriod));
        } else {
            this.appendInvalidMsg(ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"39_FaPaymentPlanDataImport", (Locale)ctx.getLocale()));
        }
        String payDate = this.getValue(data, "FPayDate");
        if (payDate != null && !"".equals(payDate)) {
            info.setPayDate(this.handleDateValue(payDate));
        }
        if ((paymentWithTax = this.getValue(data, "FPaymentWithTax")) != null && !"".equals(paymentWithTax)) {
            info.setPaymentWithTax(this.handleBigDecimalValue(paymentWithTax));
        } else {
            this.appendInvalidMsg(ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"40_FaPaymentPlanDataImport", (Locale)ctx.getLocale()));
        }
        String taxRate = this.getValue(data, "FTaxRate");
        if (taxRate != null && !"".equals(taxRate)) {
            info.setTaxRate(this.handleBigDecimalValue(taxRate));
        } else {
            this.appendInvalidMsg(ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"41_FaPaymentPlanDataImport", (Locale)ctx.getLocale()));
        }
        String taxAmount = this.getValue(data, "FTaxAmount");
        if (taxAmount != null && !"".equals(taxAmount)) {
            info.setTaxAmount(this.handleBigDecimalValue(taxAmount));
        } else {
            this.appendInvalidMsg(ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"42_FaPaymentPlanDataImport", (Locale)ctx.getLocale()));
        }
        String paymentWithoutTax = this.getValue(data, "FPaymentWithoutTax");
        if (taxAmount != null && !"".equals(taxAmount)) {
            info.setPaymentWithoutTax(this.handleBigDecimalValue(paymentWithoutTax));
        } else {
            this.appendInvalidMsg(ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"43_FaPaymentPlanDataImport", (Locale)ctx.getLocale()));
        }
        if (this.invalidMsg == null) {
            return info;
        }
        throw new TaskExternalException(this.invalidMsg.toString());
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("rentPeriod", (Object)FlDataUtils.paymentPlanLastRow, CompareType.NOTEQUALS));
        HashSet<String> headIdSet = new HashSet<String>();
        try {
            FaBillBaseCollection headInfoCollection = FaLeaseInBillNewFactory.getLocalInstance(ctx).getFaBillBaseCollection(" select id where company.id ='" + ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString() + "'");
            if (headInfoCollection != null && headInfoCollection.size() > 0) {
                for (int i = 0; i < headInfoCollection.size(); ++i) {
                    String id = headInfoCollection.get(i).getId().toString();
                    headIdSet.add(id);
                }
                filter.getFilterItems().add(new FilterItemInfo("head.id", headIdSet, CompareType.INCLUDE));
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.nlm.FlPaymentPlanExportQuery";
    }

    private BigDecimal handleBigDecimalValue(String value) {
        try {
            BigDecimal returnValue = new BigDecimal(value);
            return returnValue;
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.appendInvalidMsg(value + ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"8_FaExpensesDataImport", (Locale)ContextUtils.getContextFromSession().getLocale()));
            return null;
        }
    }

    private Integer handleIntValue(String value) {
        try {
            Integer renturnValue = Integer.parseInt(value);
            return renturnValue;
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.appendInvalidMsg(value + ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"9_FaExpensesDataImport", (Locale)ContextUtils.getContextFromSession().getLocale()));
            return null;
        }
    }

    private Date handleDateValue(String value) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date = sdf.parse(value);
            String dateString = sdf.format(date);
            return sdf.parse(dateString);
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.appendInvalidMsg(value + ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"10_FaExpensesDataImport", (Locale)ContextUtils.getContextFromSession().getLocale()));
            return null;
        }
    }

    protected void appendInvalidMsg(String message) {
        if (this.invalidMsg == null || this.invalidMsg.length() == 0) {
            this.invalidMsg = new StringBuffer();
            this.invalidMsg.append(message);
        } else {
            this.invalidMsg.append(message == null || message.length() == 0 ? "" : ";" + message);
        }
    }

    private String getValue(Map data, String fieldName) {
        if (data.get(fieldName) == null) {
            return null;
        }
        Object obj = ((DataToken)data.get((Object)fieldName)).data;
        return obj == null ? null : obj.toString();
    }

    private void verifyLeaseForOverride(Context ctx, FaLeaseInBillNewInfo LeaseInBillNewInfo) throws TaskExternalException {
        if (LeaseInBillNewInfo.getCheckedStatus().getValue() == 2) {
            throw new TaskExternalException(FaResUtil.getRes((String)"leaseCanImport", (Locale)ctx.getOriginLocale()));
        }
    }
}

