/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.app.faleasestrategy.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.nlm.DepreciationMethodEnum;
import com.kingdee.eas.fi.nlm.FaAmortizedCostRptEntryCollection;
import com.kingdee.eas.fi.nlm.FaAmortizedCostRptEntryInfo;
import com.kingdee.eas.fi.nlm.FaAmortizedCostRptInfo;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.nlm.FaLeaseStartDeprTimeRuleEnum;
import com.kingdee.eas.fi.nlm.FaLiabilitiesCvMethodEnum;
import com.kingdee.eas.fi.nlm.app.faleasestrategy.impl.AbstractFaAmortizedCostRptStrategy;
import com.kingdee.eas.fi.nlm.app.prc.PrcFaLeaseInNewStrategy;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.util.Date;

public class FLAmortizedCostRptAllPayStrategy
extends AbstractFaAmortizedCostRptStrategy {
    private boolean isIgnoreNLM303 = false;
    private boolean isInitBill = false;
    private boolean isDiscount2ImplDate = false;
    private boolean isEnableStockContract = false;
    private boolean isCalcAfterStartEntries = true;

    public FaAmortizedCostRptInfo calc4StockContract(Context ctx, FaLeaseInBillNewInfo billInfo, FaAmortizedCostRptInfo curACRpt, FaAmortizedCostRptEntryCollection curACERptCol) throws EASBizException, BOSException {
        this.isCalcAfterStartEntries = false;
        this.isIgnoreNLM303 = true;
        return this.calcACRData(ctx, billInfo, curACRpt, curACERptCol);
    }

    public FaAmortizedCostRptInfo calc4Adjustment(Context ctx, FaLeaseInBillNewInfo billInfo, FaAmortizedCostRptInfo curACRpt, FaAmortizedCostRptEntryCollection curACERptCol) throws EASBizException, BOSException {
        this.isCalcAfterStartEntries = false;
        this.isIgnoreNLM303 = false;
        return this.calcACRData(ctx, billInfo, curACRpt, curACERptCol);
    }

    @Override
    public FaAmortizedCostRptInfo calcACRData(Context ctx, FaLeaseInBillNewInfo billInfo, FaAmortizedCostRptInfo curACRpt, FaAmortizedCostRptEntryCollection curACERptCol) throws EASBizException, BOSException {
        this.isInitBill = PrcFaLeaseInNewStrategy.isInitBill(ctx, billInfo, null);
        this.isDiscount2ImplDate = FaManageUtils.getIntFaParamValue((Context)ctx, (String)"NLM_303", (String)billInfo.getCompany().getId().toString()) == 0;
        this.isEnableStockContract = FaManageUtils.getFaParamValue((Context)ctx, (String)"NLM_HIDE_001", (String)billInfo.getCompany().getId().toString());
        this.initField(ctx, billInfo);
        this.initPayDateAndPayArr(ctx, billInfo);
        this.calcBillNPV(this.advCf, this.cfPayArr, this.discountRate, curACRpt);
        this.calcStartEntriesMethod(ctx, billInfo, curACRpt, curACERptCol);
        if (this.isCalcAfterStartEntries) {
            double[][] entries = this.calcAfterStartEntriesUseArray(ctx, billInfo, curACRpt, curACERptCol);
            this.setEntries(ctx, billInfo, entries, this.payDateList, this.newLeasePolicy.getTranslationMethod(), curACRpt, curACERptCol);
        }
        curACRpt.put("entry", (Object)curACERptCol);
        return curACRpt;
    }

    @Override
    protected void initPayDateAndPayArr(Context ctx, FaLeaseInBillNewInfo billInfo) throws EASBizException {
        boolean isNewNextDep;
        Date endDate;
        Date beginDate = billInfo.getBeginDate();
        Date endAmortizedCostDate = endDate = billInfo.getEndDate();
        boolean bl = isNewNextDep = billInfo.getContractCat().getDepreciationPolicy() != null && billInfo.getContractCat().getDepreciationPolicy().getStartDeprTime() == FaLeaseStartDeprTimeRuleEnum.NEW_NEXT_DEP;
        if (isNewNextDep) {
            endAmortizedCostDate = FLAmortizedCostRptAllPayStrategy.nextMonth(endAmortizedCostDate);
        }
        if (this.newLeasePolicy.getTranslationMethod() == FaLiabilitiesCvMethodEnum.DAY) {
            Date curDate = this.isInitBill && !this.isIgnoreNLM303 && this.isEnableStockContract ? (beginDate.compareTo(billInfo.getDpInitCfmDate()) < 0 ? billInfo.getDpInitCfmDate() : beginDate) : beginDate;
            int subDates = this.subDate(endAmortizedCostDate, curDate);
            for (int i = 0; i < subDates + 1; ++i) {
                this.payDateList.add(curDate);
                this.cfPayArr.add(new Double("0"));
                curDate = this.nextDate(curDate);
            }
        }
    }

    @Override
    protected void calcStartEntriesMethod(Context ctx, FaLeaseInBillNewInfo billInfo, FaAmortizedCostRptInfo curACRpt, FaAmortizedCostRptEntryCollection curACERptCol) throws EASBizException, BOSException {
        BigDecimal cDpr;
        double iROUA;
        if (this.payDateList == null || this.payDateList.size() <= 0) {
            return;
        }
        Date beginDate = billInfo.getBeginDate();
        Date endDate = this.getNewEndDate(beginDate, billInfo.getTimeCycle());
        if (this.advPayDate != null) {
            FaAmortizedCostRptEntryInfo advEntry = new FaAmortizedCostRptEntryInfo();
            advEntry.setDate(this.advPayDate);
            advEntry.setCashflow(new BigDecimal(String.valueOf(this.advCf)));
            advEntry.setInitRightOfUseAsset(BigDecimal.ZERO);
            advEntry.setInitLiabilityPrincipal(BigDecimal.ZERO);
            advEntry.setInitUnCfmFncCost(BigDecimal.ZERO);
            advEntry.setInitLiabilityBalance(BigDecimal.ZERO);
            advEntry.setCurDepreciation(BigDecimal.ZERO);
            advEntry.setCurAccDepreciation(BigDecimal.ZERO);
            advEntry.setCurInterestPayment(BigDecimal.ZERO);
            advEntry.setCurAccInterestPayment(BigDecimal.ZERO);
            advEntry.setEndRightOfUseAsset(BigDecimal.ZERO);
            advEntry.setEndLiabilityPrincipal(BigDecimal.ZERO);
            advEntry.setEndUnCfmFncCost(BigDecimal.ZERO);
            advEntry.setEndLiabilityBalance(BigDecimal.ZERO);
            curACERptCol.add(advEntry);
        }
        FaAmortizedCostRptEntryInfo firstBizEntry = new FaAmortizedCostRptEntryInfo();
        firstBizEntry.setDate((Date)this.payDateList.get(0));
        firstBizEntry.setCashflow(this.formatBD4Save(this.db2BD((Double)this.cfPayArr.get(0)), this.originScale));
        firstBizEntry.setInitialAssetDecValue(billInfo.getInitialAssetDecValue());
        BigDecimal totalCf = new BigDecimal("0");
        for (Double cf : this.cfPayArr) {
            totalCf = totalCf.add(this.formatBD4Save(new BigDecimal(cf), this.originScale));
        }
        totalCf = totalCf.add(this.formatBD4Save(new BigDecimal(this.advCf), this.originScale));
        if (billInfo.isIsDeductible()) {
            billInfo.setRentWithoutTax(totalCf);
        } else {
            billInfo.setRentWithTax(totalCf);
        }
        double advNPV = this.calcAdvPaymentNPV(billInfo, this.discountRate);
        double idfCost = new Double("0");
        double riCost = new Double("0");
        double stampTaxStM = new Double("0");
        double rcvNPV = new Double("0");
        Double exchangeRateInfo = new Double(billInfo.getExchangeRateValue().toString());
        if (billInfo.getExchangeRate() != null && billInfo.getExchangeRate().getExchangeAux().getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE) {
            exchangeRateInfo = 1.0 / exchangeRateInfo;
        }
        if (!this.isInitBill || !this.isEnableStockContract || beginDate.compareTo(billInfo.getDpInitCfmDate()) >= 0) {
            idfCost = exchangeRateInfo * this.BD2db(billInfo.isIsDeductible() ? billInfo.getCostPmWithoutTax2() : billInfo.getCostPmWithTax2());
            riCost = exchangeRateInfo * this.BD2db(billInfo.isIsDeductible() ? billInfo.getCostPmWithoutTax7() : billInfo.getCostPmWithTax7());
        }
        if (billInfo.getCostPmWithTax6() != null) {
            int subDates = this.subDate(billInfo.getCostDate6(), billInfo.getBeginDate()) + 1;
            rcvNPV = exchangeRateInfo * this.BD2db(billInfo.getCostPmWithTax6());
            rcvNPV = this.calcCostNPV(rcvNPV, this.discountRate, subDates);
        }
        String updateSQL = " UPDATE T_FA_FaLeaseInBillNew SET FRECOVERYCOSTNPV = ? WHERE FID = ?";
        Object[] params = new Object[]{rcvNPV, billInfo.getId().toString()};
        DbUtil.execute((Context)ctx, (String)updateSQL, (Object[])params);
        advNPV = this.BD2db(this.formatBD4Save(new BigDecimal(advNPV), this.amountScale));
        idfCost = this.BD2db(this.formatBD4Save(new BigDecimal(idfCost), this.amountScale));
        stampTaxStM = this.BD2db(this.formatBD4Save(new BigDecimal(stampTaxStM), this.amountScale));
        rcvNPV = this.BD2db(this.formatBD4Save(new BigDecimal(rcvNPV), this.amountScale));
        riCost = this.BD2db(this.formatBD4Save(new BigDecimal(riCost), this.amountScale));
        double initialAssetDecValue = this.BD2db(billInfo.getInitialAssetDecValue());
        if (this.isInitBill && !this.isIgnoreNLM303 && this.isEnableStockContract) {
            int remainDprTimes;
            if (this.newLeasePolicy.getDepreciationMethod() == DepreciationMethodEnum.First) {
                remainDprTimes = this.subDate(endDate, billInfo.getBeginDate().compareTo(billInfo.getDpInitCfmDate()) <= 0 ? billInfo.getDpInitCfmDate() : billInfo.getBeginDate()) + 1;
            } else {
                int n = remainDprTimes = billInfo.getBeginDate().compareTo(billInfo.getDpInitCfmDate()) < 0 ? billInfo.getTimeCycle() - this.subMonth(billInfo.getDpInitCfmDate(), billInfo.getBeginDate()) : billInfo.getTimeCycle();
            }
            if (remainDprTimes > 0 && beginDate.compareTo(billInfo.getDpInitCfmDate()) < 0) {
                if (this.isDiscount2ImplDate) {
                    iROUA = this.BD2db(curACRpt.getNPV()) + advNPV;
                    iROUA *= exchangeRateInfo.doubleValue();
                    iROUA += rcvNPV;
                    iROUA -= initialAssetDecValue;
                } else {
                    iROUA = this.BD2db(billInfo.getBigDecimal("scInitialAsset")) - this.BD2db(billInfo.getBigDecimal("scInitAccDepreciation"));
                }
            } else {
                iROUA = this.BD2db(curACRpt.getNPV()) + advNPV;
                iROUA *= exchangeRateInfo.doubleValue();
                iROUA += idfCost + stampTaxStM - riCost + rcvNPV;
                iROUA -= initialAssetDecValue;
            }
            cDpr = this.formatBD4Save(this.db2BD(iROUA), this.amountScale).divide(this.db2BD(new Double(String.valueOf(remainDprTimes))), this.amountScale);
            firstBizEntry.put("remainTimeCycle", new Double(String.valueOf(remainDprTimes)));
        } else {
            iROUA = this.BD2db(curACRpt.getNPV()) + advNPV;
            iROUA *= exchangeRateInfo.doubleValue();
            iROUA += idfCost + stampTaxStM - riCost + rcvNPV;
            if (this.newLeasePolicy.getDepreciationMethod() == DepreciationMethodEnum.First) {
                double dprDateAmt = this.getDepDayCount(beginDate, billInfo.getDepEndDate());
                cDpr = this.formatBD4Save(this.db2BD(iROUA), this.amountScale).divide(this.db2BD(dprDateAmt), this.amountScale);
            } else {
                cDpr = this.formatBD4Save(this.db2BD(iROUA), this.amountScale).divide(this.db2BD(new Double(String.valueOf(billInfo.getTimeCycle()))), this.amountScale);
            }
        }
        BigDecimal iLP = this.formatBD4Save(billInfo.isIsDeductible() ? billInfo.getRentWithoutTax() : billInfo.getRentWithTax(), this.originScale).subtract(this.formatBD4Save(this.db2BD(this.advCf), this.originScale));
        BigDecimal iUCFC = this.formatBD4Save(billInfo.isIsDeductible() ? billInfo.getRentWithoutTax() : billInfo.getRentWithTax(), this.originScale).subtract(this.formatBD4Save(curACRpt.getNPV(), this.originScale));
        BigDecimal iLB = iLP.subtract(iUCFC);
        firstBizEntry.setInitRightOfUseAsset(this.formatBD4Save(this.db2BD(iROUA), this.amountScale));
        firstBizEntry.setInitLiabilityPrincipal(iLP);
        firstBizEntry.setInitUnCfmFncCost(iUCFC);
        firstBizEntry.setInitLiabilityBalance(iLB);
        BigDecimal cIP = this.formatBD4Save(iLB.multiply(this.db2BD(this.discountRate)), this.originScale);
        firstBizEntry.setCurDepreciation(this.formatBD4Save(cDpr, this.amountScale));
        firstBizEntry.setCurAccDepreciation(this.formatBD4Save(cDpr, this.amountScale));
        firstBizEntry.setCurInterestPayment(cIP);
        firstBizEntry.setCurAccInterestPayment(cIP);
        BigDecimal eROUA = this.formatBD4Save(this.db2BD(iROUA), this.amountScale).subtract(this.formatBD4Save(cDpr, this.amountScale));
        BigDecimal eLP = iLP.subtract(firstBizEntry.getCashflow());
        BigDecimal eUCFC = iUCFC.subtract(cIP);
        BigDecimal eLB = eLP.subtract(eUCFC);
        firstBizEntry.setEndRightOfUseAsset(eROUA);
        firstBizEntry.setEndLiabilityPrincipal(eLP);
        firstBizEntry.setEndUnCfmFncCost(eUCFC);
        firstBizEntry.setEndLiabilityBalance(eLB);
        curACERptCol.add(firstBizEntry);
    }

    @Override
    protected double[][] calcAfterStartEntriesUseArray(Context ctx, FaLeaseInBillNewInfo billInfo, FaAmortizedCostRptInfo curACRpt, FaAmortizedCostRptEntryCollection curACERptCol) throws BOSException, EASBizException {
        boolean isNextDepAndIsBeforeImplDate;
        boolean isDepLessThanOrEqualToLease;
        double[][] entries = new double[this.payDateList.size()][13];
        if (this.payDateList.size() <= 1) {
            return entries;
        }
        FaAmortizedCostRptEntryInfo firstEntry = curACERptCol.get(curACERptCol.size() - 1);
        boolean isDayCvMethod = this.newLeasePolicy.getTranslationMethod() == FaLiabilitiesCvMethodEnum.DAY;
        int depTimeCycle = billInfo.getTimeCycle();
        int leaseTimeCycle = this.getLeaseCycle(billInfo.getBeginDate(), billInfo.getEndDate());
        boolean bl = isDepLessThanOrEqualToLease = depTimeCycle <= leaseTimeCycle;
        int endDateIndex = isDayCvMethod && this.newLeasePolicy.getDepreciationMethod() == DepreciationMethodEnum.First ? (this.isInitBill && !this.isIgnoreNLM303 && this.isEnableStockContract && billInfo.getBeginDate().compareTo(billInfo.getDpInitCfmDate()) < 0 ? this.getDepDayCount(billInfo.getDpInitCfmDate(), billInfo.getDepEndDate()) - 1 : this.getDepDayCount(billInfo.getBeginDate(), billInfo.getDepEndDate()) - 1) : (firstEntry.get("remainTimeCycle") == null ? (depTimeCycle < leaseTimeCycle ? billInfo.getTimeCycle() - 1 : leaseTimeCycle - 1) : firstEntry.getInt("remainTimeCycle") - 1);
        int monthCount = 0;
        Date lastDate = null;
        entries[0][0] = this.BD2db(this.formatBD4Save(this.db2BD((Double)this.cfPayArr.get(1)), this.originScale));
        entries[0][1] = this.BD2db(firstEntry.getInitRightOfUseAsset());
        entries[0][2] = this.BD2db(firstEntry.getInitLiabilityPrincipal());
        entries[0][3] = this.BD2db(firstEntry.getInitUnCfmFncCost());
        entries[0][4] = this.BD2db(firstEntry.getInitLiabilityBalance());
        entries[0][5] = this.BD2db(firstEntry.getCurDepreciation());
        entries[0][6] = this.BD2db(firstEntry.getCurAccDepreciation());
        entries[0][7] = this.BD2db(firstEntry.getCurInterestPayment());
        entries[0][8] = this.BD2db(firstEntry.getCurAccInterestPayment());
        entries[0][9] = this.BD2db(firstEntry.getEndRightOfUseAsset());
        entries[0][10] = this.BD2db(firstEntry.getEndLiabilityPrincipal());
        entries[0][11] = this.BD2db(firstEntry.getEndUnCfmFncCost());
        entries[0][12] = this.BD2db(firstEntry.getEndLiabilityBalance());
        boolean isNewNextDep = billInfo.getContractCat().getDepreciationPolicy() != null && billInfo.getContractCat().getDepreciationPolicy().getStartDeprTime() == FaLeaseStartDeprTimeRuleEnum.NEW_NEXT_DEP;
        double curDepreciationTmp = this.BD2db(firstEntry.getCurDepreciation());
        boolean bl2 = isNextDepAndIsBeforeImplDate = isNewNextDep && (this.isDiscount2ImplDate || !billInfo.isIsBeforeImplDate());
        if (isNextDepAndIsBeforeImplDate && this.newLeasePolicy.getDepreciationMethod() == DepreciationMethodEnum.Second) {
            entries[0][5] = 0.0;
            firstEntry.setCurDepreciation(BigDecimal.ZERO);
            entries[0][6] = 0.0;
            firstEntry.setCurAccDepreciation(BigDecimal.ZERO);
            entries[0][9] = this.BD2db(firstEntry.getInitRightOfUseAsset());
            firstEntry.setEndRightOfUseAsset(firstEntry.getInitRightOfUseAsset());
            if (depTimeCycle < leaseTimeCycle) {
                ++endDateIndex;
            }
        }
        for (int i = 1; i < this.payDateList.size(); ++i) {
            entries[i][0] = this.BD2db(this.formatBD4Save(this.db2BD((Double)this.cfPayArr.get(i)), this.originScale));
            entries[i][1] = entries[i - 1][9];
            entries[i][2] = entries[i - 1][10];
            entries[i][3] = entries[i - 1][11];
            entries[i][4] = entries[i - 1][12];
            double cIP = i == this.payDateList.size() - 1 ? this.BD2db(firstEntry.getInitUnCfmFncCost()) - entries[i - 1][8] : (isDayCvMethod ? this.BD2db(this.formatBD4Save(this.db2BD(entries[i][4] * this.discountRate), this.originScale)) : entries[i][4] * firstEntry.getDouble("interestRate"));
            double cAIP = new Double("0");
            for (double[] entry : entries) {
                cAIP += entry[7];
            }
            cAIP += cIP;
            if (isDayCvMethod && this.newLeasePolicy.getDepreciationMethod() == DepreciationMethodEnum.Second) {
                if (lastDate == null) {
                    lastDate = (Date)this.payDateList.get(0);
                }
                if (this.compareYearMonth(lastDate, (Date)this.payDateList.get(i))) {
                    lastDate = (Date)this.payDateList.get(i);
                    if (++monthCount <= endDateIndex) {
                        entries[i][5] = isNextDepAndIsBeforeImplDate ? curDepreciationTmp : this.BD2db(firstEntry.getCurDepreciation());
                        entries[i][6] = entries[i][5] * new Double(String.valueOf(isNextDepAndIsBeforeImplDate ? monthCount : monthCount + 1));
                        if (monthCount == endDateIndex && isDepLessThanOrEqualToLease) {
                            entries[i][5] = entries[i][1];
                            entries[i][6] = entries[0][1];
                        }
                    } else if (!isDepLessThanOrEqualToLease) {
                        entries[i][5] = isNextDepAndIsBeforeImplDate ? curDepreciationTmp : this.BD2db(firstEntry.getCurDepreciation());
                        entries[i][6] = entries[i][5] * new Double(String.valueOf(isNextDepAndIsBeforeImplDate ? monthCount : monthCount + 1));
                    } else {
                        entries[i][5] = new Double("0");
                        entries[i][6] = entries[i - 1][6];
                    }
                } else {
                    entries[i][5] = new Double("0");
                    entries[i][6] = entries[i - 1][6];
                }
            } else if (i <= endDateIndex) {
                entries[i][5] = entries[i - 1][5];
                entries[i][6] = entries[i - 1][5] * new Double(String.valueOf(i + 1));
                if (i == endDateIndex && isDepLessThanOrEqualToLease) {
                    entries[i][5] = entries[i][1];
                    entries[i][6] = entries[0][1];
                }
            } else {
                entries[i][5] = new Double("0");
                entries[i][6] = entries[0][1];
            }
            entries[i][7] = cIP;
            entries[i][8] = cAIP;
            entries[i][9] = entries[i][1] - entries[i][5];
            entries[i][10] = entries[i][2] - entries[i][0];
            entries[i][11] = entries[i][3] - entries[i][7];
            entries[i][12] = entries[i][10] - entries[i][11];
        }
        return entries;
    }
}

