/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.app.faleasestrategy.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.nlm.DepreciationMethodEnum;
import com.kingdee.eas.fi.nlm.FaAmortizedCostRptEntryCollection;
import com.kingdee.eas.fi.nlm.FaAmortizedCostRptEntryInfo;
import com.kingdee.eas.fi.nlm.FaAmortizedCostRptInfo;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.nlm.FaNewLeasePolicyFactory;
import com.kingdee.eas.fi.nlm.FaNewLeasePolicyInfo;
import com.kingdee.eas.fi.nlm.FaPaymentPlanNewCollection;
import com.kingdee.eas.fi.nlm.app.faleasestrategy.impl.AbstractFaAmortizedCostRptStrategy;
import com.kingdee.eas.fi.nlm.app.prc.PrcFaLeaseInNewStrategy;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.poi.ss.formula.functions.Irr;

public class FLAmortizedCostRptStrategy
extends AbstractFaAmortizedCostRptStrategy {
    private Date endPayDate;
    private Context ctx;

    @Override
    public FaAmortizedCostRptInfo calcACRData(Context ctx, FaLeaseInBillNewInfo billInfo, FaAmortizedCostRptInfo curACRpt, FaAmortizedCostRptEntryCollection curACERptCol) throws EASBizException, BOSException {
        this.initField(ctx, billInfo);
        this.initPayDateAndPayArr(ctx, billInfo);
        this.discountRate = this.calcDiscountRate(billInfo, this.newLeasePolicy);
        this.calcBillNPV(this.advCf, this.cfPayArr, this.discountRate, curACRpt);
        this.calcStartEntriesMethod(ctx, billInfo, curACRpt, curACERptCol);
        double[][] entries = this.calcAfterStartEntriesUseArray(ctx, billInfo, curACRpt, curACERptCol);
        this.setEntries(ctx, billInfo, entries, this.payDateList, this.newLeasePolicy.getTranslationMethod(), curACRpt, curACERptCol);
        curACRpt.put("entry", (Object)curACERptCol);
        return curACRpt;
    }

    @Override
    protected void initPayDateAndPayArr(Context ctx, FaLeaseInBillNewInfo billInfo) throws EASBizException, BOSException {
        FaPaymentPlanNewCollection ppCol = billInfo.getPaymentEntry();
        if (ppCol.size() < 0) {
            String paymentEntryIsNull = FaLocalUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"paymentEntryIsNull");
            throw new EASBizException(new NumericExceptionSubItem("1", paymentEntryIsNull));
        }
        ppCol.sort("payDate");
        ppCol.removeObject(0);
        Date beginDate = billInfo.getBeginDate();
        Date endDate = billInfo.getEndDate();
        Date firstPayDate = billInfo.getFirstPayTime();
        this.endPayDate = ppCol.get(ppCol.size() - 1).getPayDate();
        Date endAmortizedCostDate = endDate.compareTo(this.endPayDate) > 0 ? endDate : this.endPayDate;
        int ppIdx = 0;
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)billInfo.getCompany());
        Calendar startPeriodDate = Calendar.getInstance();
        startPeriodDate.setTime(beginDate);
        startPeriodDate.set(startPeriod.getPeriodYear(), startPeriod.getPeriodNumber() - 1, 1, 0, 0, 0);
        Date curDate = startPeriodDate.getTime();
        if (ppCol.get(0).getPayDate().compareTo(startPeriodDate.getTime()) < 0) {
            ppIdx = this.getFirstImpDateIndex(ppCol, startPeriodDate.getTime());
        }
        if (firstPayDate.compareTo(beginDate) < 0) {
            Calendar cld = Calendar.getInstance();
            cld.setTimeInMillis(beginDate.getTime() - 86400000L);
            this.advPayDate = cld.getTime();
            for (int i = 0; i < ppCol.size() && ppCol.get(i).getPayDate().compareTo(beginDate) < 0; ++i) {
                this.advCf += billInfo.isIsDeductible() ? this.calcPWOT(this.BD2db(ppCol.get(0).getPaymentWithTax()), this.BD2db(ppCol.get(0).getTaxRate())) : this.BD2db(ppCol.get(0).getPaymentWithTax());
                ++ppIdx;
            }
        }
        int subDates = this.subDate(endAmortizedCostDate, curDate);
        for (int i = 0; i < subDates + 1; ++i) {
            this.payDateList.add(curDate);
            if (ppIdx >= 0 && ppIdx < ppCol.size() && curDate.compareTo(ppCol.get(ppIdx).getPayDate()) == 0) {
                double tmpNumber;
                double d = tmpNumber = billInfo.isIsDeductible() ? this.BD2db(ppCol.get(ppIdx).getPaymentWithoutTax()) : this.BD2db(ppCol.get(ppIdx).getPaymentWithTax());
                while (++ppIdx >= 0 && ppIdx < ppCol.size() && curDate.compareTo(ppCol.get(ppIdx).getPayDate()) == 0) {
                    double tmpNumberOne = billInfo.isIsDeductible() ? this.BD2db(ppCol.get(ppIdx).getPaymentWithoutTax()) : this.BD2db(ppCol.get(ppIdx).getPaymentWithTax());
                    tmpNumber += tmpNumberOne;
                }
                --ppIdx;
                this.cfPayArr.add(tmpNumber);
                ++ppIdx;
            } else {
                this.cfPayArr.add(new Double("0"));
            }
            curDate = this.nextDate(curDate);
        }
    }

    @Override
    protected void calcStartEntriesMethod(Context ctx, FaLeaseInBillNewInfo billInfo, FaAmortizedCostRptInfo curACRpt, FaAmortizedCostRptEntryCollection curACERptCol) {
        if (this.payDateList == null || this.payDateList.size() <= 0) {
            return;
        }
        if (this.advPayDate != null) {
            FaAmortizedCostRptEntryInfo advEntry = new FaAmortizedCostRptEntryInfo();
            advEntry.setDate(this.advPayDate);
            advEntry.setCashflow(new BigDecimal(String.valueOf(this.advCf)));
            advEntry.setInitRightOfUseAsset(BigDecimal.ZERO);
            advEntry.setInitLiabilityPrincipal(BigDecimal.ZERO);
            advEntry.setInitUnCfmFncCost(BigDecimal.ZERO);
            advEntry.setInitLiabilityBalance(BigDecimal.ZERO);
            advEntry.setCurDepreciation(BigDecimal.ZERO);
            advEntry.setCurAccDepreciation(BigDecimal.ZERO);
            advEntry.setCurInterestPayment(BigDecimal.ZERO);
            advEntry.setCurAccInterestPayment(BigDecimal.ZERO);
            advEntry.setEndRightOfUseAsset(BigDecimal.ZERO);
            advEntry.setEndLiabilityPrincipal(BigDecimal.ZERO);
            advEntry.setEndUnCfmFncCost(BigDecimal.ZERO);
            advEntry.setEndLiabilityBalance(BigDecimal.ZERO);
            curACERptCol.add(advEntry);
        }
        FaAmortizedCostRptEntryInfo firstBizEntry = new FaAmortizedCostRptEntryInfo();
        firstBizEntry.setDate((Date)this.payDateList.get(0));
        firstBizEntry.setCashflow(this.formatBD4Save(this.db2BD((Double)this.cfPayArr.get(0)), this.originScale));
        firstBizEntry.setInitialAssetDecValue(billInfo.getInitialAssetDecValue());
        BigDecimal iLP = this.formatBD4Save(billInfo.isIsDeductible() ? billInfo.getFinanceReLiabilityWithoutTax() : billInfo.getFinanceReLiabilityWithTax(), this.originScale);
        firstBizEntry.setInitLiabilityPrincipal(iLP);
        firstBizEntry.setInitUnCfmFncCost(billInfo.getFinanceReUnrFinExpenses());
        BigDecimal iLB = iLP.subtract(billInfo.getFinanceReUnrFinExpenses());
        firstBizEntry.setInitLiabilityBalance(iLB);
        BigDecimal cIP = this.formatBD4Save(iLB.multiply(this.db2BD(this.discountRate)), this.originScale);
        firstBizEntry.setCurInterestPayment(cIP);
        firstBizEntry.setCurAccInterestPayment(cIP);
        BigDecimal eLP = iLP.subtract(firstBizEntry.getCashflow());
        firstBizEntry.setEndLiabilityPrincipal(eLP);
        BigDecimal eUCFC = billInfo.getFinanceReUnrFinExpenses().subtract(cIP);
        firstBizEntry.setEndUnCfmFncCost(eUCFC);
        BigDecimal eLB = eLP.subtract(eUCFC);
        firstBizEntry.setEndLiabilityBalance(eLB);
        double iROUA = this.BD2db(billInfo.getFinanceInitialAsset().subtract(billInfo.getFinanceInitAccDepreciation()));
        double initialAssetDecValue = this.BD2db(billInfo.getInitialAssetDecValue());
        BigDecimal cDpr = this.formatBD4Save(this.db2BD(iROUA -= initialAssetDecValue), this.amountScale).divide(this.db2BD(new Double(String.valueOf(billInfo.getRemainingDepreciationPeriod()))), this.amountScale);
        firstBizEntry.setInitRightOfUseAsset(this.db2BD(iROUA));
        firstBizEntry.setCurDepreciation(this.formatBD4Save(cDpr, this.amountScale));
        firstBizEntry.setCurAccDepreciation(this.formatBD4Save(cDpr, this.amountScale));
        BigDecimal eROUA = firstBizEntry.getInitRightOfUseAsset().subtract(firstBizEntry.getCurDepreciation());
        firstBizEntry.setEndRightOfUseAsset(this.formatBD4Save(eROUA, this.amountScale));
        curACERptCol.add(firstBizEntry);
    }

    @Override
    protected double[][] calcAfterStartEntriesUseArray(Context ctx, FaLeaseInBillNewInfo billInfo, FaAmortizedCostRptInfo curACRpt, FaAmortizedCostRptEntryCollection curACERptCol) {
        double[][] entries = new double[this.payDateList.size()][13];
        if (this.payDateList.size() <= 1) {
            return entries;
        }
        FaAmortizedCostRptEntryInfo firstEntry = curACERptCol.get(curACERptCol.size() - 1);
        this.newLeasePolicy.setDepreciationMethod(DepreciationMethodEnum.Second);
        int endDateIndex = billInfo.getRemainingDepreciationPeriod() - 1;
        int monthCount = 0;
        Date lastDate = null;
        entries[0][0] = this.BD2db(this.formatBD4Save(this.db2BD((Double)this.cfPayArr.get(1)), this.originScale));
        entries[0][1] = this.BD2db(firstEntry.getInitRightOfUseAsset());
        entries[0][2] = this.BD2db(firstEntry.getInitLiabilityPrincipal());
        entries[0][3] = this.BD2db(firstEntry.getInitUnCfmFncCost());
        entries[0][4] = this.BD2db(firstEntry.getInitLiabilityBalance());
        entries[0][5] = this.BD2db(firstEntry.getCurDepreciation());
        entries[0][6] = this.BD2db(firstEntry.getCurAccDepreciation());
        entries[0][7] = this.BD2db(firstEntry.getCurInterestPayment());
        entries[0][8] = this.BD2db(firstEntry.getCurAccInterestPayment());
        entries[0][9] = this.BD2db(firstEntry.getEndRightOfUseAsset());
        entries[0][10] = this.BD2db(firstEntry.getEndLiabilityPrincipal());
        entries[0][11] = this.BD2db(firstEntry.getEndUnCfmFncCost());
        entries[0][12] = this.BD2db(firstEntry.getEndLiabilityBalance());
        for (int i = 1; i < this.payDateList.size(); ++i) {
            entries[i][0] = this.BD2db(this.formatBD4Save(this.db2BD((Double)this.cfPayArr.get(i)), this.originScale));
            entries[i][1] = entries[i - 1][9];
            entries[i][2] = entries[i - 1][10];
            entries[i][3] = entries[i - 1][11];
            entries[i][4] = entries[i - 1][12];
            double cIP = i == this.payDateList.size() - 1 ? this.BD2db(firstEntry.getInitUnCfmFncCost()) - entries[i - 1][8] : this.BD2db(this.formatBD4Save(this.db2BD(entries[i][4] * this.discountRate), this.originScale));
            double cAIP = new Double("0");
            for (double[] entry : entries) {
                cAIP += entry[7];
            }
            cAIP += cIP;
            if (lastDate == null) {
                lastDate = (Date)this.payDateList.get(0);
            }
            if (this.compareYearMonth(lastDate, (Date)this.payDateList.get(i))) {
                lastDate = (Date)this.payDateList.get(i);
                if (++monthCount <= endDateIndex) {
                    entries[i][5] = this.BD2db(firstEntry.getCurDepreciation());
                    entries[i][6] = this.BD2db(firstEntry.getCurDepreciation()) * new Double(String.valueOf(monthCount + 1));
                    if (monthCount == endDateIndex) {
                        entries[i][5] = entries[i][1];
                        entries[i][6] = entries[0][1];
                    }
                } else {
                    entries[i][5] = new Double("0");
                    entries[i][6] = entries[0][1];
                }
            } else {
                entries[i][5] = new Double("0");
                entries[i][6] = entries[i - 1][6];
            }
            entries[i][7] = cIP;
            entries[i][8] = cAIP;
            if (((Date)this.payDateList.get(i)).getTime() == this.endPayDate.getTime()) {
                entries[i][7] = entries[0][3] - entries[i - 1][8];
                entries[i][8] = entries[0][3];
            } else if (((Date)this.payDateList.get(i)).getTime() > this.endPayDate.getTime()) {
                entries[i][7] = new Double("0");
                entries[i][8] = entries[0][3];
            }
            entries[i][9] = entries[i][1] - entries[i][5];
            entries[i][10] = entries[i][2] - entries[i][0];
            entries[i][11] = entries[i][3] - entries[i][7];
            entries[i][12] = entries[i][10] - entries[i][11];
        }
        return entries;
    }

    @Override
    protected void initField(Context ctx, FaLeaseInBillNewInfo billInfo) throws EASBizException, BOSException {
        this.newLeasePolicy = FaNewLeasePolicyFactory.getLocalInstance(ctx).getEnabledNewLeasePolicy(billInfo.getCompany().getId().toString());
        this.originScale = this.getCurrencyScale(billInfo.getCurrency().getId().toString(), ctx);
        this.amountScale = this.getCurrentCompany(ctx).getBaseCurrency().getPrecision();
        this.curCompany = this.getCurrentCompany(ctx);
        this.payDateList = new ArrayList();
        this.cfPayArr = new ArrayList();
        this.advPayDate = null;
        this.advCf = new Double("0");
        this.isInitBill = PrcFaLeaseInNewStrategy.isInitBill(ctx, billInfo, null);
        this.ctx = ctx;
    }

    @Override
    protected double calcDiscountRate(FaLeaseInBillNewInfo billInfo, FaNewLeasePolicyInfo newLeasePolicy) {
        int interestCalcMethod = newLeasePolicy.getInterestCalculationMethod().getValue();
        double discountRate = interestCalcMethod == 1 ? Math.pow(this.BD2db(billInfo.getDiscountRate()) / new Double("100") + new Double("1"), new Double("1") / new Double("365")) - new Double("1") : this.BD2db(billInfo.getDiscountRate()) / new Double("100") / new Double("365");
        BigDecimal iLP = this.formatBD4Save(billInfo.isIsDeductible() ? billInfo.getFinanceReLiabilityWithoutTax() : billInfo.getFinanceReLiabilityWithTax(), this.originScale);
        BigDecimal iLB = iLP.subtract(billInfo.getFinanceReUnrFinExpenses());
        double npv = iLB.doubleValue();
        double irr = this.irr(this.cfPayArr, npv, discountRate);
        irr = Double.isNaN(irr) ? new Double("0") : irr;
        double discountRateYear = interestCalcMethod == 1 ? (Math.pow(irr + new Double("1"), new Double("365")) - new Double("1")) * new Double("100") : irr * new Double("100") * new Double("365");
        String sql = "update T_FA_FaLeaseInBillNew set FDiscountRate = " + discountRateYear + " where fid='" + billInfo.getId().toString() + "'";
        try {
            DbUtil.execute((Context)this.ctx, (String)sql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return irr;
    }

    protected int getFirstImpDateIndex(FaPaymentPlanNewCollection ppCol, Date date) {
        int index = -1;
        for (int i = 0; i < ppCol.size(); ++i) {
            if (ppCol.get(i).getPayDate().compareTo(date) < 0) continue;
            index = i;
            break;
        }
        return index;
    }

    private Date getLastDay(Date date) {
        Calendar cld = Calendar.getInstance();
        cld.setTime(date);
        cld.set(5, cld.getActualMaximum(5));
        return cld.getTime();
    }

    private double irr(List<Double> cfPayArr, double iLB, double guess) {
        double[] income = new double[cfPayArr.size() + 1];
        income[0] = -iLB;
        for (int i = 1; i < cfPayArr.size() + 1; ++i) {
            income[i] = cfPayArr.get(i - 1);
        }
        return Irr.irr((double[])income, (double)guess);
    }
}

