/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.app.flenum;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.nlm.DepreciationMethodEnum;
import com.kingdee.eas.fi.nlm.FaDepreAndAmortFactory;
import com.kingdee.eas.fi.nlm.FaDepreAndAmortInfo;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.nlm.FaLeaseStartDeprTimeRuleEnum;
import com.kingdee.eas.fi.nlm.FaLiabilitiesCvMethodEnum;
import com.kingdee.eas.fi.nlm.FaTerminateException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public enum TerminateBillForBeforeDepEnum {
    COMPLETELYL_TERMINATION{

        @Override
        public void calcNewDepreAndAmort(Context ctx, Date terminateDate, FaLeaseInBillNewInfo faLeaseInBillNewInfo, PeriodInfo tmPeriod) throws EASBizException, BOSException {
        }
    }
    ,
    EARLY_TERMINATION{

        @Override
        public void calcNewDepreAndAmort(Context ctx, Date terminateDate, FaLeaseInBillNewInfo faLeaseInBillNewInfo, PeriodInfo tmPeriod) throws EASBizException, BOSException, SQLException {
            BigDecimal[] monDeprInterest = this.calcTmMonDeprInterest(ctx, faLeaseInBillNewInfo.getId().toString(), new Timestamp(tmPeriod.getBeginDate().getTime()), new Timestamp(terminateDate.getTime()), false, true);
            BigDecimal[] beforeTmAccDeprInterest = this.calcTmMonDeprInterest(ctx, faLeaseInBillNewInfo.getId().toString(), null, new Timestamp(terminateDate.getTime()), false, false);
            this.newDepreAndAmort[2] = monDeprInterest[1];
            this.newDepreAndAmort[3] = beforeTmAccDeprInterest[1];
            if (faLeaseInBillNewInfo.getLiabilitiesCvMethod() == FaLiabilitiesCvMethodEnum.DAY && faLeaseInBillNewInfo.getDepreciationMethod() == DepreciationMethodEnum.First) {
                this.newDepreAndAmort[0] = monDeprInterest[0];
                this.newDepreAndAmort[1] = beforeTmAccDeprInterest[0];
            } else {
                boolean isNewNextDep;
                boolean bl = isNewNextDep = faLeaseInBillNewInfo.getContractCat().getDepreciationPolicy() != null && faLeaseInBillNewInfo.getContractCat().getDepreciationPolicy().getStartDeprTime() == FaLeaseStartDeprTimeRuleEnum.NEW_NEXT_DEP;
                if (isNewNextDep && faLeaseInBillNewInfo.getDepreciationMethod() == DepreciationMethodEnum.Second) {
                    FaDepreAndAmortInfo faDepreAndAmortInfo = this.getFaDepreAndAmortInfo(ctx, faLeaseInBillNewInfo.getId().toString(), tmPeriod.getId().toString());
                    this.newDepreAndAmort[0] = faDepreAndAmortInfo.getMonthlyDepreAmt();
                    this.newDepreAndAmort[1] = faDepreAndAmortInfo.getAcumDepreAmt();
                } else {
                    this.newDepreAndAmort[0] = new BigDecimal("0");
                    this.newDepreAndAmort[1] = beforeTmAccDeprInterest[0];
                }
            }
            if (this.isFirstDayOfMonth(terminateDate)) {
                this.newDepreAndAmort[0] = new BigDecimal("0");
                this.newDepreAndAmort[1] = new BigDecimal("0");
                this.newDepreAndAmort[2] = new BigDecimal("0");
                this.newDepreAndAmort[3] = new BigDecimal("0");
            }
            this.setCurPeriodNewDepreAndAmort(ctx, faLeaseInBillNewInfo.getId().toString(), tmPeriod, this.newDepreAndAmort);
        }
    }
    ,
    FULL_TERMINATION{

        @Override
        public void calcNewDepreAndAmort(Context ctx, Date terminateDate, FaLeaseInBillNewInfo faLeaseInBillNewInfo, PeriodInfo tmPeriod) throws EASBizException, BOSException {
            FaDepreAndAmortFactory.getLocalInstance(ctx).delete("where leaseInBill.id = '" + faLeaseInBillNewInfo.getId().toString() + "' and period.id = '" + tmPeriod.getId().toString() + "'");
        }
    }
    ,
    RETROSPECT_TERMINATION{

        @Override
        public void calcNewDepreAndAmort(Context ctx, Date terminateDate, FaLeaseInBillNewInfo faLeaseInBillNewInfo, PeriodInfo tmPeriod) throws EASBizException, BOSException {
            FaDepreAndAmortFactory.getLocalInstance(ctx).delete("where leaseInBill.id = '" + faLeaseInBillNewInfo.getId().toString() + "' and period.id = '" + tmPeriod.getId().toString() + "'");
        }
    };

    protected BigDecimal[] newDepreAndAmort = new BigDecimal[]{new BigDecimal("0"), new BigDecimal("0"), new BigDecimal("0"), new BigDecimal("0")};

    public abstract void calcNewDepreAndAmort(Context var1, Date var2, FaLeaseInBillNewInfo var3, PeriodInfo var4) throws EASBizException, BOSException, SQLException;

    public static TerminateBillForBeforeDepEnum getEnumAccordingToBillType(String billType) {
        TerminateBillForBeforeDepEnum[] enums;
        for (TerminateBillForBeforeDepEnum value : enums = TerminateBillForBeforeDepEnum.values()) {
            if (!billType.equals(value.name())) continue;
            return value;
        }
        return null;
    }

    protected void setCurPeriodNewDepreAndAmort(Context ctx, String leasebillID, PeriodInfo curPeriod, BigDecimal[] newDepreAndAmort) throws BOSException {
        StringBuffer updateSql = new StringBuffer();
        if (newDepreAndAmort[0] == null && newDepreAndAmort[1] == null && newDepreAndAmort[2] == null && newDepreAndAmort[3] == null) {
            updateSql.append("DELETE FROM T_FA_FaDepreAndAmort WHERE FLEASEINBILLID = ? and FPERIODID = ?");
            DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{leasebillID, curPeriod.getId().toString()});
            return;
        }
        updateSql.append("update T_FA_FaDepreAndAmort set FMonthlyDepreAmt = ?, FAcumDepreAmt = ?, FMonthlyInterestExpe = ?, FAcumInterestExpe = ? ");
        updateSql.append("where FLEASEINBILLID = ? and FPERIODID = ?");
        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{newDepreAndAmort[0], newDepreAndAmort[1], newDepreAndAmort[2], newDepreAndAmort[3], leasebillID, curPeriod.getId().toString()});
    }

    protected BigDecimal[] calcTmMonDeprInterest(Context ctx, String leaseInBillId, Timestamp beginDate, Timestamp tmDate, boolean isContainTmDate, boolean isContainBeginDate) throws BOSException, SQLException, FaTerminateException {
        BigDecimal[] resArr = new BigDecimal[2];
        IRowSet maRs = null;
        StringBuffer monthAmtSql = new StringBuffer();
        monthAmtSql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        monthAmtSql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        monthAmtSql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        monthAmtSql.append(" WHERE rpt.FLeaseInBillId = ?");
        if (beginDate != null) {
            monthAmtSql.append(" AND entry.FDate >" + (isContainBeginDate ? "= " : " ") + "?");
            monthAmtSql.append(" AND entry.FDate <" + (isContainTmDate ? "= " : " ") + "?");
            maRs = DbUtil.executeQuery((Context)ctx, (String)monthAmtSql.toString(), (Object[])new Object[]{leaseInBillId, beginDate, tmDate});
        } else {
            monthAmtSql.append(" AND entry.FDate <" + (isContainTmDate ? "= " : " ") + "?");
            maRs = DbUtil.executeQuery((Context)ctx, (String)monthAmtSql.toString(), (Object[])new Object[]{leaseInBillId, tmDate});
        }
        if (maRs.next() && maRs.getBigDecimal("monthDep") != null) {
            resArr[0] = maRs.getBigDecimal("monthDep");
            resArr[1] = maRs.getBigDecimal("monthIP");
        } else {
            resArr[0] = new BigDecimal("0");
            resArr[1] = new BigDecimal("0");
        }
        return resArr;
    }

    public boolean isFirstDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.get(5) + 1);
        return calendar.get(5) == 2;
    }

    protected FaDepreAndAmortInfo getFaDepreAndAmortInfo(Context ctx, String leaseBillID, String periodID) throws BOSException, SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT FID, FMonthlyDepreAmt, FAcumDepreAmt, FMonthlyInterestExpe, FAcumInterestExpe \n");
        sql.append(" FROM T_Fa_FaDepreAndAmort \n");
        sql.append(" WHERE FLeaseInBillId = ? AND FPeriodId = ? \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseBillID, periodID});
        FaDepreAndAmortInfo faDepreAndAmortInfo = new FaDepreAndAmortInfo();
        while (rs.next()) {
            faDepreAndAmortInfo.setId(BOSUuid.read((String)rs.getString("FID")));
            faDepreAndAmortInfo.setMonthlyDepreAmt(rs.getBigDecimal("FMonthlyDepreAmt"));
            faDepreAndAmortInfo.setAcumDepreAmt(rs.getBigDecimal("FAcumDepreAmt"));
            faDepreAndAmortInfo.setMonthlyInterestExpe(rs.getBigDecimal("FMonthlyInterestExpe"));
            faDepreAndAmortInfo.setAcumInterestExpe(rs.getBigDecimal("FAcumInterestExpe"));
        }
        return faDepreAndAmortInfo;
    }
}

