/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.app.prc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaBasicException;
import com.kingdee.eas.fi.fa.def.FaDefPropertyValueInfo;
import com.kingdee.eas.fi.fa.def.app.DefDBUtil;
import com.kingdee.eas.fi.fa.manage.AssistActItemInfo;
import com.kingdee.eas.fi.fa.manage.FaBakAsstActCompositCollection;
import com.kingdee.eas.fi.fa.manage.FaBakAsstActCompositInfo;
import com.kingdee.eas.fi.fa.manage.FaBakCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBakCostCenterFactory;
import com.kingdee.eas.fi.fa.manage.FaBakCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.FaBakDepartmentInfo;
import com.kingdee.eas.fi.fa.manage.FaBakFacilityInfo;
import com.kingdee.eas.fi.fa.manage.FaBillBaseEntityCollection;
import com.kingdee.eas.fi.fa.manage.FaBillBaseEntityInfo;
import com.kingdee.eas.fi.fa.manage.FaBillBaseInfo;
import com.kingdee.eas.fi.fa.manage.FaBillOriginEnum;
import com.kingdee.eas.fi.fa.manage.FaBillTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaBizAsstActCompositCollection;
import com.kingdee.eas.fi.fa.manage.FaBizAsstActCompositInfo;
import com.kingdee.eas.fi.fa.manage.FaBizCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBizCostCenterFactory;
import com.kingdee.eas.fi.fa.manage.FaBizCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.FaBizDepartmentInfo;
import com.kingdee.eas.fi.fa.manage.FaBizFacilityInfo;
import com.kingdee.eas.fi.fa.manage.FaBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.FaCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCardOriginEnum;
import com.kingdee.eas.fi.fa.manage.FaChangeBillInfo;
import com.kingdee.eas.fi.fa.manage.FaClearBillInfo;
import com.kingdee.eas.fi.fa.manage.FaCombinBillInfo;
import com.kingdee.eas.fi.fa.manage.FaCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaDepartmentInfo;
import com.kingdee.eas.fi.fa.manage.FaDepreciationEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillInfo;
import com.kingdee.eas.fi.fa.manage.FaEvalDepreciationEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaFacilityInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseBillInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaMonCardCollection;
import com.kingdee.eas.fi.fa.manage.FaMonCardFactory;
import com.kingdee.eas.fi.fa.manage.FaMonCardInfo;
import com.kingdee.eas.fi.fa.manage.FaSplitBillInfo;
import com.kingdee.eas.fi.fa.manage.FaStocktakingBillInfo;
import com.kingdee.eas.fi.fa.manage.IFaCurCard;
import com.kingdee.eas.fi.fa.manage.app.FaCardDefPropertyPersist;
import com.kingdee.eas.fi.fa.manage.app.FaDepORMapping;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.IBillBase;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public abstract class AbstractPrcFaManageStrategy
extends com.kingdee.eas.fi.fa.manage.app.AbstractPrcFaManageStrategy {
    long start = System.currentTimeMillis();
    long end = 0L;
    public static final String FACARDRESOURCE = "com.kingdee.eas.fi.fa.manage.FaCardResource";
    public static final int OPERATE_DELETE = 0;
    public static final int OPERATE_SAVE = 1;
    public static final int OPERATE_GENVOUCHER = 2;
    public static final int OPERATE_SUBMIT = 3;
    public static final int OPERATE_AUDIT = 4;
    public static final int OPERATE_UNAUDIT = 5;
    public static final int OPERATE_DELVOUCHER = 6;
    public static final int OPERATE_EDIT = 7;
    public static final String FROM_SOURCE = "FROM_SOURCE";
    public static final BigDecimal ZERO = new BigDecimal("0");
    private PeriodInfo curPeriod;
    private String resource = "com.kingdee.eas.fi.fa.manage.FaResource";
    private HashMap curParam;

    public abstract void deleteBill(Context var1, IObjectPK var2) throws EASBizException, BOSException;

    public abstract IObjectPK saveBill(Context var1, IObjectValue var2) throws EASBizException, BOSException;

    public abstract IObjectPK submitBill(Context var1, IObjectValue var2) throws EASBizException, BOSException;

    public abstract void auditBill(Context var1, IObjectValue var2) throws EASBizException, BOSException;

    public abstract void unAuditBill(Context var1, IObjectValue var2) throws EASBizException, BOSException;

    protected abstract void generateVourcher(Context var1, IObjectPK var2) throws EASBizException, BOSException;

    protected PeriodInfo getCurrentPeriod(Context ctx, BillBaseInfo bill) throws EASBizException, BOSException {
        if (this.curPeriod == null && bill != null && bill.getCompany() != null && bill.getCompany().getId() != null) {
            String strCompanyOrgUnitInfoID = bill.getCompany().getId().toString();
            ISystemStatusCtrol ictrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("systemStatus.name", (Object)new Integer(SystemEnum.FIXEDASSETS.getValue())));
            fic.add(new FilterItemInfo("company.id", (Object)strCompanyOrgUnitInfoID));
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("currentPeriod.periodYear"));
            sic.add(new SelectorItemInfo("currentPeriod.periodNumber"));
            sic.add(new SelectorItemInfo("currentPeriod.beginDate"));
            sic.add(new SelectorItemInfo("currentPeriod.endDate"));
            sic.add(new SelectorItemInfo("currentPeriod.isAdjustPeriod"));
            sic.add(new SelectorItemInfo("currentPeriod.periodType.id"));
            sic.add(new SelectorItemInfo("currentPeriod.periodType.CU.id"));
            sic.add(new SelectorItemInfo("currentPeriod.periodType.lastUpdateTime"));
            sic.add(new SelectorItemInfo("currentPeriod.periodType.lastUpdateUser.id"));
            sic.add(new SelectorItemInfo("currentPeriod.periodType.createTime"));
            sic.add(new SelectorItemInfo("currentPeriod.periodType.creator.id"));
            sic.add(new SelectorItemInfo("currentPeriod.periodType.simpleName"));
            sic.add(new SelectorItemInfo("currentPeriod.periodType.description"));
            sic.add(new SelectorItemInfo("currentPeriod.periodType.number"));
            sic.add(new SelectorItemInfo("currentPeriod.periodType.name"));
            SystemStatusCtrolCollection col = ictrol.getSystemStatusCtrolCollection(view);
            if (col.size() > 0) {
                this.curPeriod = col.get(0).getCurrentPeriod();
            }
        }
        return this.curPeriod == null ? new PeriodInfo() : this.curPeriod;
    }

    public void checkForEdit(Context ctx, IObjectValue val) throws EASBizException, BOSException {
        ObjectUuidPK pk;
        ObjectUuidPK objectUuidPK = pk = val.get("id") == null ? null : new ObjectUuidPK(val.get("id").toString());
        if (pk == null || pk.toString().length() == 0) {
            return;
        }
        BillBaseInfo billInfo = this.perpareBillInfo(ctx, (IObjectPK)pk);
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("DeletedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getDeletedStatus(billInfo, ctx));
        }
        if (billInfo.get("checkedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(billInfo, ctx));
        }
        if (billInfo.get("blockedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getBlockedStatus(billInfo, ctx));
        }
        if (billInfo.getBoolean("fiVouchered")) {
            sbMsg.append(" ");
            sbMsg.append(this.getIsVouchered(billInfo, ctx));
        }
        if (FaLocalUtils.isCurrencyDisable((Context)ctx, (BillBaseInfo)billInfo)) {
            sbMsg.append(" ");
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"CurrencyDisable", (Locale)ctx.getOriginLocale()));
        }
        if (sbMsg.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)FACARDRESOURCE, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append(sbMsg);
            throw new FaCardException(FaCardException.UN_SUCCESS, (Object[])new String[]{sbAll.toString()});
        }
        if (val.get("company") == null) {
            FaLocalUtils.verifyForLastestPeriod((Context)ctx, (IObjectValue)billInfo, (int)7);
        } else {
            FaLocalUtils.verifyForLastestPeriod((Context)ctx, (IObjectValue)val, (int)7);
        }
    }

    public void checkForSave(Context ctx, IObjectValue val) throws EASBizException, BOSException {
        ObjectUuidPK pk;
        ObjectUuidPK objectUuidPK = pk = val.get("id") == null ? null : new ObjectUuidPK(val.get("id").toString());
        if (pk == null || pk.toString().length() == 0) {
            return;
        }
        IBillBase iBillBase = (IBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSUuid.read((String)pk.toString()).getType());
        if (!iBillBase.exists("where id='" + pk + "'")) {
            return;
        }
        BillBaseInfo billInfo = this.perpareBillInfo(ctx, (IObjectPK)pk);
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("effectedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getEffectedStatus(billInfo, ctx));
        }
        if (billInfo.get("DeletedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getDeletedStatus(billInfo, ctx));
        }
        if (billInfo.get("blockedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getBlockedStatus(billInfo, ctx));
        }
        if (FaLocalUtils.isCurrencyDisable((Context)ctx, (BillBaseInfo)billInfo)) {
            sbMsg.append(" ");
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"CurrencyDisable", (Locale)ctx.getOriginLocale()));
        }
        if (sbMsg.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)FACARDRESOURCE, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append(sbMsg);
            throw new FaCardException(FaCardException.UN_SUCCESS, (Object[])new String[]{sbAll.toString()});
        }
        FaLocalUtils.verifyForLastestPeriod((Context)ctx, (IObjectValue)val, (int)1);
    }

    public void checkForDelete(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        FaLeaseInBillInfo leaseBillInfo;
        if (pk == null || pk.toString().length() == 0) {
            return;
        }
        BillBaseInfo billInfo = this.perpareBillInfo(ctx, pk);
        this.checkStateForDel(ctx, billInfo);
        if (billInfo instanceof FaClearBillInfo && this.getTempParam().get(FROM_SOURCE) == null) {
            FaClearBillInfo clearBillInfo = (FaClearBillInfo)billInfo;
            if (clearBillInfo.getBillType() != null) {
                if (clearBillInfo.getBillType() == FaBillOriginEnum.FROM_DISPATCH) {
                    String msg = ResourceBase.getString((String)FACARDRESOURCE, (String)"FaClearBillListUI_dispatchBillCannotBeDel", (Locale)ctx.getOriginLocale());
                    throw new FaCardException(FaCardException.CANNOT_BE_DELETED, (Object[])new String[]{msg});
                }
                if (clearBillInfo.getBillType() == FaBillOriginEnum.FROM_LEASEIN_RETURN) {
                    throw new FaCardException(FaCardException.LEASEIN_GIVEBACK_CLEARBILL_CANNOT_DEL);
                }
                if (clearBillInfo.getBillType() == FaBillOriginEnum.FROM_LEASEOUT_SALE) {
                    throw new FaCardException(FaCardException.LEASEOUT_SALE_CLEARBILL_CANNOT_DEL);
                }
            }
        } else if (billInfo instanceof FaCurCardInfo && this.getTempParam().get(FROM_SOURCE) == null) {
            FaCurCardInfo curCardInfo = (FaCurCardInfo)billInfo;
            if (curCardInfo.getOriginFlag() != null && (curCardInfo.getOriginFlag() == FaCardOriginEnum.DISPATCH || curCardInfo.getOriginFlag() == FaCardOriginEnum.STOCKTAKING || curCardInfo.getOriginFlag() == FaCardOriginEnum.LEASEIN)) {
                if (curCardInfo.getOriginFlag() == FaCardOriginEnum.DISPATCH) {
                    throw new FaCardException(FaCardException.DISPATCH_CARD_CANNOT_DEL);
                }
                if (curCardInfo.getOriginFlag() == FaCardOriginEnum.STOCKTAKING) {
                    throw new FaCardException(FaCardException.STOCKTAKING_CARD_CANNOT_DEL);
                }
                if (curCardInfo.getOriginFlag() == FaCardOriginEnum.LEASEIN) {
                    throw new FaCardException(FaCardException.LEASEIN_CARD_CANNOT_DEL);
                }
            }
        } else if (billInfo instanceof FaChangeBillInfo && this.getTempParam().get(FROM_SOURCE) == null) {
            FaChangeBillInfo changeBillInfo = (FaChangeBillInfo)billInfo;
            if (changeBillInfo.getBillType() != null) {
                if (changeBillInfo.getBillType().equals((Object)FaBillOriginEnum.FROM_LEASEOUT)) {
                    throw new FaCardException(FaCardException.LEASEOUT_AUDIT_CHANGEBILL_CANNOT_DEL);
                }
                if (changeBillInfo.getBillType().equals((Object)FaBillOriginEnum.FROM_LEASEOUT_GETBACK)) {
                    throw new FaCardException(FaCardException.LEASEOUT_GETBACK_CHANGEBILL_CANNOT_DEL);
                }
                if (changeBillInfo.getBillType().equals((Object)FaBillOriginEnum.FROM_LEASEIN_BUY)) {
                    throw new FaCardException(FaCardException.LEASEIN_BUY_CHANGEBILL_CANNOT_DEL);
                }
            }
        } else if (billInfo instanceof FaLeaseBillInfo && this.getTempParam().get(FROM_SOURCE) == null) {
            FaLeaseBillInfo leaseBillInfo2 = (FaLeaseBillInfo)billInfo;
            if (leaseBillInfo2.getBillType() != null && leaseBillInfo2.getBillType().equals((Object)FaBillOriginEnum.FROM_LEASEOUT_RELET)) {
                throw new FaCardException(FaCardException.LEASEOUT_RELET);
            }
        } else if (billInfo instanceof FaLeaseInBillInfo && this.getTempParam().get(FROM_SOURCE) == null && (leaseBillInfo = (FaLeaseInBillInfo)billInfo).getBillType() != null && leaseBillInfo.getBillType().equals((Object)FaBillOriginEnum.FROM_LEASEIN_RELET)) {
            throw new FaCardException(FaCardException.LEASEIN_RELET);
        }
        FaLocalUtils.verifyForLastestPeriod((Context)ctx, (IObjectValue)billInfo, (int)0);
    }

    protected void checkStateForDel(Context ctx, BillBaseInfo billInfo) throws FaCardException {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("checkedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(billInfo, ctx));
        }
        if (billInfo.get("blockedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getBlockedStatus(billInfo, ctx));
        }
        if (billInfo.getBoolean("fiVouchered")) {
            sbMsg.append(" ");
            sbMsg.append(this.getIsVouchered(billInfo, ctx));
        }
        if (sbMsg.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)FACARDRESOURCE, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append("[" + billInfo.getNumber() + "]");
            sbAll.append(sbMsg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_DELETED, (Object[])new String[]{sbAll.toString()});
        }
    }

    public void checkForAudit(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        if (pk == null || pk.toString().length() == 0) {
            return;
        }
        BillBaseInfo billInfo = this.perpareBillInfo(ctx, pk);
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("DeletedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getDeletedStatus(billInfo, ctx));
        }
        if (billInfo.get("EffectedStatus").equals(new Integer(1))) {
            sbMsg.append(" ");
            sbMsg.append(this.getEffectedStatus(billInfo, ctx));
        }
        if (billInfo.get("checkedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(billInfo, ctx));
        }
        if (billInfo.get("blockedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getBlockedStatus(billInfo, ctx));
        }
        if (billInfo.getBoolean("fiVouchered")) {
            sbMsg.append(" ");
            sbMsg.append(this.getIsVouchered(billInfo, ctx));
        }
        if (FaLocalUtils.isCurrencyDisable((Context)ctx, (BillBaseInfo)billInfo)) {
            sbMsg.append(" ");
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"CurrencyDisable", (Locale)ctx.getOriginLocale()));
        }
        if (sbMsg.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)FACARDRESOURCE, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append(sbMsg);
            throw new FaCardException(FaCardException.UN_SUCCESS, (Object[])new String[]{sbAll.toString()});
        }
        FaLocalUtils.verifyForLastestPeriod((Context)ctx, (IObjectValue)billInfo, (int)4);
    }

    public void checkForUnAudit(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        if (pk == null || pk.toString().length() == 0) {
            return;
        }
        BillBaseInfo billInfo = this.perpareBillInfo(ctx, pk);
        boolean isFromSource = this.getTempParam().get(FROM_SOURCE) == null ? false : (Boolean)this.getTempParam().get(FROM_SOURCE);
        StringBuffer sbMsg = new StringBuffer("");
        this.curPeriod = this.getCurrentPeriod(ctx, billInfo);
        Date bizDate = billInfo.getBizDate();
        if (billInfo instanceof FaChangeBillInfo) {
            bizDate = (Date)billInfo.get("changeDate");
        } else if (billInfo instanceof FaClearBillInfo) {
            bizDate = (Date)billInfo.get("clearDate");
        } else if (billInfo instanceof FaCurCardInfo) {
            bizDate = (Date)billInfo.get("fiAccountDate");
        } else if (billInfo instanceof FaSplitBillInfo) {
            bizDate = (Date)billInfo.get("splitDate");
        } else if (billInfo instanceof FaCombinBillInfo) {
            bizDate = (Date)billInfo.get("combinDate");
        } else if (billInfo instanceof FaDispatchBillInfo) {
            bizDate = (Date)billInfo.get("dispatchDate");
        }
        if (bizDate != null && ((bizDate = DateTimeUtils.truncateDate((Date)bizDate)).compareTo(this.curPeriod.getBeginDate()) < 0 || bizDate.compareTo(this.curPeriod.getEndDate()) > 0)) {
            sbMsg.append(" ");
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"NOT_IN_CURPERIOD", (Locale)ctx.getOriginLocale()));
        }
        if (billInfo.get("DeletedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getDeletedStatus(billInfo, ctx));
        }
        if (billInfo.get("EffectedStatus").equals(new Integer(1))) {
            sbMsg.append(" ");
            sbMsg.append(this.getEffectedStatus(billInfo, ctx));
        }
        if (billInfo.get("checkedStatus").equals(new Integer(1))) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(billInfo, ctx));
        }
        if (billInfo.get("blockedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getBlockedStatus(billInfo, ctx));
        }
        if (billInfo.getBoolean("fiVouchered")) {
            sbMsg.append(" ");
            sbMsg.append(this.getIsVouchered(billInfo, ctx));
        }
        if (billInfo instanceof FaClearBillInfo || billInfo instanceof FaCurCardInfo) {
            sbMsg.append(" ");
            sbMsg.append(this.getIsGenAnyBill(billInfo, ctx));
        }
        if (sbMsg.toString().trim().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)FACARDRESOURCE, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            String tips = billInfo instanceof FaCurCardInfo ? " " + billInfo.getNumber() + "(" + billInfo.getString("assetName") + ")" : " " + billInfo.getNumber();
            sbAll.append(tips + sbMsg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, (Object[])new String[]{"", sbAll.toString()});
        }
        this.checkForUnAudit(ctx, billInfo, isFromSource);
        FaLocalUtils.verifyForLastestPeriod((Context)ctx, (IObjectValue)billInfo, (int)5);
    }

    protected void checkForUnAudit(Context ctx, BillBaseInfo billInfo, boolean isFromSource) throws EASBizException, BOSException {
        if (billInfo instanceof FaBillBaseInfo) {
            if (((FaBillBaseInfo)billInfo).isFiVouchered()) {
                StringBuffer sbHasGenVoucher = new StringBuffer(ResourceBase.getString((String)FACARDRESOURCE, (String)"Has_GenVoucher", (Locale)ctx.getOriginLocale()));
                throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, (Object[])new String[]{"", sbHasGenVoucher.toString()});
            }
            if (!(billInfo instanceof FaSplitBillInfo) && !(billInfo instanceof FaCombinBillInfo)) {
                String entryRefName = FaManageUtils.getBillHeadEntryRelName((String)billInfo.getBOSType().toString(), (boolean)true);
                ICoreBase iCoreBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)billInfo.getBOSType());
                FaBillBaseEntityCollection entries = new FaBillBaseEntityCollection();
                String oql = "select id," + entryRefName + "." + this.getCurCardFieldName() + ".id," + entryRefName + "." + this.getCurCardFieldName() + ".lastBillID," + entryRefName + "." + this.getCurCardFieldName() + ".assetName," + entryRefName + "." + this.getCurCardFieldName() + ".number where id ='" + billInfo.getId() + "'";
                entries = (AbstractObjectCollection)iCoreBase.getValue(oql).get(entryRefName);
                for (FaBillBaseEntityInfo entry : entries) {
                    FaCurCardInfo curCard = entry.getFaCurCard();
                    if (curCard == null && billInfo instanceof FaStocktakingBillInfo || !(billInfo instanceof FaDispatchBillInfo ? (((FaDispatchBillInfo)billInfo).getFaClearBill() != null ? !curCard.getLastBillID().equals(((FaDispatchBillInfo)billInfo).getFaClearBill().getId().toString()) && !curCard.getLastBillID().equals(billInfo.getId().toString()) && !isFromSource : !curCard.getLastBillID().equals(billInfo.getId().toString()) && !isFromSource) : curCard.getLastBillID() != null && !curCard.getLastBillID().equals(billInfo.getId().toString()) && !isFromSource)) continue;
                    throw new FaCardException(FaCardException.CURCARD_HASOTHEROPRATION, (Object[])new String[]{curCard.getNumber() + "(" + curCard.getAssetName() + ")", "", FaLocalUtils.getEntityAlias((Context)ctx, (BOSObjectType)BOSUuid.getBOSObjectType((String)curCard.getLastBillID(), (boolean)false))});
                }
            }
        }
    }

    protected void check4genVoucherNew(Context ctx, IObjectPK pk, CompanyOrgUnitInfo company) throws EASBizException, BOSException, SQLException {
        String statusSql = " select count(1) as count from t_fa_facurcard where (fcaldepstatus in (0, 1) or FIsNeedReDepr = 1) and  fcompanyid ='" + company.getId().toString() + "'";
        IRowSet countSet = DbUtil.executeQuery((Context)ctx, (String)statusSql);
        while (countSet.next()) {
            int count = countSet.getInt("count");
            if (count <= 0) continue;
            throw new FaBasicException(FaBasicException.HAS_NOT_DEPCAL);
        }
        String sql = "select FFiVouchered from t_fa_fadepreciation where fid ='" + pk.toString() + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rowSet.size() == 0) {
            throw new EASBizException(EASBizException.CHECKPARENTDELETED);
        }
        while (rowSet.next()) {
            int fFiVouchered = rowSet.getInt("FFiVouchered");
            if (1 != fFiVouchered) continue;
            throw new FaBasicException(FaBasicException.HAS_VOUCHER);
        }
        if (this.curPeriod == null) {
            String strCompanyOrgUnitInfoID = company.getId().toString();
            ISystemStatusCtrol ictrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("systemStatus.name", (Object)new Integer(SystemEnum.FIXEDASSETS.getValue())));
            fic.add(new FilterItemInfo("company.id", (Object)strCompanyOrgUnitInfoID));
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("currentPeriod.periodYear"));
            sic.add(new SelectorItemInfo("currentPeriod.periodNumber"));
            sic.add(new SelectorItemInfo("currentPeriod.beginDate"));
            sic.add(new SelectorItemInfo("currentPeriod.endDate"));
            sic.add(new SelectorItemInfo("currentPeriod.isAdjustPeriod"));
            sic.add(new SelectorItemInfo("currentPeriod.periodType.id"));
            sic.add(new SelectorItemInfo("currentPeriod.periodType.CU.id"));
            sic.add(new SelectorItemInfo("currentPeriod.periodType.lastUpdateTime"));
            sic.add(new SelectorItemInfo("currentPeriod.periodType.lastUpdateUser.id"));
            sic.add(new SelectorItemInfo("currentPeriod.periodType.createTime"));
            sic.add(new SelectorItemInfo("currentPeriod.periodType.creator.id"));
            sic.add(new SelectorItemInfo("currentPeriod.periodType.simpleName"));
            sic.add(new SelectorItemInfo("currentPeriod.periodType.description"));
            sic.add(new SelectorItemInfo("currentPeriod.periodType.number"));
            sic.add(new SelectorItemInfo("currentPeriod.periodType.name"));
            SystemStatusCtrolCollection col = ictrol.getSystemStatusCtrolCollection(view);
            if (col.size() > 0) {
                this.curPeriod = col.get(0).getCurrentPeriod();
            }
        }
        PeriodInfo periodInfo = this.curPeriod == null ? new PeriodInfo() : this.curPeriod;
        this.checkUnAuditFaDep(ctx, periodInfo, company);
    }

    protected void checkForGenVoucher(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        String superiorFIComIds;
        BillBaseInfo billInfo = this.perpareBillInfo(ctx, pk);
        this.checkForOperate(ctx, billInfo, 2);
        if (billInfo != null && billInfo.getCompany() != null && billInfo.getCompany().getId() != null && (superiorFIComIds = this.getAllSuperiorFICompanyOrgUnit(ctx, billInfo.getCompany().getId().toString())) != null && superiorFIComIds.length() > 0) {
            String filter = "(" + superiorFIComIds.substring(1) + ")";
            this.resetCardAccountview(ctx, "FAccountAssetID", billInfo.getCompany().getId().toString(), filter);
            this.resetCardAccountview(ctx, "FAccountAccuDeprID", billInfo.getCompany().getId().toString(), filter);
            this.resetCardAccountview(ctx, "FAccountDecValueID", billInfo.getCompany().getId().toString(), filter);
            this.resetCostCenterAccountview(ctx, billInfo.getCompany().getId().toString(), filter);
            this.resetDepDistributeAccountview(ctx, billInfo.getCompany().getId().toString(), filter);
        }
    }

    protected void checkForOperate(Context ctx, BillBaseInfo billInfo, int opType) throws EASBizException, BOSException {
        if (2 == opType) {
            FaCurCardInfo cardInfo;
            if (billInfo instanceof FaChangeBillInfo) {
                FaChangeBillInfo changeBill = (FaChangeBillInfo)billInfo;
                if (!(changeBill.getBillType() == null || FaBillOriginEnum.FROM_STOCKTAKING.equals((Object)changeBill.getBillType()) || FaBillOriginEnum.FROM_LEASEIN_BUY.equals((Object)changeBill.getBillType()) || FaBillOriginEnum.FROM_LEASEOUT_GETBACK.equals((Object)changeBill.getBillType()) || FaBillOriginEnum.FROM_CAP.equals((Object)changeBill.getBillType()))) {
                    throw new FaCardException(FaCardException.BILL_CANNOT_OPERATE, (Object[])new String[]{changeBill.getNumber(), changeBill.getBillType().getAlias(ctx.getOriginLocale())});
                }
            } else if (billInfo instanceof FaCurCardInfo && FaCardOriginEnum.LEASEIN.equals((Object)(cardInfo = (FaCurCardInfo)billInfo).getOriginFlag())) {
                throw new FaCardException(FaCardException.BILL_CANNOT_OPERATE, (Object[])new String[]{cardInfo.getNumber(), FaCardOriginEnum.LEASEIN.getAlias(ctx.getOriginLocale())});
            }
            if (billInfo.get("DeletedStatus") == null || billInfo.get("checkedStatus") == null || billInfo.get("blockedStatus") == null || billInfo.get("fiVouchered") == null) {
                IObjectValue val = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(billInfo.getBOSType(), "select DeletedStatus,EffectedStatus,checkedStatus,blockedStatus,fiVouchered where id='" + billInfo.getId() + "'");
                billInfo.setInt("DeletedStatus", val.getInt("DeletedStatus"));
                billInfo.setInt("EffectedStatus", val.getInt("EffectedStatus"));
                billInfo.setInt("checkedStatus", val.getInt("checkedStatus"));
                billInfo.setInt("blockedStatus", val.getInt("blockedStatus"));
                billInfo.setBoolean("fiVouchered", val.getBoolean("fiVouchered"));
            }
            StringBuffer sbMsg = new StringBuffer("");
            if (billInfo.get("DeletedStatus") != null && billInfo.get("DeletedStatus").equals(new Integer(2)) && !(billInfo instanceof FaCurCardInfo)) {
                sbMsg.append(" ");
                sbMsg.append(this.getDeletedStatus(billInfo, ctx));
            }
            if (billInfo.get("EffectedStatus") != null && billInfo.get("EffectedStatus").equals(new Integer(1))) {
                sbMsg.append(" ");
                sbMsg.append(this.getEffectedStatus(billInfo, ctx));
            }
            if (billInfo.get("checkedStatus") != null && billInfo.get("checkedStatus").equals(new Integer(1))) {
                sbMsg.append(" ");
                sbMsg.append(this.getCheckedStatus(billInfo, ctx));
            }
            if (billInfo.get("blockedStatus") != null && billInfo.get("blockedStatus").equals(new Integer(2))) {
                sbMsg.append(" ");
                sbMsg.append(this.getBlockedStatus(billInfo, ctx));
            }
            if (billInfo.getBoolean("fiVouchered")) {
                sbMsg.append(" ");
                sbMsg.append(this.getIsVouchered(billInfo, ctx));
            }
            if (sbMsg.toString().length() > 0) {
                StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)FACARDRESOURCE, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
                sbAll.append(sbMsg);
                throw new FaCardException(FaCardException.CANNOT_BE_GENVOUCHER, (Object[])new String[]{sbAll.toString()});
            }
        }
    }

    protected StringBuffer getEffectedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("effectedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"EFFECTED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    protected StringBuffer getDeletedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("deletedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"DELETED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    protected StringBuffer getBlockedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("blockedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"BLOCKED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    protected StringBuffer getCheckedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("checkedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"CHECKED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    protected StringBuffer getIsVouchered(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.getBoolean("fiVouchered")) {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"ISVOUCHERED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    protected StringBuffer getIsGenAnyBill(BillBaseInfo billInfo, Context ctx) throws BOSException {
        StringBuffer sbMsg = new StringBuffer("");
        String aMsg = ResourceBase.getString((String)FACARDRESOURCE, (String)"hasGenBill", (Locale)ctx.getOriginLocale());
        StringTokenizer token = new StringTokenizer(aMsg, "!");
        String head = token.nextToken();
        String[][] destBillMsg = new String[][]{{"48DA3A71", head + token.nextToken(), EASResource.getString((String)this.resource, (String)"paymentBill")}, {"FC910EF3", head + token.nextToken(), EASResource.getString((String)this.resource, (String)"ppBill")}, {"FA44FD5B", head + token.nextToken(), EASResource.getString((String)this.resource, (String)"shouBill")}, {"40284E81", head + token.nextToken(), EASResource.getString((String)this.resource, (String)"payBill")}};
        for (int i = 0; i < 4; ++i) {
            ArrayList arrayList = BOTRelationFactory.getLocalInstance((Context)ctx).getDestObjIdByDestType(billInfo.getId().toString(), destBillMsg[i][0]);
            if (arrayList == null || arrayList.size() <= 0) continue;
            sbMsg.append(destBillMsg[i][1]);
        }
        return sbMsg;
    }

    protected BillBaseInfo perpareBillInfo(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        SelectorItemCollection sic;
        if (pk == null) {
            throw new IllegalArgumentException();
        }
        BOSUuid uuid = (BOSUuid)pk.getKeyValue("id");
        IBillBase iBillBase = (IBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)uuid.getType());
        BillBaseInfo billInfo = iBillBase.getBillBaseInfo(pk, sic = this.getStatusSelectors());
        if (billInfo == null) {
            throw new EASBizException(EASBizException.CHECKPARENTDELETED);
        }
        if (iBillBase instanceof IFaCurCard) {
            billInfo = (FaChangeBillInfo)billInfo.get("changeBill");
        }
        if (billInfo == null) {
            billInfo = iBillBase.getBillBaseInfo(pk, sic);
        }
        if (billInfo == null) {
            throw new EASBizException(EASBizException.CHECKPARENTDELETED);
        }
        if (!(billInfo instanceof FaCurCardInfo)) {
            this.checkUnAuditFaDep(ctx, this.getCurrentPeriod(ctx, billInfo), billInfo.getCompany());
        }
        return billInfo;
    }

    protected SelectorItemCollection getStatusSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    protected void checkFaCurCardValid(Context ctx, FaCardInfo curCard) throws EASBizException, BOSException {
        if (curCard == null) {
            throw new IllegalArgumentException();
        }
        if (curCard.getBizStatus() == null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)curCard.getId().toString()));
            view.setFilter(filter);
            view.getSelector().add(new SelectorItemInfo("bizStatus"));
            if (curCard instanceof FaCurCardInfo) {
                FaCurCardCollection infoCollection = FaCurCardFactory.getLocalInstance((Context)ctx).getFaCurCardCollection(view);
                curCard.setBizStatus(FaBizStatusEnum.getEnum((String)infoCollection.get(0).get("bizstatus").toString()));
            } else if (curCard instanceof FaMonCardInfo) {
                FaMonCardCollection monCardCollection = FaMonCardFactory.getLocalInstance((Context)ctx).getFaMonCardCollection(view);
                curCard.setBizStatus(FaBizStatusEnum.getEnum((String)monCardCollection.get(0).get("bizstatus").toString()));
            }
        }
        String strBizStatusAlias = curCard.getBizStatus().getAlias(ctx.getOriginLocale());
        String strBizStatusValue = curCard.getBizStatus().getValue();
        if (!(strBizStatusValue = strBizStatusValue.substring(2, 4)).equals(new String("99"))) {
            throw new FaCardException(FaCardException.CURCARD_NOTVALID, (Object[])new String[]{curCard.getNumber() + "(" + curCard.getAssetName() + ") " + strBizStatusAlias});
        }
        if (FaLeaseStatusEnum.FINANCE_LEASE_OUT.equals((Object)curCard.getLeaseStatus()) || FaLeaseStatusEnum.WORKING_LEASE_OUT.equals((Object)curCard.getLeaseStatus())) {
            int leaseStatus = curCard.getLeaseStatus().getValue();
            throw new FaCardException(FaCardException.CARDHASLEASEOUT, (Object[])new String[]{curCard.getNumber() + "(" + curCard.getAssetName() + ")", FaLeaseStatusEnum.getEnum((int)leaseStatus).getAlias(ctx.getOriginLocale())});
        }
    }

    protected void checkFaCurCardValid(Context ctx, FaCardInfo oldCard, FaCardInfo newCard) throws EASBizException, BOSException {
        if (newCard == null || oldCard == null) {
            throw new IllegalArgumentException();
        }
        this.checkFaCurCardValid(ctx, newCard);
        Timestamp oldDate = oldCard.getLastUpdateTime();
        Timestamp newDate = newCard.getLastUpdateTime();
        if (oldDate == null && newDate != null || oldDate == null && newDate != null || !((Date)oldDate).equals(newDate)) {
            throw new FaCardException(FaCardException.CARD_NOT_SYC, (Object[])new String[]{newCard.getNumber() + "(" + newCard.getAssetName() + ")"});
        }
    }

    protected void checkFaCurCardValid(Context ctx, Map cardCollection) throws EASBizException, BOSException {
        if (cardCollection == null || cardCollection.size() < 1) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select fid,flastUpdateTime,fbizstatus,fleasestatus,fassetname,fnumber ");
        sql.append(" from t_fa_facurcard where fid ");
        StringBuffer inClause = new StringBuffer("in (");
        Set cardIdSet = cardCollection.keySet();
        if (cardIdSet.size() == 0) {
            return;
        }
        Iterator iter = cardIdSet.iterator();
        while (iter.hasNext()) {
            inClause.append("'");
            inClause.append(iter.next().toString());
            inClause.append("'");
            inClause.append(",");
        }
        String cardIds = inClause.substring(0, inClause.length() - 1);
        cardIds = cardIds + ")";
        sql.append(cardIds);
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                Timestamp oldDate;
                String strBizStatusValue = rowSet.getString("fbizstatus");
                int fleasestatus = rowSet.getInt("fleasestatus");
                String strBizStatusAlias = FaBizStatusEnum.getEnum((String)strBizStatusValue).getAlias(ctx.getOriginLocale());
                String assetName = rowSet.getString("fassetname");
                String assetNumber = rowSet.getString("fnumber");
                String id = rowSet.getString("fid");
                Timestamp newDate = rowSet.getTimestamp("flastUpdateTime");
                if (!(strBizStatusValue = strBizStatusValue.substring(2, 4)).equals(new String("99"))) {
                    throw new FaCardException(FaCardException.CURCARD_NOTVALID, (Object[])new String[]{assetNumber + "(" + assetName + ") " + strBizStatusAlias});
                }
                if (0 != fleasestatus) {
                    throw new FaCardException(FaCardException.CARDHASLEASEOUT, (Object[])new String[]{assetNumber + "(" + assetName + ")", FaLeaseStatusEnum.getEnum((int)fleasestatus).getAlias(ctx.getOriginLocale())});
                }
                FaCardInfo cardInfo = (FaCardInfo)cardCollection.get(id);
                if (cardInfo == null || !((oldDate = cardInfo.getLastUpdateTime()) == null && newDate != null || oldDate != null && newDate == null) && (oldDate == null || newDate == null || ((Date)oldDate).equals(newDate))) continue;
                throw new FaCardException(FaCardException.CARD_NOT_SYC, (Object[])new String[]{assetNumber + "(" + assetName + ")"});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected Map getCardColFromEntry(IObjectCollection entryCol) {
        HashMap<String, FaCurCardInfo> result = new HashMap<String, FaCurCardInfo>();
        FaCurCardInfo card = null;
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            if (entryCol.getObject(i) == null || entryCol.getObject(i).get("faCurCard") == null || entryCol.getObject(i).get("faBizCard") != null) continue;
            card = ((FaBillBaseEntityInfo)entryCol.getObject(i)).getFaCurCard();
            result.put(card.getId().toString(), card);
        }
        return result;
    }

    protected void recycleNumber(Context ctx, BillBaseInfo caller) throws EASBizException, BOSException {
        if (caller == null) {
            return;
        }
        caller.setCU(CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select id,CU.id,CU.number,CU.name where id='" + caller.getCompany().getId() + "'").getCU());
        String strCompanyID = caller.getCompany() != null && caller.getCompany().getId() != null ? caller.getCompany().getId().toString() : ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.getCodingRule((IObjectValue)caller, strCompanyID) != null && iCodingRuleManager.isUseIntermitNumber((IObjectValue)caller, strCompanyID)) {
            iCodingRuleManager.recycleNumber((IObjectValue)caller, strCompanyID, caller.getNumber());
        }
    }

    protected void recycleNumber(Context ctx, BillBaseInfo caller, String bindingproperty, String customString) throws EASBizException, BOSException {
        if (caller == null) {
            return;
        }
        caller.setCU(CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select id,CU.id,CU.number,CU.name where id='" + caller.getCompany().getId() + "'").getCU());
        String strCompanyID = caller.getCompany() != null && caller.getCompany().getId() != null ? caller.getCompany().getId().toString() : ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.getCodingRule((IObjectValue)caller, strCompanyID, bindingproperty) != null && iCodingRuleManager.isUseIntermitNumber((IObjectValue)caller, strCompanyID, bindingproperty)) {
            iCodingRuleManager.recycleNumber((IObjectValue)caller, strCompanyID, bindingproperty, customString, caller.getNumber());
        }
    }

    public static void setBillInfoNumber(Context ctx, BillBaseInfo caller, IBillBase iBillBase) throws EASBizException, BOSException {
        String strCompanyID = caller.getCompany() != null && caller.getCompany().getId() != null ? caller.getCompany().getId().toString() : ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String number = (String)caller.get("number");
        caller.setCU(CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select id,CU.id,CU.number,CU.name where id='" + strCompanyID + "'").getCU());
        int maxCycleNum = 100;
        String filterString = "where number = '" + number + "' and company.id = '" + strCompanyID + "' " + (caller.get("id") != null ? "and id !='" + caller.get("id") + "'" : "");
        while (number == null || number.equals("") || iBillBase.exists(filterString)) {
            if (--maxCycleNum == 0) {
                throw new CodingRuleException(CodingRuleException.ERROR_REFERENCE_INVALID);
            }
            number = iCodingRuleManager.getNumber((IObjectValue)caller, strCompanyID);
            filterString = "where number = '" + number + "' and company.id = '" + strCompanyID + "' " + (caller.get("id") != null ? "and id !='" + caller.get("id") + "'" : "");
        }
        caller.setNumber(number);
    }

    protected void setNumber(Context ctx, BillBaseInfo caller, String bindingproperty, String customString) throws EASBizException, BOSException {
        if (caller == null) {
            return;
        }
        String strCompanyID = caller.getCompany() != null && caller.getCompany().getId() != null ? caller.getCompany().getId().toString() : ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        caller.setCU(CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select id,CU.id,CU.number,CU.name where id='" + caller.getCompany().getId() + "'").getCU());
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String number = null;
        number = iCodingRuleManager.getNumber((IObjectValue)caller, strCompanyID, bindingproperty, customString);
        if (number != null && !number.equals("")) {
            caller.setNumber(number);
        }
    }

    protected void updateCurCardBySQL(Context ctx, String bizStatus, String lastBillID, String curCardID) throws BOSException {
        String sql = "update T_FA_FACURCARD set fbizStatus = '" + bizStatus + "',flastBillID = " + (lastBillID == null ? "NULL" : "'" + lastBillID + "'") + ",flastupdatetime = GETDATE() where fid = '" + curCardID + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    protected void updateCurCardBySQL(Context ctx, String bizStatus, String lastBillID, String curCardID, boolean isLastPeriodChange) throws BOSException {
        String sql = "update T_FA_FACURCARD set fbizStatus = '" + bizStatus + "',flastBillID = " + (lastBillID == null ? "NULL" : "'" + lastBillID + "'") + ",FLastPeriodChange=" + (isLastPeriodChange ? 1 : 0) + ",flastupdatetime = GETDATE() where fid = '" + curCardID + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    protected HashMap getTempParam() {
        if (this.curParam == null) {
            this.curParam = new HashMap();
        }
        return this.curParam;
    }

    protected void checkUnAuditFaDep(Context ctx, PeriodInfo period, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        if (period == null || period.getId() == null || company == null || company.getId() == null) {
            return;
        }
        boolean hasNoAudit = FaDepORMapping.hasNoAudit((Context)ctx, (int)period.getPeriodYear(), (int)period.getPeriodNumber(), (String)company.getId().toString());
        if (hasNoAudit) {
            throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCal_NoAudit", (Locale)ctx.getOriginLocale()) + "," + ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCal_DoAction", (Locale)ctx.getOriginLocale())));
        }
    }

    protected void saveBizBakCard(Context ctx, String[] properties, FaBillTypeEnum billType, FaBizStatusEnum bizStatus) throws BOSException, EASBizException {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("fbilltype", new Integer(billType.getValue()));
        String selectCardId = properties[0];
        String entryTableName = properties[1];
        String billId = properties[2];
        String tempBakTableName = FaLocalUtils.createTempTable((Context)ctx, (CoreBaseInfo)new FaBakCardInfo(), null);
        String tempBizTableName = FaLocalUtils.createTempTable((Context)ctx, (CoreBaseInfo)new FaBizCardInfo(), (String)"ffacurcardid varchar(44)");
        String bakCardColumns = FaLocalUtils.getTableColumnWithComma((Context)ctx, (CoreBaseInfo)new FaBakCardInfo(), (String[])new String[]{"ffacurcardid", "fbakperiodid"});
        bakCardColumns = bakCardColumns + ",ffacurcardid,fbakperiodid";
        String selectBakCard = "select " + FaLocalUtils.getQueryColumn((Context)ctx, (CoreBaseInfo)new FaBakCardInfo(), (String[])new String[]{"ffacurcardid", "fbakperiodid"}, null, params) + ",fid as ffacurcardid,null as fbakperiodid";
        StringBuffer sql = new StringBuffer("insert into " + tempBakTableName + " (" + bakCardColumns + ") ");
        sql.append(selectBakCard + " from t_fa_facurcard where fid in(").append(selectCardId).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        String defSql = "select fpropertyValueId from " + tempBakTableName + " where fpropertyValueId is not null";
        String defUpdateSql = "update " + tempBakTableName + " set fpropertyValueId=? where fpropertyValueId=?";
        RptRowSet rs = DefDBUtil.executeQuery((String)defSql, null, (Context)ctx);
        while (rs.next()) {
            BOSUuid id = BOSUuid.read((String)rs.getString("fpropertyValueId"));
            FaDefPropertyValueInfo pv = FaCardDefPropertyPersist.copy((BOSUuid)id, (Context)ctx);
            if (pv == null) continue;
            DefDBUtil.executeUpdate((String)defUpdateSql, (SqlParams)new SqlParams().addString(pv.getId().toString()).addString(id.toString()), (Context)ctx);
        }
        String bakCardColumnsNotGenFid = "fid," + FaLocalUtils.getTableColumnWithComma((Context)ctx, (CoreBaseInfo)new FaBakCardInfo(), (String[])new String[]{"ffacurcardid", "fbakperiodid", "fid"});
        bakCardColumnsNotGenFid = bakCardColumnsNotGenFid + ",ffacurcardid,fbakperiodid";
        sql = new StringBuffer("insert into t_fa_fabakcard (" + bakCardColumnsNotGenFid + ") select " + bakCardColumnsNotGenFid + " from " + tempBakTableName);
        DbUtil.execute((Context)ctx, (String)sql.toString());
        AbstractPrcFaManageStrategy.saveCompositeEntry(ctx, tempBakTableName, "t_fa_fabakfacility", "t_fa_facurfacility", (CoreBaseInfo)new FaBakFacilityInfo(), new FaFacilityInfo().getBOSType());
        AbstractPrcFaManageStrategy.saveCompositeEntry(ctx, tempBakTableName, "t_fa_fabakcostcenter", "t_fa_facurcostcenter", (CoreBaseInfo)new FaBakCostCenterInfo(), new FaCostCenterInfo().getBOSType());
        AbstractPrcFaManageStrategy.saveCompositeEntry(ctx, tempBakTableName, "t_fa_fabakdepartment", "t_fa_facurdepartment", (CoreBaseInfo)new FaBakDepartmentInfo(), new FaDepartmentInfo().getBOSType());
        AbstractPrcFaManageStrategy.saveBakAsstActCompositNew(ctx, tempBakTableName, "T_fa_FaBakAsstActComposit", (CoreBaseInfo)new FaBakAsstActCompositInfo(), selectCardId);
        String bizCardColumns = FaLocalUtils.getTableColumnWithComma((Context)ctx, (CoreBaseInfo)new FaBizCardInfo(), (String[])new String[]{"ffabakcardid"});
        bizCardColumns = bizCardColumns + ",ffabakcardid";
        String selectBizCard = "select " + FaLocalUtils.getQueryColumn((Context)ctx, (CoreBaseInfo)new FaBizCardInfo(), (String[])new String[]{"ffabakcardid"}, (String)"A", params) + ",B.fid as ffabakcardid";
        sql = new StringBuffer("insert into " + tempBizTableName + " (" + bizCardColumns + ",ffacurcardid) ");
        sql.append(selectBizCard + ", A.fid as ffacurcardid from t_fa_facurcard A inner join " + tempBakTableName + " B on A.fid = B.ffacurcardid where A.fid in(");
        sql.append(selectCardId).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        String defSql2 = "select fpropertyValueId from " + tempBizTableName + " where fpropertyValueId is not null";
        String defUpdateSql2 = "update " + tempBizTableName + " set fpropertyValueId=? where fpropertyValueId=?";
        RptRowSet rs2 = DefDBUtil.executeQuery((String)defSql2, null, (Context)ctx);
        while (rs2.next()) {
            BOSUuid id = BOSUuid.read((String)rs2.getString("fpropertyValueId"));
            FaDefPropertyValueInfo pv = FaCardDefPropertyPersist.copy((BOSUuid)id, (Context)ctx);
            DefDBUtil.executeUpdate((String)defUpdateSql2, (SqlParams)new SqlParams().addString(pv.getId().toString()).addString(id.toString()), (Context)ctx);
        }
        DbUtil.execute((Context)ctx, (String)("update " + tempBizTableName + " set fbizstatus ='" + bizStatus.getValue() + "' ,flastbillid = '" + billId + "' , flastupdatetime = GETDATE()"));
        String bizCardColumnsNotGenFid = "fid," + FaLocalUtils.getTableColumnWithComma((Context)ctx, (CoreBaseInfo)new FaBizCardInfo(), (String[])new String[]{"ffabakcardid", "fid"});
        bizCardColumnsNotGenFid = bizCardColumnsNotGenFid + ",ffabakcardid";
        sql = new StringBuffer("insert into t_fa_fabizcard (" + bizCardColumnsNotGenFid + ") select " + bizCardColumnsNotGenFid + " from " + tempBizTableName);
        DbUtil.execute((Context)ctx, (String)sql.toString());
        AbstractPrcFaManageStrategy.saveCompositeEntry(ctx, tempBizTableName, "t_fa_fabizfacility", "t_fa_facurfacility", (CoreBaseInfo)new FaBizFacilityInfo(), new FaFacilityInfo().getBOSType());
        AbstractPrcFaManageStrategy.saveCompositeEntry(ctx, tempBizTableName, "t_fa_fabizcostcenter", "t_fa_facurcostcenter", (CoreBaseInfo)new FaBizCostCenterInfo(), new FaCostCenterInfo().getBOSType());
        AbstractPrcFaManageStrategy.saveCompositeEntry(ctx, tempBizTableName, "t_fa_fabizdepartment", "t_fa_facurdepartment", (CoreBaseInfo)new FaBizDepartmentInfo(), new FaDepartmentInfo().getBOSType());
        AbstractPrcFaManageStrategy.saveBizAsstActCompositNew(ctx, tempBizTableName, "T_fa_FaBizAsstActComposit", (CoreBaseInfo)new FaBizAsstActCompositInfo(), selectCardId);
        DbUtil.execute((Context)ctx, (String)("update " + entryTableName + " set (fbizcardid) = (select B.fid from " + tempBizTableName + " B where " + entryTableName + ".fcurcardid = B.ffacurcardid) where fcurcardid in (" + selectCardId + ") and " + properties[3] + "='" + billId + "'"));
        DbUtil.execute((Context)ctx, (String)("update t_fa_facurcard set fbizstatus ='" + bizStatus.getValue() + "' ,flastbillid = '" + billId + "' , flastupdatetime = GETDATE() where fid in (" + selectCardId + ")"));
        FaLocalUtils.dropTempTable((Context)ctx, (String)tempBizTableName);
        FaLocalUtils.dropTempTable((Context)ctx, (String)tempBakTableName);
    }

    protected void saveBizBakCard(Context ctx, String[] properties, FaBillTypeEnum billType, FaBizStatusEnum bizStatus, Map tempTableNames) throws BOSException {
        boolean isNeededDropTable;
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("fbilltype", new Integer(billType.getValue()));
        String selectCardId = properties[0];
        String entryTableName = properties[1];
        String billId = properties[2];
        String tempBakTableName = (String)tempTableNames.get("tempBakTableName");
        String tempBizTableName = (String)tempTableNames.get("tempBizTableName");
        boolean bl = isNeededDropTable = tempTableNames.get("isNeededDropTable") == null ? true : (Boolean)tempTableNames.get("isNeededDropTable");
        if (StringUtils.isEmpty((String)tempBakTableName) || StringUtils.isEmpty((String)tempBizTableName)) {
            return;
        }
        String bakCardColumns = FaLocalUtils.getTableColumnWithComma((Context)ctx, (CoreBaseInfo)new FaBakCardInfo(), (String[])new String[]{"ffacurcardid", "fbakperiodid"});
        bakCardColumns = bakCardColumns + ",ffacurcardid,fbakperiodid";
        String selectBakCard = "select " + FaLocalUtils.getQueryColumn((Context)ctx, (CoreBaseInfo)new FaBakCardInfo(), (String[])new String[]{"ffacurcardid", "fbakperiodid"}, null, params) + ",fid as ffacurcardid,null as fbakperiodid";
        StringBuffer sql = new StringBuffer("insert into " + tempBakTableName + " (" + bakCardColumns + ") ");
        sql.append(selectBakCard + " from t_fa_facurcard where fid in(").append(selectCardId).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        String defSql = "select fpropertyValueId from " + tempBakTableName + " where fpropertyValueId is not null";
        String defUpdateSql = "update " + tempBakTableName + " set fpropertyValueId=? where fpropertyValueId=?";
        RptRowSet rs = DefDBUtil.executeQuery((String)defSql, null, (Context)ctx);
        while (rs.next()) {
            BOSUuid id = BOSUuid.read((String)rs.getString("fpropertyValueId"));
            FaDefPropertyValueInfo pv = FaCardDefPropertyPersist.copy((BOSUuid)id, (Context)ctx);
            if (pv == null) continue;
            DefDBUtil.executeUpdate((String)defUpdateSql, (SqlParams)new SqlParams().addString(pv.getId().toString()).addString(id.toString()), (Context)ctx);
        }
        String bakCardColumnsNotGenFid = "fid," + FaLocalUtils.getTableColumnWithComma((Context)ctx, (CoreBaseInfo)new FaBakCardInfo(), (String[])new String[]{"ffacurcardid", "fbakperiodid", "fid"});
        bakCardColumnsNotGenFid = bakCardColumnsNotGenFid + ",ffacurcardid,fbakperiodid";
        sql = new StringBuffer("insert into t_fa_fabakcard (" + bakCardColumnsNotGenFid + ") select " + bakCardColumnsNotGenFid + " from " + tempBakTableName);
        DbUtil.execute((Context)ctx, (String)sql.toString());
        AbstractPrcFaManageStrategy.saveCompositeEntry(ctx, tempBakTableName, "t_fa_fabakfacility", "t_fa_facurfacility", (CoreBaseInfo)new FaBakFacilityInfo(), new FaFacilityInfo().getBOSType());
        AbstractPrcFaManageStrategy.saveCompositeEntry(ctx, tempBakTableName, "t_fa_fabakcostcenter", "t_fa_facurcostcenter", (CoreBaseInfo)new FaBakCostCenterInfo(), new FaCostCenterInfo().getBOSType());
        AbstractPrcFaManageStrategy.saveCompositeEntry(ctx, tempBakTableName, "t_fa_fabakdepartment", "t_fa_facurdepartment", (CoreBaseInfo)new FaBakDepartmentInfo(), new FaDepartmentInfo().getBOSType());
        AbstractPrcFaManageStrategy.saveBakAsstActCompositNew(ctx, tempBakTableName, "T_fa_FaBakAsstActComposit", (CoreBaseInfo)new FaBakAsstActCompositInfo(), selectCardId);
        String bizCardColumns = FaLocalUtils.getTableColumnWithComma((Context)ctx, (CoreBaseInfo)new FaBizCardInfo(), (String[])new String[]{"ffabakcardid"});
        bizCardColumns = bizCardColumns + ",ffabakcardid";
        String selectBizCard = "select " + FaLocalUtils.getQueryColumn((Context)ctx, (CoreBaseInfo)new FaBizCardInfo(), (String[])new String[]{"ffabakcardid"}, (String)"A", params) + ",B.fid as ffabakcardid";
        sql = new StringBuffer("insert into " + tempBizTableName + " (" + bizCardColumns + ",ffacurcardid) ");
        sql.append(selectBizCard + ", A.fid as ffacurcardid from t_fa_facurcard A inner join " + tempBakTableName + " B on A.fid = B.ffacurcardid where A.fid in(");
        sql.append(selectCardId).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        String defSql2 = "select fpropertyValueId from " + tempBizTableName + " where fpropertyValueId is not null";
        String defUpdateSql2 = "update " + tempBizTableName + " set fpropertyValueId=? where fpropertyValueId=?";
        RptRowSet rs2 = DefDBUtil.executeQuery((String)defSql2, null, (Context)ctx);
        while (rs2.next()) {
            BOSUuid id = BOSUuid.read((String)rs2.getString("fpropertyValueId"));
            FaDefPropertyValueInfo pv = FaCardDefPropertyPersist.copy((BOSUuid)id, (Context)ctx);
            DefDBUtil.executeUpdate((String)defUpdateSql2, (SqlParams)new SqlParams().addString(pv.getId().toString()).addString(id.toString()), (Context)ctx);
        }
        DbUtil.execute((Context)ctx, (String)("update " + tempBizTableName + " set fbizstatus ='" + bizStatus.getValue() + "' ,flastbillid = '" + billId + "' , flastupdatetime = GETDATE()"));
        String bizCardColumnsNotGenFid = "fid," + FaLocalUtils.getTableColumnWithComma((Context)ctx, (CoreBaseInfo)new FaBizCardInfo(), (String[])new String[]{"ffabakcardid", "fid"});
        bizCardColumnsNotGenFid = bizCardColumnsNotGenFid + ",ffabakcardid";
        sql = new StringBuffer("insert into t_fa_fabizcard (" + bizCardColumnsNotGenFid + ") select " + bizCardColumnsNotGenFid + " from " + tempBizTableName);
        DbUtil.execute((Context)ctx, (String)sql.toString());
        AbstractPrcFaManageStrategy.saveCompositeEntry(ctx, tempBizTableName, "t_fa_fabizfacility", "t_fa_facurfacility", (CoreBaseInfo)new FaBizFacilityInfo(), new FaFacilityInfo().getBOSType());
        AbstractPrcFaManageStrategy.saveCompositeEntry(ctx, tempBizTableName, "t_fa_fabizcostcenter", "t_fa_facurcostcenter", (CoreBaseInfo)new FaBizCostCenterInfo(), new FaCostCenterInfo().getBOSType());
        AbstractPrcFaManageStrategy.saveCompositeEntry(ctx, tempBizTableName, "t_fa_fabizdepartment", "t_fa_facurdepartment", (CoreBaseInfo)new FaBizDepartmentInfo(), new FaDepartmentInfo().getBOSType());
        AbstractPrcFaManageStrategy.saveBizAsstActCompositNew(ctx, tempBizTableName, "T_fa_FaBizAsstActComposit", (CoreBaseInfo)new FaBizAsstActCompositInfo(), selectCardId);
        DbUtil.execute((Context)ctx, (String)("update " + entryTableName + " set (fbizcardid) = (select B.fid from " + tempBizTableName + " B where " + entryTableName + ".fcurcardid = B.ffacurcardid) where fcurcardid in (" + selectCardId + ") and " + properties[3] + "='" + billId + "'"));
        DbUtil.execute((Context)ctx, (String)("update t_fa_facurcard set fbizstatus ='" + bizStatus.getValue() + "' ,flastbillid = '" + billId + "' , flastupdatetime = GETDATE() where fid in (" + selectCardId + ")"));
        if (isNeededDropTable) {
            FaLocalUtils.dropTempTable((Context)ctx, (String)tempBizTableName);
            FaLocalUtils.dropTempTable((Context)ctx, (String)tempBakTableName);
        } else {
            DbUtil.execute((Context)ctx, (String)("delete from " + tempBizTableName));
            DbUtil.execute((Context)ctx, (String)("delete from " + tempBakTableName));
        }
    }

    protected static Map createBizBakTempTable(Context ctx) throws BOSException {
        String tempBakTableName = FaLocalUtils.createTempTable((Context)ctx, (CoreBaseInfo)new FaBakCardInfo(), null);
        String tempBizTableName = FaLocalUtils.createTempTable((Context)ctx, (CoreBaseInfo)new FaBizCardInfo(), (String)"ffacurcardid varchar(44)");
        HashMap<String, Object> tempTableNames = new HashMap<String, Object>();
        tempTableNames.put("tempBakTableName", tempBakTableName);
        tempTableNames.put("tempBizTableName", tempBizTableName);
        tempTableNames.put("isNeededDropTable", true);
        return tempTableNames;
    }

    private static void saveCompositeEntry(Context ctx, String tempTableName, String insertTableName, String fromTableName, CoreBaseInfo info, BOSObjectType parentBosType) throws BOSException {
        StringBuffer sql = new StringBuffer();
        boolean isBizCard = insertTableName.toLowerCase().indexOf("t_fa_fabiz") == 0;
        String compositeColumns = FaLocalUtils.getTableColumnWithComma((Context)ctx, (CoreBaseInfo)info, (String[])new String[]{isBizCard ? "ffabizcardid" : "ffabakcardid"});
        if (!isBizCard) {
            String selectBakComposite = "select " + FaLocalUtils.getQueryColumn((Context)ctx, (CoreBaseInfo)info, (String[])new String[]{"ffabakcardid"}, (String)"A") + ",B.fid as ffabakcardid";
            sql = new StringBuffer("insert into " + insertTableName + " (" + compositeColumns + ",ffabakcardid) " + selectBakComposite);
            sql.append(" from " + tempTableName + " B inner join " + fromTableName + " A on B.ffacurcardid = A.ffacurcardid ");
        } else {
            String selectBizComposite = "select " + FaLocalUtils.getQueryColumn((Context)ctx, (CoreBaseInfo)info, (String[])new String[]{"ffabizcardid"}, (String)"A") + ",B.fid as ffabizcardid";
            sql = new StringBuffer("insert into " + insertTableName + " (" + compositeColumns + ",ffabizcardid) " + selectBizComposite);
            sql.append(" from " + tempTableName + " B inner join " + fromTableName + " A on B.ffacurcardid = A.ffacurcardid ");
        }
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    protected String saveBizCard(Context ctx, String curCardId, String bakCardId, int billType) throws BOSException {
        String bizColumns = FaLocalUtils.getTableColumnWithComma((Context)ctx, (CoreBaseInfo)new FaBizCardInfo());
        String newBosid = BOSUuid.create((BOSObjectType)new FaBizCardInfo().getBOSType()).toString();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("fid", newBosid);
        params.put("ffabakcardid", bakCardId);
        params.put("fbilltype", new Integer(billType));
        params.put("fcreatetime", new java.sql.Date(new Date().getTime()));
        String selectBizSql = FaLocalUtils.getQueryColumn((Context)ctx, (CoreBaseInfo)new FaBizCardInfo(), null, params);
        StringBuffer sql = new StringBuffer("insert into t_fa_fabizcard (" + bizColumns + ") select ");
        sql.append(selectBizSql + " from t_fa_facurcard where fid = ?");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{curCardId});
        AbstractPrcFaManageStrategy.saveCompositeEntry(ctx, (CoreBaseInfo)new FaBizFacilityInfo(), curCardId, newBosid, true);
        AbstractPrcFaManageStrategy.saveCompositeEntry(ctx, (CoreBaseInfo)new FaBizCostCenterInfo(), curCardId, newBosid, true);
        AbstractPrcFaManageStrategy.saveBizCompositeAsstActEntry(ctx, (CoreBaseInfo)new FaBizAsstActCompositInfo(), curCardId, newBosid);
        AbstractPrcFaManageStrategy.saveCompositeEntry(ctx, (CoreBaseInfo)new FaBizDepartmentInfo(), curCardId, newBosid, true);
        return newBosid;
    }

    protected String saveBakCard(Context ctx, String curCardId, int billType) throws BOSException {
        String curColumns = FaLocalUtils.getTableColumnWithComma((Context)ctx, (CoreBaseInfo)new FaBakCardInfo());
        String newBosid = BOSUuid.create((BOSObjectType)new FaBakCardInfo().getBOSType()).toString();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("fid", newBosid);
        params.put("ffacurcardid", curCardId);
        params.put("fbilltype", new Integer(billType));
        params.put("fbakperiodid", "");
        params.put("fcreatetime", new java.sql.Date(new Date().getTime()));
        String selectBakSql = FaLocalUtils.getQueryColumn((Context)ctx, (CoreBaseInfo)new FaBakCardInfo(), null, params);
        StringBuffer sql = new StringBuffer("insert into t_fa_fabakcard (" + curColumns + ") select ");
        sql.append(selectBakSql + " from t_fa_facurcard where fid = ?");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{curCardId});
        AbstractPrcFaManageStrategy.saveCompositeEntry(ctx, (CoreBaseInfo)new FaBakFacilityInfo(), curCardId, newBosid, false);
        AbstractPrcFaManageStrategy.saveCompositeEntry(ctx, (CoreBaseInfo)new FaBakCostCenterInfo(), curCardId, newBosid, false);
        AbstractPrcFaManageStrategy.saveBakCompositeAsstActEntry(ctx, (CoreBaseInfo)new FaBakAsstActCompositInfo(), curCardId, newBosid);
        AbstractPrcFaManageStrategy.saveCompositeEntry(ctx, (CoreBaseInfo)new FaBakDepartmentInfo(), curCardId, newBosid, false);
        return newBosid;
    }

    private static void saveCompositeEntry(Context ctx, CoreBaseInfo info, String cardId, String bizBakCardId, boolean isBizCard) throws BOSException {
        String sourceTable = null;
        String targetTable = null;
        if (info instanceof FaFacilityInfo) {
            sourceTable = isBizCard ? "t_fa_fabizfacility" : "t_fa_fabakfacility";
            targetTable = "t_fa_facurfacility";
        } else if (info instanceof FaCostCenterInfo) {
            sourceTable = isBizCard ? "t_fa_fabizcostcenter" : "t_fa_fabakcostcenter";
            targetTable = "t_fa_facurcostcenter";
        } else {
            sourceTable = isBizCard ? "t_fa_fabizdepartment" : "t_fa_fabakdepartment";
            targetTable = "t_fa_facurdepartment";
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (isBizCard) {
            params.put("ffabizcardid", bizBakCardId);
        } else {
            params.put("ffabakcardid", bizBakCardId);
        }
        String compositeColumns = FaLocalUtils.getTableColumnWithComma((Context)ctx, (CoreBaseInfo)info);
        String compositeSelectSql = FaLocalUtils.getQueryColumn((Context)ctx, (CoreBaseInfo)info, null, params);
        StringBuffer sql = new StringBuffer("insert into " + sourceTable + " (" + compositeColumns + ") select ");
        sql.append(compositeSelectSql + " from " + targetTable + " where ffacurcardid = ?");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{cardId});
    }

    protected void deleteBizBakCard(Context ctx, IObjectPK[] bizCardIds, IObjectPK[] bakCardIds, boolean isNeedDelPV) throws BOSException {
        int i;
        StringBuffer bizCardIdArray = new StringBuffer();
        StringBuffer bakCardIdArray = new StringBuffer();
        int batchSize = 100;
        if (bizCardIds != null && bizCardIds.length > 0) {
            for (i = 0; i < bizCardIds.length; ++i) {
                if (bizCardIds[i] == null) continue;
                bizCardIdArray.append("'" + bizCardIds[i] + "',");
                if ((i + 1) % batchSize != 0) continue;
                this.deleteBizBakCard(ctx, bizCardIdArray.substring(0, bizCardIdArray.length() - 1), null, isNeedDelPV);
                bizCardIdArray = new StringBuffer();
            }
            if (bizCardIdArray.length() > 0) {
                this.deleteBizBakCard(ctx, bizCardIdArray.substring(0, bizCardIdArray.length() - 1), null, isNeedDelPV);
            }
        }
        if (bakCardIds != null && bakCardIds.length > 0) {
            for (i = 0; i < bakCardIds.length; ++i) {
                if (bakCardIds[i] == null) continue;
                bakCardIdArray.append("'" + bakCardIds[i] + "',");
                if ((i + 1) % batchSize != 0) continue;
                this.deleteBizBakCard(ctx, null, bakCardIdArray.substring(0, bakCardIdArray.length() - 1), isNeedDelPV);
                bakCardIdArray = new StringBuffer();
            }
            if (bakCardIdArray.length() > 0) {
                this.deleteBizBakCard(ctx, null, bakCardIdArray.substring(0, bakCardIdArray.length() - 1), isNeedDelPV);
            }
        }
    }

    protected void deleteBizBakCard(Context ctx, String bizCardIds, String bakCardIds, boolean isNeedDelPV) throws BOSException {
        StringBuffer delPV;
        if (bizCardIds != null && bizCardIds.trim().length() > 0) {
            DbUtil.execute((Context)ctx, (String)("delete from t_fa_fabizAsstActComposit where fFabizCostCenterId in  (select fid from t_fa_fabizcostcenter where ffabizcardid in (" + bizCardIds + ") )"));
            DbUtil.execute((Context)ctx, (String)("delete from t_fa_fabizcostcenter where ffabizcardid in (" + bizCardIds + ")"));
            DbUtil.execute((Context)ctx, (String)("delete from t_fa_fabizdepartment where ffabizcardid in (" + bizCardIds + ")"));
            DbUtil.execute((Context)ctx, (String)("delete from t_fa_fabizfacility where ffabizcardid in (" + bizCardIds + ")"));
            DbUtil.execute((Context)ctx, (String)("delete from t_fa_fabizinitdata where ffabizcardid in (" + bizCardIds + ")"));
            if (isNeedDelPV) {
                delPV = new StringBuffer();
                delPV.append("delete from T_FA_FaDefPropertyValue where fid in(");
                delPV.append(" select pv.fid from T_FA_FaDefPropertyValue pv ");
                delPV.append(" inner join t_fa_fabizcard biz on pv.fid = biz.fpropertyvalueid ");
                delPV.append(" where biz.fid in (" + bizCardIds + "))");
                DbUtil.execute((Context)ctx, (String)delPV.toString());
            }
            DbUtil.execute((Context)ctx, (String)("delete from t_fa_fabizcard where fid in (" + bizCardIds + ")"));
        }
        if (bakCardIds != null && bakCardIds.trim().length() > 0) {
            DbUtil.execute((Context)ctx, (String)("delete from t_fa_fabakAsstActComposit where fFabakCostCenterId in  (select fid from t_fa_fabakcostcenter where ffabakcardid in (" + bakCardIds + ") )"));
            DbUtil.execute((Context)ctx, (String)("delete from t_fa_fabakcostcenter where ffabakcardid in (" + bakCardIds + ")"));
            DbUtil.execute((Context)ctx, (String)("delete from t_fa_fabakdepartment where ffabakcardid in (" + bakCardIds + ")"));
            DbUtil.execute((Context)ctx, (String)("delete from t_fa_fabakfacility where ffabakcardid in (" + bakCardIds + ")"));
            DbUtil.execute((Context)ctx, (String)("delete from t_fa_fabakinitdata where ffabakcardid in (" + bakCardIds + ")"));
            if (isNeedDelPV) {
                delPV = new StringBuffer();
                delPV.append("delete from T_FA_FaDefPropertyValue where fid in(");
                delPV.append(" select pv.fid from T_FA_FaDefPropertyValue pv ");
                delPV.append(" inner join t_fa_fabakcard bak on pv.fid = bak.fpropertyvalueid ");
                delPV.append(" where bak.fid in (" + bakCardIds + "))");
                DbUtil.execute((Context)ctx, (String)delPV.toString());
            }
            DbUtil.execute((Context)ctx, (String)("delete from t_fa_fabakcard where fid in (" + bakCardIds + ")"));
        }
    }

    protected String getCurCardFieldName() {
        return "faCurCard";
    }

    protected String getBizCardFieldName() {
        return "faBizCard";
    }

    private static void saveBizAsstActComposit(Context ctx, String tempBizTableName, String insertBizTableName, CoreBaseInfo info, String curCardId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String compositeColumns = FaLocalUtils.getTableColumnWithComma((Context)ctx, (CoreBaseInfo)info, (String[])new String[0]);
        sql = new StringBuffer("insert into " + insertBizTableName + " ( " + compositeColumns + " )");
        sql.append("(");
        sql.append("select  newbosid('AC8B88AE') as fid ,T.asstSeq as Feq,T.fAsstActItem,T.FasstActType,B.fid as fFaBizcostCenterId  from ");
        sql.append("\t(");
        sql.append(" \t\t(");
        sql.append("\t\t\tselect  asst.fAsstActItem ,asst.fAsstActType,ct.fseq as fseq,asst.fseq as asstSeq  ");
        sql.append("\t\t\tfrom t_fa_facurAsstActComposit asst ");
        sql.append("\t\t\tinner join T_Fa_faCurCostCenter ct on asst.ffacurCostCenterId = ct.fid ");
        sql.append("\t\t\twhere asst.ffacurCostCenterId in ");
        sql.append("\t\t\t( ");
        if (curCardId.toLowerCase().indexOf("select") >= 0) {
            sql.append("\t\tselect ct.fid from t_fa_facurcostcenter ct where ffacurcardid in (" + curCardId + ") ");
        } else if (curCardId.trim().startsWith("'")) {
            sql.append("\t\t\t\tselect ct.fid from t_fa_facurcostcenter ct where ffacurcardid in (" + curCardId + ") ");
        } else {
            sql.append("\t\t\t\tselect ct.fid from t_fa_facurcostcenter ct where ffacurcardid in ('" + curCardId + "') ");
        }
        sql.append("\t\t\t)");
        sql.append("\t\t)T");
        sql.append("\t\tinner join ");
        sql.append("\t\t(");
        sql.append("\t\t    select fid ,fseq from T_fa_fabizCostCenter where ffabizCardid in ");
        sql.append("\t\t\t(");
        sql.append("\t\t\t\tselect fid from " + tempBizTableName + " ");
        sql.append("\t\t\t)");
        sql.append("\t\t)");
        sql.append("\t\tB ");
        sql.append("\t\ton T.fseq = B.fseq ");
        sql.append("\t) where T.fAsstActItem is not null and T.FasstActType is not null");
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private static void saveBizAsstActCompositNew(Context ctx, String tempBizTableName, String insertBizTableName, CoreBaseInfo info, String curCardId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String compositeColumns = FaLocalUtils.getTableColumnWithComma((Context)ctx, (CoreBaseInfo)info, (String[])new String[0]);
        sql = new StringBuffer("insert into " + insertBizTableName + " ( " + compositeColumns + " )");
        sql.append("(");
        sql.append("select  newbosid('AC8B88AE') as fid ,T.asstSeq as Feq,T.fAsstActItem,T.FasstActType,B.fid as fFaBizcostCenterId  from ");
        sql.append("\t(");
        sql.append(" \t\t(");
        sql.append("\t\t\tselect  asst.fAsstActItem ,asst.fAsstActType,ct.fseq as fseq,asst.fseq as asstSeq,ct.FFaCurCardID as FFaCurCardID  ");
        sql.append("\t\t\tfrom t_fa_facurAsstActComposit asst ");
        sql.append("\t\t\tinner join T_Fa_faCurCostCenter ct on asst.ffacurCostCenterId = ct.fid ");
        sql.append("\t\t\twhere asst.ffacurCostCenterId in ");
        sql.append("\t\t\t( ");
        if (curCardId.toLowerCase().indexOf("select") >= 0) {
            sql.append("\t\tselect ct.fid from t_fa_facurcostcenter ct where ffacurcardid in (" + curCardId + ") ");
        } else if (curCardId.trim().startsWith("'")) {
            sql.append("\t\t\t\tselect ct.fid from t_fa_facurcostcenter ct where ffacurcardid in (" + curCardId + ") ");
        } else {
            sql.append("\t\t\t\tselect ct.fid from t_fa_facurcostcenter ct where ffacurcardid in ('" + curCardId + "') ");
        }
        sql.append("\t\t\t)");
        sql.append("\t\t)T");
        sql.append("\t\tinner join ");
        sql.append("\t\t(");
        sql.append("\t\t    select bizCostCenter.fid as fid, bizCostCenter.fseq as fseq,bakCard.FFaCurCardID as FFaCurCardID from T_fa_fabizCostCenter bizCostCenter inner join T_FA_FaBizCard bizCard on bizCostCenter.FFaBizCardID = bizCard.fid inner join T_FA_FaBakCard bakCard on  bizCard.FFaBakCardID = bakCard.fid  ");
        sql.append("\twhere bizCostCenter.ffabizCardid in\t\t(");
        sql.append("\t\t\t\tselect fid from " + tempBizTableName + " ");
        sql.append("\t\t\t)");
        sql.append("\t\t)");
        sql.append("\t\tB ");
        sql.append("\t\ton T.fseq = B.fseq and t.FFaCurCardID = b.FFaCurCardID ");
        sql.append("\t) where T.fAsstActItem is not null and T.FasstActType is not null");
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private static void saveBakAsstActComposit(Context ctx, String tempBakTableName, String insertBakTableName, CoreBaseInfo info, String curCardId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String compositeColumns = FaLocalUtils.getTableColumnWithComma((Context)ctx, (CoreBaseInfo)info, (String[])new String[0]);
        sql = new StringBuffer("insert into " + insertBakTableName + " ( " + compositeColumns + " )");
        sql.append("(");
        sql.append("\tselect  newbosid('EFB09895')as fid , T.asstSeq as Feq,T.fAsstActItem,T.FasstActType, B.fid as fFaBakcostCenterId from ");
        sql.append("\t\t(");
        sql.append(" \t\t\t(");
        sql.append("\t\t\t\tselect  asst.fAsstActItem ,asst.fAsstActType,ct.fseq as fseq,asst.fseq as asstSeq  ");
        sql.append("\t\t\t\tfrom t_fa_facurAsstActComposit asst ");
        sql.append("\t\t\t\tinner join T_Fa_faCurCostCenter ct on asst.ffacurCostCenterId = ct.fid ");
        sql.append("\t\t\t\twhere asst.ffacurCostCenterId in ");
        sql.append("\t\t\t\t( ");
        if (curCardId.toLowerCase().indexOf("select") >= 0) {
            sql.append("\t\t\t\t\tselect ct.fid from t_fa_facurcostcenter ct where ffacurcardid in (" + curCardId + ") ");
        } else if (curCardId.trim().startsWith("'")) {
            sql.append("\t\t\t\tselect ct.fid from t_fa_facurcostcenter ct where ffacurcardid in (" + curCardId + ") ");
        } else {
            sql.append("\t\t\t\tselect ct.fid from t_fa_facurcostcenter ct where ffacurcardid in ('" + curCardId + "') ");
        }
        sql.append("\t\t\t\t)");
        sql.append("\t\t\t)T");
        sql.append("\t\t\tinner join ");
        sql.append("\t\t\t(");
        sql.append("\t \t  \t\t select fid ,fseq from T_fa_fabakCostCenter where ffabakCardid in ");
        sql.append("\t\t\t\t(");
        sql.append("\t\t\t\t\tselect fid from " + tempBakTableName + " ");
        sql.append("\t\t\t\t)");
        sql.append("\t\t\t)B ");
        sql.append("\t\t\ton T.fseq = B.fseq ");
        sql.append("\t\t) where  T.fAsstActItem is not null and T.FasstActType is not null");
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private static void saveBakAsstActCompositNew(Context ctx, String tempBakTableName, String insertBakTableName, CoreBaseInfo info, String curCardId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String compositeColumns = FaLocalUtils.getTableColumnWithComma((Context)ctx, (CoreBaseInfo)info, (String[])new String[0]);
        sql = new StringBuffer("insert into " + insertBakTableName + " ( " + compositeColumns + " )");
        sql.append("\tselect  newbosid('EFB09895')as fid , T.asstSeq as Feq,T.fAsstActItem,T.FasstActType, B.fid as fFaBakcostCenterId from ");
        sql.append(" (");
        sql.append(" (");
        sql.append("  select  asst.fAsstActItem ,asst.fAsstActType,ct.fseq as fseq,asst.fseq as asstSeq,ct.FFaCurCardID as FFaCurCardID  ");
        sql.append("  from t_fa_facurAsstActComposit asst ");
        sql.append("  inner join T_Fa_faCurCostCenter ct on asst.ffacurCostCenterId = ct.fid ");
        sql.append("  where asst.ffacurCostCenterId in ");
        sql.append("( ");
        if (curCardId.toLowerCase().indexOf("select") >= 0) {
            sql.append("\tselect ct.fid from t_fa_facurcostcenter ct where ffacurcardid in (" + curCardId + ") ");
        } else if (curCardId.trim().startsWith("'")) {
            sql.append(" select ct.fid from t_fa_facurcostcenter ct where ffacurcardid in (" + curCardId + ") ");
        } else {
            sql.append(" select ct.fid from t_fa_facurcostcenter ct where ffacurcardid in ('" + curCardId + "') ");
        }
        sql.append("\t\t\t\t)");
        sql.append("\t\t\t)T");
        sql.append("\t\t\tinner join ");
        sql.append("\t\t\t(");
        sql.append(" select  bakcostcenter.fid as fid,bakcostcenter.fseq as fseq, bakCard.FFaCurCardID as FFaCurCardID  from T_fa_fabakCostCenter bakcostcenter ");
        sql.append("  inner join T_FA_FaBakCard bakCard ON bakcostcenter.FFaBakCardID = bakCard.fid  ");
        sql.append("\t\t\twhere bakcostcenter.ffabakCardid in\t(");
        sql.append("\t\t\t\t\tselect fid from " + tempBakTableName + " ");
        sql.append("\t\t\t\t)");
        sql.append("\t\t\t)B ");
        sql.append("\t\t\ton T.fseq = B.fseq and t.FFaCurCardID = b.FFaCurCardID ");
        sql.append("\t\t) where  T.fAsstActItem is not null and T.FasstActType is not null");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private static void saveBizCompositeAsstActEntry(Context ctx, CoreBaseInfo info, String cardId, String bizCardId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String insertBakTableName = "t_fa_faBizAsstActComposit";
        String compositeColumns = FaLocalUtils.getTableColumnWithComma((Context)ctx, (CoreBaseInfo)info, (String[])new String[0]);
        sql = new StringBuffer("insert into " + insertBakTableName + " ( " + compositeColumns + " )");
        sql.append("(");
        sql.append("\tselect newbosid('AC8B88AE') as fid,T.asstSeq as Feq ,T.fAsstActItem,T.FasstActType, B.fid as fFaBizcostCenterId  from ");
        sql.append("\t\t(");
        sql.append(" \t\t\t(");
        sql.append("\t\t\t\tselect  asst.fAsstActItem ,asst.fAsstActType,ct.fseq as fseq,asst.fseq as asstSeq  ");
        sql.append("\t\t\t\tfrom t_fa_facurAsstActComposit asst ");
        sql.append("\t\t\t\tinner join T_Fa_faCurCostCenter ct on asst.ffacurCostCenterId = ct.fid ");
        sql.append("\t\t\t\twhere asst.ffacurCostCenterId in ");
        sql.append("\t\t\t\t( ");
        if (cardId.toLowerCase().indexOf("select") >= 0) {
            sql.append("\t\t\t\t\tselect ct.fid from t_fa_facurcostcenter ct where ffacurcardid in (" + cardId + ") ");
        } else {
            sql.append("\t\t\t\t\tselect ct.fid from t_fa_facurcostcenter ct where ffacurcardid in ('" + cardId + "') ");
        }
        sql.append("\t\t\t\t)");
        sql.append("\t\t\t)T");
        sql.append("\t\t\tinner join ");
        sql.append("\t\t\t(");
        sql.append("\t \t  \t\t select fid ,fseq from T_fa_fabizCostCenter where ffabizCardid in ");
        sql.append("\t\t\t\t(");
        sql.append("\t\t\t\t\t'" + bizCardId + "'");
        sql.append("\t\t\t\t)");
        sql.append("\t\t\t)B ");
        sql.append("\t\t\ton T.fseq = B.fseq ");
        sql.append("\t\t) where T.fAsstActItem is not null and T.FasstActType is not null");
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private static void saveBakCompositeAsstActEntry(Context ctx, CoreBaseInfo info, String curCardId, String bakCardId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String insertBakTableName = "t_fa_faBakAsstActComposit";
        String compositeColumns = FaLocalUtils.getTableColumnWithComma((Context)ctx, (CoreBaseInfo)info, (String[])new String[0]);
        sql = new StringBuffer("insert into " + insertBakTableName + " ( " + compositeColumns + " )");
        sql.append("(");
        sql.append("\tselect newbosid('EFB09895') as fid ,T.asstSeq as Feq,T.fAsstActItem,T.FasstActType, B.fid as fFaBakcostCenterId from ");
        sql.append("\t\t(");
        sql.append(" \t\t\t(");
        sql.append("\t\t\t\tselect  asst.fAsstActItem ,asst.fAsstActType,ct.fseq as fseq,asst.fseq as asstSeq  ");
        sql.append("\t\t\t\tfrom t_fa_facurAsstActComposit asst ");
        sql.append("\t\t\t\tinner join T_Fa_faCurCostCenter ct on asst.ffacurCostCenterId = ct.fid ");
        sql.append("\t\t\t\twhere asst.ffacurCostCenterId in ");
        sql.append("\t\t\t\t( ");
        if (curCardId.toLowerCase().indexOf("select") >= 0) {
            sql.append("\t\t\t\t\tselect ct.fid from t_fa_facurcostcenter ct where ffacurcardid in (" + curCardId + ") ");
        } else {
            sql.append("\t\t\t\tselect ct.fid from t_fa_facurcostcenter ct where ffacurcardid in ('" + curCardId + "') ");
        }
        sql.append("\t\t\t\t)");
        sql.append("\t\t\t)T");
        sql.append("\t\t\tinner join ");
        sql.append("\t\t\t(");
        sql.append("\t \t  \t\t select fid ,fseq from T_fa_fabakCostCenter where ffabakCardid in ");
        sql.append("\t\t\t\t(");
        sql.append("\t\t\t\t\t'" + bakCardId + "'");
        sql.append("\t\t\t\t)");
        sql.append("\t\t\t)B ");
        sql.append("\t\t\ton T.fseq = B.fseq");
        sql.append("\t\t)  where  T.fAsstActItem is not null and T.FasstActType is not null");
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void saveAsstActLName(Context ctx, String cardIdSql, boolean isBizCard) throws BOSException, SQLException {
        IRowSet rsIds;
        if (cardIdSql == null) {
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        if (cardIdSql.toUpperCase().indexOf("SELECT") >= 0 && (rsIds = DbUtil.executeQuery((Context)ctx, (String)cardIdSql)).size() > 0) {
            idList.add(rsIds.getString(0));
        }
        if (idList.size() > 0) {
            return;
        }
        for (int i = 0; i < idList.size(); ++i) {
            String cardId = (String)idList.get(i);
            if (cardId.trim().length() <= 0) continue;
            this.updateFaAsstActLName(ctx, cardId.trim(), isBizCard);
        }
    }

    private void updateFaAsstActLName(Context ctx, String cardId, boolean isBizCard) throws BOSException {
        String costCenterOql;
        CoreBaseCollection collection = null;
        if (isBizCard) {
            costCenterOql = "select id,accountView.*,seqapportionScale,faBizAsstActComposit.asstActType.*,faBizAsstActComposit.asstActItem.*,faBizAsstActComposit.seq where ffaBizCardId='" + cardId + "'";
            collection = FaBizCostCenterFactory.getLocalInstance((Context)ctx).getCollection(costCenterOql);
        } else {
            costCenterOql = "select id,accountView.*,seqapportionScale,faBakAsstActComposit.asstActType.*,faBakAsstActComposit.asstActItem.*,faBakAsstActComposit.seq where ffaBakCardId='" + cardId + "'";
            collection = FaBakCostCenterFactory.getLocalInstance((Context)ctx).getCollection(costCenterOql);
        }
        for (int i = 0; i < collection.size(); ++i) {
            CoreBaseInfo info = collection.get(i);
            if (!(info instanceof FaCostCenterInfo)) continue;
            String asstActLname = this.getAsstActLongName((FaCostCenterInfo)info, ctx);
            String costCenterId = info.getId().toString();
            String costCenterTable = "";
            costCenterTable = isBizCard ? "T_fa_faBizCostCenter" : "T_fa_faBakCostCenter";
            String sql = "update set " + costCenterTable + " fAsstActLname = '" + asstActLname + "'  where fid = '" + costCenterId + "'";
            if (costCenterId == null || costCenterId.length() <= 0 || asstActLname == null || asstActLname.length() <= 0) continue;
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private String getAsstActLongName(FaCostCenterInfo faCostCenterInfo, Context ctx) {
        if (faCostCenterInfo == null || faCostCenterInfo.getAccountView() == null) {
            return "";
        }
        if (faCostCenterInfo instanceof FaBizCostCenterInfo) {
            FaBizCostCenterInfo fabizCostCenterInfo = null;
            fabizCostCenterInfo = (FaBizCostCenterInfo)faCostCenterInfo;
            String asstActLName = "";
            asstActLName = fabizCostCenterInfo.getAccountView().getNumber() + " - " + fabizCostCenterInfo.getAccountView().getName() + " ";
            asstActLName = asstActLName + fabizCostCenterInfo.getApportionScale() + "% ";
            FaBizAsstActCompositCollection bizAsstActCollection = fabizCostCenterInfo.getFaBizAsstActComposit();
            int size = bizAsstActCollection.size();
            for (int i = 0; i < size - 1; ++i) {
                AsstActTypeInfo asstActType = bizAsstActCollection.get(i).getAsstActType();
                AssistActItemInfo asstActItem = bizAsstActCollection.get(i).getAsstActItem();
                if (asstActType == null || asstActItem == null) continue;
                asstActLName = asstActLName + bizAsstActCollection.get(i).getAsstActType().getName(ctx.getLocale()) + "-" + bizAsstActCollection.get(i).getAsstActItem().getName(ctx.getLocale()) + "/";
            }
            if (bizAsstActCollection.get(size - 1) != null && bizAsstActCollection.get(size - 1).getAsstActType() != null && bizAsstActCollection.get(size - 1).getAsstActItem() != null) {
                asstActLName = asstActLName + bizAsstActCollection.get(size - 1).getAsstActType().getName(ctx.getLocale()) + "-" + bizAsstActCollection.get(size - 1).getAsstActItem().getName(ctx.getLocale());
            }
            return asstActLName;
        }
        if (faCostCenterInfo instanceof FaBakCostCenterInfo) {
            FaBakCostCenterInfo fabakCostCenterInfo = null;
            fabakCostCenterInfo = (FaBakCostCenterInfo)faCostCenterInfo;
            String asstActLName = "";
            asstActLName = fabakCostCenterInfo.getAccountView().getNumber() + " - " + fabakCostCenterInfo.getAccountView().getName() + " ";
            asstActLName = asstActLName + fabakCostCenterInfo.getApportionScale() + "% ";
            FaBakAsstActCompositCollection bakAsstActCollection = fabakCostCenterInfo.getFaBakAsstActComposit();
            int size = bakAsstActCollection.size();
            for (int i = 0; i < size - 1; ++i) {
                AsstActTypeInfo asstActType = bakAsstActCollection.get(i).getAsstActType();
                AssistActItemInfo asstActItem = bakAsstActCollection.get(i).getAsstActItem();
                if (asstActType == null || asstActItem == null) continue;
                asstActLName = asstActLName + bakAsstActCollection.get(i).getAsstActType().getName(ctx.getLocale()) + "-" + bakAsstActCollection.get(i).getAsstActItem().getName(ctx.getLocale()) + "/";
            }
            if (bakAsstActCollection.get(size - 1) != null && bakAsstActCollection.get(size - 1).getAsstActType() != null && bakAsstActCollection.get(size - 1).getAsstActItem() != null) {
                asstActLName = asstActLName + bakAsstActCollection.get(size - 1).getAsstActType().getName(ctx.getLocale()) + "-" + bakAsstActCollection.get(size - 1).getAsstActItem().getName(ctx.getLocale());
            }
            return asstActLName;
        }
        return "";
    }

    protected void recycleGroupNumber(Context ctx, BillBaseInfo caller, String bindingproperty, String customString) throws EASBizException, BOSException {
        if (caller == null) {
            return;
        }
        caller.setCU(CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select id,CU.id,CU.number,CU.name where id='" + caller.getCompany().getId() + "'").getCU());
        String strCompanyID = caller.getCompany() != null && caller.getCompany().getId() != null ? caller.getCompany().getId().toString() : ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.getCodingRule((IObjectValue)caller, strCompanyID, bindingproperty) != null && iCodingRuleManager.isUseIntermitNumber((IObjectValue)caller, strCompanyID, bindingproperty)) {
            iCodingRuleManager.recycleNumber((IObjectValue)caller, strCompanyID, bindingproperty, customString, ((FaCurCardInfo)caller).getGroupNumber());
        }
    }

    protected boolean needSubstractDepr(Context ctx, String curCardId) throws BOSException, EASBizException {
        PeriodInfo currPeriod = FaLocalUtils.getCurrentPeriod((Context)ctx);
        ObjectUuidPK pk = new ObjectUuidPK(curCardId);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("company.id"));
        selector.add(new SelectorItemInfo("assetCat.DepreciationPolicy.StartDeprTime"));
        FaCurCardInfo checkPolicyCard = FaCurCardFactory.getLocalInstance((Context)ctx).getFaCurCardInfo((IObjectPK)pk, selector);
        boolean isStartDeprTime = checkPolicyCard.getAssetCat().getDepreciationPolicy().getStartDeprTime().getValue() != 0;
        boolean isDep = FaDepreciationEntryFactory.getLocalInstance((Context)ctx).exists("select fid where LnkFaDepreEntry.period.id='" + currPeriod.getId().toString() + "' and LnkFaDepreEntry.company.id='" + checkPolicyCard.getCompany().getId().toString() + "' and faCurCard.id='" + curCardId + "'");
        if (!isDep) {
            isDep = FaEvalDepreciationEntryFactory.getLocalInstance((Context)ctx).exists("select fid where LnkFaDepreEntry.period.id='" + currPeriod.getId().toString() + "' and LnkFaDepreEntry.company.id='" + checkPolicyCard.getCompany().getId().toString() + "' and faCurCard.id='" + curCardId + "'");
        }
        return isDep && !isStartDeprTime;
    }

    protected String getSubBizCardDepSql(String bizCardId) {
        StringBuffer sql = new StringBuffer();
        sql.append(" update t_fa_fabizcard set ");
        sql.append(" faccudepr = faccudepr - fdeprtterm,");
        sql.append(" FAccuDeprTYear = FAccuDeprTYear - fdeprtterm, ");
        sql.append(" fneatValue = fneatValue +  fdeprtterm, ");
        sql.append(" fneatAmt = fneatAmt + fdeprtterm, ");
        sql.append(" fdeprtterm = 0, ");
        sql.append(" fdeprTermCount = fdeprTermCount - 1 ");
        sql.append(" where ").append("fid = '").append(bizCardId).append("'");
        return sql.toString();
    }

    private String getAllSuperiorFICompanyOrgUnit(Context ctx, String companyID) throws EASBizException, BOSException {
        StringBuffer superiorFIComIds = new StringBuffer();
        String longNumberSql = "select flongnumber from t_org_company where fid= ? ";
        IRowSet longNumberRowSet = DbUtil.executeQuery((Context)ctx, (String)longNumberSql, (Object[])new Object[]{companyID});
        try {
            if (longNumberRowSet != null && longNumberRowSet.next()) {
                String longNumber = longNumberRowSet.getString("flongnumber");
                String[] numbers = longNumber.split("!");
                StringBuffer superiorNumbers = new StringBuffer();
                for (int i = 0; i < numbers.length - 1; ++i) {
                    superiorNumbers.append(",'").append(numbers[i]).append("'");
                }
                if (superiorNumbers.length() == 0) {
                    return "";
                }
                String superiorFICompanySql = "select fid from t_org_company where fnumber in (" + superiorNumbers.substring(1) + ")";
                IRowSet superiorFIComRowSet = DbUtil.executeQuery((Context)ctx, (String)superiorFICompanySql);
                while (superiorFIComRowSet != null && superiorFIComRowSet.next()) {
                    superiorFIComIds.append(",'").append(superiorFIComRowSet.getString("fid")).append("'");
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return superiorFIComIds.toString();
    }

    private void resetCardAccountview(Context ctx, String cardAccountview, String companyID, String filter) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select 1 from t_fa_facurcard facard ");
        sql.append(" inner join T_BD_accountview ac on facard." + cardAccountview.trim() + " = ac.fid ");
        sql.append(" where ac.fcompanyid <> facard.fcompanyid ");
        sql.append(" and ac.fcompanyid in ").append(filter);
        sql.append(" and ac.faccounttableid = (select faccounttableid from t_org_company where fid = ? ) ");
        sql.append(" and ac.fisleaf = 1 ");
        sql.append(" and ac.fisCFreeze = 0 ");
        sql.append(" and facard.fcompanyid= ? ; ");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID, companyID});
        try {
            if (result != null && result.next()) {
                this.updateCard(ctx, cardAccountview, companyID, filter, "t_fa_facurcard");
                this.updateCard(ctx, cardAccountview, companyID, filter, "t_fa_famoncard");
                this.updateCard(ctx, cardAccountview, companyID, filter, "t_fa_fabizcard");
                this.updateCard(ctx, cardAccountview, companyID, filter, "t_fa_fabakcard");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void updateCard(Context ctx, String cardAccountview, String companyID, String filter, String cardTabName) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update " + cardTabName + " as facard ");
        sql.append(" set " + cardAccountview.trim() + " = (select accountview.fid ");
        sql.append(" from T_BD_accountview accountview ");
        sql.append(" inner join T_BD_accountview aview on accountview.fnumber = aview.fnumber ");
        sql.append(" and accountview.flongname_l2 = aview.flongname_l2 ");
        sql.append(" where aview.fid = facard." + cardAccountview.trim() + " ");
        sql.append(" and accountview.fid <> facard." + cardAccountview.trim() + " ");
        sql.append(" and accountview.fcompanyid = ? ");
        sql.append(" and accountview.faccounttableid = (select faccounttableid from t_org_company where fid = ? ) ");
        sql.append(" and accountview.fisleaf = 1 ");
        sql.append(" and accountview.fisCFreeze = 0 ");
        sql.append(" and facard.fcompanyid= ?  ");
        sql.append(" and aview.fcompanyid in " + filter + " ) ");
        sql.append(" where facard.fid in( ");
        sql.append(" select facard1.fid ");
        sql.append(" from " + cardTabName + " facard1 ");
        sql.append(" inner join T_BD_accountview accountview on accountview.fid <> facard1." + cardAccountview.trim() + " ");
        sql.append(" inner join T_BD_accountview aview on aview.fid = facard1." + cardAccountview.trim() + " ");
        sql.append(" where accountview.fnumber = aview.fnumber ");
        sql.append(" and accountview.flongname_l2 = aview.flongname_l2 ");
        sql.append(" and accountview.fcompanyid = ? ");
        sql.append(" and accountview.faccounttableid = (select faccounttableid from t_org_company where fid = ? ) ");
        sql.append(" and accountview.fisleaf = 1 ");
        sql.append(" and accountview.fisCFreeze = 0  ");
        sql.append(" and facard1.fcompanyid= ? ");
        sql.append(" and aview.fcompanyid in " + filter + " );");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID, companyID, companyID, companyID, companyID, companyID});
    }

    private void resetCostCenterAccountview(Context ctx, String companyID, String filter) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select 1 from t_fa_facurcard facard ");
        sql.append(" inner join T_FA_FaCurCostCenter costcenter on costcenter.ffacurcardid=facard.fid ");
        sql.append(" inner join T_BD_accountview ac on costcenter.FAccountViewID=ac.fid ");
        sql.append(" where ac.fcompanyid <> facard.fcompanyid ");
        sql.append(" and ac.fcompanyid in ").append(filter);
        sql.append(" and ac.faccounttableid = (select faccounttableid from t_org_company where fid= ? ) ");
        sql.append(" and ac.fisleaf = 1 ");
        sql.append(" and ac.fisCFreeze = 0 ");
        sql.append(" and facard.fcompanyid= ? ");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID, companyID});
        try {
            if (result != null && result.next()) {
                this.updateCostcenter(ctx, "T_FA_FaCurCostCenter", "ffacurcardid", "t_fa_facurcard", companyID, filter);
                this.updateCostcenter(ctx, "T_FA_FaMonCostCenter", "ffamoncardid", "t_fa_famoncard", companyID, filter);
                this.updateCostcenter(ctx, "T_FA_FaBizCostCenter", "ffabizcardid", "t_fa_fabizcard", companyID, filter);
                this.updateCostcenter(ctx, "T_FA_FaBakCostCenter", "ffabakcardid", "t_fa_fabakcard", companyID, filter);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void updateCostcenter(Context ctx, String costCenterTabName, String costCenterColumnName, String cardTabName, String companyID, String filter) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update " + costCenterTabName + " as costcenter ");
        sql.append(" set FAccountViewID = (select accountview.fid ");
        sql.append(" from " + cardTabName + " facard, T_BD_accountview accountview ");
        sql.append(" inner join T_BD_accountview aview on accountview.fnumber = aview.fnumber ");
        sql.append(" and accountview.flongname_l2 = aview.flongname_l2 ");
        sql.append(" where aview.fid = costcenter.FAccountViewID ");
        sql.append(" and accountview.fid <> costcenter.FAccountViewID ");
        sql.append(" and costcenter." + costCenterColumnName + "= facard.fid ");
        sql.append(" and accountview.fcompanyid = ? ");
        sql.append(" and accountview.faccounttableid = (select faccounttableid from t_org_company where fid= ? ) ");
        sql.append(" and accountview.fisleaf = 1 ");
        sql.append(" and accountview.fisCFreeze = 0 ");
        sql.append(" and facard.fcompanyid= ?  ");
        sql.append(" and aview.fcompanyid in " + filter + ") ");
        sql.append(" where costcenter.fid in( ");
        sql.append(" select costcenter1.fid ");
        sql.append(" from " + costCenterTabName + " costcenter1 ");
        sql.append(" inner join " + cardTabName + " facard on costcenter1." + costCenterColumnName + "= facard.fid ");
        sql.append(" inner join T_BD_accountview accountview on accountview.fid <> costcenter1.FAccountViewID ");
        sql.append(" inner join T_BD_accountview aview on aview.fid = costcenter1.FAccountViewID ");
        sql.append(" where accountview.fnumber = aview.fnumber ");
        sql.append(" and accountview.flongname_l2 = aview.flongname_l2 ");
        sql.append(" and accountview.fcompanyid = ? ");
        sql.append(" and accountview.faccounttableid = ");
        sql.append(" (select faccounttableid from t_org_company where fid = ? ) ");
        sql.append(" and accountview.fisleaf = 1 ");
        sql.append(" and accountview.fisCFreeze = 0 ");
        sql.append(" and facard.fcompanyid= ?  ");
        sql.append(" and aview.fcompanyid in " + filter + " );");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID, companyID, companyID, companyID, companyID, companyID});
    }

    private void resetDepDistributeAccountview(Context ctx, String companyID, String filter) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select 1 from t_fa_fadepdistribute dis ");
        sql.append("inner join t_fa_fadepreciationentry depentry on depentry.fid=dis.fdepentryid ");
        sql.append("inner join t_fa_fadepreciation depr on depr.fid = depentry.flnkfadepreentry ");
        sql.append("inner join t_fa_facurcard facard on facard.fid=depentry.ffacurcardid ");
        sql.append("inner join T_BD_accountview ac on dis.FAccountViewID = ac.fid ");
        sql.append("where ac.fcompanyid <> facard.fcompanyid ");
        sql.append("and ac.fcompanyid in ").append(filter);
        sql.append("and ac.faccounttableid = (select faccounttableid from t_org_company where fid = ? ) ");
        sql.append("and ac.fisleaf = 1 ");
        sql.append("and ac.fisCFreeze = 0 ");
        sql.append("and facard.fcompanyid= ? ");
        sql.append("and depr.fcompanyid= ? ");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID, companyID, companyID});
        try {
            if (result != null && result.next()) {
                this.updateDepDistributeAccView(ctx, companyID, filter);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void updateDepDistributeAccView(Context ctx, String companyID, String filter) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_fa_fadepdistribute as dis ");
        sql.append(" set FAccountViewID=(select accountview.fid ");
        sql.append(" from t_fa_facurcard facard,t_fa_fadepreciationentry depentry,t_fa_fadepreciation depr,T_BD_accountview accountview ");
        sql.append(" inner join T_BD_accountview aview on accountview.fnumber = aview.fnumber ");
        sql.append(" and accountview.flongname_l2 = aview.flongname_l2 ");
        sql.append(" where depentry.ffacurcardid = facard.fid ");
        sql.append(" and depr.fid = depentry.flnkfadepreentry ");
        sql.append(" and aview.fid = dis.FAccountViewID ");
        sql.append(" and accountview.fid <> dis.FAccountViewID ");
        sql.append(" and depentry.fid = dis.fdepentryid ");
        sql.append(" and accountview.fcompanyid = ? ");
        sql.append(" and accountview.faccounttableid = (select faccounttableid from t_org_company where fid= ? ) ");
        sql.append(" and accountview.fisleaf = 1 ");
        sql.append(" and accountview.fisCFreeze = 0 ");
        sql.append(" and facard.fcompanyid= ?  ");
        sql.append(" and depr.fcompanyid= ?  ");
        sql.append(" and aview.fcompanyid in " + filter + ") ");
        sql.append(" where dis.fid in( ");
        sql.append(" select dis1.fid ");
        sql.append(" from t_fa_fadepdistribute dis1 ");
        sql.append(" inner join t_fa_fadepreciationentry depentry on depentry.fid = dis1.fdepentryid ");
        sql.append(" inner join t_fa_fadepreciation depr on depr.fid = depentry.flnkfadepreentry ");
        sql.append(" inner join t_fa_facurcard facard on facard.fid = depentry.ffacurcardid ");
        sql.append(" inner join T_BD_accountview accountview on accountview.fid <> dis1.FAccountViewID ");
        sql.append(" inner join T_BD_accountview aview on aview.fid = dis1.FAccountViewID ");
        sql.append(" where accountview.fnumber = aview.fnumber ");
        sql.append(" and accountview.flongname_l2 = aview.flongname_l2 ");
        sql.append(" and accountview.fcompanyid = ? ");
        sql.append(" and accountview.faccounttableid = ");
        sql.append(" (select faccounttableid from t_org_company where fid = ? ) ");
        sql.append(" and accountview.fisleaf = 1 ");
        sql.append(" and accountview.fisCFreeze = 0 ");
        sql.append(" and facard.fcompanyid = ?  ");
        sql.append(" and depr.fcompanyid = ? ");
        sql.append(" and aview.fcompanyid in " + filter + "); ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID, companyID, companyID, companyID, companyID, companyID, companyID, companyID});
    }
}

