/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.app.prc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.nlm.DepreciationMethodEnum;
import com.kingdee.eas.fi.nlm.FaAmortizedCostRptEntryCollection;
import com.kingdee.eas.fi.nlm.FaAmortizedCostRptEntryFactory;
import com.kingdee.eas.fi.nlm.FaAmortizedCostRptEntryInfo;
import com.kingdee.eas.fi.nlm.FaAmortizedCostRptFactory;
import com.kingdee.eas.fi.nlm.FaAmortizedCostRptInfo;
import com.kingdee.eas.fi.nlm.FaLeaseException;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNew;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewCollection;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewFactory;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.nlm.FaLeaseSourceTypeEnum;
import com.kingdee.eas.fi.nlm.FaLeaseTypeEnum;
import com.kingdee.eas.fi.nlm.FaLiabilitiesCvMethodEnum;
import com.kingdee.eas.fi.nlm.FaNewLeasePolicyFactory;
import com.kingdee.eas.fi.nlm.FaNewLeasePolicyInfo;
import com.kingdee.eas.fi.nlm.FaPayFrequencyEnum;
import com.kingdee.eas.fi.nlm.FaRentSettlementBillFactory;
import com.kingdee.eas.fi.nlm.IFaAmortizedCostRpt;
import com.kingdee.eas.fi.nlm.IFaLeaseInBillNew;
import com.kingdee.eas.fi.nlm.NLMAssetCalculationDetailFactory;
import com.kingdee.eas.fi.nlm.app.prc.AbstractPrcFaManageStrategy;
import com.kingdee.eas.fi.nlm.app.utils.FlLocalUtils;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.IBillBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import org.apache.log4j.Logger;

public class PrcFaLeaseInNewStrategy
extends AbstractPrcFaManageStrategy {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.nlm.app.PrcFaLeaseInNewStrategy");
    public static final String FALEASENEWRESOURCE = "com.kingdee.eas.fi.nlm.FaLeaseNewResource";
    public static final String POLICYRESOURCE = "com.kingdee.eas.fi.nlm.FaNewLeasePolicyResource";

    @Override
    public void deleteBill(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        IFaLeaseInBillNew iFaLeaseInNew = FaLeaseInBillNewFactory.getLocalInstance(ctx);
        FaLeaseInBillNewInfo billNewInfo = iFaLeaseInNew.getFaLeaseInBillNewInfo("select id,number,company where id ='" + pk + "'");
        this.recycleNumber(ctx, (BillBaseInfo)billNewInfo);
        iFaLeaseInNew.deleteSelf(pk);
        String updateSQL = " update T_FA_FaTerminateBillEntry  set FCreatedLeaseInBillID = '' WHERE FCreatedLeaseInBillID = ?";
        Object[] params = new Object[]{pk.toString()};
        DbUtil.execute((Context)ctx, (String)updateSQL, (Object[])params);
    }

    @Override
    public IObjectPK saveBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        return this.innerSaveBill(ctx, (FaLeaseInBillNewInfo)model, false);
    }

    private IObjectPK innerSaveBill(Context ctx, FaLeaseInBillNewInfo info, boolean isSubmit) throws BOSException, EASBizException {
        info.setPeriod(FlLocalUtils.getFLCurrentPeriod(info.getCompany().getId().toString(), ctx));
        info.setBizDate(DateTimeUtils.truncateDate((java.util.Date)new java.util.Date()));
        info.setDeletedStatus(DeletedStatusEnum.NORMAL);
        info.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        info.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        if (PrcFaLeaseInNewStrategy.isInitBill(ctx, info, null) && !info.isIsExempt() && !info.isIsBeforeImplDate()) {
            info.setFiVouchered(true);
        } else {
            info.setFiVouchered(false);
        }
        if (info.getLeaseType() == FaLeaseTypeEnum.GL_BALANCE_ENTRY) {
            info.setFiVouchered(true);
            info.setDepreciationMethod(DepreciationMethodEnum.Second);
        }
        info.setHasEffected(true);
        info.setEffectedStatus(isSubmit ? EffectedStatusEnum.EFFECTED : EffectedStatusEnum.TEMPSTORE);
        IFaLeaseInBillNew iLeaseInBillNew = FaLeaseInBillNewFactory.getLocalInstance(ctx);
        PrcFaLeaseInNewStrategy.setBillInfoNumber(ctx, (BillBaseInfo)info, (IBillBase)iLeaseInBillNew);
        return isSubmit ? iLeaseInBillNew.submitSelf(info) : iLeaseInBillNew.saveSelf(info);
    }

    @Override
    public IObjectPK submitBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        return this.innerSaveBill(ctx, (FaLeaseInBillNewInfo)model, true);
    }

    @Override
    public void auditBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        FaLeaseInBillNewInfo billInfo = (FaLeaseInBillNewInfo)model;
        ObjectUuidPK pk = new ObjectUuidPK(billInfo.getId());
        FaRentSettlementBillFactory.getLocalInstance(ctx).createByLeaseInBillId((IObjectPK)pk);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("PaymentEntry.*");
        sic.add("Currency.*");
        sic.add("exchangeRate.*");
        sic.add("exchangeRate.exchangeAux.*");
        billInfo = FaLeaseInBillNewFactory.getLocalInstance(ctx).getFaLeaseInBillNewInfo((IObjectPK)pk, sic);
        int currencyPrecision = PrcFaLeaseInNewStrategy.getCurrencyScale(billInfo.getCompany(), ctx);
        int currencyPrecisionOC = billInfo.getCurrency().getPrecision();
        boolean exchangeRateConvertMode = true;
        if (billInfo.getExchangeRate() != null && billInfo.getExchangeRate().getExchangeAux().getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE) {
            exchangeRateConvertMode = false;
        }
        BigDecimal exchangeRateInfo = billInfo.getExchangeRateValue();
        if (billInfo.getExchangeRate() != null && billInfo.getExchangeRate().getExchangeAux().getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE) {
            exchangeRateInfo = new BigDecimal("1").divide(exchangeRateInfo, currencyPrecisionOC, 4);
        }
        if (!billInfo.isIsExempt()) {
            FaAmortizedCostRptInfo originACRptInfo;
            SimpleDateFormat sdf;
            IRowSet tmRs;
            StringBuilder tmSql;
            java.util.Date changeDate;
            FaLeaseInBillNewInfo originBillInfo;
            String deleteSql;
            PeriodInfo curPeriod;
            java.util.Date fiAccountDate;
            FaLeaseTypeEnum leaseType;
            BigDecimal initAsset = BigDecimal.ZERO;
            BigDecimal cashFlowTotal = BigDecimal.ZERO;
            BigDecimal unrecognizedFinanceFee = BigDecimal.ZERO;
            BigDecimal initAccDepreciation = BigDecimal.ZERO;
            BigDecimal remainingLiability = BigDecimal.ZERO;
            BigDecimal accDepOfAsset = BigDecimal.ZERO;
            BigDecimal accUnrFinExpenses = BigDecimal.ZERO;
            BigDecimal surplusReserve = BigDecimal.ZERO;
            BigDecimal undistributedProfit = BigDecimal.ZERO;
            boolean isInitBill = PrcFaLeaseInNewStrategy.isInitBill(ctx, billInfo, null);
            boolean isEnableStockContract = FaManageUtils.getFaParamValue((Context)ctx, (String)"NLM_HIDE_001", (String)billInfo.getCompany().getId().toString());
            boolean isDiscount2ImplDate = FaManageUtils.getIntFaParamValue((Context)ctx, (String)"NLM_303", (String)billInfo.getCompany().getId().toString()) == 0;
            FaNewLeasePolicyInfo newLeasePolicy = FaNewLeasePolicyFactory.getLocalInstance(ctx).getEnabledNewLeasePolicy(billInfo.getCompany().getId().toString());
            if (newLeasePolicy == null) {
                throw new EASBizException(new NumericExceptionSubItem("001", ResourceBase.getString((String)POLICYRESOURCE, (String)"Can_Not_Audit_Policy_Not_Set", (Locale)ctx.getOriginLocale())));
            }
            IFaAmortizedCostRpt iFaAmortizedCostRpt = FaAmortizedCostRptFactory.getLocalInstance(ctx);
            if (isInitBill && isEnableStockContract && !isDiscount2ImplDate) {
                FaAmortizedCostRptInfo stockACRptInfo = iFaAmortizedCostRpt.calc4StockContract(billInfo);
                initAsset = stockACRptInfo.getEntry().get(stockACRptInfo.getEntry().size() - 1).getInitRightOfUseAsset();
                billInfo.setInitialAsset(initAsset);
            }
            if (isInitBill && isEnableStockContract && !isDiscount2ImplDate && billInfo.getBeginDate().compareTo(billInfo.getDpInitCfmDate()) < 0) {
                if (newLeasePolicy.getTranslationMethod() == FaLiabilitiesCvMethodEnum.DAY && newLeasePolicy.getDepreciationMethod() == DepreciationMethodEnum.First) {
                    int depDateAmt = FaManageUtils.subDate((java.util.Date)billInfo.getEndDate(), (java.util.Date)billInfo.getBeginDate()) + 1;
                    int beforeDepDateAmt = FaManageUtils.subDate((java.util.Date)billInfo.getDpInitCfmDate(), (java.util.Date)billInfo.getBeginDate());
                    BigDecimal dayDep = billInfo.getInitialAsset().divide(new BigDecimal(depDateAmt), currencyPrecision, 4);
                    initAccDepreciation = new BigDecimal(beforeDepDateAmt).multiply(dayDep);
                } else {
                    int beforeTimeCycle = FaManageUtils.subMonth((java.util.Date)billInfo.getDpInitCfmDate(), (java.util.Date)billInfo.getBeginDate());
                    BigDecimal monthDep = billInfo.getInitialAsset().divide(new BigDecimal(billInfo.getTimeCycle()), currencyPrecision, 4);
                    initAccDepreciation = new BigDecimal(beforeTimeCycle).multiply(monthDep);
                }
            }
            int firstBizEntryIndex = 0;
            FaLeaseTypeEnum faLeaseTypeEnum = leaseType = billInfo.getLeaseType() == null ? FaLeaseTypeEnum.OPERATING_LEASE : billInfo.getLeaseType();
            if ((FaPayFrequencyEnum.PAY_IN_ADVANCE != billInfo.getPayFrequency() || FaLeaseTypeEnum.OPERATING_LEASE != leaseType) && newLeasePolicy.getTranslationMethod() == FaLiabilitiesCvMethodEnum.DAY && billInfo.getFirstPayTime().compareTo(billInfo.getBeginDate()) < 0) {
                ++firstBizEntryIndex;
            }
            FaLeaseInBillNewInfo paramLeaseInBill = new FaLeaseInBillNewInfo();
            paramLeaseInBill.setId(pk.getKeyValue());
            paramLeaseInBill.setInitialAsset(initAsset);
            paramLeaseInBill.setInitAccDepreciation(initAccDepreciation);
            FaAmortizedCostRptInfo prtInfo = iFaAmortizedCostRpt.calc(paramLeaseInBill);
            FaAmortizedCostRptEntryCollection collection = prtInfo.getEntry();
            if (collection != null && collection.size() > 0) {
                if (isInitBill && isEnableStockContract && !isDiscount2ImplDate) {
                    remainingLiability = FaLeaseInBillNewFactory.getLocalInstance(ctx).getFaLeaseInBillNewInfo((IObjectPK)new ObjectUuidPK(billInfo.getId().toString())).getRemainingLiability();
                    remainingLiability = remainingLiability == null ? BigDecimal.ZERO : remainingLiability;
                } else {
                    initAsset = collection.get(firstBizEntryIndex).getInitRightOfUseAsset();
                }
                cashFlowTotal = collection.get(firstBizEntryIndex).getInitLiabilityPrincipal();
                unrecognizedFinanceFee = collection.get(firstBizEntryIndex).getInitUnCfmFncCost();
            }
            if (!billInfo.isIsBeforeImplDate() && collection != null && collection.size() > 0) {
                int j;
                fiAccountDate = billInfo.getFiAccountDate();
                if (newLeasePolicy.getTranslationMethod() == FaLiabilitiesCvMethodEnum.DAY && newLeasePolicy.getDepreciationMethod() == DepreciationMethodEnum.First) {
                    java.util.Date minMonthDate = this.getMinMonthDate(fiAccountDate);
                    int j2 = collection.size();
                    for (int i = 0; i < j2; ++i) {
                        if (!this.compareDateIfPreDay(collection.get(i).getDate(), minMonthDate)) continue;
                        accDepOfAsset = collection.get(i).getCurAccDepreciation();
                        accUnrFinExpenses = collection.get(i).getCurAccInterestPayment();
                        break;
                    }
                }
                if (newLeasePolicy.getTranslationMethod() == FaLiabilitiesCvMethodEnum.DAY && newLeasePolicy.getDepreciationMethod() == DepreciationMethodEnum.Second) {
                    j = collection.size();
                    for (int i = 0; i < j && this.compareDateIfMonthPreDate(collection.get(i).getDate(), fiAccountDate); ++i) {
                        accDepOfAsset = accDepOfAsset.add(collection.get(i).getCurDepreciation());
                        accUnrFinExpenses = accUnrFinExpenses.add(collection.get(i).getCurInterestPayment());
                    }
                }
                if (newLeasePolicy.getTranslationMethod() == FaLiabilitiesCvMethodEnum.PERIOD) {
                    j = collection.size();
                    for (int i = 0; i < j; ++i) {
                        if (!this.compareDateIfPreMonth(collection.get(i).getDate(), fiAccountDate)) continue;
                        accDepOfAsset = collection.get(i).getCurAccDepreciation();
                        accUnrFinExpenses = collection.get(i).getCurAccInterestPayment();
                        break;
                    }
                }
            } else if (collection != null && collection.size() > 0) {
                fiAccountDate = billInfo.getFiAccountDate();
                java.util.Date dpInitCfmDate = billInfo.getDpInitCfmDate();
                java.util.Date minMonthDate = this.getMinMonthDate(fiAccountDate);
                int j = collection.size();
                for (int i = 0; i < j; ++i) {
                    if (!this.compareDateIfBetweenTwoDate(collection.get(i).getDate(), dpInitCfmDate, minMonthDate)) continue;
                    accDepOfAsset = accDepOfAsset.add(collection.get(i).getCurDepreciation());
                    accUnrFinExpenses = accUnrFinExpenses.add(collection.get(i).getCurInterestPayment());
                }
            }
            String updateSQL = " UPDATE T_FA_FaLeaseInBillNew SET FInitialAsset = ?, FInitialLiability = ?, FUnrecognizedFinanceFee = ?, FInitAccDepreciation = ?, FRemainingLiability = ?, FLiabilitiesCvMethod = ?, FDepreciationMethod  = ?,FAccDepOfAsset = ?, FAccUnrFinExpenses = ?,FSurplusReserve = ?, FUndistributedProfit = ?, FInterestCalculationMethod = ?, FNewLeasePolicyRefID = ? WHERE FID = ?";
            initAsset = initAsset.add(billInfo.getInitialAssetDecValue() == null ? BigDecimal.ZERO : billInfo.getInitialAssetDecValue()).setScale(currencyPrecision, 4);
            cashFlowTotal = cashFlowTotal.setScale(currencyPrecisionOC, 4);
            unrecognizedFinanceFee = unrecognizedFinanceFee.setScale(currencyPrecisionOC, 4);
            initAccDepreciation = initAccDepreciation.setScale(currencyPrecision, 4);
            accDepOfAsset = accDepOfAsset.setScale(currencyPrecision, 4);
            accUnrFinExpenses = accUnrFinExpenses.setScale(currencyPrecisionOC, 4);
            BigDecimal remainingLiabilityTmpOne = cashFlowTotal.multiply(exchangeRateInfo);
            BigDecimal remainingLiabilityTmpTwo = unrecognizedFinanceFee.multiply(exchangeRateInfo);
            remainingLiability = remainingLiabilityTmpOne.add(initAccDepreciation).subtract(initAsset).subtract(remainingLiabilityTmpTwo).add(remainingLiability);
            remainingLiability = remainingLiability.setScale(currencyPrecision, 4);
            if (isInitBill && isEnableStockContract && isDiscount2ImplDate) {
                remainingLiability = BigDecimal.ZERO;
            }
            surplusReserve = remainingLiability.multiply(new BigDecimal("0.1")).setScale(currencyPrecision, 4);
            undistributedProfit = remainingLiability.multiply(new BigDecimal("0.9")).setScale(currencyPrecision, 4);
            String depreciationMethod = newLeasePolicy.getDepreciationMethod().getValue();
            if (billInfo.getLeaseType() == FaLeaseTypeEnum.FINANCE_LEASE || billInfo.getLeaseType() == FaLeaseTypeEnum.GL_BALANCE_ENTRY) {
                depreciationMethod = "2";
                initAsset = BigDecimal.ZERO;
                cashFlowTotal = BigDecimal.ZERO;
                unrecognizedFinanceFee = BigDecimal.ZERO;
                initAccDepreciation = BigDecimal.ZERO;
                remainingLiability = BigDecimal.ZERO;
            }
            Object[] params = new Object[]{initAsset, cashFlowTotal, unrecognizedFinanceFee, initAccDepreciation, remainingLiability, newLeasePolicy.getTranslationMethod().getValue(), depreciationMethod, accDepOfAsset, accUnrFinExpenses, surplusReserve, undistributedProfit, newLeasePolicy.getInterestCalculationMethod().getValue(), newLeasePolicy.getId().toString(), pk.toString()};
            DbUtil.execute((Context)ctx, (String)updateSQL, (Object[])params);
            if (billInfo.getSourceType() == FaLeaseSourceTypeEnum.TERMINATION_CREAT) {
                FaLeaseInBillNewInfo originBillInfo2;
                BigDecimal ratio;
                Date terminateDate;
                StringBuilder tmSql2 = new StringBuilder();
                tmSql2.append("SELECT bill.FTerminateDate terminateDate, entry.FRatio ratio, entry.FLeaseInBillID billId \n");
                tmSql2.append("FROM T_FA_FaTerminateBill bill \n");
                tmSql2.append("LEFT JOIN T_FA_FaTerminateBillEntry entry ON bill.FID = entry.FBillID \n");
                tmSql2.append("WHERE entry.FCreatedLeaseInBillID = ? \n");
                IRowSet tmRs2 = DbUtil.executeQuery((Context)ctx, (String)tmSql2.toString(), (Object[])new String[]{billInfo.getId().toString()});
                try {
                    if (!tmRs2.next()) {
                        throw new EASBizException(new NumericExceptionSubItem("001", ResourceBase.getString((String)FALEASENEWRESOURCE, (String)"Association_TerminateBill_Not_Exist", (Locale)ctx.getOriginLocale())));
                    }
                    terminateDate = tmRs2.getDate("terminateDate");
                    ratio = tmRs2.getBigDecimal("ratio");
                    originBillInfo2 = FaLeaseInBillNewFactory.getLocalInstance(ctx).getFaLeaseInBillNewInfo((IObjectPK)new ObjectUuidPK(tmRs2.getString("billId")));
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                FaAmortizedCostRptInfo originACRptInfo2 = iFaAmortizedCostRpt.getFaAmortizedCostRptInfo("where leaseInBill.id = '" + originBillInfo2.getId().toString() + "' order by entry.date, id");
                FaAmortizedCostRptEntryCollection costRptEntryCollection = originACRptInfo2.getEntry();
                BigDecimal tmpOneOld = new BigDecimal("0");
                BigDecimal tmpTwoOld = new BigDecimal("0");
                java.util.Date terminateDateTmp = terminateDate;
                if (billInfo.getDepreciationMethod() == DepreciationMethodEnum.Second) {
                    terminateDateTmp = this.getMinMonthDate(terminateDateTmp);
                }
                int m = costRptEntryCollection.size();
                for (int n = 0; n < m; ++n) {
                    if (!this.compareDateIfDay(costRptEntryCollection.get(n).getDate(), terminateDateTmp)) continue;
                    tmpOneOld = costRptEntryCollection.get(n).getInitLiabilityBalance();
                    tmpOneOld = tmpOneOld.multiply(exchangeRateInfo);
                    tmpTwoOld = costRptEntryCollection.get(n).getInitLiabilityPrincipal();
                    break;
                }
                ratio = new BigDecimal("100").subtract(ratio).divide(new BigDecimal("100"), 16, 4);
                BigDecimal one = initAsset.subtract(tmpOneOld.multiply(ratio)).setScale(currencyPrecision, 4);
                BigDecimal two = cashFlowTotal.subtract(tmpTwoOld.multiply(ratio)).setScale(currencyPrecisionOC, 4);
                BigDecimal oneTmp = one.divide(exchangeRateInfo, currencyPrecisionOC, 4);
                BigDecimal three = two.subtract(oneTmp).setScale(currencyPrecisionOC, 4);
                BigDecimal four = originBillInfo2.getInitialAsset().multiply(ratio).add(one).setScale(currencyPrecision, 4);
                BigDecimal five = originBillInfo2.getInitialLiability().multiply(ratio).add(two).setScale(currencyPrecisionOC, 4);
                BigDecimal fourTmp = four.divide(exchangeRateInfo, currencyPrecisionOC, 4);
                BigDecimal six = five.subtract(fourTmp).setScale(currencyPrecisionOC, 4);
                String adjSql = "UPDATE T_FA_FaLeaseInBillNew SET FAdjustmentAsset = ?, FAdjustmentLiability = ?, FAdjustmentUnFncFee = ?, FWholeProcessAsset = ?, FWholeProcessLiability = ?, FWholeProcessUFF = ? WHERE FID = ?";
                DbUtil.execute((Context)ctx, (String)adjSql, (Object[])new Object[]{one, two, three, four, five, six, billInfo.getId().toString()});
                iFaAmortizedCostRpt.calc4Adjustment(billInfo);
                curPeriod = FlLocalUtils.getFLCurrentPeriod(billInfo.getCompany().getId().toString(), ctx);
                deleteSql = " DELETE FROM T_FA_FaDepreAndAmort where FID in (  SELECT dep.FID FROM T_FA_FaDepreAndAmort dep left join T_BD_Period period on dep.FPeriodID = period.FID  WHERE FLEASEINBILLID = ? and period.FNumber > ?) ";
                DbUtil.execute((Context)ctx, (String)deleteSql, (Object[])new Object[]{originBillInfo2.getId().toString(), curPeriod.getNumber()});
            }
            if (billInfo.getSourceType() == FaLeaseSourceTypeEnum.ASSET_CHANGE_CREAT) {
                originBillInfo = null;
                changeDate = null;
                tmSql = new StringBuilder();
                tmSql.append("SELECT * \n");
                tmSql.append(" FROM T_FA_FaNLMChangeAssetItem \n");
                tmSql.append("WHERE FLEASEINBILLNEWID = ? \n");
                tmRs = DbUtil.executeQuery((Context)ctx, (String)tmSql.toString(), (Object[])new String[]{billInfo.getId().toString()});
                try {
                    if (tmRs.next()) {
                        originBillInfo = FaLeaseInBillNewFactory.getLocalInstance(ctx).getFaLeaseInBillNewInfo((IObjectPK)new ObjectUuidPK(tmRs.getString("FLEASEINBILLOLDID")));
                        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        changeDate = sdf.parse(tmRs.getString("FChangeDate"));
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                catch (ParseException e) {
                    throw new BOSException((Throwable)e);
                }
                changeDate = billInfo.getBeginDate();
                originACRptInfo = iFaAmortizedCostRpt.getFaAmortizedCostRptInfo("where leaseInBill.id = '" + originBillInfo.getId().toString() + "' order by entry.date, id");
                FaAmortizedCostRptEntryCollection costRptEntryCollection = originACRptInfo.getEntry();
                BigDecimal tmpOneOld = new BigDecimal("0");
                BigDecimal tmpTwoOld = new BigDecimal("0");
                java.util.Date changeDateTmp = changeDate;
                if (billInfo.getDepreciationMethod() == DepreciationMethodEnum.Second) {
                    changeDateTmp = this.getMinMonthDate(changeDateTmp);
                }
                int m = costRptEntryCollection.size();
                for (int n = 0; n < m; ++n) {
                    if (!this.compareDateIfDay(costRptEntryCollection.get(n).getDate(), changeDateTmp)) continue;
                    tmpOneOld = costRptEntryCollection.get(n).getInitLiabilityBalance();
                    tmpOneOld = tmpOneOld.multiply(exchangeRateInfo);
                    tmpTwoOld = costRptEntryCollection.get(n).getInitLiabilityPrincipal();
                    break;
                }
                BigDecimal one = initAsset.subtract(tmpOneOld).setScale(currencyPrecision, 4);
                BigDecimal two = cashFlowTotal.subtract(tmpTwoOld).setScale(currencyPrecisionOC, 4);
                BigDecimal oneTmp = one.divide(exchangeRateInfo, currencyPrecisionOC, 4);
                BigDecimal three = two.subtract(oneTmp).setScale(currencyPrecisionOC, 4);
                BigDecimal four = originBillInfo.getInitialAsset().add(one).setScale(currencyPrecision, 4);
                BigDecimal five = originBillInfo.getInitialLiability().add(two).setScale(currencyPrecisionOC, 4);
                BigDecimal six = originBillInfo.getUnrecognizedFinanceFee().add(three).setScale(currencyPrecisionOC, 4);
                String adjSql = "UPDATE T_FA_FaLeaseInBillNew SET FAdjustmentAsset = ?, FAdjustmentLiability = ?, FAdjustmentUnFncFee = ?, FWholeProcessAsset = ?, FWholeProcessLiability = ?, FWholeProcessUFF = ? WHERE FID = ?";
                DbUtil.execute((Context)ctx, (String)adjSql, (Object[])new Object[]{one, two, three, four, five, six, billInfo.getId().toString()});
                FaAmortizedCostRptInfo newACRptInfo = iFaAmortizedCostRpt.calc4Adjustment(billInfo);
                java.util.Date newBeginDate = billInfo.getBeginDate();
                java.util.Date newFiAccountDate = billInfo.getFiAccountDate();
                BigDecimal adjustAccDepAsset = this.getAdjustForType(ctx, originACRptInfo, newACRptInfo, newBeginDate, newFiAccountDate, "Dep");
                BigDecimal adjustDecAsset = this.getAdjustForType(ctx, originACRptInfo, newACRptInfo, newBeginDate, newFiAccountDate, "Dec");
                BigDecimal adjustInterestPayment = this.getAdjustForType(ctx, originACRptInfo, newACRptInfo, newBeginDate, newFiAccountDate, "InterestPayment");
                String updateSQLTmp = "UPDATE T_FA_FaLeaseInBillNew SET FBizStatus = 7 WHERE FID = ?";
                DbUtil.execute((Context)ctx, (String)updateSQLTmp, (Object[])new Object[]{originBillInfo.getId().toString()});
                String updateSQLNewTmp = "UPDATE T_FA_FaLeaseInBillNew SET FAdjustAccDepAsset = ?, FAdjustDecAsset = ?, FAdjustInterestPayment = ? WHERE FID = ?";
                DbUtil.execute((Context)ctx, (String)updateSQLNewTmp, (Object[])new Object[]{adjustAccDepAsset, adjustDecAsset, adjustInterestPayment, billInfo.getId().toString()});
                PeriodInfo curPeriod2 = FlLocalUtils.getFLCurrentPeriod(billInfo.getCompany().getId().toString(), ctx);
                String deleteSql2 = " DELETE FROM T_FA_FaDepreAndAmort where FID in (  SELECT dep.FID FROM T_FA_FaDepreAndAmort dep left join T_BD_Period period on dep.FPeriodID = period.FID  WHERE FLEASEINBILLID = ? and period.FNumber >= ?) ";
                DbUtil.execute((Context)ctx, (String)deleteSql2, (Object[])new Object[]{originBillInfo.getId().toString(), curPeriod2.getNumber()});
            }
            if (billInfo.getSourceType() == FaLeaseSourceTypeEnum.RETROACTIVE_ADJUSTMENT_CREAT) {
                originBillInfo = null;
                changeDate = null;
                tmSql = new StringBuilder();
                tmSql.append("SELECT * \n");
                tmSql.append(" FROM T_FA_FaNLMChangeAssetItem \n");
                tmSql.append("WHERE FLEASEINBILLNEWID = ? \n");
                tmRs = DbUtil.executeQuery((Context)ctx, (String)tmSql.toString(), (Object[])new String[]{billInfo.getId().toString()});
                try {
                    if (tmRs.next()) {
                        originBillInfo = FaLeaseInBillNewFactory.getLocalInstance(ctx).getFaLeaseInBillNewInfo((IObjectPK)new ObjectUuidPK(tmRs.getString("FLEASEINBILLOLDID")), this.getLeaseInBillSelector());
                        billInfo = FaLeaseInBillNewFactory.getLocalInstance(ctx).getFaLeaseInBillNewInfo((IObjectPK)new ObjectUuidPK(billInfo.getId()), this.getLeaseInBillSelector());
                        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        changeDate = sdf.parse(tmRs.getString("FChangeDate"));
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                catch (ParseException e) {
                    throw new BOSException((Throwable)e);
                }
                originACRptInfo = null;
                if (iFaAmortizedCostRpt != null) {
                    originACRptInfo = iFaAmortizedCostRpt.getFaAmortizedCostRptInfo("where leaseInBill.id = '" + (originBillInfo == null ? null : originBillInfo.getId().toString()) + "' order by entry.date, id");
                }
                FaAmortizedCostRptInfo newACRptInfo = iFaAmortizedCostRpt.getFaAmortizedCostRptInfo("where leaseInBill.id = '" + billInfo.getId().toString() + "' order by entry.date, id");
                java.util.Date newBeginDate = billInfo.getBeginDate();
                java.util.Date newFiAccountDate = billInfo.getFiAccountDate();
                BigDecimal one = billInfo.getInitialAsset().subtract(originBillInfo.getInitialAsset()).setScale(currencyPrecision, 4);
                BigDecimal two = billInfo.getInitialLiability().subtract(originBillInfo.getInitialLiability()).setScale(currencyPrecisionOC, 4);
                if (originBillInfo.isIsBeforeImplDate() && isDiscount2ImplDate) {
                    java.util.Date dpInitCfmDate = billInfo.getDpInitCfmDate();
                    FaAmortizedCostRptEntryInfo entryInfoNew = FaAmortizedCostRptEntryFactory.getLocalInstance(ctx).getFaAmortizedCostRptEntryInfo("where date = {d '" + dpInitCfmDate + "'} and amortizedCostRpt.leaseInBill.id = '" + billInfo.getId().toString() + "'");
                    FaAmortizedCostRptEntryInfo entryInfoOld = originACRptInfo.getEntry().get(0);
                    one = entryInfoNew.getInitLiabilityBalance().subtract(entryInfoOld.getInitLiabilityBalance()).setScale(currencyPrecision, 4);
                    two = entryInfoNew.getInitLiabilityPrincipal().subtract(entryInfoOld.getInitLiabilityPrincipal()).setScale(currencyPrecisionOC, 4);
                }
                if (originBillInfo.isIsBeforeImplDate() && !isDiscount2ImplDate) {
                    two = billInfo.getRentWithTaxNew().subtract(originBillInfo.getRentWithTaxNew()).setScale(currencyPrecisionOC, 4);
                }
                BigDecimal oneTmp = one.divide(exchangeRateInfo, currencyPrecisionOC, 4);
                BigDecimal three = two.subtract(oneTmp).setScale(currencyPrecisionOC, 4);
                BigDecimal accDeprAdjustment = this.getRetroactiveAdjustForType(ctx, isDiscount2ImplDate, originBillInfo, billInfo, originACRptInfo, newACRptInfo, newBeginDate, newFiAccountDate, "accDeprAdjustment");
                BigDecimal accInterestAdjustment = this.getRetroactiveAdjustForType(ctx, isDiscount2ImplDate, originBillInfo, billInfo, originACRptInfo, newACRptInfo, newBeginDate, newFiAccountDate, "accInterestAdjustment");
                String adjSql = "UPDATE T_FA_FaLeaseInBillNew SET FAdjustmentAsset = ?, FAdjustmentLiability = ?, FAdjustmentUnFncFee = ?, FAccDeprAdjustment = ?, FAccInterestAdjustment = ? WHERE FID = ?";
                DbUtil.execute((Context)ctx, (String)adjSql, (Object[])new Object[]{one, two, three, accDeprAdjustment, accInterestAdjustment, billInfo.getId().toString()});
                BigDecimal adjustAccDepAsset = BigDecimal.ZERO;
                BigDecimal adjustDecAsset = BigDecimal.ZERO;
                BigDecimal adjustInterestPayment = BigDecimal.ZERO;
                String updateSQLTmp = "UPDATE T_FA_FaLeaseInBillNew SET FBizStatus = 11, FAdjustAccDepAsset = ?, FAdjustDecAsset = ?, FAdjustInterestPayment = ? WHERE FID = ?";
                DbUtil.execute((Context)ctx, (String)updateSQLTmp, (Object[])new Object[]{adjustAccDepAsset, adjustDecAsset, adjustInterestPayment, originBillInfo.getId().toString()});
                curPeriod = FlLocalUtils.getFLCurrentPeriod(billInfo.getCompany().getId().toString(), ctx);
                deleteSql = " DELETE FROM T_FA_FaDepreAndAmort where FID in (  SELECT dep.FID FROM T_FA_FaDepreAndAmort dep left join T_BD_Period period on dep.FPeriodID = period.FID  WHERE FLEASEINBILLID = ? and period.FNumber >= ?) ";
                DbUtil.execute((Context)ctx, (String)deleteSql, (Object[])new Object[]{originBillInfo.getId().toString(), curPeriod.getNumber()});
            }
        }
        NLMAssetCalculationDetailFactory.getLocalInstance(ctx).saveNLMAssetCalcByBillId((IObjectPK)pk);
        String updateSQL = "UPDATE T_FA_FaLeaseInBillNew SET FBizStatus = 1 WHERE FID = ?";
        DbUtil.execute((Context)ctx, (String)updateSQL, (Object[])new String[]{pk.toString()});
        FaLeaseInBillNewFactory.getLocalInstance(ctx).passAuditSelf((IObjectPK)pk, billInfo);
    }

    private BigDecimal getAdjustForType(Context ctx, FaAmortizedCostRptInfo originACRptInfo, FaAmortizedCostRptInfo newACRptInfo, java.util.Date newBeginDate, java.util.Date newFiAccountDate, String type) {
        int i;
        BigDecimal originValue = new BigDecimal("0");
        BigDecimal newValue = new BigDecimal("0");
        FaAmortizedCostRptEntryCollection originACRptEntry = originACRptInfo.getEntry();
        FaAmortizedCostRptEntryCollection newACRptEntry = newACRptInfo.getEntry();
        Calendar cld = Calendar.getInstance();
        cld.setTime(newFiAccountDate);
        cld.set(5, 1);
        cld.set(12, 0);
        cld.set(13, 0);
        cld.set(14, 0);
        newFiAccountDate = cld.getTime();
        Calendar cld1 = Calendar.getInstance();
        cld1.setTime(newBeginDate);
        cld1.set(5, 1);
        cld1.set(12, 0);
        cld1.set(13, 0);
        cld1.set(14, 0);
        newBeginDate = cld1.getTime();
        int j = originACRptEntry.size();
        for (i = 0; i < j; ++i) {
            if (originACRptEntry.get(i).getDate().compareTo(newBeginDate) < 0 || originACRptEntry.get(i).getDate().compareTo(newFiAccountDate) >= 0) continue;
            if ("Dep".equals(type)) {
                originValue = originValue.add(originACRptEntry.get(i).getCurDepreciation() == null ? new BigDecimal("0") : originACRptEntry.get(i).getCurDepreciation());
            }
            if ("Dec".equals(type)) {
                originValue = originValue.add(originACRptEntry.get(i).getInitialAssetDecValue() == null ? new BigDecimal("0") : originACRptEntry.get(i).getInitialAssetDecValue());
            }
            if (!"InterestPayment".equals(type)) continue;
            originValue = originValue.add(originACRptEntry.get(i).getCurInterestPayment() == null ? new BigDecimal("0") : originACRptEntry.get(i).getCurInterestPayment());
        }
        j = newACRptEntry.size();
        for (i = 0; i < j; ++i) {
            if (newACRptEntry.get(i).getDate().compareTo(newBeginDate) < 0 || newACRptEntry.get(i).getDate().compareTo(newFiAccountDate) >= 0) continue;
            if ("Dep".equals(type)) {
                newValue = newValue.add(newACRptEntry.get(i).getCurDepreciation() == null ? new BigDecimal("0") : newACRptEntry.get(i).getCurDepreciation());
            }
            if ("Dec".equals(type)) {
                newValue = newValue.add(newACRptEntry.get(i).getInitialAssetDecValue() == null ? new BigDecimal("0") : newACRptEntry.get(i).getInitialAssetDecValue());
            }
            if (!"InterestPayment".equals(type)) continue;
            newValue = newValue.add(newACRptEntry.get(i).getCurInterestPayment() == null ? new BigDecimal("0") : newACRptEntry.get(i).getCurInterestPayment());
        }
        return newValue.subtract(originValue);
    }

    private BigDecimal getRetroactiveAdjustForType(Context ctx, boolean isDiscount2ImplDate, FaLeaseInBillNewInfo originBillInfo, FaLeaseInBillNewInfo newBillInfo, FaAmortizedCostRptInfo originACRptInfo, FaAmortizedCostRptInfo newACRptInfo, java.util.Date newBeginDate, java.util.Date newFiAccountDate, String type) throws EASBizException, BOSException {
        int i;
        int j;
        BigDecimal interestOld;
        BigDecimal depOld;
        BigDecimal interestNew;
        int i2;
        BigDecimal originValue = new BigDecimal("0");
        BigDecimal newValue = new BigDecimal("0");
        FaAmortizedCostRptEntryCollection originACRptEntry = originACRptInfo.getEntry();
        FaAmortizedCostRptEntryCollection newACRptEntry = newACRptInfo.getEntry();
        Calendar cld = Calendar.getInstance();
        cld.setTime(newFiAccountDate);
        cld.set(5, 1);
        cld.set(12, 0);
        cld.set(13, 0);
        cld.set(14, 0);
        newFiAccountDate = cld.getTime();
        java.util.Date perNewFiAccountDate = this.perDate(newFiAccountDate);
        Calendar cld1 = Calendar.getInstance();
        cld1.setTime(newBillInfo.getDpInitCfmDate());
        cld1.set(5, 1);
        cld1.set(12, 0);
        cld1.set(13, 0);
        cld1.set(14, 0);
        java.util.Date dpInitCfmDate = cld1.getTime();
        int j2 = originACRptEntry.size();
        for (i2 = 0; i2 < j2; ++i2) {
            if (originACRptEntry.get(i2).getDate().compareTo(newFiAccountDate) >= 0) continue;
            if ("accDeprAdjustment".equals(type)) {
                originValue = originValue.add(originACRptEntry.get(i2).getCurDepreciation() == null ? new BigDecimal("0") : originACRptEntry.get(i2).getCurDepreciation());
            }
            if (!"accInterestAdjustment".equals(type)) continue;
            originValue = originValue.add(originACRptEntry.get(i2).getCurInterestPayment() == null ? new BigDecimal("0") : originACRptEntry.get(i2).getCurInterestPayment());
        }
        j2 = newACRptEntry.size();
        for (i2 = 0; i2 < j2; ++i2) {
            if (newACRptEntry.get(i2).getDate().compareTo(newFiAccountDate) >= 0) continue;
            if ("accDeprAdjustment".equals(type)) {
                newValue = newValue.add(newACRptEntry.get(i2).getCurDepreciation() == null ? new BigDecimal("0") : newACRptEntry.get(i2).getCurDepreciation());
            }
            if (!"accInterestAdjustment".equals(type)) continue;
            newValue = newValue.add(newACRptEntry.get(i2).getCurInterestPayment() == null ? new BigDecimal("0") : newACRptEntry.get(i2).getCurInterestPayment());
        }
        BigDecimal result = newValue.subtract(originValue);
        if (originBillInfo.isIsBeforeImplDate() && isDiscount2ImplDate) {
            BigDecimal depNew = BigDecimal.ZERO;
            interestNew = BigDecimal.ZERO;
            depOld = BigDecimal.ZERO;
            interestOld = BigDecimal.ZERO;
            j = newACRptEntry.size();
            for (i = 0; i < j; ++i) {
                if (newACRptEntry.get(i).getDate().compareTo(dpInitCfmDate) < 0 || newACRptEntry.get(i).getDate().compareTo(newFiAccountDate) >= 0) continue;
                depNew = depNew.add(newACRptEntry.get(i).getCurDepreciation() == null ? new BigDecimal("0") : newACRptEntry.get(i).getCurDepreciation());
                interestNew = interestNew.add(newACRptEntry.get(i).getCurInterestPayment() == null ? new BigDecimal("0") : newACRptEntry.get(i).getCurInterestPayment());
            }
            j = originACRptEntry.size();
            for (i = 0; i < j; ++i) {
                if (originACRptEntry.get(i).getDate().compareTo(perNewFiAccountDate) != 0) continue;
                depOld = originACRptEntry.get(i).getCurAccDepreciation() == null ? new BigDecimal("0") : originACRptEntry.get(i).getCurAccDepreciation();
                interestOld = originACRptEntry.get(i).getCurAccInterestPayment() == null ? new BigDecimal("0") : originACRptEntry.get(i).getCurAccInterestPayment();
                break;
            }
            if ("accDeprAdjustment".equals(type)) {
                result = depNew.subtract(depOld);
            }
            if ("accInterestAdjustment".equals(type)) {
                result = interestNew.subtract(interestOld);
            }
        }
        if (originBillInfo.isIsBeforeImplDate() && !isDiscount2ImplDate) {
            BigDecimal depNew = newBillInfo.getAccDepOfAsset() == null ? new BigDecimal("0") : newBillInfo.getAccDepOfAsset();
            interestNew = newBillInfo.getAccUnrFinExpenses() == null ? new BigDecimal("0") : newBillInfo.getAccUnrFinExpenses();
            depOld = BigDecimal.ZERO;
            interestOld = BigDecimal.ZERO;
            j = originACRptEntry.size();
            for (i = 0; i < j; ++i) {
                if (originACRptEntry.get(i).getDate().compareTo(perNewFiAccountDate) != 0) continue;
                depOld = originACRptEntry.get(i).getCurAccDepreciation() == null ? new BigDecimal("0") : originACRptEntry.get(i).getCurAccDepreciation();
                depOld = depOld.add(originBillInfo.getInitAccDepreciation());
                interestOld = originACRptEntry.get(i).getCurAccInterestPayment() == null ? new BigDecimal("0") : originACRptEntry.get(i).getCurAccInterestPayment();
                BigDecimal exchangeRateInfo = new BigDecimal(originBillInfo.getExchangeRateValue().toString());
                if (originBillInfo.getExchangeRate() != null && originBillInfo.getExchangeRate().getExchangeAux().getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE) {
                    exchangeRateInfo = BigDecimal.ONE.divide(exchangeRateInfo, originBillInfo.getCompany().getBaseCurrency().getPrecision(), 4);
                }
                BigDecimal tmpValueOne = originBillInfo.getRentWithTax() == null ? BigDecimal.ZERO : originBillInfo.getRentWithTax();
                BigDecimal tmpValueTwo = originBillInfo.getInitialAsset() == null ? BigDecimal.ZERO : originBillInfo.getInitialAsset().divide(exchangeRateInfo, originBillInfo.getCompany().getBaseCurrency().getPrecision(), 4);
                BigDecimal tmpValueThree = this.calcAdvPaymentNPV(originBillInfo, this.calcDiscountRate(ctx, originBillInfo));
                BigDecimal tmpValueFour = originBillInfo.getRecoveryCostNPV() == null ? BigDecimal.ZERO : originBillInfo.getRecoveryCostNPV();
                BigDecimal tmpValueFire = originBillInfo.isIsDeductible() ? originBillInfo.getCostPmWithoutTaxOC2() : originBillInfo.getCostPmWithTaxOC2();
                tmpValueFire = tmpValueFire == null ? BigDecimal.ZERO : tmpValueFire;
                BigDecimal tmpValueSix = originBillInfo.getStampTaxStM() == null ? BigDecimal.ZERO : originBillInfo.getStampTaxStM().divide(exchangeRateInfo, originBillInfo.getCompany().getBaseCurrency().getPrecision(), 4);
                BigDecimal tmpValueSeven = originBillInfo.isIsDeductible() ? originBillInfo.getCostPmWithoutTaxOC7() : originBillInfo.getCostPmWithTaxOC7();
                tmpValueSeven = tmpValueSeven == null ? BigDecimal.ZERO : tmpValueSeven;
                BigDecimal tmpValueEight = originBillInfo.getUnrecognizedFinanceFee() == null ? BigDecimal.ZERO : originBillInfo.getUnrecognizedFinanceFee();
                BigDecimal tmpValue = tmpValueOne.subtract(tmpValueTwo).add(tmpValueThree).add(tmpValueFour).add(tmpValueFire).add(tmpValueSix).subtract(tmpValueSeven).subtract(tmpValueEight);
                interestOld = interestOld.add(tmpValue);
                break;
            }
            if ("accDeprAdjustment".equals(type)) {
                result = depNew.subtract(depOld);
            }
            if ("accInterestAdjustment".equals(type)) {
                result = interestNew.subtract(interestOld);
            }
        }
        return result;
    }

    @Override
    public void unAuditBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        FaLeaseInBillNewInfo leaseInNewInfo = (FaLeaseInBillNewInfo)model;
        ObjectUuidPK pk = new ObjectUuidPK(leaseInNewInfo.getId());
        String updateSQL = " UPDATE T_FA_FaLeaseInBillNew SET FBizStatus = 0, FDepreciationMethod = null, FInterestCalculationMethod = null, FNewLeasePolicyRefID = null WHERE FID = ?";
        Object[] params = new Object[]{leaseInNewInfo.getId().toString()};
        DbUtil.execute((Context)ctx, (String)updateSQL, (Object[])params);
        String linkLeaseInBillId = FaLeaseInBillNewFactory.getLocalInstance(ctx).getLinkLeaseInBillIdForAssetChangeUp(leaseInNewInfo.getId().toString());
        if (linkLeaseInBillId != null) {
            String updateOriginSQL = " UPDATE T_FA_FaLeaseInBillNew SET FBizStatus = FBizStatus - 1 WHERE FID = ?";
            Object[] originParams = new Object[]{linkLeaseInBillId};
            DbUtil.execute((Context)ctx, (String)updateOriginSQL, (Object[])originParams);
        }
        FaLeaseInBillNewFactory.getLocalInstance(ctx).unpassAuditSelf((IObjectPK)pk, leaseInNewInfo);
        FaAmortizedCostRptFactory.getLocalInstance(ctx).deleteByBillId((IObjectPK)pk);
        FaRentSettlementBillFactory.getLocalInstance(ctx).deleteByLeaseBillId((IObjectPK)pk);
        NLMAssetCalculationDetailFactory.getLocalInstance(ctx).deleteByBillId((IObjectPK)pk);
    }

    @Override
    protected void generateVourcher(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
    }

    private void checkContractNumber(Context ctx, FaLeaseInBillNewInfo bill) throws BOSException, EASBizException {
        if (bill.getContractNumber() == null) {
            return;
        }
        if (bill.getSourceType() == FaLeaseSourceTypeEnum.TERMINATION_CREAT) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("contractNumber", (Object)bill.getContractNumber()));
        filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)bill.getCU().getId().toString()));
        if (bill.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)bill.getId().toString(), CompareType.NOTEQUALS));
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        FaLeaseInBillNewCollection leaseInBillCol = FaLeaseInBillNewFactory.getLocalInstance(ctx).getFaLeaseInBillNewCollection(view);
        if (leaseInBillCol != null && leaseInBillCol.size() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("001", ResourceBase.getString((String)FALEASENEWRESOURCE, (String)"Contract_Number_Exists", (Locale)ctx.getOriginLocale())));
        }
    }

    @Override
    public void checkForDelete(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        if (pk == null || pk.toString().length() == 0) {
            return;
        }
        BillBaseInfo billInfo = this.perpareBillInfo(ctx, pk);
        this.checkStateForDel(ctx, billInfo);
    }

    @Override
    protected void checkStateForDel(Context ctx, BillBaseInfo billInfo) throws FaCardException {
        StringBuffer sbMsg = new StringBuffer("");
        try {
            FaLeaseInBillNewInfo leaseInBillInfo = (FaLeaseInBillNewInfo)billInfo;
            if (!PrcFaLeaseInNewStrategy.isInitBill(ctx, leaseInBillInfo, null) && billInfo.get("checkedStatus").equals(new Integer(2))) {
                sbMsg.append(" ");
                sbMsg.append(this.getCheckedStatus(billInfo, ctx));
            }
            if (!PrcFaLeaseInNewStrategy.isInitBill(ctx, leaseInBillInfo, null) && billInfo.getBoolean("fiVouchered")) {
                sbMsg.append(" ");
                sbMsg.append(this.getIsVouchered(billInfo, ctx));
            }
        }
        catch (Exception e) {
            sbMsg.append(" ");
            sbMsg.append(e.getMessage());
        }
        if (billInfo.get("blockedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getBlockedStatus(billInfo, ctx));
        }
        if (sbMsg.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append("[" + billInfo.getNumber() + "]");
            sbAll.append(sbMsg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_DELETED, (Object[])new String[]{sbAll.toString()});
        }
    }

    public boolean isEndInit(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        ISystemStatusCtrol ictrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        boolean isStart = ictrol.isStart(SystemEnum.FINANCE_LEASE.getValue(), company.getId().toString());
        return isStart;
    }

    public static boolean isInitBill(Context ctx, FaLeaseInBillNewInfo billInfo, IObjectPK pk) throws EASBizException, BOSException {
        if (billInfo == null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("isHistory");
            selector.add("company.id");
            selector.add("company.number");
            billInfo = FaLeaseInBillNewFactory.getLocalInstance(ctx).getFaLeaseInBillNewInfo(pk, selector);
        }
        return billInfo.isIsHistory();
    }

    @Override
    public void checkForSave(Context ctx, IObjectValue val) throws EASBizException, BOSException {
        ObjectUuidPK pk;
        ObjectUuidPK objectUuidPK = pk = val.get("id") == null ? null : new ObjectUuidPK(val.get("id").toString());
        if (pk == null || pk.toString().length() == 0) {
            return;
        }
        IBillBase iBillBase = (IBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSUuid.read((String)pk.toString()).getType());
        if (!iBillBase.exists("where id='" + pk + "'")) {
            return;
        }
        BillBaseInfo billInfo = this.perpareBillInfo(ctx, (IObjectPK)pk);
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("effectedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getEffectedStatus(billInfo, ctx));
        }
        if (billInfo.get("DeletedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getDeletedStatus(billInfo, ctx));
        }
        if (billInfo.get("blockedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getBlockedStatus(billInfo, ctx));
        }
        if (FlLocalUtils.isCurrencyDisable(ctx, billInfo)) {
            sbMsg.append(" ");
            sbMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"CurrencyDisable", (Locale)ctx.getOriginLocale()));
        }
    }

    @Override
    public void checkForEdit(Context ctx, IObjectValue val) throws EASBizException, BOSException {
        FaLeaseInBillNewInfo leaseInBillInfo;
        ObjectUuidPK pk;
        ObjectUuidPK objectUuidPK = pk = val.get("id") == null ? null : new ObjectUuidPK(val.get("id").toString());
        if (pk == null || pk.toString().length() == 0) {
            return;
        }
        BillBaseInfo billInfo = this.perpareBillInfo(ctx, (IObjectPK)pk);
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("DeletedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getDeletedStatus(billInfo, ctx));
        }
        if (billInfo.get("checkedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(billInfo, ctx));
        }
        if (billInfo.get("blockedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getBlockedStatus(billInfo, ctx));
        }
        if (!PrcFaLeaseInNewStrategy.isInitBill(ctx, leaseInBillInfo = (FaLeaseInBillNewInfo)billInfo, null) && billInfo.getBoolean("fiVouchered")) {
            sbMsg.append(" ");
            sbMsg.append(this.getIsVouchered(billInfo, ctx));
        }
        if (FlLocalUtils.isCurrencyDisable(ctx, billInfo)) {
            sbMsg.append(" ");
            sbMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"CurrencyDisable", (Locale)ctx.getOriginLocale()));
        }
        if (sbMsg.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append(sbMsg);
            throw new FaCardException(FaCardException.UN_SUCCESS, (Object[])new String[]{sbAll.toString()});
        }
    }

    @Override
    public void checkForAudit(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        if (pk == null || pk.toString().length() == 0) {
            return;
        }
        FaLeaseInBillNewInfo billInfo = (FaLeaseInBillNewInfo)this.perpareBillInfo(ctx, pk);
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("DeletedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getDeletedStatus((BillBaseInfo)billInfo, ctx));
        }
        if (billInfo.get("EffectedStatus").equals(new Integer(1))) {
            sbMsg.append(" ");
            sbMsg.append(this.getEffectedStatus((BillBaseInfo)billInfo, ctx));
            sbMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"46_FaLeaseChangeBillControllerBean", (Locale)ctx.getLocale()));
        }
        if (billInfo.get("checkedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus((BillBaseInfo)billInfo, ctx));
        }
        if (billInfo.get("blockedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getBlockedStatus((BillBaseInfo)billInfo, ctx));
        }
        if (!PrcFaLeaseInNewStrategy.isInitBill(ctx, billInfo, null) && billInfo.getBoolean("fiVouchered")) {
            sbMsg.append(" ");
            sbMsg.append(this.getIsVouchered((BillBaseInfo)billInfo, ctx));
        }
        if (FlLocalUtils.isCurrencyDisable(ctx, (BillBaseInfo)billInfo)) {
            sbMsg.append(" ");
            sbMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"CurrencyDisable", (Locale)ctx.getOriginLocale()));
        }
        if (sbMsg.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append(sbMsg);
            throw new FaCardException(FaCardException.UN_SUCCESS, (Object[])new String[]{sbAll.toString()});
        }
    }

    @Override
    public void checkForUnAudit(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        if (pk == null || pk.toString().length() == 0) {
            return;
        }
        FaLeaseInBillNewInfo billInfo = (FaLeaseInBillNewInfo)this.perpareBillInfo(ctx, pk);
        boolean isFromSource = this.getTempParam().get("FROM_SOURCE") == null ? false : (Boolean)this.getTempParam().get("FROM_SOURCE");
        PeriodInfo curPeriod = FlLocalUtils.getFLCurrentPeriod(billInfo.getCompany().getId().toString(), ctx);
        java.util.Date bizDate = billInfo.getBizDate();
        if (bizDate != null && ((bizDate = DateTimeUtils.truncateDate((java.util.Date)bizDate)).compareTo(curPeriod.getBeginDate()) < 0 || bizDate.compareTo(curPeriod.getEndDate()) > 0)) {
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, (Object[])new String[]{"", ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"NOT_IN_CURPERIOD", (Locale)ctx.getOriginLocale())});
        }
        if (this.isEndInit(ctx, billInfo.getCompany()) && PrcFaLeaseInNewStrategy.isInitBill(ctx, billInfo, null)) {
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, (Object[])new String[]{"", ResourceBase.getString((String)FALEASENEWRESOURCE, (String)"Init_End", (Locale)ctx.getOriginLocale()) + "\uff0c" + ResourceBase.getString((String)FALEASENEWRESOURCE, (String)"This_Is_Init_Bill", (Locale)ctx.getOriginLocale())});
        }
        if (billInfo.getBizStatus().getValue() == 4) {
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, (Object[])new String[]{"", ResourceBase.getString((String)FALEASENEWRESOURCE, (String)"Terminated", (Locale)ctx.getOriginLocale())});
        }
        if (billInfo.getBizStatus().getValue() == 5) {
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, (Object[])new String[]{"", ResourceBase.getString((String)FALEASENEWRESOURCE, (String)"Have_Terminated", (Locale)ctx.getOriginLocale())});
        }
        if (billInfo.getBizStatus().getValue() == 2) {
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, (Object[])new String[]{"", ResourceBase.getString((String)FALEASENEWRESOURCE, (String)"Changing", (Locale)ctx.getOriginLocale())});
        }
        if (billInfo.getBizStatus().getValue() == 3) {
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, (Object[])new String[]{"", ResourceBase.getString((String)FALEASENEWRESOURCE, (String)"Have_Change", (Locale)ctx.getOriginLocale())});
        }
        if (billInfo.getBizStatus().getValue() == 6) {
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, (Object[])new String[]{"", ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"81_PrcFaLeaseInNewStrategy", (Locale)ctx.getLocale())});
        }
        if (billInfo.getBizStatus().getValue() == 7) {
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, (Object[])new String[]{"", ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"82_PrcFaLeaseInNewStrategy", (Locale)ctx.getLocale())});
        }
        if (billInfo.getBizStatus().getValue() == 10) {
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, (Object[])new String[]{"", ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"83_PrcFaLeaseInNewStrategy", (Locale)ctx.getLocale())});
        }
        if (billInfo.getBizStatus().getValue() == 11) {
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, (Object[])new String[]{"", ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"84_PrcFaLeaseInNewStrategy", (Locale)ctx.getLocale())});
        }
        if (billInfo.getBizStatus().getValue() == 8) {
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, (Object[])new String[]{"", ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"85_PrcFaLeaseInNewStrategy", (Locale)ctx.getLocale())});
        }
        if (billInfo.getBizStatus().getValue() == 9) {
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, (Object[])new String[]{"", ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"86_PrcFaLeaseInNewStrategy", (Locale)ctx.getLocale())});
        }
        StringBuilder ckVoucherSQL = new StringBuilder();
        ckVoucherSQL.append(" SELECT Fid ");
        ckVoucherSQL.append(" FROM T_FA_FaDepreAndAmort ");
        ckVoucherSQL.append(" WHERE FLeaseInBillID = ? AND FiVouchered = 1 ");
        IRowSet ckVoucherRs = DbUtil.executeQuery((Context)ctx, (String)ckVoucherSQL.toString(), (Object[])new Object[]{billInfo.getId().toString()});
        try {
            if (ckVoucherRs.next()) {
                throw new FaLeaseException(FaLeaseException.HASVOUCHER);
            }
        }
        catch (SQLException throwables) {
            throw new BOSException((Throwable)throwables);
        }
        FaLeaseInBillNewCollection leaseInNewCol = new FaLeaseInBillNewCollection();
        leaseInNewCol.add(billInfo);
        FlLocalUtils.checkRSDownBillGenInFuturePeriod(ctx, (IObjectCollection)leaseInNewCol, curPeriod);
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("DeletedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getDeletedStatus((BillBaseInfo)billInfo, ctx));
        }
        if (billInfo.get("EffectedStatus").equals(new Integer(1))) {
            sbMsg.append(" ");
            sbMsg.append(this.getEffectedStatus((BillBaseInfo)billInfo, ctx));
        }
        if (billInfo.get("checkedStatus").equals(new Integer(1))) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus((BillBaseInfo)billInfo, ctx));
        }
        if (billInfo.get("blockedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getBlockedStatus((BillBaseInfo)billInfo, ctx));
        }
        if (!PrcFaLeaseInNewStrategy.isInitBill(ctx, billInfo, null) && billInfo.getBoolean("fiVouchered")) {
            sbMsg.append(" ");
            sbMsg.append(this.getIsVouchered((BillBaseInfo)billInfo, ctx));
        }
        if (sbMsg.toString().trim().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            String tips = " " + billInfo.getNumber();
            sbAll.append(tips + sbMsg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, (Object[])new String[]{"", sbAll.toString()});
        }
        this.checkForUnAudit(ctx, (BillBaseInfo)billInfo, isFromSource);
    }

    @Override
    protected void checkForUnAudit(Context ctx, BillBaseInfo billInfo, boolean isFromSource) throws EASBizException, BOSException {
    }

    @Override
    protected BillBaseInfo perpareBillInfo(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        SelectorItemCollection sic;
        if (pk == null) {
            throw new IllegalArgumentException();
        }
        IBillBase iBillBase = (IBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)new FaLeaseInBillNew().getType());
        BillBaseInfo billInfo = iBillBase.getBillBaseInfo(pk, sic = this.getStatusSelectors());
        if (billInfo == null) {
            throw new EASBizException(EASBizException.CHECKPARENTDELETED);
        }
        if (billInfo == null) {
            billInfo = iBillBase.getBillBaseInfo(pk, sic);
        }
        if (billInfo == null) {
            throw new EASBizException(EASBizException.CHECKPARENTDELETED);
        }
        return billInfo;
    }

    public static int getCurrencyScale(CompanyOrgUnitInfo company, Context ctx) throws EASBizException, BOSException {
        CurrencyInfo currency;
        if (company == null) {
            company = ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        if ((currency = company.getBaseCurrency()) != null && currency.get("precision") != null) {
            return currency.getPrecision();
        }
        if (currency == null || currency.getId() == null) {
            CompanyOrgUnitInfo _comp = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select baseCurrency.precision where id='" + company.getId() + "'");
            return _comp.getBaseCurrency().getPrecision();
        }
        return CurrencyFactory.getLocalInstance((Context)ctx).getValue("select precision where id='" + company.getBaseCurrency().getId() + "'").getInt("precision");
    }

    private boolean compareDateIfPreDay(java.util.Date date1, java.util.Date date2) {
        long DATE_TIME_MILLIS = 86400000L;
        Calendar cld1 = Calendar.getInstance();
        Calendar cld2 = Calendar.getInstance();
        cld1.setTime(date1);
        cld2.setTime(date2);
        cld1.set(cld1.get(1), cld1.get(2), cld1.get(5), 0, 0, 0);
        cld2.set(cld2.get(1), cld2.get(2), cld2.get(5), 0, 0, 0);
        int subDay = (int)((cld2.getTimeInMillis() - cld1.getTimeInMillis()) / 86400000L);
        return subDay == 1;
    }

    private boolean compareDateIfDay(java.util.Date date1, java.util.Date date2) {
        long DATE_TIME_MILLIS = 86400000L;
        Calendar cld1 = Calendar.getInstance();
        Calendar cld2 = Calendar.getInstance();
        cld1.setTime(date1);
        cld2.setTime(date2);
        cld1.set(cld1.get(1), cld1.get(2), cld1.get(5), 0, 0, 0);
        cld2.set(cld2.get(1), cld2.get(2), cld2.get(5), 0, 0, 0);
        int subDay = (int)((cld2.getTimeInMillis() - cld1.getTimeInMillis()) / 86400000L);
        return subDay == 0;
    }

    private boolean compareDateIfPreMonth(java.util.Date date1, java.util.Date date2) {
        Calendar cld1 = Calendar.getInstance();
        Calendar cld2 = Calendar.getInstance();
        cld1.setTime(date1);
        cld2.setTime(date2);
        int subMonth = (cld2.get(1) - cld1.get(1)) * 12 + cld2.get(2) - cld1.get(2);
        return subMonth == 1;
    }

    private boolean compareDateIfMonthPreDate(java.util.Date date1, java.util.Date date2) {
        Calendar cld1 = Calendar.getInstance();
        Calendar cld2 = Calendar.getInstance();
        cld1.setTime(date1);
        cld2.setTime(date2);
        int subMonth = (cld2.get(1) - cld1.get(1)) * 12 + cld2.get(2) - cld1.get(2);
        return subMonth >= 1;
    }

    private boolean compareDateIfBetweenTwoDate(java.util.Date date1, java.util.Date date2, java.util.Date date3) {
        long DATE_TIME_MILLIS = 86400000L;
        Calendar cld1 = Calendar.getInstance();
        Calendar cld2 = Calendar.getInstance();
        Calendar cld3 = Calendar.getInstance();
        cld1.setTime(date1);
        cld2.setTime(date2);
        cld3.setTime(date3);
        cld1.set(cld1.get(1), cld1.get(2), cld1.get(5), 0, 0, 0);
        cld2.set(cld2.get(1), cld2.get(2), cld2.get(5), 0, 0, 0);
        cld3.set(cld3.get(1), cld3.get(2), cld3.get(5), 0, 0, 0);
        int subDayOne = (int)((cld1.getTimeInMillis() - cld2.getTimeInMillis()) / 86400000L);
        int subDayTwo = (int)((cld3.getTimeInMillis() - cld1.getTimeInMillis()) / 86400000L);
        return subDayOne >= 0 && subDayTwo > 0;
    }

    private java.util.Date getMinMonthDate(java.util.Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMinimum(5));
        return calendar.getTime();
    }

    private java.util.Date perDate(java.util.Date curDate) {
        Calendar curCld = Calendar.getInstance();
        Calendar nxtCld = Calendar.getInstance();
        curCld.setTime(curDate);
        nxtCld.setTimeInMillis(curCld.getTimeInMillis() - 86400000L);
        return nxtCld.getTime();
    }

    private BigDecimal calcAdvPaymentNPV(FaLeaseInBillNewInfo billInfo, double dayRate) {
        if (billInfo.getCostDate1() == null || billInfo.getCostPmWithTaxOC1() == null) {
            return BigDecimal.ZERO;
        }
        if (billInfo.getCostDate1().compareTo(billInfo.getBeginDate()) <= 0) {
            return billInfo.isIsDeductible() ? billInfo.getCostPmWithoutTaxOC1() : billInfo.getCostPmWithTaxOC1();
        }
        int advDates = this.subDate(billInfo.getCostDate1(), billInfo.getBeginDate()) + 1;
        double advPaymentNPV = this.BD2db(billInfo.isIsDeductible() ? billInfo.getCostPmWithoutTaxOC1() : billInfo.getCostPmWithTaxOC1()) / Math.pow(new Double("1") + dayRate, advDates);
        return BigDecimal.valueOf(advPaymentNPV);
    }

    private double BD2db(BigDecimal bd) {
        return bd == null ? new Double("0").doubleValue() : bd.doubleValue();
    }

    private int subDate(java.util.Date date1, java.util.Date date2) {
        Calendar cld1 = Calendar.getInstance();
        Calendar cld2 = Calendar.getInstance();
        cld1.setTime(date1);
        cld2.setTime(date2);
        cld1.set(cld1.get(1), cld1.get(2), cld1.get(5), 0, 0, 0);
        cld2.set(cld2.get(1), cld2.get(2), cld2.get(5), 0, 0, 0);
        return (int)((cld1.getTimeInMillis() - cld2.getTimeInMillis()) / 24L * 60L * 60L * 1000L);
    }

    private double calcDiscountRate(Context ctx, FaLeaseInBillNewInfo billInfo) throws BOSException, EASBizException {
        double discountRate;
        FaNewLeasePolicyInfo newLeasePolicy = FaNewLeasePolicyFactory.getLocalInstance(ctx).getEnabledNewLeasePolicy(billInfo.getCompany().getId().toString());
        int interestCalcMethod = newLeasePolicy.getInterestCalculationMethod().getValue();
        if (newLeasePolicy.getTranslationMethod() == FaLiabilitiesCvMethodEnum.DAY) {
            discountRate = interestCalcMethod == 1 ? Math.pow(this.BD2db(billInfo.getDiscountRate()) / new Double("100") + new Double("1"), new Double("1") / new Double("365")) - new Double("1") : this.BD2db(billInfo.getDiscountRate()) / new Double("100") / new Double("365");
        } else {
            Double N;
            switch (billInfo.getPayFrequency().getValue()) {
                case 0: {
                    N = new Double("1");
                    break;
                }
                case 1: {
                    N = new Double("1") / new Double("2");
                    break;
                }
                case 2: {
                    N = new Double("1") / new Double("4");
                    break;
                }
                case 3: {
                    N = new Double("1") / new Double("12");
                    break;
                }
                case 5: {
                    N = new Double("1");
                    break;
                }
                default: {
                    N = new Double("1");
                }
            }
            discountRate = interestCalcMethod == 3 ? Math.pow(this.BD2db(billInfo.getDiscountRate()) / new Double("100") + new Double("1"), N) - new Double("1") : this.BD2db(billInfo.getDiscountRate()) / new Double("100") * N;
        }
        return discountRate;
    }

    private SelectorItemCollection getLeaseInBillSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("contractCat.id");
        sic.add("contractCat.name");
        sic.add("contractCat.depreciationPolicy");
        sic.add("contractCat.depreciationPolicy.*");
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("company.id");
        sic.add("company.name");
        sic.add("company.baseCurrency.precision");
        sic.add("company.accountPeriodType.*");
        sic.add("paymentEntry.*");
        sic.add("exchangeRate.*");
        sic.add("exchangeRate.exchangeAux.*");
        return sic;
    }
}

