/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.nlm.FaRentSettlementBillCollection;
import com.kingdee.eas.fi.nlm.FaRentSettlementBillFactory;
import com.kingdee.eas.fi.nlm.FaRentSettlementBillInfo;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;

public class FlLocalUtils {
    private static String RES_PATH_LEASENEW = "com.kingdee.eas.fi.nlm.FaLeaseNewResource";

    public static void checkRSDownBillGenInFuturePeriod(Context ctx, IObjectCollection entries, PeriodInfo curPeriod) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("fiVouchered");
        sic.add("entries.id");
        sic.add("entries.planDate");
        sic.add("entries.fiVouchered");
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        SelectorItemCollection botSic = new SelectorItemCollection();
        botSic.add("id");
        botSic.add("number");
        EntityViewInfo botView = new EntityViewInfo();
        botView.setSelector(botSic);
        for (int i = 0; i < entries.size(); ++i) {
            FaLeaseInBillNewInfo leaseInBillInfo = (FaLeaseInBillNewInfo)(entries.getObject(i) instanceof FaLeaseInBillNewInfo ? entries.getObject(i) : (FaLeaseInBillNewInfo)entries.getObject(i).get("leaseInBill"));
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("leaseInBill.id", (Object)leaseInBillInfo.getId().toString()));
            view.setFilter(filterInfo);
            FaRentSettlementBillCollection faRentSettlementBillCollection = FaRentSettlementBillFactory.getLocalInstance(ctx).getFaRentSettlementBillCollection(view);
            if (faRentSettlementBillCollection == null) {
                return;
            }
            for (int j = 0; j < faRentSettlementBillCollection.size(); ++j) {
                FaRentSettlementBillInfo faRentSettlementBillInfo = faRentSettlementBillCollection.get(j);
                Date planDate = faRentSettlementBillInfo.getEntries().get(0).getPlanDate();
                if (planDate.compareTo(curPeriod.getEndDate()) <= 0) continue;
                if (faRentSettlementBillInfo.getEntries().get(0).isFiVouchered()) {
                    throw new EASBizException(new NumericExceptionSubItem("001", ResourceBase.getString((String)RES_PATH_LEASENEW, (String)"Assosication_RentSettlementBill_Has_Gen_Voucher", (Locale)ctx.getOriginLocale(), (Object[])new String[]{leaseInBillInfo.getNumber()})));
                }
                FilterInfo botFilterInfo = new FilterInfo();
                botFilterInfo.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)faRentSettlementBillInfo.getId().toString()));
                botView.setFilter(botFilterInfo);
                BOTRelationCollection bOTRelationCollection = BOTRelationFactory.getLocalInstance((Context)ctx).getCollection(botView);
                if (bOTRelationCollection == null || bOTRelationCollection.size() <= 0) continue;
                throw new EASBizException(new NumericExceptionSubItem("001", ResourceBase.getString((String)RES_PATH_LEASENEW, (String)"Assosication_RentSettlementBill_Has_Gen_DownBill", (Locale)ctx.getOriginLocale(), (Object[])new String[]{leaseInBillInfo.getNumber()})));
            }
        }
    }

    public static PeriodInfo getFLCurrentPeriod(String companyPK, Context ctx) throws BOSException, EASBizException {
        PeriodInfo aPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FINANCE_LEASE, (IObjectPK)new ObjectUuidPK(companyPK));
        return aPeriodInfo;
    }

    public static boolean isCurrencyDisable(Context ctx, BillBaseInfo billInfo) throws EASBizException, BOSException {
        CurrencyInfo currencyInfo;
        boolean isDisable = false;
        if (billInfo.get("currency") != null && (currencyInfo = (CurrencyInfo)billInfo.get("currency")) != null && currencyInfo.getId() != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)currencyInfo.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)"2", CompareType.EQUALS));
            isDisable = CurrencyFactory.getLocalInstance((Context)ctx).exists(filter);
        }
        return isDisable;
    }

    public static void checkLeaseChangeGenInFuturePeriod(Context ctx, IObjectCollection entries, PeriodInfo curPeriod) throws BOSException, EASBizException {
        for (int i = 0; i < entries.size(); ++i) {
            FaLeaseInBillNewInfo leaseInBillInfo = (FaLeaseInBillNewInfo)(entries.getObject(i) instanceof FaLeaseInBillNewInfo ? entries.getObject(i) : (FaLeaseInBillNewInfo)entries.getObject(i).get("leaseInBill"));
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT period.FID, period.FNumber AS periodNum FROM T_Fa_FaLeaseChangebill AS bill \n");
            sql.append("LEFT JOIN T_Fa_FaLeaseChangebillEntry AS entry ON bill.FID = entry.FBillId \n");
            sql.append("LEFT JOIN T_BD_Period AS period ON period.FID = bill.FPeriodID \n");
            sql.append("WHERE entry.FLeaseInBillId = ?");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{leaseInBillInfo.getId().toString()});
            try {
                while (rs != null && rs.next()) {
                    int periodNum = rs.getInt("periodNum");
                    if (periodNum <= curPeriod.getNumber()) continue;
                    throw new EASBizException(new NumericExceptionSubItem("001", ResourceBase.getString((String)RES_PATH_LEASENEW, (String)"Has_Gen_ChangeBill", (Locale)ctx.getOriginLocale(), (Object[])new String[]{leaseInBillInfo.getNumber()})));
                }
                continue;
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    public static void checkDeprAndAmortGenInFuturePeriod(Context ctx, IObjectCollection entries, PeriodInfo curPeriod) throws BOSException, EASBizException {
        StringBuilder ckSQL = new StringBuilder();
        ckSQL.append(" SELECT t1.Fid, t1.FPeriodID, t2.FNumber periodNumber");
        ckSQL.append(" FROM T_FA_FaDepreAndAmort t1 ");
        ckSQL.append(" INNER JOIN T_BD_Period t2 ON t1.FPeriodID = t2.FID ");
        ckSQL.append(" WHERE FLeaseInBillID = ? and t2.FNUMBER > ? ");
        for (int i = 0; i < entries.size(); ++i) {
            FaLeaseInBillNewInfo leaseInBillInfo = (FaLeaseInBillNewInfo)(entries.getObject(i) instanceof FaLeaseInBillNewInfo ? entries.getObject(i) : (FaLeaseInBillNewInfo)entries.getObject(i).get("leaseInBill"));
            IRowSet ckRs = DbUtil.executeQuery((Context)ctx, (String)ckSQL.toString(), (Object[])new Object[]{leaseInBillInfo.getId().toString(), curPeriod.getNumber()});
            try {
                if (!ckRs.next() || ckRs.getInt("periodNumber") <= curPeriod.getNumber()) continue;
                throw new EASBizException(new NumericExceptionSubItem("001", ResourceBase.getString((String)RES_PATH_LEASENEW, (String)"Has_Gen_DepreAndAmort", (Locale)ctx.getOriginLocale(), (Object[])new String[]{leaseInBillInfo.getNumber()})));
            }
            catch (SQLException throwables) {
                throw new BOSException((Throwable)throwables);
            }
        }
    }

    public static boolean isRunningWorkflow(Context ctx, String objId) throws BOSException {
        boolean hasWorkflow = false;
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
        String procDefID = service.findSubmitProcDef(new VoucherInfo().getBOSType(), ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        if (procDefID != null) {
            IEnactmentService service2 = EnactmentServiceProxy.getEnacementService((Context)ctx);
            ProcessInstInfo[] procInsts = service2.getProcessInstanceByHoldedObjectId(objId);
            int n = procInsts.length;
            for (int i = 0; i < n; ++i) {
                if (!"open.running".equals(procInsts[i].getState())) continue;
                hasWorkflow = true;
                break;
            }
        }
        return hasWorkflow;
    }

    public static VoucherInfo LookVoucherInfo(Context ctx, IObjectValue bOTRelationInfo) throws BOSException {
        Iterator iter;
        EntityViewInfo entityView = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("voucherAbstract"));
        entityView.getSelector().addObjectCollection((IObjectCollection)sic);
        FilterInfo filter = new FilterInfo();
        if (((BOTRelationInfo)bOTRelationInfo).getDestObjectID() == null) {
            return null;
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)((BOTRelationInfo)bOTRelationInfo).getDestObjectID()));
        entityView.setFilter(filter);
        IVoucher voucher = VoucherFactory.getLocalInstance((Context)ctx);
        VoucherCollection voucherCollection = voucher.getVoucherCollection(entityView);
        if (voucherCollection.size() > 0 && (iter = voucherCollection.iterator()).hasNext()) {
            VoucherInfo voucherInfo = (VoucherInfo)iter.next();
            return voucherInfo;
        }
        return null;
    }

    public static Date getBizDate4Fl(Context ctx, String companyId) throws EASBizException, BOSException {
        PeriodInfo periodInfo = FlLocalUtils.getFLCurrentPeriod(companyId, ctx);
        Date today = DateTimeUtils.truncateDate((Date)new Date());
        if (today.before(periodInfo.getBeginDate())) {
            today = DateTimeUtils.truncateDate((Date)periodInfo.getBeginDate());
        } else if (today.after(periodInfo.getEndDate())) {
            today = DateTimeUtils.truncateDate((Date)periodInfo.getEndDate());
        }
        return today;
    }

    public static String getCurrentCompanyId(Context ctx) {
        if (ctx.get((Object)"depCompanyID") != null) {
            return ctx.get((Object)"depCompanyID").toString();
        }
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = null;
        aCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        String strCompanyOrgUnitInfoID = aCompanyOrgUnitInfo.getId().toString();
        return strCompanyOrgUnitInfoID;
    }

    public static int getCurrencyScale(BOSUuid currencyID, Context ctx) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("precision"));
        ObjectUuidPK pk = new ObjectUuidPK(currencyID);
        CurrencyInfo currencyInfo = ctx == null ? CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)pk, sic) : CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)pk, sic);
        return currencyInfo == null ? 2 : currencyInfo.getPrecision();
    }
}

