/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.calctree.calculation;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewFactory;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.nlm.FaLeaseSourceTypeEnum;
import com.kingdee.eas.fi.nlm.FaLeaseTypeEnum;
import com.kingdee.eas.fi.nlm.FaNLMChangeAssetItemFactory;
import com.kingdee.eas.fi.nlm.FaTerminateBillEntryCollection;
import com.kingdee.eas.fi.nlm.FaTerminateBillEntryFactory;
import com.kingdee.eas.fi.nlm.FaTerminateBillFactory;
import com.kingdee.eas.fi.nlm.FaTerminateBillInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TerminateBillCalc {
    public static void getPaidRentAmtForOne(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date initCfmDate = (Date)params.get("initCfmDate");
        Date terminateDate = (Date)params.get("terminateDate");
        boolean isDeductible = (Boolean)params.get("isDeductible");
        StringBuilder sql = new StringBuilder();
        sql.append(" select FHeadID billId, sum(" + (isDeductible ? "FPaymentWithoutTax" : "FPaymentWithTax") + ") resultNumber FROM T_FA_FaPaymentPlanNew");
        sql.append(" where FHeadID = ?");
        sql.append(" and FPayDate >= ? and FPayDate <= ?");
        sql.append(" group by FHeadID");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(initCfmDate.getTime()), new Timestamp(terminateDate.getTime())});
        try {
            while (rs.next()) {
                String id = rs.getString("billId");
                BigDecimal paidRentAmt = rs.getBigDecimal("resultNumber") == null ? BigDecimal.ZERO : rs.getBigDecimal("resultNumber");
                result.put(id, paidRentAmt);
                result.put("queryPathList:" + id, params.get("queryPathList"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getPaidRentAmtForTwo(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date initCfmDate = (Date)params.get("initCfmDate");
        Date terminateDate = (Date)params.get("terminateDate");
        Date adjustDate = (Date)params.get("adjustDate");
        Date billBeginDate = (Date)params.get("billBeginDate");
        boolean isDeductible = (Boolean)params.get("isDeductible");
        StringBuilder sql = new StringBuilder();
        sql.append(" select FHeadID billId, sum(" + (isDeductible ? "FPaymentWithoutTax" : "FPaymentWithTax") + ") resultNumber FROM T_FA_FaPaymentPlanNew");
        sql.append(" where FHeadID = ?");
        sql.append(" and FPayDate >= ? and FPayDate <= ?");
        sql.append(" group by FHeadID");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(initCfmDate.getTime()), new Timestamp(adjustDate.getTime())});
        try {
            while (rs.next()) {
                String id = rs.getString("billId");
                BigDecimal paidRentAmt = rs.getBigDecimal("resultNumber") == null ? BigDecimal.ZERO : rs.getBigDecimal("resultNumber");
                result.put(id, paidRentAmt);
                result.put("queryPathList:" + id, params.get("queryPathList"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getPaidRentAmtForThree(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date initCfmDate = (Date)params.get("initCfmDate");
        Date terminateDate = (Date)params.get("terminateDate");
        Date adjustDate = (Date)params.get("adjustDate");
        Date billBeginDate = (Date)params.get("billBeginDate");
        boolean isDeductible = (Boolean)params.get("isDeductible");
        StringBuilder sql = new StringBuilder();
        sql.append(" select FHeadID billId, sum(" + (isDeductible ? "FPaymentWithoutTax" : "FPaymentWithTax") + ") resultNumber FROM T_FA_FaPaymentPlanNew");
        sql.append(" where FHeadID = ?");
        sql.append(" and FPayDate >= ? and FPayDate <= ?");
        sql.append(" group by FHeadID");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(billBeginDate.getTime()), new Timestamp(terminateDate.getTime())});
        try {
            while (rs.next()) {
                String id = rs.getString("billId");
                BigDecimal paidRentAmt = rs.getBigDecimal("resultNumber") == null ? BigDecimal.ZERO : rs.getBigDecimal("resultNumber");
                result.put(id, paidRentAmt);
                result.put("queryPathList:" + id, params.get("queryPathList"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getPaidRentAmtForFour(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date initCfmDate = (Date)params.get("initCfmDate");
        Date terminateDate = (Date)params.get("terminateDate");
        Date adjustDate = (Date)params.get("adjustDate");
        Date billBeginDate = (Date)params.get("billBeginDate");
        boolean isDeductible = (Boolean)params.get("isDeductible");
        StringBuilder sql = new StringBuilder();
        sql.append(" select FHeadID billId, sum(" + (isDeductible ? "FPaymentWithoutTax" : "FPaymentWithTax") + ") resultNumber FROM T_FA_FaPaymentPlanNew");
        sql.append(" where FHeadID = ?");
        sql.append(" and FPayDate >= ? and FPayDate <= ?");
        sql.append(" group by FHeadID");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(billBeginDate.getTime()), new Timestamp(adjustDate.getTime())});
        try {
            while (rs.next()) {
                String id = rs.getString("billId");
                BigDecimal paidRentAmt = rs.getBigDecimal("resultNumber") == null ? BigDecimal.ZERO : rs.getBigDecimal("resultNumber");
                result.put(id, paidRentAmt);
                result.put("queryPathList:" + id, params.get("queryPathList"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getPaidRentAmtForFive(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date initCfmDate = (Date)params.get("initCfmDate");
        Date terminateDate = (Date)params.get("terminateDate");
        Date adjustDate = (Date)params.get("adjustDate");
        Date billBeginDate = (Date)params.get("billBeginDate");
        boolean isDeductible = (Boolean)params.get("isDeductible");
        StringBuilder sql = new StringBuilder();
        sql.append(" select FHeadID billId, sum(" + (isDeductible ? "FPaymentWithoutTax" : "FPaymentWithTax") + ") resultNumber FROM T_FA_FaPaymentPlanNew");
        sql.append(" where FHeadID = ?");
        sql.append(" and FPayDate <= ?");
        sql.append(" group by FHeadID");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(terminateDate.getTime())});
        try {
            while (rs.next()) {
                String id = rs.getString("billId");
                BigDecimal paidRentAmt = rs.getBigDecimal("resultNumber") == null ? BigDecimal.ZERO : rs.getBigDecimal("resultNumber");
                result.put(id, paidRentAmt);
                result.put("queryPathList:" + id, params.get("queryPathList"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getPaidRentAmtForSix(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date initCfmDate = (Date)params.get("initCfmDate");
        Date terminateDate = (Date)params.get("terminateDate");
        Date adjustDate = (Date)params.get("adjustDate");
        Date billBeginDate = (Date)params.get("billBeginDate");
        boolean isDeductible = (Boolean)params.get("isDeductible");
        StringBuilder sql = new StringBuilder();
        sql.append(" select FHeadID billId, sum(" + (isDeductible ? "FPaymentWithoutTax" : "FPaymentWithTax") + ") resultNumber FROM T_FA_FaPaymentPlanNew");
        sql.append(" where FHeadID = ?");
        sql.append(" and FPayDate <= ?");
        sql.append(" group by FHeadID");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(adjustDate.getTime())});
        try {
            while (rs.next()) {
                String id = rs.getString("billId");
                BigDecimal paidRentAmt = rs.getBigDecimal("resultNumber") == null ? BigDecimal.ZERO : rs.getBigDecimal("resultNumber");
                result.put(id, paidRentAmt);
                result.put("queryPathList:" + id, params.get("queryPathList"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getPaidRentAmtForSeven(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException, EASBizException {
        ArrayList<String> idList = new ArrayList<String>();
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        FaLeaseSourceTypeEnum sourceType = leaseInBill.getSourceType();
        Date terminateDate = (Date)params.get("terminateDate");
        boolean isDeductible = (Boolean)params.get("isDeductible");
        TerminateBillCalc.buildIdList(ctx, idList, leaseInBillId);
        StringBuilder sql = new StringBuilder();
        sql.append(" select sum(" + (isDeductible ? "entry.FPlanWithoutTaxAmt" : "entry.FPlanWithTaxAmt") + ") number FROM T_FA_FARENTSETTLEMENTBILL bill");
        sql.append(" left join T_FA_FARENTSETTLEMENTBILLentry entry ON BILL.FID = ENTRY.FBILLID");
        sql.append(" where bill.FLEASEINBILLID = '" + leaseInBillId + "'");
        sql.append(" and entry.fplanDate <= {d '" + sdf.format(terminateDate) + "'}");
        IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        BigDecimal ss = BigDecimal.ZERO;
        BigDecimal allPlanTaxAmt = BigDecimal.ZERO;
        String id = leaseInBill.getId().toString();
        ArrayList<BigDecimal> taxAmtList = new ArrayList<BigDecimal>(1);
        TerminateBillCalc.getCalcAllPlanTaxAmt(ctx, id, leaseInBill, sdf, isDeductible, allPlanTaxAmt, taxAmtList);
        allPlanTaxAmt = (BigDecimal)taxAmtList.get(0);
        StringBuilder allSql = new StringBuilder();
        allSql.append(" SELECT SUM(entry.FTerPaidRent) allFTerPaidRent");
        allSql.append(" FROM T_FA_FaLeaseInBillNew bill");
        allSql.append(" LEFT JOIN T_FA_FaTerminateBillentry entry ON bill.FId = entry.FLEASEINBILLID");
        allSql.append(" where bill.fid in (");
        for (int i = 0; i < idList.size(); ++i) {
            if (i > 0) {
                allSql.append(",");
            }
            allSql.append("'").append((String)idList.get(i)).append("'");
        }
        allSql.append(")");
        IRowSet allRs = DbUtil.executeQuery((Context)ctx, (String)allSql.toString());
        try {
            BigDecimal planTaxAmt = BigDecimal.ZERO;
            BigDecimal allFTerPaidRent = BigDecimal.ZERO;
            BigDecimal resultNumber = BigDecimal.ZERO;
            while (rs1.next()) {
                planTaxAmt = rs1.getBigDecimal("number") == null ? BigDecimal.ZERO : rs1.getBigDecimal("number");
            }
            while (allRs.next()) {
                allFTerPaidRent = allRs.getBigDecimal("allFTerPaidRent") == null ? BigDecimal.ZERO : allRs.getBigDecimal("allFTerPaidRent");
            }
            resultNumber = planTaxAmt.add(allPlanTaxAmt).subtract(allFTerPaidRent);
            result.put(leaseInBillId, resultNumber);
            result.put("queryPathList:" + leaseInBillId, params.get("queryPathList"));
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getPaidRentAmtForEight(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException, EASBizException {
        ArrayList<String> idList = new ArrayList<String>();
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        FaLeaseSourceTypeEnum sourceType = leaseInBill.getSourceType();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date terminateDate = (Date)params.get("terminateDate");
        Date billBeginDate = (Date)params.get("billBeginDate");
        Date initCfmDate = (Date)params.get("initCfmDate");
        boolean isDeductible = (Boolean)params.get("isDeductible");
        TerminateBillCalc.buildIdList(ctx, idList, leaseInBillId);
        StringBuilder sql = new StringBuilder();
        sql.append(" select sum(" + (isDeductible ? "entry.FPlanWithoutTaxAmt" : "entry.FPlanWithTaxAmt") + ") number FROM T_FA_FARENTSETTLEMENTBILL bill");
        sql.append(" left join T_FA_FARENTSETTLEMENTBILLentry entry ON BILL.FID = ENTRY.FBILLID");
        sql.append(" where bill.FLEASEINBILLID = '" + leaseInBillId + "'");
        sql.append(" and entry.fplanDate <= {d '" + sdf.format(terminateDate) + "'}");
        IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        BigDecimal allPlanTaxAmt = BigDecimal.ZERO;
        String id = leaseInBill.getId().toString();
        ArrayList<BigDecimal> taxAmtList = new ArrayList<BigDecimal>(1);
        TerminateBillCalc.getCalcAllPlanTaxAmt(ctx, id, leaseInBill, sdf, isDeductible, allPlanTaxAmt, taxAmtList);
        allPlanTaxAmt = (BigDecimal)taxAmtList.get(0);
        FaLeaseInBillNewInfo oldLeaseBillInfo = FaLeaseInBillNewFactory.getLocalInstance(ctx).getFaLeaseInBillNewInfo((IObjectPK)new ObjectUuidPK((String)idList.get(idList.size() - 1)));
        StringBuilder sql3 = new StringBuilder();
        sql3.append(" select sum(" + (isDeductible ? "entry.FPlanWithoutTaxAmt" : "entry.FPlanWithTaxAmt") + ") number FROM T_FA_FARENTSETTLEMENTBILL bill");
        sql3.append(" left join T_FA_FARENTSETTLEMENTBILLentry entry ON BILL.FID = ENTRY.FBILLID");
        sql3.append(" where bill.FLEASEINBILLID in (");
        for (int i = 0; i < idList.size(); ++i) {
            if (i > 0) {
                sql3.append(",");
            }
            sql3.append("'").append((String)idList.get(i)).append("'");
        }
        sql3.append(")");
        sql3.append(" and entry.fplanDate >= {d '" + sdf.format(oldLeaseBillInfo.getBeginDate()) + "'}");
        sql3.append(" and entry.fplanDate < {d '" + sdf.format(initCfmDate) + "'}");
        IRowSet rs3 = DbUtil.executeQuery((Context)ctx, (String)sql3.toString());
        StringBuilder allSql = new StringBuilder();
        allSql.append(" SELECT SUM(entry.FTerPaidRent) allFTerPaidRent");
        allSql.append(" FROM T_FA_FaLeaseInBillNew bill");
        allSql.append(" LEFT JOIN T_FA_FaTerminateBillentry entry ON bill.FId = entry.FLEASEINBILLID");
        allSql.append(" where bill.fid in (");
        for (int i = 0; i < idList.size(); ++i) {
            if (i > 0) {
                allSql.append(",");
            }
            allSql.append("'").append((String)idList.get(i)).append("'");
        }
        allSql.append(")");
        IRowSet allRs = DbUtil.executeQuery((Context)ctx, (String)allSql.toString());
        try {
            BigDecimal planTaxAmt = BigDecimal.ZERO;
            BigDecimal planTaxAmtFromBegin = BigDecimal.ZERO;
            BigDecimal allFTerPaidRent = BigDecimal.ZERO;
            BigDecimal resultNumber = BigDecimal.ZERO;
            while (rs1.next()) {
                planTaxAmt = rs1.getBigDecimal("number") == null ? BigDecimal.ZERO : rs1.getBigDecimal("number");
            }
            while (rs3.next()) {
                planTaxAmtFromBegin = rs3.getBigDecimal("number") == null ? BigDecimal.ZERO : rs3.getBigDecimal("number");
            }
            while (allRs.next()) {
                allFTerPaidRent = allRs.getBigDecimal("allFTerPaidRent") == null ? BigDecimal.ZERO : allRs.getBigDecimal("allFTerPaidRent");
            }
            resultNumber = planTaxAmt.add(allPlanTaxAmt).subtract(planTaxAmtFromBegin).subtract(allFTerPaidRent);
            result.put(leaseInBillId, resultNumber);
            result.put("queryPathList:" + leaseInBillId, params.get("queryPathList"));
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getPaidRentAmtForNine(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException, EASBizException {
        ArrayList<String> idList = new ArrayList<String>();
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        FaLeaseSourceTypeEnum sourceType = leaseInBill.getSourceType();
        Date adjustDate = (Date)params.get("adjustDate");
        boolean isDeductible = (Boolean)params.get("isDeductible");
        TerminateBillCalc.buildIdList(ctx, idList, leaseInBillId);
        StringBuilder sql = new StringBuilder();
        sql.append(" select sum(" + (isDeductible ? "entry.FPlanWithoutTaxAmt" : "entry.FPlanWithTaxAmt") + ") number FROM T_FA_FARENTSETTLEMENTBILL bill");
        sql.append(" left join T_FA_FARENTSETTLEMENTBILLentry entry ON BILL.FID = ENTRY.FBILLID");
        sql.append(" where bill.FLEASEINBILLID = '" + leaseInBillId + "'");
        sql.append(" and entry.fplanDate <= {d '" + sdf.format(adjustDate) + "'}");
        IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        BigDecimal allPlanTaxAmt = BigDecimal.ZERO;
        ArrayList<BigDecimal> taxAmtList = new ArrayList<BigDecimal>(1);
        String id = leaseInBill.getId().toString();
        TerminateBillCalc.getCalcAllPlanTaxAmt(ctx, id, leaseInBill, sdf, isDeductible, allPlanTaxAmt, taxAmtList);
        allPlanTaxAmt = (BigDecimal)taxAmtList.get(0);
        StringBuilder allSql = new StringBuilder();
        allSql.append(" SELECT SUM(entry.FTerPaidRent) allFTerPaidRent");
        allSql.append(" FROM T_FA_FaLeaseInBillNew bill");
        allSql.append(" LEFT JOIN T_FA_FaTerminateBillentry entry ON bill.FId = entry.FLEASEINBILLID");
        allSql.append(" where bill.fid in (");
        for (int i = 0; i < idList.size(); ++i) {
            if (i > 0) {
                allSql.append(",");
            }
            allSql.append("'").append((String)idList.get(i)).append("'");
        }
        allSql.append(")");
        IRowSet allRs = DbUtil.executeQuery((Context)ctx, (String)allSql.toString());
        try {
            BigDecimal planTaxAmt = BigDecimal.ZERO;
            BigDecimal allFTerPaidRent = BigDecimal.ZERO;
            BigDecimal resultNumber = BigDecimal.ZERO;
            while (rs1.next()) {
                planTaxAmt = rs1.getBigDecimal("number") == null ? BigDecimal.ZERO : rs1.getBigDecimal("number");
            }
            while (allRs.next()) {
                allFTerPaidRent = allRs.getBigDecimal("allFTerPaidRent") == null ? BigDecimal.ZERO : allRs.getBigDecimal("allFTerPaidRent");
            }
            resultNumber = planTaxAmt.add(allPlanTaxAmt).subtract(allFTerPaidRent);
            result.put(leaseInBillId, resultNumber);
            result.put("queryPathList:" + leaseInBillId, params.get("queryPathList"));
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getPaidRentAmtForTen(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException, EASBizException {
        ArrayList<String> idList = new ArrayList<String>();
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        FaLeaseSourceTypeEnum sourceType = leaseInBill.getSourceType();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date adjustDate = (Date)params.get("adjustDate");
        Date billBeginDate = (Date)params.get("billBeginDate");
        Date initCfmDate = (Date)params.get("initCfmDate");
        boolean isDeductible = (Boolean)params.get("isDeductible");
        TerminateBillCalc.buildIdList(ctx, idList, leaseInBillId);
        StringBuilder sql = new StringBuilder();
        sql.append(" select sum(" + (isDeductible ? "entry.FPlanWithoutTaxAmt" : "entry.FPlanWithTaxAmt") + ") number FROM T_FA_FARENTSETTLEMENTBILL bill");
        sql.append(" left join T_FA_FARENTSETTLEMENTBILLentry entry ON BILL.FID = ENTRY.FBILLID");
        sql.append(" where bill.FLEASEINBILLID = '" + leaseInBillId + "'");
        sql.append(" and entry.fplanDate <= {d '" + sdf.format(adjustDate) + "'}");
        IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        BigDecimal allPlanTaxAmt = BigDecimal.ZERO;
        String id = leaseInBill.getId().toString();
        ArrayList<BigDecimal> taxAmtList = new ArrayList<BigDecimal>(1);
        TerminateBillCalc.getCalcAllPlanTaxAmt(ctx, id, leaseInBill, sdf, isDeductible, allPlanTaxAmt, taxAmtList);
        allPlanTaxAmt = (BigDecimal)taxAmtList.get(0);
        FaLeaseInBillNewInfo oldLeaseBillInfo = FaLeaseInBillNewFactory.getLocalInstance(ctx).getFaLeaseInBillNewInfo((IObjectPK)new ObjectUuidPK((String)idList.get(idList.size() - 1)));
        StringBuilder sql3 = new StringBuilder();
        sql3.append(" select sum(" + (isDeductible ? "entry.FPlanWithoutTaxAmt" : "entry.FPlanWithTaxAmt") + ") number FROM T_FA_FARENTSETTLEMENTBILL bill");
        sql3.append(" left join T_FA_FARENTSETTLEMENTBILLentry entry ON BILL.FID = ENTRY.FBILLID");
        sql3.append(" where bill.FLEASEINBILLID in (");
        for (int i = 0; i < idList.size(); ++i) {
            if (i > 0) {
                sql3.append(",");
            }
            sql3.append("'").append((String)idList.get(i)).append("'");
        }
        sql3.append(")");
        sql3.append(" and entry.fplanDate >= {d '" + sdf.format(oldLeaseBillInfo.getBeginDate()) + "'}");
        sql3.append(" and entry.fplanDate < {d '" + sdf.format(initCfmDate) + "'}");
        IRowSet rs3 = DbUtil.executeQuery((Context)ctx, (String)sql3.toString());
        StringBuilder allSql = new StringBuilder();
        allSql.append(" SELECT SUM(entry.FTerPaidRent) allFTerPaidRent");
        allSql.append(" FROM T_FA_FaLeaseInBillNew bill");
        allSql.append(" LEFT JOIN T_FA_FaTerminateBillentry entry ON bill.FId = entry.FLEASEINBILLID");
        allSql.append(" where bill.fid in (");
        for (int i = 0; i < idList.size(); ++i) {
            if (i > 0) {
                allSql.append(",");
            }
            allSql.append("'").append((String)idList.get(i)).append("'");
        }
        allSql.append(")");
        IRowSet allRs = DbUtil.executeQuery((Context)ctx, (String)allSql.toString());
        try {
            BigDecimal planTaxAmt = BigDecimal.ZERO;
            BigDecimal planTaxAmtFromBegin = BigDecimal.ZERO;
            BigDecimal allFTerPaidRent = BigDecimal.ZERO;
            BigDecimal resultNumber = BigDecimal.ZERO;
            while (rs1.next()) {
                planTaxAmt = rs1.getBigDecimal("number") == null ? BigDecimal.ZERO : rs1.getBigDecimal("number");
            }
            while (rs3.next()) {
                planTaxAmtFromBegin = rs3.getBigDecimal("number") == null ? BigDecimal.ZERO : rs3.getBigDecimal("number");
            }
            while (allRs.next()) {
                allFTerPaidRent = allRs.getBigDecimal("allFTerPaidRent") == null ? BigDecimal.ZERO : allRs.getBigDecimal("allFTerPaidRent");
            }
            resultNumber = planTaxAmt.add(allPlanTaxAmt).subtract(planTaxAmtFromBegin).subtract(allFTerPaidRent);
            result.put(leaseInBillId, resultNumber);
            result.put("queryPathList:" + leaseInBillId, params.get("queryPathList"));
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForOne(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date billEndDate = (Date)params.get("billEndDate");
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate <= ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(billEndDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep.add(leaseInBill.getInitAccDepreciation());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForTwo(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date billEndDate = TerminateBillCalc.getMaxMonthDate((Date)params.get("billEndDate"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate <= ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(billEndDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep.add(leaseInBill.getFinanceInitAccDepreciation());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForThree(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date billEndDate = TerminateBillCalc.getMaxMonthDate((Date)params.get("billEndDate"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate <= ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(billEndDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep.add(leaseInBill.getInitAccDepreciation());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForFour(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date terminateDate = (Date)params.get("terminateDate");
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate < ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(terminateDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep.add(leaseInBill.getInitAccDepreciation());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForFive(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date terminateDate = TerminateBillCalc.getMinMonthDate((Date)params.get("terminateDate"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate < ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(terminateDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep.add(leaseInBill.getFinanceInitAccDepreciation());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForSix(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date terminateDate = TerminateBillCalc.getMinMonthDate((Date)params.get("terminateDate"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate < ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(terminateDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep.add(leaseInBill.getInitAccDepreciation());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForSeven(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date terminateDate = TerminateBillCalc.getMaxMonthDate((Date)params.get("terminateDate"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate <= ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(terminateDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep.add(leaseInBill.getInitAccDepreciation());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForEight(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date adjustDate = TerminateBillCalc.getMinMonthDate((Date)params.get("adjustDate"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate < ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(adjustDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep.add(leaseInBill.getFinanceInitAccDepreciation());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForNine(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date adjustDate = TerminateBillCalc.getMinMonthDate((Date)params.get("adjustDate"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate < ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(adjustDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep.add(leaseInBill.getInitAccDepreciation());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForTen(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date adjustDate = TerminateBillCalc.getMaxMonthDate((Date)params.get("adjustDate"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate <= ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(adjustDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep.add(leaseInBill.getInitAccDepreciation());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForEleven(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date adjustDate = (Date)params.get("adjustDate");
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate < ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(adjustDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep.add(leaseInBill.getInitAccDepreciation());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForTwelve(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date billEndDate = TerminateBillCalc.getMaxMonthDate((Date)params.get("billEndDate"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate <= ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(billEndDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep;
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForThirteen(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        ArrayList<String> idList = new ArrayList<String>();
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date billEndDate = TerminateBillCalc.getMaxMonthDate((Date)params.get("billEndDate"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate <= ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(billEndDate.getTime())});
        TerminateBillCalc.buildIdList(ctx, idList, leaseInBillId);
        StringBuilder allSql = new StringBuilder();
        allSql.append(" SELECT SUM(dep.FMONTHLYDEPREAMT) monthDep, SUM(dep.FMONTHLYINTERESTEXPE) monthIP");
        allSql.append(" FROM T_FA_FaDepreAndAmort dep");
        allSql.append(" where dep.FLEASEINBILLID in (");
        for (int i = 0; i < idList.size(); ++i) {
            if (i > 0) {
                allSql.append(",");
            }
            allSql.append("'").append((String)idList.get(i)).append("'");
        }
        allSql.append(")");
        IRowSet allRs = DbUtil.executeQuery((Context)ctx, (String)allSql.toString());
        StringBuilder allSql1 = new StringBuilder();
        allSql1.append(" SELECT SUM(faccDepOfAsset) allFaccDepOfAsset,SUM(FInitAccDepreciation) allFInitAccDepreciation, SUM(fadjustAccDepAsset) allFadjustAccDepAsset, SUM(faccDeprAdjustment) allFaccDeprAdjustment,SUM(FinanceInitAccDepreciation) allFinanceInitAccDepreciation");
        allSql1.append(" FROM T_FA_FaLeaseInBillNew");
        allSql1.append(" where fid in (");
        for (int i = 0; i < idList.size(); ++i) {
            if (i > 0) {
                allSql1.append(",");
            }
            allSql1.append("'").append((String)idList.get(i)).append("'");
        }
        allSql1.append(")");
        IRowSet allRs1 = DbUtil.executeQuery((Context)ctx, (String)allSql1.toString());
        StringBuilder allSql2 = new StringBuilder();
        allSql2.append(" SELECT SUM(entry.FTerAcumDepreamt) allFTerAcumDepreamt");
        allSql2.append(" FROM T_FA_FaLeaseInBillNew bill");
        allSql2.append(" LEFT JOIN T_FA_FaTerminateBillentry entry ON bill.FId = entry.FLEASEINBILLID");
        allSql2.append(" where bill.fid in (");
        for (int i = 0; i < idList.size(); ++i) {
            if (i > 0) {
                allSql2.append(",");
            }
            allSql2.append("'").append((String)idList.get(i)).append("'");
        }
        allSql2.append(")");
        IRowSet allRs2 = DbUtil.executeQuery((Context)ctx, (String)allSql2.toString());
        try {
            BigDecimal accDepOfAsset = leaseInBill.getAccDepOfAsset() == null ? BigDecimal.ZERO : leaseInBill.getAccDepOfAsset();
            BigDecimal adjustAccDepAsset = leaseInBill.getAdjustAccDepAsset() == null ? BigDecimal.ZERO : leaseInBill.getAdjustAccDepAsset();
            BigDecimal accDeprAdjustment = leaseInBill.getAccDeprAdjustment() == null ? BigDecimal.ZERO : leaseInBill.getAccDeprAdjustment();
            BigDecimal allRsMonthDep = BigDecimal.ZERO;
            BigDecimal allFaccDepOfAsset = BigDecimal.ZERO;
            BigDecimal allFInitAccDepreciation = BigDecimal.ZERO;
            BigDecimal allFadjustAccDepAsset = BigDecimal.ZERO;
            BigDecimal allFaccDeprAdjustment = BigDecimal.ZERO;
            BigDecimal allFinanceInitAccDepreciation = BigDecimal.ZERO;
            BigDecimal allFTerAcumDepreamt = BigDecimal.ZERO;
            BigDecimal allFTerAcumDepreamtTerminate = BigDecimal.ZERO;
            while (allRs.next()) {
                allRsMonthDep = allRs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : allRs.getBigDecimal("monthDep");
            }
            while (allRs1.next()) {
                allFaccDepOfAsset = allRs1.getBigDecimal("allFaccDepOfAsset") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFaccDepOfAsset");
                allFInitAccDepreciation = allRs1.getBigDecimal("allFInitAccDepreciation") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFInitAccDepreciation");
                allFadjustAccDepAsset = allRs1.getBigDecimal("allFadjustAccDepAsset") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFadjustAccDepAsset");
                allFaccDeprAdjustment = allRs1.getBigDecimal("allFaccDeprAdjustment") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFaccDeprAdjustment");
                allFinanceInitAccDepreciation = allRs1.getBigDecimal("allFinanceInitAccDepreciation") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFinanceInitAccDepreciation");
            }
            while (allRs2.next()) {
                allFTerAcumDepreamtTerminate = allRs2.getBigDecimal("allFTerAcumDepreamt") == null ? BigDecimal.ZERO : allRs2.getBigDecimal("allFTerAcumDepreamt");
            }
            while (rs.next()) {
                BigDecimal monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep.subtract(accDepOfAsset).add(adjustAccDepAsset).add(accDeprAdjustment).add(allRsMonthDep).add(allFaccDepOfAsset).add(allFInitAccDepreciation).add(allFadjustAccDepAsset).add(allFaccDeprAdjustment).add(allFinanceInitAccDepreciation).subtract(allFTerAcumDepreamtTerminate);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForFourteen(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        ArrayList<String> idList = new ArrayList<String>();
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date billEndDate = (Date)params.get("billEndDate");
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate <= ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(billEndDate.getTime())});
        TerminateBillCalc.buildIdList(ctx, idList, leaseInBillId);
        StringBuilder allSql = new StringBuilder();
        allSql.append(" SELECT SUM(dep.FMONTHLYDEPREAMT) monthDep, SUM(dep.FMONTHLYINTERESTEXPE) monthIP");
        allSql.append(" FROM T_FA_FaDepreAndAmort dep");
        allSql.append(" where dep.FLEASEINBILLID in (");
        for (int i = 0; i < idList.size(); ++i) {
            if (i > 0) {
                allSql.append(",");
            }
            allSql.append("'").append((String)idList.get(i)).append("'");
        }
        allSql.append(")");
        IRowSet allRs = DbUtil.executeQuery((Context)ctx, (String)allSql.toString());
        StringBuilder allSql1 = new StringBuilder();
        allSql1.append(" SELECT SUM(faccDepOfAsset) allFaccDepOfAsset, SUM(FInitAccDepreciation) allFInitAccDepreciation, SUM(fadjustAccDepAsset) allFadjustAccDepAsset, SUM(faccDeprAdjustment) allFaccDeprAdjustment,SUM(FinanceInitAccDepreciation) allFinanceInitAccDepreciation");
        allSql1.append(" FROM T_FA_FaLeaseInBillNew");
        allSql1.append(" where fid in (");
        for (int i = 0; i < idList.size(); ++i) {
            if (i > 0) {
                allSql1.append(",");
            }
            allSql1.append("'").append(((String)idList.get(i)).toString()).append("'");
        }
        allSql1.append(")");
        IRowSet allRs1 = DbUtil.executeQuery((Context)ctx, (String)allSql1.toString());
        StringBuilder allSql2 = new StringBuilder();
        allSql2.append(" SELECT SUM(entry.FTerAcumDepreamt) allFTerAcumDepreamt ");
        allSql2.append(" FROM T_FA_FaLeaseInBillNew bill");
        allSql2.append(" LEFT JOIN T_FA_FaTerminateBillentry entry ON bill.FId = entry.FLEASEINBILLID");
        allSql2.append(" where bill.fid in (");
        for (int i = 0; i < idList.size(); ++i) {
            if (i > 0) {
                allSql2.append(",");
            }
            allSql2.append("'").append((String)idList.get(i)).append("'");
        }
        allSql2.append(")");
        IRowSet allRs2 = DbUtil.executeQuery((Context)ctx, (String)allSql2.toString());
        try {
            BigDecimal accDepOfAsset = leaseInBill.getAccDepOfAsset() == null ? BigDecimal.ZERO : leaseInBill.getAccDepOfAsset();
            BigDecimal adjustAccDepAsset = leaseInBill.getAdjustAccDepAsset() == null ? BigDecimal.ZERO : leaseInBill.getAdjustAccDepAsset();
            BigDecimal accDeprAdjustment = leaseInBill.getAccDeprAdjustment() == null ? BigDecimal.ZERO : leaseInBill.getAccDeprAdjustment();
            BigDecimal allRsMonthDep = BigDecimal.ZERO;
            BigDecimal allFaccDepOfAsset = BigDecimal.ZERO;
            BigDecimal allFInitAccDepreciation = BigDecimal.ZERO;
            BigDecimal allFadjustAccDepAsset = BigDecimal.ZERO;
            BigDecimal allFaccDeprAdjustment = BigDecimal.ZERO;
            BigDecimal allFinanceInitAccDepreciation = BigDecimal.ZERO;
            BigDecimal allFTerAcumDepreamt = BigDecimal.ZERO;
            BigDecimal allFTerAcumDepreamtTerminate = BigDecimal.ZERO;
            while (allRs.next()) {
                allRsMonthDep = allRs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : allRs.getBigDecimal("monthDep");
            }
            while (allRs1.next()) {
                allFaccDepOfAsset = allRs1.getBigDecimal("allFaccDepOfAsset") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFaccDepOfAsset");
                allFInitAccDepreciation = allRs1.getBigDecimal("allFInitAccDepreciation") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFInitAccDepreciation");
                allFadjustAccDepAsset = allRs1.getBigDecimal("allFadjustAccDepAsset") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFadjustAccDepAsset");
                allFaccDeprAdjustment = allRs1.getBigDecimal("allFaccDeprAdjustment") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFaccDeprAdjustment");
                allFinanceInitAccDepreciation = allRs1.getBigDecimal("allFinanceInitAccDepreciation") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFinanceInitAccDepreciation");
            }
            while (allRs2.next()) {
                allFTerAcumDepreamtTerminate = allRs2.getBigDecimal("allFTerAcumDepreamt") == null ? BigDecimal.ZERO : allRs2.getBigDecimal("allFTerAcumDepreamt");
            }
            while (rs.next()) {
                BigDecimal monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep.subtract(accDepOfAsset).add(adjustAccDepAsset).add(accDeprAdjustment).add(allRsMonthDep).add(allFaccDepOfAsset).add(allFInitAccDepreciation).add(allFadjustAccDepAsset).add(allFaccDeprAdjustment).add(allFinanceInitAccDepreciation).subtract(allFTerAcumDepreamtTerminate);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForFifteen(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        ArrayList<String> idList = new ArrayList<String>();
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date terminateDate = TerminateBillCalc.getMaxMonthDate((Date)params.get("terminateDate"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate <= ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(terminateDate.getTime())});
        TerminateBillCalc.buildIdList(ctx, idList, leaseInBillId);
        StringBuilder allSql = new StringBuilder();
        allSql.append(" SELECT SUM(dep.FMONTHLYDEPREAMT) monthDep, SUM(dep.FMONTHLYINTERESTEXPE) monthIP");
        allSql.append(" FROM T_FA_FaDepreAndAmort dep");
        allSql.append(" where dep.FLEASEINBILLID in (");
        for (int i = 0; i < idList.size(); ++i) {
            if (i > 0) {
                allSql.append(",");
            }
            allSql.append("'").append((String)idList.get(i)).append("'");
        }
        allSql.append(")");
        IRowSet allRs = DbUtil.executeQuery((Context)ctx, (String)allSql.toString());
        StringBuilder allSql1 = new StringBuilder();
        allSql1.append(" SELECT SUM(faccDepOfAsset) allFaccDepOfAsset, SUM(FInitAccDepreciation) allFInitAccDepreciation, SUM(fadjustAccDepAsset) allFadjustAccDepAsset, SUM(faccDeprAdjustment) allFaccDeprAdjustment,SUM(FinanceInitAccDepreciation) allFinanceInitAccDepreciation");
        allSql1.append(" FROM T_FA_FaLeaseInBillNew");
        allSql1.append(" where fid in (");
        for (int i = 0; i < idList.size(); ++i) {
            if (i > 0) {
                allSql1.append(",");
            }
            allSql1.append("'").append((String)idList.get(i)).append("'");
        }
        allSql1.append(")");
        IRowSet allRs1 = DbUtil.executeQuery((Context)ctx, (String)allSql1.toString());
        StringBuilder allSql2 = new StringBuilder();
        allSql2.append(" SELECT SUM(entry.FTerAcumDepreamt) allFTerAcumDepreamt ");
        allSql2.append(" FROM T_FA_FaLeaseInBillNew bill");
        allSql2.append(" LEFT JOIN T_FA_FaTerminateBillentry entry ON bill.FId = entry.FLEASEINBILLID");
        allSql2.append(" where bill.fid in (");
        for (int i = 0; i < idList.size(); ++i) {
            if (i > 0) {
                allSql2.append(",");
            }
            allSql2.append("'").append((String)idList.get(i)).append("'");
        }
        allSql2.append(")");
        IRowSet allRs2 = DbUtil.executeQuery((Context)ctx, (String)allSql2.toString());
        try {
            BigDecimal accDepOfAsset = leaseInBill.getAccDepOfAsset() == null ? BigDecimal.ZERO : leaseInBill.getAccDepOfAsset();
            BigDecimal adjustAccDepAsset = leaseInBill.getAdjustAccDepAsset() == null ? BigDecimal.ZERO : leaseInBill.getAdjustAccDepAsset();
            BigDecimal accDeprAdjustment = leaseInBill.getAccDeprAdjustment() == null ? BigDecimal.ZERO : leaseInBill.getAccDeprAdjustment();
            BigDecimal allRsMonthDep = BigDecimal.ZERO;
            BigDecimal allFaccDepOfAsset = BigDecimal.ZERO;
            BigDecimal allFInitAccDepreciation = BigDecimal.ZERO;
            BigDecimal allFadjustAccDepAsset = BigDecimal.ZERO;
            BigDecimal allFaccDeprAdjustment = BigDecimal.ZERO;
            BigDecimal allFinanceInitAccDepreciation = BigDecimal.ZERO;
            BigDecimal allFTerAcumDepreamt = BigDecimal.ZERO;
            BigDecimal allFTerAcumDepreamtTerminate = BigDecimal.ZERO;
            while (allRs.next()) {
                allRsMonthDep = allRs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : allRs.getBigDecimal("monthDep");
            }
            while (allRs1.next()) {
                allFaccDepOfAsset = allRs1.getBigDecimal("allFaccDepOfAsset") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFaccDepOfAsset");
                allFInitAccDepreciation = allRs1.getBigDecimal("allFInitAccDepreciation") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFInitAccDepreciation");
                allFadjustAccDepAsset = allRs1.getBigDecimal("allFadjustAccDepAsset") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFadjustAccDepAsset");
                allFaccDeprAdjustment = allRs1.getBigDecimal("allFaccDeprAdjustment") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFaccDeprAdjustment");
                allFinanceInitAccDepreciation = allRs1.getBigDecimal("allFinanceInitAccDepreciation") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFinanceInitAccDepreciation");
            }
            while (allRs2.next()) {
                allFTerAcumDepreamtTerminate = allRs2.getBigDecimal("allFTerAcumDepreamt") == null ? BigDecimal.ZERO : allRs2.getBigDecimal("allFTerAcumDepreamt");
            }
            while (rs.next()) {
                BigDecimal monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep.subtract(accDepOfAsset).add(adjustAccDepAsset).add(accDeprAdjustment).add(allRsMonthDep).add(allFaccDepOfAsset).add(allFInitAccDepreciation).add(allFadjustAccDepAsset).add(allFaccDeprAdjustment).add(allFinanceInitAccDepreciation).subtract(allFTerAcumDepreamtTerminate);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForSixteen(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        ArrayList<String> idList = new ArrayList<String>();
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date terminateDate = TerminateBillCalc.getMinMonthDate((Date)params.get("terminateDate"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate < ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(terminateDate.getTime())});
        TerminateBillCalc.buildIdList(ctx, idList, leaseInBillId);
        StringBuilder allSql = new StringBuilder();
        allSql.append(" SELECT SUM(dep.FMONTHLYDEPREAMT) monthDep, SUM(dep.FMONTHLYINTERESTEXPE) monthIP");
        allSql.append(" FROM T_FA_FaDepreAndAmort dep");
        allSql.append(" where dep.FLEASEINBILLID in (");
        for (int i = 0; i < idList.size(); ++i) {
            if (i > 0) {
                allSql.append(",");
            }
            allSql.append("'").append((String)idList.get(i)).append("'");
        }
        allSql.append(")");
        IRowSet allRs = DbUtil.executeQuery((Context)ctx, (String)allSql.toString());
        StringBuilder allSql1 = new StringBuilder();
        allSql1.append(" SELECT SUM(faccDepOfAsset) allFaccDepOfAsset, SUM(FInitAccDepreciation) allFInitAccDepreciation, SUM(fadjustAccDepAsset) allFadjustAccDepAsset, SUM(faccDeprAdjustment) allFaccDeprAdjustment,SUM(FinanceInitAccDepreciation) allFinanceInitAccDepreciation");
        allSql1.append(" FROM T_FA_FaLeaseInBillNew");
        allSql1.append(" where fid in (");
        for (int i = 0; i < idList.size(); ++i) {
            if (i > 0) {
                allSql1.append(",");
            }
            allSql1.append("'").append((String)idList.get(i)).append("'");
        }
        allSql1.append(")");
        IRowSet allRs1 = DbUtil.executeQuery((Context)ctx, (String)allSql1.toString());
        StringBuilder allSql2 = new StringBuilder();
        allSql2.append(" SELECT SUM(entry.FTerAcumDepreamt) allFTerAcumDepreamt ");
        allSql2.append(" FROM T_FA_FaLeaseInBillNew bill");
        allSql2.append(" LEFT JOIN T_FA_FaTerminateBillentry entry ON bill.FId = entry.FLEASEINBILLID");
        allSql2.append(" where bill.fid in (");
        for (int i = 0; i < idList.size(); ++i) {
            if (i > 0) {
                allSql2.append(",");
            }
            allSql2.append("'").append((String)idList.get(i)).append("'");
        }
        allSql2.append(")");
        IRowSet allRs2 = DbUtil.executeQuery((Context)ctx, (String)allSql2.toString());
        try {
            BigDecimal accDepOfAsset = leaseInBill.getAccDepOfAsset() == null ? BigDecimal.ZERO : leaseInBill.getAccDepOfAsset();
            BigDecimal adjustAccDepAsset = leaseInBill.getAdjustAccDepAsset() == null ? BigDecimal.ZERO : leaseInBill.getAdjustAccDepAsset();
            BigDecimal accDeprAdjustment = leaseInBill.getAccDeprAdjustment() == null ? BigDecimal.ZERO : leaseInBill.getAccDeprAdjustment();
            BigDecimal allRsMonthDep = BigDecimal.ZERO;
            BigDecimal allFaccDepOfAsset = BigDecimal.ZERO;
            BigDecimal allFInitAccDepreciation = BigDecimal.ZERO;
            BigDecimal allFadjustAccDepAsset = BigDecimal.ZERO;
            BigDecimal allFaccDeprAdjustment = BigDecimal.ZERO;
            BigDecimal allFinanceInitAccDepreciation = BigDecimal.ZERO;
            BigDecimal allFTerAcumDepreamt = BigDecimal.ZERO;
            BigDecimal allFTerAcumDepreamtTerminate = BigDecimal.ZERO;
            while (allRs.next()) {
                allRsMonthDep = allRs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : allRs.getBigDecimal("monthDep");
            }
            while (allRs1.next()) {
                allFaccDepOfAsset = allRs1.getBigDecimal("allFaccDepOfAsset") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFaccDepOfAsset");
                allFInitAccDepreciation = allRs1.getBigDecimal("allFInitAccDepreciation") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFInitAccDepreciation");
                allFadjustAccDepAsset = allRs1.getBigDecimal("allFadjustAccDepAsset") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFadjustAccDepAsset");
                allFaccDeprAdjustment = allRs1.getBigDecimal("allFaccDeprAdjustment") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFaccDeprAdjustment");
                allFinanceInitAccDepreciation = allRs1.getBigDecimal("allFinanceInitAccDepreciation") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFinanceInitAccDepreciation");
            }
            while (allRs2.next()) {
                allFTerAcumDepreamtTerminate = allRs2.getBigDecimal("allFTerAcumDepreamt") == null ? BigDecimal.ZERO : allRs2.getBigDecimal("allFTerAcumDepreamt");
            }
            while (rs.next()) {
                BigDecimal monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep.subtract(accDepOfAsset).add(adjustAccDepAsset).add(accDeprAdjustment).add(allRsMonthDep).add(allFaccDepOfAsset).add(allFInitAccDepreciation).add(allFadjustAccDepAsset).add(allFaccDeprAdjustment).add(allFinanceInitAccDepreciation).subtract(allFTerAcumDepreamtTerminate);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForSeventeen(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        ArrayList<String> idList = new ArrayList<String>();
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date terminateDate = (Date)params.get("terminateDate");
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate < ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(terminateDate.getTime())});
        TerminateBillCalc.buildIdList(ctx, idList, leaseInBillId);
        StringBuilder allSql = new StringBuilder();
        allSql.append(" SELECT SUM(dep.FMONTHLYDEPREAMT) monthDep, SUM(dep.FMONTHLYINTERESTEXPE) monthIP");
        allSql.append(" FROM T_FA_FaDepreAndAmort dep");
        allSql.append(" where dep.FLEASEINBILLID in (");
        for (int i = 0; i < idList.size(); ++i) {
            if (i > 0) {
                allSql.append(",");
            }
            allSql.append("'").append((String)idList.get(i)).append("'");
        }
        allSql.append(")");
        IRowSet allRs = DbUtil.executeQuery((Context)ctx, (String)allSql.toString());
        StringBuilder allSql1 = new StringBuilder();
        allSql1.append(" SELECT SUM(faccDepOfAsset) allFaccDepOfAsset, SUM(FInitAccDepreciation) allFInitAccDepreciation,  SUM(fadjustAccDepAsset) allFadjustAccDepAsset, SUM(faccDeprAdjustment) allFaccDeprAdjustment,SUM(FinanceInitAccDepreciation) allFinanceInitAccDepreciation");
        allSql1.append(" FROM T_FA_FaLeaseInBillNew");
        allSql1.append(" where fid in (");
        for (int i = 0; i < idList.size(); ++i) {
            if (i > 0) {
                allSql1.append(",");
            }
            allSql1.append("'").append((String)idList.get(i)).append("'");
        }
        allSql1.append(")");
        IRowSet allRs1 = DbUtil.executeQuery((Context)ctx, (String)allSql1.toString());
        StringBuilder allSql2 = new StringBuilder();
        allSql2.append(" SELECT SUM(entry.FTerAcumDepreamt) allFTerAcumDepreamt ");
        allSql2.append(" FROM T_FA_FaLeaseInBillNew bill");
        allSql2.append(" LEFT JOIN T_FA_FaTerminateBillentry entry ON bill.FId = entry.FLEASEINBILLID");
        allSql2.append(" where bill.fid in (");
        for (int i = 0; i < idList.size(); ++i) {
            if (i > 0) {
                allSql2.append(",");
            }
            allSql2.append("'").append(((String)idList.get(i)).toString()).append("'");
        }
        allSql2.append(")");
        IRowSet allRs2 = DbUtil.executeQuery((Context)ctx, (String)allSql2.toString());
        try {
            BigDecimal accDepOfAsset = leaseInBill.getAccDepOfAsset() == null ? BigDecimal.ZERO : leaseInBill.getAccDepOfAsset();
            BigDecimal adjustAccDepAsset = leaseInBill.getAdjustAccDepAsset() == null ? BigDecimal.ZERO : leaseInBill.getAdjustAccDepAsset();
            BigDecimal accDeprAdjustment = leaseInBill.getAccDeprAdjustment() == null ? BigDecimal.ZERO : leaseInBill.getAccDeprAdjustment();
            BigDecimal allRsMonthDep = BigDecimal.ZERO;
            BigDecimal allFaccDepOfAsset = BigDecimal.ZERO;
            BigDecimal allFInitAccDepreciation = BigDecimal.ZERO;
            BigDecimal allFadjustAccDepAsset = BigDecimal.ZERO;
            BigDecimal allFaccDeprAdjustment = BigDecimal.ZERO;
            BigDecimal allFinanceInitAccDepreciation = BigDecimal.ZERO;
            BigDecimal allFTerAcumDepreamt = BigDecimal.ZERO;
            BigDecimal allFTerAcumDepreamtTerminate = BigDecimal.ZERO;
            while (allRs.next()) {
                allRsMonthDep = allRs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : allRs.getBigDecimal("monthDep");
            }
            while (allRs1.next()) {
                allFaccDepOfAsset = allRs1.getBigDecimal("allFaccDepOfAsset") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFaccDepOfAsset");
                allFInitAccDepreciation = allRs1.getBigDecimal("allFInitAccDepreciation") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFInitAccDepreciation");
                allFadjustAccDepAsset = allRs1.getBigDecimal("allFadjustAccDepAsset") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFadjustAccDepAsset");
                allFaccDeprAdjustment = allRs1.getBigDecimal("allFaccDeprAdjustment") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFaccDeprAdjustment");
                allFinanceInitAccDepreciation = allRs1.getBigDecimal("allFinanceInitAccDepreciation") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFinanceInitAccDepreciation");
            }
            while (allRs2.next()) {
                allFTerAcumDepreamtTerminate = allRs2.getBigDecimal("allFTerAcumDepreamt") == null ? BigDecimal.ZERO : allRs2.getBigDecimal("allFTerAcumDepreamt");
            }
            while (rs.next()) {
                BigDecimal monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep.subtract(accDepOfAsset).add(adjustAccDepAsset).add(accDeprAdjustment).add(allRsMonthDep).add(allFaccDepOfAsset).add(allFInitAccDepreciation).add(allFadjustAccDepAsset).add(allFaccDeprAdjustment).add(allFinanceInitAccDepreciation).subtract(allFTerAcumDepreamtTerminate);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForEighteen(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date terminateDate = TerminateBillCalc.getMaxMonthDate((Date)params.get("terminateDate"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate <= ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(terminateDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep;
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForNineteen(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date terminateDate = TerminateBillCalc.getMinMonthDate((Date)params.get("terminateDate"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate < ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(terminateDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep;
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForTwenty(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date terminateDate = (Date)params.get("terminateDate");
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate < ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(terminateDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep;
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForTwentyone(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date terminateDate = TerminateBillCalc.getMaxMonthDate((Date)params.get("terminateDate"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate <= ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(terminateDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep.add(leaseInBill.getInitAccDepreciation() == null ? BigDecimal.ZERO : leaseInBill.getInitAccDepreciation());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForTwentytwo(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date terminateDate = TerminateBillCalc.getMinMonthDate((Date)params.get("terminateDate"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate < ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(terminateDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep.add(leaseInBill.getInitAccDepreciation() == null ? BigDecimal.ZERO : leaseInBill.getInitAccDepreciation());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForTwentythree(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date terminateDate = (Date)params.get("terminateDate");
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate < ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(terminateDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep.add(leaseInBill.getInitAccDepreciation() == null ? BigDecimal.ZERO : leaseInBill.getInitAccDepreciation());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForTwentyfour(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        ArrayList<String> idList = new ArrayList<String>();
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date adjustDate = TerminateBillCalc.getMaxMonthDate((Date)params.get("adjustDate"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate <= ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(adjustDate.getTime())});
        TerminateBillCalc.buildIdList(ctx, idList, leaseInBillId);
        StringBuilder allSql = new StringBuilder();
        allSql.append(" SELECT SUM(dep.FMONTHLYDEPREAMT) monthDep, SUM(dep.FMONTHLYINTERESTEXPE) monthIP");
        allSql.append(" FROM T_FA_FaDepreAndAmort dep");
        allSql.append(" where dep.FLEASEINBILLID in (");
        for (int i = 0; i < idList.size(); ++i) {
            if (i > 0) {
                allSql.append(",");
            }
            allSql.append("'").append((String)idList.get(i)).append("'");
        }
        allSql.append(")");
        IRowSet allRs = DbUtil.executeQuery((Context)ctx, (String)allSql.toString());
        StringBuilder allSql1 = new StringBuilder();
        allSql1.append(" SELECT SUM(faccDepOfAsset) allFaccDepOfAsset, SUM(FInitAccDepreciation) allFInitAccDepreciation,  SUM(fadjustAccDepAsset) allFadjustAccDepAsset, SUM(faccDeprAdjustment) allFaccDeprAdjustment,SUM(FinanceInitAccDepreciation) allFinanceInitAccDepreciation");
        allSql1.append(" FROM T_FA_FaLeaseInBillNew");
        allSql1.append(" where fid in (");
        for (int i = 0; i < idList.size(); ++i) {
            if (i > 0) {
                allSql1.append(",");
            }
            allSql1.append("'").append(((String)idList.get(i)).toString()).append("'");
        }
        allSql1.append(")");
        IRowSet allRs1 = DbUtil.executeQuery((Context)ctx, (String)allSql1.toString());
        StringBuilder allSql2 = new StringBuilder();
        allSql2.append(" SELECT SUM(entry.FTerAcumDepreamt) allFTerAcumDepreamt ");
        allSql2.append(" FROM T_FA_FaLeaseInBillNew bill");
        allSql2.append(" LEFT JOIN T_FA_FaTerminateBillentry entry ON bill.FId = entry.FLEASEINBILLID");
        allSql2.append(" where bill.fid in (");
        for (int i = 0; i < idList.size(); ++i) {
            if (i > 0) {
                allSql2.append(",");
            }
            allSql2.append("'").append((String)idList.get(i)).append("'");
        }
        allSql2.append(")");
        IRowSet allRs2 = DbUtil.executeQuery((Context)ctx, (String)allSql2.toString());
        try {
            BigDecimal accDepOfAsset = leaseInBill.getAccDepOfAsset() == null ? BigDecimal.ZERO : leaseInBill.getAccDepOfAsset();
            BigDecimal adjustAccDepAsset = leaseInBill.getAdjustAccDepAsset() == null ? BigDecimal.ZERO : leaseInBill.getAdjustAccDepAsset();
            BigDecimal accDeprAdjustment = leaseInBill.getAccDeprAdjustment() == null ? BigDecimal.ZERO : leaseInBill.getAccDeprAdjustment();
            BigDecimal allRsMonthDep = BigDecimal.ZERO;
            BigDecimal allFaccDepOfAsset = BigDecimal.ZERO;
            BigDecimal allFInitAccDepreciation = BigDecimal.ZERO;
            BigDecimal allFadjustAccDepAsset = BigDecimal.ZERO;
            BigDecimal allFaccDeprAdjustment = BigDecimal.ZERO;
            BigDecimal allFinanceInitAccDepreciation = BigDecimal.ZERO;
            BigDecimal allFTerAcumDepreamt = BigDecimal.ZERO;
            BigDecimal allFTerAcumDepreamtTerminate = BigDecimal.ZERO;
            while (allRs.next()) {
                allRsMonthDep = allRs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : allRs.getBigDecimal("monthDep");
            }
            while (allRs1.next()) {
                allFaccDepOfAsset = allRs1.getBigDecimal("allFaccDepOfAsset") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFaccDepOfAsset");
                allFInitAccDepreciation = allRs1.getBigDecimal("allFInitAccDepreciation") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFInitAccDepreciation");
                allFadjustAccDepAsset = allRs1.getBigDecimal("allFadjustAccDepAsset") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFadjustAccDepAsset");
                allFaccDeprAdjustment = allRs1.getBigDecimal("allFaccDeprAdjustment") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFaccDeprAdjustment");
                allFinanceInitAccDepreciation = allRs1.getBigDecimal("allFinanceInitAccDepreciation") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFinanceInitAccDepreciation");
            }
            while (allRs2.next()) {
                allFTerAcumDepreamtTerminate = allRs2.getBigDecimal("allFTerAcumDepreamt") == null ? BigDecimal.ZERO : allRs2.getBigDecimal("allFTerAcumDepreamt");
            }
            while (rs.next()) {
                BigDecimal monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep.subtract(accDepOfAsset).add(adjustAccDepAsset).add(accDeprAdjustment).add(allRsMonthDep).add(allFaccDepOfAsset).add(allFInitAccDepreciation).add(allFadjustAccDepAsset).add(allFaccDeprAdjustment).add(allFinanceInitAccDepreciation).subtract(allFTerAcumDepreamtTerminate);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForTwentyfive(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        ArrayList<String> idList = new ArrayList<String>();
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date adjustDate = TerminateBillCalc.getMinMonthDate((Date)params.get("adjustDate"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate < ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(adjustDate.getTime())});
        TerminateBillCalc.buildIdList(ctx, idList, leaseInBillId);
        StringBuilder allSql = new StringBuilder();
        allSql.append(" SELECT SUM(dep.FMONTHLYDEPREAMT) monthDep, SUM(dep.FMONTHLYINTERESTEXPE) monthIP");
        allSql.append(" FROM T_FA_FaDepreAndAmort dep");
        allSql.append(" where dep.FLEASEINBILLID in (");
        for (int i = 0; i < idList.size(); ++i) {
            if (i > 0) {
                allSql.append(",");
            }
            allSql.append("'").append((String)idList.get(i)).append("'");
        }
        allSql.append(")");
        IRowSet allRs = DbUtil.executeQuery((Context)ctx, (String)allSql.toString());
        StringBuilder allSql1 = new StringBuilder();
        allSql1.append(" SELECT SUM(faccDepOfAsset) allFaccDepOfAsset, SUM(FInitAccDepreciation) allFInitAccDepreciation,  SUM(fadjustAccDepAsset) allFadjustAccDepAsset, SUM(faccDeprAdjustment) allFaccDeprAdjustment,SUM(FinanceInitAccDepreciation) allFinanceInitAccDepreciation");
        allSql1.append(" FROM T_FA_FaLeaseInBillNew");
        allSql1.append(" where fid in (");
        for (int i = 0; i < idList.size(); ++i) {
            if (i > 0) {
                allSql1.append(",");
            }
            allSql1.append("'").append((String)idList.get(i)).append("'");
        }
        allSql1.append(")");
        IRowSet allRs1 = DbUtil.executeQuery((Context)ctx, (String)allSql1.toString());
        StringBuilder allSql2 = new StringBuilder();
        allSql2.append(" SELECT SUM(entry.FTerAcumDepreamt) allFTerAcumDepreamt ");
        allSql2.append(" FROM T_FA_FaLeaseInBillNew bill");
        allSql2.append(" LEFT JOIN T_FA_FaTerminateBillentry entry ON bill.FId = entry.FLEASEINBILLID");
        allSql2.append(" where bill.fid in (");
        for (int i = 0; i < idList.size(); ++i) {
            if (i > 0) {
                allSql2.append(",");
            }
            allSql2.append("'").append((String)idList.get(i)).append("'");
        }
        allSql2.append(")");
        IRowSet allRs2 = DbUtil.executeQuery((Context)ctx, (String)allSql2.toString());
        try {
            BigDecimal accDepOfAsset = leaseInBill.getAccDepOfAsset() == null ? BigDecimal.ZERO : leaseInBill.getAccDepOfAsset();
            BigDecimal adjustAccDepAsset = leaseInBill.getAdjustAccDepAsset() == null ? BigDecimal.ZERO : leaseInBill.getAdjustAccDepAsset();
            BigDecimal accDeprAdjustment = leaseInBill.getAccDeprAdjustment() == null ? BigDecimal.ZERO : leaseInBill.getAccDeprAdjustment();
            BigDecimal allRsMonthDep = BigDecimal.ZERO;
            BigDecimal allFaccDepOfAsset = BigDecimal.ZERO;
            BigDecimal allFInitAccDepreciation = BigDecimal.ZERO;
            BigDecimal allFadjustAccDepAsset = BigDecimal.ZERO;
            BigDecimal allFaccDeprAdjustment = BigDecimal.ZERO;
            BigDecimal allFinanceInitAccDepreciation = BigDecimal.ZERO;
            BigDecimal allFTerAcumDepreamt = BigDecimal.ZERO;
            BigDecimal allFTerAcumDepreamtTerminate = BigDecimal.ZERO;
            while (allRs.next()) {
                allRsMonthDep = allRs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : allRs.getBigDecimal("monthDep");
            }
            while (allRs1.next()) {
                allFaccDepOfAsset = allRs1.getBigDecimal("allFaccDepOfAsset") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFaccDepOfAsset");
                allFInitAccDepreciation = allRs1.getBigDecimal("allFInitAccDepreciation") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFInitAccDepreciation");
                allFadjustAccDepAsset = allRs1.getBigDecimal("allFadjustAccDepAsset") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFadjustAccDepAsset");
                allFaccDeprAdjustment = allRs1.getBigDecimal("allFaccDeprAdjustment") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFaccDeprAdjustment");
                allFinanceInitAccDepreciation = allRs1.getBigDecimal("allFinanceInitAccDepreciation") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFinanceInitAccDepreciation");
            }
            while (allRs2.next()) {
                allFTerAcumDepreamtTerminate = allRs2.getBigDecimal("allFTerAcumDepreamt") == null ? BigDecimal.ZERO : allRs2.getBigDecimal("allFTerAcumDepreamt");
            }
            while (rs.next()) {
                BigDecimal monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep.subtract(accDepOfAsset).add(adjustAccDepAsset).add(accDeprAdjustment).add(allRsMonthDep).add(allFaccDepOfAsset).add(allFInitAccDepreciation).add(allFadjustAccDepAsset).add(allFaccDeprAdjustment).add(allFinanceInitAccDepreciation).subtract(allFTerAcumDepreamtTerminate);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForTwentysix(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        ArrayList<String> idList = new ArrayList<String>();
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date adjustDate = (Date)params.get("adjustDate");
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate < ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(adjustDate.getTime())});
        TerminateBillCalc.buildIdList(ctx, idList, leaseInBillId);
        StringBuilder allSql = new StringBuilder();
        allSql.append(" SELECT SUM(dep.FMONTHLYDEPREAMT) monthDep, SUM(dep.FMONTHLYINTERESTEXPE) monthIP");
        allSql.append(" FROM T_FA_FaDepreAndAmort dep");
        allSql.append(" where dep.FLEASEINBILLID in (");
        for (int i = 0; i < idList.size(); ++i) {
            if (i > 0) {
                allSql.append(",");
            }
            allSql.append("'").append((String)idList.get(i)).append("'");
        }
        allSql.append(")");
        IRowSet allRs = DbUtil.executeQuery((Context)ctx, (String)allSql.toString());
        StringBuilder allSql1 = new StringBuilder();
        allSql1.append(" SELECT SUM(faccDepOfAsset) allFaccDepOfAsset, SUM(FInitAccDepreciation) allFInitAccDepreciation,  SUM(fadjustAccDepAsset) allFadjustAccDepAsset, SUM(faccDeprAdjustment) allFaccDeprAdjustment,SUM(FinanceInitAccDepreciation) allFinanceInitAccDepreciation");
        allSql1.append(" FROM T_FA_FaLeaseInBillNew");
        allSql1.append(" where fid in (");
        for (int i = 0; i < idList.size(); ++i) {
            if (i > 0) {
                allSql1.append(",");
            }
            allSql1.append("'").append((String)idList.get(i)).append("'");
        }
        allSql1.append(")");
        IRowSet allRs1 = DbUtil.executeQuery((Context)ctx, (String)allSql1.toString());
        StringBuilder allSql2 = new StringBuilder();
        allSql2.append(" SELECT SUM(entry.FTerAcumDepreamt) allFTerAcumDepreamt ");
        allSql2.append(" FROM T_FA_FaLeaseInBillNew bill");
        allSql2.append(" LEFT JOIN T_FA_FaTerminateBillentry entry ON bill.FId = entry.FLEASEINBILLID");
        allSql2.append(" where bill.fid in (");
        for (int i = 0; i < idList.size(); ++i) {
            if (i > 0) {
                allSql2.append(",");
            }
            allSql2.append("'").append((String)idList.get(i)).append("'");
        }
        allSql2.append(")");
        IRowSet allRs2 = DbUtil.executeQuery((Context)ctx, (String)allSql2.toString());
        try {
            BigDecimal accDepOfAsset = leaseInBill.getAccDepOfAsset() == null ? BigDecimal.ZERO : leaseInBill.getAccDepOfAsset();
            BigDecimal adjustAccDepAsset = leaseInBill.getAdjustAccDepAsset() == null ? BigDecimal.ZERO : leaseInBill.getAdjustAccDepAsset();
            BigDecimal accDeprAdjustment = leaseInBill.getAccDeprAdjustment() == null ? BigDecimal.ZERO : leaseInBill.getAccDeprAdjustment();
            BigDecimal allRsMonthDep = BigDecimal.ZERO;
            BigDecimal allFaccDepOfAsset = BigDecimal.ZERO;
            BigDecimal allFInitAccDepreciation = BigDecimal.ZERO;
            BigDecimal allFadjustAccDepAsset = BigDecimal.ZERO;
            BigDecimal allFaccDeprAdjustment = BigDecimal.ZERO;
            BigDecimal allFinanceInitAccDepreciation = BigDecimal.ZERO;
            BigDecimal allFTerAcumDepreamt = BigDecimal.ZERO;
            BigDecimal allFTerAcumDepreamtTerminate = BigDecimal.ZERO;
            while (allRs.next()) {
                allRsMonthDep = allRs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : allRs.getBigDecimal("monthDep");
            }
            while (allRs1.next()) {
                allFaccDepOfAsset = allRs1.getBigDecimal("allFaccDepOfAsset") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFaccDepOfAsset");
                allFInitAccDepreciation = allRs1.getBigDecimal("allFInitAccDepreciation") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFInitAccDepreciation");
                allFadjustAccDepAsset = allRs1.getBigDecimal("allFadjustAccDepAsset") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFadjustAccDepAsset");
                allFaccDeprAdjustment = allRs1.getBigDecimal("allFaccDeprAdjustment") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFaccDeprAdjustment");
                allFinanceInitAccDepreciation = allRs1.getBigDecimal("allFinanceInitAccDepreciation") == null ? BigDecimal.ZERO : allRs1.getBigDecimal("allFinanceInitAccDepreciation");
            }
            while (allRs2.next()) {
                allFTerAcumDepreamtTerminate = allRs2.getBigDecimal("allFTerAcumDepreamt") == null ? BigDecimal.ZERO : allRs2.getBigDecimal("allFTerAcumDepreamt");
            }
            while (rs.next()) {
                BigDecimal monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep.subtract(accDepOfAsset).add(adjustAccDepAsset).add(accDeprAdjustment).add(allRsMonthDep).add(allFaccDepOfAsset).add(allFInitAccDepreciation).add(allFadjustAccDepAsset).add(allFaccDeprAdjustment).add(allFinanceInitAccDepreciation).subtract(allFTerAcumDepreamtTerminate);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForTwentyseven(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date adjustDate = TerminateBillCalc.getMaxMonthDate((Date)params.get("adjustDate"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate <= ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(adjustDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep;
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForTwentyeight(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date adjustDate = TerminateBillCalc.getMinMonthDate((Date)params.get("adjustDate"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate < ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(adjustDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep;
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForTwentynine(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date adjustDate = (Date)params.get("adjustDate");
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate < ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(adjustDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep;
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumInterestExpeForOne(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date billEndDate = (Date)params.get("billEndDate");
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate <= ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(billEndDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthIP;
                ((BigDecimal[])result.get((Object)leaseInBillId))[1] = monthIP = rs.getBigDecimal("monthIP") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthIP");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumInterestExpeForTwo(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date terminateDate = (Date)params.get("terminateDate");
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate < ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(terminateDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthIP;
                ((BigDecimal[])result.get((Object)leaseInBillId))[1] = monthIP = rs.getBigDecimal("monthIP") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthIP");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumInterestExpeForThree(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date adjustDate = (Date)params.get("adjustDate");
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate < ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(adjustDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthIP;
                ((BigDecimal[])result.get((Object)leaseInBillId))[1] = monthIP = rs.getBigDecimal("monthIP") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthIP");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getRetrPaidRentAmtForOne(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date terminateDate = (Date)params.get("terminateDate");
        Date adjustDate = (Date)params.get("adjustDate");
        boolean isDeductible = (Boolean)params.get("isDeductible");
        StringBuilder sql = new StringBuilder();
        sql.append(" select FHeadID billId, sum(" + (isDeductible ? "FPaymentWithoutTax" : "FPaymentWithTax") + ") resultNumber FROM T_FA_FaPaymentPlanNew");
        sql.append(" where FHeadID = ?");
        sql.append(" and FPayDate > ? and FPayDate <= ?");
        sql.append(" group by FHeadID");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(adjustDate.getTime()), new Timestamp(terminateDate.getTime())});
        try {
            while (rs.next()) {
                String id = rs.getString("billId");
                BigDecimal retrPaidRentAmt = rs.getBigDecimal("resultNumber") == null ? BigDecimal.ZERO : rs.getBigDecimal("resultNumber");
                result.put(id + "adjust", retrPaidRentAmt);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getRetrCalcAcumDepreAmtForOne(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date adjustDate = TerminateBillCalc.getMinMonthDate((Date)params.get("adjustDate"));
        Date terminateDate = TerminateBillCalc.getMinMonthDate((Date)params.get("terminateDate"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate >= ?");
        sql.append(" AND entry.FDate < ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(adjustDate.getTime()), new Timestamp(terminateDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep;
                ((BigDecimal[])result.get((Object)leaseInBillId))[2] = monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getRetrCalcAcumDepreAmtForTwo(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date adjustDate = (Date)params.get("adjustDate");
        Date terminateDate = TerminateBillCalc.getMinMonthDate((Date)params.get("terminateDate"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate >= ?");
        sql.append(" AND entry.FDate < ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(adjustDate.getTime()), new Timestamp(terminateDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep;
                ((BigDecimal[])result.get((Object)leaseInBillId))[2] = monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getRetrCalcAcumDepreAmtForThree(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date adjustDate = TerminateBillCalc.getMaxMonthDate((Date)params.get("adjustDate"));
        Date terminateDate = TerminateBillCalc.getMinMonthDate((Date)params.get("terminateDate"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate > ?");
        sql.append(" AND entry.FDate < ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(adjustDate.getTime()), new Timestamp(terminateDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep;
                ((BigDecimal[])result.get((Object)leaseInBillId))[2] = monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getRetrCalcAcumDepreAmtForFour(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date adjustDate = TerminateBillCalc.getMinMonthDate((Date)params.get("adjustDate"));
        Date terminateDate = TerminateBillCalc.getMinMonthDate((Date)params.get("terminateDate"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate >= ?");
        sql.append(" AND entry.FDate < ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(adjustDate.getTime()), new Timestamp(terminateDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep;
                ((BigDecimal[])result.get((Object)leaseInBillId))[2] = monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getRetrCalcAcumInterestExpeForOne(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date adjustDate = (Date)params.get("adjustDate");
        Date terminateDate = TerminateBillCalc.getMinMonthDate((Date)params.get("terminateDate"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate >= ?");
        sql.append(" AND entry.FDate < ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(adjustDate.getTime()), new Timestamp(terminateDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthIP;
                ((BigDecimal[])result.get((Object)leaseInBillId))[3] = monthIP = rs.getBigDecimal("monthIP") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthIP");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcInitAmountForOne(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        result.put("initialAsset", leaseInBill.getInitialAsset());
        result.put("initialLiability", leaseInBill.getInitialLiability());
        result.put("unrecognizedFinanceFee", leaseInBill.getUnrecognizedFinanceFee());
    }

    public static void getCalcInitAmountForTwo(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        boolean isDeductible = leaseInBill.isIsDeductible();
        result.put("initialAsset", leaseInBill.getFinanceInitialAsset());
        result.put("initialLiability", isDeductible ? leaseInBill.getFinanceReLiabilityWithoutTax() : leaseInBill.getFinanceReLiabilityWithTax());
        result.put("unrecognizedFinanceFee", leaseInBill.getFinanceReUnrFinExpenses());
    }

    public static void getCalcInitAmountForThree(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException, EASBizException {
        ArrayList<String> idList = new ArrayList<String>();
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        TerminateBillCalc.buildIdList(ctx, idList, leaseInBillId);
        FaLeaseInBillNewInfo oldLeaseBillInfo = FaLeaseInBillNewFactory.getRemoteInstance().getFaLeaseInBillNewInfo((IObjectPK)new ObjectUuidPK((String)idList.get(idList.size() - 1)));
        StringBuilder allSql = new StringBuilder();
        allSql.append(" SELECT SUM(FAdjustmentAsset) allFAdjustmentAsset, SUM(FAdjustmentLiability) allFAdjustmentLiability, SUM(FAdjustmentUnFncFee) allFAdjustmentUnFncFee");
        allSql.append(" FROM T_FA_FaLeaseInBillNew");
        allSql.append(" where fid in (");
        for (int i = 0; i < idList.size(); ++i) {
            if (i > 0) {
                allSql.append(",");
            }
            allSql.append("'").append(((String)idList.get(i)).toString()).append("'");
        }
        allSql.append(",");
        allSql.append("'").append(leaseInBillId).append("'");
        allSql.append(")");
        IRowSet allRs = SQLExecutorFactory.getRemoteInstance((String)allSql.toString()).executeSQL();
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FTerInitialAsset) allFTerInitialAsset, SUM(entry.FTerInitialLiability) allFTerInitialLiability, SUM(entry.FTerUFinanceFee) allFTerUFinanceFee");
        sql.append(" FROM T_FA_FaLeaseInBillNew bill");
        sql.append(" LEFT JOIN T_FA_FaTerminateBillentry entry ON bill.FId = entry.FLEASEINBILLID");
        sql.append(" where bill.fid in (");
        for (int i = 0; i < idList.size(); ++i) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append("'").append((String)idList.get(i)).append("'");
        }
        sql.append(")");
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        try {
            BigDecimal allFAdjustmentAsset = BigDecimal.ZERO;
            BigDecimal allFAdjustmentLiability = BigDecimal.ZERO;
            BigDecimal allFAdjustmentUnFncFee = BigDecimal.ZERO;
            BigDecimal allFTerInitialAsset = BigDecimal.ZERO;
            BigDecimal allFTerInitialLiability = BigDecimal.ZERO;
            BigDecimal allFTerUFinanceFee = BigDecimal.ZERO;
            while (allRs.next()) {
                allFAdjustmentAsset = allRs.getBigDecimal("allFAdjustmentAsset") == null ? BigDecimal.ZERO : allRs.getBigDecimal("allFAdjustmentAsset");
                allFAdjustmentLiability = allRs.getBigDecimal("allFAdjustmentLiability") == null ? BigDecimal.ZERO : allRs.getBigDecimal("allFAdjustmentLiability");
                allFAdjustmentUnFncFee = allRs.getBigDecimal("allFAdjustmentUnFncFee") == null ? BigDecimal.ZERO : allRs.getBigDecimal("allFAdjustmentUnFncFee");
            }
            while (rs.next()) {
                allFTerInitialAsset = rs.getBigDecimal("allFTerInitialAsset") == null ? BigDecimal.ZERO : rs.getBigDecimal("allFTerInitialAsset");
                allFTerInitialLiability = rs.getBigDecimal("allFTerInitialLiability") == null ? BigDecimal.ZERO : rs.getBigDecimal("allFTerInitialLiability");
                allFTerUFinanceFee = rs.getBigDecimal("allFTerUFinanceFee") == null ? BigDecimal.ZERO : rs.getBigDecimal("allFTerUFinanceFee");
            }
            if (oldLeaseBillInfo.isIsHistory() && oldLeaseBillInfo.getLeaseType() != FaLeaseTypeEnum.OPERATING_LEASE) {
                result.put("initialAsset", oldLeaseBillInfo.getFinanceInitialAsset().add(allFAdjustmentAsset).subtract(allFTerInitialAsset));
                result.put("initialLiability", oldLeaseBillInfo.getFinanceReLiabilityWithTax().add(allFAdjustmentLiability).subtract(allFTerInitialLiability));
                result.put("unrecognizedFinanceFee", oldLeaseBillInfo.getFinanceReUnrFinExpenses().add(allFAdjustmentUnFncFee).subtract(allFTerUFinanceFee));
            } else {
                result.put("initialAsset", oldLeaseBillInfo.getInitialAsset().add(allFAdjustmentAsset).subtract(allFTerInitialAsset));
                result.put("initialLiability", oldLeaseBillInfo.getInitialLiability().add(allFAdjustmentLiability).subtract(allFTerInitialLiability));
                result.put("unrecognizedFinanceFee", oldLeaseBillInfo.getUnrecognizedFinanceFee().add(allFAdjustmentUnFncFee).subtract(allFTerUFinanceFee));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcDecValueForOne(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date terminateDate = TerminateBillCalc.getMaxMonthDate((Date)params.get("terminateDate"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FInitialAssetDecValue) decValue");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = '" + leaseInBillId + "'");
        sql.append(" AND entry.FDate <= {d '" + sdf.format(terminateDate) + "'}");
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        try {
            while (rs.next()) {
                BigDecimal decValue = rs.getBigDecimal("decValue") == null ? BigDecimal.ZERO : rs.getBigDecimal("decValue");
                result.put("initialAssetDecValue", decValue);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcDecValueForTwo(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        ArrayList<String> idList = new ArrayList<String>();
        TerminateBillCalc.buildIdList(ctx, idList, leaseInBillId);
        Date billEndDate = TerminateBillCalc.getMaxMonthDate((Date)params.get("billEndDate"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FInitialAssetDecValue) decValue");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = '" + leaseInBillId + "'");
        sql.append(" AND entry.FDate <= {d '" + sdf.format(billEndDate) + "'}");
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        StringBuilder allSourcesql = new StringBuilder();
        allSourcesql.append(" SELECT SUM(FInitialAssetDecValue) allFInitialAssetDecValue");
        allSourcesql.append(" FROM T_FA_FaLeaseInBillNew");
        allSourcesql.append(" where fid in (");
        for (int i = 0; i < idList.size(); ++i) {
            if (i > 0) {
                allSourcesql.append(",");
            }
            allSourcesql.append("'").append((String)idList.get(i)).append("'");
        }
        allSourcesql.append(")");
        IRowSet rs1 = SQLExecutorFactory.getRemoteInstance((String)allSourcesql.toString()).executeSQL();
        StringBuilder relateTerminatesql = new StringBuilder();
        relateTerminatesql.append(" SELECT SUM(bill.FInitialAssetDecValue) allFInitialAssetDecValue");
        relateTerminatesql.append(" FROM T_FA_FaLeaseInBillNew bill");
        relateTerminatesql.append(" LEFT JOIN T_FA_FaTerminateBillentry entry ON bill.FId = entry.FCREATEDLEASEINBILLID");
        relateTerminatesql.append(" where bill.fid in (");
        for (int i = 0; i < idList.size(); ++i) {
            if (i > 0) {
                relateTerminatesql.append(",");
            }
            relateTerminatesql.append("'").append((String)idList.get(i)).append("'");
        }
        relateTerminatesql.append(")");
        IRowSet rs2 = SQLExecutorFactory.getRemoteInstance((String)relateTerminatesql.toString()).executeSQL();
        try {
            BigDecimal rs1AllFInitialAssetDecValue = BigDecimal.ZERO;
            BigDecimal rs2AllFInitialAssetDecValue = BigDecimal.ZERO;
            while (rs1.next()) {
                rs1AllFInitialAssetDecValue = rs1.getBigDecimal("allFInitialAssetDecValue") == null ? BigDecimal.ZERO : rs1.getBigDecimal("allFInitialAssetDecValue");
            }
            while (rs2.next()) {
                rs2AllFInitialAssetDecValue = rs2.getBigDecimal("allFInitialAssetDecValue") == null ? BigDecimal.ZERO : rs2.getBigDecimal("allFInitialAssetDecValue");
            }
            while (rs.next()) {
                BigDecimal decValue = rs.getBigDecimal("decValue") == null ? BigDecimal.ZERO : rs.getBigDecimal("decValue").add(rs1AllFInitialAssetDecValue).subtract(rs2AllFInitialAssetDecValue);
                result.put("initialAssetDecValue", decValue);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcDecValueForThree(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date billEndDate = TerminateBillCalc.getMaxMonthDate((Date)params.get("billEndDate"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FInitialAssetDecValue) decValue");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = '" + leaseInBillId + "'");
        sql.append(" AND entry.FDate <= {d '" + sdf.format(billEndDate) + "'}");
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        try {
            while (rs.next()) {
                BigDecimal decValue = rs.getBigDecimal("decValue") == null ? BigDecimal.ZERO : rs.getBigDecimal("decValue");
                result.put("initialAssetDecValue", decValue);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcDecValueForFour(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        ArrayList<String> idList = new ArrayList<String>();
        TerminateBillCalc.buildIdList(ctx, idList, leaseInBillId);
        Date terminateDate = TerminateBillCalc.getMaxMonthDate((Date)params.get("terminateDate"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FInitialAssetDecValue) decValue");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = '" + leaseInBillId + "'");
        sql.append(" AND entry.FDate <= {d '" + sdf.format(terminateDate) + "'}");
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        StringBuilder allSourcesql = new StringBuilder();
        allSourcesql.append(" SELECT SUM(FInitialAssetDecValue) allFInitialAssetDecValue");
        allSourcesql.append(" FROM T_FA_FaLeaseInBillNew");
        allSourcesql.append(" where fid in (");
        for (int i = 0; i < idList.size(); ++i) {
            if (i > 0) {
                allSourcesql.append(",");
            }
            allSourcesql.append("'").append((String)idList.get(i)).append("'");
        }
        allSourcesql.append(")");
        IRowSet rs1 = SQLExecutorFactory.getRemoteInstance((String)allSourcesql.toString()).executeSQL();
        StringBuilder relateTerminatesql = new StringBuilder();
        relateTerminatesql.append(" SELECT SUM(bill.FInitialAssetDecValue) allFInitialAssetDecValue");
        relateTerminatesql.append(" FROM T_FA_FaLeaseInBillNew bill");
        relateTerminatesql.append(" LEFT JOIN T_FA_FaTerminateBillentry entry ON bill.FId = entry.FCREATEDLEASEINBILLID");
        relateTerminatesql.append(" where bill.fid in (");
        for (int i = 0; i < idList.size(); ++i) {
            if (i > 0) {
                relateTerminatesql.append(",");
            }
            relateTerminatesql.append("'").append((String)idList.get(i)).append("'");
        }
        relateTerminatesql.append(")");
        IRowSet rs2 = SQLExecutorFactory.getRemoteInstance((String)relateTerminatesql.toString()).executeSQL();
        try {
            BigDecimal rs1AllFInitialAssetDecValue = BigDecimal.ZERO;
            BigDecimal rs2AllFInitialAssetDecValue = BigDecimal.ZERO;
            while (rs1.next()) {
                rs1AllFInitialAssetDecValue = rs1.getBigDecimal("allFInitialAssetDecValue") == null ? BigDecimal.ZERO : rs1.getBigDecimal("allFInitialAssetDecValue");
            }
            while (rs2.next()) {
                rs2AllFInitialAssetDecValue = rs2.getBigDecimal("allFInitialAssetDecValue") == null ? BigDecimal.ZERO : rs2.getBigDecimal("allFInitialAssetDecValue");
            }
            while (rs.next()) {
                BigDecimal decValue = rs.getBigDecimal("decValue") == null ? BigDecimal.ZERO : rs.getBigDecimal("decValue").add(rs1AllFInitialAssetDecValue).subtract(rs2AllFInitialAssetDecValue);
                result.put("initialAssetDecValue", decValue);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcDecValueForFive(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date terminateDate = TerminateBillCalc.getMaxMonthDate((Date)params.get("terminateDate"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FInitialAssetDecValue) decValue");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = '" + leaseInBillId + "'");
        sql.append(" AND entry.FDate <= {d '" + sdf.format(terminateDate) + "'}");
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        try {
            while (rs.next()) {
                BigDecimal decValue = rs.getBigDecimal("decValue") == null ? BigDecimal.ZERO : rs.getBigDecimal("decValue");
                result.put("initialAssetDecValue", decValue);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcDecValueForSix(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        ArrayList<String> idList = new ArrayList<String>();
        TerminateBillCalc.buildIdList(ctx, idList, leaseInBillId);
        Date adjustDate = TerminateBillCalc.getMinMonthDate((Date)params.get("adjustDate"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FInitialAssetDecValue) decValue");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = '" + leaseInBillId + "'");
        sql.append(" AND entry.FDate < {d '" + sdf.format(adjustDate) + "'}");
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        StringBuilder allSourcesql = new StringBuilder();
        allSourcesql.append(" SELECT SUM(FInitialAssetDecValue) allFInitialAssetDecValue");
        allSourcesql.append(" FROM T_FA_FaLeaseInBillNew");
        allSourcesql.append(" where fid in (");
        for (int i = 0; i < idList.size(); ++i) {
            if (i > 0) {
                allSourcesql.append(",");
            }
            allSourcesql.append("'").append((String)idList.get(i)).append("'");
        }
        allSourcesql.append(")");
        IRowSet rs1 = SQLExecutorFactory.getRemoteInstance((String)allSourcesql.toString()).executeSQL();
        StringBuilder relateTerminatesql = new StringBuilder();
        relateTerminatesql.append(" SELECT SUM(bill.FInitialAssetDecValue) allFInitialAssetDecValue");
        relateTerminatesql.append(" FROM T_FA_FaLeaseInBillNew bill");
        relateTerminatesql.append(" LEFT JOIN T_FA_FaTerminateBillentry entry ON bill.FId = entry.FCREATEDLEASEINBILLID");
        relateTerminatesql.append(" where bill.fid in (");
        for (int i = 0; i < idList.size(); ++i) {
            if (i > 0) {
                relateTerminatesql.append(",");
            }
            relateTerminatesql.append("'").append(((String)idList.get(i)).toString()).append("'");
        }
        relateTerminatesql.append(")");
        IRowSet rs2 = SQLExecutorFactory.getRemoteInstance((String)relateTerminatesql.toString()).executeSQL();
        try {
            BigDecimal rs1AllFInitialAssetDecValue = BigDecimal.ZERO;
            BigDecimal rs2AllFInitialAssetDecValue = BigDecimal.ZERO;
            while (rs1.next()) {
                rs1AllFInitialAssetDecValue = rs1.getBigDecimal("allFInitialAssetDecValue") == null ? BigDecimal.ZERO : rs1.getBigDecimal("allFInitialAssetDecValue");
            }
            while (rs2.next()) {
                rs2AllFInitialAssetDecValue = rs2.getBigDecimal("allFInitialAssetDecValue") == null ? BigDecimal.ZERO : rs2.getBigDecimal("allFInitialAssetDecValue");
            }
            while (rs.next()) {
                BigDecimal decValue = rs.getBigDecimal("decValue") == null ? BigDecimal.ZERO : rs.getBigDecimal("decValue").add(rs1AllFInitialAssetDecValue).subtract(rs1AllFInitialAssetDecValue);
                result.put("initialAssetDecValue", decValue);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcDecValueForSeven(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date adjustDate = TerminateBillCalc.getMinMonthDate((Date)params.get("adjustDate"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FInitialAssetDecValue) decValue");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = '" + leaseInBillId + "'");
        sql.append(" AND entry.FDate < {d '" + sdf.format(adjustDate) + "'}");
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        try {
            while (rs.next()) {
                BigDecimal decValue = rs.getBigDecimal("decValue") == null ? BigDecimal.ZERO : rs.getBigDecimal("decValue");
                result.put("initialAssetDecValue", decValue);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getRetrCalcDecValueForOne(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date adjustDate = (Date)params.get("adjustDate");
        Date terminateDate = TerminateBillCalc.getMinMonthDate((Date)params.get("terminateDate"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FInitialAssetDecValue) decValue");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = '" + leaseInBillId + "'");
        sql.append(" AND entry.FDate >= {d '" + sdf.format(adjustDate) + "'}");
        sql.append(" AND entry.FDate < {d '" + sdf.format(terminateDate) + "'}");
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        try {
            while (rs.next()) {
                BigDecimal decValue = rs.getBigDecimal("decValue") == null ? BigDecimal.ZERO : rs.getBigDecimal("decValue");
                result.put("retrospectDecValue", decValue);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getRetrCalcDecValueForTwo(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date adjustDate = TerminateBillCalc.getMaxMonthDate((Date)params.get("adjustDate"));
        Date terminateDate = TerminateBillCalc.getMaxMonthDate((Date)params.get("terminateDate"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FInitialAssetDecValue) decValue");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = '" + leaseInBillId + "'");
        sql.append(" AND entry.FDate >= {d '" + sdf.format(adjustDate) + "'}");
        sql.append(" AND entry.FDate <= {d '" + sdf.format(terminateDate) + "'}");
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        try {
            while (rs.next()) {
                BigDecimal decValue = rs.getBigDecimal("decValue") == null ? BigDecimal.ZERO : rs.getBigDecimal("decValue");
                result.put("retrospectDecValue", decValue);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAssetDisposalGainForOne(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
    }

    public static void getCalcAssetDisposalGainForTwo(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
    }

    public static void getCalcAssetDisposalGainForThree(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
    }

    public static void getCalcCalcAssetDisposalGainForFour(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
    }

    public static void getCalcUnrecognizedFinancingForOne(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date billEndDate = (Date)params.get("billEndDate");
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT entry.FEndUnCfmFncCost endCost");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = '" + leaseInBillId + "'");
        sql.append(" AND entry.FDate = {d '" + sdf.format(billEndDate) + "'}");
        IRowSet rs = ctx == null ? SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL() : DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                BigDecimal fee = rs.getBigDecimal("endCost") == null ? BigDecimal.ZERO : rs.getBigDecimal("endCost");
                result.put("unrecognizedFinanceFeeBalance", fee);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcUnrecognizedFinancingForTwo(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date adjustDate = (Date)params.get("adjustDate");
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT entry.FInitUnCfmFncCost initCost");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = '" + leaseInBillId + "'");
        sql.append(" AND entry.FDate = {d '" + sdf.format(adjustDate) + "'}");
        IRowSet rs = ctx == null ? SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL() : DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                BigDecimal fee = rs.getBigDecimal("initCost") == null ? BigDecimal.ZERO : rs.getBigDecimal("initCost");
                result.put("unrecognizedFinanceFeeBalance", fee);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcRemainingLeasePaymentsForOne(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date billEndDate = (Date)params.get("billEndDate");
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FEndLiabilityprincipal) endBalance");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = '" + leaseInBillId + "'");
        sql.append(" AND entry.FDate = {d '" + sdf.format(billEndDate) + "'}");
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        try {
            while (rs.next()) {
                BigDecimal endBalance = rs.getBigDecimal("endBalance") == null ? BigDecimal.ZERO : rs.getBigDecimal("endBalance");
                result.put("remainLeasePayment", endBalance);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcRemainingLeasePaymentsForTwo(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date adjustDate = (Date)params.get("adjustDate");
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FEndLiabilityprincipal) endBalance");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = '" + leaseInBillId + "'");
        sql.append(" AND entry.FDate = {d '" + sdf.format(adjustDate) + "'}");
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        try {
            while (rs.next()) {
                BigDecimal endBalance = rs.getBigDecimal("endBalance") == null ? BigDecimal.ZERO : rs.getBigDecimal("endBalance");
                result.put("remainLeasePayment", endBalance);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcRemainingLeasePaymentsForThree(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date terminateDate = (Date)params.get("terminateDate");
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FEndLiabilityprincipal) endBalance");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = '" + leaseInBillId + "'");
        sql.append(" AND entry.FDate = {d '" + sdf.format(terminateDate) + "'}");
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        try {
            while (rs.next()) {
                BigDecimal endBalance = rs.getBigDecimal("endBalance") == null ? BigDecimal.ZERO : rs.getBigDecimal("endBalance");
                result.put("remainLeasePayment", endBalance);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static String idSet2Str(Set<String> idSet) {
        StringBuffer ids = new StringBuffer();
        Iterator<String> it = idSet.iterator();
        while (it.hasNext()) {
            ids.append("'");
            ids.append(it.next());
            ids.append("'");
            if (!it.hasNext()) continue;
            ids.append(",");
        }
        return ids.toString();
    }

    public static Date getMinMonthDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMinimum(5));
        return calendar.getTime();
    }

    public static Date getMaxMonthDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    private static void buildIdList(Context ctx, List<String> idList, String leaseInBillId) throws BOSException {
        try {
            String id;
            String sqlString = "select FSOURCETYPE sourceType from T_FA_FaLeaseInBillNew where fid = '" + leaseInBillId + "'";
            IRowSet rs1 = ctx == null ? SQLExecutorFactory.getRemoteInstance((String)sqlString).executeSQL() : DbUtil.executeQuery((Context)ctx, (String)sqlString);
            int sourceType = 0;
            while (rs1.next()) {
                sourceType = rs1.getInt("sourceType");
            }
            if (sourceType == 0) {
                return;
            }
            if (sourceType == 1) {
                sqlString = "select FLeaseInBillID id from T_FA_FaTerminateBillentry where FCREATEDLEASEINBILLID = '" + leaseInBillId + "'";
                IRowSet rs2 = ctx == null ? SQLExecutorFactory.getRemoteInstance((String)sqlString).executeSQL() : DbUtil.executeQuery((Context)ctx, (String)sqlString);
                leaseInBillId = "";
                while (rs2.next()) {
                    id = rs2.getString("id");
                    idList.add(id);
                    leaseInBillId = id;
                    TerminateBillCalc.buildIdList(ctx, idList, leaseInBillId);
                }
            }
            if (sourceType == 2 || sourceType == 3) {
                sqlString = "SELECT FLeaseInBillOldID id FROM t_fa_faNLMChangeAssetItem where FLEASEINBILLNEWID = '" + leaseInBillId + "'";
                IRowSet rs3 = ctx == null ? SQLExecutorFactory.getRemoteInstance((String)sqlString).executeSQL() : DbUtil.executeQuery((Context)ctx, (String)sqlString);
                while (rs3.next()) {
                    id = rs3.getString("id");
                    idList.add(id);
                    leaseInBillId = id;
                    TerminateBillCalc.buildIdList(ctx, idList, leaseInBillId);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static void getCalcAllPlanTaxAmt(Context ctx, String idString, FaLeaseInBillNewInfo leaseInBill, SimpleDateFormat sdf, boolean isDeductible, BigDecimal ss, List<BigDecimal> list) throws BOSException, EASBizException {
        if (leaseInBill.getSourceType() == FaLeaseSourceTypeEnum.MANUALLY_ADDED) {
            list.add(ss);
            return;
        }
        if (FaTerminateBillEntryFactory.getLocalInstance(ctx).exists("where createdLeaseInBill.id = '" + idString + "'") || FaNLMChangeAssetItemFactory.getLocalInstance(ctx).exists("where leaseInBillNew.id = '" + idString + "'")) {
            Date tmpDate = null;
            String sql = "";
            if (leaseInBill.getSourceType() == FaLeaseSourceTypeEnum.TERMINATION_CREAT) {
                FaTerminateBillEntryCollection tmpBillEntryCollection = FaTerminateBillEntryFactory.getLocalInstance(ctx).getFaTerminateBillEntryCollection("where createdLeaseInBill.id = '" + idString + "'");
                FaTerminateBillInfo tmpBill = tmpBillEntryCollection.get(0).getBill();
                tmpBill = FaTerminateBillFactory.getLocalInstance(ctx).getFaTerminateBillInfo((IObjectPK)new ObjectUuidPK(tmpBill.getId()));
                tmpDate = tmpBill.getTerminateDate();
                sql = "select FLeaseInBillID id from T_FA_FaTerminateBillentry where FCREATEDLEASEINBILLID = '" + idString + "'";
            } else if (leaseInBill.getSourceType() == FaLeaseSourceTypeEnum.ASSET_CHANGE_CREAT || leaseInBill.getSourceType() == FaLeaseSourceTypeEnum.RETROACTIVE_ADJUSTMENT_CREAT) {
                tmpDate = FaNLMChangeAssetItemFactory.getLocalInstance(ctx).getFaNLMChangeAssetItemInfo("where leaseInBillNew.id = '" + idString + "'").getChangeDate();
                sql = "SELECT FLeaseInBillOldID id FROM t_fa_faNLMChangeAssetItem where FLEASEINBILLNEWID = '" + idString + "'";
            }
            IRowSet rs = ctx == null ? SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL() : DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                while (rs.next()) {
                    idString = rs.getString("id");
                }
                StringBuilder sql2 = new StringBuilder();
                sql2.append(" select sum(" + (isDeductible ? "entry.FPlanWithoutTaxAmt" : "entry.FPlanWithTaxAmt") + ") number FROM T_FA_FARENTSETTLEMENTBILL bill");
                sql2.append(" left join T_FA_FARENTSETTLEMENTBILLentry entry ON BILL.FID = ENTRY.FBILLID");
                sql2.append(" where bill.FLEASEINBILLID = '" + idString + "'");
                sql2.append(" and entry.fplanDate < {d '" + sdf.format(tmpDate) + "'}");
                IRowSet rs2 = ctx == null ? SQLExecutorFactory.getRemoteInstance((String)sql2.toString()).executeSQL() : DbUtil.executeQuery((Context)ctx, (String)sql2.toString());
                while (rs2 != null && rs2.next()) {
                    ss = ss.add(rs2.getBigDecimal("number") == null ? BigDecimal.ZERO : rs2.getBigDecimal("number"));
                }
                leaseInBill = FaLeaseInBillNewFactory.getLocalInstance(ctx).getFaLeaseInBillNewCollection("where id = '" + idString + "'").get(0);
                TerminateBillCalc.getCalcAllPlanTaxAmt(ctx, idString, leaseInBill, sdf, isDeductible, ss, list);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }
}

