/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.ScriptContext;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaAdapter;
import com.kingdee.eas.fi.gr.cslrpt.IRPTItemDataService;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemDataServiceFactory;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptRefractor;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.TablePorperts;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class IndexCalcProxy {
    private Context ServerCtx = null;
    private ICompanyOrgUnit comp;
    private IPermission permission;
    private String userID;
    Map orgs = null;
    private KDTable calcTable = null;
    private RptRefractor rptData = null;
    private RptSheetParamInfo rptSP = null;
    private IPeriod period = null;
    public static final int DT_CURRENT = 1;
    public static final int DT_START = 2;
    public static final int DT_END = 3;
    private IRPTItemDataService cslRptDataService = null;

    public IndexCalcProxy(Context ctx) throws BOSException {
        this.period = PeriodFactory.getLocalInstance((Context)ctx);
        this.comp = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        this.permission = PermissionFactory.getLocalInstance((Context)ctx);
        this.cslRptDataService = RPTItemDataServiceFactory.getLocalInstance((Context)ctx);
        this.calcTable = null;
        this.rptData = new RptRefractor(null);
        this.ServerCtx = ctx;
        this.userID = ctx.get((Object)"rptSchemeUserID") != null ? ctx.get((Object)"rptSchemeUserID").toString() : ctx.getCaller().toString();
        this.getUserComp();
    }

    public Map ref(String orgCode, String rptCode, String sheetName, String cellName) throws BOSException, EASBizException {
        return null;
    }

    public Map refm(String orgUnit, String tempType, String tempCode, int rptyear, int rptperiod, String sheetName, String cellName, String currency) throws BOSException, EASBizException {
        ReportInfo reportInfo;
        CurrencyInfo ci;
        if ((currency == null || currency.trim().length() == 0) && (ci = (reportInfo = this.rptData.getReportInfo()).getCurrency()) != null) {
            currency = ci.getNumber();
        }
        return this.getIndexData(currency, 0, 0, 0, 0);
    }

    public Map FOG_FA(String orgUnit, String assertCat, String assertNumber, String manageUnit, int year, int startPeriod, int endPeriod, String direction, String dataType) throws BOSException, EASBizException {
        this.checkFunctionPermission(orgUnit, "fa_card_view");
        if (startPeriod == 0) {
            startPeriod = Integer.valueOf(this.rptDate("MM"));
        }
        if (endPeriod == 0) {
            endPeriod = startPeriod;
        }
        return this.getIndexData(null, 0, startPeriod, 0, endPeriod);
    }

    public Map stdCur(String orgNumber) throws BOSException, EASBizException {
        return null;
    }

    private String rptDate(String dateFormat) throws BOSException, EASBizException {
        return this.getDateImp(dateFormat, 1);
    }

    public Map acct(String fiOrgUnit, String acctItem, String balType, int startYear, int startPeriod, int endYear, int endPeriod, String currency) throws BOSException, EASBizException {
        if (!this.orgs.containsKey(fiOrgUnit.toUpperCase())) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"NoCompanyPermission", (Locale)this.ServerCtx.getOriginLocale()));
        }
        this.getRptSP();
        ReportBaseInfo report = this.rptData.getReportBaseInfo();
        if (report != null) {
            if (startYear <= 0) {
                startYear = (this.rptSP == null || this.rptSP.getStartYear() == 0 ? report.getYear() : this.rptSP.getStartYear()) + startYear;
            }
            if (startPeriod <= 0 && (startPeriod = (this.rptSP == null || this.rptSP.getStartPeriod() == 0 ? report.getPeriod() : this.rptSP.getStartPeriod()) + startPeriod) <= 0) {
                startPeriod += PeriodUtils.getMaxPeriodNumber(null, (int)(--startYear), (String)report.getCompany().getId().toString());
            }
            if (endYear <= 0) {
                endYear = (this.rptSP == null || this.rptSP.getEndYear() == 0 ? report.getYear() : this.rptSP.getEndYear()) + endYear;
            }
            if (endPeriod <= 0 && (endPeriod = (this.rptSP == null || this.rptSP.getEndPeriod() == 0 ? report.getPeriod() : this.rptSP.getEndPeriod()) + endPeriod) <= 0) {
                --endYear;
                endPeriod += PeriodUtils.getMaxPeriodNumber(null, (int)startYear, (String)report.getCompany().getId().toString());
            }
            if (currency == null || currency.length() <= 0) {
                if (this.rptSP != null && this.rptSP.getCurrency() != null) {
                    currency = this.rptSP.getCurrency().getNumber().toString();
                } else if (report.getCurrency() != null) {
                    currency = report.getCurrency().getNumber().toString();
                }
            }
        }
        return this.getIndexData(currency, startYear, startPeriod, endYear, endPeriod);
    }

    private void getRptSP() {
        KDTable ct;
        if (this.calcTable == null) {
            return;
        }
        ScriptContext sc = (ScriptContext)this.calcTable.getScriptManager().getRelationsObject().getCurrentListener();
        KDTable kDTable = ct = sc == null ? null : sc.getTable();
        if (ct == null) {
            ct = this.calcTable;
        }
        this.rptSP = (RptSheetParamInfo)TablePorperts.getInstance(ct).get("SheetParam");
    }

    private void getUserComp() throws BOSException {
        ObjectUuidPK CtrlUnitPK = this.ServerCtx == null ? new ObjectUuidPK(SysContext.getSysContext().getCurrentCtrlUnit().getId()) : new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)this.ServerCtx).getId());
        Map fullOrgs = new HashMap();
        try {
            fullOrgs = this.permission.getOrgsOfIncludeSubCU((IObjectPK)CtrlUnitPK, (IObjectPK)new ObjectUuidPK(this.userID), OrgType.Company, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.rpt.client", "RptReportProcessUI"), (IMetaDataPK)new MetaDataPK("rpt_report_calculate"));
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.setFilter(new FilterInfo());
        Iterator iterator = ((HashMap)fullOrgs).keySet().iterator();
        StringBuffer mask = new StringBuffer();
        int index = 0;
        while (iterator.hasNext()) {
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)iterator.next().toString(), CompareType.EQUALS));
            if (index == 0) {
                mask.append("#" + index++);
                continue;
            }
            mask.append("or #" + index++);
        }
        evi.getFilter().setMaskString(mask.toString());
        ICompanyOrgUnit company = null;
        company = this.ServerCtx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)this.ServerCtx);
        CompanyOrgUnitCollection coms = company.getCompanyOrgUnitCollection(evi);
        this.orgs = new HashMap();
        this.orgs.put("", null);
        int n = coms.size();
        for (int i = 0; i < n; ++i) {
            this.orgs.put(coms.get(i).getNumber().toUpperCase(), new FunctionPermission(coms.get(i).getId()));
        }
    }

    public Map acctCash(String fiOrgUnit, String cashTypeEnumStr, String currency, int intYear, int startPeriod, int endPeriod, String FlowPorj) throws BOSException, EASBizException {
        ReportBaseInfo report = this.rptData.getReportBaseInfo();
        if (!this.orgs.containsKey(fiOrgUnit.toUpperCase())) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"NoCompanyPermission", (Locale)this.ServerCtx.getOriginLocale()));
        }
        this.getRptSP();
        if (report != null) {
            if (startPeriod == 0) {
                startPeriod = this.rptSP == null || this.rptSP.getStartPeriod() == 0 ? report.getPeriod() : this.rptSP.getStartPeriod();
            }
            if (endPeriod == 0) {
                endPeriod = this.rptSP == null || this.rptSP.getEndPeriod() == 0 ? report.getPeriod() : this.rptSP.getEndPeriod();
            }
            if (currency == null || currency.length() <= 0) {
                if (this.rptSP != null && this.rptSP.getCurrency() != null) {
                    currency = this.rptSP.getCurrency().getNumber().toString();
                } else if (report.getCurrency() != null) {
                    currency = report.getCurrency().getNumber().toString();
                }
            }
        }
        return this.getIndexData(currency, 0, startPeriod, 0, endPeriod);
    }

    public Map acctExt(String fiOrgUnit, String account, String opposingAccount, String userDefineFiter, String voucherGetType, String currency, String startDate, String endDate) throws BOSException, EASBizException {
        ReportBaseInfo report = this.rptData.getReportBaseInfo();
        if (!this.orgs.containsKey(fiOrgUnit.toUpperCase())) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"NoCompanyPermission", (Locale)this.ServerCtx.getOriginLocale()));
        }
        this.getRptSP();
        if (report != null) {
            if (currency == null || currency.length() <= 0) {
                if (this.rptSP != null && this.rptSP.getCurrency() != null) {
                    currency = this.rptSP.getCurrency().getNumber();
                } else if (report.getCurrency() != null) {
                    currency = report.getCurrency().getNumber();
                }
            }
            return this.getIndexData(currency, 0, 0, 0, 0);
        }
        return null;
    }

    public Map BgAcct(String orgNumber, String bgTypeNumber, String bgElementNumber, String strDimAndItemNum, String currencyNumber, int year, int period) throws EASBizException, BOSException {
        return null;
    }

    public Map BgAcct(String orgNumber, String bgTypeNumber, String bgElementNumber, String strDimAndItemNum, String currencyNumber, int beginYear, int beginPeriod, int endYear, int endPeriod) throws EASBizException, BOSException {
        ReportBaseInfo report = this.rptData.getReportBaseInfo();
        this.getRptSP();
        int currentYear = 0;
        short currentPeriod = 0;
        if (report != null) {
            currentYear = report.getYear();
            currentPeriod = report.getPeriod();
            if (beginYear <= 0) {
                int n = beginYear = this.rptSP.getStartYear() == 0 ? currentYear + beginYear : this.rptSP.getStartYear() + beginYear;
            }
            if (beginPeriod <= 0) {
                int n = beginPeriod = this.rptSP.getStartPeriod() == 0 ? currentPeriod + beginPeriod : this.rptSP.getStartPeriod() + beginPeriod;
            }
            if (endYear <= 0) {
                int n = endYear = this.rptSP.getEndYear() == 0 ? currentYear + endYear : this.rptSP.getEndYear() + endYear;
            }
            if (endPeriod <= 0) {
                int n = endPeriod = this.rptSP.getEndPeriod() == 0 ? currentPeriod + endPeriod : this.rptSP.getEndPeriod() + endPeriod;
            }
            if (currencyNumber == null || currencyNumber.length() <= 0) {
                if (this.rptSP.getCurrency() != null) {
                    currencyNumber = this.rptSP.getCurrency().getNumber().toString();
                } else if (report.getCurrency() != null) {
                    currencyNumber = report.getCurrency().getNumber().toString();
                }
            }
            return this.getIndexData(currencyNumber, beginYear, beginPeriod, endYear, endPeriod);
        }
        return null;
    }

    private Map getIndexData(String currencyNumber, int beginYear, int beginPeriod, int endYear, int endPeriod) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("START_YEAR", String.valueOf(beginYear));
        map.put("END_YEAR", String.valueOf(endYear));
        map.put("START_PERIOD", String.valueOf(beginPeriod));
        map.put("END_PERIOD", String.valueOf(endPeriod));
        map.put("CURRENCY", currencyNumber);
        return map;
    }

    public Map BgBalance(String orgNumber, String bgTypeNumber, String bgElementNumber, String strDimAndItemNum, String currencyNumber, int year, int period) throws EASBizException, BOSException {
        return null;
    }

    public Map BgBalance(String orgNumber, String bgTypeNumber, String bgElementNumber, String strDimAndItemNum, String currencyNumber, int beginYear, int beginPeriod, int endYear, int endPeriod) throws EASBizException, BOSException {
        ReportBaseInfo report = this.rptData.getReportBaseInfo();
        this.getRptSP();
        int currentYear = 0;
        short currentPeriod = 0;
        if (report != null) {
            currentYear = report.getYear();
            currentPeriod = report.getPeriod();
            if (beginYear <= 0) {
                int n = beginYear = this.rptSP.getStartYear() == 0 ? currentYear + beginYear : this.rptSP.getStartYear() + beginYear;
            }
            if (beginPeriod <= 0) {
                int n = beginPeriod = this.rptSP.getStartPeriod() == 0 ? currentPeriod + beginPeriod : this.rptSP.getStartPeriod() + beginPeriod;
            }
            if (endYear <= 0) {
                int n = endYear = this.rptSP.getEndYear() == 0 ? currentYear + endYear : this.rptSP.getEndYear() + endYear;
            }
            if (endPeriod <= 0) {
                int n = endPeriod = this.rptSP.getEndPeriod() == 0 ? currentPeriod + endPeriod : this.rptSP.getEndPeriod() + endPeriod;
            }
            if (currencyNumber == null || currencyNumber.length() <= 0) {
                if (this.rptSP.getCurrency() != null) {
                    currencyNumber = this.rptSP.getCurrency().getNumber().toString();
                } else if (report.getCurrency() != null) {
                    currencyNumber = report.getCurrency().getNumber().toString();
                }
            }
            return this.getIndexData(currencyNumber, beginYear, beginPeriod, endYear, endPeriod);
        }
        return null;
    }

    public Map AcctItem(String orgBoundNumber, String orgUnitNumber, String currencyNumber, String covertCurrencyNumber, String startItemNumber, String endItemNumber, String rptPeriodType, int yearOffset, int startPeriodOffset, int endPeriodOffset, String dataSource, String dataElement, String valueType, boolean isAdjust) throws BOSException {
        CslReportInfo cslRpt = this.rptData.getCslReportInfo();
        if (cslRpt != null) {
            int endPeriod;
            int endYear;
            int startPeriod;
            int startYear;
            int int_periodType = rptPeriodType == null || rptPeriodType.trim().equals("") ? cslRpt.getPeriodType().getValue() : FormulaAdapter.getRptPeriodType((String)rptPeriodType);
            int rptYear = cslRpt.getYear();
            int rptPeriod = cslRpt.getPeriod();
            int[] start = RPTDateUtil.getRptYearAndPeriod((int)rptYear, (int)rptPeriod, (int)int_periodType, (int)yearOffset, (int)startPeriodOffset);
            int[] end = RPTDateUtil.getRptYearAndPeriod((int)rptYear, (int)rptPeriod, (int)int_periodType, (int)yearOffset, (int)endPeriodOffset);
            if (start == null) {
                startYear = rptYear;
                startPeriod = rptPeriod;
            } else {
                startYear = start[0];
                startPeriod = start[1];
            }
            if (end == null) {
                endYear = rptYear;
                endPeriod = rptPeriod;
            } else {
                endYear = end[0];
                endPeriod = end[1];
            }
            return this.getIndexData(null, startYear, startPeriod, endYear, endPeriod);
        }
        return null;
    }

    public BigDecimal acctAC(String fiOrgUnit, String destOrgUnit, String acctItem, String balanceType, int startYear, int startPeriod, int endYear, int endPeriod, String currency) throws BOSException, EASBizException {
        int periodType;
        short rptPeriod;
        int rptYear;
        int[] start;
        ReportBaseInfo cslRpt = this.rptData.getReportBaseInfo();
        if (StringUtils.isEmpty((String)fiOrgUnit)) {
            fiOrgUnit = cslRpt.getCompany().getNumber();
        }
        if ((start = RPTDateUtil.getRptYearAndPeriod((int)(rptYear = cslRpt.getYear()), (int)(rptPeriod = cslRpt.getPeriod()), (int)(periodType = cslRpt.getPeriodType().getValue()), (int)startYear, (int)startPeriod)) == null) {
            startYear = rptYear;
            startPeriod = rptPeriod;
        } else {
            startYear = start[0];
            startPeriod = start[1];
        }
        int[] end = RPTDateUtil.getRptYearAndPeriod((int)rptYear, (int)rptPeriod, (int)periodType, (int)endYear, (int)endPeriod);
        if (end == null) {
            endYear = rptYear;
            endPeriod = rptPeriod;
        } else {
            endYear = end[0];
            endPeriod = end[1];
        }
        return this.cslRptDataService.acctAC(fiOrgUnit, destOrgUnit, acctItem, balanceType, startYear, startPeriod, endYear, endPeriod, currency, false);
    }

    public Map AdjustData(String orgBoundNumber, String orgUnitNumber, String currencyNumber, String startItemNumber, String endItemNumber, String rptPeriodType, int yearOffset, int startPeriodOffset, int endPeriodOffset, String dataSource, String dataElement, String valueType, String dc, boolean isIncldUnAudit) throws BOSException {
        ReportBaseInfo cslRpt = this.rptData.getReportBaseInfo();
        if (cslRpt != null) {
            int endPeriod;
            int endYear;
            int startPeriod;
            int startYear;
            if (currencyNumber == null || currencyNumber.trim().equals("")) {
                currencyNumber = cslRpt.getCurrency().getNumber();
            }
            int int_periodType = rptPeriodType == null || rptPeriodType.trim().equals("") ? cslRpt.getPeriodType().getValue() : FormulaAdapter.getRptPeriodType((String)rptPeriodType);
            int rptYear = cslRpt.getYear();
            int rptPeriod = cslRpt.getPeriod();
            int[] start = RPTDateUtil.getRptYearAndPeriod((int)rptYear, (int)rptPeriod, (int)int_periodType, (int)yearOffset, (int)startPeriodOffset);
            int[] end = RPTDateUtil.getRptYearAndPeriod((int)rptYear, (int)rptPeriod, (int)int_periodType, (int)yearOffset, (int)endPeriodOffset);
            if (start == null) {
                startYear = rptYear;
                startPeriod = rptPeriod;
            } else {
                startYear = start[0];
                startPeriod = start[1];
            }
            if (end == null) {
                endYear = rptYear;
                endPeriod = rptPeriod;
            } else {
                endYear = end[0];
                endPeriod = end[1];
            }
            return this.getIndexData(currencyNumber, startYear, startPeriod, endYear, endPeriod);
        }
        return null;
    }

    public Map ElimData(String orgBoundNumber, String orgUnitNumber, String currencyNumber, String startItemNumber, String endItemNumber, String rptPeriodType, int yearOffset, int startPeriodOffset, int endPeriodOffset, String dataElement, String valueType, String dc, boolean isIncldUnAudit) throws BOSException {
        ReportBaseInfo cslRpt = this.rptData.getReportBaseInfo();
        if (cslRpt != null) {
            int endPeriod;
            int endYear;
            int startPeriod;
            int startYear;
            if (currencyNumber == null || currencyNumber.trim().equals("")) {
                currencyNumber = cslRpt.getCurrency().getNumber();
            }
            int int_periodType = rptPeriodType == null || rptPeriodType.trim().equals("") ? cslRpt.getPeriodType().getValue() : FormulaAdapter.getRptPeriodType((String)rptPeriodType);
            int rptYear = cslRpt.getYear();
            int rptPeriod = cslRpt.getPeriod();
            int[] start = RPTDateUtil.getRptYearAndPeriod((int)rptYear, (int)rptPeriod, (int)int_periodType, (int)yearOffset, (int)startPeriodOffset);
            int[] end = RPTDateUtil.getRptYearAndPeriod((int)rptYear, (int)rptPeriod, (int)int_periodType, (int)yearOffset, (int)endPeriodOffset);
            if (start == null) {
                startYear = rptYear;
                startPeriod = rptPeriod;
            } else {
                startYear = start[0];
                startPeriod = start[1];
            }
            if (end == null) {
                endYear = rptYear;
                endPeriod = rptPeriod;
            } else {
                endYear = end[0];
                endPeriod = end[1];
            }
            return this.getIndexData(currencyNumber, startYear, startPeriod, endYear, endPeriod);
        }
        return null;
    }

    private String getDateImp(String dateFormat, int type) throws BOSException, EASBizException {
        Date rptDate = null;
        ReportBaseInfo ri = this.rptData.getReportBaseInfo();
        TemplateInfo ti = this.rptData.getTemplateInfo();
        if (ri != null) {
            switch (type) {
                case 2: {
                    rptDate = ri.getStartDate();
                    break;
                }
                default: {
                    rptDate = ri.getEndDate();
                    break;
                }
            }
        } else if (ti != null) {
            rptDate = ti.getStartDate();
        } else {
            return null;
        }
        int year = 0;
        int month = 0;
        if (ri != null && this.rptSP != null) {
            year = this.rptSP.getEndYear();
            month = this.rptSP.getEndPeriod();
            if (year == 0) {
                year = ri.getYear();
            }
            if (month == 0) {
                month = ri.getPeriod();
            }
        }
        if (dateFormat.equalsIgnoreCase("YYYY")) {
            if (ri != null && this.rptSP != null) {
                return String.valueOf(year);
            }
            Timestamp time = new Timestamp(rptDate.getTime());
            String strdate = time.toString();
            return strdate.substring(0, 4);
        }
        if (dateFormat.equalsIgnoreCase("MM")) {
            if (ri != null && this.rptSP != null) {
                return String.valueOf(month);
            }
            Timestamp time = new Timestamp(rptDate.getTime());
            String strdate = time.toString();
            return strdate.substring(0, 2);
        }
        if (dateFormat.equalsIgnoreCase("YYYY-MM")) {
            if (ri != null && this.rptSP != null) {
                return String.valueOf(year) + "-" + String.valueOf(month);
            }
            Timestamp time = new Timestamp(rptDate.getTime());
            String strdate = time.toString();
            return strdate.substring(0, 7);
        }
        if (ri != null && this.rptSP != null && ri.getPeriodType() != RptPeriodTypeEnum.DAILY && ri.getPeriodType() != RptPeriodTypeEnum.WEEKLY) {
            if (ri.getSourceType() == RptSrcTypeEnum.SUM || ri.getSourceType() == RptSrcTypeEnum.CONSOLIDATION || ri.getSourceType() == RptSrcTypeEnum.MANUSCRIPT) {
                rptDate = ri.getEndDate();
            } else {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("AccountPeriodType"));
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.comp.getValue((IObjectPK)new ObjectUuidPK(ri.getCompany().getId()), selector);
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("PeriodYear", (Object)new Integer(year)));
                filter.getFilterItems().add(new FilterItemInfo("PeriodNumber", (Object)new Integer(month)));
                filter.getFilterItems().add(new FilterItemInfo("PeriodType", (Object)company.getAccountPeriodType().getId().toString()));
                evi.setFilter(filter);
                PeriodCollection periods = this.period.getPeriodCollection(evi);
                if (periods.size() > 0) {
                    rptDate = periods.get(0).getEndDate();
                }
            }
        }
        Timestamp time = new Timestamp(rptDate.getTime());
        String strdate = time.toString();
        return strdate.substring(0, 10);
    }

    public Map cash(String companyNum, String sDataSource, String acctTableNum, String accountNum, String bankAcctNum, String currencyNum, String sBeginDate, String sEndDate, String sDataType) throws BOSException, EASBizException {
        return null;
    }

    public Map inAcct(String companyNumber, String sSubsidiaryType, String sInnerAcctType, String innerAcctNumber, String currencyNumber, String sCapitalType, String sBeginDay, String sEndDay, String sInAcctDataType) throws BOSException, EASBizException {
        return null;
    }

    public Map rptIndex(String fiOrgUnit, String indexNumber, int startYear, int startPeriod, int endYear, int endPeriod, String currency, int rptSrcType) throws BOSException, EASBizException {
        if (!this.orgs.containsKey(fiOrgUnit.toUpperCase())) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"NoCompanyPermission", (Locale)this.ServerCtx.getOriginLocale()));
        }
        if (indexNumber == null || indexNumber.trim().length() == 0) {
            return null;
        }
        this.getRptSP();
        ReportBaseInfo report = this.rptData.getReportBaseInfo();
        if (report != null) {
            if (startYear <= 0) {
                startYear = (this.rptSP == null || this.rptSP.getStartYear() == 0 ? report.getYear() : this.rptSP.getStartYear()) + startYear;
            }
            if (startPeriod <= 0 && (startPeriod = (this.rptSP == null || this.rptSP.getStartPeriod() == 0 ? report.getPeriod() : this.rptSP.getStartPeriod()) + startPeriod) <= 0) {
                startPeriod += PeriodUtils.getMaxPeriodNumber(null, (int)(--startYear), (String)report.getCompany().getId().toString());
            }
            if (endYear <= 0) {
                endYear = (this.rptSP == null || this.rptSP.getEndYear() == 0 ? report.getYear() : this.rptSP.getEndYear()) + endYear;
            }
            if (endPeriod <= 0 && (endPeriod = (this.rptSP == null || this.rptSP.getEndPeriod() == 0 ? report.getPeriod() : this.rptSP.getEndPeriod()) + endPeriod) <= 0) {
                --endYear;
                endPeriod += PeriodUtils.getMaxPeriodNumber(null, (int)startYear, (String)report.getCompany().getId().toString());
            }
            if (currency == null || currency.length() <= 0) {
                if (this.rptSP != null && this.rptSP.getCurrency() != null) {
                    currency = this.rptSP.getCurrency().getNumber().toString();
                } else if (report.getCurrency() != null) {
                    currency = report.getCurrency().getNumber().toString();
                }
            }
            return this.getIndexData(currency, startYear, startPeriod, endYear, endPeriod);
        }
        return null;
    }

    private boolean checkFunctionPermission(String companyNumber, String permissionItem) throws BOSException, EASBizException {
        FunctionPermission p = (FunctionPermission)this.orgs.get(companyNumber.toUpperCase());
        if (p != null) {
            Boolean perm = (Boolean)p.permissionItems.get(permissionItem);
            if (perm != null) {
                return perm;
            }
            try {
                this.permission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(this.userID), p.companyId, permissionItem);
                p.permissionItems.put(permissionItem, Boolean.TRUE);
                return true;
            }
            catch (EASBizException e) {
                p.permissionItems.put(permissionItem, Boolean.FALSE);
                return false;
            }
        }
        return false;
    }

    public Map getCompany() throws BOSException {
        return null;
    }

    public Map keyWord(String name) {
        return null;
    }

    public Map rptName() {
        return null;
    }

    public Map getCurrency() throws BOSException, EASBizException {
        return null;
    }

    public Map getCurrentDate(String pattern) throws BOSException, EASBizException {
        return null;
    }

    public Map getCurrentUser() {
        return null;
    }

    public Map getOrgName(String orgType) throws BOSException, EASBizException {
        return null;
    }

    public Map getOrgTree() throws BOSException, EASBizException {
        return null;
    }

    public Map getEndDate(String pattern) throws BOSException, EASBizException {
        return null;
    }

    public Map getStartDate(String pattern) throws BOSException, EASBizException {
        return null;
    }

    private class FunctionPermission {
        IObjectPK companyId = null;
        Map permissionItems = new HashMap(2);

        FunctionPermission(BOSUuid id) {
            this.companyId = new ObjectUuidPK(id);
        }
    }
}

