/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt;

import com.kingdee.eas.fi.rpt.util.IObjectIterator;
import com.kingdee.eas.fi.rpt.util.UserObjectTrans;
import java.awt.Rectangle;
import java.io.Serializable;

public final class Rect
implements Serializable {
    public int x1;
    public int y1;
    public int x2;
    public int y2;

    public Rect() {
        this(-1, -1, -1, -1);
    }

    public Rect(Rect mirror) {
        if (mirror == null) {
            this.y1 = -1;
            this.y2 = -1;
            this.x1 = -1;
            this.x2 = -1;
        } else {
            this.y1 = mirror.y1;
            this.y2 = mirror.y2;
            this.x1 = mirror.x1;
            this.x2 = mirror.x2;
        }
    }

    public Rect(int left, int top, int right, int bottom) {
        this.y1 = top;
        this.y2 = bottom;
        this.x1 = left;
        this.x2 = right;
    }

    public Rect normalize() {
        int tp;
        if (this.x1 > this.x2) {
            tp = this.x1;
            this.x1 = this.x2;
            this.x2 = tp;
        }
        if (this.y1 > this.y2) {
            tp = this.y1;
            this.y1 = this.y2;
            this.y2 = tp;
        }
        return this;
    }

    public Rect format(int min_x, int min_y, int max_x, int max_y) {
        int xx1 = this.x1;
        int xx2 = this.x2;
        int yy1 = this.y1;
        int yy2 = this.y2;
        if (xx1 == -1) {
            int n = xx1 = this.x2 == -1 ? min_x : this.x2;
        }
        if (xx2 == -1) {
            int n = xx2 = this.x1 == -1 ? max_x : this.x1;
        }
        if (yy1 == -1) {
            int n = yy1 = this.y2 == -1 ? min_y : this.y2;
        }
        if (yy2 == -1) {
            yy2 = this.y1 == -1 ? max_y : this.y1;
        }
        this.x1 = xx1;
        this.x2 = xx2;
        this.y1 = yy1;
        this.y2 = yy2;
        this.normalize();
        this.x1 = Rect.setLimit(this.x1, min_x, max_x);
        this.x2 = Rect.setLimit(this.x2, min_x, max_x);
        this.y1 = Rect.setLimit(this.y1, min_y, max_y);
        this.y2 = Rect.setLimit(this.y2, min_y, max_y);
        return this;
    }

    private static int setLimit(int target, int min, int max) {
        if (target < min) {
            target = min;
        } else if (target > max) {
            target = max;
        }
        return target;
    }

    public Rectangle toRectangle() {
        this.normalize();
        return new Rectangle(this.x1, this.y1, this.x2 - this.x1 + 1, this.y2 - this.y1 + 1);
    }

    public boolean isValid() {
        return this.x1 != -1 || this.x2 != -1 || this.y1 != -1 || this.y2 != -1;
    }

    public int getXBase() {
        if (this.x1 < 0) {
            return this.x2 < 0 ? 0 : this.x2;
        }
        return this.x1;
    }

    public int getYBase() {
        if (this.y1 < 0) {
            return this.y2 < 0 ? 0 : this.y2;
        }
        return this.y1;
    }

    public void fromSerialString(String s) throws Exception {
        IObjectIterator it = UserObjectTrans.createObjectIterator((String)s);
        if (it.hasNext()) {
            this.x1 = (Integer)it.nextObject();
        }
        if (it.hasNext()) {
            this.y1 = (Integer)it.nextObject();
        }
        if (it.hasNext()) {
            this.x2 = (Integer)it.nextObject();
        }
        if (it.hasNext()) {
            this.y2 = (Integer)it.nextObject();
        }
    }

    public String toSerialString() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(UserObjectTrans.getSerialString((Object)new Integer(this.x1)));
        sb.append(UserObjectTrans.getSerialString((Object)new Integer(this.y1)));
        sb.append(UserObjectTrans.getSerialString((Object)new Integer(this.x2)));
        sb.append(UserObjectTrans.getSerialString((Object)new Integer(this.y2)));
        return sb.toString();
    }
}

