/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.bos.ctrl.kdf.util.file.ZipKDF;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.IItemSourceType;
import com.kingdee.eas.fi.rpt.AbstractReportBaseInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import java.io.IOException;
import java.io.Serializable;

public class ReportBaseInfo
extends AbstractReportBaseInfo
implements Serializable,
IItemSourceType {
    private Book book = null;

    public ReportBaseInfo() {
    }

    protected ReportBaseInfo(String pkField) {
        super(pkField);
    }

    public Object clone() {
        ReportBaseInfo obj = (ReportBaseInfo)super.clone();
        try {
            if (this.book != null) {
                obj.clearBook();
            }
        }
        catch (Exception e) {
            try {
                obj.clearBook();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return obj;
    }

    public Book getCurBook() {
        return this.book;
    }

    public void setCurBook(Book book) {
        this.book = book;
    }

    @Override
    public byte[] getZipData() {
        return super.getData();
    }

    public void setCompany(CompanyOrgUnitInfo item) {
        this.put("company", item.castToFullOrgUnitInfo());
    }

    @Override
    public void setZipData(byte[] data) {
        super.setData(data);
    }

    @Override
    public KDF getKDF() throws IOException, KDFException {
        if (super.getData() == null) {
            return null;
        }
        return ZipKDF.unpack((byte[])super.getData());
    }

    @Override
    public void setKDF(KDF kdf) throws IOException {
        super.setData(ZipKDF.pack((KDF)kdf));
    }

    @Override
    public Book getBook() throws Exception {
        if (this.book != null) {
            return this.book;
        }
        return IOHelper.unpackBook(super.getData(), "rpt_trans");
    }

    public Book getCatchBook() throws Exception {
        if (this.book == null) {
            this.book = IOHelper.unpackBook(super.getData(), "rpt_trans");
        }
        return this.book;
    }

    public void clearBook() throws Exception {
        this.book = null;
    }

    @Override
    public void setBook(Book book) throws IOException {
        this.book = book;
        super.setData(IOHelper.packBook(book));
    }

    @Override
    public void setData(byte[] item) {
        super.setData(item);
        this.book = null;
    }

    public String toSelfString() {
        if (this.getPeriodType() == RptPeriodTypeEnum.DAILY) {
            return this.getStartDate().toString();
        }
        return this.getYear() + "-" + this.getPeriod();
    }

    public int getItemSourceType() {
        RptSrcTypeEnum sourceType = this.getSourceType();
        if (sourceType == null) {
            return -1;
        }
        return sourceType.getValue();
    }

    public BOSUuid getItemSourceId() {
        return this.getId();
    }
}

