/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.rpt.EmptyRptCellDelegate;
import com.kingdee.eas.fi.rpt.IRptCellDelegate;
import com.kingdee.eas.fi.rpt.PostilCollection;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class RptCell
implements Serializable {
    private static final long serialVersionUID = 20040415140217L;
    private static Class CLIENTCELLCLASS;
    private static Class RPTCELLCLASS;
    private transient IRptCellDelegate delegate = null;
    private transient ICell cell;
    private ItemFormula itemFormula;
    private Map extObj = new HashMap();

    public static RptCell getRptCellWithoutUserObject(ICell cell) {
        RptCell res = RptCell.getRptCell(cell);
        if (res != null) {
            return res;
        }
        res = new RptCell(cell);
        return res;
    }

    public void putExtObj(Object key, Object value) {
        this.extObj.put(key, value);
    }

    public Object getExtObj(Object key) {
        return this.extObj.get(key);
    }

    public static RptCell getRptCell(ICell kdtCell) {
        RptCell res;
        RptCell rptCell = res = kdtCell == null ? null : RptCell.getRptCell(kdtCell.getUserObject());
        if (res != null) {
            res.setCell(kdtCell);
        }
        return res;
    }

    public static RptCell getRptCell(Object objCell) {
        if (objCell == null) {
            return null;
        }
        Class<?> oc = objCell.getClass();
        if (RPTCELLCLASS == oc) {
            RptCell res = (RptCell)objCell;
            res.createRptCellDelegate();
            return res;
        }
        if (CLIENTCELLCLASS != null) {
            com.kingdee.eas.fi.rpt.client.RptCell oldCell = (com.kingdee.eas.fi.rpt.client.RptCell)objCell;
            RptCell newCell = new RptCell(oldCell.getCell());
            newCell.setComment(oldCell.getComment());
            newCell.setItemFormula(oldCell.getItemFormula());
            newCell.setSheet(oldCell.getSheet());
            return newCell;
        }
        return null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.itemFormula);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object o = in.readObject();
        if (o == null) {
            this.itemFormula = null;
        } else if (o instanceof ItemFormula) {
            this.itemFormula = (ItemFormula)o;
            this.itemFormula.setCell(this);
        } else {
            throw new ClassNotFoundException();
        }
        this.createRptCellDelegate();
        this.delegate.setItemFormula(this.itemFormula);
    }

    protected IRptCellDelegate createRptCellDelegate() {
        if (this.delegate != null) {
            return this.delegate;
        }
        if (CLIENTCELLCLASS != null) {
            try {
                this.delegate = (IRptCellDelegate)CLIENTCELLCLASS.newInstance();
            }
            catch (Exception e) {
                this.delegate = new EmptyRptCellDelegate();
            }
        } else {
            this.delegate = new EmptyRptCellDelegate();
        }
        return this.delegate;
    }

    public RptCell(ICell cl) {
        this.createRptCellDelegate();
        if (this.delegate != null) {
            this.cell = this.delegate.setCell(cl);
        }
    }

    public RptCell() {
        this.createRptCellDelegate();
    }

    public Object getValue() {
        return this.cell == null ? null : this.cell.getValue();
    }

    public Object setValue(Object val) {
        if (this.cell != null) {
            this.cell.setValue(val);
        }
        return val;
    }

    public void addComment(Object cmt) {
        this.delegate.addComment(cmt);
    }

    public void removeComments() {
        this.delegate.removeComments();
    }

    public boolean hasComment() {
        return this.delegate.hasComment();
    }

    public void getComments(PostilCollection comments) {
        this.delegate.getComments(comments);
    }

    public String getCommentString() {
        return this.delegate.getCommentString();
    }

    public void editComment(boolean isEditable) {
        this.delegate.editComment(isEditable);
    }

    public void setSheet(Object sht) {
        this.delegate.setSheet(sht);
    }

    public Object getSheet() {
        return this.delegate.getSheet();
    }

    public ItemFormula setItemFormula(String line) {
        this.itemFormula = this.delegate.setItemFormula(line);
        if (this.itemFormula != null) {
            this.itemFormula.setCell(this);
        }
        return this.itemFormula;
    }

    public void applyCellRender() {
        if (this.itemFormula != null) {
            this.delegate.applyCellRender();
        }
    }

    public String getItemFormulaLine() {
        return this.itemFormula == null ? null : this.itemFormula.getFormula();
    }

    public ICell getCell() {
        return this.cell;
    }

    public void setCell(ICell cl) {
        this.cell = this.delegate.setCell(cl);
    }

    public Object getComment() {
        return this.delegate.getComment();
    }

    public void setComment(Object comment) {
        this.delegate.setComment(comment);
    }

    public ItemFormula getItemFormula() {
        return this.itemFormula;
    }

    public void setItemFormula(ItemFormula iFormula) {
        this.itemFormula = this.delegate.setItemFormula(iFormula);
        if (this.itemFormula != null) {
            this.itemFormula.setCell(this);
            this.delegate.applyCellRender();
        }
    }

    public void setFormula(String expr) {
        this.cell.setExpressions(expr);
    }

    static {
        try {
            RPTCELLCLASS = RptCell.class;
            CLIENTCELLCLASS = RPTCELLCLASS.getClassLoader().loadClass("com.kingdee.eas.fi.rpt.client.RptCellDelegate");
        }
        catch (Exception e) {
            CLIENTCELLCLASS = null;
        }
    }
}

