/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt;

import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.rpt.CmtComparator;
import com.kingdee.eas.fi.rpt.CommentConstants;
import com.kingdee.eas.fi.rpt.PostilInfo;
import com.kingdee.eas.fi.rpt.PostilTypeEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.DateTimeUtils;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;

public class RptComment
implements Cloneable {
    protected boolean isInited = false;
    protected RptComment mirror = null;
    protected int status = 1;
    protected static int tipLength = 100;
    public String content = null;
    public UserInfo author = null;
    public Timestamp date = null;
    public UserInfo updateUser = null;
    public Timestamp createtime = null;
    protected PostilInfo source;

    protected Object clone() {
        return this.getCommentCopy();
    }

    public RptComment() {
        this.source = null;
        this.mirror = this;
    }

    public RptComment(PostilInfo source) throws Exception {
        if (source == null || source.getStatus() == 3) {
            throw new Exception();
        }
        this.status = 4;
        this.source = source;
        this.mirror = this;
        this.content = new String(source.getDescription());
    }

    protected void initialize() {
        if (this.isInited) {
            return;
        }
        if (this.source != null) {
            this.content = new String(this.source.getDescription());
            this.author = this.source.getCreator();
            if (this.source.getLastUpdateTime() != null) {
                this.date = (Timestamp)this.source.getLastUpdateTime().clone();
            }
            this.status = 4;
            if (this.source.getCreateTime() != null) {
                this.createtime = (Timestamp)this.source.getCreateTime().clone();
            }
            this.updateUser = this.source.getLastUpdateUser();
        } else {
            this.content = ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"rptcomment-default", (Locale)SysContext.getSysContext().getLocale());
            this.author = null;
            this.date = null;
            this.status = 1;
            this.updateUser = null;
            this.createtime = null;
        }
        if (this.author == null) {
            this.author = (UserInfo)SysContext.getSysContext().getCurrentUser();
        }
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        if (this.date == null) {
            this.date = currentTime;
        }
        if (this.updateUser == null) {
            this.updateUser = (UserInfo)SysContext.getSysContext().getCurrentUser();
        }
        if (this.createtime == null) {
            this.createtime = currentTime;
        }
        this.isInited = true;
    }

    public PostilInfo getTrueSource() {
        if (this.source == null) {
            this.source = new PostilInfo();
            this.initialize(this.source);
        }
        this.source.setStatus(CommentConstants.getRptStatus(this.status));
        this.source.setDescription(this.getContent());
        this.source.setLastUpdateTime(this.date);
        if (this.source.getCreateTime() == null) {
            this.source.setCreateTime(this.createtime);
        }
        return this.source;
    }

    public PostilInfo getSource() {
        if (this.source == null) {
            this.source = new PostilInfo();
            this.initialize(this.source);
        }
        if (this.status == 1) {
            return null;
        }
        this.source.setStatus(CommentConstants.getRptStatus(this.status));
        this.source.setDescription(this.getContent());
        this.source.setLastUpdateTime(this.date);
        return this.source;
    }

    protected void initialize(PostilInfo info) {
        info.setCreator(this.author);
        info.setLastUpdateTime(this.date);
        info.setDescription(this.content);
        info.setPostilType(PostilTypeEnum.REPORT);
        info.setStatus(CommentConstants.getRptStatus(this.status));
        info.setLastUpdateUser(this.updateUser);
    }

    public void setSource(PostilInfo source) {
        this.source = source;
    }

    public RptComment getCommentCopy() {
        this.initialize();
        RptComment res = new RptComment();
        res.mirror = this;
        res.source = this.source == null ? null : (PostilInfo)this.source.clone();
        res.author = this.author;
        res.date = this.date;
        res.createtime = this.createtime;
        res.updateUser = this.updateUser;
        res.status = this.status;
        res.isInited = true;
        res.content = this.content == null ? "" : new String(this.content);
        return res;
    }

    public RptComment getSmartCopy() {
        if (this.mirror != null) {
            this.status = CommentConstants.getStatus(this.mirror.status, this.status);
            this.mirror = null;
        } else {
            this.status = this.status == 2 || this.content == null ? 1 : 0;
        }
        return this.status == 1 ? null : this;
    }

    public String getTipString(int length) {
        this.initialize();
        String res = "";
        Locale lc = SysContext.getSysContext().getLocale();
        int len = 0;
        String tmp = null;
        if (this.author != null) {
            if (lc != null) {
                tmp = this.author.getName(lc);
            }
            if (tmp == null) {
                tmp = this.author.getName();
            }
            if (tmp != null && (len += (tmp = tmp.trim()).length()) < length - 1) {
                res = res + tmp + ", ";
            }
        }
        if (this.date != null) {
            DateFormat df = DateFormat.getDateTimeInstance(1, 3, lc);
            if (df != null) {
                tmp = df.format(this.date);
            }
            if (tmp != null && (len += tmp.length()) < length - 1) {
                res = res + tmp + ", ";
            }
        }
        if (this.content != null) {
            tmp = this.content.trim();
            if ((len = length - len) < 1) {
                tmp = "";
            } else if (len < tmp.length()) {
                tmp = tmp.substring(0, len - 1);
            }
            res = res + tmp;
        }
        return res;
    }

    public String getFullString() {
        if (!this.isInited || !this.isValid()) {
            return null;
        }
        String res = "";
        Locale lc = SysContext.getSysContext().getLocale();
        String tmp = null;
        if (this.author != null) {
            if (lc != null) {
                tmp = this.author.getName(lc);
            }
            if (tmp == null) {
                tmp = this.author.getName();
            }
            if (tmp != null) {
                tmp = tmp.trim();
                res = res + tmp + ", ";
            }
        }
        if (this.date != null) {
            DateFormat df = DateFormat.getDateTimeInstance(1, 3, lc);
            if (df != null) {
                tmp = df.format(this.date);
            }
            if (tmp != null) {
                res = res + tmp + ", ";
            }
        }
        if (this.content != null) {
            tmp = this.content.trim();
            res = res + tmp;
        }
        return res;
    }

    public static Comparator getComparator(int compMode) {
        return new CmtComparator(compMode);
    }

    public String toString() {
        return this.getTipString(tipLength);
    }

    public boolean isFresh() {
        return this.status == 0 || this.status == 1;
    }

    public String getContent() {
        this.initialize();
        return this.content;
    }

    public String getDate() {
        this.initialize();
        return DateTimeUtils.format((Date)this.date, (String)"yyyy-MM-dd HH:mm:ss");
    }

    public String getUser() {
        this.initialize();
        return this.author == null ? null : this.author.getName();
    }

    public String getUpdateUser() {
        this.initialize();
        return this.updateUser == null ? null : this.updateUser.getName();
    }

    public String getCreatetime() {
        this.initialize();
        return DateTimeUtils.format((Date)this.createtime, (String)"yyyy-MM-dd HH:mm:ss");
    }

    public void setContent(String text) {
        this.initialize();
        String def = ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"rptcomment-default", (Locale)SysContext.getSysContext().getLocale());
        if (def.equals(text)) {
            return;
        }
        this.content = text;
        this.status = CommentConstants.getStatus(this.status, 3);
    }

    public void setDead() {
        this.status = CommentConstants.getStatus(this.status, 2);
    }

    public boolean isValid() {
        return this.status != 2;
    }

    public void setdate(Timestamp timestamp) {
        this.date = timestamp;
    }

    public void setUpdateUser(UserInfo updateUser) {
        this.updateUser = updateUser;
    }

    public void setNewly() {
        this.initialize();
        this.status = 0;
    }
}

